/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Website parameters for the S3 bucket.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsS3BucketWebsiteConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsS3BucketWebsiteConfiguration.Builder, AwsS3BucketWebsiteConfiguration> {
    private static final SdkField<String> ERROR_DOCUMENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ErrorDocument").getter(getter(AwsS3BucketWebsiteConfiguration::errorDocument))
            .setter(setter(Builder::errorDocument))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorDocument").build()).build();

    private static final SdkField<String> INDEX_DOCUMENT_SUFFIX_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IndexDocumentSuffix").getter(getter(AwsS3BucketWebsiteConfiguration::indexDocumentSuffix))
            .setter(setter(Builder::indexDocumentSuffix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IndexDocumentSuffix").build())
            .build();

    private static final SdkField<AwsS3BucketWebsiteConfigurationRedirectTo> REDIRECT_ALL_REQUESTS_TO_FIELD = SdkField
            .<AwsS3BucketWebsiteConfigurationRedirectTo> builder(MarshallingType.SDK_POJO).memberName("RedirectAllRequestsTo")
            .getter(getter(AwsS3BucketWebsiteConfiguration::redirectAllRequestsTo))
            .setter(setter(Builder::redirectAllRequestsTo)).constructor(AwsS3BucketWebsiteConfigurationRedirectTo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RedirectAllRequestsTo").build())
            .build();

    private static final SdkField<List<AwsS3BucketWebsiteConfigurationRoutingRule>> ROUTING_RULES_FIELD = SdkField
            .<List<AwsS3BucketWebsiteConfigurationRoutingRule>> builder(MarshallingType.LIST)
            .memberName("RoutingRules")
            .getter(getter(AwsS3BucketWebsiteConfiguration::routingRules))
            .setter(setter(Builder::routingRules))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoutingRules").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AwsS3BucketWebsiteConfigurationRoutingRule> builder(MarshallingType.SDK_POJO)
                                            .constructor(AwsS3BucketWebsiteConfigurationRoutingRule::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ERROR_DOCUMENT_FIELD,
            INDEX_DOCUMENT_SUFFIX_FIELD, REDIRECT_ALL_REQUESTS_TO_FIELD, ROUTING_RULES_FIELD));

    private static final long serialVersionUID = 1L;

    private final String errorDocument;

    private final String indexDocumentSuffix;

    private final AwsS3BucketWebsiteConfigurationRedirectTo redirectAllRequestsTo;

    private final List<AwsS3BucketWebsiteConfigurationRoutingRule> routingRules;

    private AwsS3BucketWebsiteConfiguration(BuilderImpl builder) {
        this.errorDocument = builder.errorDocument;
        this.indexDocumentSuffix = builder.indexDocumentSuffix;
        this.redirectAllRequestsTo = builder.redirectAllRequestsTo;
        this.routingRules = builder.routingRules;
    }

    /**
     * <p>
     * The name of the error document for the website.
     * </p>
     * 
     * @return The name of the error document for the website.
     */
    public final String errorDocument() {
        return errorDocument;
    }

    /**
     * <p>
     * The name of the index document for the website.
     * </p>
     * 
     * @return The name of the index document for the website.
     */
    public final String indexDocumentSuffix() {
        return indexDocumentSuffix;
    }

    /**
     * <p>
     * The redirect behavior for requests to the website.
     * </p>
     * 
     * @return The redirect behavior for requests to the website.
     */
    public final AwsS3BucketWebsiteConfigurationRedirectTo redirectAllRequestsTo() {
        return redirectAllRequestsTo;
    }

    /**
     * For responses, this returns true if the service returned a value for the RoutingRules property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasRoutingRules() {
        return routingRules != null && !(routingRules instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The rules for applying redirects for requests to the website.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRoutingRules} method.
     * </p>
     * 
     * @return The rules for applying redirects for requests to the website.
     */
    public final List<AwsS3BucketWebsiteConfigurationRoutingRule> routingRules() {
        return routingRules;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(errorDocument());
        hashCode = 31 * hashCode + Objects.hashCode(indexDocumentSuffix());
        hashCode = 31 * hashCode + Objects.hashCode(redirectAllRequestsTo());
        hashCode = 31 * hashCode + Objects.hashCode(hasRoutingRules() ? routingRules() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsS3BucketWebsiteConfiguration)) {
            return false;
        }
        AwsS3BucketWebsiteConfiguration other = (AwsS3BucketWebsiteConfiguration) obj;
        return Objects.equals(errorDocument(), other.errorDocument())
                && Objects.equals(indexDocumentSuffix(), other.indexDocumentSuffix())
                && Objects.equals(redirectAllRequestsTo(), other.redirectAllRequestsTo())
                && hasRoutingRules() == other.hasRoutingRules() && Objects.equals(routingRules(), other.routingRules());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsS3BucketWebsiteConfiguration").add("ErrorDocument", errorDocument())
                .add("IndexDocumentSuffix", indexDocumentSuffix()).add("RedirectAllRequestsTo", redirectAllRequestsTo())
                .add("RoutingRules", hasRoutingRules() ? routingRules() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ErrorDocument":
            return Optional.ofNullable(clazz.cast(errorDocument()));
        case "IndexDocumentSuffix":
            return Optional.ofNullable(clazz.cast(indexDocumentSuffix()));
        case "RedirectAllRequestsTo":
            return Optional.ofNullable(clazz.cast(redirectAllRequestsTo()));
        case "RoutingRules":
            return Optional.ofNullable(clazz.cast(routingRules()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsS3BucketWebsiteConfiguration, T> g) {
        return obj -> g.apply((AwsS3BucketWebsiteConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsS3BucketWebsiteConfiguration> {
        /**
         * <p>
         * The name of the error document for the website.
         * </p>
         * 
         * @param errorDocument
         *        The name of the error document for the website.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorDocument(String errorDocument);

        /**
         * <p>
         * The name of the index document for the website.
         * </p>
         * 
         * @param indexDocumentSuffix
         *        The name of the index document for the website.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder indexDocumentSuffix(String indexDocumentSuffix);

        /**
         * <p>
         * The redirect behavior for requests to the website.
         * </p>
         * 
         * @param redirectAllRequestsTo
         *        The redirect behavior for requests to the website.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder redirectAllRequestsTo(AwsS3BucketWebsiteConfigurationRedirectTo redirectAllRequestsTo);

        /**
         * <p>
         * The redirect behavior for requests to the website.
         * </p>
         * This is a convenience that creates an instance of the
         * {@link AwsS3BucketWebsiteConfigurationRedirectTo.Builder} avoiding the need to create one manually via
         * {@link AwsS3BucketWebsiteConfigurationRedirectTo#builder()}.
         *
         * When the {@link Consumer} completes, {@link AwsS3BucketWebsiteConfigurationRedirectTo.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #redirectAllRequestsTo(AwsS3BucketWebsiteConfigurationRedirectTo)}.
         * 
         * @param redirectAllRequestsTo
         *        a consumer that will call methods on {@link AwsS3BucketWebsiteConfigurationRedirectTo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #redirectAllRequestsTo(AwsS3BucketWebsiteConfigurationRedirectTo)
         */
        default Builder redirectAllRequestsTo(Consumer<AwsS3BucketWebsiteConfigurationRedirectTo.Builder> redirectAllRequestsTo) {
            return redirectAllRequestsTo(AwsS3BucketWebsiteConfigurationRedirectTo.builder().applyMutation(redirectAllRequestsTo)
                    .build());
        }

        /**
         * <p>
         * The rules for applying redirects for requests to the website.
         * </p>
         * 
         * @param routingRules
         *        The rules for applying redirects for requests to the website.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routingRules(Collection<AwsS3BucketWebsiteConfigurationRoutingRule> routingRules);

        /**
         * <p>
         * The rules for applying redirects for requests to the website.
         * </p>
         * 
         * @param routingRules
         *        The rules for applying redirects for requests to the website.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routingRules(AwsS3BucketWebsiteConfigurationRoutingRule... routingRules);

        /**
         * <p>
         * The rules for applying redirects for requests to the website.
         * </p>
         * This is a convenience that creates an instance of the {@link List
         * <AwsS3BucketWebsiteConfigurationRoutingRule>.Builder} avoiding the need to create one manually via
         * {@link List<AwsS3BucketWebsiteConfigurationRoutingRule>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AwsS3BucketWebsiteConfigurationRoutingRule>.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #routingRules(List<AwsS3BucketWebsiteConfigurationRoutingRule>)}.
         * 
         * @param routingRules
         *        a consumer that will call methods on {@link List<AwsS3BucketWebsiteConfigurationRoutingRule>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #routingRules(List<AwsS3BucketWebsiteConfigurationRoutingRule>)
         */
        Builder routingRules(Consumer<AwsS3BucketWebsiteConfigurationRoutingRule.Builder>... routingRules);
    }

    static final class BuilderImpl implements Builder {
        private String errorDocument;

        private String indexDocumentSuffix;

        private AwsS3BucketWebsiteConfigurationRedirectTo redirectAllRequestsTo;

        private List<AwsS3BucketWebsiteConfigurationRoutingRule> routingRules = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AwsS3BucketWebsiteConfiguration model) {
            errorDocument(model.errorDocument);
            indexDocumentSuffix(model.indexDocumentSuffix);
            redirectAllRequestsTo(model.redirectAllRequestsTo);
            routingRules(model.routingRules);
        }

        public final String getErrorDocument() {
            return errorDocument;
        }

        public final void setErrorDocument(String errorDocument) {
            this.errorDocument = errorDocument;
        }

        @Override
        @Transient
        public final Builder errorDocument(String errorDocument) {
            this.errorDocument = errorDocument;
            return this;
        }

        public final String getIndexDocumentSuffix() {
            return indexDocumentSuffix;
        }

        public final void setIndexDocumentSuffix(String indexDocumentSuffix) {
            this.indexDocumentSuffix = indexDocumentSuffix;
        }

        @Override
        @Transient
        public final Builder indexDocumentSuffix(String indexDocumentSuffix) {
            this.indexDocumentSuffix = indexDocumentSuffix;
            return this;
        }

        public final AwsS3BucketWebsiteConfigurationRedirectTo.Builder getRedirectAllRequestsTo() {
            return redirectAllRequestsTo != null ? redirectAllRequestsTo.toBuilder() : null;
        }

        public final void setRedirectAllRequestsTo(AwsS3BucketWebsiteConfigurationRedirectTo.BuilderImpl redirectAllRequestsTo) {
            this.redirectAllRequestsTo = redirectAllRequestsTo != null ? redirectAllRequestsTo.build() : null;
        }

        @Override
        @Transient
        public final Builder redirectAllRequestsTo(AwsS3BucketWebsiteConfigurationRedirectTo redirectAllRequestsTo) {
            this.redirectAllRequestsTo = redirectAllRequestsTo;
            return this;
        }

        public final List<AwsS3BucketWebsiteConfigurationRoutingRule.Builder> getRoutingRules() {
            List<AwsS3BucketWebsiteConfigurationRoutingRule.Builder> result = AwsS3BucketWebsiteConfigurationRoutingRulesCopier
                    .copyToBuilder(this.routingRules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRoutingRules(Collection<AwsS3BucketWebsiteConfigurationRoutingRule.BuilderImpl> routingRules) {
            this.routingRules = AwsS3BucketWebsiteConfigurationRoutingRulesCopier.copyFromBuilder(routingRules);
        }

        @Override
        @Transient
        public final Builder routingRules(Collection<AwsS3BucketWebsiteConfigurationRoutingRule> routingRules) {
            this.routingRules = AwsS3BucketWebsiteConfigurationRoutingRulesCopier.copy(routingRules);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder routingRules(AwsS3BucketWebsiteConfigurationRoutingRule... routingRules) {
            routingRules(Arrays.asList(routingRules));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder routingRules(Consumer<AwsS3BucketWebsiteConfigurationRoutingRule.Builder>... routingRules) {
            routingRules(Stream.of(routingRules)
                    .map(c -> AwsS3BucketWebsiteConfigurationRoutingRule.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public AwsS3BucketWebsiteConfiguration build() {
            return new AwsS3BucketWebsiteConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
