/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The redirect behavior for requests to the website.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsS3BucketWebsiteConfigurationRedirectTo implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsS3BucketWebsiteConfigurationRedirectTo.Builder, AwsS3BucketWebsiteConfigurationRedirectTo> {
    private static final SdkField<String> HOSTNAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Hostname").getter(getter(AwsS3BucketWebsiteConfigurationRedirectTo::hostname))
            .setter(setter(Builder::hostname))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Hostname").build()).build();

    private static final SdkField<String> PROTOCOL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Protocol").getter(getter(AwsS3BucketWebsiteConfigurationRedirectTo::protocol))
            .setter(setter(Builder::protocol))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Protocol").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(HOSTNAME_FIELD, PROTOCOL_FIELD));

    private static final long serialVersionUID = 1L;

    private final String hostname;

    private final String protocol;

    private AwsS3BucketWebsiteConfigurationRedirectTo(BuilderImpl builder) {
        this.hostname = builder.hostname;
        this.protocol = builder.protocol;
    }

    /**
     * <p>
     * The name of the host to redirect requests to.
     * </p>
     * 
     * @return The name of the host to redirect requests to.
     */
    public final String hostname() {
        return hostname;
    }

    /**
     * <p>
     * The protocol to use when redirecting requests. By default, uses the same protocol as the original request.
     * </p>
     * 
     * @return The protocol to use when redirecting requests. By default, uses the same protocol as the original
     *         request.
     */
    public final String protocol() {
        return protocol;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hostname());
        hashCode = 31 * hashCode + Objects.hashCode(protocol());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsS3BucketWebsiteConfigurationRedirectTo)) {
            return false;
        }
        AwsS3BucketWebsiteConfigurationRedirectTo other = (AwsS3BucketWebsiteConfigurationRedirectTo) obj;
        return Objects.equals(hostname(), other.hostname()) && Objects.equals(protocol(), other.protocol());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsS3BucketWebsiteConfigurationRedirectTo").add("Hostname", hostname())
                .add("Protocol", protocol()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Hostname":
            return Optional.ofNullable(clazz.cast(hostname()));
        case "Protocol":
            return Optional.ofNullable(clazz.cast(protocol()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsS3BucketWebsiteConfigurationRedirectTo, T> g) {
        return obj -> g.apply((AwsS3BucketWebsiteConfigurationRedirectTo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsS3BucketWebsiteConfigurationRedirectTo> {
        /**
         * <p>
         * The name of the host to redirect requests to.
         * </p>
         * 
         * @param hostname
         *        The name of the host to redirect requests to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostname(String hostname);

        /**
         * <p>
         * The protocol to use when redirecting requests. By default, uses the same protocol as the original request.
         * </p>
         * 
         * @param protocol
         *        The protocol to use when redirecting requests. By default, uses the same protocol as the original
         *        request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder protocol(String protocol);
    }

    static final class BuilderImpl implements Builder {
        private String hostname;

        private String protocol;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsS3BucketWebsiteConfigurationRedirectTo model) {
            hostname(model.hostname);
            protocol(model.protocol);
        }

        public final String getHostname() {
            return hostname;
        }

        public final void setHostname(String hostname) {
            this.hostname = hostname;
        }

        @Override
        @Transient
        public final Builder hostname(String hostname) {
            this.hostname = hostname;
            return this;
        }

        public final String getProtocol() {
            return protocol;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        @Override
        @Transient
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        @Override
        public AwsS3BucketWebsiteConfigurationRedirectTo build() {
            return new AwsS3BucketWebsiteConfigurationRedirectTo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
