/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The condition that must be met in order to apply the routing rule.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsS3BucketWebsiteConfigurationRoutingRuleCondition
        implements
        SdkPojo,
        Serializable,
        ToCopyableBuilder<AwsS3BucketWebsiteConfigurationRoutingRuleCondition.Builder, AwsS3BucketWebsiteConfigurationRoutingRuleCondition> {
    private static final SdkField<String> HTTP_ERROR_CODE_RETURNED_EQUALS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("HttpErrorCodeReturnedEquals")
            .getter(getter(AwsS3BucketWebsiteConfigurationRoutingRuleCondition::httpErrorCodeReturnedEquals))
            .setter(setter(Builder::httpErrorCodeReturnedEquals))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HttpErrorCodeReturnedEquals")
                    .build()).build();

    private static final SdkField<String> KEY_PREFIX_EQUALS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KeyPrefixEquals").getter(getter(AwsS3BucketWebsiteConfigurationRoutingRuleCondition::keyPrefixEquals))
            .setter(setter(Builder::keyPrefixEquals))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyPrefixEquals").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            HTTP_ERROR_CODE_RETURNED_EQUALS_FIELD, KEY_PREFIX_EQUALS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String httpErrorCodeReturnedEquals;

    private final String keyPrefixEquals;

    private AwsS3BucketWebsiteConfigurationRoutingRuleCondition(BuilderImpl builder) {
        this.httpErrorCodeReturnedEquals = builder.httpErrorCodeReturnedEquals;
        this.keyPrefixEquals = builder.keyPrefixEquals;
    }

    /**
     * <p>
     * Indicates to redirect the request if the HTTP error code matches this value.
     * </p>
     * 
     * @return Indicates to redirect the request if the HTTP error code matches this value.
     */
    public final String httpErrorCodeReturnedEquals() {
        return httpErrorCodeReturnedEquals;
    }

    /**
     * <p>
     * Indicates to redirect the request if the key prefix matches this value.
     * </p>
     * 
     * @return Indicates to redirect the request if the key prefix matches this value.
     */
    public final String keyPrefixEquals() {
        return keyPrefixEquals;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(httpErrorCodeReturnedEquals());
        hashCode = 31 * hashCode + Objects.hashCode(keyPrefixEquals());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsS3BucketWebsiteConfigurationRoutingRuleCondition)) {
            return false;
        }
        AwsS3BucketWebsiteConfigurationRoutingRuleCondition other = (AwsS3BucketWebsiteConfigurationRoutingRuleCondition) obj;
        return Objects.equals(httpErrorCodeReturnedEquals(), other.httpErrorCodeReturnedEquals())
                && Objects.equals(keyPrefixEquals(), other.keyPrefixEquals());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsS3BucketWebsiteConfigurationRoutingRuleCondition")
                .add("HttpErrorCodeReturnedEquals", httpErrorCodeReturnedEquals()).add("KeyPrefixEquals", keyPrefixEquals())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "HttpErrorCodeReturnedEquals":
            return Optional.ofNullable(clazz.cast(httpErrorCodeReturnedEquals()));
        case "KeyPrefixEquals":
            return Optional.ofNullable(clazz.cast(keyPrefixEquals()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsS3BucketWebsiteConfigurationRoutingRuleCondition, T> g) {
        return obj -> g.apply((AwsS3BucketWebsiteConfigurationRoutingRuleCondition) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsS3BucketWebsiteConfigurationRoutingRuleCondition> {
        /**
         * <p>
         * Indicates to redirect the request if the HTTP error code matches this value.
         * </p>
         * 
         * @param httpErrorCodeReturnedEquals
         *        Indicates to redirect the request if the HTTP error code matches this value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder httpErrorCodeReturnedEquals(String httpErrorCodeReturnedEquals);

        /**
         * <p>
         * Indicates to redirect the request if the key prefix matches this value.
         * </p>
         * 
         * @param keyPrefixEquals
         *        Indicates to redirect the request if the key prefix matches this value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyPrefixEquals(String keyPrefixEquals);
    }

    static final class BuilderImpl implements Builder {
        private String httpErrorCodeReturnedEquals;

        private String keyPrefixEquals;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsS3BucketWebsiteConfigurationRoutingRuleCondition model) {
            httpErrorCodeReturnedEquals(model.httpErrorCodeReturnedEquals);
            keyPrefixEquals(model.keyPrefixEquals);
        }

        public final String getHttpErrorCodeReturnedEquals() {
            return httpErrorCodeReturnedEquals;
        }

        public final void setHttpErrorCodeReturnedEquals(String httpErrorCodeReturnedEquals) {
            this.httpErrorCodeReturnedEquals = httpErrorCodeReturnedEquals;
        }

        @Override
        @Transient
        public final Builder httpErrorCodeReturnedEquals(String httpErrorCodeReturnedEquals) {
            this.httpErrorCodeReturnedEquals = httpErrorCodeReturnedEquals;
            return this;
        }

        public final String getKeyPrefixEquals() {
            return keyPrefixEquals;
        }

        public final void setKeyPrefixEquals(String keyPrefixEquals) {
            this.keyPrefixEquals = keyPrefixEquals;
        }

        @Override
        @Transient
        public final Builder keyPrefixEquals(String keyPrefixEquals) {
            this.keyPrefixEquals = keyPrefixEquals;
            return this;
        }

        @Override
        public AwsS3BucketWebsiteConfigurationRoutingRuleCondition build() {
            return new AwsS3BucketWebsiteConfigurationRoutingRuleCondition(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
