/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides the details about the compliance status for a patch.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsSsmComplianceSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsSsmComplianceSummary.Builder, AwsSsmComplianceSummary> {
    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(AwsSsmComplianceSummary::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<Integer> COMPLIANT_CRITICAL_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("CompliantCriticalCount").getter(getter(AwsSsmComplianceSummary::compliantCriticalCount))
            .setter(setter(Builder::compliantCriticalCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompliantCriticalCount").build())
            .build();

    private static final SdkField<Integer> COMPLIANT_HIGH_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("CompliantHighCount").getter(getter(AwsSsmComplianceSummary::compliantHighCount))
            .setter(setter(Builder::compliantHighCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompliantHighCount").build())
            .build();

    private static final SdkField<Integer> COMPLIANT_MEDIUM_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("CompliantMediumCount").getter(getter(AwsSsmComplianceSummary::compliantMediumCount))
            .setter(setter(Builder::compliantMediumCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompliantMediumCount").build())
            .build();

    private static final SdkField<String> EXECUTION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ExecutionType").getter(getter(AwsSsmComplianceSummary::executionType))
            .setter(setter(Builder::executionType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionType").build()).build();

    private static final SdkField<Integer> NON_COMPLIANT_CRITICAL_COUNT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER).memberName("NonCompliantCriticalCount")
            .getter(getter(AwsSsmComplianceSummary::nonCompliantCriticalCount))
            .setter(setter(Builder::nonCompliantCriticalCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NonCompliantCriticalCount").build())
            .build();

    private static final SdkField<Integer> COMPLIANT_INFORMATIONAL_COUNT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("CompliantInformationalCount")
            .getter(getter(AwsSsmComplianceSummary::compliantInformationalCount))
            .setter(setter(Builder::compliantInformationalCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompliantInformationalCount")
                    .build()).build();

    private static final SdkField<Integer> NON_COMPLIANT_INFORMATIONAL_COUNT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("NonCompliantInformationalCount")
            .getter(getter(AwsSsmComplianceSummary::nonCompliantInformationalCount))
            .setter(setter(Builder::nonCompliantInformationalCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NonCompliantInformationalCount")
                    .build()).build();

    private static final SdkField<Integer> COMPLIANT_UNSPECIFIED_COUNT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER).memberName("CompliantUnspecifiedCount")
            .getter(getter(AwsSsmComplianceSummary::compliantUnspecifiedCount))
            .setter(setter(Builder::compliantUnspecifiedCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompliantUnspecifiedCount").build())
            .build();

    private static final SdkField<Integer> NON_COMPLIANT_LOW_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("NonCompliantLowCount").getter(getter(AwsSsmComplianceSummary::nonCompliantLowCount))
            .setter(setter(Builder::nonCompliantLowCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NonCompliantLowCount").build())
            .build();

    private static final SdkField<Integer> NON_COMPLIANT_HIGH_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("NonCompliantHighCount").getter(getter(AwsSsmComplianceSummary::nonCompliantHighCount))
            .setter(setter(Builder::nonCompliantHighCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NonCompliantHighCount").build())
            .build();

    private static final SdkField<Integer> COMPLIANT_LOW_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("CompliantLowCount").getter(getter(AwsSsmComplianceSummary::compliantLowCount))
            .setter(setter(Builder::compliantLowCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompliantLowCount").build()).build();

    private static final SdkField<String> COMPLIANCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ComplianceType").getter(getter(AwsSsmComplianceSummary::complianceType))
            .setter(setter(Builder::complianceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComplianceType").build()).build();

    private static final SdkField<String> PATCH_BASELINE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PatchBaselineId").getter(getter(AwsSsmComplianceSummary::patchBaselineId))
            .setter(setter(Builder::patchBaselineId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PatchBaselineId").build()).build();

    private static final SdkField<String> OVERALL_SEVERITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OverallSeverity").getter(getter(AwsSsmComplianceSummary::overallSeverity))
            .setter(setter(Builder::overallSeverity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OverallSeverity").build()).build();

    private static final SdkField<Integer> NON_COMPLIANT_MEDIUM_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("NonCompliantMediumCount").getter(getter(AwsSsmComplianceSummary::nonCompliantMediumCount))
            .setter(setter(Builder::nonCompliantMediumCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NonCompliantMediumCount").build())
            .build();

    private static final SdkField<Integer> NON_COMPLIANT_UNSPECIFIED_COUNT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("NonCompliantUnspecifiedCount")
            .getter(getter(AwsSsmComplianceSummary::nonCompliantUnspecifiedCount))
            .setter(setter(Builder::nonCompliantUnspecifiedCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NonCompliantUnspecifiedCount")
                    .build()).build();

    private static final SdkField<String> PATCH_GROUP_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PatchGroup").getter(getter(AwsSsmComplianceSummary::patchGroup)).setter(setter(Builder::patchGroup))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PatchGroup").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD,
            COMPLIANT_CRITICAL_COUNT_FIELD, COMPLIANT_HIGH_COUNT_FIELD, COMPLIANT_MEDIUM_COUNT_FIELD, EXECUTION_TYPE_FIELD,
            NON_COMPLIANT_CRITICAL_COUNT_FIELD, COMPLIANT_INFORMATIONAL_COUNT_FIELD, NON_COMPLIANT_INFORMATIONAL_COUNT_FIELD,
            COMPLIANT_UNSPECIFIED_COUNT_FIELD, NON_COMPLIANT_LOW_COUNT_FIELD, NON_COMPLIANT_HIGH_COUNT_FIELD,
            COMPLIANT_LOW_COUNT_FIELD, COMPLIANCE_TYPE_FIELD, PATCH_BASELINE_ID_FIELD, OVERALL_SEVERITY_FIELD,
            NON_COMPLIANT_MEDIUM_COUNT_FIELD, NON_COMPLIANT_UNSPECIFIED_COUNT_FIELD, PATCH_GROUP_FIELD));

    private static final long serialVersionUID = 1L;

    private final String status;

    private final Integer compliantCriticalCount;

    private final Integer compliantHighCount;

    private final Integer compliantMediumCount;

    private final String executionType;

    private final Integer nonCompliantCriticalCount;

    private final Integer compliantInformationalCount;

    private final Integer nonCompliantInformationalCount;

    private final Integer compliantUnspecifiedCount;

    private final Integer nonCompliantLowCount;

    private final Integer nonCompliantHighCount;

    private final Integer compliantLowCount;

    private final String complianceType;

    private final String patchBaselineId;

    private final String overallSeverity;

    private final Integer nonCompliantMediumCount;

    private final Integer nonCompliantUnspecifiedCount;

    private final String patchGroup;

    private AwsSsmComplianceSummary(BuilderImpl builder) {
        this.status = builder.status;
        this.compliantCriticalCount = builder.compliantCriticalCount;
        this.compliantHighCount = builder.compliantHighCount;
        this.compliantMediumCount = builder.compliantMediumCount;
        this.executionType = builder.executionType;
        this.nonCompliantCriticalCount = builder.nonCompliantCriticalCount;
        this.compliantInformationalCount = builder.compliantInformationalCount;
        this.nonCompliantInformationalCount = builder.nonCompliantInformationalCount;
        this.compliantUnspecifiedCount = builder.compliantUnspecifiedCount;
        this.nonCompliantLowCount = builder.nonCompliantLowCount;
        this.nonCompliantHighCount = builder.nonCompliantHighCount;
        this.compliantLowCount = builder.compliantLowCount;
        this.complianceType = builder.complianceType;
        this.patchBaselineId = builder.patchBaselineId;
        this.overallSeverity = builder.overallSeverity;
        this.nonCompliantMediumCount = builder.nonCompliantMediumCount;
        this.nonCompliantUnspecifiedCount = builder.nonCompliantUnspecifiedCount;
        this.patchGroup = builder.patchGroup;
    }

    /**
     * <p>
     * The current patch compliance status.
     * </p>
     * <p>
     * The possible status values are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>COMPLIANT</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NON_COMPLIANT</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UNSPECIFIED_DATA</code>
     * </p>
     * </li>
     * </ul>
     * 
     * @return The current patch compliance status.</p>
     *         <p>
     *         The possible status values are:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>COMPLIANT</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NON_COMPLIANT</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>UNSPECIFIED_DATA</code>
     *         </p>
     *         </li>
     */
    public final String status() {
        return status;
    }

    /**
     * <p>
     * For the patches that are compliant, the number that have a severity of <code>CRITICAL</code>.
     * </p>
     * 
     * @return For the patches that are compliant, the number that have a severity of <code>CRITICAL</code>.
     */
    public final Integer compliantCriticalCount() {
        return compliantCriticalCount;
    }

    /**
     * <p>
     * For the patches that are compliant, the number that have a severity of <code>HIGH</code>.
     * </p>
     * 
     * @return For the patches that are compliant, the number that have a severity of <code>HIGH</code>.
     */
    public final Integer compliantHighCount() {
        return compliantHighCount;
    }

    /**
     * <p>
     * For the patches that are compliant, the number that have a severity of <code>MEDIUM</code>.
     * </p>
     * 
     * @return For the patches that are compliant, the number that have a severity of <code>MEDIUM</code>.
     */
    public final Integer compliantMediumCount() {
        return compliantMediumCount;
    }

    /**
     * <p>
     * The type of execution that was used determine compliance.
     * </p>
     * 
     * @return The type of execution that was used determine compliance.
     */
    public final String executionType() {
        return executionType;
    }

    /**
     * <p>
     * For the patch items that are noncompliant, the number of items that have a severity of <code>CRITICAL</code>.
     * </p>
     * 
     * @return For the patch items that are noncompliant, the number of items that have a severity of
     *         <code>CRITICAL</code>.
     */
    public final Integer nonCompliantCriticalCount() {
        return nonCompliantCriticalCount;
    }

    /**
     * <p>
     * For the patches that are compliant, the number that have a severity of <code>INFORMATIONAL</code>.
     * </p>
     * 
     * @return For the patches that are compliant, the number that have a severity of <code>INFORMATIONAL</code>.
     */
    public final Integer compliantInformationalCount() {
        return compliantInformationalCount;
    }

    /**
     * <p>
     * For the patches that are noncompliant, the number that have a severity of <code>INFORMATIONAL</code>.
     * </p>
     * 
     * @return For the patches that are noncompliant, the number that have a severity of <code>INFORMATIONAL</code>.
     */
    public final Integer nonCompliantInformationalCount() {
        return nonCompliantInformationalCount;
    }

    /**
     * <p>
     * For the patches that are compliant, the number that have a severity of <code>UNSPECIFIED</code>.
     * </p>
     * 
     * @return For the patches that are compliant, the number that have a severity of <code>UNSPECIFIED</code>.
     */
    public final Integer compliantUnspecifiedCount() {
        return compliantUnspecifiedCount;
    }

    /**
     * <p>
     * For the patches that are noncompliant, the number that have a severity of <code>LOW</code>.
     * </p>
     * 
     * @return For the patches that are noncompliant, the number that have a severity of <code>LOW</code>.
     */
    public final Integer nonCompliantLowCount() {
        return nonCompliantLowCount;
    }

    /**
     * <p>
     * For the patches that are noncompliant, the number that have a severity of <code>HIGH</code>.
     * </p>
     * 
     * @return For the patches that are noncompliant, the number that have a severity of <code>HIGH</code>.
     */
    public final Integer nonCompliantHighCount() {
        return nonCompliantHighCount;
    }

    /**
     * <p>
     * For the patches that are compliant, the number that have a severity of <code>LOW</code>.
     * </p>
     * 
     * @return For the patches that are compliant, the number that have a severity of <code>LOW</code>.
     */
    public final Integer compliantLowCount() {
        return compliantLowCount;
    }

    /**
     * <p>
     * The type of resource for which the compliance was determined. For <code>AwsSsmPatchCompliance</code>,
     * <code>ComplianceType</code> is <code>Patch</code>.
     * </p>
     * 
     * @return The type of resource for which the compliance was determined. For <code>AwsSsmPatchCompliance</code>,
     *         <code>ComplianceType</code> is <code>Patch</code>.
     */
    public final String complianceType() {
        return complianceType;
    }

    /**
     * <p>
     * The identifier of the patch baseline. The patch baseline lists the patches that are approved for installation.
     * </p>
     * 
     * @return The identifier of the patch baseline. The patch baseline lists the patches that are approved for
     *         installation.
     */
    public final String patchBaselineId() {
        return patchBaselineId;
    }

    /**
     * <p>
     * The highest severity for the patches.
     * </p>
     * 
     * @return The highest severity for the patches.
     */
    public final String overallSeverity() {
        return overallSeverity;
    }

    /**
     * <p>
     * For the patches that are noncompliant, the number that have a severity of <code>MEDIUM</code>.
     * </p>
     * 
     * @return For the patches that are noncompliant, the number that have a severity of <code>MEDIUM</code>.
     */
    public final Integer nonCompliantMediumCount() {
        return nonCompliantMediumCount;
    }

    /**
     * <p>
     * For the patches that are noncompliant, the number that have a severity of <code>UNSPECIFIED</code>.
     * </p>
     * 
     * @return For the patches that are noncompliant, the number that have a severity of <code>UNSPECIFIED</code>.
     */
    public final Integer nonCompliantUnspecifiedCount() {
        return nonCompliantUnspecifiedCount;
    }

    /**
     * <p>
     * The identifier of the patch group for which compliance was determined. A patch group uses tags to group EC2
     * instances that should have the same patch compliance.
     * </p>
     * 
     * @return The identifier of the patch group for which compliance was determined. A patch group uses tags to group
     *         EC2 instances that should have the same patch compliance.
     */
    public final String patchGroup() {
        return patchGroup;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(compliantCriticalCount());
        hashCode = 31 * hashCode + Objects.hashCode(compliantHighCount());
        hashCode = 31 * hashCode + Objects.hashCode(compliantMediumCount());
        hashCode = 31 * hashCode + Objects.hashCode(executionType());
        hashCode = 31 * hashCode + Objects.hashCode(nonCompliantCriticalCount());
        hashCode = 31 * hashCode + Objects.hashCode(compliantInformationalCount());
        hashCode = 31 * hashCode + Objects.hashCode(nonCompliantInformationalCount());
        hashCode = 31 * hashCode + Objects.hashCode(compliantUnspecifiedCount());
        hashCode = 31 * hashCode + Objects.hashCode(nonCompliantLowCount());
        hashCode = 31 * hashCode + Objects.hashCode(nonCompliantHighCount());
        hashCode = 31 * hashCode + Objects.hashCode(compliantLowCount());
        hashCode = 31 * hashCode + Objects.hashCode(complianceType());
        hashCode = 31 * hashCode + Objects.hashCode(patchBaselineId());
        hashCode = 31 * hashCode + Objects.hashCode(overallSeverity());
        hashCode = 31 * hashCode + Objects.hashCode(nonCompliantMediumCount());
        hashCode = 31 * hashCode + Objects.hashCode(nonCompliantUnspecifiedCount());
        hashCode = 31 * hashCode + Objects.hashCode(patchGroup());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsSsmComplianceSummary)) {
            return false;
        }
        AwsSsmComplianceSummary other = (AwsSsmComplianceSummary) obj;
        return Objects.equals(status(), other.status())
                && Objects.equals(compliantCriticalCount(), other.compliantCriticalCount())
                && Objects.equals(compliantHighCount(), other.compliantHighCount())
                && Objects.equals(compliantMediumCount(), other.compliantMediumCount())
                && Objects.equals(executionType(), other.executionType())
                && Objects.equals(nonCompliantCriticalCount(), other.nonCompliantCriticalCount())
                && Objects.equals(compliantInformationalCount(), other.compliantInformationalCount())
                && Objects.equals(nonCompliantInformationalCount(), other.nonCompliantInformationalCount())
                && Objects.equals(compliantUnspecifiedCount(), other.compliantUnspecifiedCount())
                && Objects.equals(nonCompliantLowCount(), other.nonCompliantLowCount())
                && Objects.equals(nonCompliantHighCount(), other.nonCompliantHighCount())
                && Objects.equals(compliantLowCount(), other.compliantLowCount())
                && Objects.equals(complianceType(), other.complianceType())
                && Objects.equals(patchBaselineId(), other.patchBaselineId())
                && Objects.equals(overallSeverity(), other.overallSeverity())
                && Objects.equals(nonCompliantMediumCount(), other.nonCompliantMediumCount())
                && Objects.equals(nonCompliantUnspecifiedCount(), other.nonCompliantUnspecifiedCount())
                && Objects.equals(patchGroup(), other.patchGroup());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsSsmComplianceSummary").add("Status", status())
                .add("CompliantCriticalCount", compliantCriticalCount()).add("CompliantHighCount", compliantHighCount())
                .add("CompliantMediumCount", compliantMediumCount()).add("ExecutionType", executionType())
                .add("NonCompliantCriticalCount", nonCompliantCriticalCount())
                .add("CompliantInformationalCount", compliantInformationalCount())
                .add("NonCompliantInformationalCount", nonCompliantInformationalCount())
                .add("CompliantUnspecifiedCount", compliantUnspecifiedCount())
                .add("NonCompliantLowCount", nonCompliantLowCount()).add("NonCompliantHighCount", nonCompliantHighCount())
                .add("CompliantLowCount", compliantLowCount()).add("ComplianceType", complianceType())
                .add("PatchBaselineId", patchBaselineId()).add("OverallSeverity", overallSeverity())
                .add("NonCompliantMediumCount", nonCompliantMediumCount())
                .add("NonCompliantUnspecifiedCount", nonCompliantUnspecifiedCount()).add("PatchGroup", patchGroup()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        case "CompliantCriticalCount":
            return Optional.ofNullable(clazz.cast(compliantCriticalCount()));
        case "CompliantHighCount":
            return Optional.ofNullable(clazz.cast(compliantHighCount()));
        case "CompliantMediumCount":
            return Optional.ofNullable(clazz.cast(compliantMediumCount()));
        case "ExecutionType":
            return Optional.ofNullable(clazz.cast(executionType()));
        case "NonCompliantCriticalCount":
            return Optional.ofNullable(clazz.cast(nonCompliantCriticalCount()));
        case "CompliantInformationalCount":
            return Optional.ofNullable(clazz.cast(compliantInformationalCount()));
        case "NonCompliantInformationalCount":
            return Optional.ofNullable(clazz.cast(nonCompliantInformationalCount()));
        case "CompliantUnspecifiedCount":
            return Optional.ofNullable(clazz.cast(compliantUnspecifiedCount()));
        case "NonCompliantLowCount":
            return Optional.ofNullable(clazz.cast(nonCompliantLowCount()));
        case "NonCompliantHighCount":
            return Optional.ofNullable(clazz.cast(nonCompliantHighCount()));
        case "CompliantLowCount":
            return Optional.ofNullable(clazz.cast(compliantLowCount()));
        case "ComplianceType":
            return Optional.ofNullable(clazz.cast(complianceType()));
        case "PatchBaselineId":
            return Optional.ofNullable(clazz.cast(patchBaselineId()));
        case "OverallSeverity":
            return Optional.ofNullable(clazz.cast(overallSeverity()));
        case "NonCompliantMediumCount":
            return Optional.ofNullable(clazz.cast(nonCompliantMediumCount()));
        case "NonCompliantUnspecifiedCount":
            return Optional.ofNullable(clazz.cast(nonCompliantUnspecifiedCount()));
        case "PatchGroup":
            return Optional.ofNullable(clazz.cast(patchGroup()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsSsmComplianceSummary, T> g) {
        return obj -> g.apply((AwsSsmComplianceSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsSsmComplianceSummary> {
        /**
         * <p>
         * The current patch compliance status.
         * </p>
         * <p>
         * The possible status values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>COMPLIANT</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NON_COMPLIANT</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>UNSPECIFIED_DATA</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The current patch compliance status.</p>
         *        <p>
         *        The possible status values are:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>COMPLIANT</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NON_COMPLIANT</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>UNSPECIFIED_DATA</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * For the patches that are compliant, the number that have a severity of <code>CRITICAL</code>.
         * </p>
         * 
         * @param compliantCriticalCount
         *        For the patches that are compliant, the number that have a severity of <code>CRITICAL</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder compliantCriticalCount(Integer compliantCriticalCount);

        /**
         * <p>
         * For the patches that are compliant, the number that have a severity of <code>HIGH</code>.
         * </p>
         * 
         * @param compliantHighCount
         *        For the patches that are compliant, the number that have a severity of <code>HIGH</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder compliantHighCount(Integer compliantHighCount);

        /**
         * <p>
         * For the patches that are compliant, the number that have a severity of <code>MEDIUM</code>.
         * </p>
         * 
         * @param compliantMediumCount
         *        For the patches that are compliant, the number that have a severity of <code>MEDIUM</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder compliantMediumCount(Integer compliantMediumCount);

        /**
         * <p>
         * The type of execution that was used determine compliance.
         * </p>
         * 
         * @param executionType
         *        The type of execution that was used determine compliance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionType(String executionType);

        /**
         * <p>
         * For the patch items that are noncompliant, the number of items that have a severity of <code>CRITICAL</code>.
         * </p>
         * 
         * @param nonCompliantCriticalCount
         *        For the patch items that are noncompliant, the number of items that have a severity of
         *        <code>CRITICAL</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nonCompliantCriticalCount(Integer nonCompliantCriticalCount);

        /**
         * <p>
         * For the patches that are compliant, the number that have a severity of <code>INFORMATIONAL</code>.
         * </p>
         * 
         * @param compliantInformationalCount
         *        For the patches that are compliant, the number that have a severity of <code>INFORMATIONAL</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder compliantInformationalCount(Integer compliantInformationalCount);

        /**
         * <p>
         * For the patches that are noncompliant, the number that have a severity of <code>INFORMATIONAL</code>.
         * </p>
         * 
         * @param nonCompliantInformationalCount
         *        For the patches that are noncompliant, the number that have a severity of <code>INFORMATIONAL</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nonCompliantInformationalCount(Integer nonCompliantInformationalCount);

        /**
         * <p>
         * For the patches that are compliant, the number that have a severity of <code>UNSPECIFIED</code>.
         * </p>
         * 
         * @param compliantUnspecifiedCount
         *        For the patches that are compliant, the number that have a severity of <code>UNSPECIFIED</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder compliantUnspecifiedCount(Integer compliantUnspecifiedCount);

        /**
         * <p>
         * For the patches that are noncompliant, the number that have a severity of <code>LOW</code>.
         * </p>
         * 
         * @param nonCompliantLowCount
         *        For the patches that are noncompliant, the number that have a severity of <code>LOW</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nonCompliantLowCount(Integer nonCompliantLowCount);

        /**
         * <p>
         * For the patches that are noncompliant, the number that have a severity of <code>HIGH</code>.
         * </p>
         * 
         * @param nonCompliantHighCount
         *        For the patches that are noncompliant, the number that have a severity of <code>HIGH</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nonCompliantHighCount(Integer nonCompliantHighCount);

        /**
         * <p>
         * For the patches that are compliant, the number that have a severity of <code>LOW</code>.
         * </p>
         * 
         * @param compliantLowCount
         *        For the patches that are compliant, the number that have a severity of <code>LOW</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder compliantLowCount(Integer compliantLowCount);

        /**
         * <p>
         * The type of resource for which the compliance was determined. For <code>AwsSsmPatchCompliance</code>,
         * <code>ComplianceType</code> is <code>Patch</code>.
         * </p>
         * 
         * @param complianceType
         *        The type of resource for which the compliance was determined. For <code>AwsSsmPatchCompliance</code>,
         *        <code>ComplianceType</code> is <code>Patch</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder complianceType(String complianceType);

        /**
         * <p>
         * The identifier of the patch baseline. The patch baseline lists the patches that are approved for
         * installation.
         * </p>
         * 
         * @param patchBaselineId
         *        The identifier of the patch baseline. The patch baseline lists the patches that are approved for
         *        installation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder patchBaselineId(String patchBaselineId);

        /**
         * <p>
         * The highest severity for the patches.
         * </p>
         * 
         * @param overallSeverity
         *        The highest severity for the patches.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder overallSeverity(String overallSeverity);

        /**
         * <p>
         * For the patches that are noncompliant, the number that have a severity of <code>MEDIUM</code>.
         * </p>
         * 
         * @param nonCompliantMediumCount
         *        For the patches that are noncompliant, the number that have a severity of <code>MEDIUM</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nonCompliantMediumCount(Integer nonCompliantMediumCount);

        /**
         * <p>
         * For the patches that are noncompliant, the number that have a severity of <code>UNSPECIFIED</code>.
         * </p>
         * 
         * @param nonCompliantUnspecifiedCount
         *        For the patches that are noncompliant, the number that have a severity of <code>UNSPECIFIED</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nonCompliantUnspecifiedCount(Integer nonCompliantUnspecifiedCount);

        /**
         * <p>
         * The identifier of the patch group for which compliance was determined. A patch group uses tags to group EC2
         * instances that should have the same patch compliance.
         * </p>
         * 
         * @param patchGroup
         *        The identifier of the patch group for which compliance was determined. A patch group uses tags to
         *        group EC2 instances that should have the same patch compliance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder patchGroup(String patchGroup);
    }

    static final class BuilderImpl implements Builder {
        private String status;

        private Integer compliantCriticalCount;

        private Integer compliantHighCount;

        private Integer compliantMediumCount;

        private String executionType;

        private Integer nonCompliantCriticalCount;

        private Integer compliantInformationalCount;

        private Integer nonCompliantInformationalCount;

        private Integer compliantUnspecifiedCount;

        private Integer nonCompliantLowCount;

        private Integer nonCompliantHighCount;

        private Integer compliantLowCount;

        private String complianceType;

        private String patchBaselineId;

        private String overallSeverity;

        private Integer nonCompliantMediumCount;

        private Integer nonCompliantUnspecifiedCount;

        private String patchGroup;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsSsmComplianceSummary model) {
            status(model.status);
            compliantCriticalCount(model.compliantCriticalCount);
            compliantHighCount(model.compliantHighCount);
            compliantMediumCount(model.compliantMediumCount);
            executionType(model.executionType);
            nonCompliantCriticalCount(model.nonCompliantCriticalCount);
            compliantInformationalCount(model.compliantInformationalCount);
            nonCompliantInformationalCount(model.nonCompliantInformationalCount);
            compliantUnspecifiedCount(model.compliantUnspecifiedCount);
            nonCompliantLowCount(model.nonCompliantLowCount);
            nonCompliantHighCount(model.nonCompliantHighCount);
            compliantLowCount(model.compliantLowCount);
            complianceType(model.complianceType);
            patchBaselineId(model.patchBaselineId);
            overallSeverity(model.overallSeverity);
            nonCompliantMediumCount(model.nonCompliantMediumCount);
            nonCompliantUnspecifiedCount(model.nonCompliantUnspecifiedCount);
            patchGroup(model.patchGroup);
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        @Transient
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final Integer getCompliantCriticalCount() {
            return compliantCriticalCount;
        }

        public final void setCompliantCriticalCount(Integer compliantCriticalCount) {
            this.compliantCriticalCount = compliantCriticalCount;
        }

        @Override
        @Transient
        public final Builder compliantCriticalCount(Integer compliantCriticalCount) {
            this.compliantCriticalCount = compliantCriticalCount;
            return this;
        }

        public final Integer getCompliantHighCount() {
            return compliantHighCount;
        }

        public final void setCompliantHighCount(Integer compliantHighCount) {
            this.compliantHighCount = compliantHighCount;
        }

        @Override
        @Transient
        public final Builder compliantHighCount(Integer compliantHighCount) {
            this.compliantHighCount = compliantHighCount;
            return this;
        }

        public final Integer getCompliantMediumCount() {
            return compliantMediumCount;
        }

        public final void setCompliantMediumCount(Integer compliantMediumCount) {
            this.compliantMediumCount = compliantMediumCount;
        }

        @Override
        @Transient
        public final Builder compliantMediumCount(Integer compliantMediumCount) {
            this.compliantMediumCount = compliantMediumCount;
            return this;
        }

        public final String getExecutionType() {
            return executionType;
        }

        public final void setExecutionType(String executionType) {
            this.executionType = executionType;
        }

        @Override
        @Transient
        public final Builder executionType(String executionType) {
            this.executionType = executionType;
            return this;
        }

        public final Integer getNonCompliantCriticalCount() {
            return nonCompliantCriticalCount;
        }

        public final void setNonCompliantCriticalCount(Integer nonCompliantCriticalCount) {
            this.nonCompliantCriticalCount = nonCompliantCriticalCount;
        }

        @Override
        @Transient
        public final Builder nonCompliantCriticalCount(Integer nonCompliantCriticalCount) {
            this.nonCompliantCriticalCount = nonCompliantCriticalCount;
            return this;
        }

        public final Integer getCompliantInformationalCount() {
            return compliantInformationalCount;
        }

        public final void setCompliantInformationalCount(Integer compliantInformationalCount) {
            this.compliantInformationalCount = compliantInformationalCount;
        }

        @Override
        @Transient
        public final Builder compliantInformationalCount(Integer compliantInformationalCount) {
            this.compliantInformationalCount = compliantInformationalCount;
            return this;
        }

        public final Integer getNonCompliantInformationalCount() {
            return nonCompliantInformationalCount;
        }

        public final void setNonCompliantInformationalCount(Integer nonCompliantInformationalCount) {
            this.nonCompliantInformationalCount = nonCompliantInformationalCount;
        }

        @Override
        @Transient
        public final Builder nonCompliantInformationalCount(Integer nonCompliantInformationalCount) {
            this.nonCompliantInformationalCount = nonCompliantInformationalCount;
            return this;
        }

        public final Integer getCompliantUnspecifiedCount() {
            return compliantUnspecifiedCount;
        }

        public final void setCompliantUnspecifiedCount(Integer compliantUnspecifiedCount) {
            this.compliantUnspecifiedCount = compliantUnspecifiedCount;
        }

        @Override
        @Transient
        public final Builder compliantUnspecifiedCount(Integer compliantUnspecifiedCount) {
            this.compliantUnspecifiedCount = compliantUnspecifiedCount;
            return this;
        }

        public final Integer getNonCompliantLowCount() {
            return nonCompliantLowCount;
        }

        public final void setNonCompliantLowCount(Integer nonCompliantLowCount) {
            this.nonCompliantLowCount = nonCompliantLowCount;
        }

        @Override
        @Transient
        public final Builder nonCompliantLowCount(Integer nonCompliantLowCount) {
            this.nonCompliantLowCount = nonCompliantLowCount;
            return this;
        }

        public final Integer getNonCompliantHighCount() {
            return nonCompliantHighCount;
        }

        public final void setNonCompliantHighCount(Integer nonCompliantHighCount) {
            this.nonCompliantHighCount = nonCompliantHighCount;
        }

        @Override
        @Transient
        public final Builder nonCompliantHighCount(Integer nonCompliantHighCount) {
            this.nonCompliantHighCount = nonCompliantHighCount;
            return this;
        }

        public final Integer getCompliantLowCount() {
            return compliantLowCount;
        }

        public final void setCompliantLowCount(Integer compliantLowCount) {
            this.compliantLowCount = compliantLowCount;
        }

        @Override
        @Transient
        public final Builder compliantLowCount(Integer compliantLowCount) {
            this.compliantLowCount = compliantLowCount;
            return this;
        }

        public final String getComplianceType() {
            return complianceType;
        }

        public final void setComplianceType(String complianceType) {
            this.complianceType = complianceType;
        }

        @Override
        @Transient
        public final Builder complianceType(String complianceType) {
            this.complianceType = complianceType;
            return this;
        }

        public final String getPatchBaselineId() {
            return patchBaselineId;
        }

        public final void setPatchBaselineId(String patchBaselineId) {
            this.patchBaselineId = patchBaselineId;
        }

        @Override
        @Transient
        public final Builder patchBaselineId(String patchBaselineId) {
            this.patchBaselineId = patchBaselineId;
            return this;
        }

        public final String getOverallSeverity() {
            return overallSeverity;
        }

        public final void setOverallSeverity(String overallSeverity) {
            this.overallSeverity = overallSeverity;
        }

        @Override
        @Transient
        public final Builder overallSeverity(String overallSeverity) {
            this.overallSeverity = overallSeverity;
            return this;
        }

        public final Integer getNonCompliantMediumCount() {
            return nonCompliantMediumCount;
        }

        public final void setNonCompliantMediumCount(Integer nonCompliantMediumCount) {
            this.nonCompliantMediumCount = nonCompliantMediumCount;
        }

        @Override
        @Transient
        public final Builder nonCompliantMediumCount(Integer nonCompliantMediumCount) {
            this.nonCompliantMediumCount = nonCompliantMediumCount;
            return this;
        }

        public final Integer getNonCompliantUnspecifiedCount() {
            return nonCompliantUnspecifiedCount;
        }

        public final void setNonCompliantUnspecifiedCount(Integer nonCompliantUnspecifiedCount) {
            this.nonCompliantUnspecifiedCount = nonCompliantUnspecifiedCount;
        }

        @Override
        @Transient
        public final Builder nonCompliantUnspecifiedCount(Integer nonCompliantUnspecifiedCount) {
            this.nonCompliantUnspecifiedCount = nonCompliantUnspecifiedCount;
            return this;
        }

        public final String getPatchGroup() {
            return patchGroup;
        }

        public final void setPatchGroup(String patchGroup) {
            this.patchGroup = patchGroup;
        }

        @Override
        @Transient
        public final Builder patchGroup(String patchGroup) {
            this.patchGroup = patchGroup;
            return this;
        }

        @Override
        public AwsSsmComplianceSummary build() {
            return new AwsSsmComplianceSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
