/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeStandardsResponse extends SecurityHubResponse implements
        ToCopyableBuilder<DescribeStandardsResponse.Builder, DescribeStandardsResponse> {
    private static final SdkField<List<Standard>> STANDARDS_FIELD = SdkField
            .<List<Standard>> builder(MarshallingType.LIST)
            .memberName("Standards")
            .getter(getter(DescribeStandardsResponse::standards))
            .setter(setter(Builder::standards))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Standards").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Standard> builder(MarshallingType.SDK_POJO)
                                            .constructor(Standard::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(DescribeStandardsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STANDARDS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<Standard> standards;

    private final String nextToken;

    private DescribeStandardsResponse(BuilderImpl builder) {
        super(builder);
        this.standards = builder.standards;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Standards property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasStandards() {
        return standards != null && !(standards instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of available standards.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStandards} method.
     * </p>
     * 
     * @return A list of available standards.
     */
    public final List<Standard> standards() {
        return standards;
    }

    /**
     * <p>
     * The pagination token to use to request the next page of results.
     * </p>
     * 
     * @return The pagination token to use to request the next page of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasStandards() ? standards() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeStandardsResponse)) {
            return false;
        }
        DescribeStandardsResponse other = (DescribeStandardsResponse) obj;
        return hasStandards() == other.hasStandards() && Objects.equals(standards(), other.standards())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeStandardsResponse").add("Standards", hasStandards() ? standards() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Standards":
            return Optional.ofNullable(clazz.cast(standards()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeStandardsResponse, T> g) {
        return obj -> g.apply((DescribeStandardsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SecurityHubResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeStandardsResponse> {
        /**
         * <p>
         * A list of available standards.
         * </p>
         * 
         * @param standards
         *        A list of available standards.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder standards(Collection<Standard> standards);

        /**
         * <p>
         * A list of available standards.
         * </p>
         * 
         * @param standards
         *        A list of available standards.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder standards(Standard... standards);

        /**
         * <p>
         * A list of available standards.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Standard>.Builder} avoiding the need to
         * create one manually via {@link List<Standard>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Standard>.Builder#build()} is called immediately and its
         * result is passed to {@link #standards(List<Standard>)}.
         * 
         * @param standards
         *        a consumer that will call methods on {@link List<Standard>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #standards(List<Standard>)
         */
        Builder standards(Consumer<Standard.Builder>... standards);

        /**
         * <p>
         * The pagination token to use to request the next page of results.
         * </p>
         * 
         * @param nextToken
         *        The pagination token to use to request the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends SecurityHubResponse.BuilderImpl implements Builder {
        private List<Standard> standards = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeStandardsResponse model) {
            super(model);
            standards(model.standards);
            nextToken(model.nextToken);
        }

        public final List<Standard.Builder> getStandards() {
            List<Standard.Builder> result = StandardsCopier.copyToBuilder(this.standards);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setStandards(Collection<Standard.BuilderImpl> standards) {
            this.standards = StandardsCopier.copyFromBuilder(standards);
        }

        @Override
        @Transient
        public final Builder standards(Collection<Standard> standards) {
            this.standards = StandardsCopier.copy(standards);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder standards(Standard... standards) {
            standards(Arrays.asList(standards));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder standards(Consumer<Standard.Builder>... standards) {
            standards(Stream.of(standards).map(c -> Standard.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeStandardsResponse build() {
            return new DescribeStandardsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
