/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provided if <code>ActionType</code> is <code>DNS_REQUEST</code>. It provides details about the DNS request that was
 * detected.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DnsRequestAction implements SdkPojo, Serializable,
        ToCopyableBuilder<DnsRequestAction.Builder, DnsRequestAction> {
    private static final SdkField<String> DOMAIN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Domain")
            .getter(getter(DnsRequestAction::domain)).setter(setter(Builder::domain))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Domain").build()).build();

    private static final SdkField<String> PROTOCOL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Protocol").getter(getter(DnsRequestAction::protocol)).setter(setter(Builder::protocol))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Protocol").build()).build();

    private static final SdkField<Boolean> BLOCKED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Blocked").getter(getter(DnsRequestAction::blocked)).setter(setter(Builder::blocked))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Blocked").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_FIELD, PROTOCOL_FIELD,
            BLOCKED_FIELD));

    private static final long serialVersionUID = 1L;

    private final String domain;

    private final String protocol;

    private final Boolean blocked;

    private DnsRequestAction(BuilderImpl builder) {
        this.domain = builder.domain;
        this.protocol = builder.protocol;
        this.blocked = builder.blocked;
    }

    /**
     * <p>
     * The DNS domain that is associated with the DNS request.
     * </p>
     * 
     * @return The DNS domain that is associated with the DNS request.
     */
    public final String domain() {
        return domain;
    }

    /**
     * <p>
     * The protocol that was used for the DNS request.
     * </p>
     * 
     * @return The protocol that was used for the DNS request.
     */
    public final String protocol() {
        return protocol;
    }

    /**
     * <p>
     * Indicates whether the DNS request was blocked.
     * </p>
     * 
     * @return Indicates whether the DNS request was blocked.
     */
    public final Boolean blocked() {
        return blocked;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(domain());
        hashCode = 31 * hashCode + Objects.hashCode(protocol());
        hashCode = 31 * hashCode + Objects.hashCode(blocked());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DnsRequestAction)) {
            return false;
        }
        DnsRequestAction other = (DnsRequestAction) obj;
        return Objects.equals(domain(), other.domain()) && Objects.equals(protocol(), other.protocol())
                && Objects.equals(blocked(), other.blocked());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DnsRequestAction").add("Domain", domain()).add("Protocol", protocol()).add("Blocked", blocked())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Domain":
            return Optional.ofNullable(clazz.cast(domain()));
        case "Protocol":
            return Optional.ofNullable(clazz.cast(protocol()));
        case "Blocked":
            return Optional.ofNullable(clazz.cast(blocked()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DnsRequestAction, T> g) {
        return obj -> g.apply((DnsRequestAction) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DnsRequestAction> {
        /**
         * <p>
         * The DNS domain that is associated with the DNS request.
         * </p>
         * 
         * @param domain
         *        The DNS domain that is associated with the DNS request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domain(String domain);

        /**
         * <p>
         * The protocol that was used for the DNS request.
         * </p>
         * 
         * @param protocol
         *        The protocol that was used for the DNS request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder protocol(String protocol);

        /**
         * <p>
         * Indicates whether the DNS request was blocked.
         * </p>
         * 
         * @param blocked
         *        Indicates whether the DNS request was blocked.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blocked(Boolean blocked);
    }

    static final class BuilderImpl implements Builder {
        private String domain;

        private String protocol;

        private Boolean blocked;

        private BuilderImpl() {
        }

        private BuilderImpl(DnsRequestAction model) {
            domain(model.domain);
            protocol(model.protocol);
            blocked(model.blocked);
        }

        public final String getDomain() {
            return domain;
        }

        public final void setDomain(String domain) {
            this.domain = domain;
        }

        @Override
        @Transient
        public final Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public final String getProtocol() {
            return protocol;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        @Override
        @Transient
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        public final Boolean getBlocked() {
            return blocked;
        }

        public final void setBlocked(Boolean blocked) {
            this.blocked = blocked;
        }

        @Override
        @Transient
        public final Builder blocked(Boolean blocked) {
            this.blocked = blocked;
            return this;
        }

        @Override
        public DnsRequestAction build() {
            return new DnsRequestAction(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
