/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides the latitude and longitude coordinates of a location.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GeoLocation implements SdkPojo, Serializable, ToCopyableBuilder<GeoLocation.Builder, GeoLocation> {
    private static final SdkField<Double> LON_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE).memberName("Lon")
            .getter(getter(GeoLocation::lon)).setter(setter(Builder::lon))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Lon").build()).build();

    private static final SdkField<Double> LAT_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE).memberName("Lat")
            .getter(getter(GeoLocation::lat)).setter(setter(Builder::lat))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Lat").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LON_FIELD, LAT_FIELD));

    private static final long serialVersionUID = 1L;

    private final Double lon;

    private final Double lat;

    private GeoLocation(BuilderImpl builder) {
        this.lon = builder.lon;
        this.lat = builder.lat;
    }

    /**
     * <p>
     * The longitude of the location.
     * </p>
     * 
     * @return The longitude of the location.
     */
    public final Double lon() {
        return lon;
    }

    /**
     * <p>
     * The latitude of the location.
     * </p>
     * 
     * @return The latitude of the location.
     */
    public final Double lat() {
        return lat;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(lon());
        hashCode = 31 * hashCode + Objects.hashCode(lat());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GeoLocation)) {
            return false;
        }
        GeoLocation other = (GeoLocation) obj;
        return Objects.equals(lon(), other.lon()) && Objects.equals(lat(), other.lat());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GeoLocation").add("Lon", lon()).add("Lat", lat()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Lon":
            return Optional.ofNullable(clazz.cast(lon()));
        case "Lat":
            return Optional.ofNullable(clazz.cast(lat()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GeoLocation, T> g) {
        return obj -> g.apply((GeoLocation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GeoLocation> {
        /**
         * <p>
         * The longitude of the location.
         * </p>
         * 
         * @param lon
         *        The longitude of the location.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lon(Double lon);

        /**
         * <p>
         * The latitude of the location.
         * </p>
         * 
         * @param lat
         *        The latitude of the location.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lat(Double lat);
    }

    static final class BuilderImpl implements Builder {
        private Double lon;

        private Double lat;

        private BuilderImpl() {
        }

        private BuilderImpl(GeoLocation model) {
            lon(model.lon);
            lat(model.lat);
        }

        public final Double getLon() {
            return lon;
        }

        public final void setLon(Double lon) {
            this.lon = lon;
        }

        @Override
        @Transient
        public final Builder lon(Double lon) {
            this.lon = lon;
            return this;
        }

        public final Double getLat() {
            return lat;
        }

        public final void setLat(Double lat) {
            this.lat = lat;
        }

        @Override
        @Transient
        public final Builder lat(Double lat) {
            this.lat = lat;
            return this;
        }

        @Override
        public GeoLocation build() {
            return new GeoLocation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
