/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An IPV6 CIDR block association.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Ipv6CidrBlockAssociation implements SdkPojo, Serializable,
        ToCopyableBuilder<Ipv6CidrBlockAssociation.Builder, Ipv6CidrBlockAssociation> {
    private static final SdkField<String> ASSOCIATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AssociationId").getter(getter(Ipv6CidrBlockAssociation::associationId))
            .setter(setter(Builder::associationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociationId").build()).build();

    private static final SdkField<String> IPV6_CIDR_BLOCK_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Ipv6CidrBlock").getter(getter(Ipv6CidrBlockAssociation::ipv6CidrBlock))
            .setter(setter(Builder::ipv6CidrBlock))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ipv6CidrBlock").build()).build();

    private static final SdkField<String> CIDR_BLOCK_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CidrBlockState").getter(getter(Ipv6CidrBlockAssociation::cidrBlockState))
            .setter(setter(Builder::cidrBlockState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CidrBlockState").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSOCIATION_ID_FIELD,
            IPV6_CIDR_BLOCK_FIELD, CIDR_BLOCK_STATE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String associationId;

    private final String ipv6CidrBlock;

    private final String cidrBlockState;

    private Ipv6CidrBlockAssociation(BuilderImpl builder) {
        this.associationId = builder.associationId;
        this.ipv6CidrBlock = builder.ipv6CidrBlock;
        this.cidrBlockState = builder.cidrBlockState;
    }

    /**
     * <p>
     * The association ID for the IPv6 CIDR block.
     * </p>
     * 
     * @return The association ID for the IPv6 CIDR block.
     */
    public final String associationId() {
        return associationId;
    }

    /**
     * <p>
     * The IPv6 CIDR block.
     * </p>
     * 
     * @return The IPv6 CIDR block.
     */
    public final String ipv6CidrBlock() {
        return ipv6CidrBlock;
    }

    /**
     * <p>
     * Information about the state of the CIDR block.
     * </p>
     * 
     * @return Information about the state of the CIDR block.
     */
    public final String cidrBlockState() {
        return cidrBlockState;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(associationId());
        hashCode = 31 * hashCode + Objects.hashCode(ipv6CidrBlock());
        hashCode = 31 * hashCode + Objects.hashCode(cidrBlockState());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Ipv6CidrBlockAssociation)) {
            return false;
        }
        Ipv6CidrBlockAssociation other = (Ipv6CidrBlockAssociation) obj;
        return Objects.equals(associationId(), other.associationId()) && Objects.equals(ipv6CidrBlock(), other.ipv6CidrBlock())
                && Objects.equals(cidrBlockState(), other.cidrBlockState());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Ipv6CidrBlockAssociation").add("AssociationId", associationId())
                .add("Ipv6CidrBlock", ipv6CidrBlock()).add("CidrBlockState", cidrBlockState()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AssociationId":
            return Optional.ofNullable(clazz.cast(associationId()));
        case "Ipv6CidrBlock":
            return Optional.ofNullable(clazz.cast(ipv6CidrBlock()));
        case "CidrBlockState":
            return Optional.ofNullable(clazz.cast(cidrBlockState()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Ipv6CidrBlockAssociation, T> g) {
        return obj -> g.apply((Ipv6CidrBlockAssociation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Ipv6CidrBlockAssociation> {
        /**
         * <p>
         * The association ID for the IPv6 CIDR block.
         * </p>
         * 
         * @param associationId
         *        The association ID for the IPv6 CIDR block.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associationId(String associationId);

        /**
         * <p>
         * The IPv6 CIDR block.
         * </p>
         * 
         * @param ipv6CidrBlock
         *        The IPv6 CIDR block.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipv6CidrBlock(String ipv6CidrBlock);

        /**
         * <p>
         * Information about the state of the CIDR block.
         * </p>
         * 
         * @param cidrBlockState
         *        Information about the state of the CIDR block.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cidrBlockState(String cidrBlockState);
    }

    static final class BuilderImpl implements Builder {
        private String associationId;

        private String ipv6CidrBlock;

        private String cidrBlockState;

        private BuilderImpl() {
        }

        private BuilderImpl(Ipv6CidrBlockAssociation model) {
            associationId(model.associationId);
            ipv6CidrBlock(model.ipv6CidrBlock);
            cidrBlockState(model.cidrBlockState);
        }

        public final String getAssociationId() {
            return associationId;
        }

        public final void setAssociationId(String associationId) {
            this.associationId = associationId;
        }

        @Override
        @Transient
        public final Builder associationId(String associationId) {
            this.associationId = associationId;
            return this;
        }

        public final String getIpv6CidrBlock() {
            return ipv6CidrBlock;
        }

        public final void setIpv6CidrBlock(String ipv6CidrBlock) {
            this.ipv6CidrBlock = ipv6CidrBlock;
        }

        @Override
        @Transient
        public final Builder ipv6CidrBlock(String ipv6CidrBlock) {
            this.ipv6CidrBlock = ipv6CidrBlock;
            return this;
        }

        public final String getCidrBlockState() {
            return cidrBlockState;
        }

        public final void setCidrBlockState(String cidrBlockState) {
            this.cidrBlockState = cidrBlockState;
        }

        @Override
        @Transient
        public final Builder cidrBlockState(String cidrBlockState) {
            this.cidrBlockState = cidrBlockState;
            return this;
        }

        @Override
        public Ipv6CidrBlockAssociation build() {
            return new Ipv6CidrBlockAssociation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
