/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The list of detected instances of sensitive data.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SensitiveDataDetections implements SdkPojo, Serializable,
        ToCopyableBuilder<SensitiveDataDetections.Builder, SensitiveDataDetections> {
    private static final SdkField<Long> COUNT_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("Count")
            .getter(getter(SensitiveDataDetections::count)).setter(setter(Builder::count))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Count").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(SensitiveDataDetections::type)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<Occurrences> OCCURRENCES_FIELD = SdkField.<Occurrences> builder(MarshallingType.SDK_POJO)
            .memberName("Occurrences").getter(getter(SensitiveDataDetections::occurrences)).setter(setter(Builder::occurrences))
            .constructor(Occurrences::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Occurrences").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COUNT_FIELD, TYPE_FIELD,
            OCCURRENCES_FIELD));

    private static final long serialVersionUID = 1L;

    private final Long count;

    private final String type;

    private final Occurrences occurrences;

    private SensitiveDataDetections(BuilderImpl builder) {
        this.count = builder.count;
        this.type = builder.type;
        this.occurrences = builder.occurrences;
    }

    /**
     * <p>
     * The total number of occurrences of sensitive data that were detected.
     * </p>
     * 
     * @return The total number of occurrences of sensitive data that were detected.
     */
    public final Long count() {
        return count;
    }

    /**
     * <p>
     * The type of sensitive data that was detected. For example, the type might indicate that the data is an email
     * address.
     * </p>
     * 
     * @return The type of sensitive data that was detected. For example, the type might indicate that the data is an
     *         email address.
     */
    public final String type() {
        return type;
    }

    /**
     * <p>
     * Details about the sensitive data that was detected.
     * </p>
     * 
     * @return Details about the sensitive data that was detected.
     */
    public final Occurrences occurrences() {
        return occurrences;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(count());
        hashCode = 31 * hashCode + Objects.hashCode(type());
        hashCode = 31 * hashCode + Objects.hashCode(occurrences());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SensitiveDataDetections)) {
            return false;
        }
        SensitiveDataDetections other = (SensitiveDataDetections) obj;
        return Objects.equals(count(), other.count()) && Objects.equals(type(), other.type())
                && Objects.equals(occurrences(), other.occurrences());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SensitiveDataDetections").add("Count", count()).add("Type", type())
                .add("Occurrences", occurrences()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Count":
            return Optional.ofNullable(clazz.cast(count()));
        case "Type":
            return Optional.ofNullable(clazz.cast(type()));
        case "Occurrences":
            return Optional.ofNullable(clazz.cast(occurrences()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SensitiveDataDetections, T> g) {
        return obj -> g.apply((SensitiveDataDetections) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SensitiveDataDetections> {
        /**
         * <p>
         * The total number of occurrences of sensitive data that were detected.
         * </p>
         * 
         * @param count
         *        The total number of occurrences of sensitive data that were detected.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder count(Long count);

        /**
         * <p>
         * The type of sensitive data that was detected. For example, the type might indicate that the data is an email
         * address.
         * </p>
         * 
         * @param type
         *        The type of sensitive data that was detected. For example, the type might indicate that the data is an
         *        email address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder type(String type);

        /**
         * <p>
         * Details about the sensitive data that was detected.
         * </p>
         * 
         * @param occurrences
         *        Details about the sensitive data that was detected.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder occurrences(Occurrences occurrences);

        /**
         * <p>
         * Details about the sensitive data that was detected.
         * </p>
         * This is a convenience that creates an instance of the {@link Occurrences.Builder} avoiding the need to create
         * one manually via {@link Occurrences#builder()}.
         *
         * When the {@link Consumer} completes, {@link Occurrences.Builder#build()} is called immediately and its result
         * is passed to {@link #occurrences(Occurrences)}.
         * 
         * @param occurrences
         *        a consumer that will call methods on {@link Occurrences.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #occurrences(Occurrences)
         */
        default Builder occurrences(Consumer<Occurrences.Builder> occurrences) {
            return occurrences(Occurrences.builder().applyMutation(occurrences).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Long count;

        private String type;

        private Occurrences occurrences;

        private BuilderImpl() {
        }

        private BuilderImpl(SensitiveDataDetections model) {
            count(model.count);
            type(model.type);
            occurrences(model.occurrences);
        }

        public final Long getCount() {
            return count;
        }

        public final void setCount(Long count) {
            this.count = count;
        }

        @Override
        @Transient
        public final Builder count(Long count) {
            this.count = count;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        @Transient
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final Occurrences.Builder getOccurrences() {
            return occurrences != null ? occurrences.toBuilder() : null;
        }

        public final void setOccurrences(Occurrences.BuilderImpl occurrences) {
            this.occurrences = occurrences != null ? occurrences.build() : null;
        }

        @Override
        @Transient
        public final Builder occurrences(Occurrences occurrences) {
            this.occurrences = occurrences;
            return this;
        }

        @Override
        public SensitiveDataDetections build() {
            return new SensitiveDataDetections(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
