/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains a detected instance of sensitive data that are based on built-in identifiers.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SensitiveDataResult implements SdkPojo, Serializable,
        ToCopyableBuilder<SensitiveDataResult.Builder, SensitiveDataResult> {
    private static final SdkField<String> CATEGORY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Category").getter(getter(SensitiveDataResult::category)).setter(setter(Builder::category))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Category").build()).build();

    private static final SdkField<List<SensitiveDataDetections>> DETECTIONS_FIELD = SdkField
            .<List<SensitiveDataDetections>> builder(MarshallingType.LIST)
            .memberName("Detections")
            .getter(getter(SensitiveDataResult::detections))
            .setter(setter(Builder::detections))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Detections").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SensitiveDataDetections> builder(MarshallingType.SDK_POJO)
                                            .constructor(SensitiveDataDetections::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Long> TOTAL_COUNT_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("TotalCount").getter(getter(SensitiveDataResult::totalCount)).setter(setter(Builder::totalCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalCount").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATEGORY_FIELD,
            DETECTIONS_FIELD, TOTAL_COUNT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String category;

    private final List<SensitiveDataDetections> detections;

    private final Long totalCount;

    private SensitiveDataResult(BuilderImpl builder) {
        this.category = builder.category;
        this.detections = builder.detections;
        this.totalCount = builder.totalCount;
    }

    /**
     * <p>
     * The category of sensitive data that was detected. For example, the category can indicate that the sensitive data
     * involved credentials, financial information, or personal information.
     * </p>
     * 
     * @return The category of sensitive data that was detected. For example, the category can indicate that the
     *         sensitive data involved credentials, financial information, or personal information.
     */
    public final String category() {
        return category;
    }

    /**
     * For responses, this returns true if the service returned a value for the Detections property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasDetections() {
        return detections != null && !(detections instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of detected instances of sensitive data.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDetections} method.
     * </p>
     * 
     * @return The list of detected instances of sensitive data.
     */
    public final List<SensitiveDataDetections> detections() {
        return detections;
    }

    /**
     * <p>
     * The total number of occurrences of sensitive data.
     * </p>
     * 
     * @return The total number of occurrences of sensitive data.
     */
    public final Long totalCount() {
        return totalCount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(category());
        hashCode = 31 * hashCode + Objects.hashCode(hasDetections() ? detections() : null);
        hashCode = 31 * hashCode + Objects.hashCode(totalCount());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SensitiveDataResult)) {
            return false;
        }
        SensitiveDataResult other = (SensitiveDataResult) obj;
        return Objects.equals(category(), other.category()) && hasDetections() == other.hasDetections()
                && Objects.equals(detections(), other.detections()) && Objects.equals(totalCount(), other.totalCount());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SensitiveDataResult").add("Category", category())
                .add("Detections", hasDetections() ? detections() : null).add("TotalCount", totalCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Category":
            return Optional.ofNullable(clazz.cast(category()));
        case "Detections":
            return Optional.ofNullable(clazz.cast(detections()));
        case "TotalCount":
            return Optional.ofNullable(clazz.cast(totalCount()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SensitiveDataResult, T> g) {
        return obj -> g.apply((SensitiveDataResult) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SensitiveDataResult> {
        /**
         * <p>
         * The category of sensitive data that was detected. For example, the category can indicate that the sensitive
         * data involved credentials, financial information, or personal information.
         * </p>
         * 
         * @param category
         *        The category of sensitive data that was detected. For example, the category can indicate that the
         *        sensitive data involved credentials, financial information, or personal information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder category(String category);

        /**
         * <p>
         * The list of detected instances of sensitive data.
         * </p>
         * 
         * @param detections
         *        The list of detected instances of sensitive data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder detections(Collection<SensitiveDataDetections> detections);

        /**
         * <p>
         * The list of detected instances of sensitive data.
         * </p>
         * 
         * @param detections
         *        The list of detected instances of sensitive data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder detections(SensitiveDataDetections... detections);

        /**
         * <p>
         * The list of detected instances of sensitive data.
         * </p>
         * This is a convenience that creates an instance of the {@link List<SensitiveDataDetections>.Builder} avoiding
         * the need to create one manually via {@link List<SensitiveDataDetections>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<SensitiveDataDetections>.Builder#build()} is called
         * immediately and its result is passed to {@link #detections(List<SensitiveDataDetections>)}.
         * 
         * @param detections
         *        a consumer that will call methods on {@link List<SensitiveDataDetections>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #detections(List<SensitiveDataDetections>)
         */
        Builder detections(Consumer<SensitiveDataDetections.Builder>... detections);

        /**
         * <p>
         * The total number of occurrences of sensitive data.
         * </p>
         * 
         * @param totalCount
         *        The total number of occurrences of sensitive data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalCount(Long totalCount);
    }

    static final class BuilderImpl implements Builder {
        private String category;

        private List<SensitiveDataDetections> detections = DefaultSdkAutoConstructList.getInstance();

        private Long totalCount;

        private BuilderImpl() {
        }

        private BuilderImpl(SensitiveDataResult model) {
            category(model.category);
            detections(model.detections);
            totalCount(model.totalCount);
        }

        public final String getCategory() {
            return category;
        }

        public final void setCategory(String category) {
            this.category = category;
        }

        @Override
        @Transient
        public final Builder category(String category) {
            this.category = category;
            return this;
        }

        public final List<SensitiveDataDetections.Builder> getDetections() {
            List<SensitiveDataDetections.Builder> result = SensitiveDataDetectionsListCopier.copyToBuilder(this.detections);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDetections(Collection<SensitiveDataDetections.BuilderImpl> detections) {
            this.detections = SensitiveDataDetectionsListCopier.copyFromBuilder(detections);
        }

        @Override
        @Transient
        public final Builder detections(Collection<SensitiveDataDetections> detections) {
            this.detections = SensitiveDataDetectionsListCopier.copy(detections);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder detections(SensitiveDataDetections... detections) {
            detections(Arrays.asList(detections));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder detections(Consumer<SensitiveDataDetections.Builder>... detections) {
            detections(Stream.of(detections).map(c -> SensitiveDataDetections.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Long getTotalCount() {
            return totalCount;
        }

        public final void setTotalCount(Long totalCount) {
            this.totalCount = totalCount;
        }

        @Override
        @Transient
        public final Builder totalCount(Long totalCount) {
            this.totalCount = totalCount;
            return this;
        }

        @Override
        public SensitiveDataResult build() {
            return new SensitiveDataResult(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
