/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Updates to the severity information for a finding.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SeverityUpdate implements SdkPojo, Serializable, ToCopyableBuilder<SeverityUpdate.Builder, SeverityUpdate> {
    private static final SdkField<Integer> NORMALIZED_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Normalized").getter(getter(SeverityUpdate::normalized)).setter(setter(Builder::normalized))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Normalized").build()).build();

    private static final SdkField<Double> PRODUCT_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE).memberName("Product")
            .getter(getter(SeverityUpdate::product)).setter(setter(Builder::product))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Product").build()).build();

    private static final SdkField<String> LABEL_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Label")
            .getter(getter(SeverityUpdate::labelAsString)).setter(setter(Builder::label))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Label").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NORMALIZED_FIELD,
            PRODUCT_FIELD, LABEL_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer normalized;

    private final Double product;

    private final String label;

    private SeverityUpdate(BuilderImpl builder) {
        this.normalized = builder.normalized;
        this.product = builder.product;
        this.label = builder.label;
    }

    /**
     * <p>
     * The normalized severity for the finding. This attribute is to be deprecated in favor of <code>Label</code>.
     * </p>
     * <p>
     * If you provide <code>Normalized</code> and do not provide <code>Label</code>, <code>Label</code> is set
     * automatically as follows.
     * </p>
     * <ul>
     * <li>
     * <p>
     * 0 - <code>INFORMATIONAL</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * 1–39 - <code>LOW</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * 40–69 - <code>MEDIUM</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * 70–89 - <code>HIGH</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * 90–100 - <code>CRITICAL</code>
     * </p>
     * </li>
     * </ul>
     * 
     * @return The normalized severity for the finding. This attribute is to be deprecated in favor of
     *         <code>Label</code>.</p>
     *         <p>
     *         If you provide <code>Normalized</code> and do not provide <code>Label</code>, <code>Label</code> is set
     *         automatically as follows.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         0 - <code>INFORMATIONAL</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         1–39 - <code>LOW</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         40–69 - <code>MEDIUM</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         70–89 - <code>HIGH</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         90–100 - <code>CRITICAL</code>
     *         </p>
     *         </li>
     */
    public final Integer normalized() {
        return normalized;
    }

    /**
     * <p>
     * The native severity as defined by the Amazon Web Services service or integrated partner product that generated
     * the finding.
     * </p>
     * 
     * @return The native severity as defined by the Amazon Web Services service or integrated partner product that
     *         generated the finding.
     */
    public final Double product() {
        return product;
    }

    /**
     * <p>
     * The severity value of the finding. The allowed values are the following.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>INFORMATIONAL</code> - No issue was found.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>LOW</code> - The issue does not require action on its own.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>MEDIUM</code> - The issue must be addressed but not urgently.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>HIGH</code> - The issue must be addressed as a priority.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CRITICAL</code> - The issue must be remediated immediately to avoid it escalating.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #label} will return
     * {@link SeverityLabel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #labelAsString}.
     * </p>
     * 
     * @return The severity value of the finding. The allowed values are the following.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>INFORMATIONAL</code> - No issue was found.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>LOW</code> - The issue does not require action on its own.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>MEDIUM</code> - The issue must be addressed but not urgently.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>HIGH</code> - The issue must be addressed as a priority.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CRITICAL</code> - The issue must be remediated immediately to avoid it escalating.
     *         </p>
     *         </li>
     * @see SeverityLabel
     */
    public final SeverityLabel label() {
        return SeverityLabel.fromValue(label);
    }

    /**
     * <p>
     * The severity value of the finding. The allowed values are the following.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>INFORMATIONAL</code> - No issue was found.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>LOW</code> - The issue does not require action on its own.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>MEDIUM</code> - The issue must be addressed but not urgently.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>HIGH</code> - The issue must be addressed as a priority.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CRITICAL</code> - The issue must be remediated immediately to avoid it escalating.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #label} will return
     * {@link SeverityLabel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #labelAsString}.
     * </p>
     * 
     * @return The severity value of the finding. The allowed values are the following.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>INFORMATIONAL</code> - No issue was found.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>LOW</code> - The issue does not require action on its own.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>MEDIUM</code> - The issue must be addressed but not urgently.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>HIGH</code> - The issue must be addressed as a priority.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CRITICAL</code> - The issue must be remediated immediately to avoid it escalating.
     *         </p>
     *         </li>
     * @see SeverityLabel
     */
    public final String labelAsString() {
        return label;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(normalized());
        hashCode = 31 * hashCode + Objects.hashCode(product());
        hashCode = 31 * hashCode + Objects.hashCode(labelAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SeverityUpdate)) {
            return false;
        }
        SeverityUpdate other = (SeverityUpdate) obj;
        return Objects.equals(normalized(), other.normalized()) && Objects.equals(product(), other.product())
                && Objects.equals(labelAsString(), other.labelAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SeverityUpdate").add("Normalized", normalized()).add("Product", product())
                .add("Label", labelAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Normalized":
            return Optional.ofNullable(clazz.cast(normalized()));
        case "Product":
            return Optional.ofNullable(clazz.cast(product()));
        case "Label":
            return Optional.ofNullable(clazz.cast(labelAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SeverityUpdate, T> g) {
        return obj -> g.apply((SeverityUpdate) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SeverityUpdate> {
        /**
         * <p>
         * The normalized severity for the finding. This attribute is to be deprecated in favor of <code>Label</code>.
         * </p>
         * <p>
         * If you provide <code>Normalized</code> and do not provide <code>Label</code>, <code>Label</code> is set
         * automatically as follows.
         * </p>
         * <ul>
         * <li>
         * <p>
         * 0 - <code>INFORMATIONAL</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * 1–39 - <code>LOW</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * 40–69 - <code>MEDIUM</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * 70–89 - <code>HIGH</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * 90–100 - <code>CRITICAL</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param normalized
         *        The normalized severity for the finding. This attribute is to be deprecated in favor of
         *        <code>Label</code>.</p>
         *        <p>
         *        If you provide <code>Normalized</code> and do not provide <code>Label</code>, <code>Label</code> is
         *        set automatically as follows.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        0 - <code>INFORMATIONAL</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        1–39 - <code>LOW</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        40–69 - <code>MEDIUM</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        70–89 - <code>HIGH</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        90–100 - <code>CRITICAL</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder normalized(Integer normalized);

        /**
         * <p>
         * The native severity as defined by the Amazon Web Services service or integrated partner product that
         * generated the finding.
         * </p>
         * 
         * @param product
         *        The native severity as defined by the Amazon Web Services service or integrated partner product that
         *        generated the finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder product(Double product);

        /**
         * <p>
         * The severity value of the finding. The allowed values are the following.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>INFORMATIONAL</code> - No issue was found.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>LOW</code> - The issue does not require action on its own.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>MEDIUM</code> - The issue must be addressed but not urgently.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>HIGH</code> - The issue must be addressed as a priority.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CRITICAL</code> - The issue must be remediated immediately to avoid it escalating.
         * </p>
         * </li>
         * </ul>
         * 
         * @param label
         *        The severity value of the finding. The allowed values are the following.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>INFORMATIONAL</code> - No issue was found.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>LOW</code> - The issue does not require action on its own.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>MEDIUM</code> - The issue must be addressed but not urgently.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>HIGH</code> - The issue must be addressed as a priority.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CRITICAL</code> - The issue must be remediated immediately to avoid it escalating.
         *        </p>
         *        </li>
         * @see SeverityLabel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SeverityLabel
         */
        Builder label(String label);

        /**
         * <p>
         * The severity value of the finding. The allowed values are the following.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>INFORMATIONAL</code> - No issue was found.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>LOW</code> - The issue does not require action on its own.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>MEDIUM</code> - The issue must be addressed but not urgently.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>HIGH</code> - The issue must be addressed as a priority.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CRITICAL</code> - The issue must be remediated immediately to avoid it escalating.
         * </p>
         * </li>
         * </ul>
         * 
         * @param label
         *        The severity value of the finding. The allowed values are the following.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>INFORMATIONAL</code> - No issue was found.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>LOW</code> - The issue does not require action on its own.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>MEDIUM</code> - The issue must be addressed but not urgently.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>HIGH</code> - The issue must be addressed as a priority.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CRITICAL</code> - The issue must be remediated immediately to avoid it escalating.
         *        </p>
         *        </li>
         * @see SeverityLabel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SeverityLabel
         */
        Builder label(SeverityLabel label);
    }

    static final class BuilderImpl implements Builder {
        private Integer normalized;

        private Double product;

        private String label;

        private BuilderImpl() {
        }

        private BuilderImpl(SeverityUpdate model) {
            normalized(model.normalized);
            product(model.product);
            label(model.label);
        }

        public final Integer getNormalized() {
            return normalized;
        }

        public final void setNormalized(Integer normalized) {
            this.normalized = normalized;
        }

        @Override
        @Transient
        public final Builder normalized(Integer normalized) {
            this.normalized = normalized;
            return this;
        }

        public final Double getProduct() {
            return product;
        }

        public final void setProduct(Double product) {
            this.product = product;
        }

        @Override
        @Transient
        public final Builder product(Double product) {
            this.product = product;
            return this;
        }

        public final String getLabel() {
            return label;
        }

        public final void setLabel(String label) {
            this.label = label;
        }

        @Override
        @Transient
        public final Builder label(String label) {
            this.label = label;
            return this;
        }

        @Override
        @Transient
        public final Builder label(SeverityLabel label) {
            this.label(label == null ? null : label.toString());
            return this;
        }

        @Override
        public SeverityUpdate build() {
            return new SeverityUpdate(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
