/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateFindingsRequest extends SecurityHubRequest implements
        ToCopyableBuilder<UpdateFindingsRequest.Builder, UpdateFindingsRequest> {
    private static final SdkField<AwsSecurityFindingFilters> FILTERS_FIELD = SdkField
            .<AwsSecurityFindingFilters> builder(MarshallingType.SDK_POJO).memberName("Filters")
            .getter(getter(UpdateFindingsRequest::filters)).setter(setter(Builder::filters))
            .constructor(AwsSecurityFindingFilters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filters").build()).build();

    private static final SdkField<NoteUpdate> NOTE_FIELD = SdkField.<NoteUpdate> builder(MarshallingType.SDK_POJO)
            .memberName("Note").getter(getter(UpdateFindingsRequest::note)).setter(setter(Builder::note))
            .constructor(NoteUpdate::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Note").build()).build();

    private static final SdkField<String> RECORD_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RecordState").getter(getter(UpdateFindingsRequest::recordStateAsString))
            .setter(setter(Builder::recordState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecordState").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILTERS_FIELD, NOTE_FIELD,
            RECORD_STATE_FIELD));

    private final AwsSecurityFindingFilters filters;

    private final NoteUpdate note;

    private final String recordState;

    private UpdateFindingsRequest(BuilderImpl builder) {
        super(builder);
        this.filters = builder.filters;
        this.note = builder.note;
        this.recordState = builder.recordState;
    }

    /**
     * <p>
     * A collection of attributes that specify which findings you want to update.
     * </p>
     * 
     * @return A collection of attributes that specify which findings you want to update.
     */
    public final AwsSecurityFindingFilters filters() {
        return filters;
    }

    /**
     * <p>
     * The updated note for the finding.
     * </p>
     * 
     * @return The updated note for the finding.
     */
    public final NoteUpdate note() {
        return note;
    }

    /**
     * <p>
     * The updated record state for the finding.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #recordState} will
     * return {@link RecordState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #recordStateAsString}.
     * </p>
     * 
     * @return The updated record state for the finding.
     * @see RecordState
     */
    public final RecordState recordState() {
        return RecordState.fromValue(recordState);
    }

    /**
     * <p>
     * The updated record state for the finding.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #recordState} will
     * return {@link RecordState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #recordStateAsString}.
     * </p>
     * 
     * @return The updated record state for the finding.
     * @see RecordState
     */
    public final String recordStateAsString() {
        return recordState;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(filters());
        hashCode = 31 * hashCode + Objects.hashCode(note());
        hashCode = 31 * hashCode + Objects.hashCode(recordStateAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateFindingsRequest)) {
            return false;
        }
        UpdateFindingsRequest other = (UpdateFindingsRequest) obj;
        return Objects.equals(filters(), other.filters()) && Objects.equals(note(), other.note())
                && Objects.equals(recordStateAsString(), other.recordStateAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateFindingsRequest").add("Filters", filters()).add("Note", note())
                .add("RecordState", recordStateAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Filters":
            return Optional.ofNullable(clazz.cast(filters()));
        case "Note":
            return Optional.ofNullable(clazz.cast(note()));
        case "RecordState":
            return Optional.ofNullable(clazz.cast(recordStateAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateFindingsRequest, T> g) {
        return obj -> g.apply((UpdateFindingsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SecurityHubRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateFindingsRequest> {
        /**
         * <p>
         * A collection of attributes that specify which findings you want to update.
         * </p>
         * 
         * @param filters
         *        A collection of attributes that specify which findings you want to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(AwsSecurityFindingFilters filters);

        /**
         * <p>
         * A collection of attributes that specify which findings you want to update.
         * </p>
         * This is a convenience that creates an instance of the {@link AwsSecurityFindingFilters.Builder} avoiding the
         * need to create one manually via {@link AwsSecurityFindingFilters#builder()}.
         *
         * When the {@link Consumer} completes, {@link AwsSecurityFindingFilters.Builder#build()} is called immediately
         * and its result is passed to {@link #filters(AwsSecurityFindingFilters)}.
         * 
         * @param filters
         *        a consumer that will call methods on {@link AwsSecurityFindingFilters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(AwsSecurityFindingFilters)
         */
        default Builder filters(Consumer<AwsSecurityFindingFilters.Builder> filters) {
            return filters(AwsSecurityFindingFilters.builder().applyMutation(filters).build());
        }

        /**
         * <p>
         * The updated note for the finding.
         * </p>
         * 
         * @param note
         *        The updated note for the finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder note(NoteUpdate note);

        /**
         * <p>
         * The updated note for the finding.
         * </p>
         * This is a convenience that creates an instance of the {@link NoteUpdate.Builder} avoiding the need to create
         * one manually via {@link NoteUpdate#builder()}.
         *
         * When the {@link Consumer} completes, {@link NoteUpdate.Builder#build()} is called immediately and its result
         * is passed to {@link #note(NoteUpdate)}.
         * 
         * @param note
         *        a consumer that will call methods on {@link NoteUpdate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #note(NoteUpdate)
         */
        default Builder note(Consumer<NoteUpdate.Builder> note) {
            return note(NoteUpdate.builder().applyMutation(note).build());
        }

        /**
         * <p>
         * The updated record state for the finding.
         * </p>
         * 
         * @param recordState
         *        The updated record state for the finding.
         * @see RecordState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RecordState
         */
        Builder recordState(String recordState);

        /**
         * <p>
         * The updated record state for the finding.
         * </p>
         * 
         * @param recordState
         *        The updated record state for the finding.
         * @see RecordState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RecordState
         */
        Builder recordState(RecordState recordState);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SecurityHubRequest.BuilderImpl implements Builder {
        private AwsSecurityFindingFilters filters;

        private NoteUpdate note;

        private String recordState;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateFindingsRequest model) {
            super(model);
            filters(model.filters);
            note(model.note);
            recordState(model.recordState);
        }

        public final AwsSecurityFindingFilters.Builder getFilters() {
            return filters != null ? filters.toBuilder() : null;
        }

        public final void setFilters(AwsSecurityFindingFilters.BuilderImpl filters) {
            this.filters = filters != null ? filters.build() : null;
        }

        @Override
        @Transient
        public final Builder filters(AwsSecurityFindingFilters filters) {
            this.filters = filters;
            return this;
        }

        public final NoteUpdate.Builder getNote() {
            return note != null ? note.toBuilder() : null;
        }

        public final void setNote(NoteUpdate.BuilderImpl note) {
            this.note = note != null ? note.build() : null;
        }

        @Override
        @Transient
        public final Builder note(NoteUpdate note) {
            this.note = note;
            return this;
        }

        public final String getRecordState() {
            return recordState;
        }

        public final void setRecordState(String recordState) {
            this.recordState = recordState;
        }

        @Override
        @Transient
        public final Builder recordState(String recordState) {
            this.recordState = recordState;
            return this;
        }

        @Override
        @Transient
        public final Builder recordState(RecordState recordState) {
            this.recordState(recordState == null ? null : recordState.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateFindingsRequest build() {
            return new UpdateFindingsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
