/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Identifies a finding to update using <code>BatchUpdateFindings</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsSecurityFindingIdentifier implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsSecurityFindingIdentifier.Builder, AwsSecurityFindingIdentifier> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(AwsSecurityFindingIdentifier::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> PRODUCT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProductArn").getter(getter(AwsSecurityFindingIdentifier::productArn))
            .setter(setter(Builder::productArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, PRODUCT_ARN_FIELD));

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String productArn;

    private AwsSecurityFindingIdentifier(BuilderImpl builder) {
        this.id = builder.id;
        this.productArn = builder.productArn;
    }

    /**
     * <p>
     * The identifier of the finding that was specified by the finding provider.
     * </p>
     * 
     * @return The identifier of the finding that was specified by the finding provider.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The ARN generated by Security Hub that uniquely identifies a product that generates findings. This can be the ARN
     * for a third-party product that is integrated with Security Hub, or the ARN for a custom integration.
     * </p>
     * 
     * @return The ARN generated by Security Hub that uniquely identifies a product that generates findings. This can be
     *         the ARN for a third-party product that is integrated with Security Hub, or the ARN for a custom
     *         integration.
     */
    public final String productArn() {
        return productArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(productArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsSecurityFindingIdentifier)) {
            return false;
        }
        AwsSecurityFindingIdentifier other = (AwsSecurityFindingIdentifier) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(productArn(), other.productArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsSecurityFindingIdentifier").add("Id", id()).add("ProductArn", productArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "ProductArn":
            return Optional.ofNullable(clazz.cast(productArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsSecurityFindingIdentifier, T> g) {
        return obj -> g.apply((AwsSecurityFindingIdentifier) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsSecurityFindingIdentifier> {
        /**
         * <p>
         * The identifier of the finding that was specified by the finding provider.
         * </p>
         * 
         * @param id
         *        The identifier of the finding that was specified by the finding provider.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The ARN generated by Security Hub that uniquely identifies a product that generates findings. This can be the
         * ARN for a third-party product that is integrated with Security Hub, or the ARN for a custom integration.
         * </p>
         * 
         * @param productArn
         *        The ARN generated by Security Hub that uniquely identifies a product that generates findings. This can
         *        be the ARN for a third-party product that is integrated with Security Hub, or the ARN for a custom
         *        integration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productArn(String productArn);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String productArn;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsSecurityFindingIdentifier model) {
            id(model.id);
            productArn(model.productArn);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getProductArn() {
            return productArn;
        }

        public final void setProductArn(String productArn) {
            this.productArn = productArn;
        }

        @Override
        public final Builder productArn(String productArn) {
            this.productArn = productArn;
            return this;
        }

        @Override
        public AwsSecurityFindingIdentifier build() {
            return new AwsSecurityFindingIdentifier(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
