/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The details of network-related information about a finding.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Network implements SdkPojo, Serializable, ToCopyableBuilder<Network.Builder, Network> {
    private static final SdkField<String> DIRECTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Direction").getter(getter(Network::directionAsString)).setter(setter(Builder::direction))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Direction").build()).build();

    private static final SdkField<String> PROTOCOL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Protocol").getter(getter(Network::protocol)).setter(setter(Builder::protocol))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Protocol").build()).build();

    private static final SdkField<PortRange> OPEN_PORT_RANGE_FIELD = SdkField.<PortRange> builder(MarshallingType.SDK_POJO)
            .memberName("OpenPortRange").getter(getter(Network::openPortRange)).setter(setter(Builder::openPortRange))
            .constructor(PortRange::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OpenPortRange").build()).build();

    private static final SdkField<String> SOURCE_IP_V4_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceIpV4").getter(getter(Network::sourceIpV4)).setter(setter(Builder::sourceIpV4))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceIpV4").build()).build();

    private static final SdkField<String> SOURCE_IP_V6_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceIpV6").getter(getter(Network::sourceIpV6)).setter(setter(Builder::sourceIpV6))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceIpV6").build()).build();

    private static final SdkField<Integer> SOURCE_PORT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("SourcePort").getter(getter(Network::sourcePort)).setter(setter(Builder::sourcePort))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourcePort").build()).build();

    private static final SdkField<String> SOURCE_DOMAIN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceDomain").getter(getter(Network::sourceDomain)).setter(setter(Builder::sourceDomain))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceDomain").build()).build();

    private static final SdkField<String> SOURCE_MAC_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceMac").getter(getter(Network::sourceMac)).setter(setter(Builder::sourceMac))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceMac").build()).build();

    private static final SdkField<String> DESTINATION_IP_V4_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DestinationIpV4").getter(getter(Network::destinationIpV4)).setter(setter(Builder::destinationIpV4))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationIpV4").build()).build();

    private static final SdkField<String> DESTINATION_IP_V6_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DestinationIpV6").getter(getter(Network::destinationIpV6)).setter(setter(Builder::destinationIpV6))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationIpV6").build()).build();

    private static final SdkField<Integer> DESTINATION_PORT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("DestinationPort").getter(getter(Network::destinationPort)).setter(setter(Builder::destinationPort))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationPort").build()).build();

    private static final SdkField<String> DESTINATION_DOMAIN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DestinationDomain").getter(getter(Network::destinationDomain))
            .setter(setter(Builder::destinationDomain))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationDomain").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIRECTION_FIELD,
            PROTOCOL_FIELD, OPEN_PORT_RANGE_FIELD, SOURCE_IP_V4_FIELD, SOURCE_IP_V6_FIELD, SOURCE_PORT_FIELD,
            SOURCE_DOMAIN_FIELD, SOURCE_MAC_FIELD, DESTINATION_IP_V4_FIELD, DESTINATION_IP_V6_FIELD, DESTINATION_PORT_FIELD,
            DESTINATION_DOMAIN_FIELD));

    private static final long serialVersionUID = 1L;

    private final String direction;

    private final String protocol;

    private final PortRange openPortRange;

    private final String sourceIpV4;

    private final String sourceIpV6;

    private final Integer sourcePort;

    private final String sourceDomain;

    private final String sourceMac;

    private final String destinationIpV4;

    private final String destinationIpV6;

    private final Integer destinationPort;

    private final String destinationDomain;

    private Network(BuilderImpl builder) {
        this.direction = builder.direction;
        this.protocol = builder.protocol;
        this.openPortRange = builder.openPortRange;
        this.sourceIpV4 = builder.sourceIpV4;
        this.sourceIpV6 = builder.sourceIpV6;
        this.sourcePort = builder.sourcePort;
        this.sourceDomain = builder.sourceDomain;
        this.sourceMac = builder.sourceMac;
        this.destinationIpV4 = builder.destinationIpV4;
        this.destinationIpV6 = builder.destinationIpV6;
        this.destinationPort = builder.destinationPort;
        this.destinationDomain = builder.destinationDomain;
    }

    /**
     * <p>
     * The direction of network traffic associated with a finding.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #direction} will
     * return {@link NetworkDirection#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #directionAsString}.
     * </p>
     * 
     * @return The direction of network traffic associated with a finding.
     * @see NetworkDirection
     */
    public final NetworkDirection direction() {
        return NetworkDirection.fromValue(direction);
    }

    /**
     * <p>
     * The direction of network traffic associated with a finding.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #direction} will
     * return {@link NetworkDirection#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #directionAsString}.
     * </p>
     * 
     * @return The direction of network traffic associated with a finding.
     * @see NetworkDirection
     */
    public final String directionAsString() {
        return direction;
    }

    /**
     * <p>
     * The protocol of network-related information about a finding.
     * </p>
     * 
     * @return The protocol of network-related information about a finding.
     */
    public final String protocol() {
        return protocol;
    }

    /**
     * <p>
     * The range of open ports that is present on the network.
     * </p>
     * 
     * @return The range of open ports that is present on the network.
     */
    public final PortRange openPortRange() {
        return openPortRange;
    }

    /**
     * <p>
     * The source IPv4 address of network-related information about a finding.
     * </p>
     * 
     * @return The source IPv4 address of network-related information about a finding.
     */
    public final String sourceIpV4() {
        return sourceIpV4;
    }

    /**
     * <p>
     * The source IPv6 address of network-related information about a finding.
     * </p>
     * 
     * @return The source IPv6 address of network-related information about a finding.
     */
    public final String sourceIpV6() {
        return sourceIpV6;
    }

    /**
     * <p>
     * The source port of network-related information about a finding.
     * </p>
     * 
     * @return The source port of network-related information about a finding.
     */
    public final Integer sourcePort() {
        return sourcePort;
    }

    /**
     * <p>
     * The source domain of network-related information about a finding.
     * </p>
     * 
     * @return The source domain of network-related information about a finding.
     */
    public final String sourceDomain() {
        return sourceDomain;
    }

    /**
     * <p>
     * The source media access control (MAC) address of network-related information about a finding.
     * </p>
     * 
     * @return The source media access control (MAC) address of network-related information about a finding.
     */
    public final String sourceMac() {
        return sourceMac;
    }

    /**
     * <p>
     * The destination IPv4 address of network-related information about a finding.
     * </p>
     * 
     * @return The destination IPv4 address of network-related information about a finding.
     */
    public final String destinationIpV4() {
        return destinationIpV4;
    }

    /**
     * <p>
     * The destination IPv6 address of network-related information about a finding.
     * </p>
     * 
     * @return The destination IPv6 address of network-related information about a finding.
     */
    public final String destinationIpV6() {
        return destinationIpV6;
    }

    /**
     * <p>
     * The destination port of network-related information about a finding.
     * </p>
     * 
     * @return The destination port of network-related information about a finding.
     */
    public final Integer destinationPort() {
        return destinationPort;
    }

    /**
     * <p>
     * The destination domain of network-related information about a finding.
     * </p>
     * 
     * @return The destination domain of network-related information about a finding.
     */
    public final String destinationDomain() {
        return destinationDomain;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(directionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(protocol());
        hashCode = 31 * hashCode + Objects.hashCode(openPortRange());
        hashCode = 31 * hashCode + Objects.hashCode(sourceIpV4());
        hashCode = 31 * hashCode + Objects.hashCode(sourceIpV6());
        hashCode = 31 * hashCode + Objects.hashCode(sourcePort());
        hashCode = 31 * hashCode + Objects.hashCode(sourceDomain());
        hashCode = 31 * hashCode + Objects.hashCode(sourceMac());
        hashCode = 31 * hashCode + Objects.hashCode(destinationIpV4());
        hashCode = 31 * hashCode + Objects.hashCode(destinationIpV6());
        hashCode = 31 * hashCode + Objects.hashCode(destinationPort());
        hashCode = 31 * hashCode + Objects.hashCode(destinationDomain());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Network)) {
            return false;
        }
        Network other = (Network) obj;
        return Objects.equals(directionAsString(), other.directionAsString()) && Objects.equals(protocol(), other.protocol())
                && Objects.equals(openPortRange(), other.openPortRange()) && Objects.equals(sourceIpV4(), other.sourceIpV4())
                && Objects.equals(sourceIpV6(), other.sourceIpV6()) && Objects.equals(sourcePort(), other.sourcePort())
                && Objects.equals(sourceDomain(), other.sourceDomain()) && Objects.equals(sourceMac(), other.sourceMac())
                && Objects.equals(destinationIpV4(), other.destinationIpV4())
                && Objects.equals(destinationIpV6(), other.destinationIpV6())
                && Objects.equals(destinationPort(), other.destinationPort())
                && Objects.equals(destinationDomain(), other.destinationDomain());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Network").add("Direction", directionAsString()).add("Protocol", protocol())
                .add("OpenPortRange", openPortRange()).add("SourceIpV4", sourceIpV4()).add("SourceIpV6", sourceIpV6())
                .add("SourcePort", sourcePort()).add("SourceDomain", sourceDomain()).add("SourceMac", sourceMac())
                .add("DestinationIpV4", destinationIpV4()).add("DestinationIpV6", destinationIpV6())
                .add("DestinationPort", destinationPort()).add("DestinationDomain", destinationDomain()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Direction":
            return Optional.ofNullable(clazz.cast(directionAsString()));
        case "Protocol":
            return Optional.ofNullable(clazz.cast(protocol()));
        case "OpenPortRange":
            return Optional.ofNullable(clazz.cast(openPortRange()));
        case "SourceIpV4":
            return Optional.ofNullable(clazz.cast(sourceIpV4()));
        case "SourceIpV6":
            return Optional.ofNullable(clazz.cast(sourceIpV6()));
        case "SourcePort":
            return Optional.ofNullable(clazz.cast(sourcePort()));
        case "SourceDomain":
            return Optional.ofNullable(clazz.cast(sourceDomain()));
        case "SourceMac":
            return Optional.ofNullable(clazz.cast(sourceMac()));
        case "DestinationIpV4":
            return Optional.ofNullable(clazz.cast(destinationIpV4()));
        case "DestinationIpV6":
            return Optional.ofNullable(clazz.cast(destinationIpV6()));
        case "DestinationPort":
            return Optional.ofNullable(clazz.cast(destinationPort()));
        case "DestinationDomain":
            return Optional.ofNullable(clazz.cast(destinationDomain()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Network, T> g) {
        return obj -> g.apply((Network) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Network> {
        /**
         * <p>
         * The direction of network traffic associated with a finding.
         * </p>
         * 
         * @param direction
         *        The direction of network traffic associated with a finding.
         * @see NetworkDirection
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NetworkDirection
         */
        Builder direction(String direction);

        /**
         * <p>
         * The direction of network traffic associated with a finding.
         * </p>
         * 
         * @param direction
         *        The direction of network traffic associated with a finding.
         * @see NetworkDirection
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NetworkDirection
         */
        Builder direction(NetworkDirection direction);

        /**
         * <p>
         * The protocol of network-related information about a finding.
         * </p>
         * 
         * @param protocol
         *        The protocol of network-related information about a finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder protocol(String protocol);

        /**
         * <p>
         * The range of open ports that is present on the network.
         * </p>
         * 
         * @param openPortRange
         *        The range of open ports that is present on the network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder openPortRange(PortRange openPortRange);

        /**
         * <p>
         * The range of open ports that is present on the network.
         * </p>
         * This is a convenience method that creates an instance of the {@link PortRange.Builder} avoiding the need to
         * create one manually via {@link PortRange#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PortRange.Builder#build()} is called immediately and its result
         * is passed to {@link #openPortRange(PortRange)}.
         * 
         * @param openPortRange
         *        a consumer that will call methods on {@link PortRange.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #openPortRange(PortRange)
         */
        default Builder openPortRange(Consumer<PortRange.Builder> openPortRange) {
            return openPortRange(PortRange.builder().applyMutation(openPortRange).build());
        }

        /**
         * <p>
         * The source IPv4 address of network-related information about a finding.
         * </p>
         * 
         * @param sourceIpV4
         *        The source IPv4 address of network-related information about a finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceIpV4(String sourceIpV4);

        /**
         * <p>
         * The source IPv6 address of network-related information about a finding.
         * </p>
         * 
         * @param sourceIpV6
         *        The source IPv6 address of network-related information about a finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceIpV6(String sourceIpV6);

        /**
         * <p>
         * The source port of network-related information about a finding.
         * </p>
         * 
         * @param sourcePort
         *        The source port of network-related information about a finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourcePort(Integer sourcePort);

        /**
         * <p>
         * The source domain of network-related information about a finding.
         * </p>
         * 
         * @param sourceDomain
         *        The source domain of network-related information about a finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceDomain(String sourceDomain);

        /**
         * <p>
         * The source media access control (MAC) address of network-related information about a finding.
         * </p>
         * 
         * @param sourceMac
         *        The source media access control (MAC) address of network-related information about a finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceMac(String sourceMac);

        /**
         * <p>
         * The destination IPv4 address of network-related information about a finding.
         * </p>
         * 
         * @param destinationIpV4
         *        The destination IPv4 address of network-related information about a finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationIpV4(String destinationIpV4);

        /**
         * <p>
         * The destination IPv6 address of network-related information about a finding.
         * </p>
         * 
         * @param destinationIpV6
         *        The destination IPv6 address of network-related information about a finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationIpV6(String destinationIpV6);

        /**
         * <p>
         * The destination port of network-related information about a finding.
         * </p>
         * 
         * @param destinationPort
         *        The destination port of network-related information about a finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationPort(Integer destinationPort);

        /**
         * <p>
         * The destination domain of network-related information about a finding.
         * </p>
         * 
         * @param destinationDomain
         *        The destination domain of network-related information about a finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationDomain(String destinationDomain);
    }

    static final class BuilderImpl implements Builder {
        private String direction;

        private String protocol;

        private PortRange openPortRange;

        private String sourceIpV4;

        private String sourceIpV6;

        private Integer sourcePort;

        private String sourceDomain;

        private String sourceMac;

        private String destinationIpV4;

        private String destinationIpV6;

        private Integer destinationPort;

        private String destinationDomain;

        private BuilderImpl() {
        }

        private BuilderImpl(Network model) {
            direction(model.direction);
            protocol(model.protocol);
            openPortRange(model.openPortRange);
            sourceIpV4(model.sourceIpV4);
            sourceIpV6(model.sourceIpV6);
            sourcePort(model.sourcePort);
            sourceDomain(model.sourceDomain);
            sourceMac(model.sourceMac);
            destinationIpV4(model.destinationIpV4);
            destinationIpV6(model.destinationIpV6);
            destinationPort(model.destinationPort);
            destinationDomain(model.destinationDomain);
        }

        public final String getDirection() {
            return direction;
        }

        public final void setDirection(String direction) {
            this.direction = direction;
        }

        @Override
        public final Builder direction(String direction) {
            this.direction = direction;
            return this;
        }

        @Override
        public final Builder direction(NetworkDirection direction) {
            this.direction(direction == null ? null : direction.toString());
            return this;
        }

        public final String getProtocol() {
            return protocol;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        @Override
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        public final PortRange.Builder getOpenPortRange() {
            return openPortRange != null ? openPortRange.toBuilder() : null;
        }

        public final void setOpenPortRange(PortRange.BuilderImpl openPortRange) {
            this.openPortRange = openPortRange != null ? openPortRange.build() : null;
        }

        @Override
        public final Builder openPortRange(PortRange openPortRange) {
            this.openPortRange = openPortRange;
            return this;
        }

        public final String getSourceIpV4() {
            return sourceIpV4;
        }

        public final void setSourceIpV4(String sourceIpV4) {
            this.sourceIpV4 = sourceIpV4;
        }

        @Override
        public final Builder sourceIpV4(String sourceIpV4) {
            this.sourceIpV4 = sourceIpV4;
            return this;
        }

        public final String getSourceIpV6() {
            return sourceIpV6;
        }

        public final void setSourceIpV6(String sourceIpV6) {
            this.sourceIpV6 = sourceIpV6;
        }

        @Override
        public final Builder sourceIpV6(String sourceIpV6) {
            this.sourceIpV6 = sourceIpV6;
            return this;
        }

        public final Integer getSourcePort() {
            return sourcePort;
        }

        public final void setSourcePort(Integer sourcePort) {
            this.sourcePort = sourcePort;
        }

        @Override
        public final Builder sourcePort(Integer sourcePort) {
            this.sourcePort = sourcePort;
            return this;
        }

        public final String getSourceDomain() {
            return sourceDomain;
        }

        public final void setSourceDomain(String sourceDomain) {
            this.sourceDomain = sourceDomain;
        }

        @Override
        public final Builder sourceDomain(String sourceDomain) {
            this.sourceDomain = sourceDomain;
            return this;
        }

        public final String getSourceMac() {
            return sourceMac;
        }

        public final void setSourceMac(String sourceMac) {
            this.sourceMac = sourceMac;
        }

        @Override
        public final Builder sourceMac(String sourceMac) {
            this.sourceMac = sourceMac;
            return this;
        }

        public final String getDestinationIpV4() {
            return destinationIpV4;
        }

        public final void setDestinationIpV4(String destinationIpV4) {
            this.destinationIpV4 = destinationIpV4;
        }

        @Override
        public final Builder destinationIpV4(String destinationIpV4) {
            this.destinationIpV4 = destinationIpV4;
            return this;
        }

        public final String getDestinationIpV6() {
            return destinationIpV6;
        }

        public final void setDestinationIpV6(String destinationIpV6) {
            this.destinationIpV6 = destinationIpV6;
        }

        @Override
        public final Builder destinationIpV6(String destinationIpV6) {
            this.destinationIpV6 = destinationIpV6;
            return this;
        }

        public final Integer getDestinationPort() {
            return destinationPort;
        }

        public final void setDestinationPort(Integer destinationPort) {
            this.destinationPort = destinationPort;
        }

        @Override
        public final Builder destinationPort(Integer destinationPort) {
            this.destinationPort = destinationPort;
            return this;
        }

        public final String getDestinationDomain() {
            return destinationDomain;
        }

        public final void setDestinationDomain(String destinationDomain) {
            this.destinationDomain = destinationDomain;
        }

        @Override
        public final Builder destinationDomain(String destinationDomain) {
            this.destinationDomain = destinationDomain;
            return this;
        }

        @Override
        public Network build() {
            return new Network(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
