/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Additional details about a resource related to a finding.
 * </p>
 * <p>
 * To provide the details, use the object that corresponds to the resource type. For example, if the resource type is
 * <code>AwsEc2Instance</code>, then you use the <code>AwsEc2Instance</code> object to provide the details.
 * </p>
 * <p>
 * If the type-specific object does not contain all of the fields you want to populate, then you use the
 * <code>Other</code> object to populate those additional fields.
 * </p>
 * <p>
 * You also use the <code>Other</code> object to populate the details when the selected type does not have a
 * corresponding object.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResourceDetails implements SdkPojo, Serializable, ToCopyableBuilder<ResourceDetails.Builder, ResourceDetails> {
    private static final SdkField<AwsAutoScalingAutoScalingGroupDetails> AWS_AUTO_SCALING_AUTO_SCALING_GROUP_FIELD = SdkField
            .<AwsAutoScalingAutoScalingGroupDetails> builder(MarshallingType.SDK_POJO)
            .memberName("AwsAutoScalingAutoScalingGroup")
            .getter(getter(ResourceDetails::awsAutoScalingAutoScalingGroup))
            .setter(setter(Builder::awsAutoScalingAutoScalingGroup))
            .constructor(AwsAutoScalingAutoScalingGroupDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsAutoScalingAutoScalingGroup")
                    .build()).build();

    private static final SdkField<AwsCodeBuildProjectDetails> AWS_CODE_BUILD_PROJECT_FIELD = SdkField
            .<AwsCodeBuildProjectDetails> builder(MarshallingType.SDK_POJO).memberName("AwsCodeBuildProject")
            .getter(getter(ResourceDetails::awsCodeBuildProject)).setter(setter(Builder::awsCodeBuildProject))
            .constructor(AwsCodeBuildProjectDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsCodeBuildProject").build())
            .build();

    private static final SdkField<AwsCloudFrontDistributionDetails> AWS_CLOUD_FRONT_DISTRIBUTION_FIELD = SdkField
            .<AwsCloudFrontDistributionDetails> builder(MarshallingType.SDK_POJO).memberName("AwsCloudFrontDistribution")
            .getter(getter(ResourceDetails::awsCloudFrontDistribution)).setter(setter(Builder::awsCloudFrontDistribution))
            .constructor(AwsCloudFrontDistributionDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsCloudFrontDistribution").build())
            .build();

    private static final SdkField<AwsEc2InstanceDetails> AWS_EC2_INSTANCE_FIELD = SdkField
            .<AwsEc2InstanceDetails> builder(MarshallingType.SDK_POJO).memberName("AwsEc2Instance")
            .getter(getter(ResourceDetails::awsEc2Instance)).setter(setter(Builder::awsEc2Instance))
            .constructor(AwsEc2InstanceDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsEc2Instance").build()).build();

    private static final SdkField<AwsEc2NetworkInterfaceDetails> AWS_EC2_NETWORK_INTERFACE_FIELD = SdkField
            .<AwsEc2NetworkInterfaceDetails> builder(MarshallingType.SDK_POJO).memberName("AwsEc2NetworkInterface")
            .getter(getter(ResourceDetails::awsEc2NetworkInterface)).setter(setter(Builder::awsEc2NetworkInterface))
            .constructor(AwsEc2NetworkInterfaceDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsEc2NetworkInterface").build())
            .build();

    private static final SdkField<AwsEc2SecurityGroupDetails> AWS_EC2_SECURITY_GROUP_FIELD = SdkField
            .<AwsEc2SecurityGroupDetails> builder(MarshallingType.SDK_POJO).memberName("AwsEc2SecurityGroup")
            .getter(getter(ResourceDetails::awsEc2SecurityGroup)).setter(setter(Builder::awsEc2SecurityGroup))
            .constructor(AwsEc2SecurityGroupDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsEc2SecurityGroup").build())
            .build();

    private static final SdkField<AwsEc2VolumeDetails> AWS_EC2_VOLUME_FIELD = SdkField
            .<AwsEc2VolumeDetails> builder(MarshallingType.SDK_POJO).memberName("AwsEc2Volume")
            .getter(getter(ResourceDetails::awsEc2Volume)).setter(setter(Builder::awsEc2Volume))
            .constructor(AwsEc2VolumeDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsEc2Volume").build()).build();

    private static final SdkField<AwsEc2VpcDetails> AWS_EC2_VPC_FIELD = SdkField
            .<AwsEc2VpcDetails> builder(MarshallingType.SDK_POJO).memberName("AwsEc2Vpc")
            .getter(getter(ResourceDetails::awsEc2Vpc)).setter(setter(Builder::awsEc2Vpc)).constructor(AwsEc2VpcDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsEc2Vpc").build()).build();

    private static final SdkField<AwsEc2EipDetails> AWS_EC2_EIP_FIELD = SdkField
            .<AwsEc2EipDetails> builder(MarshallingType.SDK_POJO).memberName("AwsEc2Eip")
            .getter(getter(ResourceDetails::awsEc2Eip)).setter(setter(Builder::awsEc2Eip)).constructor(AwsEc2EipDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsEc2Eip").build()).build();

    private static final SdkField<AwsEc2SubnetDetails> AWS_EC2_SUBNET_FIELD = SdkField
            .<AwsEc2SubnetDetails> builder(MarshallingType.SDK_POJO).memberName("AwsEc2Subnet")
            .getter(getter(ResourceDetails::awsEc2Subnet)).setter(setter(Builder::awsEc2Subnet))
            .constructor(AwsEc2SubnetDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsEc2Subnet").build()).build();

    private static final SdkField<AwsEc2NetworkAclDetails> AWS_EC2_NETWORK_ACL_FIELD = SdkField
            .<AwsEc2NetworkAclDetails> builder(MarshallingType.SDK_POJO).memberName("AwsEc2NetworkAcl")
            .getter(getter(ResourceDetails::awsEc2NetworkAcl)).setter(setter(Builder::awsEc2NetworkAcl))
            .constructor(AwsEc2NetworkAclDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsEc2NetworkAcl").build()).build();

    private static final SdkField<AwsElbv2LoadBalancerDetails> AWS_ELBV2_LOAD_BALANCER_FIELD = SdkField
            .<AwsElbv2LoadBalancerDetails> builder(MarshallingType.SDK_POJO).memberName("AwsElbv2LoadBalancer")
            .getter(getter(ResourceDetails::awsElbv2LoadBalancer)).setter(setter(Builder::awsElbv2LoadBalancer))
            .constructor(AwsElbv2LoadBalancerDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsElbv2LoadBalancer").build())
            .build();

    private static final SdkField<AwsElasticBeanstalkEnvironmentDetails> AWS_ELASTIC_BEANSTALK_ENVIRONMENT_FIELD = SdkField
            .<AwsElasticBeanstalkEnvironmentDetails> builder(MarshallingType.SDK_POJO)
            .memberName("AwsElasticBeanstalkEnvironment")
            .getter(getter(ResourceDetails::awsElasticBeanstalkEnvironment))
            .setter(setter(Builder::awsElasticBeanstalkEnvironment))
            .constructor(AwsElasticBeanstalkEnvironmentDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsElasticBeanstalkEnvironment")
                    .build()).build();

    private static final SdkField<AwsElasticsearchDomainDetails> AWS_ELASTICSEARCH_DOMAIN_FIELD = SdkField
            .<AwsElasticsearchDomainDetails> builder(MarshallingType.SDK_POJO).memberName("AwsElasticsearchDomain")
            .getter(getter(ResourceDetails::awsElasticsearchDomain)).setter(setter(Builder::awsElasticsearchDomain))
            .constructor(AwsElasticsearchDomainDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsElasticsearchDomain").build())
            .build();

    private static final SdkField<AwsS3BucketDetails> AWS_S3_BUCKET_FIELD = SdkField
            .<AwsS3BucketDetails> builder(MarshallingType.SDK_POJO).memberName("AwsS3Bucket")
            .getter(getter(ResourceDetails::awsS3Bucket)).setter(setter(Builder::awsS3Bucket))
            .constructor(AwsS3BucketDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsS3Bucket").build()).build();

    private static final SdkField<AwsS3AccountPublicAccessBlockDetails> AWS_S3_ACCOUNT_PUBLIC_ACCESS_BLOCK_FIELD = SdkField
            .<AwsS3AccountPublicAccessBlockDetails> builder(MarshallingType.SDK_POJO)
            .memberName("AwsS3AccountPublicAccessBlock")
            .getter(getter(ResourceDetails::awsS3AccountPublicAccessBlock))
            .setter(setter(Builder::awsS3AccountPublicAccessBlock))
            .constructor(AwsS3AccountPublicAccessBlockDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsS3AccountPublicAccessBlock")
                    .build()).build();

    private static final SdkField<AwsS3ObjectDetails> AWS_S3_OBJECT_FIELD = SdkField
            .<AwsS3ObjectDetails> builder(MarshallingType.SDK_POJO).memberName("AwsS3Object")
            .getter(getter(ResourceDetails::awsS3Object)).setter(setter(Builder::awsS3Object))
            .constructor(AwsS3ObjectDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsS3Object").build()).build();

    private static final SdkField<AwsSecretsManagerSecretDetails> AWS_SECRETS_MANAGER_SECRET_FIELD = SdkField
            .<AwsSecretsManagerSecretDetails> builder(MarshallingType.SDK_POJO).memberName("AwsSecretsManagerSecret")
            .getter(getter(ResourceDetails::awsSecretsManagerSecret)).setter(setter(Builder::awsSecretsManagerSecret))
            .constructor(AwsSecretsManagerSecretDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsSecretsManagerSecret").build())
            .build();

    private static final SdkField<AwsIamAccessKeyDetails> AWS_IAM_ACCESS_KEY_FIELD = SdkField
            .<AwsIamAccessKeyDetails> builder(MarshallingType.SDK_POJO).memberName("AwsIamAccessKey")
            .getter(getter(ResourceDetails::awsIamAccessKey)).setter(setter(Builder::awsIamAccessKey))
            .constructor(AwsIamAccessKeyDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsIamAccessKey").build()).build();

    private static final SdkField<AwsIamUserDetails> AWS_IAM_USER_FIELD = SdkField
            .<AwsIamUserDetails> builder(MarshallingType.SDK_POJO).memberName("AwsIamUser")
            .getter(getter(ResourceDetails::awsIamUser)).setter(setter(Builder::awsIamUser))
            .constructor(AwsIamUserDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsIamUser").build()).build();

    private static final SdkField<AwsIamPolicyDetails> AWS_IAM_POLICY_FIELD = SdkField
            .<AwsIamPolicyDetails> builder(MarshallingType.SDK_POJO).memberName("AwsIamPolicy")
            .getter(getter(ResourceDetails::awsIamPolicy)).setter(setter(Builder::awsIamPolicy))
            .constructor(AwsIamPolicyDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsIamPolicy").build()).build();

    private static final SdkField<AwsApiGatewayV2StageDetails> AWS_API_GATEWAY_V2_STAGE_FIELD = SdkField
            .<AwsApiGatewayV2StageDetails> builder(MarshallingType.SDK_POJO).memberName("AwsApiGatewayV2Stage")
            .getter(getter(ResourceDetails::awsApiGatewayV2Stage)).setter(setter(Builder::awsApiGatewayV2Stage))
            .constructor(AwsApiGatewayV2StageDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsApiGatewayV2Stage").build())
            .build();

    private static final SdkField<AwsApiGatewayV2ApiDetails> AWS_API_GATEWAY_V2_API_FIELD = SdkField
            .<AwsApiGatewayV2ApiDetails> builder(MarshallingType.SDK_POJO).memberName("AwsApiGatewayV2Api")
            .getter(getter(ResourceDetails::awsApiGatewayV2Api)).setter(setter(Builder::awsApiGatewayV2Api))
            .constructor(AwsApiGatewayV2ApiDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsApiGatewayV2Api").build())
            .build();

    private static final SdkField<AwsDynamoDbTableDetails> AWS_DYNAMO_DB_TABLE_FIELD = SdkField
            .<AwsDynamoDbTableDetails> builder(MarshallingType.SDK_POJO).memberName("AwsDynamoDbTable")
            .getter(getter(ResourceDetails::awsDynamoDbTable)).setter(setter(Builder::awsDynamoDbTable))
            .constructor(AwsDynamoDbTableDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsDynamoDbTable").build()).build();

    private static final SdkField<AwsApiGatewayStageDetails> AWS_API_GATEWAY_STAGE_FIELD = SdkField
            .<AwsApiGatewayStageDetails> builder(MarshallingType.SDK_POJO).memberName("AwsApiGatewayStage")
            .getter(getter(ResourceDetails::awsApiGatewayStage)).setter(setter(Builder::awsApiGatewayStage))
            .constructor(AwsApiGatewayStageDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsApiGatewayStage").build())
            .build();

    private static final SdkField<AwsApiGatewayRestApiDetails> AWS_API_GATEWAY_REST_API_FIELD = SdkField
            .<AwsApiGatewayRestApiDetails> builder(MarshallingType.SDK_POJO).memberName("AwsApiGatewayRestApi")
            .getter(getter(ResourceDetails::awsApiGatewayRestApi)).setter(setter(Builder::awsApiGatewayRestApi))
            .constructor(AwsApiGatewayRestApiDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsApiGatewayRestApi").build())
            .build();

    private static final SdkField<AwsCloudTrailTrailDetails> AWS_CLOUD_TRAIL_TRAIL_FIELD = SdkField
            .<AwsCloudTrailTrailDetails> builder(MarshallingType.SDK_POJO).memberName("AwsCloudTrailTrail")
            .getter(getter(ResourceDetails::awsCloudTrailTrail)).setter(setter(Builder::awsCloudTrailTrail))
            .constructor(AwsCloudTrailTrailDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsCloudTrailTrail").build())
            .build();

    private static final SdkField<AwsSsmPatchComplianceDetails> AWS_SSM_PATCH_COMPLIANCE_FIELD = SdkField
            .<AwsSsmPatchComplianceDetails> builder(MarshallingType.SDK_POJO).memberName("AwsSsmPatchCompliance")
            .getter(getter(ResourceDetails::awsSsmPatchCompliance)).setter(setter(Builder::awsSsmPatchCompliance))
            .constructor(AwsSsmPatchComplianceDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsSsmPatchCompliance").build())
            .build();

    private static final SdkField<AwsCertificateManagerCertificateDetails> AWS_CERTIFICATE_MANAGER_CERTIFICATE_FIELD = SdkField
            .<AwsCertificateManagerCertificateDetails> builder(MarshallingType.SDK_POJO)
            .memberName("AwsCertificateManagerCertificate")
            .getter(getter(ResourceDetails::awsCertificateManagerCertificate))
            .setter(setter(Builder::awsCertificateManagerCertificate))
            .constructor(AwsCertificateManagerCertificateDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsCertificateManagerCertificate")
                    .build()).build();

    private static final SdkField<AwsRedshiftClusterDetails> AWS_REDSHIFT_CLUSTER_FIELD = SdkField
            .<AwsRedshiftClusterDetails> builder(MarshallingType.SDK_POJO).memberName("AwsRedshiftCluster")
            .getter(getter(ResourceDetails::awsRedshiftCluster)).setter(setter(Builder::awsRedshiftCluster))
            .constructor(AwsRedshiftClusterDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsRedshiftCluster").build())
            .build();

    private static final SdkField<AwsElbLoadBalancerDetails> AWS_ELB_LOAD_BALANCER_FIELD = SdkField
            .<AwsElbLoadBalancerDetails> builder(MarshallingType.SDK_POJO).memberName("AwsElbLoadBalancer")
            .getter(getter(ResourceDetails::awsElbLoadBalancer)).setter(setter(Builder::awsElbLoadBalancer))
            .constructor(AwsElbLoadBalancerDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsElbLoadBalancer").build())
            .build();

    private static final SdkField<AwsIamGroupDetails> AWS_IAM_GROUP_FIELD = SdkField
            .<AwsIamGroupDetails> builder(MarshallingType.SDK_POJO).memberName("AwsIamGroup")
            .getter(getter(ResourceDetails::awsIamGroup)).setter(setter(Builder::awsIamGroup))
            .constructor(AwsIamGroupDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsIamGroup").build()).build();

    private static final SdkField<AwsIamRoleDetails> AWS_IAM_ROLE_FIELD = SdkField
            .<AwsIamRoleDetails> builder(MarshallingType.SDK_POJO).memberName("AwsIamRole")
            .getter(getter(ResourceDetails::awsIamRole)).setter(setter(Builder::awsIamRole))
            .constructor(AwsIamRoleDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsIamRole").build()).build();

    private static final SdkField<AwsKmsKeyDetails> AWS_KMS_KEY_FIELD = SdkField
            .<AwsKmsKeyDetails> builder(MarshallingType.SDK_POJO).memberName("AwsKmsKey")
            .getter(getter(ResourceDetails::awsKmsKey)).setter(setter(Builder::awsKmsKey)).constructor(AwsKmsKeyDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsKmsKey").build()).build();

    private static final SdkField<AwsLambdaFunctionDetails> AWS_LAMBDA_FUNCTION_FIELD = SdkField
            .<AwsLambdaFunctionDetails> builder(MarshallingType.SDK_POJO).memberName("AwsLambdaFunction")
            .getter(getter(ResourceDetails::awsLambdaFunction)).setter(setter(Builder::awsLambdaFunction))
            .constructor(AwsLambdaFunctionDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsLambdaFunction").build()).build();

    private static final SdkField<AwsLambdaLayerVersionDetails> AWS_LAMBDA_LAYER_VERSION_FIELD = SdkField
            .<AwsLambdaLayerVersionDetails> builder(MarshallingType.SDK_POJO).memberName("AwsLambdaLayerVersion")
            .getter(getter(ResourceDetails::awsLambdaLayerVersion)).setter(setter(Builder::awsLambdaLayerVersion))
            .constructor(AwsLambdaLayerVersionDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsLambdaLayerVersion").build())
            .build();

    private static final SdkField<AwsRdsDbInstanceDetails> AWS_RDS_DB_INSTANCE_FIELD = SdkField
            .<AwsRdsDbInstanceDetails> builder(MarshallingType.SDK_POJO).memberName("AwsRdsDbInstance")
            .getter(getter(ResourceDetails::awsRdsDbInstance)).setter(setter(Builder::awsRdsDbInstance))
            .constructor(AwsRdsDbInstanceDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsRdsDbInstance").build()).build();

    private static final SdkField<AwsSnsTopicDetails> AWS_SNS_TOPIC_FIELD = SdkField
            .<AwsSnsTopicDetails> builder(MarshallingType.SDK_POJO).memberName("AwsSnsTopic")
            .getter(getter(ResourceDetails::awsSnsTopic)).setter(setter(Builder::awsSnsTopic))
            .constructor(AwsSnsTopicDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsSnsTopic").build()).build();

    private static final SdkField<AwsSqsQueueDetails> AWS_SQS_QUEUE_FIELD = SdkField
            .<AwsSqsQueueDetails> builder(MarshallingType.SDK_POJO).memberName("AwsSqsQueue")
            .getter(getter(ResourceDetails::awsSqsQueue)).setter(setter(Builder::awsSqsQueue))
            .constructor(AwsSqsQueueDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsSqsQueue").build()).build();

    private static final SdkField<AwsWafWebAclDetails> AWS_WAF_WEB_ACL_FIELD = SdkField
            .<AwsWafWebAclDetails> builder(MarshallingType.SDK_POJO).memberName("AwsWafWebAcl")
            .getter(getter(ResourceDetails::awsWafWebAcl)).setter(setter(Builder::awsWafWebAcl))
            .constructor(AwsWafWebAclDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsWafWebAcl").build()).build();

    private static final SdkField<AwsRdsDbSnapshotDetails> AWS_RDS_DB_SNAPSHOT_FIELD = SdkField
            .<AwsRdsDbSnapshotDetails> builder(MarshallingType.SDK_POJO).memberName("AwsRdsDbSnapshot")
            .getter(getter(ResourceDetails::awsRdsDbSnapshot)).setter(setter(Builder::awsRdsDbSnapshot))
            .constructor(AwsRdsDbSnapshotDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsRdsDbSnapshot").build()).build();

    private static final SdkField<AwsRdsDbClusterSnapshotDetails> AWS_RDS_DB_CLUSTER_SNAPSHOT_FIELD = SdkField
            .<AwsRdsDbClusterSnapshotDetails> builder(MarshallingType.SDK_POJO).memberName("AwsRdsDbClusterSnapshot")
            .getter(getter(ResourceDetails::awsRdsDbClusterSnapshot)).setter(setter(Builder::awsRdsDbClusterSnapshot))
            .constructor(AwsRdsDbClusterSnapshotDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsRdsDbClusterSnapshot").build())
            .build();

    private static final SdkField<AwsRdsDbClusterDetails> AWS_RDS_DB_CLUSTER_FIELD = SdkField
            .<AwsRdsDbClusterDetails> builder(MarshallingType.SDK_POJO).memberName("AwsRdsDbCluster")
            .getter(getter(ResourceDetails::awsRdsDbCluster)).setter(setter(Builder::awsRdsDbCluster))
            .constructor(AwsRdsDbClusterDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsRdsDbCluster").build()).build();

    private static final SdkField<AwsEcsClusterDetails> AWS_ECS_CLUSTER_FIELD = SdkField
            .<AwsEcsClusterDetails> builder(MarshallingType.SDK_POJO).memberName("AwsEcsCluster")
            .getter(getter(ResourceDetails::awsEcsCluster)).setter(setter(Builder::awsEcsCluster))
            .constructor(AwsEcsClusterDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsEcsCluster").build()).build();

    private static final SdkField<AwsEcsContainerDetails> AWS_ECS_CONTAINER_FIELD = SdkField
            .<AwsEcsContainerDetails> builder(MarshallingType.SDK_POJO).memberName("AwsEcsContainer")
            .getter(getter(ResourceDetails::awsEcsContainer)).setter(setter(Builder::awsEcsContainer))
            .constructor(AwsEcsContainerDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsEcsContainer").build()).build();

    private static final SdkField<AwsEcsTaskDefinitionDetails> AWS_ECS_TASK_DEFINITION_FIELD = SdkField
            .<AwsEcsTaskDefinitionDetails> builder(MarshallingType.SDK_POJO).memberName("AwsEcsTaskDefinition")
            .getter(getter(ResourceDetails::awsEcsTaskDefinition)).setter(setter(Builder::awsEcsTaskDefinition))
            .constructor(AwsEcsTaskDefinitionDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsEcsTaskDefinition").build())
            .build();

    private static final SdkField<ContainerDetails> CONTAINER_FIELD = SdkField
            .<ContainerDetails> builder(MarshallingType.SDK_POJO).memberName("Container")
            .getter(getter(ResourceDetails::container)).setter(setter(Builder::container)).constructor(ContainerDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Container").build()).build();

    private static final SdkField<Map<String, String>> OTHER_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Other")
            .getter(getter(ResourceDetails::other))
            .setter(setter(Builder::other))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Other").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<AwsRdsEventSubscriptionDetails> AWS_RDS_EVENT_SUBSCRIPTION_FIELD = SdkField
            .<AwsRdsEventSubscriptionDetails> builder(MarshallingType.SDK_POJO).memberName("AwsRdsEventSubscription")
            .getter(getter(ResourceDetails::awsRdsEventSubscription)).setter(setter(Builder::awsRdsEventSubscription))
            .constructor(AwsRdsEventSubscriptionDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsRdsEventSubscription").build())
            .build();

    private static final SdkField<AwsEcsServiceDetails> AWS_ECS_SERVICE_FIELD = SdkField
            .<AwsEcsServiceDetails> builder(MarshallingType.SDK_POJO).memberName("AwsEcsService")
            .getter(getter(ResourceDetails::awsEcsService)).setter(setter(Builder::awsEcsService))
            .constructor(AwsEcsServiceDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsEcsService").build()).build();

    private static final SdkField<AwsAutoScalingLaunchConfigurationDetails> AWS_AUTO_SCALING_LAUNCH_CONFIGURATION_FIELD = SdkField
            .<AwsAutoScalingLaunchConfigurationDetails> builder(MarshallingType.SDK_POJO)
            .memberName("AwsAutoScalingLaunchConfiguration")
            .getter(getter(ResourceDetails::awsAutoScalingLaunchConfiguration))
            .setter(setter(Builder::awsAutoScalingLaunchConfiguration))
            .constructor(AwsAutoScalingLaunchConfigurationDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsAutoScalingLaunchConfiguration")
                    .build()).build();

    private static final SdkField<AwsEc2VpnConnectionDetails> AWS_EC2_VPN_CONNECTION_FIELD = SdkField
            .<AwsEc2VpnConnectionDetails> builder(MarshallingType.SDK_POJO).memberName("AwsEc2VpnConnection")
            .getter(getter(ResourceDetails::awsEc2VpnConnection)).setter(setter(Builder::awsEc2VpnConnection))
            .constructor(AwsEc2VpnConnectionDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsEc2VpnConnection").build())
            .build();

    private static final SdkField<AwsEcrContainerImageDetails> AWS_ECR_CONTAINER_IMAGE_FIELD = SdkField
            .<AwsEcrContainerImageDetails> builder(MarshallingType.SDK_POJO).memberName("AwsEcrContainerImage")
            .getter(getter(ResourceDetails::awsEcrContainerImage)).setter(setter(Builder::awsEcrContainerImage))
            .constructor(AwsEcrContainerImageDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsEcrContainerImage").build())
            .build();

    private static final SdkField<AwsOpenSearchServiceDomainDetails> AWS_OPEN_SEARCH_SERVICE_DOMAIN_FIELD = SdkField
            .<AwsOpenSearchServiceDomainDetails> builder(MarshallingType.SDK_POJO)
            .memberName("AwsOpenSearchServiceDomain")
            .getter(getter(ResourceDetails::awsOpenSearchServiceDomain))
            .setter(setter(Builder::awsOpenSearchServiceDomain))
            .constructor(AwsOpenSearchServiceDomainDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsOpenSearchServiceDomain").build())
            .build();

    private static final SdkField<AwsEc2VpcEndpointServiceDetails> AWS_EC2_VPC_ENDPOINT_SERVICE_FIELD = SdkField
            .<AwsEc2VpcEndpointServiceDetails> builder(MarshallingType.SDK_POJO).memberName("AwsEc2VpcEndpointService")
            .getter(getter(ResourceDetails::awsEc2VpcEndpointService)).setter(setter(Builder::awsEc2VpcEndpointService))
            .constructor(AwsEc2VpcEndpointServiceDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsEc2VpcEndpointService").build())
            .build();

    private static final SdkField<AwsXrayEncryptionConfigDetails> AWS_XRAY_ENCRYPTION_CONFIG_FIELD = SdkField
            .<AwsXrayEncryptionConfigDetails> builder(MarshallingType.SDK_POJO).memberName("AwsXrayEncryptionConfig")
            .getter(getter(ResourceDetails::awsXrayEncryptionConfig)).setter(setter(Builder::awsXrayEncryptionConfig))
            .constructor(AwsXrayEncryptionConfigDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsXrayEncryptionConfig").build())
            .build();

    private static final SdkField<AwsWafRateBasedRuleDetails> AWS_WAF_RATE_BASED_RULE_FIELD = SdkField
            .<AwsWafRateBasedRuleDetails> builder(MarshallingType.SDK_POJO).memberName("AwsWafRateBasedRule")
            .getter(getter(ResourceDetails::awsWafRateBasedRule)).setter(setter(Builder::awsWafRateBasedRule))
            .constructor(AwsWafRateBasedRuleDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsWafRateBasedRule").build())
            .build();

    private static final SdkField<AwsWafRegionalRateBasedRuleDetails> AWS_WAF_REGIONAL_RATE_BASED_RULE_FIELD = SdkField
            .<AwsWafRegionalRateBasedRuleDetails> builder(MarshallingType.SDK_POJO)
            .memberName("AwsWafRegionalRateBasedRule")
            .getter(getter(ResourceDetails::awsWafRegionalRateBasedRule))
            .setter(setter(Builder::awsWafRegionalRateBasedRule))
            .constructor(AwsWafRegionalRateBasedRuleDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsWafRegionalRateBasedRule")
                    .build()).build();

    private static final SdkField<AwsEcrRepositoryDetails> AWS_ECR_REPOSITORY_FIELD = SdkField
            .<AwsEcrRepositoryDetails> builder(MarshallingType.SDK_POJO).memberName("AwsEcrRepository")
            .getter(getter(ResourceDetails::awsEcrRepository)).setter(setter(Builder::awsEcrRepository))
            .constructor(AwsEcrRepositoryDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsEcrRepository").build()).build();

    private static final SdkField<AwsEksClusterDetails> AWS_EKS_CLUSTER_FIELD = SdkField
            .<AwsEksClusterDetails> builder(MarshallingType.SDK_POJO).memberName("AwsEksCluster")
            .getter(getter(ResourceDetails::awsEksCluster)).setter(setter(Builder::awsEksCluster))
            .constructor(AwsEksClusterDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsEksCluster").build()).build();

    private static final SdkField<AwsNetworkFirewallFirewallPolicyDetails> AWS_NETWORK_FIREWALL_FIREWALL_POLICY_FIELD = SdkField
            .<AwsNetworkFirewallFirewallPolicyDetails> builder(MarshallingType.SDK_POJO)
            .memberName("AwsNetworkFirewallFirewallPolicy")
            .getter(getter(ResourceDetails::awsNetworkFirewallFirewallPolicy))
            .setter(setter(Builder::awsNetworkFirewallFirewallPolicy))
            .constructor(AwsNetworkFirewallFirewallPolicyDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsNetworkFirewallFirewallPolicy")
                    .build()).build();

    private static final SdkField<AwsNetworkFirewallFirewallDetails> AWS_NETWORK_FIREWALL_FIREWALL_FIELD = SdkField
            .<AwsNetworkFirewallFirewallDetails> builder(MarshallingType.SDK_POJO)
            .memberName("AwsNetworkFirewallFirewall")
            .getter(getter(ResourceDetails::awsNetworkFirewallFirewall))
            .setter(setter(Builder::awsNetworkFirewallFirewall))
            .constructor(AwsNetworkFirewallFirewallDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsNetworkFirewallFirewall").build())
            .build();

    private static final SdkField<AwsNetworkFirewallRuleGroupDetails> AWS_NETWORK_FIREWALL_RULE_GROUP_FIELD = SdkField
            .<AwsNetworkFirewallRuleGroupDetails> builder(MarshallingType.SDK_POJO)
            .memberName("AwsNetworkFirewallRuleGroup")
            .getter(getter(ResourceDetails::awsNetworkFirewallRuleGroup))
            .setter(setter(Builder::awsNetworkFirewallRuleGroup))
            .constructor(AwsNetworkFirewallRuleGroupDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsNetworkFirewallRuleGroup")
                    .build()).build();

    private static final SdkField<AwsRdsDbSecurityGroupDetails> AWS_RDS_DB_SECURITY_GROUP_FIELD = SdkField
            .<AwsRdsDbSecurityGroupDetails> builder(MarshallingType.SDK_POJO).memberName("AwsRdsDbSecurityGroup")
            .getter(getter(ResourceDetails::awsRdsDbSecurityGroup)).setter(setter(Builder::awsRdsDbSecurityGroup))
            .constructor(AwsRdsDbSecurityGroupDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsRdsDbSecurityGroup").build())
            .build();

    private static final SdkField<AwsKinesisStreamDetails> AWS_KINESIS_STREAM_FIELD = SdkField
            .<AwsKinesisStreamDetails> builder(MarshallingType.SDK_POJO).memberName("AwsKinesisStream")
            .getter(getter(ResourceDetails::awsKinesisStream)).setter(setter(Builder::awsKinesisStream))
            .constructor(AwsKinesisStreamDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsKinesisStream").build()).build();

    private static final SdkField<AwsEc2TransitGatewayDetails> AWS_EC2_TRANSIT_GATEWAY_FIELD = SdkField
            .<AwsEc2TransitGatewayDetails> builder(MarshallingType.SDK_POJO).memberName("AwsEc2TransitGateway")
            .getter(getter(ResourceDetails::awsEc2TransitGateway)).setter(setter(Builder::awsEc2TransitGateway))
            .constructor(AwsEc2TransitGatewayDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsEc2TransitGateway").build())
            .build();

    private static final SdkField<AwsEfsAccessPointDetails> AWS_EFS_ACCESS_POINT_FIELD = SdkField
            .<AwsEfsAccessPointDetails> builder(MarshallingType.SDK_POJO).memberName("AwsEfsAccessPoint")
            .getter(getter(ResourceDetails::awsEfsAccessPoint)).setter(setter(Builder::awsEfsAccessPoint))
            .constructor(AwsEfsAccessPointDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsEfsAccessPoint").build()).build();

    private static final SdkField<AwsCloudFormationStackDetails> AWS_CLOUD_FORMATION_STACK_FIELD = SdkField
            .<AwsCloudFormationStackDetails> builder(MarshallingType.SDK_POJO).memberName("AwsCloudFormationStack")
            .getter(getter(ResourceDetails::awsCloudFormationStack)).setter(setter(Builder::awsCloudFormationStack))
            .constructor(AwsCloudFormationStackDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsCloudFormationStack").build())
            .build();

    private static final SdkField<AwsCloudWatchAlarmDetails> AWS_CLOUD_WATCH_ALARM_FIELD = SdkField
            .<AwsCloudWatchAlarmDetails> builder(MarshallingType.SDK_POJO).memberName("AwsCloudWatchAlarm")
            .getter(getter(ResourceDetails::awsCloudWatchAlarm)).setter(setter(Builder::awsCloudWatchAlarm))
            .constructor(AwsCloudWatchAlarmDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsCloudWatchAlarm").build())
            .build();

    private static final SdkField<AwsEc2VpcPeeringConnectionDetails> AWS_EC2_VPC_PEERING_CONNECTION_FIELD = SdkField
            .<AwsEc2VpcPeeringConnectionDetails> builder(MarshallingType.SDK_POJO)
            .memberName("AwsEc2VpcPeeringConnection")
            .getter(getter(ResourceDetails::awsEc2VpcPeeringConnection))
            .setter(setter(Builder::awsEc2VpcPeeringConnection))
            .constructor(AwsEc2VpcPeeringConnectionDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsEc2VpcPeeringConnection").build())
            .build();

    private static final SdkField<AwsWafRegionalRuleGroupDetails> AWS_WAF_REGIONAL_RULE_GROUP_FIELD = SdkField
            .<AwsWafRegionalRuleGroupDetails> builder(MarshallingType.SDK_POJO).memberName("AwsWafRegionalRuleGroup")
            .getter(getter(ResourceDetails::awsWafRegionalRuleGroup)).setter(setter(Builder::awsWafRegionalRuleGroup))
            .constructor(AwsWafRegionalRuleGroupDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsWafRegionalRuleGroup").build())
            .build();

    private static final SdkField<AwsWafRegionalRuleDetails> AWS_WAF_REGIONAL_RULE_FIELD = SdkField
            .<AwsWafRegionalRuleDetails> builder(MarshallingType.SDK_POJO).memberName("AwsWafRegionalRule")
            .getter(getter(ResourceDetails::awsWafRegionalRule)).setter(setter(Builder::awsWafRegionalRule))
            .constructor(AwsWafRegionalRuleDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsWafRegionalRule").build())
            .build();

    private static final SdkField<AwsWafRegionalWebAclDetails> AWS_WAF_REGIONAL_WEB_ACL_FIELD = SdkField
            .<AwsWafRegionalWebAclDetails> builder(MarshallingType.SDK_POJO).memberName("AwsWafRegionalWebAcl")
            .getter(getter(ResourceDetails::awsWafRegionalWebAcl)).setter(setter(Builder::awsWafRegionalWebAcl))
            .constructor(AwsWafRegionalWebAclDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsWafRegionalWebAcl").build())
            .build();

    private static final SdkField<AwsWafRuleDetails> AWS_WAF_RULE_FIELD = SdkField
            .<AwsWafRuleDetails> builder(MarshallingType.SDK_POJO).memberName("AwsWafRule")
            .getter(getter(ResourceDetails::awsWafRule)).setter(setter(Builder::awsWafRule))
            .constructor(AwsWafRuleDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsWafRule").build()).build();

    private static final SdkField<AwsWafRuleGroupDetails> AWS_WAF_RULE_GROUP_FIELD = SdkField
            .<AwsWafRuleGroupDetails> builder(MarshallingType.SDK_POJO).memberName("AwsWafRuleGroup")
            .getter(getter(ResourceDetails::awsWafRuleGroup)).setter(setter(Builder::awsWafRuleGroup))
            .constructor(AwsWafRuleGroupDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsWafRuleGroup").build()).build();

    private static final SdkField<AwsEcsTaskDetails> AWS_ECS_TASK_FIELD = SdkField
            .<AwsEcsTaskDetails> builder(MarshallingType.SDK_POJO).memberName("AwsEcsTask")
            .getter(getter(ResourceDetails::awsEcsTask)).setter(setter(Builder::awsEcsTask))
            .constructor(AwsEcsTaskDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsEcsTask").build()).build();

    private static final SdkField<AwsBackupBackupVaultDetails> AWS_BACKUP_BACKUP_VAULT_FIELD = SdkField
            .<AwsBackupBackupVaultDetails> builder(MarshallingType.SDK_POJO).memberName("AwsBackupBackupVault")
            .getter(getter(ResourceDetails::awsBackupBackupVault)).setter(setter(Builder::awsBackupBackupVault))
            .constructor(AwsBackupBackupVaultDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsBackupBackupVault").build())
            .build();

    private static final SdkField<AwsBackupBackupPlanDetails> AWS_BACKUP_BACKUP_PLAN_FIELD = SdkField
            .<AwsBackupBackupPlanDetails> builder(MarshallingType.SDK_POJO).memberName("AwsBackupBackupPlan")
            .getter(getter(ResourceDetails::awsBackupBackupPlan)).setter(setter(Builder::awsBackupBackupPlan))
            .constructor(AwsBackupBackupPlanDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsBackupBackupPlan").build())
            .build();

    private static final SdkField<AwsBackupRecoveryPointDetails> AWS_BACKUP_RECOVERY_POINT_FIELD = SdkField
            .<AwsBackupRecoveryPointDetails> builder(MarshallingType.SDK_POJO).memberName("AwsBackupRecoveryPoint")
            .getter(getter(ResourceDetails::awsBackupRecoveryPoint)).setter(setter(Builder::awsBackupRecoveryPoint))
            .constructor(AwsBackupRecoveryPointDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsBackupRecoveryPoint").build())
            .build();

    private static final SdkField<AwsEc2LaunchTemplateDetails> AWS_EC2_LAUNCH_TEMPLATE_FIELD = SdkField
            .<AwsEc2LaunchTemplateDetails> builder(MarshallingType.SDK_POJO).memberName("AwsEc2LaunchTemplate")
            .getter(getter(ResourceDetails::awsEc2LaunchTemplate)).setter(setter(Builder::awsEc2LaunchTemplate))
            .constructor(AwsEc2LaunchTemplateDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsEc2LaunchTemplate").build())
            .build();

    private static final SdkField<AwsSageMakerNotebookInstanceDetails> AWS_SAGE_MAKER_NOTEBOOK_INSTANCE_FIELD = SdkField
            .<AwsSageMakerNotebookInstanceDetails> builder(MarshallingType.SDK_POJO)
            .memberName("AwsSageMakerNotebookInstance")
            .getter(getter(ResourceDetails::awsSageMakerNotebookInstance))
            .setter(setter(Builder::awsSageMakerNotebookInstance))
            .constructor(AwsSageMakerNotebookInstanceDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsSageMakerNotebookInstance")
                    .build()).build();

    private static final SdkField<AwsWafv2WebAclDetails> AWS_WAFV2_WEB_ACL_FIELD = SdkField
            .<AwsWafv2WebAclDetails> builder(MarshallingType.SDK_POJO).memberName("AwsWafv2WebAcl")
            .getter(getter(ResourceDetails::awsWafv2WebAcl)).setter(setter(Builder::awsWafv2WebAcl))
            .constructor(AwsWafv2WebAclDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsWafv2WebAcl").build()).build();

    private static final SdkField<AwsWafv2RuleGroupDetails> AWS_WAFV2_RULE_GROUP_FIELD = SdkField
            .<AwsWafv2RuleGroupDetails> builder(MarshallingType.SDK_POJO).memberName("AwsWafv2RuleGroup")
            .getter(getter(ResourceDetails::awsWafv2RuleGroup)).setter(setter(Builder::awsWafv2RuleGroup))
            .constructor(AwsWafv2RuleGroupDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsWafv2RuleGroup").build()).build();

    private static final SdkField<AwsEc2RouteTableDetails> AWS_EC2_ROUTE_TABLE_FIELD = SdkField
            .<AwsEc2RouteTableDetails> builder(MarshallingType.SDK_POJO).memberName("AwsEc2RouteTable")
            .getter(getter(ResourceDetails::awsEc2RouteTable)).setter(setter(Builder::awsEc2RouteTable))
            .constructor(AwsEc2RouteTableDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsEc2RouteTable").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            AWS_AUTO_SCALING_AUTO_SCALING_GROUP_FIELD, AWS_CODE_BUILD_PROJECT_FIELD, AWS_CLOUD_FRONT_DISTRIBUTION_FIELD,
            AWS_EC2_INSTANCE_FIELD, AWS_EC2_NETWORK_INTERFACE_FIELD, AWS_EC2_SECURITY_GROUP_FIELD, AWS_EC2_VOLUME_FIELD,
            AWS_EC2_VPC_FIELD, AWS_EC2_EIP_FIELD, AWS_EC2_SUBNET_FIELD, AWS_EC2_NETWORK_ACL_FIELD, AWS_ELBV2_LOAD_BALANCER_FIELD,
            AWS_ELASTIC_BEANSTALK_ENVIRONMENT_FIELD, AWS_ELASTICSEARCH_DOMAIN_FIELD, AWS_S3_BUCKET_FIELD,
            AWS_S3_ACCOUNT_PUBLIC_ACCESS_BLOCK_FIELD, AWS_S3_OBJECT_FIELD, AWS_SECRETS_MANAGER_SECRET_FIELD,
            AWS_IAM_ACCESS_KEY_FIELD, AWS_IAM_USER_FIELD, AWS_IAM_POLICY_FIELD, AWS_API_GATEWAY_V2_STAGE_FIELD,
            AWS_API_GATEWAY_V2_API_FIELD, AWS_DYNAMO_DB_TABLE_FIELD, AWS_API_GATEWAY_STAGE_FIELD, AWS_API_GATEWAY_REST_API_FIELD,
            AWS_CLOUD_TRAIL_TRAIL_FIELD, AWS_SSM_PATCH_COMPLIANCE_FIELD, AWS_CERTIFICATE_MANAGER_CERTIFICATE_FIELD,
            AWS_REDSHIFT_CLUSTER_FIELD, AWS_ELB_LOAD_BALANCER_FIELD, AWS_IAM_GROUP_FIELD, AWS_IAM_ROLE_FIELD, AWS_KMS_KEY_FIELD,
            AWS_LAMBDA_FUNCTION_FIELD, AWS_LAMBDA_LAYER_VERSION_FIELD, AWS_RDS_DB_INSTANCE_FIELD, AWS_SNS_TOPIC_FIELD,
            AWS_SQS_QUEUE_FIELD, AWS_WAF_WEB_ACL_FIELD, AWS_RDS_DB_SNAPSHOT_FIELD, AWS_RDS_DB_CLUSTER_SNAPSHOT_FIELD,
            AWS_RDS_DB_CLUSTER_FIELD, AWS_ECS_CLUSTER_FIELD, AWS_ECS_CONTAINER_FIELD, AWS_ECS_TASK_DEFINITION_FIELD,
            CONTAINER_FIELD, OTHER_FIELD, AWS_RDS_EVENT_SUBSCRIPTION_FIELD, AWS_ECS_SERVICE_FIELD,
            AWS_AUTO_SCALING_LAUNCH_CONFIGURATION_FIELD, AWS_EC2_VPN_CONNECTION_FIELD, AWS_ECR_CONTAINER_IMAGE_FIELD,
            AWS_OPEN_SEARCH_SERVICE_DOMAIN_FIELD, AWS_EC2_VPC_ENDPOINT_SERVICE_FIELD, AWS_XRAY_ENCRYPTION_CONFIG_FIELD,
            AWS_WAF_RATE_BASED_RULE_FIELD, AWS_WAF_REGIONAL_RATE_BASED_RULE_FIELD, AWS_ECR_REPOSITORY_FIELD,
            AWS_EKS_CLUSTER_FIELD, AWS_NETWORK_FIREWALL_FIREWALL_POLICY_FIELD, AWS_NETWORK_FIREWALL_FIREWALL_FIELD,
            AWS_NETWORK_FIREWALL_RULE_GROUP_FIELD, AWS_RDS_DB_SECURITY_GROUP_FIELD, AWS_KINESIS_STREAM_FIELD,
            AWS_EC2_TRANSIT_GATEWAY_FIELD, AWS_EFS_ACCESS_POINT_FIELD, AWS_CLOUD_FORMATION_STACK_FIELD,
            AWS_CLOUD_WATCH_ALARM_FIELD, AWS_EC2_VPC_PEERING_CONNECTION_FIELD, AWS_WAF_REGIONAL_RULE_GROUP_FIELD,
            AWS_WAF_REGIONAL_RULE_FIELD, AWS_WAF_REGIONAL_WEB_ACL_FIELD, AWS_WAF_RULE_FIELD, AWS_WAF_RULE_GROUP_FIELD,
            AWS_ECS_TASK_FIELD, AWS_BACKUP_BACKUP_VAULT_FIELD, AWS_BACKUP_BACKUP_PLAN_FIELD, AWS_BACKUP_RECOVERY_POINT_FIELD,
            AWS_EC2_LAUNCH_TEMPLATE_FIELD, AWS_SAGE_MAKER_NOTEBOOK_INSTANCE_FIELD, AWS_WAFV2_WEB_ACL_FIELD,
            AWS_WAFV2_RULE_GROUP_FIELD, AWS_EC2_ROUTE_TABLE_FIELD));

    private static final long serialVersionUID = 1L;

    private final AwsAutoScalingAutoScalingGroupDetails awsAutoScalingAutoScalingGroup;

    private final AwsCodeBuildProjectDetails awsCodeBuildProject;

    private final AwsCloudFrontDistributionDetails awsCloudFrontDistribution;

    private final AwsEc2InstanceDetails awsEc2Instance;

    private final AwsEc2NetworkInterfaceDetails awsEc2NetworkInterface;

    private final AwsEc2SecurityGroupDetails awsEc2SecurityGroup;

    private final AwsEc2VolumeDetails awsEc2Volume;

    private final AwsEc2VpcDetails awsEc2Vpc;

    private final AwsEc2EipDetails awsEc2Eip;

    private final AwsEc2SubnetDetails awsEc2Subnet;

    private final AwsEc2NetworkAclDetails awsEc2NetworkAcl;

    private final AwsElbv2LoadBalancerDetails awsElbv2LoadBalancer;

    private final AwsElasticBeanstalkEnvironmentDetails awsElasticBeanstalkEnvironment;

    private final AwsElasticsearchDomainDetails awsElasticsearchDomain;

    private final AwsS3BucketDetails awsS3Bucket;

    private final AwsS3AccountPublicAccessBlockDetails awsS3AccountPublicAccessBlock;

    private final AwsS3ObjectDetails awsS3Object;

    private final AwsSecretsManagerSecretDetails awsSecretsManagerSecret;

    private final AwsIamAccessKeyDetails awsIamAccessKey;

    private final AwsIamUserDetails awsIamUser;

    private final AwsIamPolicyDetails awsIamPolicy;

    private final AwsApiGatewayV2StageDetails awsApiGatewayV2Stage;

    private final AwsApiGatewayV2ApiDetails awsApiGatewayV2Api;

    private final AwsDynamoDbTableDetails awsDynamoDbTable;

    private final AwsApiGatewayStageDetails awsApiGatewayStage;

    private final AwsApiGatewayRestApiDetails awsApiGatewayRestApi;

    private final AwsCloudTrailTrailDetails awsCloudTrailTrail;

    private final AwsSsmPatchComplianceDetails awsSsmPatchCompliance;

    private final AwsCertificateManagerCertificateDetails awsCertificateManagerCertificate;

    private final AwsRedshiftClusterDetails awsRedshiftCluster;

    private final AwsElbLoadBalancerDetails awsElbLoadBalancer;

    private final AwsIamGroupDetails awsIamGroup;

    private final AwsIamRoleDetails awsIamRole;

    private final AwsKmsKeyDetails awsKmsKey;

    private final AwsLambdaFunctionDetails awsLambdaFunction;

    private final AwsLambdaLayerVersionDetails awsLambdaLayerVersion;

    private final AwsRdsDbInstanceDetails awsRdsDbInstance;

    private final AwsSnsTopicDetails awsSnsTopic;

    private final AwsSqsQueueDetails awsSqsQueue;

    private final AwsWafWebAclDetails awsWafWebAcl;

    private final AwsRdsDbSnapshotDetails awsRdsDbSnapshot;

    private final AwsRdsDbClusterSnapshotDetails awsRdsDbClusterSnapshot;

    private final AwsRdsDbClusterDetails awsRdsDbCluster;

    private final AwsEcsClusterDetails awsEcsCluster;

    private final AwsEcsContainerDetails awsEcsContainer;

    private final AwsEcsTaskDefinitionDetails awsEcsTaskDefinition;

    private final ContainerDetails container;

    private final Map<String, String> other;

    private final AwsRdsEventSubscriptionDetails awsRdsEventSubscription;

    private final AwsEcsServiceDetails awsEcsService;

    private final AwsAutoScalingLaunchConfigurationDetails awsAutoScalingLaunchConfiguration;

    private final AwsEc2VpnConnectionDetails awsEc2VpnConnection;

    private final AwsEcrContainerImageDetails awsEcrContainerImage;

    private final AwsOpenSearchServiceDomainDetails awsOpenSearchServiceDomain;

    private final AwsEc2VpcEndpointServiceDetails awsEc2VpcEndpointService;

    private final AwsXrayEncryptionConfigDetails awsXrayEncryptionConfig;

    private final AwsWafRateBasedRuleDetails awsWafRateBasedRule;

    private final AwsWafRegionalRateBasedRuleDetails awsWafRegionalRateBasedRule;

    private final AwsEcrRepositoryDetails awsEcrRepository;

    private final AwsEksClusterDetails awsEksCluster;

    private final AwsNetworkFirewallFirewallPolicyDetails awsNetworkFirewallFirewallPolicy;

    private final AwsNetworkFirewallFirewallDetails awsNetworkFirewallFirewall;

    private final AwsNetworkFirewallRuleGroupDetails awsNetworkFirewallRuleGroup;

    private final AwsRdsDbSecurityGroupDetails awsRdsDbSecurityGroup;

    private final AwsKinesisStreamDetails awsKinesisStream;

    private final AwsEc2TransitGatewayDetails awsEc2TransitGateway;

    private final AwsEfsAccessPointDetails awsEfsAccessPoint;

    private final AwsCloudFormationStackDetails awsCloudFormationStack;

    private final AwsCloudWatchAlarmDetails awsCloudWatchAlarm;

    private final AwsEc2VpcPeeringConnectionDetails awsEc2VpcPeeringConnection;

    private final AwsWafRegionalRuleGroupDetails awsWafRegionalRuleGroup;

    private final AwsWafRegionalRuleDetails awsWafRegionalRule;

    private final AwsWafRegionalWebAclDetails awsWafRegionalWebAcl;

    private final AwsWafRuleDetails awsWafRule;

    private final AwsWafRuleGroupDetails awsWafRuleGroup;

    private final AwsEcsTaskDetails awsEcsTask;

    private final AwsBackupBackupVaultDetails awsBackupBackupVault;

    private final AwsBackupBackupPlanDetails awsBackupBackupPlan;

    private final AwsBackupRecoveryPointDetails awsBackupRecoveryPoint;

    private final AwsEc2LaunchTemplateDetails awsEc2LaunchTemplate;

    private final AwsSageMakerNotebookInstanceDetails awsSageMakerNotebookInstance;

    private final AwsWafv2WebAclDetails awsWafv2WebAcl;

    private final AwsWafv2RuleGroupDetails awsWafv2RuleGroup;

    private final AwsEc2RouteTableDetails awsEc2RouteTable;

    private ResourceDetails(BuilderImpl builder) {
        this.awsAutoScalingAutoScalingGroup = builder.awsAutoScalingAutoScalingGroup;
        this.awsCodeBuildProject = builder.awsCodeBuildProject;
        this.awsCloudFrontDistribution = builder.awsCloudFrontDistribution;
        this.awsEc2Instance = builder.awsEc2Instance;
        this.awsEc2NetworkInterface = builder.awsEc2NetworkInterface;
        this.awsEc2SecurityGroup = builder.awsEc2SecurityGroup;
        this.awsEc2Volume = builder.awsEc2Volume;
        this.awsEc2Vpc = builder.awsEc2Vpc;
        this.awsEc2Eip = builder.awsEc2Eip;
        this.awsEc2Subnet = builder.awsEc2Subnet;
        this.awsEc2NetworkAcl = builder.awsEc2NetworkAcl;
        this.awsElbv2LoadBalancer = builder.awsElbv2LoadBalancer;
        this.awsElasticBeanstalkEnvironment = builder.awsElasticBeanstalkEnvironment;
        this.awsElasticsearchDomain = builder.awsElasticsearchDomain;
        this.awsS3Bucket = builder.awsS3Bucket;
        this.awsS3AccountPublicAccessBlock = builder.awsS3AccountPublicAccessBlock;
        this.awsS3Object = builder.awsS3Object;
        this.awsSecretsManagerSecret = builder.awsSecretsManagerSecret;
        this.awsIamAccessKey = builder.awsIamAccessKey;
        this.awsIamUser = builder.awsIamUser;
        this.awsIamPolicy = builder.awsIamPolicy;
        this.awsApiGatewayV2Stage = builder.awsApiGatewayV2Stage;
        this.awsApiGatewayV2Api = builder.awsApiGatewayV2Api;
        this.awsDynamoDbTable = builder.awsDynamoDbTable;
        this.awsApiGatewayStage = builder.awsApiGatewayStage;
        this.awsApiGatewayRestApi = builder.awsApiGatewayRestApi;
        this.awsCloudTrailTrail = builder.awsCloudTrailTrail;
        this.awsSsmPatchCompliance = builder.awsSsmPatchCompliance;
        this.awsCertificateManagerCertificate = builder.awsCertificateManagerCertificate;
        this.awsRedshiftCluster = builder.awsRedshiftCluster;
        this.awsElbLoadBalancer = builder.awsElbLoadBalancer;
        this.awsIamGroup = builder.awsIamGroup;
        this.awsIamRole = builder.awsIamRole;
        this.awsKmsKey = builder.awsKmsKey;
        this.awsLambdaFunction = builder.awsLambdaFunction;
        this.awsLambdaLayerVersion = builder.awsLambdaLayerVersion;
        this.awsRdsDbInstance = builder.awsRdsDbInstance;
        this.awsSnsTopic = builder.awsSnsTopic;
        this.awsSqsQueue = builder.awsSqsQueue;
        this.awsWafWebAcl = builder.awsWafWebAcl;
        this.awsRdsDbSnapshot = builder.awsRdsDbSnapshot;
        this.awsRdsDbClusterSnapshot = builder.awsRdsDbClusterSnapshot;
        this.awsRdsDbCluster = builder.awsRdsDbCluster;
        this.awsEcsCluster = builder.awsEcsCluster;
        this.awsEcsContainer = builder.awsEcsContainer;
        this.awsEcsTaskDefinition = builder.awsEcsTaskDefinition;
        this.container = builder.container;
        this.other = builder.other;
        this.awsRdsEventSubscription = builder.awsRdsEventSubscription;
        this.awsEcsService = builder.awsEcsService;
        this.awsAutoScalingLaunchConfiguration = builder.awsAutoScalingLaunchConfiguration;
        this.awsEc2VpnConnection = builder.awsEc2VpnConnection;
        this.awsEcrContainerImage = builder.awsEcrContainerImage;
        this.awsOpenSearchServiceDomain = builder.awsOpenSearchServiceDomain;
        this.awsEc2VpcEndpointService = builder.awsEc2VpcEndpointService;
        this.awsXrayEncryptionConfig = builder.awsXrayEncryptionConfig;
        this.awsWafRateBasedRule = builder.awsWafRateBasedRule;
        this.awsWafRegionalRateBasedRule = builder.awsWafRegionalRateBasedRule;
        this.awsEcrRepository = builder.awsEcrRepository;
        this.awsEksCluster = builder.awsEksCluster;
        this.awsNetworkFirewallFirewallPolicy = builder.awsNetworkFirewallFirewallPolicy;
        this.awsNetworkFirewallFirewall = builder.awsNetworkFirewallFirewall;
        this.awsNetworkFirewallRuleGroup = builder.awsNetworkFirewallRuleGroup;
        this.awsRdsDbSecurityGroup = builder.awsRdsDbSecurityGroup;
        this.awsKinesisStream = builder.awsKinesisStream;
        this.awsEc2TransitGateway = builder.awsEc2TransitGateway;
        this.awsEfsAccessPoint = builder.awsEfsAccessPoint;
        this.awsCloudFormationStack = builder.awsCloudFormationStack;
        this.awsCloudWatchAlarm = builder.awsCloudWatchAlarm;
        this.awsEc2VpcPeeringConnection = builder.awsEc2VpcPeeringConnection;
        this.awsWafRegionalRuleGroup = builder.awsWafRegionalRuleGroup;
        this.awsWafRegionalRule = builder.awsWafRegionalRule;
        this.awsWafRegionalWebAcl = builder.awsWafRegionalWebAcl;
        this.awsWafRule = builder.awsWafRule;
        this.awsWafRuleGroup = builder.awsWafRuleGroup;
        this.awsEcsTask = builder.awsEcsTask;
        this.awsBackupBackupVault = builder.awsBackupBackupVault;
        this.awsBackupBackupPlan = builder.awsBackupBackupPlan;
        this.awsBackupRecoveryPoint = builder.awsBackupRecoveryPoint;
        this.awsEc2LaunchTemplate = builder.awsEc2LaunchTemplate;
        this.awsSageMakerNotebookInstance = builder.awsSageMakerNotebookInstance;
        this.awsWafv2WebAcl = builder.awsWafv2WebAcl;
        this.awsWafv2RuleGroup = builder.awsWafv2RuleGroup;
        this.awsEc2RouteTable = builder.awsEc2RouteTable;
    }

    /**
     * <p>
     * Details for an autoscaling group.
     * </p>
     * 
     * @return Details for an autoscaling group.
     */
    public final AwsAutoScalingAutoScalingGroupDetails awsAutoScalingAutoScalingGroup() {
        return awsAutoScalingAutoScalingGroup;
    }

    /**
     * <p>
     * Details for an CodeBuild project.
     * </p>
     * 
     * @return Details for an CodeBuild project.
     */
    public final AwsCodeBuildProjectDetails awsCodeBuildProject() {
        return awsCodeBuildProject;
    }

    /**
     * <p>
     * Details about a CloudFront distribution.
     * </p>
     * 
     * @return Details about a CloudFront distribution.
     */
    public final AwsCloudFrontDistributionDetails awsCloudFrontDistribution() {
        return awsCloudFrontDistribution;
    }

    /**
     * <p>
     * Details about an EC2 instance related to a finding.
     * </p>
     * 
     * @return Details about an EC2 instance related to a finding.
     */
    public final AwsEc2InstanceDetails awsEc2Instance() {
        return awsEc2Instance;
    }

    /**
     * <p>
     * Details for an EC2 network interface.
     * </p>
     * 
     * @return Details for an EC2 network interface.
     */
    public final AwsEc2NetworkInterfaceDetails awsEc2NetworkInterface() {
        return awsEc2NetworkInterface;
    }

    /**
     * <p>
     * Details for an EC2 security group.
     * </p>
     * 
     * @return Details for an EC2 security group.
     */
    public final AwsEc2SecurityGroupDetails awsEc2SecurityGroup() {
        return awsEc2SecurityGroup;
    }

    /**
     * <p>
     * Details for an Amazon EC2 volume.
     * </p>
     * 
     * @return Details for an Amazon EC2 volume.
     */
    public final AwsEc2VolumeDetails awsEc2Volume() {
        return awsEc2Volume;
    }

    /**
     * <p>
     * Details for an Amazon EC2 VPC.
     * </p>
     * 
     * @return Details for an Amazon EC2 VPC.
     */
    public final AwsEc2VpcDetails awsEc2Vpc() {
        return awsEc2Vpc;
    }

    /**
     * <p>
     * Details about an Elastic IP address.
     * </p>
     * 
     * @return Details about an Elastic IP address.
     */
    public final AwsEc2EipDetails awsEc2Eip() {
        return awsEc2Eip;
    }

    /**
     * <p>
     * Details about a subnet in Amazon EC2.
     * </p>
     * 
     * @return Details about a subnet in Amazon EC2.
     */
    public final AwsEc2SubnetDetails awsEc2Subnet() {
        return awsEc2Subnet;
    }

    /**
     * <p>
     * Details about an EC2 network access control list (ACL).
     * </p>
     * 
     * @return Details about an EC2 network access control list (ACL).
     */
    public final AwsEc2NetworkAclDetails awsEc2NetworkAcl() {
        return awsEc2NetworkAcl;
    }

    /**
     * <p>
     * Details about a load balancer.
     * </p>
     * 
     * @return Details about a load balancer.
     */
    public final AwsElbv2LoadBalancerDetails awsElbv2LoadBalancer() {
        return awsElbv2LoadBalancer;
    }

    /**
     * <p>
     * Details about an Elastic Beanstalk environment.
     * </p>
     * 
     * @return Details about an Elastic Beanstalk environment.
     */
    public final AwsElasticBeanstalkEnvironmentDetails awsElasticBeanstalkEnvironment() {
        return awsElasticBeanstalkEnvironment;
    }

    /**
     * <p>
     * Details for an Elasticsearch domain.
     * </p>
     * 
     * @return Details for an Elasticsearch domain.
     */
    public final AwsElasticsearchDomainDetails awsElasticsearchDomain() {
        return awsElasticsearchDomain;
    }

    /**
     * <p>
     * Details about an S3 bucket related to a finding.
     * </p>
     * 
     * @return Details about an S3 bucket related to a finding.
     */
    public final AwsS3BucketDetails awsS3Bucket() {
        return awsS3Bucket;
    }

    /**
     * <p>
     * Details about the Amazon S3 Public Access Block configuration for an account.
     * </p>
     * 
     * @return Details about the Amazon S3 Public Access Block configuration for an account.
     */
    public final AwsS3AccountPublicAccessBlockDetails awsS3AccountPublicAccessBlock() {
        return awsS3AccountPublicAccessBlock;
    }

    /**
     * <p>
     * Details about an S3 object related to a finding.
     * </p>
     * 
     * @return Details about an S3 object related to a finding.
     */
    public final AwsS3ObjectDetails awsS3Object() {
        return awsS3Object;
    }

    /**
     * <p>
     * Details about a Secrets Manager secret.
     * </p>
     * 
     * @return Details about a Secrets Manager secret.
     */
    public final AwsSecretsManagerSecretDetails awsSecretsManagerSecret() {
        return awsSecretsManagerSecret;
    }

    /**
     * <p>
     * Details about an IAM access key related to a finding.
     * </p>
     * 
     * @return Details about an IAM access key related to a finding.
     */
    public final AwsIamAccessKeyDetails awsIamAccessKey() {
        return awsIamAccessKey;
    }

    /**
     * <p>
     * Details about an IAM user.
     * </p>
     * 
     * @return Details about an IAM user.
     */
    public final AwsIamUserDetails awsIamUser() {
        return awsIamUser;
    }

    /**
     * <p>
     * Details about an IAM permissions policy.
     * </p>
     * 
     * @return Details about an IAM permissions policy.
     */
    public final AwsIamPolicyDetails awsIamPolicy() {
        return awsIamPolicy;
    }

    /**
     * <p>
     * Provides information about a version 2 stage for Amazon API Gateway.
     * </p>
     * 
     * @return Provides information about a version 2 stage for Amazon API Gateway.
     */
    public final AwsApiGatewayV2StageDetails awsApiGatewayV2Stage() {
        return awsApiGatewayV2Stage;
    }

    /**
     * <p>
     * Provides information about a version 2 API in Amazon API Gateway.
     * </p>
     * 
     * @return Provides information about a version 2 API in Amazon API Gateway.
     */
    public final AwsApiGatewayV2ApiDetails awsApiGatewayV2Api() {
        return awsApiGatewayV2Api;
    }

    /**
     * <p>
     * Details about a DynamoDB table.
     * </p>
     * 
     * @return Details about a DynamoDB table.
     */
    public final AwsDynamoDbTableDetails awsDynamoDbTable() {
        return awsDynamoDbTable;
    }

    /**
     * <p>
     * Provides information about a version 1 Amazon API Gateway stage.
     * </p>
     * 
     * @return Provides information about a version 1 Amazon API Gateway stage.
     */
    public final AwsApiGatewayStageDetails awsApiGatewayStage() {
        return awsApiGatewayStage;
    }

    /**
     * <p>
     * Provides information about a REST API in version 1 of Amazon API Gateway.
     * </p>
     * 
     * @return Provides information about a REST API in version 1 of Amazon API Gateway.
     */
    public final AwsApiGatewayRestApiDetails awsApiGatewayRestApi() {
        return awsApiGatewayRestApi;
    }

    /**
     * <p>
     * Provides details about a CloudTrail trail.
     * </p>
     * 
     * @return Provides details about a CloudTrail trail.
     */
    public final AwsCloudTrailTrailDetails awsCloudTrailTrail() {
        return awsCloudTrailTrail;
    }

    /**
     * <p>
     * Provides information about the state of a patch on an instance based on the patch baseline that was used to patch
     * the instance.
     * </p>
     * 
     * @return Provides information about the state of a patch on an instance based on the patch baseline that was used
     *         to patch the instance.
     */
    public final AwsSsmPatchComplianceDetails awsSsmPatchCompliance() {
        return awsSsmPatchCompliance;
    }

    /**
     * <p>
     * Provides details about an Certificate Manager certificate.
     * </p>
     * 
     * @return Provides details about an Certificate Manager certificate.
     */
    public final AwsCertificateManagerCertificateDetails awsCertificateManagerCertificate() {
        return awsCertificateManagerCertificate;
    }

    /**
     * <p>
     * Contains details about an Amazon Redshift cluster.
     * </p>
     * 
     * @return Contains details about an Amazon Redshift cluster.
     */
    public final AwsRedshiftClusterDetails awsRedshiftCluster() {
        return awsRedshiftCluster;
    }

    /**
     * <p>
     * Contains details about a Classic Load Balancer.
     * </p>
     * 
     * @return Contains details about a Classic Load Balancer.
     */
    public final AwsElbLoadBalancerDetails awsElbLoadBalancer() {
        return awsElbLoadBalancer;
    }

    /**
     * <p>
     * Contains details about an IAM group.
     * </p>
     * 
     * @return Contains details about an IAM group.
     */
    public final AwsIamGroupDetails awsIamGroup() {
        return awsIamGroup;
    }

    /**
     * <p>
     * Details about an IAM role.
     * </p>
     * 
     * @return Details about an IAM role.
     */
    public final AwsIamRoleDetails awsIamRole() {
        return awsIamRole;
    }

    /**
     * <p>
     * Details about an KMS key.
     * </p>
     * 
     * @return Details about an KMS key.
     */
    public final AwsKmsKeyDetails awsKmsKey() {
        return awsKmsKey;
    }

    /**
     * <p>
     * Details about a Lambda function.
     * </p>
     * 
     * @return Details about a Lambda function.
     */
    public final AwsLambdaFunctionDetails awsLambdaFunction() {
        return awsLambdaFunction;
    }

    /**
     * <p>
     * Details for a Lambda layer version.
     * </p>
     * 
     * @return Details for a Lambda layer version.
     */
    public final AwsLambdaLayerVersionDetails awsLambdaLayerVersion() {
        return awsLambdaLayerVersion;
    }

    /**
     * <p>
     * Details about an Amazon RDS database instance.
     * </p>
     * 
     * @return Details about an Amazon RDS database instance.
     */
    public final AwsRdsDbInstanceDetails awsRdsDbInstance() {
        return awsRdsDbInstance;
    }

    /**
     * <p>
     * Details about an SNS topic.
     * </p>
     * 
     * @return Details about an SNS topic.
     */
    public final AwsSnsTopicDetails awsSnsTopic() {
        return awsSnsTopic;
    }

    /**
     * <p>
     * Details about an SQS queue.
     * </p>
     * 
     * @return Details about an SQS queue.
     */
    public final AwsSqsQueueDetails awsSqsQueue() {
        return awsSqsQueue;
    }

    /**
     * <p>
     * Details for an WAF web ACL.
     * </p>
     * 
     * @return Details for an WAF web ACL.
     */
    public final AwsWafWebAclDetails awsWafWebAcl() {
        return awsWafWebAcl;
    }

    /**
     * <p>
     * Details about an Amazon RDS database snapshot.
     * </p>
     * 
     * @return Details about an Amazon RDS database snapshot.
     */
    public final AwsRdsDbSnapshotDetails awsRdsDbSnapshot() {
        return awsRdsDbSnapshot;
    }

    /**
     * <p>
     * Details about an Amazon RDS database cluster snapshot.
     * </p>
     * 
     * @return Details about an Amazon RDS database cluster snapshot.
     */
    public final AwsRdsDbClusterSnapshotDetails awsRdsDbClusterSnapshot() {
        return awsRdsDbClusterSnapshot;
    }

    /**
     * <p>
     * Details about an Amazon RDS database cluster.
     * </p>
     * 
     * @return Details about an Amazon RDS database cluster.
     */
    public final AwsRdsDbClusterDetails awsRdsDbCluster() {
        return awsRdsDbCluster;
    }

    /**
     * <p>
     * Details about an Amazon ECS cluster.
     * </p>
     * 
     * @return Details about an Amazon ECS cluster.
     */
    public final AwsEcsClusterDetails awsEcsCluster() {
        return awsEcsCluster;
    }

    /**
     * <p>
     * Provides information about a Docker container that's part of a task.
     * </p>
     * 
     * @return Provides information about a Docker container that's part of a task.
     */
    public final AwsEcsContainerDetails awsEcsContainer() {
        return awsEcsContainer;
    }

    /**
     * <p>
     * Details about a task definition. A task definition describes the container and volume definitions of an Amazon
     * Elastic Container Service task.
     * </p>
     * 
     * @return Details about a task definition. A task definition describes the container and volume definitions of an
     *         Amazon Elastic Container Service task.
     */
    public final AwsEcsTaskDefinitionDetails awsEcsTaskDefinition() {
        return awsEcsTaskDefinition;
    }

    /**
     * <p>
     * Details about a container resource related to a finding.
     * </p>
     * 
     * @return Details about a container resource related to a finding.
     */
    public final ContainerDetails container() {
        return container;
    }

    /**
     * For responses, this returns true if the service returned a value for the Other property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasOther() {
        return other != null && !(other instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Details about a resource that are not available in a type-specific details object. Use the <code>Other</code>
     * object in the following cases.
     * </p>
     * <ul>
     * <li>
     * <p>
     * The type-specific object does not contain all of the fields that you want to populate. In this case, first use
     * the type-specific object to populate those fields. Use the <code>Other</code> object to populate the fields that
     * are missing from the type-specific object.
     * </p>
     * </li>
     * <li>
     * <p>
     * The resource type does not have a corresponding object. This includes resources for which the type is
     * <code>Other</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOther} method.
     * </p>
     * 
     * @return Details about a resource that are not available in a type-specific details object. Use the
     *         <code>Other</code> object in the following cases.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         The type-specific object does not contain all of the fields that you want to populate. In this case,
     *         first use the type-specific object to populate those fields. Use the <code>Other</code> object to
     *         populate the fields that are missing from the type-specific object.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The resource type does not have a corresponding object. This includes resources for which the type is
     *         <code>Other</code>.
     *         </p>
     *         </li>
     */
    public final Map<String, String> other() {
        return other;
    }

    /**
     * <p>
     * Details about an RDS event notification subscription.
     * </p>
     * 
     * @return Details about an RDS event notification subscription.
     */
    public final AwsRdsEventSubscriptionDetails awsRdsEventSubscription() {
        return awsRdsEventSubscription;
    }

    /**
     * <p>
     * Details about a service within an ECS cluster.
     * </p>
     * 
     * @return Details about a service within an ECS cluster.
     */
    public final AwsEcsServiceDetails awsEcsService() {
        return awsEcsService;
    }

    /**
     * <p>
     * Provides details about a launch configuration.
     * </p>
     * 
     * @return Provides details about a launch configuration.
     */
    public final AwsAutoScalingLaunchConfigurationDetails awsAutoScalingLaunchConfiguration() {
        return awsAutoScalingLaunchConfiguration;
    }

    /**
     * <p>
     * Details about an Amazon EC2 VPN connection.
     * </p>
     * 
     * @return Details about an Amazon EC2 VPN connection.
     */
    public final AwsEc2VpnConnectionDetails awsEc2VpnConnection() {
        return awsEc2VpnConnection;
    }

    /**
     * <p>
     * Information about an Amazon ECR image.
     * </p>
     * 
     * @return Information about an Amazon ECR image.
     */
    public final AwsEcrContainerImageDetails awsEcrContainerImage() {
        return awsEcrContainerImage;
    }

    /**
     * <p>
     * Details about an Amazon OpenSearch Service domain.
     * </p>
     * 
     * @return Details about an Amazon OpenSearch Service domain.
     */
    public final AwsOpenSearchServiceDomainDetails awsOpenSearchServiceDomain() {
        return awsOpenSearchServiceDomain;
    }

    /**
     * <p>
     * Details about the service configuration for a VPC endpoint service.
     * </p>
     * 
     * @return Details about the service configuration for a VPC endpoint service.
     */
    public final AwsEc2VpcEndpointServiceDetails awsEc2VpcEndpointService() {
        return awsEc2VpcEndpointService;
    }

    /**
     * <p>
     * Information about the encryption configuration for X-Ray.
     * </p>
     * 
     * @return Information about the encryption configuration for X-Ray.
     */
    public final AwsXrayEncryptionConfigDetails awsXrayEncryptionConfig() {
        return awsXrayEncryptionConfig;
    }

    /**
     * <p>
     * Details about a rate-based rule for global resources.
     * </p>
     * 
     * @return Details about a rate-based rule for global resources.
     */
    public final AwsWafRateBasedRuleDetails awsWafRateBasedRule() {
        return awsWafRateBasedRule;
    }

    /**
     * <p>
     * Details about a rate-based rule for Regional resources.
     * </p>
     * 
     * @return Details about a rate-based rule for Regional resources.
     */
    public final AwsWafRegionalRateBasedRuleDetails awsWafRegionalRateBasedRule() {
        return awsWafRegionalRateBasedRule;
    }

    /**
     * <p>
     * Information about an Amazon Elastic Container Registry repository.
     * </p>
     * 
     * @return Information about an Amazon Elastic Container Registry repository.
     */
    public final AwsEcrRepositoryDetails awsEcrRepository() {
        return awsEcrRepository;
    }

    /**
     * <p>
     * Details about an Amazon EKS cluster.
     * </p>
     * 
     * @return Details about an Amazon EKS cluster.
     */
    public final AwsEksClusterDetails awsEksCluster() {
        return awsEksCluster;
    }

    /**
     * <p>
     * Details about an Network Firewall firewall policy.
     * </p>
     * 
     * @return Details about an Network Firewall firewall policy.
     */
    public final AwsNetworkFirewallFirewallPolicyDetails awsNetworkFirewallFirewallPolicy() {
        return awsNetworkFirewallFirewallPolicy;
    }

    /**
     * <p>
     * Details about an Network Firewall firewall.
     * </p>
     * 
     * @return Details about an Network Firewall firewall.
     */
    public final AwsNetworkFirewallFirewallDetails awsNetworkFirewallFirewall() {
        return awsNetworkFirewallFirewall;
    }

    /**
     * <p>
     * Details about an Network Firewall rule group.
     * </p>
     * 
     * @return Details about an Network Firewall rule group.
     */
    public final AwsNetworkFirewallRuleGroupDetails awsNetworkFirewallRuleGroup() {
        return awsNetworkFirewallRuleGroup;
    }

    /**
     * <p>
     * Details about an Amazon RDS DB security group.
     * </p>
     * 
     * @return Details about an Amazon RDS DB security group.
     */
    public final AwsRdsDbSecurityGroupDetails awsRdsDbSecurityGroup() {
        return awsRdsDbSecurityGroup;
    }

    /**
     * <p>
     * Details about an Amazon Kinesis data stream.
     * </p>
     * 
     * @return Details about an Amazon Kinesis data stream.
     */
    public final AwsKinesisStreamDetails awsKinesisStream() {
        return awsKinesisStream;
    }

    /**
     * <p>
     * Details about an Amazon EC2 transit gateway that interconnects your virtual private clouds (VPC) and on-premises
     * networks.
     * </p>
     * 
     * @return Details about an Amazon EC2 transit gateway that interconnects your virtual private clouds (VPC) and
     *         on-premises networks.
     */
    public final AwsEc2TransitGatewayDetails awsEc2TransitGateway() {
        return awsEc2TransitGateway;
    }

    /**
     * <p>
     * Details about an Amazon EFS access point. An access point is an application-specific view into an EFS file system
     * that applies an operating system user and group, and a file system path, to any file system request made through
     * the access point.
     * </p>
     * 
     * @return Details about an Amazon EFS access point. An access point is an application-specific view into an EFS
     *         file system that applies an operating system user and group, and a file system path, to any file system
     *         request made through the access point.
     */
    public final AwsEfsAccessPointDetails awsEfsAccessPoint() {
        return awsEfsAccessPoint;
    }

    /**
     * <p>
     * Details about an CloudFormation stack. A stack is a collection of Amazon Web Services resources that you can
     * manage as a single unit.
     * </p>
     * 
     * @return Details about an CloudFormation stack. A stack is a collection of Amazon Web Services resources that you
     *         can manage as a single unit.
     */
    public final AwsCloudFormationStackDetails awsCloudFormationStack() {
        return awsCloudFormationStack;
    }

    /**
     * <p>
     * Details about an Amazon CloudWatch alarm. An alarm allows you to monitor and receive alerts about your Amazon Web
     * Services resources and applications across multiple Regions.
     * </p>
     * 
     * @return Details about an Amazon CloudWatch alarm. An alarm allows you to monitor and receive alerts about your
     *         Amazon Web Services resources and applications across multiple Regions.
     */
    public final AwsCloudWatchAlarmDetails awsCloudWatchAlarm() {
        return awsCloudWatchAlarm;
    }

    /**
     * <p>
     * Details about an Amazon EC2 VPC peering connection. A VPC peering connection is a networking connection between
     * two VPCs that enables you to route traffic between them privately.
     * </p>
     * 
     * @return Details about an Amazon EC2 VPC peering connection. A VPC peering connection is a networking connection
     *         between two VPCs that enables you to route traffic between them privately.
     */
    public final AwsEc2VpcPeeringConnectionDetails awsEc2VpcPeeringConnection() {
        return awsEc2VpcPeeringConnection;
    }

    /**
     * <p>
     * Details about an WAF rule group for Regional resources.
     * </p>
     * 
     * @return Details about an WAF rule group for Regional resources.
     */
    public final AwsWafRegionalRuleGroupDetails awsWafRegionalRuleGroup() {
        return awsWafRegionalRuleGroup;
    }

    /**
     * <p>
     * Details about an WAF rule for Regional resources.
     * </p>
     * 
     * @return Details about an WAF rule for Regional resources.
     */
    public final AwsWafRegionalRuleDetails awsWafRegionalRule() {
        return awsWafRegionalRule;
    }

    /**
     * <p>
     * Details about an WAF web access control list (web ACL) for Regional resources.
     * </p>
     * 
     * @return Details about an WAF web access control list (web ACL) for Regional resources.
     */
    public final AwsWafRegionalWebAclDetails awsWafRegionalWebAcl() {
        return awsWafRegionalWebAcl;
    }

    /**
     * <p>
     * Details about an WAF rule for global resources.
     * </p>
     * 
     * @return Details about an WAF rule for global resources.
     */
    public final AwsWafRuleDetails awsWafRule() {
        return awsWafRule;
    }

    /**
     * <p>
     * Details about an WAF rule group for global resources.
     * </p>
     * 
     * @return Details about an WAF rule group for global resources.
     */
    public final AwsWafRuleGroupDetails awsWafRuleGroup() {
        return awsWafRuleGroup;
    }

    /**
     * <p>
     * Details about a task in a cluster.
     * </p>
     * 
     * @return Details about a task in a cluster.
     */
    public final AwsEcsTaskDetails awsEcsTask() {
        return awsEcsTask;
    }

    /**
     * <p>
     * Provides details about an Backup backup vault.
     * </p>
     * 
     * @return Provides details about an Backup backup vault.
     */
    public final AwsBackupBackupVaultDetails awsBackupBackupVault() {
        return awsBackupBackupVault;
    }

    /**
     * <p>
     * Provides details about an Backup backup plan.
     * </p>
     * 
     * @return Provides details about an Backup backup plan.
     */
    public final AwsBackupBackupPlanDetails awsBackupBackupPlan() {
        return awsBackupBackupPlan;
    }

    /**
     * <p>
     * Provides details about an Backup backup, or recovery point.
     * </p>
     * 
     * @return Provides details about an Backup backup, or recovery point.
     */
    public final AwsBackupRecoveryPointDetails awsBackupRecoveryPoint() {
        return awsBackupRecoveryPoint;
    }

    /**
     * Returns the value of the AwsEc2LaunchTemplate property for this object.
     * 
     * @return The value of the AwsEc2LaunchTemplate property for this object.
     */
    public final AwsEc2LaunchTemplateDetails awsEc2LaunchTemplate() {
        return awsEc2LaunchTemplate;
    }

    /**
     * Returns the value of the AwsSageMakerNotebookInstance property for this object.
     * 
     * @return The value of the AwsSageMakerNotebookInstance property for this object.
     */
    public final AwsSageMakerNotebookInstanceDetails awsSageMakerNotebookInstance() {
        return awsSageMakerNotebookInstance;
    }

    /**
     * Returns the value of the AwsWafv2WebAcl property for this object.
     * 
     * @return The value of the AwsWafv2WebAcl property for this object.
     */
    public final AwsWafv2WebAclDetails awsWafv2WebAcl() {
        return awsWafv2WebAcl;
    }

    /**
     * Returns the value of the AwsWafv2RuleGroup property for this object.
     * 
     * @return The value of the AwsWafv2RuleGroup property for this object.
     */
    public final AwsWafv2RuleGroupDetails awsWafv2RuleGroup() {
        return awsWafv2RuleGroup;
    }

    /**
     * <p>
     * Provides details about a route table. A route table contains a set of rules, called routes, that determine where
     * to direct network traffic from your subnet or gateway.
     * </p>
     * 
     * @return Provides details about a route table. A route table contains a set of rules, called routes, that
     *         determine where to direct network traffic from your subnet or gateway.
     */
    public final AwsEc2RouteTableDetails awsEc2RouteTable() {
        return awsEc2RouteTable;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(awsAutoScalingAutoScalingGroup());
        hashCode = 31 * hashCode + Objects.hashCode(awsCodeBuildProject());
        hashCode = 31 * hashCode + Objects.hashCode(awsCloudFrontDistribution());
        hashCode = 31 * hashCode + Objects.hashCode(awsEc2Instance());
        hashCode = 31 * hashCode + Objects.hashCode(awsEc2NetworkInterface());
        hashCode = 31 * hashCode + Objects.hashCode(awsEc2SecurityGroup());
        hashCode = 31 * hashCode + Objects.hashCode(awsEc2Volume());
        hashCode = 31 * hashCode + Objects.hashCode(awsEc2Vpc());
        hashCode = 31 * hashCode + Objects.hashCode(awsEc2Eip());
        hashCode = 31 * hashCode + Objects.hashCode(awsEc2Subnet());
        hashCode = 31 * hashCode + Objects.hashCode(awsEc2NetworkAcl());
        hashCode = 31 * hashCode + Objects.hashCode(awsElbv2LoadBalancer());
        hashCode = 31 * hashCode + Objects.hashCode(awsElasticBeanstalkEnvironment());
        hashCode = 31 * hashCode + Objects.hashCode(awsElasticsearchDomain());
        hashCode = 31 * hashCode + Objects.hashCode(awsS3Bucket());
        hashCode = 31 * hashCode + Objects.hashCode(awsS3AccountPublicAccessBlock());
        hashCode = 31 * hashCode + Objects.hashCode(awsS3Object());
        hashCode = 31 * hashCode + Objects.hashCode(awsSecretsManagerSecret());
        hashCode = 31 * hashCode + Objects.hashCode(awsIamAccessKey());
        hashCode = 31 * hashCode + Objects.hashCode(awsIamUser());
        hashCode = 31 * hashCode + Objects.hashCode(awsIamPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(awsApiGatewayV2Stage());
        hashCode = 31 * hashCode + Objects.hashCode(awsApiGatewayV2Api());
        hashCode = 31 * hashCode + Objects.hashCode(awsDynamoDbTable());
        hashCode = 31 * hashCode + Objects.hashCode(awsApiGatewayStage());
        hashCode = 31 * hashCode + Objects.hashCode(awsApiGatewayRestApi());
        hashCode = 31 * hashCode + Objects.hashCode(awsCloudTrailTrail());
        hashCode = 31 * hashCode + Objects.hashCode(awsSsmPatchCompliance());
        hashCode = 31 * hashCode + Objects.hashCode(awsCertificateManagerCertificate());
        hashCode = 31 * hashCode + Objects.hashCode(awsRedshiftCluster());
        hashCode = 31 * hashCode + Objects.hashCode(awsElbLoadBalancer());
        hashCode = 31 * hashCode + Objects.hashCode(awsIamGroup());
        hashCode = 31 * hashCode + Objects.hashCode(awsIamRole());
        hashCode = 31 * hashCode + Objects.hashCode(awsKmsKey());
        hashCode = 31 * hashCode + Objects.hashCode(awsLambdaFunction());
        hashCode = 31 * hashCode + Objects.hashCode(awsLambdaLayerVersion());
        hashCode = 31 * hashCode + Objects.hashCode(awsRdsDbInstance());
        hashCode = 31 * hashCode + Objects.hashCode(awsSnsTopic());
        hashCode = 31 * hashCode + Objects.hashCode(awsSqsQueue());
        hashCode = 31 * hashCode + Objects.hashCode(awsWafWebAcl());
        hashCode = 31 * hashCode + Objects.hashCode(awsRdsDbSnapshot());
        hashCode = 31 * hashCode + Objects.hashCode(awsRdsDbClusterSnapshot());
        hashCode = 31 * hashCode + Objects.hashCode(awsRdsDbCluster());
        hashCode = 31 * hashCode + Objects.hashCode(awsEcsCluster());
        hashCode = 31 * hashCode + Objects.hashCode(awsEcsContainer());
        hashCode = 31 * hashCode + Objects.hashCode(awsEcsTaskDefinition());
        hashCode = 31 * hashCode + Objects.hashCode(container());
        hashCode = 31 * hashCode + Objects.hashCode(hasOther() ? other() : null);
        hashCode = 31 * hashCode + Objects.hashCode(awsRdsEventSubscription());
        hashCode = 31 * hashCode + Objects.hashCode(awsEcsService());
        hashCode = 31 * hashCode + Objects.hashCode(awsAutoScalingLaunchConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(awsEc2VpnConnection());
        hashCode = 31 * hashCode + Objects.hashCode(awsEcrContainerImage());
        hashCode = 31 * hashCode + Objects.hashCode(awsOpenSearchServiceDomain());
        hashCode = 31 * hashCode + Objects.hashCode(awsEc2VpcEndpointService());
        hashCode = 31 * hashCode + Objects.hashCode(awsXrayEncryptionConfig());
        hashCode = 31 * hashCode + Objects.hashCode(awsWafRateBasedRule());
        hashCode = 31 * hashCode + Objects.hashCode(awsWafRegionalRateBasedRule());
        hashCode = 31 * hashCode + Objects.hashCode(awsEcrRepository());
        hashCode = 31 * hashCode + Objects.hashCode(awsEksCluster());
        hashCode = 31 * hashCode + Objects.hashCode(awsNetworkFirewallFirewallPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(awsNetworkFirewallFirewall());
        hashCode = 31 * hashCode + Objects.hashCode(awsNetworkFirewallRuleGroup());
        hashCode = 31 * hashCode + Objects.hashCode(awsRdsDbSecurityGroup());
        hashCode = 31 * hashCode + Objects.hashCode(awsKinesisStream());
        hashCode = 31 * hashCode + Objects.hashCode(awsEc2TransitGateway());
        hashCode = 31 * hashCode + Objects.hashCode(awsEfsAccessPoint());
        hashCode = 31 * hashCode + Objects.hashCode(awsCloudFormationStack());
        hashCode = 31 * hashCode + Objects.hashCode(awsCloudWatchAlarm());
        hashCode = 31 * hashCode + Objects.hashCode(awsEc2VpcPeeringConnection());
        hashCode = 31 * hashCode + Objects.hashCode(awsWafRegionalRuleGroup());
        hashCode = 31 * hashCode + Objects.hashCode(awsWafRegionalRule());
        hashCode = 31 * hashCode + Objects.hashCode(awsWafRegionalWebAcl());
        hashCode = 31 * hashCode + Objects.hashCode(awsWafRule());
        hashCode = 31 * hashCode + Objects.hashCode(awsWafRuleGroup());
        hashCode = 31 * hashCode + Objects.hashCode(awsEcsTask());
        hashCode = 31 * hashCode + Objects.hashCode(awsBackupBackupVault());
        hashCode = 31 * hashCode + Objects.hashCode(awsBackupBackupPlan());
        hashCode = 31 * hashCode + Objects.hashCode(awsBackupRecoveryPoint());
        hashCode = 31 * hashCode + Objects.hashCode(awsEc2LaunchTemplate());
        hashCode = 31 * hashCode + Objects.hashCode(awsSageMakerNotebookInstance());
        hashCode = 31 * hashCode + Objects.hashCode(awsWafv2WebAcl());
        hashCode = 31 * hashCode + Objects.hashCode(awsWafv2RuleGroup());
        hashCode = 31 * hashCode + Objects.hashCode(awsEc2RouteTable());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceDetails)) {
            return false;
        }
        ResourceDetails other = (ResourceDetails) obj;
        return Objects.equals(awsAutoScalingAutoScalingGroup(), other.awsAutoScalingAutoScalingGroup())
                && Objects.equals(awsCodeBuildProject(), other.awsCodeBuildProject())
                && Objects.equals(awsCloudFrontDistribution(), other.awsCloudFrontDistribution())
                && Objects.equals(awsEc2Instance(), other.awsEc2Instance())
                && Objects.equals(awsEc2NetworkInterface(), other.awsEc2NetworkInterface())
                && Objects.equals(awsEc2SecurityGroup(), other.awsEc2SecurityGroup())
                && Objects.equals(awsEc2Volume(), other.awsEc2Volume()) && Objects.equals(awsEc2Vpc(), other.awsEc2Vpc())
                && Objects.equals(awsEc2Eip(), other.awsEc2Eip()) && Objects.equals(awsEc2Subnet(), other.awsEc2Subnet())
                && Objects.equals(awsEc2NetworkAcl(), other.awsEc2NetworkAcl())
                && Objects.equals(awsElbv2LoadBalancer(), other.awsElbv2LoadBalancer())
                && Objects.equals(awsElasticBeanstalkEnvironment(), other.awsElasticBeanstalkEnvironment())
                && Objects.equals(awsElasticsearchDomain(), other.awsElasticsearchDomain())
                && Objects.equals(awsS3Bucket(), other.awsS3Bucket())
                && Objects.equals(awsS3AccountPublicAccessBlock(), other.awsS3AccountPublicAccessBlock())
                && Objects.equals(awsS3Object(), other.awsS3Object())
                && Objects.equals(awsSecretsManagerSecret(), other.awsSecretsManagerSecret())
                && Objects.equals(awsIamAccessKey(), other.awsIamAccessKey()) && Objects.equals(awsIamUser(), other.awsIamUser())
                && Objects.equals(awsIamPolicy(), other.awsIamPolicy())
                && Objects.equals(awsApiGatewayV2Stage(), other.awsApiGatewayV2Stage())
                && Objects.equals(awsApiGatewayV2Api(), other.awsApiGatewayV2Api())
                && Objects.equals(awsDynamoDbTable(), other.awsDynamoDbTable())
                && Objects.equals(awsApiGatewayStage(), other.awsApiGatewayStage())
                && Objects.equals(awsApiGatewayRestApi(), other.awsApiGatewayRestApi())
                && Objects.equals(awsCloudTrailTrail(), other.awsCloudTrailTrail())
                && Objects.equals(awsSsmPatchCompliance(), other.awsSsmPatchCompliance())
                && Objects.equals(awsCertificateManagerCertificate(), other.awsCertificateManagerCertificate())
                && Objects.equals(awsRedshiftCluster(), other.awsRedshiftCluster())
                && Objects.equals(awsElbLoadBalancer(), other.awsElbLoadBalancer())
                && Objects.equals(awsIamGroup(), other.awsIamGroup()) && Objects.equals(awsIamRole(), other.awsIamRole())
                && Objects.equals(awsKmsKey(), other.awsKmsKey())
                && Objects.equals(awsLambdaFunction(), other.awsLambdaFunction())
                && Objects.equals(awsLambdaLayerVersion(), other.awsLambdaLayerVersion())
                && Objects.equals(awsRdsDbInstance(), other.awsRdsDbInstance())
                && Objects.equals(awsSnsTopic(), other.awsSnsTopic()) && Objects.equals(awsSqsQueue(), other.awsSqsQueue())
                && Objects.equals(awsWafWebAcl(), other.awsWafWebAcl())
                && Objects.equals(awsRdsDbSnapshot(), other.awsRdsDbSnapshot())
                && Objects.equals(awsRdsDbClusterSnapshot(), other.awsRdsDbClusterSnapshot())
                && Objects.equals(awsRdsDbCluster(), other.awsRdsDbCluster())
                && Objects.equals(awsEcsCluster(), other.awsEcsCluster())
                && Objects.equals(awsEcsContainer(), other.awsEcsContainer())
                && Objects.equals(awsEcsTaskDefinition(), other.awsEcsTaskDefinition())
                && Objects.equals(container(), other.container()) && hasOther() == other.hasOther()
                && Objects.equals(other(), other.other())
                && Objects.equals(awsRdsEventSubscription(), other.awsRdsEventSubscription())
                && Objects.equals(awsEcsService(), other.awsEcsService())
                && Objects.equals(awsAutoScalingLaunchConfiguration(), other.awsAutoScalingLaunchConfiguration())
                && Objects.equals(awsEc2VpnConnection(), other.awsEc2VpnConnection())
                && Objects.equals(awsEcrContainerImage(), other.awsEcrContainerImage())
                && Objects.equals(awsOpenSearchServiceDomain(), other.awsOpenSearchServiceDomain())
                && Objects.equals(awsEc2VpcEndpointService(), other.awsEc2VpcEndpointService())
                && Objects.equals(awsXrayEncryptionConfig(), other.awsXrayEncryptionConfig())
                && Objects.equals(awsWafRateBasedRule(), other.awsWafRateBasedRule())
                && Objects.equals(awsWafRegionalRateBasedRule(), other.awsWafRegionalRateBasedRule())
                && Objects.equals(awsEcrRepository(), other.awsEcrRepository())
                && Objects.equals(awsEksCluster(), other.awsEksCluster())
                && Objects.equals(awsNetworkFirewallFirewallPolicy(), other.awsNetworkFirewallFirewallPolicy())
                && Objects.equals(awsNetworkFirewallFirewall(), other.awsNetworkFirewallFirewall())
                && Objects.equals(awsNetworkFirewallRuleGroup(), other.awsNetworkFirewallRuleGroup())
                && Objects.equals(awsRdsDbSecurityGroup(), other.awsRdsDbSecurityGroup())
                && Objects.equals(awsKinesisStream(), other.awsKinesisStream())
                && Objects.equals(awsEc2TransitGateway(), other.awsEc2TransitGateway())
                && Objects.equals(awsEfsAccessPoint(), other.awsEfsAccessPoint())
                && Objects.equals(awsCloudFormationStack(), other.awsCloudFormationStack())
                && Objects.equals(awsCloudWatchAlarm(), other.awsCloudWatchAlarm())
                && Objects.equals(awsEc2VpcPeeringConnection(), other.awsEc2VpcPeeringConnection())
                && Objects.equals(awsWafRegionalRuleGroup(), other.awsWafRegionalRuleGroup())
                && Objects.equals(awsWafRegionalRule(), other.awsWafRegionalRule())
                && Objects.equals(awsWafRegionalWebAcl(), other.awsWafRegionalWebAcl())
                && Objects.equals(awsWafRule(), other.awsWafRule()) && Objects.equals(awsWafRuleGroup(), other.awsWafRuleGroup())
                && Objects.equals(awsEcsTask(), other.awsEcsTask())
                && Objects.equals(awsBackupBackupVault(), other.awsBackupBackupVault())
                && Objects.equals(awsBackupBackupPlan(), other.awsBackupBackupPlan())
                && Objects.equals(awsBackupRecoveryPoint(), other.awsBackupRecoveryPoint())
                && Objects.equals(awsEc2LaunchTemplate(), other.awsEc2LaunchTemplate())
                && Objects.equals(awsSageMakerNotebookInstance(), other.awsSageMakerNotebookInstance())
                && Objects.equals(awsWafv2WebAcl(), other.awsWafv2WebAcl())
                && Objects.equals(awsWafv2RuleGroup(), other.awsWafv2RuleGroup())
                && Objects.equals(awsEc2RouteTable(), other.awsEc2RouteTable());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ResourceDetails").add("AwsAutoScalingAutoScalingGroup", awsAutoScalingAutoScalingGroup())
                .add("AwsCodeBuildProject", awsCodeBuildProject()).add("AwsCloudFrontDistribution", awsCloudFrontDistribution())
                .add("AwsEc2Instance", awsEc2Instance()).add("AwsEc2NetworkInterface", awsEc2NetworkInterface())
                .add("AwsEc2SecurityGroup", awsEc2SecurityGroup()).add("AwsEc2Volume", awsEc2Volume())
                .add("AwsEc2Vpc", awsEc2Vpc()).add("AwsEc2Eip", awsEc2Eip()).add("AwsEc2Subnet", awsEc2Subnet())
                .add("AwsEc2NetworkAcl", awsEc2NetworkAcl()).add("AwsElbv2LoadBalancer", awsElbv2LoadBalancer())
                .add("AwsElasticBeanstalkEnvironment", awsElasticBeanstalkEnvironment())
                .add("AwsElasticsearchDomain", awsElasticsearchDomain()).add("AwsS3Bucket", awsS3Bucket())
                .add("AwsS3AccountPublicAccessBlock", awsS3AccountPublicAccessBlock()).add("AwsS3Object", awsS3Object())
                .add("AwsSecretsManagerSecret", awsSecretsManagerSecret()).add("AwsIamAccessKey", awsIamAccessKey())
                .add("AwsIamUser", awsIamUser()).add("AwsIamPolicy", awsIamPolicy())
                .add("AwsApiGatewayV2Stage", awsApiGatewayV2Stage()).add("AwsApiGatewayV2Api", awsApiGatewayV2Api())
                .add("AwsDynamoDbTable", awsDynamoDbTable()).add("AwsApiGatewayStage", awsApiGatewayStage())
                .add("AwsApiGatewayRestApi", awsApiGatewayRestApi()).add("AwsCloudTrailTrail", awsCloudTrailTrail())
                .add("AwsSsmPatchCompliance", awsSsmPatchCompliance())
                .add("AwsCertificateManagerCertificate", awsCertificateManagerCertificate())
                .add("AwsRedshiftCluster", awsRedshiftCluster()).add("AwsElbLoadBalancer", awsElbLoadBalancer())
                .add("AwsIamGroup", awsIamGroup()).add("AwsIamRole", awsIamRole()).add("AwsKmsKey", awsKmsKey())
                .add("AwsLambdaFunction", awsLambdaFunction()).add("AwsLambdaLayerVersion", awsLambdaLayerVersion())
                .add("AwsRdsDbInstance", awsRdsDbInstance()).add("AwsSnsTopic", awsSnsTopic()).add("AwsSqsQueue", awsSqsQueue())
                .add("AwsWafWebAcl", awsWafWebAcl()).add("AwsRdsDbSnapshot", awsRdsDbSnapshot())
                .add("AwsRdsDbClusterSnapshot", awsRdsDbClusterSnapshot()).add("AwsRdsDbCluster", awsRdsDbCluster())
                .add("AwsEcsCluster", awsEcsCluster()).add("AwsEcsContainer", awsEcsContainer())
                .add("AwsEcsTaskDefinition", awsEcsTaskDefinition()).add("Container", container())
                .add("Other", hasOther() ? other() : null).add("AwsRdsEventSubscription", awsRdsEventSubscription())
                .add("AwsEcsService", awsEcsService())
                .add("AwsAutoScalingLaunchConfiguration", awsAutoScalingLaunchConfiguration())
                .add("AwsEc2VpnConnection", awsEc2VpnConnection()).add("AwsEcrContainerImage", awsEcrContainerImage())
                .add("AwsOpenSearchServiceDomain", awsOpenSearchServiceDomain())
                .add("AwsEc2VpcEndpointService", awsEc2VpcEndpointService())
                .add("AwsXrayEncryptionConfig", awsXrayEncryptionConfig()).add("AwsWafRateBasedRule", awsWafRateBasedRule())
                .add("AwsWafRegionalRateBasedRule", awsWafRegionalRateBasedRule()).add("AwsEcrRepository", awsEcrRepository())
                .add("AwsEksCluster", awsEksCluster())
                .add("AwsNetworkFirewallFirewallPolicy", awsNetworkFirewallFirewallPolicy())
                .add("AwsNetworkFirewallFirewall", awsNetworkFirewallFirewall())
                .add("AwsNetworkFirewallRuleGroup", awsNetworkFirewallRuleGroup())
                .add("AwsRdsDbSecurityGroup", awsRdsDbSecurityGroup()).add("AwsKinesisStream", awsKinesisStream())
                .add("AwsEc2TransitGateway", awsEc2TransitGateway()).add("AwsEfsAccessPoint", awsEfsAccessPoint())
                .add("AwsCloudFormationStack", awsCloudFormationStack()).add("AwsCloudWatchAlarm", awsCloudWatchAlarm())
                .add("AwsEc2VpcPeeringConnection", awsEc2VpcPeeringConnection())
                .add("AwsWafRegionalRuleGroup", awsWafRegionalRuleGroup()).add("AwsWafRegionalRule", awsWafRegionalRule())
                .add("AwsWafRegionalWebAcl", awsWafRegionalWebAcl()).add("AwsWafRule", awsWafRule())
                .add("AwsWafRuleGroup", awsWafRuleGroup()).add("AwsEcsTask", awsEcsTask())
                .add("AwsBackupBackupVault", awsBackupBackupVault()).add("AwsBackupBackupPlan", awsBackupBackupPlan())
                .add("AwsBackupRecoveryPoint", awsBackupRecoveryPoint()).add("AwsEc2LaunchTemplate", awsEc2LaunchTemplate())
                .add("AwsSageMakerNotebookInstance", awsSageMakerNotebookInstance()).add("AwsWafv2WebAcl", awsWafv2WebAcl())
                .add("AwsWafv2RuleGroup", awsWafv2RuleGroup()).add("AwsEc2RouteTable", awsEc2RouteTable()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AwsAutoScalingAutoScalingGroup":
            return Optional.ofNullable(clazz.cast(awsAutoScalingAutoScalingGroup()));
        case "AwsCodeBuildProject":
            return Optional.ofNullable(clazz.cast(awsCodeBuildProject()));
        case "AwsCloudFrontDistribution":
            return Optional.ofNullable(clazz.cast(awsCloudFrontDistribution()));
        case "AwsEc2Instance":
            return Optional.ofNullable(clazz.cast(awsEc2Instance()));
        case "AwsEc2NetworkInterface":
            return Optional.ofNullable(clazz.cast(awsEc2NetworkInterface()));
        case "AwsEc2SecurityGroup":
            return Optional.ofNullable(clazz.cast(awsEc2SecurityGroup()));
        case "AwsEc2Volume":
            return Optional.ofNullable(clazz.cast(awsEc2Volume()));
        case "AwsEc2Vpc":
            return Optional.ofNullable(clazz.cast(awsEc2Vpc()));
        case "AwsEc2Eip":
            return Optional.ofNullable(clazz.cast(awsEc2Eip()));
        case "AwsEc2Subnet":
            return Optional.ofNullable(clazz.cast(awsEc2Subnet()));
        case "AwsEc2NetworkAcl":
            return Optional.ofNullable(clazz.cast(awsEc2NetworkAcl()));
        case "AwsElbv2LoadBalancer":
            return Optional.ofNullable(clazz.cast(awsElbv2LoadBalancer()));
        case "AwsElasticBeanstalkEnvironment":
            return Optional.ofNullable(clazz.cast(awsElasticBeanstalkEnvironment()));
        case "AwsElasticsearchDomain":
            return Optional.ofNullable(clazz.cast(awsElasticsearchDomain()));
        case "AwsS3Bucket":
            return Optional.ofNullable(clazz.cast(awsS3Bucket()));
        case "AwsS3AccountPublicAccessBlock":
            return Optional.ofNullable(clazz.cast(awsS3AccountPublicAccessBlock()));
        case "AwsS3Object":
            return Optional.ofNullable(clazz.cast(awsS3Object()));
        case "AwsSecretsManagerSecret":
            return Optional.ofNullable(clazz.cast(awsSecretsManagerSecret()));
        case "AwsIamAccessKey":
            return Optional.ofNullable(clazz.cast(awsIamAccessKey()));
        case "AwsIamUser":
            return Optional.ofNullable(clazz.cast(awsIamUser()));
        case "AwsIamPolicy":
            return Optional.ofNullable(clazz.cast(awsIamPolicy()));
        case "AwsApiGatewayV2Stage":
            return Optional.ofNullable(clazz.cast(awsApiGatewayV2Stage()));
        case "AwsApiGatewayV2Api":
            return Optional.ofNullable(clazz.cast(awsApiGatewayV2Api()));
        case "AwsDynamoDbTable":
            return Optional.ofNullable(clazz.cast(awsDynamoDbTable()));
        case "AwsApiGatewayStage":
            return Optional.ofNullable(clazz.cast(awsApiGatewayStage()));
        case "AwsApiGatewayRestApi":
            return Optional.ofNullable(clazz.cast(awsApiGatewayRestApi()));
        case "AwsCloudTrailTrail":
            return Optional.ofNullable(clazz.cast(awsCloudTrailTrail()));
        case "AwsSsmPatchCompliance":
            return Optional.ofNullable(clazz.cast(awsSsmPatchCompliance()));
        case "AwsCertificateManagerCertificate":
            return Optional.ofNullable(clazz.cast(awsCertificateManagerCertificate()));
        case "AwsRedshiftCluster":
            return Optional.ofNullable(clazz.cast(awsRedshiftCluster()));
        case "AwsElbLoadBalancer":
            return Optional.ofNullable(clazz.cast(awsElbLoadBalancer()));
        case "AwsIamGroup":
            return Optional.ofNullable(clazz.cast(awsIamGroup()));
        case "AwsIamRole":
            return Optional.ofNullable(clazz.cast(awsIamRole()));
        case "AwsKmsKey":
            return Optional.ofNullable(clazz.cast(awsKmsKey()));
        case "AwsLambdaFunction":
            return Optional.ofNullable(clazz.cast(awsLambdaFunction()));
        case "AwsLambdaLayerVersion":
            return Optional.ofNullable(clazz.cast(awsLambdaLayerVersion()));
        case "AwsRdsDbInstance":
            return Optional.ofNullable(clazz.cast(awsRdsDbInstance()));
        case "AwsSnsTopic":
            return Optional.ofNullable(clazz.cast(awsSnsTopic()));
        case "AwsSqsQueue":
            return Optional.ofNullable(clazz.cast(awsSqsQueue()));
        case "AwsWafWebAcl":
            return Optional.ofNullable(clazz.cast(awsWafWebAcl()));
        case "AwsRdsDbSnapshot":
            return Optional.ofNullable(clazz.cast(awsRdsDbSnapshot()));
        case "AwsRdsDbClusterSnapshot":
            return Optional.ofNullable(clazz.cast(awsRdsDbClusterSnapshot()));
        case "AwsRdsDbCluster":
            return Optional.ofNullable(clazz.cast(awsRdsDbCluster()));
        case "AwsEcsCluster":
            return Optional.ofNullable(clazz.cast(awsEcsCluster()));
        case "AwsEcsContainer":
            return Optional.ofNullable(clazz.cast(awsEcsContainer()));
        case "AwsEcsTaskDefinition":
            return Optional.ofNullable(clazz.cast(awsEcsTaskDefinition()));
        case "Container":
            return Optional.ofNullable(clazz.cast(container()));
        case "Other":
            return Optional.ofNullable(clazz.cast(other()));
        case "AwsRdsEventSubscription":
            return Optional.ofNullable(clazz.cast(awsRdsEventSubscription()));
        case "AwsEcsService":
            return Optional.ofNullable(clazz.cast(awsEcsService()));
        case "AwsAutoScalingLaunchConfiguration":
            return Optional.ofNullable(clazz.cast(awsAutoScalingLaunchConfiguration()));
        case "AwsEc2VpnConnection":
            return Optional.ofNullable(clazz.cast(awsEc2VpnConnection()));
        case "AwsEcrContainerImage":
            return Optional.ofNullable(clazz.cast(awsEcrContainerImage()));
        case "AwsOpenSearchServiceDomain":
            return Optional.ofNullable(clazz.cast(awsOpenSearchServiceDomain()));
        case "AwsEc2VpcEndpointService":
            return Optional.ofNullable(clazz.cast(awsEc2VpcEndpointService()));
        case "AwsXrayEncryptionConfig":
            return Optional.ofNullable(clazz.cast(awsXrayEncryptionConfig()));
        case "AwsWafRateBasedRule":
            return Optional.ofNullable(clazz.cast(awsWafRateBasedRule()));
        case "AwsWafRegionalRateBasedRule":
            return Optional.ofNullable(clazz.cast(awsWafRegionalRateBasedRule()));
        case "AwsEcrRepository":
            return Optional.ofNullable(clazz.cast(awsEcrRepository()));
        case "AwsEksCluster":
            return Optional.ofNullable(clazz.cast(awsEksCluster()));
        case "AwsNetworkFirewallFirewallPolicy":
            return Optional.ofNullable(clazz.cast(awsNetworkFirewallFirewallPolicy()));
        case "AwsNetworkFirewallFirewall":
            return Optional.ofNullable(clazz.cast(awsNetworkFirewallFirewall()));
        case "AwsNetworkFirewallRuleGroup":
            return Optional.ofNullable(clazz.cast(awsNetworkFirewallRuleGroup()));
        case "AwsRdsDbSecurityGroup":
            return Optional.ofNullable(clazz.cast(awsRdsDbSecurityGroup()));
        case "AwsKinesisStream":
            return Optional.ofNullable(clazz.cast(awsKinesisStream()));
        case "AwsEc2TransitGateway":
            return Optional.ofNullable(clazz.cast(awsEc2TransitGateway()));
        case "AwsEfsAccessPoint":
            return Optional.ofNullable(clazz.cast(awsEfsAccessPoint()));
        case "AwsCloudFormationStack":
            return Optional.ofNullable(clazz.cast(awsCloudFormationStack()));
        case "AwsCloudWatchAlarm":
            return Optional.ofNullable(clazz.cast(awsCloudWatchAlarm()));
        case "AwsEc2VpcPeeringConnection":
            return Optional.ofNullable(clazz.cast(awsEc2VpcPeeringConnection()));
        case "AwsWafRegionalRuleGroup":
            return Optional.ofNullable(clazz.cast(awsWafRegionalRuleGroup()));
        case "AwsWafRegionalRule":
            return Optional.ofNullable(clazz.cast(awsWafRegionalRule()));
        case "AwsWafRegionalWebAcl":
            return Optional.ofNullable(clazz.cast(awsWafRegionalWebAcl()));
        case "AwsWafRule":
            return Optional.ofNullable(clazz.cast(awsWafRule()));
        case "AwsWafRuleGroup":
            return Optional.ofNullable(clazz.cast(awsWafRuleGroup()));
        case "AwsEcsTask":
            return Optional.ofNullable(clazz.cast(awsEcsTask()));
        case "AwsBackupBackupVault":
            return Optional.ofNullable(clazz.cast(awsBackupBackupVault()));
        case "AwsBackupBackupPlan":
            return Optional.ofNullable(clazz.cast(awsBackupBackupPlan()));
        case "AwsBackupRecoveryPoint":
            return Optional.ofNullable(clazz.cast(awsBackupRecoveryPoint()));
        case "AwsEc2LaunchTemplate":
            return Optional.ofNullable(clazz.cast(awsEc2LaunchTemplate()));
        case "AwsSageMakerNotebookInstance":
            return Optional.ofNullable(clazz.cast(awsSageMakerNotebookInstance()));
        case "AwsWafv2WebAcl":
            return Optional.ofNullable(clazz.cast(awsWafv2WebAcl()));
        case "AwsWafv2RuleGroup":
            return Optional.ofNullable(clazz.cast(awsWafv2RuleGroup()));
        case "AwsEc2RouteTable":
            return Optional.ofNullable(clazz.cast(awsEc2RouteTable()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ResourceDetails, T> g) {
        return obj -> g.apply((ResourceDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ResourceDetails> {
        /**
         * <p>
         * Details for an autoscaling group.
         * </p>
         * 
         * @param awsAutoScalingAutoScalingGroup
         *        Details for an autoscaling group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsAutoScalingAutoScalingGroup(AwsAutoScalingAutoScalingGroupDetails awsAutoScalingAutoScalingGroup);

        /**
         * <p>
         * Details for an autoscaling group.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AwsAutoScalingAutoScalingGroupDetails.Builder} avoiding the need to create one manually via
         * {@link AwsAutoScalingAutoScalingGroupDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsAutoScalingAutoScalingGroupDetails.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #awsAutoScalingAutoScalingGroup(AwsAutoScalingAutoScalingGroupDetails)}.
         * 
         * @param awsAutoScalingAutoScalingGroup
         *        a consumer that will call methods on {@link AwsAutoScalingAutoScalingGroupDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #awsAutoScalingAutoScalingGroup(AwsAutoScalingAutoScalingGroupDetails)
         */
        default Builder awsAutoScalingAutoScalingGroup(
                Consumer<AwsAutoScalingAutoScalingGroupDetails.Builder> awsAutoScalingAutoScalingGroup) {
            return awsAutoScalingAutoScalingGroup(AwsAutoScalingAutoScalingGroupDetails.builder()
                    .applyMutation(awsAutoScalingAutoScalingGroup).build());
        }

        /**
         * <p>
         * Details for an CodeBuild project.
         * </p>
         * 
         * @param awsCodeBuildProject
         *        Details for an CodeBuild project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsCodeBuildProject(AwsCodeBuildProjectDetails awsCodeBuildProject);

        /**
         * <p>
         * Details for an CodeBuild project.
         * </p>
         * This is a convenience method that creates an instance of the {@link AwsCodeBuildProjectDetails.Builder}
         * avoiding the need to create one manually via {@link AwsCodeBuildProjectDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsCodeBuildProjectDetails.Builder#build()} is called immediately
         * and its result is passed to {@link #awsCodeBuildProject(AwsCodeBuildProjectDetails)}.
         * 
         * @param awsCodeBuildProject
         *        a consumer that will call methods on {@link AwsCodeBuildProjectDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #awsCodeBuildProject(AwsCodeBuildProjectDetails)
         */
        default Builder awsCodeBuildProject(Consumer<AwsCodeBuildProjectDetails.Builder> awsCodeBuildProject) {
            return awsCodeBuildProject(AwsCodeBuildProjectDetails.builder().applyMutation(awsCodeBuildProject).build());
        }

        /**
         * <p>
         * Details about a CloudFront distribution.
         * </p>
         * 
         * @param awsCloudFrontDistribution
         *        Details about a CloudFront distribution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsCloudFrontDistribution(AwsCloudFrontDistributionDetails awsCloudFrontDistribution);

        /**
         * <p>
         * Details about a CloudFront distribution.
         * </p>
         * This is a convenience method that creates an instance of the {@link AwsCloudFrontDistributionDetails.Builder}
         * avoiding the need to create one manually via {@link AwsCloudFrontDistributionDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsCloudFrontDistributionDetails.Builder#build()} is called
         * immediately and its result is passed to {@link #awsCloudFrontDistribution(AwsCloudFrontDistributionDetails)}.
         * 
         * @param awsCloudFrontDistribution
         *        a consumer that will call methods on {@link AwsCloudFrontDistributionDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #awsCloudFrontDistribution(AwsCloudFrontDistributionDetails)
         */
        default Builder awsCloudFrontDistribution(Consumer<AwsCloudFrontDistributionDetails.Builder> awsCloudFrontDistribution) {
            return awsCloudFrontDistribution(AwsCloudFrontDistributionDetails.builder().applyMutation(awsCloudFrontDistribution)
                    .build());
        }

        /**
         * <p>
         * Details about an EC2 instance related to a finding.
         * </p>
         * 
         * @param awsEc2Instance
         *        Details about an EC2 instance related to a finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsEc2Instance(AwsEc2InstanceDetails awsEc2Instance);

        /**
         * <p>
         * Details about an EC2 instance related to a finding.
         * </p>
         * This is a convenience method that creates an instance of the {@link AwsEc2InstanceDetails.Builder} avoiding
         * the need to create one manually via {@link AwsEc2InstanceDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsEc2InstanceDetails.Builder#build()} is called immediately and
         * its result is passed to {@link #awsEc2Instance(AwsEc2InstanceDetails)}.
         * 
         * @param awsEc2Instance
         *        a consumer that will call methods on {@link AwsEc2InstanceDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #awsEc2Instance(AwsEc2InstanceDetails)
         */
        default Builder awsEc2Instance(Consumer<AwsEc2InstanceDetails.Builder> awsEc2Instance) {
            return awsEc2Instance(AwsEc2InstanceDetails.builder().applyMutation(awsEc2Instance).build());
        }

        /**
         * <p>
         * Details for an EC2 network interface.
         * </p>
         * 
         * @param awsEc2NetworkInterface
         *        Details for an EC2 network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsEc2NetworkInterface(AwsEc2NetworkInterfaceDetails awsEc2NetworkInterface);

        /**
         * <p>
         * Details for an EC2 network interface.
         * </p>
         * This is a convenience method that creates an instance of the {@link AwsEc2NetworkInterfaceDetails.Builder}
         * avoiding the need to create one manually via {@link AwsEc2NetworkInterfaceDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsEc2NetworkInterfaceDetails.Builder#build()} is called
         * immediately and its result is passed to {@link #awsEc2NetworkInterface(AwsEc2NetworkInterfaceDetails)}.
         * 
         * @param awsEc2NetworkInterface
         *        a consumer that will call methods on {@link AwsEc2NetworkInterfaceDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #awsEc2NetworkInterface(AwsEc2NetworkInterfaceDetails)
         */
        default Builder awsEc2NetworkInterface(Consumer<AwsEc2NetworkInterfaceDetails.Builder> awsEc2NetworkInterface) {
            return awsEc2NetworkInterface(AwsEc2NetworkInterfaceDetails.builder().applyMutation(awsEc2NetworkInterface).build());
        }

        /**
         * <p>
         * Details for an EC2 security group.
         * </p>
         * 
         * @param awsEc2SecurityGroup
         *        Details for an EC2 security group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsEc2SecurityGroup(AwsEc2SecurityGroupDetails awsEc2SecurityGroup);

        /**
         * <p>
         * Details for an EC2 security group.
         * </p>
         * This is a convenience method that creates an instance of the {@link AwsEc2SecurityGroupDetails.Builder}
         * avoiding the need to create one manually via {@link AwsEc2SecurityGroupDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsEc2SecurityGroupDetails.Builder#build()} is called immediately
         * and its result is passed to {@link #awsEc2SecurityGroup(AwsEc2SecurityGroupDetails)}.
         * 
         * @param awsEc2SecurityGroup
         *        a consumer that will call methods on {@link AwsEc2SecurityGroupDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #awsEc2SecurityGroup(AwsEc2SecurityGroupDetails)
         */
        default Builder awsEc2SecurityGroup(Consumer<AwsEc2SecurityGroupDetails.Builder> awsEc2SecurityGroup) {
            return awsEc2SecurityGroup(AwsEc2SecurityGroupDetails.builder().applyMutation(awsEc2SecurityGroup).build());
        }

        /**
         * <p>
         * Details for an Amazon EC2 volume.
         * </p>
         * 
         * @param awsEc2Volume
         *        Details for an Amazon EC2 volume.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsEc2Volume(AwsEc2VolumeDetails awsEc2Volume);

        /**
         * <p>
         * Details for an Amazon EC2 volume.
         * </p>
         * This is a convenience method that creates an instance of the {@link AwsEc2VolumeDetails.Builder} avoiding the
         * need to create one manually via {@link AwsEc2VolumeDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsEc2VolumeDetails.Builder#build()} is called immediately and
         * its result is passed to {@link #awsEc2Volume(AwsEc2VolumeDetails)}.
         * 
         * @param awsEc2Volume
         *        a consumer that will call methods on {@link AwsEc2VolumeDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #awsEc2Volume(AwsEc2VolumeDetails)
         */
        default Builder awsEc2Volume(Consumer<AwsEc2VolumeDetails.Builder> awsEc2Volume) {
            return awsEc2Volume(AwsEc2VolumeDetails.builder().applyMutation(awsEc2Volume).build());
        }

        /**
         * <p>
         * Details for an Amazon EC2 VPC.
         * </p>
         * 
         * @param awsEc2Vpc
         *        Details for an Amazon EC2 VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsEc2Vpc(AwsEc2VpcDetails awsEc2Vpc);

        /**
         * <p>
         * Details for an Amazon EC2 VPC.
         * </p>
         * This is a convenience method that creates an instance of the {@link AwsEc2VpcDetails.Builder} avoiding the
         * need to create one manually via {@link AwsEc2VpcDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsEc2VpcDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #awsEc2Vpc(AwsEc2VpcDetails)}.
         * 
         * @param awsEc2Vpc
         *        a consumer that will call methods on {@link AwsEc2VpcDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #awsEc2Vpc(AwsEc2VpcDetails)
         */
        default Builder awsEc2Vpc(Consumer<AwsEc2VpcDetails.Builder> awsEc2Vpc) {
            return awsEc2Vpc(AwsEc2VpcDetails.builder().applyMutation(awsEc2Vpc).build());
        }

        /**
         * <p>
         * Details about an Elastic IP address.
         * </p>
         * 
         * @param awsEc2Eip
         *        Details about an Elastic IP address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsEc2Eip(AwsEc2EipDetails awsEc2Eip);

        /**
         * <p>
         * Details about an Elastic IP address.
         * </p>
         * This is a convenience method that creates an instance of the {@link AwsEc2EipDetails.Builder} avoiding the
         * need to create one manually via {@link AwsEc2EipDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsEc2EipDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #awsEc2Eip(AwsEc2EipDetails)}.
         * 
         * @param awsEc2Eip
         *        a consumer that will call methods on {@link AwsEc2EipDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #awsEc2Eip(AwsEc2EipDetails)
         */
        default Builder awsEc2Eip(Consumer<AwsEc2EipDetails.Builder> awsEc2Eip) {
            return awsEc2Eip(AwsEc2EipDetails.builder().applyMutation(awsEc2Eip).build());
        }

        /**
         * <p>
         * Details about a subnet in Amazon EC2.
         * </p>
         * 
         * @param awsEc2Subnet
         *        Details about a subnet in Amazon EC2.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsEc2Subnet(AwsEc2SubnetDetails awsEc2Subnet);

        /**
         * <p>
         * Details about a subnet in Amazon EC2.
         * </p>
         * This is a convenience method that creates an instance of the {@link AwsEc2SubnetDetails.Builder} avoiding the
         * need to create one manually via {@link AwsEc2SubnetDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsEc2SubnetDetails.Builder#build()} is called immediately and
         * its result is passed to {@link #awsEc2Subnet(AwsEc2SubnetDetails)}.
         * 
         * @param awsEc2Subnet
         *        a consumer that will call methods on {@link AwsEc2SubnetDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #awsEc2Subnet(AwsEc2SubnetDetails)
         */
        default Builder awsEc2Subnet(Consumer<AwsEc2SubnetDetails.Builder> awsEc2Subnet) {
            return awsEc2Subnet(AwsEc2SubnetDetails.builder().applyMutation(awsEc2Subnet).build());
        }

        /**
         * <p>
         * Details about an EC2 network access control list (ACL).
         * </p>
         * 
         * @param awsEc2NetworkAcl
         *        Details about an EC2 network access control list (ACL).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsEc2NetworkAcl(AwsEc2NetworkAclDetails awsEc2NetworkAcl);

        /**
         * <p>
         * Details about an EC2 network access control list (ACL).
         * </p>
         * This is a convenience method that creates an instance of the {@link AwsEc2NetworkAclDetails.Builder} avoiding
         * the need to create one manually via {@link AwsEc2NetworkAclDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsEc2NetworkAclDetails.Builder#build()} is called immediately
         * and its result is passed to {@link #awsEc2NetworkAcl(AwsEc2NetworkAclDetails)}.
         * 
         * @param awsEc2NetworkAcl
         *        a consumer that will call methods on {@link AwsEc2NetworkAclDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #awsEc2NetworkAcl(AwsEc2NetworkAclDetails)
         */
        default Builder awsEc2NetworkAcl(Consumer<AwsEc2NetworkAclDetails.Builder> awsEc2NetworkAcl) {
            return awsEc2NetworkAcl(AwsEc2NetworkAclDetails.builder().applyMutation(awsEc2NetworkAcl).build());
        }

        /**
         * <p>
         * Details about a load balancer.
         * </p>
         * 
         * @param awsElbv2LoadBalancer
         *        Details about a load balancer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsElbv2LoadBalancer(AwsElbv2LoadBalancerDetails awsElbv2LoadBalancer);

        /**
         * <p>
         * Details about a load balancer.
         * </p>
         * This is a convenience method that creates an instance of the {@link AwsElbv2LoadBalancerDetails.Builder}
         * avoiding the need to create one manually via {@link AwsElbv2LoadBalancerDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsElbv2LoadBalancerDetails.Builder#build()} is called
         * immediately and its result is passed to {@link #awsElbv2LoadBalancer(AwsElbv2LoadBalancerDetails)}.
         * 
         * @param awsElbv2LoadBalancer
         *        a consumer that will call methods on {@link AwsElbv2LoadBalancerDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #awsElbv2LoadBalancer(AwsElbv2LoadBalancerDetails)
         */
        default Builder awsElbv2LoadBalancer(Consumer<AwsElbv2LoadBalancerDetails.Builder> awsElbv2LoadBalancer) {
            return awsElbv2LoadBalancer(AwsElbv2LoadBalancerDetails.builder().applyMutation(awsElbv2LoadBalancer).build());
        }

        /**
         * <p>
         * Details about an Elastic Beanstalk environment.
         * </p>
         * 
         * @param awsElasticBeanstalkEnvironment
         *        Details about an Elastic Beanstalk environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsElasticBeanstalkEnvironment(AwsElasticBeanstalkEnvironmentDetails awsElasticBeanstalkEnvironment);

        /**
         * <p>
         * Details about an Elastic Beanstalk environment.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AwsElasticBeanstalkEnvironmentDetails.Builder} avoiding the need to create one manually via
         * {@link AwsElasticBeanstalkEnvironmentDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsElasticBeanstalkEnvironmentDetails.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #awsElasticBeanstalkEnvironment(AwsElasticBeanstalkEnvironmentDetails)}.
         * 
         * @param awsElasticBeanstalkEnvironment
         *        a consumer that will call methods on {@link AwsElasticBeanstalkEnvironmentDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #awsElasticBeanstalkEnvironment(AwsElasticBeanstalkEnvironmentDetails)
         */
        default Builder awsElasticBeanstalkEnvironment(
                Consumer<AwsElasticBeanstalkEnvironmentDetails.Builder> awsElasticBeanstalkEnvironment) {
            return awsElasticBeanstalkEnvironment(AwsElasticBeanstalkEnvironmentDetails.builder()
                    .applyMutation(awsElasticBeanstalkEnvironment).build());
        }

        /**
         * <p>
         * Details for an Elasticsearch domain.
         * </p>
         * 
         * @param awsElasticsearchDomain
         *        Details for an Elasticsearch domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsElasticsearchDomain(AwsElasticsearchDomainDetails awsElasticsearchDomain);

        /**
         * <p>
         * Details for an Elasticsearch domain.
         * </p>
         * This is a convenience method that creates an instance of the {@link AwsElasticsearchDomainDetails.Builder}
         * avoiding the need to create one manually via {@link AwsElasticsearchDomainDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsElasticsearchDomainDetails.Builder#build()} is called
         * immediately and its result is passed to {@link #awsElasticsearchDomain(AwsElasticsearchDomainDetails)}.
         * 
         * @param awsElasticsearchDomain
         *        a consumer that will call methods on {@link AwsElasticsearchDomainDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #awsElasticsearchDomain(AwsElasticsearchDomainDetails)
         */
        default Builder awsElasticsearchDomain(Consumer<AwsElasticsearchDomainDetails.Builder> awsElasticsearchDomain) {
            return awsElasticsearchDomain(AwsElasticsearchDomainDetails.builder().applyMutation(awsElasticsearchDomain).build());
        }

        /**
         * <p>
         * Details about an S3 bucket related to a finding.
         * </p>
         * 
         * @param awsS3Bucket
         *        Details about an S3 bucket related to a finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsS3Bucket(AwsS3BucketDetails awsS3Bucket);

        /**
         * <p>
         * Details about an S3 bucket related to a finding.
         * </p>
         * This is a convenience method that creates an instance of the {@link AwsS3BucketDetails.Builder} avoiding the
         * need to create one manually via {@link AwsS3BucketDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsS3BucketDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #awsS3Bucket(AwsS3BucketDetails)}.
         * 
         * @param awsS3Bucket
         *        a consumer that will call methods on {@link AwsS3BucketDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #awsS3Bucket(AwsS3BucketDetails)
         */
        default Builder awsS3Bucket(Consumer<AwsS3BucketDetails.Builder> awsS3Bucket) {
            return awsS3Bucket(AwsS3BucketDetails.builder().applyMutation(awsS3Bucket).build());
        }

        /**
         * <p>
         * Details about the Amazon S3 Public Access Block configuration for an account.
         * </p>
         * 
         * @param awsS3AccountPublicAccessBlock
         *        Details about the Amazon S3 Public Access Block configuration for an account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsS3AccountPublicAccessBlock(AwsS3AccountPublicAccessBlockDetails awsS3AccountPublicAccessBlock);

        /**
         * <p>
         * Details about the Amazon S3 Public Access Block configuration for an account.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AwsS3AccountPublicAccessBlockDetails.Builder} avoiding the need to create one manually via
         * {@link AwsS3AccountPublicAccessBlockDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsS3AccountPublicAccessBlockDetails.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #awsS3AccountPublicAccessBlock(AwsS3AccountPublicAccessBlockDetails)}.
         * 
         * @param awsS3AccountPublicAccessBlock
         *        a consumer that will call methods on {@link AwsS3AccountPublicAccessBlockDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #awsS3AccountPublicAccessBlock(AwsS3AccountPublicAccessBlockDetails)
         */
        default Builder awsS3AccountPublicAccessBlock(
                Consumer<AwsS3AccountPublicAccessBlockDetails.Builder> awsS3AccountPublicAccessBlock) {
            return awsS3AccountPublicAccessBlock(AwsS3AccountPublicAccessBlockDetails.builder()
                    .applyMutation(awsS3AccountPublicAccessBlock).build());
        }

        /**
         * <p>
         * Details about an S3 object related to a finding.
         * </p>
         * 
         * @param awsS3Object
         *        Details about an S3 object related to a finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsS3Object(AwsS3ObjectDetails awsS3Object);

        /**
         * <p>
         * Details about an S3 object related to a finding.
         * </p>
         * This is a convenience method that creates an instance of the {@link AwsS3ObjectDetails.Builder} avoiding the
         * need to create one manually via {@link AwsS3ObjectDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsS3ObjectDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #awsS3Object(AwsS3ObjectDetails)}.
         * 
         * @param awsS3Object
         *        a consumer that will call methods on {@link AwsS3ObjectDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #awsS3Object(AwsS3ObjectDetails)
         */
        default Builder awsS3Object(Consumer<AwsS3ObjectDetails.Builder> awsS3Object) {
            return awsS3Object(AwsS3ObjectDetails.builder().applyMutation(awsS3Object).build());
        }

        /**
         * <p>
         * Details about a Secrets Manager secret.
         * </p>
         * 
         * @param awsSecretsManagerSecret
         *        Details about a Secrets Manager secret.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsSecretsManagerSecret(AwsSecretsManagerSecretDetails awsSecretsManagerSecret);

        /**
         * <p>
         * Details about a Secrets Manager secret.
         * </p>
         * This is a convenience method that creates an instance of the {@link AwsSecretsManagerSecretDetails.Builder}
         * avoiding the need to create one manually via {@link AwsSecretsManagerSecretDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsSecretsManagerSecretDetails.Builder#build()} is called
         * immediately and its result is passed to {@link #awsSecretsManagerSecret(AwsSecretsManagerSecretDetails)}.
         * 
         * @param awsSecretsManagerSecret
         *        a consumer that will call methods on {@link AwsSecretsManagerSecretDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #awsSecretsManagerSecret(AwsSecretsManagerSecretDetails)
         */
        default Builder awsSecretsManagerSecret(Consumer<AwsSecretsManagerSecretDetails.Builder> awsSecretsManagerSecret) {
            return awsSecretsManagerSecret(AwsSecretsManagerSecretDetails.builder().applyMutation(awsSecretsManagerSecret)
                    .build());
        }

        /**
         * <p>
         * Details about an IAM access key related to a finding.
         * </p>
         * 
         * @param awsIamAccessKey
         *        Details about an IAM access key related to a finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsIamAccessKey(AwsIamAccessKeyDetails awsIamAccessKey);

        /**
         * <p>
         * Details about an IAM access key related to a finding.
         * </p>
         * This is a convenience method that creates an instance of the {@link AwsIamAccessKeyDetails.Builder} avoiding
         * the need to create one manually via {@link AwsIamAccessKeyDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsIamAccessKeyDetails.Builder#build()} is called immediately and
         * its result is passed to {@link #awsIamAccessKey(AwsIamAccessKeyDetails)}.
         * 
         * @param awsIamAccessKey
         *        a consumer that will call methods on {@link AwsIamAccessKeyDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #awsIamAccessKey(AwsIamAccessKeyDetails)
         */
        default Builder awsIamAccessKey(Consumer<AwsIamAccessKeyDetails.Builder> awsIamAccessKey) {
            return awsIamAccessKey(AwsIamAccessKeyDetails.builder().applyMutation(awsIamAccessKey).build());
        }

        /**
         * <p>
         * Details about an IAM user.
         * </p>
         * 
         * @param awsIamUser
         *        Details about an IAM user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsIamUser(AwsIamUserDetails awsIamUser);

        /**
         * <p>
         * Details about an IAM user.
         * </p>
         * This is a convenience method that creates an instance of the {@link AwsIamUserDetails.Builder} avoiding the
         * need to create one manually via {@link AwsIamUserDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsIamUserDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #awsIamUser(AwsIamUserDetails)}.
         * 
         * @param awsIamUser
         *        a consumer that will call methods on {@link AwsIamUserDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #awsIamUser(AwsIamUserDetails)
         */
        default Builder awsIamUser(Consumer<AwsIamUserDetails.Builder> awsIamUser) {
            return awsIamUser(AwsIamUserDetails.builder().applyMutation(awsIamUser).build());
        }

        /**
         * <p>
         * Details about an IAM permissions policy.
         * </p>
         * 
         * @param awsIamPolicy
         *        Details about an IAM permissions policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsIamPolicy(AwsIamPolicyDetails awsIamPolicy);

        /**
         * <p>
         * Details about an IAM permissions policy.
         * </p>
         * This is a convenience method that creates an instance of the {@link AwsIamPolicyDetails.Builder} avoiding the
         * need to create one manually via {@link AwsIamPolicyDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsIamPolicyDetails.Builder#build()} is called immediately and
         * its result is passed to {@link #awsIamPolicy(AwsIamPolicyDetails)}.
         * 
         * @param awsIamPolicy
         *        a consumer that will call methods on {@link AwsIamPolicyDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #awsIamPolicy(AwsIamPolicyDetails)
         */
        default Builder awsIamPolicy(Consumer<AwsIamPolicyDetails.Builder> awsIamPolicy) {
            return awsIamPolicy(AwsIamPolicyDetails.builder().applyMutation(awsIamPolicy).build());
        }

        /**
         * <p>
         * Provides information about a version 2 stage for Amazon API Gateway.
         * </p>
         * 
         * @param awsApiGatewayV2Stage
         *        Provides information about a version 2 stage for Amazon API Gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsApiGatewayV2Stage(AwsApiGatewayV2StageDetails awsApiGatewayV2Stage);

        /**
         * <p>
         * Provides information about a version 2 stage for Amazon API Gateway.
         * </p>
         * This is a convenience method that creates an instance of the {@link AwsApiGatewayV2StageDetails.Builder}
         * avoiding the need to create one manually via {@link AwsApiGatewayV2StageDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsApiGatewayV2StageDetails.Builder#build()} is called
         * immediately and its result is passed to {@link #awsApiGatewayV2Stage(AwsApiGatewayV2StageDetails)}.
         * 
         * @param awsApiGatewayV2Stage
         *        a consumer that will call methods on {@link AwsApiGatewayV2StageDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #awsApiGatewayV2Stage(AwsApiGatewayV2StageDetails)
         */
        default Builder awsApiGatewayV2Stage(Consumer<AwsApiGatewayV2StageDetails.Builder> awsApiGatewayV2Stage) {
            return awsApiGatewayV2Stage(AwsApiGatewayV2StageDetails.builder().applyMutation(awsApiGatewayV2Stage).build());
        }

        /**
         * <p>
         * Provides information about a version 2 API in Amazon API Gateway.
         * </p>
         * 
         * @param awsApiGatewayV2Api
         *        Provides information about a version 2 API in Amazon API Gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsApiGatewayV2Api(AwsApiGatewayV2ApiDetails awsApiGatewayV2Api);

        /**
         * <p>
         * Provides information about a version 2 API in Amazon API Gateway.
         * </p>
         * This is a convenience method that creates an instance of the {@link AwsApiGatewayV2ApiDetails.Builder}
         * avoiding the need to create one manually via {@link AwsApiGatewayV2ApiDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsApiGatewayV2ApiDetails.Builder#build()} is called immediately
         * and its result is passed to {@link #awsApiGatewayV2Api(AwsApiGatewayV2ApiDetails)}.
         * 
         * @param awsApiGatewayV2Api
         *        a consumer that will call methods on {@link AwsApiGatewayV2ApiDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #awsApiGatewayV2Api(AwsApiGatewayV2ApiDetails)
         */
        default Builder awsApiGatewayV2Api(Consumer<AwsApiGatewayV2ApiDetails.Builder> awsApiGatewayV2Api) {
            return awsApiGatewayV2Api(AwsApiGatewayV2ApiDetails.builder().applyMutation(awsApiGatewayV2Api).build());
        }

        /**
         * <p>
         * Details about a DynamoDB table.
         * </p>
         * 
         * @param awsDynamoDbTable
         *        Details about a DynamoDB table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsDynamoDbTable(AwsDynamoDbTableDetails awsDynamoDbTable);

        /**
         * <p>
         * Details about a DynamoDB table.
         * </p>
         * This is a convenience method that creates an instance of the {@link AwsDynamoDbTableDetails.Builder} avoiding
         * the need to create one manually via {@link AwsDynamoDbTableDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsDynamoDbTableDetails.Builder#build()} is called immediately
         * and its result is passed to {@link #awsDynamoDbTable(AwsDynamoDbTableDetails)}.
         * 
         * @param awsDynamoDbTable
         *        a consumer that will call methods on {@link AwsDynamoDbTableDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #awsDynamoDbTable(AwsDynamoDbTableDetails)
         */
        default Builder awsDynamoDbTable(Consumer<AwsDynamoDbTableDetails.Builder> awsDynamoDbTable) {
            return awsDynamoDbTable(AwsDynamoDbTableDetails.builder().applyMutation(awsDynamoDbTable).build());
        }

        /**
         * <p>
         * Provides information about a version 1 Amazon API Gateway stage.
         * </p>
         * 
         * @param awsApiGatewayStage
         *        Provides information about a version 1 Amazon API Gateway stage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsApiGatewayStage(AwsApiGatewayStageDetails awsApiGatewayStage);

        /**
         * <p>
         * Provides information about a version 1 Amazon API Gateway stage.
         * </p>
         * This is a convenience method that creates an instance of the {@link AwsApiGatewayStageDetails.Builder}
         * avoiding the need to create one manually via {@link AwsApiGatewayStageDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsApiGatewayStageDetails.Builder#build()} is called immediately
         * and its result is passed to {@link #awsApiGatewayStage(AwsApiGatewayStageDetails)}.
         * 
         * @param awsApiGatewayStage
         *        a consumer that will call methods on {@link AwsApiGatewayStageDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #awsApiGatewayStage(AwsApiGatewayStageDetails)
         */
        default Builder awsApiGatewayStage(Consumer<AwsApiGatewayStageDetails.Builder> awsApiGatewayStage) {
            return awsApiGatewayStage(AwsApiGatewayStageDetails.builder().applyMutation(awsApiGatewayStage).build());
        }

        /**
         * <p>
         * Provides information about a REST API in version 1 of Amazon API Gateway.
         * </p>
         * 
         * @param awsApiGatewayRestApi
         *        Provides information about a REST API in version 1 of Amazon API Gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsApiGatewayRestApi(AwsApiGatewayRestApiDetails awsApiGatewayRestApi);

        /**
         * <p>
         * Provides information about a REST API in version 1 of Amazon API Gateway.
         * </p>
         * This is a convenience method that creates an instance of the {@link AwsApiGatewayRestApiDetails.Builder}
         * avoiding the need to create one manually via {@link AwsApiGatewayRestApiDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsApiGatewayRestApiDetails.Builder#build()} is called
         * immediately and its result is passed to {@link #awsApiGatewayRestApi(AwsApiGatewayRestApiDetails)}.
         * 
         * @param awsApiGatewayRestApi
         *        a consumer that will call methods on {@link AwsApiGatewayRestApiDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #awsApiGatewayRestApi(AwsApiGatewayRestApiDetails)
         */
        default Builder awsApiGatewayRestApi(Consumer<AwsApiGatewayRestApiDetails.Builder> awsApiGatewayRestApi) {
            return awsApiGatewayRestApi(AwsApiGatewayRestApiDetails.builder().applyMutation(awsApiGatewayRestApi).build());
        }

        /**
         * <p>
         * Provides details about a CloudTrail trail.
         * </p>
         * 
         * @param awsCloudTrailTrail
         *        Provides details about a CloudTrail trail.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsCloudTrailTrail(AwsCloudTrailTrailDetails awsCloudTrailTrail);

        /**
         * <p>
         * Provides details about a CloudTrail trail.
         * </p>
         * This is a convenience method that creates an instance of the {@link AwsCloudTrailTrailDetails.Builder}
         * avoiding the need to create one manually via {@link AwsCloudTrailTrailDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsCloudTrailTrailDetails.Builder#build()} is called immediately
         * and its result is passed to {@link #awsCloudTrailTrail(AwsCloudTrailTrailDetails)}.
         * 
         * @param awsCloudTrailTrail
         *        a consumer that will call methods on {@link AwsCloudTrailTrailDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #awsCloudTrailTrail(AwsCloudTrailTrailDetails)
         */
        default Builder awsCloudTrailTrail(Consumer<AwsCloudTrailTrailDetails.Builder> awsCloudTrailTrail) {
            return awsCloudTrailTrail(AwsCloudTrailTrailDetails.builder().applyMutation(awsCloudTrailTrail).build());
        }

        /**
         * <p>
         * Provides information about the state of a patch on an instance based on the patch baseline that was used to
         * patch the instance.
         * </p>
         * 
         * @param awsSsmPatchCompliance
         *        Provides information about the state of a patch on an instance based on the patch baseline that was
         *        used to patch the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsSsmPatchCompliance(AwsSsmPatchComplianceDetails awsSsmPatchCompliance);

        /**
         * <p>
         * Provides information about the state of a patch on an instance based on the patch baseline that was used to
         * patch the instance.
         * </p>
         * This is a convenience method that creates an instance of the {@link AwsSsmPatchComplianceDetails.Builder}
         * avoiding the need to create one manually via {@link AwsSsmPatchComplianceDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsSsmPatchComplianceDetails.Builder#build()} is called
         * immediately and its result is passed to {@link #awsSsmPatchCompliance(AwsSsmPatchComplianceDetails)}.
         * 
         * @param awsSsmPatchCompliance
         *        a consumer that will call methods on {@link AwsSsmPatchComplianceDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #awsSsmPatchCompliance(AwsSsmPatchComplianceDetails)
         */
        default Builder awsSsmPatchCompliance(Consumer<AwsSsmPatchComplianceDetails.Builder> awsSsmPatchCompliance) {
            return awsSsmPatchCompliance(AwsSsmPatchComplianceDetails.builder().applyMutation(awsSsmPatchCompliance).build());
        }

        /**
         * <p>
         * Provides details about an Certificate Manager certificate.
         * </p>
         * 
         * @param awsCertificateManagerCertificate
         *        Provides details about an Certificate Manager certificate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsCertificateManagerCertificate(AwsCertificateManagerCertificateDetails awsCertificateManagerCertificate);

        /**
         * <p>
         * Provides details about an Certificate Manager certificate.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AwsCertificateManagerCertificateDetails.Builder} avoiding the need to create one manually via
         * {@link AwsCertificateManagerCertificateDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsCertificateManagerCertificateDetails.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #awsCertificateManagerCertificate(AwsCertificateManagerCertificateDetails)}.
         * 
         * @param awsCertificateManagerCertificate
         *        a consumer that will call methods on {@link AwsCertificateManagerCertificateDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #awsCertificateManagerCertificate(AwsCertificateManagerCertificateDetails)
         */
        default Builder awsCertificateManagerCertificate(
                Consumer<AwsCertificateManagerCertificateDetails.Builder> awsCertificateManagerCertificate) {
            return awsCertificateManagerCertificate(AwsCertificateManagerCertificateDetails.builder()
                    .applyMutation(awsCertificateManagerCertificate).build());
        }

        /**
         * <p>
         * Contains details about an Amazon Redshift cluster.
         * </p>
         * 
         * @param awsRedshiftCluster
         *        Contains details about an Amazon Redshift cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsRedshiftCluster(AwsRedshiftClusterDetails awsRedshiftCluster);

        /**
         * <p>
         * Contains details about an Amazon Redshift cluster.
         * </p>
         * This is a convenience method that creates an instance of the {@link AwsRedshiftClusterDetails.Builder}
         * avoiding the need to create one manually via {@link AwsRedshiftClusterDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsRedshiftClusterDetails.Builder#build()} is called immediately
         * and its result is passed to {@link #awsRedshiftCluster(AwsRedshiftClusterDetails)}.
         * 
         * @param awsRedshiftCluster
         *        a consumer that will call methods on {@link AwsRedshiftClusterDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #awsRedshiftCluster(AwsRedshiftClusterDetails)
         */
        default Builder awsRedshiftCluster(Consumer<AwsRedshiftClusterDetails.Builder> awsRedshiftCluster) {
            return awsRedshiftCluster(AwsRedshiftClusterDetails.builder().applyMutation(awsRedshiftCluster).build());
        }

        /**
         * <p>
         * Contains details about a Classic Load Balancer.
         * </p>
         * 
         * @param awsElbLoadBalancer
         *        Contains details about a Classic Load Balancer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsElbLoadBalancer(AwsElbLoadBalancerDetails awsElbLoadBalancer);

        /**
         * <p>
         * Contains details about a Classic Load Balancer.
         * </p>
         * This is a convenience method that creates an instance of the {@link AwsElbLoadBalancerDetails.Builder}
         * avoiding the need to create one manually via {@link AwsElbLoadBalancerDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsElbLoadBalancerDetails.Builder#build()} is called immediately
         * and its result is passed to {@link #awsElbLoadBalancer(AwsElbLoadBalancerDetails)}.
         * 
         * @param awsElbLoadBalancer
         *        a consumer that will call methods on {@link AwsElbLoadBalancerDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #awsElbLoadBalancer(AwsElbLoadBalancerDetails)
         */
        default Builder awsElbLoadBalancer(Consumer<AwsElbLoadBalancerDetails.Builder> awsElbLoadBalancer) {
            return awsElbLoadBalancer(AwsElbLoadBalancerDetails.builder().applyMutation(awsElbLoadBalancer).build());
        }

        /**
         * <p>
         * Contains details about an IAM group.
         * </p>
         * 
         * @param awsIamGroup
         *        Contains details about an IAM group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsIamGroup(AwsIamGroupDetails awsIamGroup);

        /**
         * <p>
         * Contains details about an IAM group.
         * </p>
         * This is a convenience method that creates an instance of the {@link AwsIamGroupDetails.Builder} avoiding the
         * need to create one manually via {@link AwsIamGroupDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsIamGroupDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #awsIamGroup(AwsIamGroupDetails)}.
         * 
         * @param awsIamGroup
         *        a consumer that will call methods on {@link AwsIamGroupDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #awsIamGroup(AwsIamGroupDetails)
         */
        default Builder awsIamGroup(Consumer<AwsIamGroupDetails.Builder> awsIamGroup) {
            return awsIamGroup(AwsIamGroupDetails.builder().applyMutation(awsIamGroup).build());
        }

        /**
         * <p>
         * Details about an IAM role.
         * </p>
         * 
         * @param awsIamRole
         *        Details about an IAM role.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsIamRole(AwsIamRoleDetails awsIamRole);

        /**
         * <p>
         * Details about an IAM role.
         * </p>
         * This is a convenience method that creates an instance of the {@link AwsIamRoleDetails.Builder} avoiding the
         * need to create one manually via {@link AwsIamRoleDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsIamRoleDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #awsIamRole(AwsIamRoleDetails)}.
         * 
         * @param awsIamRole
         *        a consumer that will call methods on {@link AwsIamRoleDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #awsIamRole(AwsIamRoleDetails)
         */
        default Builder awsIamRole(Consumer<AwsIamRoleDetails.Builder> awsIamRole) {
            return awsIamRole(AwsIamRoleDetails.builder().applyMutation(awsIamRole).build());
        }

        /**
         * <p>
         * Details about an KMS key.
         * </p>
         * 
         * @param awsKmsKey
         *        Details about an KMS key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsKmsKey(AwsKmsKeyDetails awsKmsKey);

        /**
         * <p>
         * Details about an KMS key.
         * </p>
         * This is a convenience method that creates an instance of the {@link AwsKmsKeyDetails.Builder} avoiding the
         * need to create one manually via {@link AwsKmsKeyDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsKmsKeyDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #awsKmsKey(AwsKmsKeyDetails)}.
         * 
         * @param awsKmsKey
         *        a consumer that will call methods on {@link AwsKmsKeyDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #awsKmsKey(AwsKmsKeyDetails)
         */
        default Builder awsKmsKey(Consumer<AwsKmsKeyDetails.Builder> awsKmsKey) {
            return awsKmsKey(AwsKmsKeyDetails.builder().applyMutation(awsKmsKey).build());
        }

        /**
         * <p>
         * Details about a Lambda function.
         * </p>
         * 
         * @param awsLambdaFunction
         *        Details about a Lambda function.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsLambdaFunction(AwsLambdaFunctionDetails awsLambdaFunction);

        /**
         * <p>
         * Details about a Lambda function.
         * </p>
         * This is a convenience method that creates an instance of the {@link AwsLambdaFunctionDetails.Builder}
         * avoiding the need to create one manually via {@link AwsLambdaFunctionDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsLambdaFunctionDetails.Builder#build()} is called immediately
         * and its result is passed to {@link #awsLambdaFunction(AwsLambdaFunctionDetails)}.
         * 
         * @param awsLambdaFunction
         *        a consumer that will call methods on {@link AwsLambdaFunctionDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #awsLambdaFunction(AwsLambdaFunctionDetails)
         */
        default Builder awsLambdaFunction(Consumer<AwsLambdaFunctionDetails.Builder> awsLambdaFunction) {
            return awsLambdaFunction(AwsLambdaFunctionDetails.builder().applyMutation(awsLambdaFunction).build());
        }

        /**
         * <p>
         * Details for a Lambda layer version.
         * </p>
         * 
         * @param awsLambdaLayerVersion
         *        Details for a Lambda layer version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsLambdaLayerVersion(AwsLambdaLayerVersionDetails awsLambdaLayerVersion);

        /**
         * <p>
         * Details for a Lambda layer version.
         * </p>
         * This is a convenience method that creates an instance of the {@link AwsLambdaLayerVersionDetails.Builder}
         * avoiding the need to create one manually via {@link AwsLambdaLayerVersionDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsLambdaLayerVersionDetails.Builder#build()} is called
         * immediately and its result is passed to {@link #awsLambdaLayerVersion(AwsLambdaLayerVersionDetails)}.
         * 
         * @param awsLambdaLayerVersion
         *        a consumer that will call methods on {@link AwsLambdaLayerVersionDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #awsLambdaLayerVersion(AwsLambdaLayerVersionDetails)
         */
        default Builder awsLambdaLayerVersion(Consumer<AwsLambdaLayerVersionDetails.Builder> awsLambdaLayerVersion) {
            return awsLambdaLayerVersion(AwsLambdaLayerVersionDetails.builder().applyMutation(awsLambdaLayerVersion).build());
        }

        /**
         * <p>
         * Details about an Amazon RDS database instance.
         * </p>
         * 
         * @param awsRdsDbInstance
         *        Details about an Amazon RDS database instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsRdsDbInstance(AwsRdsDbInstanceDetails awsRdsDbInstance);

        /**
         * <p>
         * Details about an Amazon RDS database instance.
         * </p>
         * This is a convenience method that creates an instance of the {@link AwsRdsDbInstanceDetails.Builder} avoiding
         * the need to create one manually via {@link AwsRdsDbInstanceDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsRdsDbInstanceDetails.Builder#build()} is called immediately
         * and its result is passed to {@link #awsRdsDbInstance(AwsRdsDbInstanceDetails)}.
         * 
         * @param awsRdsDbInstance
         *        a consumer that will call methods on {@link AwsRdsDbInstanceDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #awsRdsDbInstance(AwsRdsDbInstanceDetails)
         */
        default Builder awsRdsDbInstance(Consumer<AwsRdsDbInstanceDetails.Builder> awsRdsDbInstance) {
            return awsRdsDbInstance(AwsRdsDbInstanceDetails.builder().applyMutation(awsRdsDbInstance).build());
        }

        /**
         * <p>
         * Details about an SNS topic.
         * </p>
         * 
         * @param awsSnsTopic
         *        Details about an SNS topic.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsSnsTopic(AwsSnsTopicDetails awsSnsTopic);

        /**
         * <p>
         * Details about an SNS topic.
         * </p>
         * This is a convenience method that creates an instance of the {@link AwsSnsTopicDetails.Builder} avoiding the
         * need to create one manually via {@link AwsSnsTopicDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsSnsTopicDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #awsSnsTopic(AwsSnsTopicDetails)}.
         * 
         * @param awsSnsTopic
         *        a consumer that will call methods on {@link AwsSnsTopicDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #awsSnsTopic(AwsSnsTopicDetails)
         */
        default Builder awsSnsTopic(Consumer<AwsSnsTopicDetails.Builder> awsSnsTopic) {
            return awsSnsTopic(AwsSnsTopicDetails.builder().applyMutation(awsSnsTopic).build());
        }

        /**
         * <p>
         * Details about an SQS queue.
         * </p>
         * 
         * @param awsSqsQueue
         *        Details about an SQS queue.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsSqsQueue(AwsSqsQueueDetails awsSqsQueue);

        /**
         * <p>
         * Details about an SQS queue.
         * </p>
         * This is a convenience method that creates an instance of the {@link AwsSqsQueueDetails.Builder} avoiding the
         * need to create one manually via {@link AwsSqsQueueDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsSqsQueueDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #awsSqsQueue(AwsSqsQueueDetails)}.
         * 
         * @param awsSqsQueue
         *        a consumer that will call methods on {@link AwsSqsQueueDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #awsSqsQueue(AwsSqsQueueDetails)
         */
        default Builder awsSqsQueue(Consumer<AwsSqsQueueDetails.Builder> awsSqsQueue) {
            return awsSqsQueue(AwsSqsQueueDetails.builder().applyMutation(awsSqsQueue).build());
        }

        /**
         * <p>
         * Details for an WAF web ACL.
         * </p>
         * 
         * @param awsWafWebAcl
         *        Details for an WAF web ACL.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsWafWebAcl(AwsWafWebAclDetails awsWafWebAcl);

        /**
         * <p>
         * Details for an WAF web ACL.
         * </p>
         * This is a convenience method that creates an instance of the {@link AwsWafWebAclDetails.Builder} avoiding the
         * need to create one manually via {@link AwsWafWebAclDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsWafWebAclDetails.Builder#build()} is called immediately and
         * its result is passed to {@link #awsWafWebAcl(AwsWafWebAclDetails)}.
         * 
         * @param awsWafWebAcl
         *        a consumer that will call methods on {@link AwsWafWebAclDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #awsWafWebAcl(AwsWafWebAclDetails)
         */
        default Builder awsWafWebAcl(Consumer<AwsWafWebAclDetails.Builder> awsWafWebAcl) {
            return awsWafWebAcl(AwsWafWebAclDetails.builder().applyMutation(awsWafWebAcl).build());
        }

        /**
         * <p>
         * Details about an Amazon RDS database snapshot.
         * </p>
         * 
         * @param awsRdsDbSnapshot
         *        Details about an Amazon RDS database snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsRdsDbSnapshot(AwsRdsDbSnapshotDetails awsRdsDbSnapshot);

        /**
         * <p>
         * Details about an Amazon RDS database snapshot.
         * </p>
         * This is a convenience method that creates an instance of the {@link AwsRdsDbSnapshotDetails.Builder} avoiding
         * the need to create one manually via {@link AwsRdsDbSnapshotDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsRdsDbSnapshotDetails.Builder#build()} is called immediately
         * and its result is passed to {@link #awsRdsDbSnapshot(AwsRdsDbSnapshotDetails)}.
         * 
         * @param awsRdsDbSnapshot
         *        a consumer that will call methods on {@link AwsRdsDbSnapshotDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #awsRdsDbSnapshot(AwsRdsDbSnapshotDetails)
         */
        default Builder awsRdsDbSnapshot(Consumer<AwsRdsDbSnapshotDetails.Builder> awsRdsDbSnapshot) {
            return awsRdsDbSnapshot(AwsRdsDbSnapshotDetails.builder().applyMutation(awsRdsDbSnapshot).build());
        }

        /**
         * <p>
         * Details about an Amazon RDS database cluster snapshot.
         * </p>
         * 
         * @param awsRdsDbClusterSnapshot
         *        Details about an Amazon RDS database cluster snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsRdsDbClusterSnapshot(AwsRdsDbClusterSnapshotDetails awsRdsDbClusterSnapshot);

        /**
         * <p>
         * Details about an Amazon RDS database cluster snapshot.
         * </p>
         * This is a convenience method that creates an instance of the {@link AwsRdsDbClusterSnapshotDetails.Builder}
         * avoiding the need to create one manually via {@link AwsRdsDbClusterSnapshotDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsRdsDbClusterSnapshotDetails.Builder#build()} is called
         * immediately and its result is passed to {@link #awsRdsDbClusterSnapshot(AwsRdsDbClusterSnapshotDetails)}.
         * 
         * @param awsRdsDbClusterSnapshot
         *        a consumer that will call methods on {@link AwsRdsDbClusterSnapshotDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #awsRdsDbClusterSnapshot(AwsRdsDbClusterSnapshotDetails)
         */
        default Builder awsRdsDbClusterSnapshot(Consumer<AwsRdsDbClusterSnapshotDetails.Builder> awsRdsDbClusterSnapshot) {
            return awsRdsDbClusterSnapshot(AwsRdsDbClusterSnapshotDetails.builder().applyMutation(awsRdsDbClusterSnapshot)
                    .build());
        }

        /**
         * <p>
         * Details about an Amazon RDS database cluster.
         * </p>
         * 
         * @param awsRdsDbCluster
         *        Details about an Amazon RDS database cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsRdsDbCluster(AwsRdsDbClusterDetails awsRdsDbCluster);

        /**
         * <p>
         * Details about an Amazon RDS database cluster.
         * </p>
         * This is a convenience method that creates an instance of the {@link AwsRdsDbClusterDetails.Builder} avoiding
         * the need to create one manually via {@link AwsRdsDbClusterDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsRdsDbClusterDetails.Builder#build()} is called immediately and
         * its result is passed to {@link #awsRdsDbCluster(AwsRdsDbClusterDetails)}.
         * 
         * @param awsRdsDbCluster
         *        a consumer that will call methods on {@link AwsRdsDbClusterDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #awsRdsDbCluster(AwsRdsDbClusterDetails)
         */
        default Builder awsRdsDbCluster(Consumer<AwsRdsDbClusterDetails.Builder> awsRdsDbCluster) {
            return awsRdsDbCluster(AwsRdsDbClusterDetails.builder().applyMutation(awsRdsDbCluster).build());
        }

        /**
         * <p>
         * Details about an Amazon ECS cluster.
         * </p>
         * 
         * @param awsEcsCluster
         *        Details about an Amazon ECS cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsEcsCluster(AwsEcsClusterDetails awsEcsCluster);

        /**
         * <p>
         * Details about an Amazon ECS cluster.
         * </p>
         * This is a convenience method that creates an instance of the {@link AwsEcsClusterDetails.Builder} avoiding
         * the need to create one manually via {@link AwsEcsClusterDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsEcsClusterDetails.Builder#build()} is called immediately and
         * its result is passed to {@link #awsEcsCluster(AwsEcsClusterDetails)}.
         * 
         * @param awsEcsCluster
         *        a consumer that will call methods on {@link AwsEcsClusterDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #awsEcsCluster(AwsEcsClusterDetails)
         */
        default Builder awsEcsCluster(Consumer<AwsEcsClusterDetails.Builder> awsEcsCluster) {
            return awsEcsCluster(AwsEcsClusterDetails.builder().applyMutation(awsEcsCluster).build());
        }

        /**
         * <p>
         * Provides information about a Docker container that's part of a task.
         * </p>
         * 
         * @param awsEcsContainer
         *        Provides information about a Docker container that's part of a task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsEcsContainer(AwsEcsContainerDetails awsEcsContainer);

        /**
         * <p>
         * Provides information about a Docker container that's part of a task.
         * </p>
         * This is a convenience method that creates an instance of the {@link AwsEcsContainerDetails.Builder} avoiding
         * the need to create one manually via {@link AwsEcsContainerDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsEcsContainerDetails.Builder#build()} is called immediately and
         * its result is passed to {@link #awsEcsContainer(AwsEcsContainerDetails)}.
         * 
         * @param awsEcsContainer
         *        a consumer that will call methods on {@link AwsEcsContainerDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #awsEcsContainer(AwsEcsContainerDetails)
         */
        default Builder awsEcsContainer(Consumer<AwsEcsContainerDetails.Builder> awsEcsContainer) {
            return awsEcsContainer(AwsEcsContainerDetails.builder().applyMutation(awsEcsContainer).build());
        }

        /**
         * <p>
         * Details about a task definition. A task definition describes the container and volume definitions of an
         * Amazon Elastic Container Service task.
         * </p>
         * 
         * @param awsEcsTaskDefinition
         *        Details about a task definition. A task definition describes the container and volume definitions of
         *        an Amazon Elastic Container Service task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsEcsTaskDefinition(AwsEcsTaskDefinitionDetails awsEcsTaskDefinition);

        /**
         * <p>
         * Details about a task definition. A task definition describes the container and volume definitions of an
         * Amazon Elastic Container Service task.
         * </p>
         * This is a convenience method that creates an instance of the {@link AwsEcsTaskDefinitionDetails.Builder}
         * avoiding the need to create one manually via {@link AwsEcsTaskDefinitionDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsEcsTaskDefinitionDetails.Builder#build()} is called
         * immediately and its result is passed to {@link #awsEcsTaskDefinition(AwsEcsTaskDefinitionDetails)}.
         * 
         * @param awsEcsTaskDefinition
         *        a consumer that will call methods on {@link AwsEcsTaskDefinitionDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #awsEcsTaskDefinition(AwsEcsTaskDefinitionDetails)
         */
        default Builder awsEcsTaskDefinition(Consumer<AwsEcsTaskDefinitionDetails.Builder> awsEcsTaskDefinition) {
            return awsEcsTaskDefinition(AwsEcsTaskDefinitionDetails.builder().applyMutation(awsEcsTaskDefinition).build());
        }

        /**
         * <p>
         * Details about a container resource related to a finding.
         * </p>
         * 
         * @param container
         *        Details about a container resource related to a finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder container(ContainerDetails container);

        /**
         * <p>
         * Details about a container resource related to a finding.
         * </p>
         * This is a convenience method that creates an instance of the {@link ContainerDetails.Builder} avoiding the
         * need to create one manually via {@link ContainerDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ContainerDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #container(ContainerDetails)}.
         * 
         * @param container
         *        a consumer that will call methods on {@link ContainerDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #container(ContainerDetails)
         */
        default Builder container(Consumer<ContainerDetails.Builder> container) {
            return container(ContainerDetails.builder().applyMutation(container).build());
        }

        /**
         * <p>
         * Details about a resource that are not available in a type-specific details object. Use the <code>Other</code>
         * object in the following cases.
         * </p>
         * <ul>
         * <li>
         * <p>
         * The type-specific object does not contain all of the fields that you want to populate. In this case, first
         * use the type-specific object to populate those fields. Use the <code>Other</code> object to populate the
         * fields that are missing from the type-specific object.
         * </p>
         * </li>
         * <li>
         * <p>
         * The resource type does not have a corresponding object. This includes resources for which the type is
         * <code>Other</code>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param other
         *        Details about a resource that are not available in a type-specific details object. Use the
         *        <code>Other</code> object in the following cases.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        The type-specific object does not contain all of the fields that you want to populate. In this case,
         *        first use the type-specific object to populate those fields. Use the <code>Other</code> object to
         *        populate the fields that are missing from the type-specific object.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The resource type does not have a corresponding object. This includes resources for which the type is
         *        <code>Other</code>.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder other(Map<String, String> other);

        /**
         * <p>
         * Details about an RDS event notification subscription.
         * </p>
         * 
         * @param awsRdsEventSubscription
         *        Details about an RDS event notification subscription.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsRdsEventSubscription(AwsRdsEventSubscriptionDetails awsRdsEventSubscription);

        /**
         * <p>
         * Details about an RDS event notification subscription.
         * </p>
         * This is a convenience method that creates an instance of the {@link AwsRdsEventSubscriptionDetails.Builder}
         * avoiding the need to create one manually via {@link AwsRdsEventSubscriptionDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsRdsEventSubscriptionDetails.Builder#build()} is called
         * immediately and its result is passed to {@link #awsRdsEventSubscription(AwsRdsEventSubscriptionDetails)}.
         * 
         * @param awsRdsEventSubscription
         *        a consumer that will call methods on {@link AwsRdsEventSubscriptionDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #awsRdsEventSubscription(AwsRdsEventSubscriptionDetails)
         */
        default Builder awsRdsEventSubscription(Consumer<AwsRdsEventSubscriptionDetails.Builder> awsRdsEventSubscription) {
            return awsRdsEventSubscription(AwsRdsEventSubscriptionDetails.builder().applyMutation(awsRdsEventSubscription)
                    .build());
        }

        /**
         * <p>
         * Details about a service within an ECS cluster.
         * </p>
         * 
         * @param awsEcsService
         *        Details about a service within an ECS cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsEcsService(AwsEcsServiceDetails awsEcsService);

        /**
         * <p>
         * Details about a service within an ECS cluster.
         * </p>
         * This is a convenience method that creates an instance of the {@link AwsEcsServiceDetails.Builder} avoiding
         * the need to create one manually via {@link AwsEcsServiceDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsEcsServiceDetails.Builder#build()} is called immediately and
         * its result is passed to {@link #awsEcsService(AwsEcsServiceDetails)}.
         * 
         * @param awsEcsService
         *        a consumer that will call methods on {@link AwsEcsServiceDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #awsEcsService(AwsEcsServiceDetails)
         */
        default Builder awsEcsService(Consumer<AwsEcsServiceDetails.Builder> awsEcsService) {
            return awsEcsService(AwsEcsServiceDetails.builder().applyMutation(awsEcsService).build());
        }

        /**
         * <p>
         * Provides details about a launch configuration.
         * </p>
         * 
         * @param awsAutoScalingLaunchConfiguration
         *        Provides details about a launch configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsAutoScalingLaunchConfiguration(AwsAutoScalingLaunchConfigurationDetails awsAutoScalingLaunchConfiguration);

        /**
         * <p>
         * Provides details about a launch configuration.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AwsAutoScalingLaunchConfigurationDetails.Builder} avoiding the need to create one manually via
         * {@link AwsAutoScalingLaunchConfigurationDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsAutoScalingLaunchConfigurationDetails.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #awsAutoScalingLaunchConfiguration(AwsAutoScalingLaunchConfigurationDetails)}.
         * 
         * @param awsAutoScalingLaunchConfiguration
         *        a consumer that will call methods on {@link AwsAutoScalingLaunchConfigurationDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #awsAutoScalingLaunchConfiguration(AwsAutoScalingLaunchConfigurationDetails)
         */
        default Builder awsAutoScalingLaunchConfiguration(
                Consumer<AwsAutoScalingLaunchConfigurationDetails.Builder> awsAutoScalingLaunchConfiguration) {
            return awsAutoScalingLaunchConfiguration(AwsAutoScalingLaunchConfigurationDetails.builder()
                    .applyMutation(awsAutoScalingLaunchConfiguration).build());
        }

        /**
         * <p>
         * Details about an Amazon EC2 VPN connection.
         * </p>
         * 
         * @param awsEc2VpnConnection
         *        Details about an Amazon EC2 VPN connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsEc2VpnConnection(AwsEc2VpnConnectionDetails awsEc2VpnConnection);

        /**
         * <p>
         * Details about an Amazon EC2 VPN connection.
         * </p>
         * This is a convenience method that creates an instance of the {@link AwsEc2VpnConnectionDetails.Builder}
         * avoiding the need to create one manually via {@link AwsEc2VpnConnectionDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsEc2VpnConnectionDetails.Builder#build()} is called immediately
         * and its result is passed to {@link #awsEc2VpnConnection(AwsEc2VpnConnectionDetails)}.
         * 
         * @param awsEc2VpnConnection
         *        a consumer that will call methods on {@link AwsEc2VpnConnectionDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #awsEc2VpnConnection(AwsEc2VpnConnectionDetails)
         */
        default Builder awsEc2VpnConnection(Consumer<AwsEc2VpnConnectionDetails.Builder> awsEc2VpnConnection) {
            return awsEc2VpnConnection(AwsEc2VpnConnectionDetails.builder().applyMutation(awsEc2VpnConnection).build());
        }

        /**
         * <p>
         * Information about an Amazon ECR image.
         * </p>
         * 
         * @param awsEcrContainerImage
         *        Information about an Amazon ECR image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsEcrContainerImage(AwsEcrContainerImageDetails awsEcrContainerImage);

        /**
         * <p>
         * Information about an Amazon ECR image.
         * </p>
         * This is a convenience method that creates an instance of the {@link AwsEcrContainerImageDetails.Builder}
         * avoiding the need to create one manually via {@link AwsEcrContainerImageDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsEcrContainerImageDetails.Builder#build()} is called
         * immediately and its result is passed to {@link #awsEcrContainerImage(AwsEcrContainerImageDetails)}.
         * 
         * @param awsEcrContainerImage
         *        a consumer that will call methods on {@link AwsEcrContainerImageDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #awsEcrContainerImage(AwsEcrContainerImageDetails)
         */
        default Builder awsEcrContainerImage(Consumer<AwsEcrContainerImageDetails.Builder> awsEcrContainerImage) {
            return awsEcrContainerImage(AwsEcrContainerImageDetails.builder().applyMutation(awsEcrContainerImage).build());
        }

        /**
         * <p>
         * Details about an Amazon OpenSearch Service domain.
         * </p>
         * 
         * @param awsOpenSearchServiceDomain
         *        Details about an Amazon OpenSearch Service domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsOpenSearchServiceDomain(AwsOpenSearchServiceDomainDetails awsOpenSearchServiceDomain);

        /**
         * <p>
         * Details about an Amazon OpenSearch Service domain.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AwsOpenSearchServiceDomainDetails.Builder} avoiding the need to create one manually via
         * {@link AwsOpenSearchServiceDomainDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsOpenSearchServiceDomainDetails.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #awsOpenSearchServiceDomain(AwsOpenSearchServiceDomainDetails)}.
         * 
         * @param awsOpenSearchServiceDomain
         *        a consumer that will call methods on {@link AwsOpenSearchServiceDomainDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #awsOpenSearchServiceDomain(AwsOpenSearchServiceDomainDetails)
         */
        default Builder awsOpenSearchServiceDomain(Consumer<AwsOpenSearchServiceDomainDetails.Builder> awsOpenSearchServiceDomain) {
            return awsOpenSearchServiceDomain(AwsOpenSearchServiceDomainDetails.builder()
                    .applyMutation(awsOpenSearchServiceDomain).build());
        }

        /**
         * <p>
         * Details about the service configuration for a VPC endpoint service.
         * </p>
         * 
         * @param awsEc2VpcEndpointService
         *        Details about the service configuration for a VPC endpoint service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsEc2VpcEndpointService(AwsEc2VpcEndpointServiceDetails awsEc2VpcEndpointService);

        /**
         * <p>
         * Details about the service configuration for a VPC endpoint service.
         * </p>
         * This is a convenience method that creates an instance of the {@link AwsEc2VpcEndpointServiceDetails.Builder}
         * avoiding the need to create one manually via {@link AwsEc2VpcEndpointServiceDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsEc2VpcEndpointServiceDetails.Builder#build()} is called
         * immediately and its result is passed to {@link #awsEc2VpcEndpointService(AwsEc2VpcEndpointServiceDetails)}.
         * 
         * @param awsEc2VpcEndpointService
         *        a consumer that will call methods on {@link AwsEc2VpcEndpointServiceDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #awsEc2VpcEndpointService(AwsEc2VpcEndpointServiceDetails)
         */
        default Builder awsEc2VpcEndpointService(Consumer<AwsEc2VpcEndpointServiceDetails.Builder> awsEc2VpcEndpointService) {
            return awsEc2VpcEndpointService(AwsEc2VpcEndpointServiceDetails.builder().applyMutation(awsEc2VpcEndpointService)
                    .build());
        }

        /**
         * <p>
         * Information about the encryption configuration for X-Ray.
         * </p>
         * 
         * @param awsXrayEncryptionConfig
         *        Information about the encryption configuration for X-Ray.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsXrayEncryptionConfig(AwsXrayEncryptionConfigDetails awsXrayEncryptionConfig);

        /**
         * <p>
         * Information about the encryption configuration for X-Ray.
         * </p>
         * This is a convenience method that creates an instance of the {@link AwsXrayEncryptionConfigDetails.Builder}
         * avoiding the need to create one manually via {@link AwsXrayEncryptionConfigDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsXrayEncryptionConfigDetails.Builder#build()} is called
         * immediately and its result is passed to {@link #awsXrayEncryptionConfig(AwsXrayEncryptionConfigDetails)}.
         * 
         * @param awsXrayEncryptionConfig
         *        a consumer that will call methods on {@link AwsXrayEncryptionConfigDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #awsXrayEncryptionConfig(AwsXrayEncryptionConfigDetails)
         */
        default Builder awsXrayEncryptionConfig(Consumer<AwsXrayEncryptionConfigDetails.Builder> awsXrayEncryptionConfig) {
            return awsXrayEncryptionConfig(AwsXrayEncryptionConfigDetails.builder().applyMutation(awsXrayEncryptionConfig)
                    .build());
        }

        /**
         * <p>
         * Details about a rate-based rule for global resources.
         * </p>
         * 
         * @param awsWafRateBasedRule
         *        Details about a rate-based rule for global resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsWafRateBasedRule(AwsWafRateBasedRuleDetails awsWafRateBasedRule);

        /**
         * <p>
         * Details about a rate-based rule for global resources.
         * </p>
         * This is a convenience method that creates an instance of the {@link AwsWafRateBasedRuleDetails.Builder}
         * avoiding the need to create one manually via {@link AwsWafRateBasedRuleDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsWafRateBasedRuleDetails.Builder#build()} is called immediately
         * and its result is passed to {@link #awsWafRateBasedRule(AwsWafRateBasedRuleDetails)}.
         * 
         * @param awsWafRateBasedRule
         *        a consumer that will call methods on {@link AwsWafRateBasedRuleDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #awsWafRateBasedRule(AwsWafRateBasedRuleDetails)
         */
        default Builder awsWafRateBasedRule(Consumer<AwsWafRateBasedRuleDetails.Builder> awsWafRateBasedRule) {
            return awsWafRateBasedRule(AwsWafRateBasedRuleDetails.builder().applyMutation(awsWafRateBasedRule).build());
        }

        /**
         * <p>
         * Details about a rate-based rule for Regional resources.
         * </p>
         * 
         * @param awsWafRegionalRateBasedRule
         *        Details about a rate-based rule for Regional resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsWafRegionalRateBasedRule(AwsWafRegionalRateBasedRuleDetails awsWafRegionalRateBasedRule);

        /**
         * <p>
         * Details about a rate-based rule for Regional resources.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AwsWafRegionalRateBasedRuleDetails.Builder} avoiding the need to create one manually via
         * {@link AwsWafRegionalRateBasedRuleDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsWafRegionalRateBasedRuleDetails.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #awsWafRegionalRateBasedRule(AwsWafRegionalRateBasedRuleDetails)}.
         * 
         * @param awsWafRegionalRateBasedRule
         *        a consumer that will call methods on {@link AwsWafRegionalRateBasedRuleDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #awsWafRegionalRateBasedRule(AwsWafRegionalRateBasedRuleDetails)
         */
        default Builder awsWafRegionalRateBasedRule(
                Consumer<AwsWafRegionalRateBasedRuleDetails.Builder> awsWafRegionalRateBasedRule) {
            return awsWafRegionalRateBasedRule(AwsWafRegionalRateBasedRuleDetails.builder()
                    .applyMutation(awsWafRegionalRateBasedRule).build());
        }

        /**
         * <p>
         * Information about an Amazon Elastic Container Registry repository.
         * </p>
         * 
         * @param awsEcrRepository
         *        Information about an Amazon Elastic Container Registry repository.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsEcrRepository(AwsEcrRepositoryDetails awsEcrRepository);

        /**
         * <p>
         * Information about an Amazon Elastic Container Registry repository.
         * </p>
         * This is a convenience method that creates an instance of the {@link AwsEcrRepositoryDetails.Builder} avoiding
         * the need to create one manually via {@link AwsEcrRepositoryDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsEcrRepositoryDetails.Builder#build()} is called immediately
         * and its result is passed to {@link #awsEcrRepository(AwsEcrRepositoryDetails)}.
         * 
         * @param awsEcrRepository
         *        a consumer that will call methods on {@link AwsEcrRepositoryDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #awsEcrRepository(AwsEcrRepositoryDetails)
         */
        default Builder awsEcrRepository(Consumer<AwsEcrRepositoryDetails.Builder> awsEcrRepository) {
            return awsEcrRepository(AwsEcrRepositoryDetails.builder().applyMutation(awsEcrRepository).build());
        }

        /**
         * <p>
         * Details about an Amazon EKS cluster.
         * </p>
         * 
         * @param awsEksCluster
         *        Details about an Amazon EKS cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsEksCluster(AwsEksClusterDetails awsEksCluster);

        /**
         * <p>
         * Details about an Amazon EKS cluster.
         * </p>
         * This is a convenience method that creates an instance of the {@link AwsEksClusterDetails.Builder} avoiding
         * the need to create one manually via {@link AwsEksClusterDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsEksClusterDetails.Builder#build()} is called immediately and
         * its result is passed to {@link #awsEksCluster(AwsEksClusterDetails)}.
         * 
         * @param awsEksCluster
         *        a consumer that will call methods on {@link AwsEksClusterDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #awsEksCluster(AwsEksClusterDetails)
         */
        default Builder awsEksCluster(Consumer<AwsEksClusterDetails.Builder> awsEksCluster) {
            return awsEksCluster(AwsEksClusterDetails.builder().applyMutation(awsEksCluster).build());
        }

        /**
         * <p>
         * Details about an Network Firewall firewall policy.
         * </p>
         * 
         * @param awsNetworkFirewallFirewallPolicy
         *        Details about an Network Firewall firewall policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsNetworkFirewallFirewallPolicy(AwsNetworkFirewallFirewallPolicyDetails awsNetworkFirewallFirewallPolicy);

        /**
         * <p>
         * Details about an Network Firewall firewall policy.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AwsNetworkFirewallFirewallPolicyDetails.Builder} avoiding the need to create one manually via
         * {@link AwsNetworkFirewallFirewallPolicyDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsNetworkFirewallFirewallPolicyDetails.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #awsNetworkFirewallFirewallPolicy(AwsNetworkFirewallFirewallPolicyDetails)}.
         * 
         * @param awsNetworkFirewallFirewallPolicy
         *        a consumer that will call methods on {@link AwsNetworkFirewallFirewallPolicyDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #awsNetworkFirewallFirewallPolicy(AwsNetworkFirewallFirewallPolicyDetails)
         */
        default Builder awsNetworkFirewallFirewallPolicy(
                Consumer<AwsNetworkFirewallFirewallPolicyDetails.Builder> awsNetworkFirewallFirewallPolicy) {
            return awsNetworkFirewallFirewallPolicy(AwsNetworkFirewallFirewallPolicyDetails.builder()
                    .applyMutation(awsNetworkFirewallFirewallPolicy).build());
        }

        /**
         * <p>
         * Details about an Network Firewall firewall.
         * </p>
         * 
         * @param awsNetworkFirewallFirewall
         *        Details about an Network Firewall firewall.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsNetworkFirewallFirewall(AwsNetworkFirewallFirewallDetails awsNetworkFirewallFirewall);

        /**
         * <p>
         * Details about an Network Firewall firewall.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AwsNetworkFirewallFirewallDetails.Builder} avoiding the need to create one manually via
         * {@link AwsNetworkFirewallFirewallDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsNetworkFirewallFirewallDetails.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #awsNetworkFirewallFirewall(AwsNetworkFirewallFirewallDetails)}.
         * 
         * @param awsNetworkFirewallFirewall
         *        a consumer that will call methods on {@link AwsNetworkFirewallFirewallDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #awsNetworkFirewallFirewall(AwsNetworkFirewallFirewallDetails)
         */
        default Builder awsNetworkFirewallFirewall(Consumer<AwsNetworkFirewallFirewallDetails.Builder> awsNetworkFirewallFirewall) {
            return awsNetworkFirewallFirewall(AwsNetworkFirewallFirewallDetails.builder()
                    .applyMutation(awsNetworkFirewallFirewall).build());
        }

        /**
         * <p>
         * Details about an Network Firewall rule group.
         * </p>
         * 
         * @param awsNetworkFirewallRuleGroup
         *        Details about an Network Firewall rule group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsNetworkFirewallRuleGroup(AwsNetworkFirewallRuleGroupDetails awsNetworkFirewallRuleGroup);

        /**
         * <p>
         * Details about an Network Firewall rule group.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AwsNetworkFirewallRuleGroupDetails.Builder} avoiding the need to create one manually via
         * {@link AwsNetworkFirewallRuleGroupDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsNetworkFirewallRuleGroupDetails.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #awsNetworkFirewallRuleGroup(AwsNetworkFirewallRuleGroupDetails)}.
         * 
         * @param awsNetworkFirewallRuleGroup
         *        a consumer that will call methods on {@link AwsNetworkFirewallRuleGroupDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #awsNetworkFirewallRuleGroup(AwsNetworkFirewallRuleGroupDetails)
         */
        default Builder awsNetworkFirewallRuleGroup(
                Consumer<AwsNetworkFirewallRuleGroupDetails.Builder> awsNetworkFirewallRuleGroup) {
            return awsNetworkFirewallRuleGroup(AwsNetworkFirewallRuleGroupDetails.builder()
                    .applyMutation(awsNetworkFirewallRuleGroup).build());
        }

        /**
         * <p>
         * Details about an Amazon RDS DB security group.
         * </p>
         * 
         * @param awsRdsDbSecurityGroup
         *        Details about an Amazon RDS DB security group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsRdsDbSecurityGroup(AwsRdsDbSecurityGroupDetails awsRdsDbSecurityGroup);

        /**
         * <p>
         * Details about an Amazon RDS DB security group.
         * </p>
         * This is a convenience method that creates an instance of the {@link AwsRdsDbSecurityGroupDetails.Builder}
         * avoiding the need to create one manually via {@link AwsRdsDbSecurityGroupDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsRdsDbSecurityGroupDetails.Builder#build()} is called
         * immediately and its result is passed to {@link #awsRdsDbSecurityGroup(AwsRdsDbSecurityGroupDetails)}.
         * 
         * @param awsRdsDbSecurityGroup
         *        a consumer that will call methods on {@link AwsRdsDbSecurityGroupDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #awsRdsDbSecurityGroup(AwsRdsDbSecurityGroupDetails)
         */
        default Builder awsRdsDbSecurityGroup(Consumer<AwsRdsDbSecurityGroupDetails.Builder> awsRdsDbSecurityGroup) {
            return awsRdsDbSecurityGroup(AwsRdsDbSecurityGroupDetails.builder().applyMutation(awsRdsDbSecurityGroup).build());
        }

        /**
         * <p>
         * Details about an Amazon Kinesis data stream.
         * </p>
         * 
         * @param awsKinesisStream
         *        Details about an Amazon Kinesis data stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsKinesisStream(AwsKinesisStreamDetails awsKinesisStream);

        /**
         * <p>
         * Details about an Amazon Kinesis data stream.
         * </p>
         * This is a convenience method that creates an instance of the {@link AwsKinesisStreamDetails.Builder} avoiding
         * the need to create one manually via {@link AwsKinesisStreamDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsKinesisStreamDetails.Builder#build()} is called immediately
         * and its result is passed to {@link #awsKinesisStream(AwsKinesisStreamDetails)}.
         * 
         * @param awsKinesisStream
         *        a consumer that will call methods on {@link AwsKinesisStreamDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #awsKinesisStream(AwsKinesisStreamDetails)
         */
        default Builder awsKinesisStream(Consumer<AwsKinesisStreamDetails.Builder> awsKinesisStream) {
            return awsKinesisStream(AwsKinesisStreamDetails.builder().applyMutation(awsKinesisStream).build());
        }

        /**
         * <p>
         * Details about an Amazon EC2 transit gateway that interconnects your virtual private clouds (VPC) and
         * on-premises networks.
         * </p>
         * 
         * @param awsEc2TransitGateway
         *        Details about an Amazon EC2 transit gateway that interconnects your virtual private clouds (VPC) and
         *        on-premises networks.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsEc2TransitGateway(AwsEc2TransitGatewayDetails awsEc2TransitGateway);

        /**
         * <p>
         * Details about an Amazon EC2 transit gateway that interconnects your virtual private clouds (VPC) and
         * on-premises networks.
         * </p>
         * This is a convenience method that creates an instance of the {@link AwsEc2TransitGatewayDetails.Builder}
         * avoiding the need to create one manually via {@link AwsEc2TransitGatewayDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsEc2TransitGatewayDetails.Builder#build()} is called
         * immediately and its result is passed to {@link #awsEc2TransitGateway(AwsEc2TransitGatewayDetails)}.
         * 
         * @param awsEc2TransitGateway
         *        a consumer that will call methods on {@link AwsEc2TransitGatewayDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #awsEc2TransitGateway(AwsEc2TransitGatewayDetails)
         */
        default Builder awsEc2TransitGateway(Consumer<AwsEc2TransitGatewayDetails.Builder> awsEc2TransitGateway) {
            return awsEc2TransitGateway(AwsEc2TransitGatewayDetails.builder().applyMutation(awsEc2TransitGateway).build());
        }

        /**
         * <p>
         * Details about an Amazon EFS access point. An access point is an application-specific view into an EFS file
         * system that applies an operating system user and group, and a file system path, to any file system request
         * made through the access point.
         * </p>
         * 
         * @param awsEfsAccessPoint
         *        Details about an Amazon EFS access point. An access point is an application-specific view into an EFS
         *        file system that applies an operating system user and group, and a file system path, to any file
         *        system request made through the access point.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsEfsAccessPoint(AwsEfsAccessPointDetails awsEfsAccessPoint);

        /**
         * <p>
         * Details about an Amazon EFS access point. An access point is an application-specific view into an EFS file
         * system that applies an operating system user and group, and a file system path, to any file system request
         * made through the access point.
         * </p>
         * This is a convenience method that creates an instance of the {@link AwsEfsAccessPointDetails.Builder}
         * avoiding the need to create one manually via {@link AwsEfsAccessPointDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsEfsAccessPointDetails.Builder#build()} is called immediately
         * and its result is passed to {@link #awsEfsAccessPoint(AwsEfsAccessPointDetails)}.
         * 
         * @param awsEfsAccessPoint
         *        a consumer that will call methods on {@link AwsEfsAccessPointDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #awsEfsAccessPoint(AwsEfsAccessPointDetails)
         */
        default Builder awsEfsAccessPoint(Consumer<AwsEfsAccessPointDetails.Builder> awsEfsAccessPoint) {
            return awsEfsAccessPoint(AwsEfsAccessPointDetails.builder().applyMutation(awsEfsAccessPoint).build());
        }

        /**
         * <p>
         * Details about an CloudFormation stack. A stack is a collection of Amazon Web Services resources that you can
         * manage as a single unit.
         * </p>
         * 
         * @param awsCloudFormationStack
         *        Details about an CloudFormation stack. A stack is a collection of Amazon Web Services resources that
         *        you can manage as a single unit.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsCloudFormationStack(AwsCloudFormationStackDetails awsCloudFormationStack);

        /**
         * <p>
         * Details about an CloudFormation stack. A stack is a collection of Amazon Web Services resources that you can
         * manage as a single unit.
         * </p>
         * This is a convenience method that creates an instance of the {@link AwsCloudFormationStackDetails.Builder}
         * avoiding the need to create one manually via {@link AwsCloudFormationStackDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsCloudFormationStackDetails.Builder#build()} is called
         * immediately and its result is passed to {@link #awsCloudFormationStack(AwsCloudFormationStackDetails)}.
         * 
         * @param awsCloudFormationStack
         *        a consumer that will call methods on {@link AwsCloudFormationStackDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #awsCloudFormationStack(AwsCloudFormationStackDetails)
         */
        default Builder awsCloudFormationStack(Consumer<AwsCloudFormationStackDetails.Builder> awsCloudFormationStack) {
            return awsCloudFormationStack(AwsCloudFormationStackDetails.builder().applyMutation(awsCloudFormationStack).build());
        }

        /**
         * <p>
         * Details about an Amazon CloudWatch alarm. An alarm allows you to monitor and receive alerts about your Amazon
         * Web Services resources and applications across multiple Regions.
         * </p>
         * 
         * @param awsCloudWatchAlarm
         *        Details about an Amazon CloudWatch alarm. An alarm allows you to monitor and receive alerts about your
         *        Amazon Web Services resources and applications across multiple Regions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsCloudWatchAlarm(AwsCloudWatchAlarmDetails awsCloudWatchAlarm);

        /**
         * <p>
         * Details about an Amazon CloudWatch alarm. An alarm allows you to monitor and receive alerts about your Amazon
         * Web Services resources and applications across multiple Regions.
         * </p>
         * This is a convenience method that creates an instance of the {@link AwsCloudWatchAlarmDetails.Builder}
         * avoiding the need to create one manually via {@link AwsCloudWatchAlarmDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsCloudWatchAlarmDetails.Builder#build()} is called immediately
         * and its result is passed to {@link #awsCloudWatchAlarm(AwsCloudWatchAlarmDetails)}.
         * 
         * @param awsCloudWatchAlarm
         *        a consumer that will call methods on {@link AwsCloudWatchAlarmDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #awsCloudWatchAlarm(AwsCloudWatchAlarmDetails)
         */
        default Builder awsCloudWatchAlarm(Consumer<AwsCloudWatchAlarmDetails.Builder> awsCloudWatchAlarm) {
            return awsCloudWatchAlarm(AwsCloudWatchAlarmDetails.builder().applyMutation(awsCloudWatchAlarm).build());
        }

        /**
         * <p>
         * Details about an Amazon EC2 VPC peering connection. A VPC peering connection is a networking connection
         * between two VPCs that enables you to route traffic between them privately.
         * </p>
         * 
         * @param awsEc2VpcPeeringConnection
         *        Details about an Amazon EC2 VPC peering connection. A VPC peering connection is a networking
         *        connection between two VPCs that enables you to route traffic between them privately.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsEc2VpcPeeringConnection(AwsEc2VpcPeeringConnectionDetails awsEc2VpcPeeringConnection);

        /**
         * <p>
         * Details about an Amazon EC2 VPC peering connection. A VPC peering connection is a networking connection
         * between two VPCs that enables you to route traffic between them privately.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AwsEc2VpcPeeringConnectionDetails.Builder} avoiding the need to create one manually via
         * {@link AwsEc2VpcPeeringConnectionDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsEc2VpcPeeringConnectionDetails.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #awsEc2VpcPeeringConnection(AwsEc2VpcPeeringConnectionDetails)}.
         * 
         * @param awsEc2VpcPeeringConnection
         *        a consumer that will call methods on {@link AwsEc2VpcPeeringConnectionDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #awsEc2VpcPeeringConnection(AwsEc2VpcPeeringConnectionDetails)
         */
        default Builder awsEc2VpcPeeringConnection(Consumer<AwsEc2VpcPeeringConnectionDetails.Builder> awsEc2VpcPeeringConnection) {
            return awsEc2VpcPeeringConnection(AwsEc2VpcPeeringConnectionDetails.builder()
                    .applyMutation(awsEc2VpcPeeringConnection).build());
        }

        /**
         * <p>
         * Details about an WAF rule group for Regional resources.
         * </p>
         * 
         * @param awsWafRegionalRuleGroup
         *        Details about an WAF rule group for Regional resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsWafRegionalRuleGroup(AwsWafRegionalRuleGroupDetails awsWafRegionalRuleGroup);

        /**
         * <p>
         * Details about an WAF rule group for Regional resources.
         * </p>
         * This is a convenience method that creates an instance of the {@link AwsWafRegionalRuleGroupDetails.Builder}
         * avoiding the need to create one manually via {@link AwsWafRegionalRuleGroupDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsWafRegionalRuleGroupDetails.Builder#build()} is called
         * immediately and its result is passed to {@link #awsWafRegionalRuleGroup(AwsWafRegionalRuleGroupDetails)}.
         * 
         * @param awsWafRegionalRuleGroup
         *        a consumer that will call methods on {@link AwsWafRegionalRuleGroupDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #awsWafRegionalRuleGroup(AwsWafRegionalRuleGroupDetails)
         */
        default Builder awsWafRegionalRuleGroup(Consumer<AwsWafRegionalRuleGroupDetails.Builder> awsWafRegionalRuleGroup) {
            return awsWafRegionalRuleGroup(AwsWafRegionalRuleGroupDetails.builder().applyMutation(awsWafRegionalRuleGroup)
                    .build());
        }

        /**
         * <p>
         * Details about an WAF rule for Regional resources.
         * </p>
         * 
         * @param awsWafRegionalRule
         *        Details about an WAF rule for Regional resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsWafRegionalRule(AwsWafRegionalRuleDetails awsWafRegionalRule);

        /**
         * <p>
         * Details about an WAF rule for Regional resources.
         * </p>
         * This is a convenience method that creates an instance of the {@link AwsWafRegionalRuleDetails.Builder}
         * avoiding the need to create one manually via {@link AwsWafRegionalRuleDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsWafRegionalRuleDetails.Builder#build()} is called immediately
         * and its result is passed to {@link #awsWafRegionalRule(AwsWafRegionalRuleDetails)}.
         * 
         * @param awsWafRegionalRule
         *        a consumer that will call methods on {@link AwsWafRegionalRuleDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #awsWafRegionalRule(AwsWafRegionalRuleDetails)
         */
        default Builder awsWafRegionalRule(Consumer<AwsWafRegionalRuleDetails.Builder> awsWafRegionalRule) {
            return awsWafRegionalRule(AwsWafRegionalRuleDetails.builder().applyMutation(awsWafRegionalRule).build());
        }

        /**
         * <p>
         * Details about an WAF web access control list (web ACL) for Regional resources.
         * </p>
         * 
         * @param awsWafRegionalWebAcl
         *        Details about an WAF web access control list (web ACL) for Regional resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsWafRegionalWebAcl(AwsWafRegionalWebAclDetails awsWafRegionalWebAcl);

        /**
         * <p>
         * Details about an WAF web access control list (web ACL) for Regional resources.
         * </p>
         * This is a convenience method that creates an instance of the {@link AwsWafRegionalWebAclDetails.Builder}
         * avoiding the need to create one manually via {@link AwsWafRegionalWebAclDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsWafRegionalWebAclDetails.Builder#build()} is called
         * immediately and its result is passed to {@link #awsWafRegionalWebAcl(AwsWafRegionalWebAclDetails)}.
         * 
         * @param awsWafRegionalWebAcl
         *        a consumer that will call methods on {@link AwsWafRegionalWebAclDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #awsWafRegionalWebAcl(AwsWafRegionalWebAclDetails)
         */
        default Builder awsWafRegionalWebAcl(Consumer<AwsWafRegionalWebAclDetails.Builder> awsWafRegionalWebAcl) {
            return awsWafRegionalWebAcl(AwsWafRegionalWebAclDetails.builder().applyMutation(awsWafRegionalWebAcl).build());
        }

        /**
         * <p>
         * Details about an WAF rule for global resources.
         * </p>
         * 
         * @param awsWafRule
         *        Details about an WAF rule for global resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsWafRule(AwsWafRuleDetails awsWafRule);

        /**
         * <p>
         * Details about an WAF rule for global resources.
         * </p>
         * This is a convenience method that creates an instance of the {@link AwsWafRuleDetails.Builder} avoiding the
         * need to create one manually via {@link AwsWafRuleDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsWafRuleDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #awsWafRule(AwsWafRuleDetails)}.
         * 
         * @param awsWafRule
         *        a consumer that will call methods on {@link AwsWafRuleDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #awsWafRule(AwsWafRuleDetails)
         */
        default Builder awsWafRule(Consumer<AwsWafRuleDetails.Builder> awsWafRule) {
            return awsWafRule(AwsWafRuleDetails.builder().applyMutation(awsWafRule).build());
        }

        /**
         * <p>
         * Details about an WAF rule group for global resources.
         * </p>
         * 
         * @param awsWafRuleGroup
         *        Details about an WAF rule group for global resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsWafRuleGroup(AwsWafRuleGroupDetails awsWafRuleGroup);

        /**
         * <p>
         * Details about an WAF rule group for global resources.
         * </p>
         * This is a convenience method that creates an instance of the {@link AwsWafRuleGroupDetails.Builder} avoiding
         * the need to create one manually via {@link AwsWafRuleGroupDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsWafRuleGroupDetails.Builder#build()} is called immediately and
         * its result is passed to {@link #awsWafRuleGroup(AwsWafRuleGroupDetails)}.
         * 
         * @param awsWafRuleGroup
         *        a consumer that will call methods on {@link AwsWafRuleGroupDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #awsWafRuleGroup(AwsWafRuleGroupDetails)
         */
        default Builder awsWafRuleGroup(Consumer<AwsWafRuleGroupDetails.Builder> awsWafRuleGroup) {
            return awsWafRuleGroup(AwsWafRuleGroupDetails.builder().applyMutation(awsWafRuleGroup).build());
        }

        /**
         * <p>
         * Details about a task in a cluster.
         * </p>
         * 
         * @param awsEcsTask
         *        Details about a task in a cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsEcsTask(AwsEcsTaskDetails awsEcsTask);

        /**
         * <p>
         * Details about a task in a cluster.
         * </p>
         * This is a convenience method that creates an instance of the {@link AwsEcsTaskDetails.Builder} avoiding the
         * need to create one manually via {@link AwsEcsTaskDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsEcsTaskDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #awsEcsTask(AwsEcsTaskDetails)}.
         * 
         * @param awsEcsTask
         *        a consumer that will call methods on {@link AwsEcsTaskDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #awsEcsTask(AwsEcsTaskDetails)
         */
        default Builder awsEcsTask(Consumer<AwsEcsTaskDetails.Builder> awsEcsTask) {
            return awsEcsTask(AwsEcsTaskDetails.builder().applyMutation(awsEcsTask).build());
        }

        /**
         * <p>
         * Provides details about an Backup backup vault.
         * </p>
         * 
         * @param awsBackupBackupVault
         *        Provides details about an Backup backup vault.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsBackupBackupVault(AwsBackupBackupVaultDetails awsBackupBackupVault);

        /**
         * <p>
         * Provides details about an Backup backup vault.
         * </p>
         * This is a convenience method that creates an instance of the {@link AwsBackupBackupVaultDetails.Builder}
         * avoiding the need to create one manually via {@link AwsBackupBackupVaultDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsBackupBackupVaultDetails.Builder#build()} is called
         * immediately and its result is passed to {@link #awsBackupBackupVault(AwsBackupBackupVaultDetails)}.
         * 
         * @param awsBackupBackupVault
         *        a consumer that will call methods on {@link AwsBackupBackupVaultDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #awsBackupBackupVault(AwsBackupBackupVaultDetails)
         */
        default Builder awsBackupBackupVault(Consumer<AwsBackupBackupVaultDetails.Builder> awsBackupBackupVault) {
            return awsBackupBackupVault(AwsBackupBackupVaultDetails.builder().applyMutation(awsBackupBackupVault).build());
        }

        /**
         * <p>
         * Provides details about an Backup backup plan.
         * </p>
         * 
         * @param awsBackupBackupPlan
         *        Provides details about an Backup backup plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsBackupBackupPlan(AwsBackupBackupPlanDetails awsBackupBackupPlan);

        /**
         * <p>
         * Provides details about an Backup backup plan.
         * </p>
         * This is a convenience method that creates an instance of the {@link AwsBackupBackupPlanDetails.Builder}
         * avoiding the need to create one manually via {@link AwsBackupBackupPlanDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsBackupBackupPlanDetails.Builder#build()} is called immediately
         * and its result is passed to {@link #awsBackupBackupPlan(AwsBackupBackupPlanDetails)}.
         * 
         * @param awsBackupBackupPlan
         *        a consumer that will call methods on {@link AwsBackupBackupPlanDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #awsBackupBackupPlan(AwsBackupBackupPlanDetails)
         */
        default Builder awsBackupBackupPlan(Consumer<AwsBackupBackupPlanDetails.Builder> awsBackupBackupPlan) {
            return awsBackupBackupPlan(AwsBackupBackupPlanDetails.builder().applyMutation(awsBackupBackupPlan).build());
        }

        /**
         * <p>
         * Provides details about an Backup backup, or recovery point.
         * </p>
         * 
         * @param awsBackupRecoveryPoint
         *        Provides details about an Backup backup, or recovery point.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsBackupRecoveryPoint(AwsBackupRecoveryPointDetails awsBackupRecoveryPoint);

        /**
         * <p>
         * Provides details about an Backup backup, or recovery point.
         * </p>
         * This is a convenience method that creates an instance of the {@link AwsBackupRecoveryPointDetails.Builder}
         * avoiding the need to create one manually via {@link AwsBackupRecoveryPointDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsBackupRecoveryPointDetails.Builder#build()} is called
         * immediately and its result is passed to {@link #awsBackupRecoveryPoint(AwsBackupRecoveryPointDetails)}.
         * 
         * @param awsBackupRecoveryPoint
         *        a consumer that will call methods on {@link AwsBackupRecoveryPointDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #awsBackupRecoveryPoint(AwsBackupRecoveryPointDetails)
         */
        default Builder awsBackupRecoveryPoint(Consumer<AwsBackupRecoveryPointDetails.Builder> awsBackupRecoveryPoint) {
            return awsBackupRecoveryPoint(AwsBackupRecoveryPointDetails.builder().applyMutation(awsBackupRecoveryPoint).build());
        }

        /**
         * Sets the value of the AwsEc2LaunchTemplate property for this object.
         *
         * @param awsEc2LaunchTemplate
         *        The new value for the AwsEc2LaunchTemplate property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsEc2LaunchTemplate(AwsEc2LaunchTemplateDetails awsEc2LaunchTemplate);

        /**
         * Sets the value of the AwsEc2LaunchTemplate property for this object.
         *
         * This is a convenience method that creates an instance of the {@link AwsEc2LaunchTemplateDetails.Builder}
         * avoiding the need to create one manually via {@link AwsEc2LaunchTemplateDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsEc2LaunchTemplateDetails.Builder#build()} is called
         * immediately and its result is passed to {@link #awsEc2LaunchTemplate(AwsEc2LaunchTemplateDetails)}.
         * 
         * @param awsEc2LaunchTemplate
         *        a consumer that will call methods on {@link AwsEc2LaunchTemplateDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #awsEc2LaunchTemplate(AwsEc2LaunchTemplateDetails)
         */
        default Builder awsEc2LaunchTemplate(Consumer<AwsEc2LaunchTemplateDetails.Builder> awsEc2LaunchTemplate) {
            return awsEc2LaunchTemplate(AwsEc2LaunchTemplateDetails.builder().applyMutation(awsEc2LaunchTemplate).build());
        }

        /**
         * Sets the value of the AwsSageMakerNotebookInstance property for this object.
         *
         * @param awsSageMakerNotebookInstance
         *        The new value for the AwsSageMakerNotebookInstance property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsSageMakerNotebookInstance(AwsSageMakerNotebookInstanceDetails awsSageMakerNotebookInstance);

        /**
         * Sets the value of the AwsSageMakerNotebookInstance property for this object.
         *
         * This is a convenience method that creates an instance of the
         * {@link AwsSageMakerNotebookInstanceDetails.Builder} avoiding the need to create one manually via
         * {@link AwsSageMakerNotebookInstanceDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsSageMakerNotebookInstanceDetails.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #awsSageMakerNotebookInstance(AwsSageMakerNotebookInstanceDetails)}.
         * 
         * @param awsSageMakerNotebookInstance
         *        a consumer that will call methods on {@link AwsSageMakerNotebookInstanceDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #awsSageMakerNotebookInstance(AwsSageMakerNotebookInstanceDetails)
         */
        default Builder awsSageMakerNotebookInstance(
                Consumer<AwsSageMakerNotebookInstanceDetails.Builder> awsSageMakerNotebookInstance) {
            return awsSageMakerNotebookInstance(AwsSageMakerNotebookInstanceDetails.builder()
                    .applyMutation(awsSageMakerNotebookInstance).build());
        }

        /**
         * Sets the value of the AwsWafv2WebAcl property for this object.
         *
         * @param awsWafv2WebAcl
         *        The new value for the AwsWafv2WebAcl property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsWafv2WebAcl(AwsWafv2WebAclDetails awsWafv2WebAcl);

        /**
         * Sets the value of the AwsWafv2WebAcl property for this object.
         *
         * This is a convenience method that creates an instance of the {@link AwsWafv2WebAclDetails.Builder} avoiding
         * the need to create one manually via {@link AwsWafv2WebAclDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsWafv2WebAclDetails.Builder#build()} is called immediately and
         * its result is passed to {@link #awsWafv2WebAcl(AwsWafv2WebAclDetails)}.
         * 
         * @param awsWafv2WebAcl
         *        a consumer that will call methods on {@link AwsWafv2WebAclDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #awsWafv2WebAcl(AwsWafv2WebAclDetails)
         */
        default Builder awsWafv2WebAcl(Consumer<AwsWafv2WebAclDetails.Builder> awsWafv2WebAcl) {
            return awsWafv2WebAcl(AwsWafv2WebAclDetails.builder().applyMutation(awsWafv2WebAcl).build());
        }

        /**
         * Sets the value of the AwsWafv2RuleGroup property for this object.
         *
         * @param awsWafv2RuleGroup
         *        The new value for the AwsWafv2RuleGroup property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsWafv2RuleGroup(AwsWafv2RuleGroupDetails awsWafv2RuleGroup);

        /**
         * Sets the value of the AwsWafv2RuleGroup property for this object.
         *
         * This is a convenience method that creates an instance of the {@link AwsWafv2RuleGroupDetails.Builder}
         * avoiding the need to create one manually via {@link AwsWafv2RuleGroupDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsWafv2RuleGroupDetails.Builder#build()} is called immediately
         * and its result is passed to {@link #awsWafv2RuleGroup(AwsWafv2RuleGroupDetails)}.
         * 
         * @param awsWafv2RuleGroup
         *        a consumer that will call methods on {@link AwsWafv2RuleGroupDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #awsWafv2RuleGroup(AwsWafv2RuleGroupDetails)
         */
        default Builder awsWafv2RuleGroup(Consumer<AwsWafv2RuleGroupDetails.Builder> awsWafv2RuleGroup) {
            return awsWafv2RuleGroup(AwsWafv2RuleGroupDetails.builder().applyMutation(awsWafv2RuleGroup).build());
        }

        /**
         * <p>
         * Provides details about a route table. A route table contains a set of rules, called routes, that determine
         * where to direct network traffic from your subnet or gateway.
         * </p>
         * 
         * @param awsEc2RouteTable
         *        Provides details about a route table. A route table contains a set of rules, called routes, that
         *        determine where to direct network traffic from your subnet or gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsEc2RouteTable(AwsEc2RouteTableDetails awsEc2RouteTable);

        /**
         * <p>
         * Provides details about a route table. A route table contains a set of rules, called routes, that determine
         * where to direct network traffic from your subnet or gateway.
         * </p>
         * This is a convenience method that creates an instance of the {@link AwsEc2RouteTableDetails.Builder} avoiding
         * the need to create one manually via {@link AwsEc2RouteTableDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsEc2RouteTableDetails.Builder#build()} is called immediately
         * and its result is passed to {@link #awsEc2RouteTable(AwsEc2RouteTableDetails)}.
         * 
         * @param awsEc2RouteTable
         *        a consumer that will call methods on {@link AwsEc2RouteTableDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #awsEc2RouteTable(AwsEc2RouteTableDetails)
         */
        default Builder awsEc2RouteTable(Consumer<AwsEc2RouteTableDetails.Builder> awsEc2RouteTable) {
            return awsEc2RouteTable(AwsEc2RouteTableDetails.builder().applyMutation(awsEc2RouteTable).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private AwsAutoScalingAutoScalingGroupDetails awsAutoScalingAutoScalingGroup;

        private AwsCodeBuildProjectDetails awsCodeBuildProject;

        private AwsCloudFrontDistributionDetails awsCloudFrontDistribution;

        private AwsEc2InstanceDetails awsEc2Instance;

        private AwsEc2NetworkInterfaceDetails awsEc2NetworkInterface;

        private AwsEc2SecurityGroupDetails awsEc2SecurityGroup;

        private AwsEc2VolumeDetails awsEc2Volume;

        private AwsEc2VpcDetails awsEc2Vpc;

        private AwsEc2EipDetails awsEc2Eip;

        private AwsEc2SubnetDetails awsEc2Subnet;

        private AwsEc2NetworkAclDetails awsEc2NetworkAcl;

        private AwsElbv2LoadBalancerDetails awsElbv2LoadBalancer;

        private AwsElasticBeanstalkEnvironmentDetails awsElasticBeanstalkEnvironment;

        private AwsElasticsearchDomainDetails awsElasticsearchDomain;

        private AwsS3BucketDetails awsS3Bucket;

        private AwsS3AccountPublicAccessBlockDetails awsS3AccountPublicAccessBlock;

        private AwsS3ObjectDetails awsS3Object;

        private AwsSecretsManagerSecretDetails awsSecretsManagerSecret;

        private AwsIamAccessKeyDetails awsIamAccessKey;

        private AwsIamUserDetails awsIamUser;

        private AwsIamPolicyDetails awsIamPolicy;

        private AwsApiGatewayV2StageDetails awsApiGatewayV2Stage;

        private AwsApiGatewayV2ApiDetails awsApiGatewayV2Api;

        private AwsDynamoDbTableDetails awsDynamoDbTable;

        private AwsApiGatewayStageDetails awsApiGatewayStage;

        private AwsApiGatewayRestApiDetails awsApiGatewayRestApi;

        private AwsCloudTrailTrailDetails awsCloudTrailTrail;

        private AwsSsmPatchComplianceDetails awsSsmPatchCompliance;

        private AwsCertificateManagerCertificateDetails awsCertificateManagerCertificate;

        private AwsRedshiftClusterDetails awsRedshiftCluster;

        private AwsElbLoadBalancerDetails awsElbLoadBalancer;

        private AwsIamGroupDetails awsIamGroup;

        private AwsIamRoleDetails awsIamRole;

        private AwsKmsKeyDetails awsKmsKey;

        private AwsLambdaFunctionDetails awsLambdaFunction;

        private AwsLambdaLayerVersionDetails awsLambdaLayerVersion;

        private AwsRdsDbInstanceDetails awsRdsDbInstance;

        private AwsSnsTopicDetails awsSnsTopic;

        private AwsSqsQueueDetails awsSqsQueue;

        private AwsWafWebAclDetails awsWafWebAcl;

        private AwsRdsDbSnapshotDetails awsRdsDbSnapshot;

        private AwsRdsDbClusterSnapshotDetails awsRdsDbClusterSnapshot;

        private AwsRdsDbClusterDetails awsRdsDbCluster;

        private AwsEcsClusterDetails awsEcsCluster;

        private AwsEcsContainerDetails awsEcsContainer;

        private AwsEcsTaskDefinitionDetails awsEcsTaskDefinition;

        private ContainerDetails container;

        private Map<String, String> other = DefaultSdkAutoConstructMap.getInstance();

        private AwsRdsEventSubscriptionDetails awsRdsEventSubscription;

        private AwsEcsServiceDetails awsEcsService;

        private AwsAutoScalingLaunchConfigurationDetails awsAutoScalingLaunchConfiguration;

        private AwsEc2VpnConnectionDetails awsEc2VpnConnection;

        private AwsEcrContainerImageDetails awsEcrContainerImage;

        private AwsOpenSearchServiceDomainDetails awsOpenSearchServiceDomain;

        private AwsEc2VpcEndpointServiceDetails awsEc2VpcEndpointService;

        private AwsXrayEncryptionConfigDetails awsXrayEncryptionConfig;

        private AwsWafRateBasedRuleDetails awsWafRateBasedRule;

        private AwsWafRegionalRateBasedRuleDetails awsWafRegionalRateBasedRule;

        private AwsEcrRepositoryDetails awsEcrRepository;

        private AwsEksClusterDetails awsEksCluster;

        private AwsNetworkFirewallFirewallPolicyDetails awsNetworkFirewallFirewallPolicy;

        private AwsNetworkFirewallFirewallDetails awsNetworkFirewallFirewall;

        private AwsNetworkFirewallRuleGroupDetails awsNetworkFirewallRuleGroup;

        private AwsRdsDbSecurityGroupDetails awsRdsDbSecurityGroup;

        private AwsKinesisStreamDetails awsKinesisStream;

        private AwsEc2TransitGatewayDetails awsEc2TransitGateway;

        private AwsEfsAccessPointDetails awsEfsAccessPoint;

        private AwsCloudFormationStackDetails awsCloudFormationStack;

        private AwsCloudWatchAlarmDetails awsCloudWatchAlarm;

        private AwsEc2VpcPeeringConnectionDetails awsEc2VpcPeeringConnection;

        private AwsWafRegionalRuleGroupDetails awsWafRegionalRuleGroup;

        private AwsWafRegionalRuleDetails awsWafRegionalRule;

        private AwsWafRegionalWebAclDetails awsWafRegionalWebAcl;

        private AwsWafRuleDetails awsWafRule;

        private AwsWafRuleGroupDetails awsWafRuleGroup;

        private AwsEcsTaskDetails awsEcsTask;

        private AwsBackupBackupVaultDetails awsBackupBackupVault;

        private AwsBackupBackupPlanDetails awsBackupBackupPlan;

        private AwsBackupRecoveryPointDetails awsBackupRecoveryPoint;

        private AwsEc2LaunchTemplateDetails awsEc2LaunchTemplate;

        private AwsSageMakerNotebookInstanceDetails awsSageMakerNotebookInstance;

        private AwsWafv2WebAclDetails awsWafv2WebAcl;

        private AwsWafv2RuleGroupDetails awsWafv2RuleGroup;

        private AwsEc2RouteTableDetails awsEc2RouteTable;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceDetails model) {
            awsAutoScalingAutoScalingGroup(model.awsAutoScalingAutoScalingGroup);
            awsCodeBuildProject(model.awsCodeBuildProject);
            awsCloudFrontDistribution(model.awsCloudFrontDistribution);
            awsEc2Instance(model.awsEc2Instance);
            awsEc2NetworkInterface(model.awsEc2NetworkInterface);
            awsEc2SecurityGroup(model.awsEc2SecurityGroup);
            awsEc2Volume(model.awsEc2Volume);
            awsEc2Vpc(model.awsEc2Vpc);
            awsEc2Eip(model.awsEc2Eip);
            awsEc2Subnet(model.awsEc2Subnet);
            awsEc2NetworkAcl(model.awsEc2NetworkAcl);
            awsElbv2LoadBalancer(model.awsElbv2LoadBalancer);
            awsElasticBeanstalkEnvironment(model.awsElasticBeanstalkEnvironment);
            awsElasticsearchDomain(model.awsElasticsearchDomain);
            awsS3Bucket(model.awsS3Bucket);
            awsS3AccountPublicAccessBlock(model.awsS3AccountPublicAccessBlock);
            awsS3Object(model.awsS3Object);
            awsSecretsManagerSecret(model.awsSecretsManagerSecret);
            awsIamAccessKey(model.awsIamAccessKey);
            awsIamUser(model.awsIamUser);
            awsIamPolicy(model.awsIamPolicy);
            awsApiGatewayV2Stage(model.awsApiGatewayV2Stage);
            awsApiGatewayV2Api(model.awsApiGatewayV2Api);
            awsDynamoDbTable(model.awsDynamoDbTable);
            awsApiGatewayStage(model.awsApiGatewayStage);
            awsApiGatewayRestApi(model.awsApiGatewayRestApi);
            awsCloudTrailTrail(model.awsCloudTrailTrail);
            awsSsmPatchCompliance(model.awsSsmPatchCompliance);
            awsCertificateManagerCertificate(model.awsCertificateManagerCertificate);
            awsRedshiftCluster(model.awsRedshiftCluster);
            awsElbLoadBalancer(model.awsElbLoadBalancer);
            awsIamGroup(model.awsIamGroup);
            awsIamRole(model.awsIamRole);
            awsKmsKey(model.awsKmsKey);
            awsLambdaFunction(model.awsLambdaFunction);
            awsLambdaLayerVersion(model.awsLambdaLayerVersion);
            awsRdsDbInstance(model.awsRdsDbInstance);
            awsSnsTopic(model.awsSnsTopic);
            awsSqsQueue(model.awsSqsQueue);
            awsWafWebAcl(model.awsWafWebAcl);
            awsRdsDbSnapshot(model.awsRdsDbSnapshot);
            awsRdsDbClusterSnapshot(model.awsRdsDbClusterSnapshot);
            awsRdsDbCluster(model.awsRdsDbCluster);
            awsEcsCluster(model.awsEcsCluster);
            awsEcsContainer(model.awsEcsContainer);
            awsEcsTaskDefinition(model.awsEcsTaskDefinition);
            container(model.container);
            other(model.other);
            awsRdsEventSubscription(model.awsRdsEventSubscription);
            awsEcsService(model.awsEcsService);
            awsAutoScalingLaunchConfiguration(model.awsAutoScalingLaunchConfiguration);
            awsEc2VpnConnection(model.awsEc2VpnConnection);
            awsEcrContainerImage(model.awsEcrContainerImage);
            awsOpenSearchServiceDomain(model.awsOpenSearchServiceDomain);
            awsEc2VpcEndpointService(model.awsEc2VpcEndpointService);
            awsXrayEncryptionConfig(model.awsXrayEncryptionConfig);
            awsWafRateBasedRule(model.awsWafRateBasedRule);
            awsWafRegionalRateBasedRule(model.awsWafRegionalRateBasedRule);
            awsEcrRepository(model.awsEcrRepository);
            awsEksCluster(model.awsEksCluster);
            awsNetworkFirewallFirewallPolicy(model.awsNetworkFirewallFirewallPolicy);
            awsNetworkFirewallFirewall(model.awsNetworkFirewallFirewall);
            awsNetworkFirewallRuleGroup(model.awsNetworkFirewallRuleGroup);
            awsRdsDbSecurityGroup(model.awsRdsDbSecurityGroup);
            awsKinesisStream(model.awsKinesisStream);
            awsEc2TransitGateway(model.awsEc2TransitGateway);
            awsEfsAccessPoint(model.awsEfsAccessPoint);
            awsCloudFormationStack(model.awsCloudFormationStack);
            awsCloudWatchAlarm(model.awsCloudWatchAlarm);
            awsEc2VpcPeeringConnection(model.awsEc2VpcPeeringConnection);
            awsWafRegionalRuleGroup(model.awsWafRegionalRuleGroup);
            awsWafRegionalRule(model.awsWafRegionalRule);
            awsWafRegionalWebAcl(model.awsWafRegionalWebAcl);
            awsWafRule(model.awsWafRule);
            awsWafRuleGroup(model.awsWafRuleGroup);
            awsEcsTask(model.awsEcsTask);
            awsBackupBackupVault(model.awsBackupBackupVault);
            awsBackupBackupPlan(model.awsBackupBackupPlan);
            awsBackupRecoveryPoint(model.awsBackupRecoveryPoint);
            awsEc2LaunchTemplate(model.awsEc2LaunchTemplate);
            awsSageMakerNotebookInstance(model.awsSageMakerNotebookInstance);
            awsWafv2WebAcl(model.awsWafv2WebAcl);
            awsWafv2RuleGroup(model.awsWafv2RuleGroup);
            awsEc2RouteTable(model.awsEc2RouteTable);
        }

        public final AwsAutoScalingAutoScalingGroupDetails.Builder getAwsAutoScalingAutoScalingGroup() {
            return awsAutoScalingAutoScalingGroup != null ? awsAutoScalingAutoScalingGroup.toBuilder() : null;
        }

        public final void setAwsAutoScalingAutoScalingGroup(
                AwsAutoScalingAutoScalingGroupDetails.BuilderImpl awsAutoScalingAutoScalingGroup) {
            this.awsAutoScalingAutoScalingGroup = awsAutoScalingAutoScalingGroup != null ? awsAutoScalingAutoScalingGroup.build()
                    : null;
        }

        @Override
        public final Builder awsAutoScalingAutoScalingGroup(AwsAutoScalingAutoScalingGroupDetails awsAutoScalingAutoScalingGroup) {
            this.awsAutoScalingAutoScalingGroup = awsAutoScalingAutoScalingGroup;
            return this;
        }

        public final AwsCodeBuildProjectDetails.Builder getAwsCodeBuildProject() {
            return awsCodeBuildProject != null ? awsCodeBuildProject.toBuilder() : null;
        }

        public final void setAwsCodeBuildProject(AwsCodeBuildProjectDetails.BuilderImpl awsCodeBuildProject) {
            this.awsCodeBuildProject = awsCodeBuildProject != null ? awsCodeBuildProject.build() : null;
        }

        @Override
        public final Builder awsCodeBuildProject(AwsCodeBuildProjectDetails awsCodeBuildProject) {
            this.awsCodeBuildProject = awsCodeBuildProject;
            return this;
        }

        public final AwsCloudFrontDistributionDetails.Builder getAwsCloudFrontDistribution() {
            return awsCloudFrontDistribution != null ? awsCloudFrontDistribution.toBuilder() : null;
        }

        public final void setAwsCloudFrontDistribution(AwsCloudFrontDistributionDetails.BuilderImpl awsCloudFrontDistribution) {
            this.awsCloudFrontDistribution = awsCloudFrontDistribution != null ? awsCloudFrontDistribution.build() : null;
        }

        @Override
        public final Builder awsCloudFrontDistribution(AwsCloudFrontDistributionDetails awsCloudFrontDistribution) {
            this.awsCloudFrontDistribution = awsCloudFrontDistribution;
            return this;
        }

        public final AwsEc2InstanceDetails.Builder getAwsEc2Instance() {
            return awsEc2Instance != null ? awsEc2Instance.toBuilder() : null;
        }

        public final void setAwsEc2Instance(AwsEc2InstanceDetails.BuilderImpl awsEc2Instance) {
            this.awsEc2Instance = awsEc2Instance != null ? awsEc2Instance.build() : null;
        }

        @Override
        public final Builder awsEc2Instance(AwsEc2InstanceDetails awsEc2Instance) {
            this.awsEc2Instance = awsEc2Instance;
            return this;
        }

        public final AwsEc2NetworkInterfaceDetails.Builder getAwsEc2NetworkInterface() {
            return awsEc2NetworkInterface != null ? awsEc2NetworkInterface.toBuilder() : null;
        }

        public final void setAwsEc2NetworkInterface(AwsEc2NetworkInterfaceDetails.BuilderImpl awsEc2NetworkInterface) {
            this.awsEc2NetworkInterface = awsEc2NetworkInterface != null ? awsEc2NetworkInterface.build() : null;
        }

        @Override
        public final Builder awsEc2NetworkInterface(AwsEc2NetworkInterfaceDetails awsEc2NetworkInterface) {
            this.awsEc2NetworkInterface = awsEc2NetworkInterface;
            return this;
        }

        public final AwsEc2SecurityGroupDetails.Builder getAwsEc2SecurityGroup() {
            return awsEc2SecurityGroup != null ? awsEc2SecurityGroup.toBuilder() : null;
        }

        public final void setAwsEc2SecurityGroup(AwsEc2SecurityGroupDetails.BuilderImpl awsEc2SecurityGroup) {
            this.awsEc2SecurityGroup = awsEc2SecurityGroup != null ? awsEc2SecurityGroup.build() : null;
        }

        @Override
        public final Builder awsEc2SecurityGroup(AwsEc2SecurityGroupDetails awsEc2SecurityGroup) {
            this.awsEc2SecurityGroup = awsEc2SecurityGroup;
            return this;
        }

        public final AwsEc2VolumeDetails.Builder getAwsEc2Volume() {
            return awsEc2Volume != null ? awsEc2Volume.toBuilder() : null;
        }

        public final void setAwsEc2Volume(AwsEc2VolumeDetails.BuilderImpl awsEc2Volume) {
            this.awsEc2Volume = awsEc2Volume != null ? awsEc2Volume.build() : null;
        }

        @Override
        public final Builder awsEc2Volume(AwsEc2VolumeDetails awsEc2Volume) {
            this.awsEc2Volume = awsEc2Volume;
            return this;
        }

        public final AwsEc2VpcDetails.Builder getAwsEc2Vpc() {
            return awsEc2Vpc != null ? awsEc2Vpc.toBuilder() : null;
        }

        public final void setAwsEc2Vpc(AwsEc2VpcDetails.BuilderImpl awsEc2Vpc) {
            this.awsEc2Vpc = awsEc2Vpc != null ? awsEc2Vpc.build() : null;
        }

        @Override
        public final Builder awsEc2Vpc(AwsEc2VpcDetails awsEc2Vpc) {
            this.awsEc2Vpc = awsEc2Vpc;
            return this;
        }

        public final AwsEc2EipDetails.Builder getAwsEc2Eip() {
            return awsEc2Eip != null ? awsEc2Eip.toBuilder() : null;
        }

        public final void setAwsEc2Eip(AwsEc2EipDetails.BuilderImpl awsEc2Eip) {
            this.awsEc2Eip = awsEc2Eip != null ? awsEc2Eip.build() : null;
        }

        @Override
        public final Builder awsEc2Eip(AwsEc2EipDetails awsEc2Eip) {
            this.awsEc2Eip = awsEc2Eip;
            return this;
        }

        public final AwsEc2SubnetDetails.Builder getAwsEc2Subnet() {
            return awsEc2Subnet != null ? awsEc2Subnet.toBuilder() : null;
        }

        public final void setAwsEc2Subnet(AwsEc2SubnetDetails.BuilderImpl awsEc2Subnet) {
            this.awsEc2Subnet = awsEc2Subnet != null ? awsEc2Subnet.build() : null;
        }

        @Override
        public final Builder awsEc2Subnet(AwsEc2SubnetDetails awsEc2Subnet) {
            this.awsEc2Subnet = awsEc2Subnet;
            return this;
        }

        public final AwsEc2NetworkAclDetails.Builder getAwsEc2NetworkAcl() {
            return awsEc2NetworkAcl != null ? awsEc2NetworkAcl.toBuilder() : null;
        }

        public final void setAwsEc2NetworkAcl(AwsEc2NetworkAclDetails.BuilderImpl awsEc2NetworkAcl) {
            this.awsEc2NetworkAcl = awsEc2NetworkAcl != null ? awsEc2NetworkAcl.build() : null;
        }

        @Override
        public final Builder awsEc2NetworkAcl(AwsEc2NetworkAclDetails awsEc2NetworkAcl) {
            this.awsEc2NetworkAcl = awsEc2NetworkAcl;
            return this;
        }

        public final AwsElbv2LoadBalancerDetails.Builder getAwsElbv2LoadBalancer() {
            return awsElbv2LoadBalancer != null ? awsElbv2LoadBalancer.toBuilder() : null;
        }

        public final void setAwsElbv2LoadBalancer(AwsElbv2LoadBalancerDetails.BuilderImpl awsElbv2LoadBalancer) {
            this.awsElbv2LoadBalancer = awsElbv2LoadBalancer != null ? awsElbv2LoadBalancer.build() : null;
        }

        @Override
        public final Builder awsElbv2LoadBalancer(AwsElbv2LoadBalancerDetails awsElbv2LoadBalancer) {
            this.awsElbv2LoadBalancer = awsElbv2LoadBalancer;
            return this;
        }

        public final AwsElasticBeanstalkEnvironmentDetails.Builder getAwsElasticBeanstalkEnvironment() {
            return awsElasticBeanstalkEnvironment != null ? awsElasticBeanstalkEnvironment.toBuilder() : null;
        }

        public final void setAwsElasticBeanstalkEnvironment(
                AwsElasticBeanstalkEnvironmentDetails.BuilderImpl awsElasticBeanstalkEnvironment) {
            this.awsElasticBeanstalkEnvironment = awsElasticBeanstalkEnvironment != null ? awsElasticBeanstalkEnvironment.build()
                    : null;
        }

        @Override
        public final Builder awsElasticBeanstalkEnvironment(AwsElasticBeanstalkEnvironmentDetails awsElasticBeanstalkEnvironment) {
            this.awsElasticBeanstalkEnvironment = awsElasticBeanstalkEnvironment;
            return this;
        }

        public final AwsElasticsearchDomainDetails.Builder getAwsElasticsearchDomain() {
            return awsElasticsearchDomain != null ? awsElasticsearchDomain.toBuilder() : null;
        }

        public final void setAwsElasticsearchDomain(AwsElasticsearchDomainDetails.BuilderImpl awsElasticsearchDomain) {
            this.awsElasticsearchDomain = awsElasticsearchDomain != null ? awsElasticsearchDomain.build() : null;
        }

        @Override
        public final Builder awsElasticsearchDomain(AwsElasticsearchDomainDetails awsElasticsearchDomain) {
            this.awsElasticsearchDomain = awsElasticsearchDomain;
            return this;
        }

        public final AwsS3BucketDetails.Builder getAwsS3Bucket() {
            return awsS3Bucket != null ? awsS3Bucket.toBuilder() : null;
        }

        public final void setAwsS3Bucket(AwsS3BucketDetails.BuilderImpl awsS3Bucket) {
            this.awsS3Bucket = awsS3Bucket != null ? awsS3Bucket.build() : null;
        }

        @Override
        public final Builder awsS3Bucket(AwsS3BucketDetails awsS3Bucket) {
            this.awsS3Bucket = awsS3Bucket;
            return this;
        }

        public final AwsS3AccountPublicAccessBlockDetails.Builder getAwsS3AccountPublicAccessBlock() {
            return awsS3AccountPublicAccessBlock != null ? awsS3AccountPublicAccessBlock.toBuilder() : null;
        }

        public final void setAwsS3AccountPublicAccessBlock(
                AwsS3AccountPublicAccessBlockDetails.BuilderImpl awsS3AccountPublicAccessBlock) {
            this.awsS3AccountPublicAccessBlock = awsS3AccountPublicAccessBlock != null ? awsS3AccountPublicAccessBlock.build()
                    : null;
        }

        @Override
        public final Builder awsS3AccountPublicAccessBlock(AwsS3AccountPublicAccessBlockDetails awsS3AccountPublicAccessBlock) {
            this.awsS3AccountPublicAccessBlock = awsS3AccountPublicAccessBlock;
            return this;
        }

        public final AwsS3ObjectDetails.Builder getAwsS3Object() {
            return awsS3Object != null ? awsS3Object.toBuilder() : null;
        }

        public final void setAwsS3Object(AwsS3ObjectDetails.BuilderImpl awsS3Object) {
            this.awsS3Object = awsS3Object != null ? awsS3Object.build() : null;
        }

        @Override
        public final Builder awsS3Object(AwsS3ObjectDetails awsS3Object) {
            this.awsS3Object = awsS3Object;
            return this;
        }

        public final AwsSecretsManagerSecretDetails.Builder getAwsSecretsManagerSecret() {
            return awsSecretsManagerSecret != null ? awsSecretsManagerSecret.toBuilder() : null;
        }

        public final void setAwsSecretsManagerSecret(AwsSecretsManagerSecretDetails.BuilderImpl awsSecretsManagerSecret) {
            this.awsSecretsManagerSecret = awsSecretsManagerSecret != null ? awsSecretsManagerSecret.build() : null;
        }

        @Override
        public final Builder awsSecretsManagerSecret(AwsSecretsManagerSecretDetails awsSecretsManagerSecret) {
            this.awsSecretsManagerSecret = awsSecretsManagerSecret;
            return this;
        }

        public final AwsIamAccessKeyDetails.Builder getAwsIamAccessKey() {
            return awsIamAccessKey != null ? awsIamAccessKey.toBuilder() : null;
        }

        public final void setAwsIamAccessKey(AwsIamAccessKeyDetails.BuilderImpl awsIamAccessKey) {
            this.awsIamAccessKey = awsIamAccessKey != null ? awsIamAccessKey.build() : null;
        }

        @Override
        public final Builder awsIamAccessKey(AwsIamAccessKeyDetails awsIamAccessKey) {
            this.awsIamAccessKey = awsIamAccessKey;
            return this;
        }

        public final AwsIamUserDetails.Builder getAwsIamUser() {
            return awsIamUser != null ? awsIamUser.toBuilder() : null;
        }

        public final void setAwsIamUser(AwsIamUserDetails.BuilderImpl awsIamUser) {
            this.awsIamUser = awsIamUser != null ? awsIamUser.build() : null;
        }

        @Override
        public final Builder awsIamUser(AwsIamUserDetails awsIamUser) {
            this.awsIamUser = awsIamUser;
            return this;
        }

        public final AwsIamPolicyDetails.Builder getAwsIamPolicy() {
            return awsIamPolicy != null ? awsIamPolicy.toBuilder() : null;
        }

        public final void setAwsIamPolicy(AwsIamPolicyDetails.BuilderImpl awsIamPolicy) {
            this.awsIamPolicy = awsIamPolicy != null ? awsIamPolicy.build() : null;
        }

        @Override
        public final Builder awsIamPolicy(AwsIamPolicyDetails awsIamPolicy) {
            this.awsIamPolicy = awsIamPolicy;
            return this;
        }

        public final AwsApiGatewayV2StageDetails.Builder getAwsApiGatewayV2Stage() {
            return awsApiGatewayV2Stage != null ? awsApiGatewayV2Stage.toBuilder() : null;
        }

        public final void setAwsApiGatewayV2Stage(AwsApiGatewayV2StageDetails.BuilderImpl awsApiGatewayV2Stage) {
            this.awsApiGatewayV2Stage = awsApiGatewayV2Stage != null ? awsApiGatewayV2Stage.build() : null;
        }

        @Override
        public final Builder awsApiGatewayV2Stage(AwsApiGatewayV2StageDetails awsApiGatewayV2Stage) {
            this.awsApiGatewayV2Stage = awsApiGatewayV2Stage;
            return this;
        }

        public final AwsApiGatewayV2ApiDetails.Builder getAwsApiGatewayV2Api() {
            return awsApiGatewayV2Api != null ? awsApiGatewayV2Api.toBuilder() : null;
        }

        public final void setAwsApiGatewayV2Api(AwsApiGatewayV2ApiDetails.BuilderImpl awsApiGatewayV2Api) {
            this.awsApiGatewayV2Api = awsApiGatewayV2Api != null ? awsApiGatewayV2Api.build() : null;
        }

        @Override
        public final Builder awsApiGatewayV2Api(AwsApiGatewayV2ApiDetails awsApiGatewayV2Api) {
            this.awsApiGatewayV2Api = awsApiGatewayV2Api;
            return this;
        }

        public final AwsDynamoDbTableDetails.Builder getAwsDynamoDbTable() {
            return awsDynamoDbTable != null ? awsDynamoDbTable.toBuilder() : null;
        }

        public final void setAwsDynamoDbTable(AwsDynamoDbTableDetails.BuilderImpl awsDynamoDbTable) {
            this.awsDynamoDbTable = awsDynamoDbTable != null ? awsDynamoDbTable.build() : null;
        }

        @Override
        public final Builder awsDynamoDbTable(AwsDynamoDbTableDetails awsDynamoDbTable) {
            this.awsDynamoDbTable = awsDynamoDbTable;
            return this;
        }

        public final AwsApiGatewayStageDetails.Builder getAwsApiGatewayStage() {
            return awsApiGatewayStage != null ? awsApiGatewayStage.toBuilder() : null;
        }

        public final void setAwsApiGatewayStage(AwsApiGatewayStageDetails.BuilderImpl awsApiGatewayStage) {
            this.awsApiGatewayStage = awsApiGatewayStage != null ? awsApiGatewayStage.build() : null;
        }

        @Override
        public final Builder awsApiGatewayStage(AwsApiGatewayStageDetails awsApiGatewayStage) {
            this.awsApiGatewayStage = awsApiGatewayStage;
            return this;
        }

        public final AwsApiGatewayRestApiDetails.Builder getAwsApiGatewayRestApi() {
            return awsApiGatewayRestApi != null ? awsApiGatewayRestApi.toBuilder() : null;
        }

        public final void setAwsApiGatewayRestApi(AwsApiGatewayRestApiDetails.BuilderImpl awsApiGatewayRestApi) {
            this.awsApiGatewayRestApi = awsApiGatewayRestApi != null ? awsApiGatewayRestApi.build() : null;
        }

        @Override
        public final Builder awsApiGatewayRestApi(AwsApiGatewayRestApiDetails awsApiGatewayRestApi) {
            this.awsApiGatewayRestApi = awsApiGatewayRestApi;
            return this;
        }

        public final AwsCloudTrailTrailDetails.Builder getAwsCloudTrailTrail() {
            return awsCloudTrailTrail != null ? awsCloudTrailTrail.toBuilder() : null;
        }

        public final void setAwsCloudTrailTrail(AwsCloudTrailTrailDetails.BuilderImpl awsCloudTrailTrail) {
            this.awsCloudTrailTrail = awsCloudTrailTrail != null ? awsCloudTrailTrail.build() : null;
        }

        @Override
        public final Builder awsCloudTrailTrail(AwsCloudTrailTrailDetails awsCloudTrailTrail) {
            this.awsCloudTrailTrail = awsCloudTrailTrail;
            return this;
        }

        public final AwsSsmPatchComplianceDetails.Builder getAwsSsmPatchCompliance() {
            return awsSsmPatchCompliance != null ? awsSsmPatchCompliance.toBuilder() : null;
        }

        public final void setAwsSsmPatchCompliance(AwsSsmPatchComplianceDetails.BuilderImpl awsSsmPatchCompliance) {
            this.awsSsmPatchCompliance = awsSsmPatchCompliance != null ? awsSsmPatchCompliance.build() : null;
        }

        @Override
        public final Builder awsSsmPatchCompliance(AwsSsmPatchComplianceDetails awsSsmPatchCompliance) {
            this.awsSsmPatchCompliance = awsSsmPatchCompliance;
            return this;
        }

        public final AwsCertificateManagerCertificateDetails.Builder getAwsCertificateManagerCertificate() {
            return awsCertificateManagerCertificate != null ? awsCertificateManagerCertificate.toBuilder() : null;
        }

        public final void setAwsCertificateManagerCertificate(
                AwsCertificateManagerCertificateDetails.BuilderImpl awsCertificateManagerCertificate) {
            this.awsCertificateManagerCertificate = awsCertificateManagerCertificate != null ? awsCertificateManagerCertificate
                    .build() : null;
        }

        @Override
        public final Builder awsCertificateManagerCertificate(
                AwsCertificateManagerCertificateDetails awsCertificateManagerCertificate) {
            this.awsCertificateManagerCertificate = awsCertificateManagerCertificate;
            return this;
        }

        public final AwsRedshiftClusterDetails.Builder getAwsRedshiftCluster() {
            return awsRedshiftCluster != null ? awsRedshiftCluster.toBuilder() : null;
        }

        public final void setAwsRedshiftCluster(AwsRedshiftClusterDetails.BuilderImpl awsRedshiftCluster) {
            this.awsRedshiftCluster = awsRedshiftCluster != null ? awsRedshiftCluster.build() : null;
        }

        @Override
        public final Builder awsRedshiftCluster(AwsRedshiftClusterDetails awsRedshiftCluster) {
            this.awsRedshiftCluster = awsRedshiftCluster;
            return this;
        }

        public final AwsElbLoadBalancerDetails.Builder getAwsElbLoadBalancer() {
            return awsElbLoadBalancer != null ? awsElbLoadBalancer.toBuilder() : null;
        }

        public final void setAwsElbLoadBalancer(AwsElbLoadBalancerDetails.BuilderImpl awsElbLoadBalancer) {
            this.awsElbLoadBalancer = awsElbLoadBalancer != null ? awsElbLoadBalancer.build() : null;
        }

        @Override
        public final Builder awsElbLoadBalancer(AwsElbLoadBalancerDetails awsElbLoadBalancer) {
            this.awsElbLoadBalancer = awsElbLoadBalancer;
            return this;
        }

        public final AwsIamGroupDetails.Builder getAwsIamGroup() {
            return awsIamGroup != null ? awsIamGroup.toBuilder() : null;
        }

        public final void setAwsIamGroup(AwsIamGroupDetails.BuilderImpl awsIamGroup) {
            this.awsIamGroup = awsIamGroup != null ? awsIamGroup.build() : null;
        }

        @Override
        public final Builder awsIamGroup(AwsIamGroupDetails awsIamGroup) {
            this.awsIamGroup = awsIamGroup;
            return this;
        }

        public final AwsIamRoleDetails.Builder getAwsIamRole() {
            return awsIamRole != null ? awsIamRole.toBuilder() : null;
        }

        public final void setAwsIamRole(AwsIamRoleDetails.BuilderImpl awsIamRole) {
            this.awsIamRole = awsIamRole != null ? awsIamRole.build() : null;
        }

        @Override
        public final Builder awsIamRole(AwsIamRoleDetails awsIamRole) {
            this.awsIamRole = awsIamRole;
            return this;
        }

        public final AwsKmsKeyDetails.Builder getAwsKmsKey() {
            return awsKmsKey != null ? awsKmsKey.toBuilder() : null;
        }

        public final void setAwsKmsKey(AwsKmsKeyDetails.BuilderImpl awsKmsKey) {
            this.awsKmsKey = awsKmsKey != null ? awsKmsKey.build() : null;
        }

        @Override
        public final Builder awsKmsKey(AwsKmsKeyDetails awsKmsKey) {
            this.awsKmsKey = awsKmsKey;
            return this;
        }

        public final AwsLambdaFunctionDetails.Builder getAwsLambdaFunction() {
            return awsLambdaFunction != null ? awsLambdaFunction.toBuilder() : null;
        }

        public final void setAwsLambdaFunction(AwsLambdaFunctionDetails.BuilderImpl awsLambdaFunction) {
            this.awsLambdaFunction = awsLambdaFunction != null ? awsLambdaFunction.build() : null;
        }

        @Override
        public final Builder awsLambdaFunction(AwsLambdaFunctionDetails awsLambdaFunction) {
            this.awsLambdaFunction = awsLambdaFunction;
            return this;
        }

        public final AwsLambdaLayerVersionDetails.Builder getAwsLambdaLayerVersion() {
            return awsLambdaLayerVersion != null ? awsLambdaLayerVersion.toBuilder() : null;
        }

        public final void setAwsLambdaLayerVersion(AwsLambdaLayerVersionDetails.BuilderImpl awsLambdaLayerVersion) {
            this.awsLambdaLayerVersion = awsLambdaLayerVersion != null ? awsLambdaLayerVersion.build() : null;
        }

        @Override
        public final Builder awsLambdaLayerVersion(AwsLambdaLayerVersionDetails awsLambdaLayerVersion) {
            this.awsLambdaLayerVersion = awsLambdaLayerVersion;
            return this;
        }

        public final AwsRdsDbInstanceDetails.Builder getAwsRdsDbInstance() {
            return awsRdsDbInstance != null ? awsRdsDbInstance.toBuilder() : null;
        }

        public final void setAwsRdsDbInstance(AwsRdsDbInstanceDetails.BuilderImpl awsRdsDbInstance) {
            this.awsRdsDbInstance = awsRdsDbInstance != null ? awsRdsDbInstance.build() : null;
        }

        @Override
        public final Builder awsRdsDbInstance(AwsRdsDbInstanceDetails awsRdsDbInstance) {
            this.awsRdsDbInstance = awsRdsDbInstance;
            return this;
        }

        public final AwsSnsTopicDetails.Builder getAwsSnsTopic() {
            return awsSnsTopic != null ? awsSnsTopic.toBuilder() : null;
        }

        public final void setAwsSnsTopic(AwsSnsTopicDetails.BuilderImpl awsSnsTopic) {
            this.awsSnsTopic = awsSnsTopic != null ? awsSnsTopic.build() : null;
        }

        @Override
        public final Builder awsSnsTopic(AwsSnsTopicDetails awsSnsTopic) {
            this.awsSnsTopic = awsSnsTopic;
            return this;
        }

        public final AwsSqsQueueDetails.Builder getAwsSqsQueue() {
            return awsSqsQueue != null ? awsSqsQueue.toBuilder() : null;
        }

        public final void setAwsSqsQueue(AwsSqsQueueDetails.BuilderImpl awsSqsQueue) {
            this.awsSqsQueue = awsSqsQueue != null ? awsSqsQueue.build() : null;
        }

        @Override
        public final Builder awsSqsQueue(AwsSqsQueueDetails awsSqsQueue) {
            this.awsSqsQueue = awsSqsQueue;
            return this;
        }

        public final AwsWafWebAclDetails.Builder getAwsWafWebAcl() {
            return awsWafWebAcl != null ? awsWafWebAcl.toBuilder() : null;
        }

        public final void setAwsWafWebAcl(AwsWafWebAclDetails.BuilderImpl awsWafWebAcl) {
            this.awsWafWebAcl = awsWafWebAcl != null ? awsWafWebAcl.build() : null;
        }

        @Override
        public final Builder awsWafWebAcl(AwsWafWebAclDetails awsWafWebAcl) {
            this.awsWafWebAcl = awsWafWebAcl;
            return this;
        }

        public final AwsRdsDbSnapshotDetails.Builder getAwsRdsDbSnapshot() {
            return awsRdsDbSnapshot != null ? awsRdsDbSnapshot.toBuilder() : null;
        }

        public final void setAwsRdsDbSnapshot(AwsRdsDbSnapshotDetails.BuilderImpl awsRdsDbSnapshot) {
            this.awsRdsDbSnapshot = awsRdsDbSnapshot != null ? awsRdsDbSnapshot.build() : null;
        }

        @Override
        public final Builder awsRdsDbSnapshot(AwsRdsDbSnapshotDetails awsRdsDbSnapshot) {
            this.awsRdsDbSnapshot = awsRdsDbSnapshot;
            return this;
        }

        public final AwsRdsDbClusterSnapshotDetails.Builder getAwsRdsDbClusterSnapshot() {
            return awsRdsDbClusterSnapshot != null ? awsRdsDbClusterSnapshot.toBuilder() : null;
        }

        public final void setAwsRdsDbClusterSnapshot(AwsRdsDbClusterSnapshotDetails.BuilderImpl awsRdsDbClusterSnapshot) {
            this.awsRdsDbClusterSnapshot = awsRdsDbClusterSnapshot != null ? awsRdsDbClusterSnapshot.build() : null;
        }

        @Override
        public final Builder awsRdsDbClusterSnapshot(AwsRdsDbClusterSnapshotDetails awsRdsDbClusterSnapshot) {
            this.awsRdsDbClusterSnapshot = awsRdsDbClusterSnapshot;
            return this;
        }

        public final AwsRdsDbClusterDetails.Builder getAwsRdsDbCluster() {
            return awsRdsDbCluster != null ? awsRdsDbCluster.toBuilder() : null;
        }

        public final void setAwsRdsDbCluster(AwsRdsDbClusterDetails.BuilderImpl awsRdsDbCluster) {
            this.awsRdsDbCluster = awsRdsDbCluster != null ? awsRdsDbCluster.build() : null;
        }

        @Override
        public final Builder awsRdsDbCluster(AwsRdsDbClusterDetails awsRdsDbCluster) {
            this.awsRdsDbCluster = awsRdsDbCluster;
            return this;
        }

        public final AwsEcsClusterDetails.Builder getAwsEcsCluster() {
            return awsEcsCluster != null ? awsEcsCluster.toBuilder() : null;
        }

        public final void setAwsEcsCluster(AwsEcsClusterDetails.BuilderImpl awsEcsCluster) {
            this.awsEcsCluster = awsEcsCluster != null ? awsEcsCluster.build() : null;
        }

        @Override
        public final Builder awsEcsCluster(AwsEcsClusterDetails awsEcsCluster) {
            this.awsEcsCluster = awsEcsCluster;
            return this;
        }

        public final AwsEcsContainerDetails.Builder getAwsEcsContainer() {
            return awsEcsContainer != null ? awsEcsContainer.toBuilder() : null;
        }

        public final void setAwsEcsContainer(AwsEcsContainerDetails.BuilderImpl awsEcsContainer) {
            this.awsEcsContainer = awsEcsContainer != null ? awsEcsContainer.build() : null;
        }

        @Override
        public final Builder awsEcsContainer(AwsEcsContainerDetails awsEcsContainer) {
            this.awsEcsContainer = awsEcsContainer;
            return this;
        }

        public final AwsEcsTaskDefinitionDetails.Builder getAwsEcsTaskDefinition() {
            return awsEcsTaskDefinition != null ? awsEcsTaskDefinition.toBuilder() : null;
        }

        public final void setAwsEcsTaskDefinition(AwsEcsTaskDefinitionDetails.BuilderImpl awsEcsTaskDefinition) {
            this.awsEcsTaskDefinition = awsEcsTaskDefinition != null ? awsEcsTaskDefinition.build() : null;
        }

        @Override
        public final Builder awsEcsTaskDefinition(AwsEcsTaskDefinitionDetails awsEcsTaskDefinition) {
            this.awsEcsTaskDefinition = awsEcsTaskDefinition;
            return this;
        }

        public final ContainerDetails.Builder getContainer() {
            return container != null ? container.toBuilder() : null;
        }

        public final void setContainer(ContainerDetails.BuilderImpl container) {
            this.container = container != null ? container.build() : null;
        }

        @Override
        public final Builder container(ContainerDetails container) {
            this.container = container;
            return this;
        }

        public final Map<String, String> getOther() {
            if (other instanceof SdkAutoConstructMap) {
                return null;
            }
            return other;
        }

        public final void setOther(Map<String, String> other) {
            this.other = FieldMapCopier.copy(other);
        }

        @Override
        public final Builder other(Map<String, String> other) {
            this.other = FieldMapCopier.copy(other);
            return this;
        }

        public final AwsRdsEventSubscriptionDetails.Builder getAwsRdsEventSubscription() {
            return awsRdsEventSubscription != null ? awsRdsEventSubscription.toBuilder() : null;
        }

        public final void setAwsRdsEventSubscription(AwsRdsEventSubscriptionDetails.BuilderImpl awsRdsEventSubscription) {
            this.awsRdsEventSubscription = awsRdsEventSubscription != null ? awsRdsEventSubscription.build() : null;
        }

        @Override
        public final Builder awsRdsEventSubscription(AwsRdsEventSubscriptionDetails awsRdsEventSubscription) {
            this.awsRdsEventSubscription = awsRdsEventSubscription;
            return this;
        }

        public final AwsEcsServiceDetails.Builder getAwsEcsService() {
            return awsEcsService != null ? awsEcsService.toBuilder() : null;
        }

        public final void setAwsEcsService(AwsEcsServiceDetails.BuilderImpl awsEcsService) {
            this.awsEcsService = awsEcsService != null ? awsEcsService.build() : null;
        }

        @Override
        public final Builder awsEcsService(AwsEcsServiceDetails awsEcsService) {
            this.awsEcsService = awsEcsService;
            return this;
        }

        public final AwsAutoScalingLaunchConfigurationDetails.Builder getAwsAutoScalingLaunchConfiguration() {
            return awsAutoScalingLaunchConfiguration != null ? awsAutoScalingLaunchConfiguration.toBuilder() : null;
        }

        public final void setAwsAutoScalingLaunchConfiguration(
                AwsAutoScalingLaunchConfigurationDetails.BuilderImpl awsAutoScalingLaunchConfiguration) {
            this.awsAutoScalingLaunchConfiguration = awsAutoScalingLaunchConfiguration != null ? awsAutoScalingLaunchConfiguration
                    .build() : null;
        }

        @Override
        public final Builder awsAutoScalingLaunchConfiguration(
                AwsAutoScalingLaunchConfigurationDetails awsAutoScalingLaunchConfiguration) {
            this.awsAutoScalingLaunchConfiguration = awsAutoScalingLaunchConfiguration;
            return this;
        }

        public final AwsEc2VpnConnectionDetails.Builder getAwsEc2VpnConnection() {
            return awsEc2VpnConnection != null ? awsEc2VpnConnection.toBuilder() : null;
        }

        public final void setAwsEc2VpnConnection(AwsEc2VpnConnectionDetails.BuilderImpl awsEc2VpnConnection) {
            this.awsEc2VpnConnection = awsEc2VpnConnection != null ? awsEc2VpnConnection.build() : null;
        }

        @Override
        public final Builder awsEc2VpnConnection(AwsEc2VpnConnectionDetails awsEc2VpnConnection) {
            this.awsEc2VpnConnection = awsEc2VpnConnection;
            return this;
        }

        public final AwsEcrContainerImageDetails.Builder getAwsEcrContainerImage() {
            return awsEcrContainerImage != null ? awsEcrContainerImage.toBuilder() : null;
        }

        public final void setAwsEcrContainerImage(AwsEcrContainerImageDetails.BuilderImpl awsEcrContainerImage) {
            this.awsEcrContainerImage = awsEcrContainerImage != null ? awsEcrContainerImage.build() : null;
        }

        @Override
        public final Builder awsEcrContainerImage(AwsEcrContainerImageDetails awsEcrContainerImage) {
            this.awsEcrContainerImage = awsEcrContainerImage;
            return this;
        }

        public final AwsOpenSearchServiceDomainDetails.Builder getAwsOpenSearchServiceDomain() {
            return awsOpenSearchServiceDomain != null ? awsOpenSearchServiceDomain.toBuilder() : null;
        }

        public final void setAwsOpenSearchServiceDomain(AwsOpenSearchServiceDomainDetails.BuilderImpl awsOpenSearchServiceDomain) {
            this.awsOpenSearchServiceDomain = awsOpenSearchServiceDomain != null ? awsOpenSearchServiceDomain.build() : null;
        }

        @Override
        public final Builder awsOpenSearchServiceDomain(AwsOpenSearchServiceDomainDetails awsOpenSearchServiceDomain) {
            this.awsOpenSearchServiceDomain = awsOpenSearchServiceDomain;
            return this;
        }

        public final AwsEc2VpcEndpointServiceDetails.Builder getAwsEc2VpcEndpointService() {
            return awsEc2VpcEndpointService != null ? awsEc2VpcEndpointService.toBuilder() : null;
        }

        public final void setAwsEc2VpcEndpointService(AwsEc2VpcEndpointServiceDetails.BuilderImpl awsEc2VpcEndpointService) {
            this.awsEc2VpcEndpointService = awsEc2VpcEndpointService != null ? awsEc2VpcEndpointService.build() : null;
        }

        @Override
        public final Builder awsEc2VpcEndpointService(AwsEc2VpcEndpointServiceDetails awsEc2VpcEndpointService) {
            this.awsEc2VpcEndpointService = awsEc2VpcEndpointService;
            return this;
        }

        public final AwsXrayEncryptionConfigDetails.Builder getAwsXrayEncryptionConfig() {
            return awsXrayEncryptionConfig != null ? awsXrayEncryptionConfig.toBuilder() : null;
        }

        public final void setAwsXrayEncryptionConfig(AwsXrayEncryptionConfigDetails.BuilderImpl awsXrayEncryptionConfig) {
            this.awsXrayEncryptionConfig = awsXrayEncryptionConfig != null ? awsXrayEncryptionConfig.build() : null;
        }

        @Override
        public final Builder awsXrayEncryptionConfig(AwsXrayEncryptionConfigDetails awsXrayEncryptionConfig) {
            this.awsXrayEncryptionConfig = awsXrayEncryptionConfig;
            return this;
        }

        public final AwsWafRateBasedRuleDetails.Builder getAwsWafRateBasedRule() {
            return awsWafRateBasedRule != null ? awsWafRateBasedRule.toBuilder() : null;
        }

        public final void setAwsWafRateBasedRule(AwsWafRateBasedRuleDetails.BuilderImpl awsWafRateBasedRule) {
            this.awsWafRateBasedRule = awsWafRateBasedRule != null ? awsWafRateBasedRule.build() : null;
        }

        @Override
        public final Builder awsWafRateBasedRule(AwsWafRateBasedRuleDetails awsWafRateBasedRule) {
            this.awsWafRateBasedRule = awsWafRateBasedRule;
            return this;
        }

        public final AwsWafRegionalRateBasedRuleDetails.Builder getAwsWafRegionalRateBasedRule() {
            return awsWafRegionalRateBasedRule != null ? awsWafRegionalRateBasedRule.toBuilder() : null;
        }

        public final void setAwsWafRegionalRateBasedRule(
                AwsWafRegionalRateBasedRuleDetails.BuilderImpl awsWafRegionalRateBasedRule) {
            this.awsWafRegionalRateBasedRule = awsWafRegionalRateBasedRule != null ? awsWafRegionalRateBasedRule.build() : null;
        }

        @Override
        public final Builder awsWafRegionalRateBasedRule(AwsWafRegionalRateBasedRuleDetails awsWafRegionalRateBasedRule) {
            this.awsWafRegionalRateBasedRule = awsWafRegionalRateBasedRule;
            return this;
        }

        public final AwsEcrRepositoryDetails.Builder getAwsEcrRepository() {
            return awsEcrRepository != null ? awsEcrRepository.toBuilder() : null;
        }

        public final void setAwsEcrRepository(AwsEcrRepositoryDetails.BuilderImpl awsEcrRepository) {
            this.awsEcrRepository = awsEcrRepository != null ? awsEcrRepository.build() : null;
        }

        @Override
        public final Builder awsEcrRepository(AwsEcrRepositoryDetails awsEcrRepository) {
            this.awsEcrRepository = awsEcrRepository;
            return this;
        }

        public final AwsEksClusterDetails.Builder getAwsEksCluster() {
            return awsEksCluster != null ? awsEksCluster.toBuilder() : null;
        }

        public final void setAwsEksCluster(AwsEksClusterDetails.BuilderImpl awsEksCluster) {
            this.awsEksCluster = awsEksCluster != null ? awsEksCluster.build() : null;
        }

        @Override
        public final Builder awsEksCluster(AwsEksClusterDetails awsEksCluster) {
            this.awsEksCluster = awsEksCluster;
            return this;
        }

        public final AwsNetworkFirewallFirewallPolicyDetails.Builder getAwsNetworkFirewallFirewallPolicy() {
            return awsNetworkFirewallFirewallPolicy != null ? awsNetworkFirewallFirewallPolicy.toBuilder() : null;
        }

        public final void setAwsNetworkFirewallFirewallPolicy(
                AwsNetworkFirewallFirewallPolicyDetails.BuilderImpl awsNetworkFirewallFirewallPolicy) {
            this.awsNetworkFirewallFirewallPolicy = awsNetworkFirewallFirewallPolicy != null ? awsNetworkFirewallFirewallPolicy
                    .build() : null;
        }

        @Override
        public final Builder awsNetworkFirewallFirewallPolicy(
                AwsNetworkFirewallFirewallPolicyDetails awsNetworkFirewallFirewallPolicy) {
            this.awsNetworkFirewallFirewallPolicy = awsNetworkFirewallFirewallPolicy;
            return this;
        }

        public final AwsNetworkFirewallFirewallDetails.Builder getAwsNetworkFirewallFirewall() {
            return awsNetworkFirewallFirewall != null ? awsNetworkFirewallFirewall.toBuilder() : null;
        }

        public final void setAwsNetworkFirewallFirewall(AwsNetworkFirewallFirewallDetails.BuilderImpl awsNetworkFirewallFirewall) {
            this.awsNetworkFirewallFirewall = awsNetworkFirewallFirewall != null ? awsNetworkFirewallFirewall.build() : null;
        }

        @Override
        public final Builder awsNetworkFirewallFirewall(AwsNetworkFirewallFirewallDetails awsNetworkFirewallFirewall) {
            this.awsNetworkFirewallFirewall = awsNetworkFirewallFirewall;
            return this;
        }

        public final AwsNetworkFirewallRuleGroupDetails.Builder getAwsNetworkFirewallRuleGroup() {
            return awsNetworkFirewallRuleGroup != null ? awsNetworkFirewallRuleGroup.toBuilder() : null;
        }

        public final void setAwsNetworkFirewallRuleGroup(
                AwsNetworkFirewallRuleGroupDetails.BuilderImpl awsNetworkFirewallRuleGroup) {
            this.awsNetworkFirewallRuleGroup = awsNetworkFirewallRuleGroup != null ? awsNetworkFirewallRuleGroup.build() : null;
        }

        @Override
        public final Builder awsNetworkFirewallRuleGroup(AwsNetworkFirewallRuleGroupDetails awsNetworkFirewallRuleGroup) {
            this.awsNetworkFirewallRuleGroup = awsNetworkFirewallRuleGroup;
            return this;
        }

        public final AwsRdsDbSecurityGroupDetails.Builder getAwsRdsDbSecurityGroup() {
            return awsRdsDbSecurityGroup != null ? awsRdsDbSecurityGroup.toBuilder() : null;
        }

        public final void setAwsRdsDbSecurityGroup(AwsRdsDbSecurityGroupDetails.BuilderImpl awsRdsDbSecurityGroup) {
            this.awsRdsDbSecurityGroup = awsRdsDbSecurityGroup != null ? awsRdsDbSecurityGroup.build() : null;
        }

        @Override
        public final Builder awsRdsDbSecurityGroup(AwsRdsDbSecurityGroupDetails awsRdsDbSecurityGroup) {
            this.awsRdsDbSecurityGroup = awsRdsDbSecurityGroup;
            return this;
        }

        public final AwsKinesisStreamDetails.Builder getAwsKinesisStream() {
            return awsKinesisStream != null ? awsKinesisStream.toBuilder() : null;
        }

        public final void setAwsKinesisStream(AwsKinesisStreamDetails.BuilderImpl awsKinesisStream) {
            this.awsKinesisStream = awsKinesisStream != null ? awsKinesisStream.build() : null;
        }

        @Override
        public final Builder awsKinesisStream(AwsKinesisStreamDetails awsKinesisStream) {
            this.awsKinesisStream = awsKinesisStream;
            return this;
        }

        public final AwsEc2TransitGatewayDetails.Builder getAwsEc2TransitGateway() {
            return awsEc2TransitGateway != null ? awsEc2TransitGateway.toBuilder() : null;
        }

        public final void setAwsEc2TransitGateway(AwsEc2TransitGatewayDetails.BuilderImpl awsEc2TransitGateway) {
            this.awsEc2TransitGateway = awsEc2TransitGateway != null ? awsEc2TransitGateway.build() : null;
        }

        @Override
        public final Builder awsEc2TransitGateway(AwsEc2TransitGatewayDetails awsEc2TransitGateway) {
            this.awsEc2TransitGateway = awsEc2TransitGateway;
            return this;
        }

        public final AwsEfsAccessPointDetails.Builder getAwsEfsAccessPoint() {
            return awsEfsAccessPoint != null ? awsEfsAccessPoint.toBuilder() : null;
        }

        public final void setAwsEfsAccessPoint(AwsEfsAccessPointDetails.BuilderImpl awsEfsAccessPoint) {
            this.awsEfsAccessPoint = awsEfsAccessPoint != null ? awsEfsAccessPoint.build() : null;
        }

        @Override
        public final Builder awsEfsAccessPoint(AwsEfsAccessPointDetails awsEfsAccessPoint) {
            this.awsEfsAccessPoint = awsEfsAccessPoint;
            return this;
        }

        public final AwsCloudFormationStackDetails.Builder getAwsCloudFormationStack() {
            return awsCloudFormationStack != null ? awsCloudFormationStack.toBuilder() : null;
        }

        public final void setAwsCloudFormationStack(AwsCloudFormationStackDetails.BuilderImpl awsCloudFormationStack) {
            this.awsCloudFormationStack = awsCloudFormationStack != null ? awsCloudFormationStack.build() : null;
        }

        @Override
        public final Builder awsCloudFormationStack(AwsCloudFormationStackDetails awsCloudFormationStack) {
            this.awsCloudFormationStack = awsCloudFormationStack;
            return this;
        }

        public final AwsCloudWatchAlarmDetails.Builder getAwsCloudWatchAlarm() {
            return awsCloudWatchAlarm != null ? awsCloudWatchAlarm.toBuilder() : null;
        }

        public final void setAwsCloudWatchAlarm(AwsCloudWatchAlarmDetails.BuilderImpl awsCloudWatchAlarm) {
            this.awsCloudWatchAlarm = awsCloudWatchAlarm != null ? awsCloudWatchAlarm.build() : null;
        }

        @Override
        public final Builder awsCloudWatchAlarm(AwsCloudWatchAlarmDetails awsCloudWatchAlarm) {
            this.awsCloudWatchAlarm = awsCloudWatchAlarm;
            return this;
        }

        public final AwsEc2VpcPeeringConnectionDetails.Builder getAwsEc2VpcPeeringConnection() {
            return awsEc2VpcPeeringConnection != null ? awsEc2VpcPeeringConnection.toBuilder() : null;
        }

        public final void setAwsEc2VpcPeeringConnection(AwsEc2VpcPeeringConnectionDetails.BuilderImpl awsEc2VpcPeeringConnection) {
            this.awsEc2VpcPeeringConnection = awsEc2VpcPeeringConnection != null ? awsEc2VpcPeeringConnection.build() : null;
        }

        @Override
        public final Builder awsEc2VpcPeeringConnection(AwsEc2VpcPeeringConnectionDetails awsEc2VpcPeeringConnection) {
            this.awsEc2VpcPeeringConnection = awsEc2VpcPeeringConnection;
            return this;
        }

        public final AwsWafRegionalRuleGroupDetails.Builder getAwsWafRegionalRuleGroup() {
            return awsWafRegionalRuleGroup != null ? awsWafRegionalRuleGroup.toBuilder() : null;
        }

        public final void setAwsWafRegionalRuleGroup(AwsWafRegionalRuleGroupDetails.BuilderImpl awsWafRegionalRuleGroup) {
            this.awsWafRegionalRuleGroup = awsWafRegionalRuleGroup != null ? awsWafRegionalRuleGroup.build() : null;
        }

        @Override
        public final Builder awsWafRegionalRuleGroup(AwsWafRegionalRuleGroupDetails awsWafRegionalRuleGroup) {
            this.awsWafRegionalRuleGroup = awsWafRegionalRuleGroup;
            return this;
        }

        public final AwsWafRegionalRuleDetails.Builder getAwsWafRegionalRule() {
            return awsWafRegionalRule != null ? awsWafRegionalRule.toBuilder() : null;
        }

        public final void setAwsWafRegionalRule(AwsWafRegionalRuleDetails.BuilderImpl awsWafRegionalRule) {
            this.awsWafRegionalRule = awsWafRegionalRule != null ? awsWafRegionalRule.build() : null;
        }

        @Override
        public final Builder awsWafRegionalRule(AwsWafRegionalRuleDetails awsWafRegionalRule) {
            this.awsWafRegionalRule = awsWafRegionalRule;
            return this;
        }

        public final AwsWafRegionalWebAclDetails.Builder getAwsWafRegionalWebAcl() {
            return awsWafRegionalWebAcl != null ? awsWafRegionalWebAcl.toBuilder() : null;
        }

        public final void setAwsWafRegionalWebAcl(AwsWafRegionalWebAclDetails.BuilderImpl awsWafRegionalWebAcl) {
            this.awsWafRegionalWebAcl = awsWafRegionalWebAcl != null ? awsWafRegionalWebAcl.build() : null;
        }

        @Override
        public final Builder awsWafRegionalWebAcl(AwsWafRegionalWebAclDetails awsWafRegionalWebAcl) {
            this.awsWafRegionalWebAcl = awsWafRegionalWebAcl;
            return this;
        }

        public final AwsWafRuleDetails.Builder getAwsWafRule() {
            return awsWafRule != null ? awsWafRule.toBuilder() : null;
        }

        public final void setAwsWafRule(AwsWafRuleDetails.BuilderImpl awsWafRule) {
            this.awsWafRule = awsWafRule != null ? awsWafRule.build() : null;
        }

        @Override
        public final Builder awsWafRule(AwsWafRuleDetails awsWafRule) {
            this.awsWafRule = awsWafRule;
            return this;
        }

        public final AwsWafRuleGroupDetails.Builder getAwsWafRuleGroup() {
            return awsWafRuleGroup != null ? awsWafRuleGroup.toBuilder() : null;
        }

        public final void setAwsWafRuleGroup(AwsWafRuleGroupDetails.BuilderImpl awsWafRuleGroup) {
            this.awsWafRuleGroup = awsWafRuleGroup != null ? awsWafRuleGroup.build() : null;
        }

        @Override
        public final Builder awsWafRuleGroup(AwsWafRuleGroupDetails awsWafRuleGroup) {
            this.awsWafRuleGroup = awsWafRuleGroup;
            return this;
        }

        public final AwsEcsTaskDetails.Builder getAwsEcsTask() {
            return awsEcsTask != null ? awsEcsTask.toBuilder() : null;
        }

        public final void setAwsEcsTask(AwsEcsTaskDetails.BuilderImpl awsEcsTask) {
            this.awsEcsTask = awsEcsTask != null ? awsEcsTask.build() : null;
        }

        @Override
        public final Builder awsEcsTask(AwsEcsTaskDetails awsEcsTask) {
            this.awsEcsTask = awsEcsTask;
            return this;
        }

        public final AwsBackupBackupVaultDetails.Builder getAwsBackupBackupVault() {
            return awsBackupBackupVault != null ? awsBackupBackupVault.toBuilder() : null;
        }

        public final void setAwsBackupBackupVault(AwsBackupBackupVaultDetails.BuilderImpl awsBackupBackupVault) {
            this.awsBackupBackupVault = awsBackupBackupVault != null ? awsBackupBackupVault.build() : null;
        }

        @Override
        public final Builder awsBackupBackupVault(AwsBackupBackupVaultDetails awsBackupBackupVault) {
            this.awsBackupBackupVault = awsBackupBackupVault;
            return this;
        }

        public final AwsBackupBackupPlanDetails.Builder getAwsBackupBackupPlan() {
            return awsBackupBackupPlan != null ? awsBackupBackupPlan.toBuilder() : null;
        }

        public final void setAwsBackupBackupPlan(AwsBackupBackupPlanDetails.BuilderImpl awsBackupBackupPlan) {
            this.awsBackupBackupPlan = awsBackupBackupPlan != null ? awsBackupBackupPlan.build() : null;
        }

        @Override
        public final Builder awsBackupBackupPlan(AwsBackupBackupPlanDetails awsBackupBackupPlan) {
            this.awsBackupBackupPlan = awsBackupBackupPlan;
            return this;
        }

        public final AwsBackupRecoveryPointDetails.Builder getAwsBackupRecoveryPoint() {
            return awsBackupRecoveryPoint != null ? awsBackupRecoveryPoint.toBuilder() : null;
        }

        public final void setAwsBackupRecoveryPoint(AwsBackupRecoveryPointDetails.BuilderImpl awsBackupRecoveryPoint) {
            this.awsBackupRecoveryPoint = awsBackupRecoveryPoint != null ? awsBackupRecoveryPoint.build() : null;
        }

        @Override
        public final Builder awsBackupRecoveryPoint(AwsBackupRecoveryPointDetails awsBackupRecoveryPoint) {
            this.awsBackupRecoveryPoint = awsBackupRecoveryPoint;
            return this;
        }

        public final AwsEc2LaunchTemplateDetails.Builder getAwsEc2LaunchTemplate() {
            return awsEc2LaunchTemplate != null ? awsEc2LaunchTemplate.toBuilder() : null;
        }

        public final void setAwsEc2LaunchTemplate(AwsEc2LaunchTemplateDetails.BuilderImpl awsEc2LaunchTemplate) {
            this.awsEc2LaunchTemplate = awsEc2LaunchTemplate != null ? awsEc2LaunchTemplate.build() : null;
        }

        @Override
        public final Builder awsEc2LaunchTemplate(AwsEc2LaunchTemplateDetails awsEc2LaunchTemplate) {
            this.awsEc2LaunchTemplate = awsEc2LaunchTemplate;
            return this;
        }

        public final AwsSageMakerNotebookInstanceDetails.Builder getAwsSageMakerNotebookInstance() {
            return awsSageMakerNotebookInstance != null ? awsSageMakerNotebookInstance.toBuilder() : null;
        }

        public final void setAwsSageMakerNotebookInstance(
                AwsSageMakerNotebookInstanceDetails.BuilderImpl awsSageMakerNotebookInstance) {
            this.awsSageMakerNotebookInstance = awsSageMakerNotebookInstance != null ? awsSageMakerNotebookInstance.build()
                    : null;
        }

        @Override
        public final Builder awsSageMakerNotebookInstance(AwsSageMakerNotebookInstanceDetails awsSageMakerNotebookInstance) {
            this.awsSageMakerNotebookInstance = awsSageMakerNotebookInstance;
            return this;
        }

        public final AwsWafv2WebAclDetails.Builder getAwsWafv2WebAcl() {
            return awsWafv2WebAcl != null ? awsWafv2WebAcl.toBuilder() : null;
        }

        public final void setAwsWafv2WebAcl(AwsWafv2WebAclDetails.BuilderImpl awsWafv2WebAcl) {
            this.awsWafv2WebAcl = awsWafv2WebAcl != null ? awsWafv2WebAcl.build() : null;
        }

        @Override
        public final Builder awsWafv2WebAcl(AwsWafv2WebAclDetails awsWafv2WebAcl) {
            this.awsWafv2WebAcl = awsWafv2WebAcl;
            return this;
        }

        public final AwsWafv2RuleGroupDetails.Builder getAwsWafv2RuleGroup() {
            return awsWafv2RuleGroup != null ? awsWafv2RuleGroup.toBuilder() : null;
        }

        public final void setAwsWafv2RuleGroup(AwsWafv2RuleGroupDetails.BuilderImpl awsWafv2RuleGroup) {
            this.awsWafv2RuleGroup = awsWafv2RuleGroup != null ? awsWafv2RuleGroup.build() : null;
        }

        @Override
        public final Builder awsWafv2RuleGroup(AwsWafv2RuleGroupDetails awsWafv2RuleGroup) {
            this.awsWafv2RuleGroup = awsWafv2RuleGroup;
            return this;
        }

        public final AwsEc2RouteTableDetails.Builder getAwsEc2RouteTable() {
            return awsEc2RouteTable != null ? awsEc2RouteTable.toBuilder() : null;
        }

        public final void setAwsEc2RouteTable(AwsEc2RouteTableDetails.BuilderImpl awsEc2RouteTable) {
            this.awsEc2RouteTable = awsEc2RouteTable != null ? awsEc2RouteTable.build() : null;
        }

        @Override
        public final Builder awsEc2RouteTable(AwsEc2RouteTableDetails awsEc2RouteTable) {
            this.awsEc2RouteTable = awsEc2RouteTable;
            return this;
        }

        @Override
        public ResourceDetails build() {
            return new ResourceDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
