/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchDisableStandardsRequest extends SecurityHubRequest implements
        ToCopyableBuilder<BatchDisableStandardsRequest.Builder, BatchDisableStandardsRequest> {
    private static final SdkField<List<String>> STANDARDS_SUBSCRIPTION_ARNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("StandardsSubscriptionArns")
            .getter(getter(BatchDisableStandardsRequest::standardsSubscriptionArns))
            .setter(setter(Builder::standardsSubscriptionArns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StandardsSubscriptionArns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(STANDARDS_SUBSCRIPTION_ARNS_FIELD));

    private final List<String> standardsSubscriptionArns;

    private BatchDisableStandardsRequest(BuilderImpl builder) {
        super(builder);
        this.standardsSubscriptionArns = builder.standardsSubscriptionArns;
    }

    /**
     * For responses, this returns true if the service returned a value for the StandardsSubscriptionArns property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasStandardsSubscriptionArns() {
        return standardsSubscriptionArns != null && !(standardsSubscriptionArns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The ARNs of the standards subscriptions to disable.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStandardsSubscriptionArns} method.
     * </p>
     * 
     * @return The ARNs of the standards subscriptions to disable.
     */
    public final List<String> standardsSubscriptionArns() {
        return standardsSubscriptionArns;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasStandardsSubscriptionArns() ? standardsSubscriptionArns() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchDisableStandardsRequest)) {
            return false;
        }
        BatchDisableStandardsRequest other = (BatchDisableStandardsRequest) obj;
        return hasStandardsSubscriptionArns() == other.hasStandardsSubscriptionArns()
                && Objects.equals(standardsSubscriptionArns(), other.standardsSubscriptionArns());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchDisableStandardsRequest")
                .add("StandardsSubscriptionArns", hasStandardsSubscriptionArns() ? standardsSubscriptionArns() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StandardsSubscriptionArns":
            return Optional.ofNullable(clazz.cast(standardsSubscriptionArns()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchDisableStandardsRequest, T> g) {
        return obj -> g.apply((BatchDisableStandardsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SecurityHubRequest.Builder, SdkPojo, CopyableBuilder<Builder, BatchDisableStandardsRequest> {
        /**
         * <p>
         * The ARNs of the standards subscriptions to disable.
         * </p>
         * 
         * @param standardsSubscriptionArns
         *        The ARNs of the standards subscriptions to disable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder standardsSubscriptionArns(Collection<String> standardsSubscriptionArns);

        /**
         * <p>
         * The ARNs of the standards subscriptions to disable.
         * </p>
         * 
         * @param standardsSubscriptionArns
         *        The ARNs of the standards subscriptions to disable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder standardsSubscriptionArns(String... standardsSubscriptionArns);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SecurityHubRequest.BuilderImpl implements Builder {
        private List<String> standardsSubscriptionArns = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchDisableStandardsRequest model) {
            super(model);
            standardsSubscriptionArns(model.standardsSubscriptionArns);
        }

        public final Collection<String> getStandardsSubscriptionArns() {
            if (standardsSubscriptionArns instanceof SdkAutoConstructList) {
                return null;
            }
            return standardsSubscriptionArns;
        }

        public final void setStandardsSubscriptionArns(Collection<String> standardsSubscriptionArns) {
            this.standardsSubscriptionArns = StandardsSubscriptionArnsCopier.copy(standardsSubscriptionArns);
        }

        @Override
        public final Builder standardsSubscriptionArns(Collection<String> standardsSubscriptionArns) {
            this.standardsSubscriptionArns = StandardsSubscriptionArnsCopier.copy(standardsSubscriptionArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder standardsSubscriptionArns(String... standardsSubscriptionArns) {
            standardsSubscriptionArns(Arrays.asList(standardsSubscriptionArns));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchDisableStandardsRequest build() {
            return new BatchDisableStandardsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
