/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The target account, organizational unit, or the root that is associated with an Security Hub configuration. The
 * configuration can be a configuration policy or self-managed behavior.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Target implements SdkPojo, Serializable, ToCopyableBuilder<Target.Builder, Target> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AccountId").getter(getter(Target::accountId)).setter(setter(Builder::accountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountId").build()).build();

    private static final SdkField<String> ORGANIZATIONAL_UNIT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OrganizationalUnitId").getter(getter(Target::organizationalUnitId))
            .setter(setter(Builder::organizationalUnitId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrganizationalUnitId").build())
            .build();

    private static final SdkField<String> ROOT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("RootId")
            .getter(getter(Target::rootId)).setter(setter(Builder::rootId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RootId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD,
            ORGANIZATIONAL_UNIT_ID_FIELD, ROOT_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String accountId;

    private final String organizationalUnitId;

    private final String rootId;

    private final Type type;

    private Target(BuilderImpl builder) {
        this.accountId = builder.accountId;
        this.organizationalUnitId = builder.organizationalUnitId;
        this.rootId = builder.rootId;
        this.type = builder.type;
    }

    /**
     * <p>
     * The Amazon Web Services account ID of the target account.
     * </p>
     * 
     * @return The Amazon Web Services account ID of the target account.
     */
    public final String accountId() {
        return accountId;
    }

    /**
     * <p>
     * The organizational unit ID of the target organizational unit.
     * </p>
     * 
     * @return The organizational unit ID of the target organizational unit.
     */
    public final String organizationalUnitId() {
        return organizationalUnitId;
    }

    /**
     * <p>
     * The ID of the organization root.
     * </p>
     * 
     * @return The ID of the organization root.
     */
    public final String rootId() {
        return rootId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(accountId());
        hashCode = 31 * hashCode + Objects.hashCode(organizationalUnitId());
        hashCode = 31 * hashCode + Objects.hashCode(rootId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Target)) {
            return false;
        }
        Target other = (Target) obj;
        return Objects.equals(accountId(), other.accountId())
                && Objects.equals(organizationalUnitId(), other.organizationalUnitId())
                && Objects.equals(rootId(), other.rootId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Target").add("AccountId", accountId()).add("OrganizationalUnitId", organizationalUnitId())
                .add("RootId", rootId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AccountId":
            return Optional.ofNullable(clazz.cast(accountId()));
        case "OrganizationalUnitId":
            return Optional.ofNullable(clazz.cast(organizationalUnitId()));
        case "RootId":
            return Optional.ofNullable(clazz.cast(rootId()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #accountId()} initialized to the given value.
     *
     * <p>
     * The Amazon Web Services account ID of the target account.
     * </p>
     * 
     * @param accountId
     *        The Amazon Web Services account ID of the target account.
     */
    public static Target fromAccountId(String accountId) {
        return builder().accountId(accountId).build();
    }

    /**
     * Create an instance of this class with {@link #organizationalUnitId()} initialized to the given value.
     *
     * <p>
     * The organizational unit ID of the target organizational unit.
     * </p>
     * 
     * @param organizationalUnitId
     *        The organizational unit ID of the target organizational unit.
     */
    public static Target fromOrganizationalUnitId(String organizationalUnitId) {
        return builder().organizationalUnitId(organizationalUnitId).build();
    }

    /**
     * Create an instance of this class with {@link #rootId()} initialized to the given value.
     *
     * <p>
     * The ID of the organization root.
     * </p>
     * 
     * @param rootId
     *        The ID of the organization root.
     */
    public static Target fromRootId(String rootId) {
        return builder().rootId(rootId).build();
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Target, T> g) {
        return obj -> g.apply((Target) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Target> {
        /**
         * <p>
         * The Amazon Web Services account ID of the target account.
         * </p>
         * 
         * @param accountId
         *        The Amazon Web Services account ID of the target account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(String accountId);

        /**
         * <p>
         * The organizational unit ID of the target organizational unit.
         * </p>
         * 
         * @param organizationalUnitId
         *        The organizational unit ID of the target organizational unit.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder organizationalUnitId(String organizationalUnitId);

        /**
         * <p>
         * The ID of the organization root.
         * </p>
         * 
         * @param rootId
         *        The ID of the organization root.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rootId(String rootId);
    }

    static final class BuilderImpl implements Builder {
        private String accountId;

        private String organizationalUnitId;

        private String rootId;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(Target model) {
            accountId(model.accountId);
            organizationalUnitId(model.organizationalUnitId);
            rootId(model.rootId);
        }

        public final String getAccountId() {
            return accountId;
        }

        public final void setAccountId(String accountId) {
            Object oldValue = this.accountId;
            this.accountId = accountId;
            handleUnionValueChange(Type.ACCOUNT_ID, oldValue, this.accountId);
        }

        @Override
        public final Builder accountId(String accountId) {
            Object oldValue = this.accountId;
            this.accountId = accountId;
            handleUnionValueChange(Type.ACCOUNT_ID, oldValue, this.accountId);
            return this;
        }

        public final String getOrganizationalUnitId() {
            return organizationalUnitId;
        }

        public final void setOrganizationalUnitId(String organizationalUnitId) {
            Object oldValue = this.organizationalUnitId;
            this.organizationalUnitId = organizationalUnitId;
            handleUnionValueChange(Type.ORGANIZATIONAL_UNIT_ID, oldValue, this.organizationalUnitId);
        }

        @Override
        public final Builder organizationalUnitId(String organizationalUnitId) {
            Object oldValue = this.organizationalUnitId;
            this.organizationalUnitId = organizationalUnitId;
            handleUnionValueChange(Type.ORGANIZATIONAL_UNIT_ID, oldValue, this.organizationalUnitId);
            return this;
        }

        public final String getRootId() {
            return rootId;
        }

        public final void setRootId(String rootId) {
            Object oldValue = this.rootId;
            this.rootId = rootId;
            handleUnionValueChange(Type.ROOT_ID, oldValue, this.rootId);
        }

        @Override
        public final Builder rootId(String rootId) {
            Object oldValue = this.rootId;
            this.rootId = rootId;
            handleUnionValueChange(Type.ROOT_ID, oldValue, this.rootId);
            return this;
        }

        @Override
        public Target build() {
            return new Target(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see Target#type()
     */
    public enum Type {
        ACCOUNT_ID,

        ORGANIZATIONAL_UNIT_ID,

        ROOT_ID,

        UNKNOWN_TO_SDK_VERSION
    }
}
