/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Options for filtering the <code>ListConfigurationPolicyAssociations</code> response. You can filter by the Amazon
 * Resource Name (ARN) or universally unique identifier (UUID) of a configuration policy, <code>AssociationType</code>,
 * or <code>AssociationStatus</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssociationFilters implements SdkPojo, Serializable,
        ToCopyableBuilder<AssociationFilters.Builder, AssociationFilters> {
    private static final SdkField<String> CONFIGURATION_POLICY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConfigurationPolicyId").getter(getter(AssociationFilters::configurationPolicyId))
            .setter(setter(Builder::configurationPolicyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationPolicyId").build())
            .build();

    private static final SdkField<String> ASSOCIATION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AssociationType").getter(getter(AssociationFilters::associationTypeAsString))
            .setter(setter(Builder::associationType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociationType").build()).build();

    private static final SdkField<String> ASSOCIATION_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AssociationStatus").getter(getter(AssociationFilters::associationStatusAsString))
            .setter(setter(Builder::associationStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociationStatus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIGURATION_POLICY_ID_FIELD,
            ASSOCIATION_TYPE_FIELD, ASSOCIATION_STATUS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String configurationPolicyId;

    private final String associationType;

    private final String associationStatus;

    private AssociationFilters(BuilderImpl builder) {
        this.configurationPolicyId = builder.configurationPolicyId;
        this.associationType = builder.associationType;
        this.associationStatus = builder.associationStatus;
    }

    /**
     * <p>
     * The ARN or UUID of the configuration policy.
     * </p>
     * 
     * @return The ARN or UUID of the configuration policy.
     */
    public final String configurationPolicyId() {
        return configurationPolicyId;
    }

    /**
     * <p>
     * Indicates whether the association between a target and a configuration was directly applied by the Security Hub
     * delegated administrator or inherited from a parent.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #associationType}
     * will return {@link AssociationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #associationTypeAsString}.
     * </p>
     * 
     * @return Indicates whether the association between a target and a configuration was directly applied by the
     *         Security Hub delegated administrator or inherited from a parent.
     * @see AssociationType
     */
    public final AssociationType associationType() {
        return AssociationType.fromValue(associationType);
    }

    /**
     * <p>
     * Indicates whether the association between a target and a configuration was directly applied by the Security Hub
     * delegated administrator or inherited from a parent.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #associationType}
     * will return {@link AssociationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #associationTypeAsString}.
     * </p>
     * 
     * @return Indicates whether the association between a target and a configuration was directly applied by the
     *         Security Hub delegated administrator or inherited from a parent.
     * @see AssociationType
     */
    public final String associationTypeAsString() {
        return associationType;
    }

    /**
     * <p>
     * The current status of the association between a target and a configuration policy.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #associationStatus}
     * will return {@link ConfigurationPolicyAssociationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #associationStatusAsString}.
     * </p>
     * 
     * @return The current status of the association between a target and a configuration policy.
     * @see ConfigurationPolicyAssociationStatus
     */
    public final ConfigurationPolicyAssociationStatus associationStatus() {
        return ConfigurationPolicyAssociationStatus.fromValue(associationStatus);
    }

    /**
     * <p>
     * The current status of the association between a target and a configuration policy.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #associationStatus}
     * will return {@link ConfigurationPolicyAssociationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #associationStatusAsString}.
     * </p>
     * 
     * @return The current status of the association between a target and a configuration policy.
     * @see ConfigurationPolicyAssociationStatus
     */
    public final String associationStatusAsString() {
        return associationStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(configurationPolicyId());
        hashCode = 31 * hashCode + Objects.hashCode(associationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(associationStatusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociationFilters)) {
            return false;
        }
        AssociationFilters other = (AssociationFilters) obj;
        return Objects.equals(configurationPolicyId(), other.configurationPolicyId())
                && Objects.equals(associationTypeAsString(), other.associationTypeAsString())
                && Objects.equals(associationStatusAsString(), other.associationStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AssociationFilters").add("ConfigurationPolicyId", configurationPolicyId())
                .add("AssociationType", associationTypeAsString()).add("AssociationStatus", associationStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConfigurationPolicyId":
            return Optional.ofNullable(clazz.cast(configurationPolicyId()));
        case "AssociationType":
            return Optional.ofNullable(clazz.cast(associationTypeAsString()));
        case "AssociationStatus":
            return Optional.ofNullable(clazz.cast(associationStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AssociationFilters, T> g) {
        return obj -> g.apply((AssociationFilters) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AssociationFilters> {
        /**
         * <p>
         * The ARN or UUID of the configuration policy.
         * </p>
         * 
         * @param configurationPolicyId
         *        The ARN or UUID of the configuration policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationPolicyId(String configurationPolicyId);

        /**
         * <p>
         * Indicates whether the association between a target and a configuration was directly applied by the Security
         * Hub delegated administrator or inherited from a parent.
         * </p>
         * 
         * @param associationType
         *        Indicates whether the association between a target and a configuration was directly applied by the
         *        Security Hub delegated administrator or inherited from a parent.
         * @see AssociationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AssociationType
         */
        Builder associationType(String associationType);

        /**
         * <p>
         * Indicates whether the association between a target and a configuration was directly applied by the Security
         * Hub delegated administrator or inherited from a parent.
         * </p>
         * 
         * @param associationType
         *        Indicates whether the association between a target and a configuration was directly applied by the
         *        Security Hub delegated administrator or inherited from a parent.
         * @see AssociationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AssociationType
         */
        Builder associationType(AssociationType associationType);

        /**
         * <p>
         * The current status of the association between a target and a configuration policy.
         * </p>
         * 
         * @param associationStatus
         *        The current status of the association between a target and a configuration policy.
         * @see ConfigurationPolicyAssociationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConfigurationPolicyAssociationStatus
         */
        Builder associationStatus(String associationStatus);

        /**
         * <p>
         * The current status of the association between a target and a configuration policy.
         * </p>
         * 
         * @param associationStatus
         *        The current status of the association between a target and a configuration policy.
         * @see ConfigurationPolicyAssociationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConfigurationPolicyAssociationStatus
         */
        Builder associationStatus(ConfigurationPolicyAssociationStatus associationStatus);
    }

    static final class BuilderImpl implements Builder {
        private String configurationPolicyId;

        private String associationType;

        private String associationStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociationFilters model) {
            configurationPolicyId(model.configurationPolicyId);
            associationType(model.associationType);
            associationStatus(model.associationStatus);
        }

        public final String getConfigurationPolicyId() {
            return configurationPolicyId;
        }

        public final void setConfigurationPolicyId(String configurationPolicyId) {
            this.configurationPolicyId = configurationPolicyId;
        }

        @Override
        public final Builder configurationPolicyId(String configurationPolicyId) {
            this.configurationPolicyId = configurationPolicyId;
            return this;
        }

        public final String getAssociationType() {
            return associationType;
        }

        public final void setAssociationType(String associationType) {
            this.associationType = associationType;
        }

        @Override
        public final Builder associationType(String associationType) {
            this.associationType = associationType;
            return this;
        }

        @Override
        public final Builder associationType(AssociationType associationType) {
            this.associationType(associationType == null ? null : associationType.toString());
            return this;
        }

        public final String getAssociationStatus() {
            return associationStatus;
        }

        public final void setAssociationStatus(String associationStatus) {
            this.associationStatus = associationStatus;
        }

        @Override
        public final Builder associationStatus(String associationStatus) {
            this.associationStatus = associationStatus;
            return this;
        }

        @Override
        public final Builder associationStatus(ConfigurationPolicyAssociationStatus associationStatus) {
            this.associationStatus(associationStatus == null ? null : associationStatus.toString());
            return this;
        }

        @Override
        public AssociationFilters build() {
            return new AssociationFilters(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
