/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The criteria that determine which findings a rule applies to.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AutomationRulesFindingFilters implements SdkPojo, Serializable,
        ToCopyableBuilder<AutomationRulesFindingFilters.Builder, AutomationRulesFindingFilters> {
    private static final SdkField<List<StringFilter>> PRODUCT_ARN_FIELD = SdkField
            .<List<StringFilter>> builder(MarshallingType.LIST)
            .memberName("ProductArn")
            .getter(getter(AutomationRulesFindingFilters::productArn))
            .setter(setter(Builder::productArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductArn").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StringFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(StringFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<StringFilter>> AWS_ACCOUNT_ID_FIELD = SdkField
            .<List<StringFilter>> builder(MarshallingType.LIST)
            .memberName("AwsAccountId")
            .getter(getter(AutomationRulesFindingFilters::awsAccountId))
            .setter(setter(Builder::awsAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsAccountId").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StringFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(StringFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<StringFilter>> ID_FIELD = SdkField
            .<List<StringFilter>> builder(MarshallingType.LIST)
            .memberName("Id")
            .getter(getter(AutomationRulesFindingFilters::id))
            .setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StringFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(StringFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<StringFilter>> GENERATOR_ID_FIELD = SdkField
            .<List<StringFilter>> builder(MarshallingType.LIST)
            .memberName("GeneratorId")
            .getter(getter(AutomationRulesFindingFilters::generatorId))
            .setter(setter(Builder::generatorId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GeneratorId").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StringFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(StringFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<StringFilter>> TYPE_FIELD = SdkField
            .<List<StringFilter>> builder(MarshallingType.LIST)
            .memberName("Type")
            .getter(getter(AutomationRulesFindingFilters::type))
            .setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StringFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(StringFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<DateFilter>> FIRST_OBSERVED_AT_FIELD = SdkField
            .<List<DateFilter>> builder(MarshallingType.LIST)
            .memberName("FirstObservedAt")
            .getter(getter(AutomationRulesFindingFilters::firstObservedAt))
            .setter(setter(Builder::firstObservedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirstObservedAt").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DateFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(DateFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<DateFilter>> LAST_OBSERVED_AT_FIELD = SdkField
            .<List<DateFilter>> builder(MarshallingType.LIST)
            .memberName("LastObservedAt")
            .getter(getter(AutomationRulesFindingFilters::lastObservedAt))
            .setter(setter(Builder::lastObservedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastObservedAt").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DateFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(DateFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<DateFilter>> CREATED_AT_FIELD = SdkField
            .<List<DateFilter>> builder(MarshallingType.LIST)
            .memberName("CreatedAt")
            .getter(getter(AutomationRulesFindingFilters::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DateFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(DateFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<DateFilter>> UPDATED_AT_FIELD = SdkField
            .<List<DateFilter>> builder(MarshallingType.LIST)
            .memberName("UpdatedAt")
            .getter(getter(AutomationRulesFindingFilters::updatedAt))
            .setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdatedAt").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DateFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(DateFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<NumberFilter>> CONFIDENCE_FIELD = SdkField
            .<List<NumberFilter>> builder(MarshallingType.LIST)
            .memberName("Confidence")
            .getter(getter(AutomationRulesFindingFilters::confidence))
            .setter(setter(Builder::confidence))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Confidence").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<NumberFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(NumberFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<NumberFilter>> CRITICALITY_FIELD = SdkField
            .<List<NumberFilter>> builder(MarshallingType.LIST)
            .memberName("Criticality")
            .getter(getter(AutomationRulesFindingFilters::criticality))
            .setter(setter(Builder::criticality))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Criticality").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<NumberFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(NumberFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<StringFilter>> TITLE_FIELD = SdkField
            .<List<StringFilter>> builder(MarshallingType.LIST)
            .memberName("Title")
            .getter(getter(AutomationRulesFindingFilters::title))
            .setter(setter(Builder::title))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Title").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StringFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(StringFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<StringFilter>> DESCRIPTION_FIELD = SdkField
            .<List<StringFilter>> builder(MarshallingType.LIST)
            .memberName("Description")
            .getter(getter(AutomationRulesFindingFilters::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StringFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(StringFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<StringFilter>> SOURCE_URL_FIELD = SdkField
            .<List<StringFilter>> builder(MarshallingType.LIST)
            .memberName("SourceUrl")
            .getter(getter(AutomationRulesFindingFilters::sourceUrl))
            .setter(setter(Builder::sourceUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceUrl").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StringFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(StringFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<StringFilter>> PRODUCT_NAME_FIELD = SdkField
            .<List<StringFilter>> builder(MarshallingType.LIST)
            .memberName("ProductName")
            .getter(getter(AutomationRulesFindingFilters::productName))
            .setter(setter(Builder::productName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductName").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StringFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(StringFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<StringFilter>> COMPANY_NAME_FIELD = SdkField
            .<List<StringFilter>> builder(MarshallingType.LIST)
            .memberName("CompanyName")
            .getter(getter(AutomationRulesFindingFilters::companyName))
            .setter(setter(Builder::companyName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompanyName").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StringFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(StringFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<StringFilter>> SEVERITY_LABEL_FIELD = SdkField
            .<List<StringFilter>> builder(MarshallingType.LIST)
            .memberName("SeverityLabel")
            .getter(getter(AutomationRulesFindingFilters::severityLabel))
            .setter(setter(Builder::severityLabel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SeverityLabel").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StringFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(StringFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<StringFilter>> RESOURCE_TYPE_FIELD = SdkField
            .<List<StringFilter>> builder(MarshallingType.LIST)
            .memberName("ResourceType")
            .getter(getter(AutomationRulesFindingFilters::resourceType))
            .setter(setter(Builder::resourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StringFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(StringFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<StringFilter>> RESOURCE_ID_FIELD = SdkField
            .<List<StringFilter>> builder(MarshallingType.LIST)
            .memberName("ResourceId")
            .getter(getter(AutomationRulesFindingFilters::resourceId))
            .setter(setter(Builder::resourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceId").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StringFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(StringFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<StringFilter>> RESOURCE_PARTITION_FIELD = SdkField
            .<List<StringFilter>> builder(MarshallingType.LIST)
            .memberName("ResourcePartition")
            .getter(getter(AutomationRulesFindingFilters::resourcePartition))
            .setter(setter(Builder::resourcePartition))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourcePartition").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StringFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(StringFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<StringFilter>> RESOURCE_REGION_FIELD = SdkField
            .<List<StringFilter>> builder(MarshallingType.LIST)
            .memberName("ResourceRegion")
            .getter(getter(AutomationRulesFindingFilters::resourceRegion))
            .setter(setter(Builder::resourceRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceRegion").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StringFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(StringFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<MapFilter>> RESOURCE_TAGS_FIELD = SdkField
            .<List<MapFilter>> builder(MarshallingType.LIST)
            .memberName("ResourceTags")
            .getter(getter(AutomationRulesFindingFilters::resourceTags))
            .setter(setter(Builder::resourceTags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceTags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MapFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(MapFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<MapFilter>> RESOURCE_DETAILS_OTHER_FIELD = SdkField
            .<List<MapFilter>> builder(MarshallingType.LIST)
            .memberName("ResourceDetailsOther")
            .getter(getter(AutomationRulesFindingFilters::resourceDetailsOther))
            .setter(setter(Builder::resourceDetailsOther))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceDetailsOther").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MapFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(MapFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<StringFilter>> COMPLIANCE_STATUS_FIELD = SdkField
            .<List<StringFilter>> builder(MarshallingType.LIST)
            .memberName("ComplianceStatus")
            .getter(getter(AutomationRulesFindingFilters::complianceStatus))
            .setter(setter(Builder::complianceStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComplianceStatus").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StringFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(StringFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<StringFilter>> COMPLIANCE_SECURITY_CONTROL_ID_FIELD = SdkField
            .<List<StringFilter>> builder(MarshallingType.LIST)
            .memberName("ComplianceSecurityControlId")
            .getter(getter(AutomationRulesFindingFilters::complianceSecurityControlId))
            .setter(setter(Builder::complianceSecurityControlId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComplianceSecurityControlId")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StringFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(StringFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<StringFilter>> COMPLIANCE_ASSOCIATED_STANDARDS_ID_FIELD = SdkField
            .<List<StringFilter>> builder(MarshallingType.LIST)
            .memberName("ComplianceAssociatedStandardsId")
            .getter(getter(AutomationRulesFindingFilters::complianceAssociatedStandardsId))
            .setter(setter(Builder::complianceAssociatedStandardsId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComplianceAssociatedStandardsId")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StringFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(StringFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<StringFilter>> VERIFICATION_STATE_FIELD = SdkField
            .<List<StringFilter>> builder(MarshallingType.LIST)
            .memberName("VerificationState")
            .getter(getter(AutomationRulesFindingFilters::verificationState))
            .setter(setter(Builder::verificationState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VerificationState").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StringFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(StringFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<StringFilter>> WORKFLOW_STATUS_FIELD = SdkField
            .<List<StringFilter>> builder(MarshallingType.LIST)
            .memberName("WorkflowStatus")
            .getter(getter(AutomationRulesFindingFilters::workflowStatus))
            .setter(setter(Builder::workflowStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkflowStatus").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StringFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(StringFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<StringFilter>> RECORD_STATE_FIELD = SdkField
            .<List<StringFilter>> builder(MarshallingType.LIST)
            .memberName("RecordState")
            .getter(getter(AutomationRulesFindingFilters::recordState))
            .setter(setter(Builder::recordState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecordState").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StringFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(StringFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<StringFilter>> RELATED_FINDINGS_PRODUCT_ARN_FIELD = SdkField
            .<List<StringFilter>> builder(MarshallingType.LIST)
            .memberName("RelatedFindingsProductArn")
            .getter(getter(AutomationRulesFindingFilters::relatedFindingsProductArn))
            .setter(setter(Builder::relatedFindingsProductArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RelatedFindingsProductArn").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StringFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(StringFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<StringFilter>> RELATED_FINDINGS_ID_FIELD = SdkField
            .<List<StringFilter>> builder(MarshallingType.LIST)
            .memberName("RelatedFindingsId")
            .getter(getter(AutomationRulesFindingFilters::relatedFindingsId))
            .setter(setter(Builder::relatedFindingsId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RelatedFindingsId").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StringFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(StringFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<StringFilter>> NOTE_TEXT_FIELD = SdkField
            .<List<StringFilter>> builder(MarshallingType.LIST)
            .memberName("NoteText")
            .getter(getter(AutomationRulesFindingFilters::noteText))
            .setter(setter(Builder::noteText))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NoteText").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StringFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(StringFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<DateFilter>> NOTE_UPDATED_AT_FIELD = SdkField
            .<List<DateFilter>> builder(MarshallingType.LIST)
            .memberName("NoteUpdatedAt")
            .getter(getter(AutomationRulesFindingFilters::noteUpdatedAt))
            .setter(setter(Builder::noteUpdatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NoteUpdatedAt").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DateFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(DateFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<StringFilter>> NOTE_UPDATED_BY_FIELD = SdkField
            .<List<StringFilter>> builder(MarshallingType.LIST)
            .memberName("NoteUpdatedBy")
            .getter(getter(AutomationRulesFindingFilters::noteUpdatedBy))
            .setter(setter(Builder::noteUpdatedBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NoteUpdatedBy").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StringFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(StringFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<MapFilter>> USER_DEFINED_FIELDS_FIELD = SdkField
            .<List<MapFilter>> builder(MarshallingType.LIST)
            .memberName("UserDefinedFields")
            .getter(getter(AutomationRulesFindingFilters::userDefinedFields))
            .setter(setter(Builder::userDefinedFields))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserDefinedFields").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MapFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(MapFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<StringFilter>> RESOURCE_APPLICATION_ARN_FIELD = SdkField
            .<List<StringFilter>> builder(MarshallingType.LIST)
            .memberName("ResourceApplicationArn")
            .getter(getter(AutomationRulesFindingFilters::resourceApplicationArn))
            .setter(setter(Builder::resourceApplicationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceApplicationArn").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StringFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(StringFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<StringFilter>> RESOURCE_APPLICATION_NAME_FIELD = SdkField
            .<List<StringFilter>> builder(MarshallingType.LIST)
            .memberName("ResourceApplicationName")
            .getter(getter(AutomationRulesFindingFilters::resourceApplicationName))
            .setter(setter(Builder::resourceApplicationName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceApplicationName").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StringFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(StringFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<StringFilter>> AWS_ACCOUNT_NAME_FIELD = SdkField
            .<List<StringFilter>> builder(MarshallingType.LIST)
            .memberName("AwsAccountName")
            .getter(getter(AutomationRulesFindingFilters::awsAccountName))
            .setter(setter(Builder::awsAccountName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsAccountName").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StringFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(StringFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PRODUCT_ARN_FIELD,
            AWS_ACCOUNT_ID_FIELD, ID_FIELD, GENERATOR_ID_FIELD, TYPE_FIELD, FIRST_OBSERVED_AT_FIELD, LAST_OBSERVED_AT_FIELD,
            CREATED_AT_FIELD, UPDATED_AT_FIELD, CONFIDENCE_FIELD, CRITICALITY_FIELD, TITLE_FIELD, DESCRIPTION_FIELD,
            SOURCE_URL_FIELD, PRODUCT_NAME_FIELD, COMPANY_NAME_FIELD, SEVERITY_LABEL_FIELD, RESOURCE_TYPE_FIELD,
            RESOURCE_ID_FIELD, RESOURCE_PARTITION_FIELD, RESOURCE_REGION_FIELD, RESOURCE_TAGS_FIELD,
            RESOURCE_DETAILS_OTHER_FIELD, COMPLIANCE_STATUS_FIELD, COMPLIANCE_SECURITY_CONTROL_ID_FIELD,
            COMPLIANCE_ASSOCIATED_STANDARDS_ID_FIELD, VERIFICATION_STATE_FIELD, WORKFLOW_STATUS_FIELD, RECORD_STATE_FIELD,
            RELATED_FINDINGS_PRODUCT_ARN_FIELD, RELATED_FINDINGS_ID_FIELD, NOTE_TEXT_FIELD, NOTE_UPDATED_AT_FIELD,
            NOTE_UPDATED_BY_FIELD, USER_DEFINED_FIELDS_FIELD, RESOURCE_APPLICATION_ARN_FIELD, RESOURCE_APPLICATION_NAME_FIELD,
            AWS_ACCOUNT_NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<StringFilter> productArn;

    private final List<StringFilter> awsAccountId;

    private final List<StringFilter> id;

    private final List<StringFilter> generatorId;

    private final List<StringFilter> type;

    private final List<DateFilter> firstObservedAt;

    private final List<DateFilter> lastObservedAt;

    private final List<DateFilter> createdAt;

    private final List<DateFilter> updatedAt;

    private final List<NumberFilter> confidence;

    private final List<NumberFilter> criticality;

    private final List<StringFilter> title;

    private final List<StringFilter> description;

    private final List<StringFilter> sourceUrl;

    private final List<StringFilter> productName;

    private final List<StringFilter> companyName;

    private final List<StringFilter> severityLabel;

    private final List<StringFilter> resourceType;

    private final List<StringFilter> resourceId;

    private final List<StringFilter> resourcePartition;

    private final List<StringFilter> resourceRegion;

    private final List<MapFilter> resourceTags;

    private final List<MapFilter> resourceDetailsOther;

    private final List<StringFilter> complianceStatus;

    private final List<StringFilter> complianceSecurityControlId;

    private final List<StringFilter> complianceAssociatedStandardsId;

    private final List<StringFilter> verificationState;

    private final List<StringFilter> workflowStatus;

    private final List<StringFilter> recordState;

    private final List<StringFilter> relatedFindingsProductArn;

    private final List<StringFilter> relatedFindingsId;

    private final List<StringFilter> noteText;

    private final List<DateFilter> noteUpdatedAt;

    private final List<StringFilter> noteUpdatedBy;

    private final List<MapFilter> userDefinedFields;

    private final List<StringFilter> resourceApplicationArn;

    private final List<StringFilter> resourceApplicationName;

    private final List<StringFilter> awsAccountName;

    private AutomationRulesFindingFilters(BuilderImpl builder) {
        this.productArn = builder.productArn;
        this.awsAccountId = builder.awsAccountId;
        this.id = builder.id;
        this.generatorId = builder.generatorId;
        this.type = builder.type;
        this.firstObservedAt = builder.firstObservedAt;
        this.lastObservedAt = builder.lastObservedAt;
        this.createdAt = builder.createdAt;
        this.updatedAt = builder.updatedAt;
        this.confidence = builder.confidence;
        this.criticality = builder.criticality;
        this.title = builder.title;
        this.description = builder.description;
        this.sourceUrl = builder.sourceUrl;
        this.productName = builder.productName;
        this.companyName = builder.companyName;
        this.severityLabel = builder.severityLabel;
        this.resourceType = builder.resourceType;
        this.resourceId = builder.resourceId;
        this.resourcePartition = builder.resourcePartition;
        this.resourceRegion = builder.resourceRegion;
        this.resourceTags = builder.resourceTags;
        this.resourceDetailsOther = builder.resourceDetailsOther;
        this.complianceStatus = builder.complianceStatus;
        this.complianceSecurityControlId = builder.complianceSecurityControlId;
        this.complianceAssociatedStandardsId = builder.complianceAssociatedStandardsId;
        this.verificationState = builder.verificationState;
        this.workflowStatus = builder.workflowStatus;
        this.recordState = builder.recordState;
        this.relatedFindingsProductArn = builder.relatedFindingsProductArn;
        this.relatedFindingsId = builder.relatedFindingsId;
        this.noteText = builder.noteText;
        this.noteUpdatedAt = builder.noteUpdatedAt;
        this.noteUpdatedBy = builder.noteUpdatedBy;
        this.userDefinedFields = builder.userDefinedFields;
        this.resourceApplicationArn = builder.resourceApplicationArn;
        this.resourceApplicationName = builder.resourceApplicationName;
        this.awsAccountName = builder.awsAccountName;
    }

    /**
     * For responses, this returns true if the service returned a value for the ProductArn property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasProductArn() {
        return productArn != null && !(productArn instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for a third-party product that generated a finding in Security Hub.
     * </p>
     * <p>
     * Array Members: Minimum number of 1 item. Maximum number of 20 items.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasProductArn} method.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for a third-party product that generated a finding in Security Hub. </p>
     *         <p>
     *         Array Members: Minimum number of 1 item. Maximum number of 20 items.
     */
    public final List<StringFilter> productArn() {
        return productArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the AwsAccountId property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAwsAccountId() {
        return awsAccountId != null && !(awsAccountId instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Amazon Web Services account ID in which a finding was generated.
     * </p>
     * <p>
     * Array Members: Minimum number of 1 item. Maximum number of 100 items.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAwsAccountId} method.
     * </p>
     * 
     * @return The Amazon Web Services account ID in which a finding was generated.</p>
     *         <p>
     *         Array Members: Minimum number of 1 item. Maximum number of 100 items.
     */
    public final List<StringFilter> awsAccountId() {
        return awsAccountId;
    }

    /**
     * For responses, this returns true if the service returned a value for the Id property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasId() {
        return id != null && !(id instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The product-specific identifier for a finding.
     * </p>
     * <p>
     * Array Members: Minimum number of 1 item. Maximum number of 20 items.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasId} method.
     * </p>
     * 
     * @return The product-specific identifier for a finding. </p>
     *         <p>
     *         Array Members: Minimum number of 1 item. Maximum number of 20 items.
     */
    public final List<StringFilter> id() {
        return id;
    }

    /**
     * For responses, this returns true if the service returned a value for the GeneratorId property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasGeneratorId() {
        return generatorId != null && !(generatorId instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The identifier for the solution-specific component that generated a finding.
     * </p>
     * <p>
     * Array Members: Minimum number of 1 item. Maximum number of 100 items.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasGeneratorId} method.
     * </p>
     * 
     * @return The identifier for the solution-specific component that generated a finding. </p>
     *         <p>
     *         Array Members: Minimum number of 1 item. Maximum number of 100 items.
     */
    public final List<StringFilter> generatorId() {
        return generatorId;
    }

    /**
     * For responses, this returns true if the service returned a value for the Type property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasType() {
        return type != null && !(type instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * One or more finding types in the format of namespace/category/classifier that classify a finding. For a list of
     * namespaces, classifiers, and categories, see <a
     * href="https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-findings-format-type-taxonomy.html"
     * >Types taxonomy for ASFF</a> in the <i>Security Hub User Guide</i>.
     * </p>
     * <p>
     * Array Members: Minimum number of 1 item. Maximum number of 20 items.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasType} method.
     * </p>
     * 
     * @return One or more finding types in the format of namespace/category/classifier that classify a finding. For a
     *         list of namespaces, classifiers, and categories, see <a href=
     *         "https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-findings-format-type-taxonomy.html"
     *         >Types taxonomy for ASFF</a> in the <i>Security Hub User Guide</i>.</p>
     *         <p>
     *         Array Members: Minimum number of 1 item. Maximum number of 20 items.
     */
    public final List<StringFilter> type() {
        return type;
    }

    /**
     * For responses, this returns true if the service returned a value for the FirstObservedAt property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasFirstObservedAt() {
        return firstObservedAt != null && !(firstObservedAt instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A timestamp that indicates when the potential security issue captured by a finding was first observed by the
     * security findings product.
     * </p>
     * <p>
     * Uses the <code>date-time</code> format specified in <a href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC
     * 3339 section 5.6, Internet Date/Time Format</a>. The value cannot contain spaces. For example,
     * <code>2020-03-22T13:22:13.933Z</code>.
     * </p>
     * <p>
     * Array Members: Minimum number of 1 item. Maximum number of 20 items.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFirstObservedAt} method.
     * </p>
     * 
     * @return A timestamp that indicates when the potential security issue captured by a finding was first observed by
     *         the security findings product. </p>
     *         <p>
     *         Uses the <code>date-time</code> format specified in <a
     *         href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet Date/Time
     *         Format</a>. The value cannot contain spaces. For example, <code>2020-03-22T13:22:13.933Z</code>.
     *         </p>
     *         <p>
     *         Array Members: Minimum number of 1 item. Maximum number of 20 items.
     */
    public final List<DateFilter> firstObservedAt() {
        return firstObservedAt;
    }

    /**
     * For responses, this returns true if the service returned a value for the LastObservedAt property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasLastObservedAt() {
        return lastObservedAt != null && !(lastObservedAt instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A timestamp that indicates when the potential security issue captured by a finding was most recently observed by
     * the security findings product.
     * </p>
     * <p>
     * Uses the <code>date-time</code> format specified in <a href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC
     * 3339 section 5.6, Internet Date/Time Format</a>. The value cannot contain spaces. For example,
     * <code>2020-03-22T13:22:13.933Z</code>.
     * </p>
     * <p>
     * Array Members: Minimum number of 1 item. Maximum number of 20 items.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLastObservedAt} method.
     * </p>
     * 
     * @return A timestamp that indicates when the potential security issue captured by a finding was most recently
     *         observed by the security findings product. </p>
     *         <p>
     *         Uses the <code>date-time</code> format specified in <a
     *         href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet Date/Time
     *         Format</a>. The value cannot contain spaces. For example, <code>2020-03-22T13:22:13.933Z</code>.
     *         </p>
     *         <p>
     *         Array Members: Minimum number of 1 item. Maximum number of 20 items.
     */
    public final List<DateFilter> lastObservedAt() {
        return lastObservedAt;
    }

    /**
     * For responses, this returns true if the service returned a value for the CreatedAt property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasCreatedAt() {
        return createdAt != null && !(createdAt instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A timestamp that indicates when this finding record was created.
     * </p>
     * <p>
     * Uses the <code>date-time</code> format specified in <a href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC
     * 3339 section 5.6, Internet Date/Time Format</a>. The value cannot contain spaces. For example,
     * <code>2020-03-22T13:22:13.933Z</code>.
     * </p>
     * <p>
     * Array Members: Minimum number of 1 item. Maximum number of 20 items.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCreatedAt} method.
     * </p>
     * 
     * @return A timestamp that indicates when this finding record was created. </p>
     *         <p>
     *         Uses the <code>date-time</code> format specified in <a
     *         href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet Date/Time
     *         Format</a>. The value cannot contain spaces. For example, <code>2020-03-22T13:22:13.933Z</code>.
     *         </p>
     *         <p>
     *         Array Members: Minimum number of 1 item. Maximum number of 20 items.
     */
    public final List<DateFilter> createdAt() {
        return createdAt;
    }

    /**
     * For responses, this returns true if the service returned a value for the UpdatedAt property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasUpdatedAt() {
        return updatedAt != null && !(updatedAt instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A timestamp that indicates when the finding record was most recently updated.
     * </p>
     * <p>
     * Uses the <code>date-time</code> format specified in <a href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC
     * 3339 section 5.6, Internet Date/Time Format</a>. The value cannot contain spaces. For example,
     * <code>2020-03-22T13:22:13.933Z</code>.
     * </p>
     * <p>
     * Array Members: Minimum number of 1 item. Maximum number of 20 items.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasUpdatedAt} method.
     * </p>
     * 
     * @return A timestamp that indicates when the finding record was most recently updated. </p>
     *         <p>
     *         Uses the <code>date-time</code> format specified in <a
     *         href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet Date/Time
     *         Format</a>. The value cannot contain spaces. For example, <code>2020-03-22T13:22:13.933Z</code>.
     *         </p>
     *         <p>
     *         Array Members: Minimum number of 1 item. Maximum number of 20 items.
     */
    public final List<DateFilter> updatedAt() {
        return updatedAt;
    }

    /**
     * For responses, this returns true if the service returned a value for the Confidence property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasConfidence() {
        return confidence != null && !(confidence instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The likelihood that a finding accurately identifies the behavior or issue that it was intended to identify.
     * <code>Confidence</code> is scored on a 0–100 basis using a ratio scale. A value of <code>0</code> means 0 percent
     * confidence, and a value of <code>100</code> means 100 percent confidence. For example, a data exfiltration
     * detection based on a statistical deviation of network traffic has low confidence because an actual exfiltration
     * hasn't been verified. For more information, see <a
     * href="https://docs.aws.amazon.com/securityhub/latest/userguide/asff-top-level-attributes.html#asff-confidence"
     * >Confidence</a> in the <i>Security Hub User Guide</i>.
     * </p>
     * <p>
     * Array Members: Minimum number of 1 item. Maximum number of 20 items.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasConfidence} method.
     * </p>
     * 
     * @return The likelihood that a finding accurately identifies the behavior or issue that it was intended to
     *         identify. <code>Confidence</code> is scored on a 0–100 basis using a ratio scale. A value of
     *         <code>0</code> means 0 percent confidence, and a value of <code>100</code> means 100 percent confidence.
     *         For example, a data exfiltration detection based on a statistical deviation of network traffic has low
     *         confidence because an actual exfiltration hasn't been verified. For more information, see <a href=
     *         "https://docs.aws.amazon.com/securityhub/latest/userguide/asff-top-level-attributes.html#asff-confidence"
     *         >Confidence</a> in the <i>Security Hub User Guide</i>.</p>
     *         <p>
     *         Array Members: Minimum number of 1 item. Maximum number of 20 items.
     */
    public final List<NumberFilter> confidence() {
        return confidence;
    }

    /**
     * For responses, this returns true if the service returned a value for the Criticality property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasCriticality() {
        return criticality != null && !(criticality instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The level of importance that is assigned to the resources that are associated with a finding.
     * <code>Criticality</code> is scored on a 0–100 basis, using a ratio scale that supports only full integers. A
     * score of <code>0</code> means that the underlying resources have no criticality, and a score of <code>100</code>
     * is reserved for the most critical resources. For more information, see <a
     * href="https://docs.aws.amazon.com/securityhub/latest/userguide/asff-top-level-attributes.html#asff-criticality"
     * >Criticality</a> in the <i>Security Hub User Guide</i>.
     * </p>
     * <p>
     * Array Members: Minimum number of 1 item. Maximum number of 20 items.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCriticality} method.
     * </p>
     * 
     * @return The level of importance that is assigned to the resources that are associated with a finding.
     *         <code>Criticality</code> is scored on a 0–100 basis, using a ratio scale that supports only full
     *         integers. A score of <code>0</code> means that the underlying resources have no criticality, and a score
     *         of <code>100</code> is reserved for the most critical resources. For more information, see <a
     *         href="https://docs.aws.amazon.com/securityhub/latest/userguide/asff-top-level-attributes.html#asff-criticality"
     *         >Criticality</a> in the <i>Security Hub User Guide</i>.</p>
     *         <p>
     *         Array Members: Minimum number of 1 item. Maximum number of 20 items.
     */
    public final List<NumberFilter> criticality() {
        return criticality;
    }

    /**
     * For responses, this returns true if the service returned a value for the Title property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTitle() {
        return title != null && !(title instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A finding's title.
     * </p>
     * <p>
     * Array Members: Minimum number of 1 item. Maximum number of 100 items.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTitle} method.
     * </p>
     * 
     * @return A finding's title. </p>
     *         <p>
     *         Array Members: Minimum number of 1 item. Maximum number of 100 items.
     */
    public final List<StringFilter> title() {
        return title;
    }

    /**
     * For responses, this returns true if the service returned a value for the Description property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDescription() {
        return description != null && !(description instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A finding's description.
     * </p>
     * <p>
     * Array Members: Minimum number of 1 item. Maximum number of 20 items.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDescription} method.
     * </p>
     * 
     * @return A finding's description. </p>
     *         <p>
     *         Array Members: Minimum number of 1 item. Maximum number of 20 items.
     */
    public final List<StringFilter> description() {
        return description;
    }

    /**
     * For responses, this returns true if the service returned a value for the SourceUrl property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasSourceUrl() {
        return sourceUrl != null && !(sourceUrl instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Provides a URL that links to a page about the current finding in the finding product.
     * </p>
     * <p>
     * Array Members: Minimum number of 1 item. Maximum number of 20 items.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSourceUrl} method.
     * </p>
     * 
     * @return Provides a URL that links to a page about the current finding in the finding product. </p>
     *         <p>
     *         Array Members: Minimum number of 1 item. Maximum number of 20 items.
     */
    public final List<StringFilter> sourceUrl() {
        return sourceUrl;
    }

    /**
     * For responses, this returns true if the service returned a value for the ProductName property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasProductName() {
        return productName != null && !(productName instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Provides the name of the product that generated the finding. For control-based findings, the product name is
     * Security Hub.
     * </p>
     * <p>
     * Array Members: Minimum number of 1 item. Maximum number of 20 items.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasProductName} method.
     * </p>
     * 
     * @return Provides the name of the product that generated the finding. For control-based findings, the product name
     *         is Security Hub. </p>
     *         <p>
     *         Array Members: Minimum number of 1 item. Maximum number of 20 items.
     */
    public final List<StringFilter> productName() {
        return productName;
    }

    /**
     * For responses, this returns true if the service returned a value for the CompanyName property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasCompanyName() {
        return companyName != null && !(companyName instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The name of the company for the product that generated the finding. For control-based findings, the company is
     * Amazon Web Services.
     * </p>
     * <p>
     * Array Members: Minimum number of 1 item. Maximum number of 20 items.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCompanyName} method.
     * </p>
     * 
     * @return The name of the company for the product that generated the finding. For control-based findings, the
     *         company is Amazon Web Services. </p>
     *         <p>
     *         Array Members: Minimum number of 1 item. Maximum number of 20 items.
     */
    public final List<StringFilter> companyName() {
        return companyName;
    }

    /**
     * For responses, this returns true if the service returned a value for the SeverityLabel property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSeverityLabel() {
        return severityLabel != null && !(severityLabel instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The severity value of the finding.
     * </p>
     * <p>
     * Array Members: Minimum number of 1 item. Maximum number of 20 items.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSeverityLabel} method.
     * </p>
     * 
     * @return The severity value of the finding. </p>
     *         <p>
     *         Array Members: Minimum number of 1 item. Maximum number of 20 items.
     */
    public final List<StringFilter> severityLabel() {
        return severityLabel;
    }

    /**
     * For responses, this returns true if the service returned a value for the ResourceType property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasResourceType() {
        return resourceType != null && !(resourceType instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The type of resource that the finding pertains to.
     * </p>
     * <p>
     * Array Members: Minimum number of 1 item. Maximum number of 20 items.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResourceType} method.
     * </p>
     * 
     * @return The type of resource that the finding pertains to. </p>
     *         <p>
     *         Array Members: Minimum number of 1 item. Maximum number of 20 items.
     */
    public final List<StringFilter> resourceType() {
        return resourceType;
    }

    /**
     * For responses, this returns true if the service returned a value for the ResourceId property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasResourceId() {
        return resourceId != null && !(resourceId instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The identifier for the given resource type. For Amazon Web Services resources that are identified by Amazon
     * Resource Names (ARNs), this is the ARN. For Amazon Web Services resources that lack ARNs, this is the identifier
     * as defined by the Amazon Web Service that created the resource. For non-Amazon Web Services resources, this is a
     * unique identifier that is associated with the resource.
     * </p>
     * <p>
     * Array Members: Minimum number of 1 item. Maximum number of 100 items.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResourceId} method.
     * </p>
     * 
     * @return The identifier for the given resource type. For Amazon Web Services resources that are identified by
     *         Amazon Resource Names (ARNs), this is the ARN. For Amazon Web Services resources that lack ARNs, this is
     *         the identifier as defined by the Amazon Web Service that created the resource. For non-Amazon Web
     *         Services resources, this is a unique identifier that is associated with the resource. </p>
     *         <p>
     *         Array Members: Minimum number of 1 item. Maximum number of 100 items.
     */
    public final List<StringFilter> resourceId() {
        return resourceId;
    }

    /**
     * For responses, this returns true if the service returned a value for the ResourcePartition property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasResourcePartition() {
        return resourcePartition != null && !(resourcePartition instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The partition in which the resource that the finding pertains to is located. A partition is a group of Amazon Web
     * Services Regions. Each Amazon Web Services account is scoped to one partition.
     * </p>
     * <p>
     * Array Members: Minimum number of 1 item. Maximum number of 20 items.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResourcePartition} method.
     * </p>
     * 
     * @return The partition in which the resource that the finding pertains to is located. A partition is a group of
     *         Amazon Web Services Regions. Each Amazon Web Services account is scoped to one partition. </p>
     *         <p>
     *         Array Members: Minimum number of 1 item. Maximum number of 20 items.
     */
    public final List<StringFilter> resourcePartition() {
        return resourcePartition;
    }

    /**
     * For responses, this returns true if the service returned a value for the ResourceRegion property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasResourceRegion() {
        return resourceRegion != null && !(resourceRegion instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Amazon Web Services Region where the resource that a finding pertains to is located.
     * </p>
     * <p>
     * Array Members: Minimum number of 1 item. Maximum number of 20 items.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResourceRegion} method.
     * </p>
     * 
     * @return The Amazon Web Services Region where the resource that a finding pertains to is located. </p>
     *         <p>
     *         Array Members: Minimum number of 1 item. Maximum number of 20 items.
     */
    public final List<StringFilter> resourceRegion() {
        return resourceRegion;
    }

    /**
     * For responses, this returns true if the service returned a value for the ResourceTags property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasResourceTags() {
        return resourceTags != null && !(resourceTags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of Amazon Web Services tags associated with a resource at the time the finding was processed.
     * </p>
     * <p>
     * Array Members: Minimum number of 1 item. Maximum number of 20 items.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResourceTags} method.
     * </p>
     * 
     * @return A list of Amazon Web Services tags associated with a resource at the time the finding was processed. </p>
     *         <p>
     *         Array Members: Minimum number of 1 item. Maximum number of 20 items.
     */
    public final List<MapFilter> resourceTags() {
        return resourceTags;
    }

    /**
     * For responses, this returns true if the service returned a value for the ResourceDetailsOther property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasResourceDetailsOther() {
        return resourceDetailsOther != null && !(resourceDetailsOther instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Custom fields and values about the resource that a finding pertains to.
     * </p>
     * <p>
     * Array Members: Minimum number of 1 item. Maximum number of 20 items.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResourceDetailsOther} method.
     * </p>
     * 
     * @return Custom fields and values about the resource that a finding pertains to. </p>
     *         <p>
     *         Array Members: Minimum number of 1 item. Maximum number of 20 items.
     */
    public final List<MapFilter> resourceDetailsOther() {
        return resourceDetailsOther;
    }

    /**
     * For responses, this returns true if the service returned a value for the ComplianceStatus property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasComplianceStatus() {
        return complianceStatus != null && !(complianceStatus instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The result of a security check. This field is only used for findings generated from controls.
     * </p>
     * <p>
     * Array Members: Minimum number of 1 item. Maximum number of 20 items.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasComplianceStatus} method.
     * </p>
     * 
     * @return The result of a security check. This field is only used for findings generated from controls. </p>
     *         <p>
     *         Array Members: Minimum number of 1 item. Maximum number of 20 items.
     */
    public final List<StringFilter> complianceStatus() {
        return complianceStatus;
    }

    /**
     * For responses, this returns true if the service returned a value for the ComplianceSecurityControlId property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasComplianceSecurityControlId() {
        return complianceSecurityControlId != null && !(complianceSecurityControlId instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The security control ID for which a finding was generated. Security control IDs are the same across standards.
     * </p>
     * <p>
     * Array Members: Minimum number of 1 item. Maximum number of 20 items.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasComplianceSecurityControlId} method.
     * </p>
     * 
     * @return The security control ID for which a finding was generated. Security control IDs are the same across
     *         standards.</p>
     *         <p>
     *         Array Members: Minimum number of 1 item. Maximum number of 20 items.
     */
    public final List<StringFilter> complianceSecurityControlId() {
        return complianceSecurityControlId;
    }

    /**
     * For responses, this returns true if the service returned a value for the ComplianceAssociatedStandardsId
     * property. This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()}
     * method on the property). This is useful because the SDK will never return a null collection or map, but you may
     * need to differentiate between the service returning nothing (or null) and the service returning an empty
     * collection or map. For requests, this returns true if a value for the property was specified in the request
     * builder, and false if a value was not specified.
     */
    public final boolean hasComplianceAssociatedStandardsId() {
        return complianceAssociatedStandardsId != null && !(complianceAssociatedStandardsId instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The unique identifier of a standard in which a control is enabled. This field consists of the resource portion of
     * the Amazon Resource Name (ARN) returned for a standard in the <a
     * href="https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_DescribeStandards.html">DescribeStandards</a>
     * API response.
     * </p>
     * <p>
     * Array Members: Minimum number of 1 item. Maximum number of 20 items.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasComplianceAssociatedStandardsId}
     * method.
     * </p>
     * 
     * @return The unique identifier of a standard in which a control is enabled. This field consists of the resource
     *         portion of the Amazon Resource Name (ARN) returned for a standard in the <a
     *         href="https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_DescribeStandards.html"
     *         >DescribeStandards</a> API response.</p>
     *         <p>
     *         Array Members: Minimum number of 1 item. Maximum number of 20 items.
     */
    public final List<StringFilter> complianceAssociatedStandardsId() {
        return complianceAssociatedStandardsId;
    }

    /**
     * For responses, this returns true if the service returned a value for the VerificationState property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasVerificationState() {
        return verificationState != null && !(verificationState instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Provides the veracity of a finding.
     * </p>
     * <p>
     * Array Members: Minimum number of 1 item. Maximum number of 20 items.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasVerificationState} method.
     * </p>
     * 
     * @return Provides the veracity of a finding. </p>
     *         <p>
     *         Array Members: Minimum number of 1 item. Maximum number of 20 items.
     */
    public final List<StringFilter> verificationState() {
        return verificationState;
    }

    /**
     * For responses, this returns true if the service returned a value for the WorkflowStatus property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasWorkflowStatus() {
        return workflowStatus != null && !(workflowStatus instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Provides information about the status of the investigation into a finding.
     * </p>
     * <p>
     * Array Members: Minimum number of 1 item. Maximum number of 20 items.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasWorkflowStatus} method.
     * </p>
     * 
     * @return Provides information about the status of the investigation into a finding. </p>
     *         <p>
     *         Array Members: Minimum number of 1 item. Maximum number of 20 items.
     */
    public final List<StringFilter> workflowStatus() {
        return workflowStatus;
    }

    /**
     * For responses, this returns true if the service returned a value for the RecordState property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasRecordState() {
        return recordState != null && !(recordState instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Provides the current state of a finding.
     * </p>
     * <p>
     * Array Members: Minimum number of 1 item. Maximum number of 20 items.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRecordState} method.
     * </p>
     * 
     * @return Provides the current state of a finding. </p>
     *         <p>
     *         Array Members: Minimum number of 1 item. Maximum number of 20 items.
     */
    public final List<StringFilter> recordState() {
        return recordState;
    }

    /**
     * For responses, this returns true if the service returned a value for the RelatedFindingsProductArn property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasRelatedFindingsProductArn() {
        return relatedFindingsProductArn != null && !(relatedFindingsProductArn instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The ARN for the product that generated a related finding.
     * </p>
     * <p>
     * Array Members: Minimum number of 1 item. Maximum number of 20 items.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRelatedFindingsProductArn} method.
     * </p>
     * 
     * @return The ARN for the product that generated a related finding. </p>
     *         <p>
     *         Array Members: Minimum number of 1 item. Maximum number of 20 items.
     */
    public final List<StringFilter> relatedFindingsProductArn() {
        return relatedFindingsProductArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the RelatedFindingsId property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasRelatedFindingsId() {
        return relatedFindingsId != null && !(relatedFindingsId instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The product-generated identifier for a related finding.
     * </p>
     * <p>
     * Array Members: Minimum number of 1 item. Maximum number of 20 items.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRelatedFindingsId} method.
     * </p>
     * 
     * @return The product-generated identifier for a related finding. </p>
     *         <p>
     *         Array Members: Minimum number of 1 item. Maximum number of 20 items.
     */
    public final List<StringFilter> relatedFindingsId() {
        return relatedFindingsId;
    }

    /**
     * For responses, this returns true if the service returned a value for the NoteText property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasNoteText() {
        return noteText != null && !(noteText instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The text of a user-defined note that's added to a finding.
     * </p>
     * <p>
     * Array Members: Minimum number of 1 item. Maximum number of 20 items.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasNoteText} method.
     * </p>
     * 
     * @return The text of a user-defined note that's added to a finding. </p>
     *         <p>
     *         Array Members: Minimum number of 1 item. Maximum number of 20 items.
     */
    public final List<StringFilter> noteText() {
        return noteText;
    }

    /**
     * For responses, this returns true if the service returned a value for the NoteUpdatedAt property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasNoteUpdatedAt() {
        return noteUpdatedAt != null && !(noteUpdatedAt instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The timestamp of when the note was updated. Uses the date-time format specified in <a
     * href="https://www.rfc-editor.org/rfc/rfc3339#section-5.6">RFC 3339 section 5.6, Internet Date/Time Format</a>.
     * The value cannot contain spaces. For example, <code>2020-03-22T13:22:13.933Z</code>.
     * </p>
     * <p>
     * Array Members: Minimum number of 1 item. Maximum number of 20 items.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasNoteUpdatedAt} method.
     * </p>
     * 
     * @return The timestamp of when the note was updated. Uses the date-time format specified in <a
     *         href="https://www.rfc-editor.org/rfc/rfc3339#section-5.6">RFC 3339 section 5.6, Internet Date/Time
     *         Format</a>. The value cannot contain spaces. For example, <code>2020-03-22T13:22:13.933Z</code>. </p>
     *         <p>
     *         Array Members: Minimum number of 1 item. Maximum number of 20 items.
     */
    public final List<DateFilter> noteUpdatedAt() {
        return noteUpdatedAt;
    }

    /**
     * For responses, this returns true if the service returned a value for the NoteUpdatedBy property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasNoteUpdatedBy() {
        return noteUpdatedBy != null && !(noteUpdatedBy instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The principal that created a note.
     * </p>
     * <p>
     * Array Members: Minimum number of 1 item. Maximum number of 20 items.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasNoteUpdatedBy} method.
     * </p>
     * 
     * @return The principal that created a note. </p>
     *         <p>
     *         Array Members: Minimum number of 1 item. Maximum number of 20 items.
     */
    public final List<StringFilter> noteUpdatedBy() {
        return noteUpdatedBy;
    }

    /**
     * For responses, this returns true if the service returned a value for the UserDefinedFields property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasUserDefinedFields() {
        return userDefinedFields != null && !(userDefinedFields instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of user-defined name and value string pairs added to a finding.
     * </p>
     * <p>
     * Array Members: Minimum number of 1 item. Maximum number of 20 items.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasUserDefinedFields} method.
     * </p>
     * 
     * @return A list of user-defined name and value string pairs added to a finding. </p>
     *         <p>
     *         Array Members: Minimum number of 1 item. Maximum number of 20 items.
     */
    public final List<MapFilter> userDefinedFields() {
        return userDefinedFields;
    }

    /**
     * For responses, this returns true if the service returned a value for the ResourceApplicationArn property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasResourceApplicationArn() {
        return resourceApplicationArn != null && !(resourceApplicationArn instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the application that is related to a finding.
     * </p>
     * <p>
     * Array Members: Minimum number of 1 item. Maximum number of 20 items.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResourceApplicationArn} method.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the application that is related to a finding. </p>
     *         <p>
     *         Array Members: Minimum number of 1 item. Maximum number of 20 items.
     */
    public final List<StringFilter> resourceApplicationArn() {
        return resourceApplicationArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the ResourceApplicationName property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasResourceApplicationName() {
        return resourceApplicationName != null && !(resourceApplicationName instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The name of the application that is related to a finding.
     * </p>
     * <p>
     * Array Members: Minimum number of 1 item. Maximum number of 20 items.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResourceApplicationName} method.
     * </p>
     * 
     * @return The name of the application that is related to a finding. </p>
     *         <p>
     *         Array Members: Minimum number of 1 item. Maximum number of 20 items.
     */
    public final List<StringFilter> resourceApplicationName() {
        return resourceApplicationName;
    }

    /**
     * For responses, this returns true if the service returned a value for the AwsAccountName property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAwsAccountName() {
        return awsAccountName != null && !(awsAccountName instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The name of the Amazon Web Services account in which a finding was generated.
     * </p>
     * <p>
     * Array Members: Minimum number of 1 item. Maximum number of 20 items.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAwsAccountName} method.
     * </p>
     * 
     * @return The name of the Amazon Web Services account in which a finding was generated. </p>
     *         <p>
     *         Array Members: Minimum number of 1 item. Maximum number of 20 items.
     */
    public final List<StringFilter> awsAccountName() {
        return awsAccountName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasProductArn() ? productArn() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAwsAccountId() ? awsAccountId() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasId() ? id() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasGeneratorId() ? generatorId() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasType() ? type() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasFirstObservedAt() ? firstObservedAt() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasLastObservedAt() ? lastObservedAt() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasCreatedAt() ? createdAt() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasUpdatedAt() ? updatedAt() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasConfidence() ? confidence() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasCriticality() ? criticality() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTitle() ? title() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasDescription() ? description() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSourceUrl() ? sourceUrl() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasProductName() ? productName() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasCompanyName() ? companyName() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSeverityLabel() ? severityLabel() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasResourceType() ? resourceType() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasResourceId() ? resourceId() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasResourcePartition() ? resourcePartition() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasResourceRegion() ? resourceRegion() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasResourceTags() ? resourceTags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasResourceDetailsOther() ? resourceDetailsOther() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasComplianceStatus() ? complianceStatus() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasComplianceSecurityControlId() ? complianceSecurityControlId() : null);
        hashCode = 31 * hashCode
                + Objects.hashCode(hasComplianceAssociatedStandardsId() ? complianceAssociatedStandardsId() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasVerificationState() ? verificationState() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasWorkflowStatus() ? workflowStatus() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasRecordState() ? recordState() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasRelatedFindingsProductArn() ? relatedFindingsProductArn() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasRelatedFindingsId() ? relatedFindingsId() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasNoteText() ? noteText() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasNoteUpdatedAt() ? noteUpdatedAt() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasNoteUpdatedBy() ? noteUpdatedBy() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasUserDefinedFields() ? userDefinedFields() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasResourceApplicationArn() ? resourceApplicationArn() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasResourceApplicationName() ? resourceApplicationName() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAwsAccountName() ? awsAccountName() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutomationRulesFindingFilters)) {
            return false;
        }
        AutomationRulesFindingFilters other = (AutomationRulesFindingFilters) obj;
        return hasProductArn() == other.hasProductArn() && Objects.equals(productArn(), other.productArn())
                && hasAwsAccountId() == other.hasAwsAccountId() && Objects.equals(awsAccountId(), other.awsAccountId())
                && hasId() == other.hasId() && Objects.equals(id(), other.id()) && hasGeneratorId() == other.hasGeneratorId()
                && Objects.equals(generatorId(), other.generatorId()) && hasType() == other.hasType()
                && Objects.equals(type(), other.type()) && hasFirstObservedAt() == other.hasFirstObservedAt()
                && Objects.equals(firstObservedAt(), other.firstObservedAt()) && hasLastObservedAt() == other.hasLastObservedAt()
                && Objects.equals(lastObservedAt(), other.lastObservedAt()) && hasCreatedAt() == other.hasCreatedAt()
                && Objects.equals(createdAt(), other.createdAt()) && hasUpdatedAt() == other.hasUpdatedAt()
                && Objects.equals(updatedAt(), other.updatedAt()) && hasConfidence() == other.hasConfidence()
                && Objects.equals(confidence(), other.confidence()) && hasCriticality() == other.hasCriticality()
                && Objects.equals(criticality(), other.criticality()) && hasTitle() == other.hasTitle()
                && Objects.equals(title(), other.title()) && hasDescription() == other.hasDescription()
                && Objects.equals(description(), other.description()) && hasSourceUrl() == other.hasSourceUrl()
                && Objects.equals(sourceUrl(), other.sourceUrl()) && hasProductName() == other.hasProductName()
                && Objects.equals(productName(), other.productName()) && hasCompanyName() == other.hasCompanyName()
                && Objects.equals(companyName(), other.companyName()) && hasSeverityLabel() == other.hasSeverityLabel()
                && Objects.equals(severityLabel(), other.severityLabel()) && hasResourceType() == other.hasResourceType()
                && Objects.equals(resourceType(), other.resourceType()) && hasResourceId() == other.hasResourceId()
                && Objects.equals(resourceId(), other.resourceId()) && hasResourcePartition() == other.hasResourcePartition()
                && Objects.equals(resourcePartition(), other.resourcePartition())
                && hasResourceRegion() == other.hasResourceRegion() && Objects.equals(resourceRegion(), other.resourceRegion())
                && hasResourceTags() == other.hasResourceTags() && Objects.equals(resourceTags(), other.resourceTags())
                && hasResourceDetailsOther() == other.hasResourceDetailsOther()
                && Objects.equals(resourceDetailsOther(), other.resourceDetailsOther())
                && hasComplianceStatus() == other.hasComplianceStatus()
                && Objects.equals(complianceStatus(), other.complianceStatus())
                && hasComplianceSecurityControlId() == other.hasComplianceSecurityControlId()
                && Objects.equals(complianceSecurityControlId(), other.complianceSecurityControlId())
                && hasComplianceAssociatedStandardsId() == other.hasComplianceAssociatedStandardsId()
                && Objects.equals(complianceAssociatedStandardsId(), other.complianceAssociatedStandardsId())
                && hasVerificationState() == other.hasVerificationState()
                && Objects.equals(verificationState(), other.verificationState())
                && hasWorkflowStatus() == other.hasWorkflowStatus() && Objects.equals(workflowStatus(), other.workflowStatus())
                && hasRecordState() == other.hasRecordState() && Objects.equals(recordState(), other.recordState())
                && hasRelatedFindingsProductArn() == other.hasRelatedFindingsProductArn()
                && Objects.equals(relatedFindingsProductArn(), other.relatedFindingsProductArn())
                && hasRelatedFindingsId() == other.hasRelatedFindingsId()
                && Objects.equals(relatedFindingsId(), other.relatedFindingsId()) && hasNoteText() == other.hasNoteText()
                && Objects.equals(noteText(), other.noteText()) && hasNoteUpdatedAt() == other.hasNoteUpdatedAt()
                && Objects.equals(noteUpdatedAt(), other.noteUpdatedAt()) && hasNoteUpdatedBy() == other.hasNoteUpdatedBy()
                && Objects.equals(noteUpdatedBy(), other.noteUpdatedBy())
                && hasUserDefinedFields() == other.hasUserDefinedFields()
                && Objects.equals(userDefinedFields(), other.userDefinedFields())
                && hasResourceApplicationArn() == other.hasResourceApplicationArn()
                && Objects.equals(resourceApplicationArn(), other.resourceApplicationArn())
                && hasResourceApplicationName() == other.hasResourceApplicationName()
                && Objects.equals(resourceApplicationName(), other.resourceApplicationName())
                && hasAwsAccountName() == other.hasAwsAccountName() && Objects.equals(awsAccountName(), other.awsAccountName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("AutomationRulesFindingFilters")
                .add("ProductArn", hasProductArn() ? productArn() : null)
                .add("AwsAccountId", hasAwsAccountId() ? awsAccountId() : null)
                .add("Id", hasId() ? id() : null)
                .add("GeneratorId", hasGeneratorId() ? generatorId() : null)
                .add("Type", hasType() ? type() : null)
                .add("FirstObservedAt", hasFirstObservedAt() ? firstObservedAt() : null)
                .add("LastObservedAt", hasLastObservedAt() ? lastObservedAt() : null)
                .add("CreatedAt", hasCreatedAt() ? createdAt() : null)
                .add("UpdatedAt", hasUpdatedAt() ? updatedAt() : null)
                .add("Confidence", hasConfidence() ? confidence() : null)
                .add("Criticality", hasCriticality() ? criticality() : null)
                .add("Title", hasTitle() ? title() : null)
                .add("Description", hasDescription() ? description() : null)
                .add("SourceUrl", hasSourceUrl() ? sourceUrl() : null)
                .add("ProductName", hasProductName() ? productName() : null)
                .add("CompanyName", hasCompanyName() ? companyName() : null)
                .add("SeverityLabel", hasSeverityLabel() ? severityLabel() : null)
                .add("ResourceType", hasResourceType() ? resourceType() : null)
                .add("ResourceId", hasResourceId() ? resourceId() : null)
                .add("ResourcePartition", hasResourcePartition() ? resourcePartition() : null)
                .add("ResourceRegion", hasResourceRegion() ? resourceRegion() : null)
                .add("ResourceTags", hasResourceTags() ? resourceTags() : null)
                .add("ResourceDetailsOther", hasResourceDetailsOther() ? resourceDetailsOther() : null)
                .add("ComplianceStatus", hasComplianceStatus() ? complianceStatus() : null)
                .add("ComplianceSecurityControlId", hasComplianceSecurityControlId() ? complianceSecurityControlId() : null)
                .add("ComplianceAssociatedStandardsId",
                        hasComplianceAssociatedStandardsId() ? complianceAssociatedStandardsId() : null)
                .add("VerificationState", hasVerificationState() ? verificationState() : null)
                .add("WorkflowStatus", hasWorkflowStatus() ? workflowStatus() : null)
                .add("RecordState", hasRecordState() ? recordState() : null)
                .add("RelatedFindingsProductArn", hasRelatedFindingsProductArn() ? relatedFindingsProductArn() : null)
                .add("RelatedFindingsId", hasRelatedFindingsId() ? relatedFindingsId() : null)
                .add("NoteText", hasNoteText() ? noteText() : null)
                .add("NoteUpdatedAt", hasNoteUpdatedAt() ? noteUpdatedAt() : null)
                .add("NoteUpdatedBy", hasNoteUpdatedBy() ? noteUpdatedBy() : null)
                .add("UserDefinedFields", hasUserDefinedFields() ? userDefinedFields() : null)
                .add("ResourceApplicationArn", hasResourceApplicationArn() ? resourceApplicationArn() : null)
                .add("ResourceApplicationName", hasResourceApplicationName() ? resourceApplicationName() : null)
                .add("AwsAccountName", hasAwsAccountName() ? awsAccountName() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ProductArn":
            return Optional.ofNullable(clazz.cast(productArn()));
        case "AwsAccountId":
            return Optional.ofNullable(clazz.cast(awsAccountId()));
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "GeneratorId":
            return Optional.ofNullable(clazz.cast(generatorId()));
        case "Type":
            return Optional.ofNullable(clazz.cast(type()));
        case "FirstObservedAt":
            return Optional.ofNullable(clazz.cast(firstObservedAt()));
        case "LastObservedAt":
            return Optional.ofNullable(clazz.cast(lastObservedAt()));
        case "CreatedAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "UpdatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        case "Confidence":
            return Optional.ofNullable(clazz.cast(confidence()));
        case "Criticality":
            return Optional.ofNullable(clazz.cast(criticality()));
        case "Title":
            return Optional.ofNullable(clazz.cast(title()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "SourceUrl":
            return Optional.ofNullable(clazz.cast(sourceUrl()));
        case "ProductName":
            return Optional.ofNullable(clazz.cast(productName()));
        case "CompanyName":
            return Optional.ofNullable(clazz.cast(companyName()));
        case "SeverityLabel":
            return Optional.ofNullable(clazz.cast(severityLabel()));
        case "ResourceType":
            return Optional.ofNullable(clazz.cast(resourceType()));
        case "ResourceId":
            return Optional.ofNullable(clazz.cast(resourceId()));
        case "ResourcePartition":
            return Optional.ofNullable(clazz.cast(resourcePartition()));
        case "ResourceRegion":
            return Optional.ofNullable(clazz.cast(resourceRegion()));
        case "ResourceTags":
            return Optional.ofNullable(clazz.cast(resourceTags()));
        case "ResourceDetailsOther":
            return Optional.ofNullable(clazz.cast(resourceDetailsOther()));
        case "ComplianceStatus":
            return Optional.ofNullable(clazz.cast(complianceStatus()));
        case "ComplianceSecurityControlId":
            return Optional.ofNullable(clazz.cast(complianceSecurityControlId()));
        case "ComplianceAssociatedStandardsId":
            return Optional.ofNullable(clazz.cast(complianceAssociatedStandardsId()));
        case "VerificationState":
            return Optional.ofNullable(clazz.cast(verificationState()));
        case "WorkflowStatus":
            return Optional.ofNullable(clazz.cast(workflowStatus()));
        case "RecordState":
            return Optional.ofNullable(clazz.cast(recordState()));
        case "RelatedFindingsProductArn":
            return Optional.ofNullable(clazz.cast(relatedFindingsProductArn()));
        case "RelatedFindingsId":
            return Optional.ofNullable(clazz.cast(relatedFindingsId()));
        case "NoteText":
            return Optional.ofNullable(clazz.cast(noteText()));
        case "NoteUpdatedAt":
            return Optional.ofNullable(clazz.cast(noteUpdatedAt()));
        case "NoteUpdatedBy":
            return Optional.ofNullable(clazz.cast(noteUpdatedBy()));
        case "UserDefinedFields":
            return Optional.ofNullable(clazz.cast(userDefinedFields()));
        case "ResourceApplicationArn":
            return Optional.ofNullable(clazz.cast(resourceApplicationArn()));
        case "ResourceApplicationName":
            return Optional.ofNullable(clazz.cast(resourceApplicationName()));
        case "AwsAccountName":
            return Optional.ofNullable(clazz.cast(awsAccountName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AutomationRulesFindingFilters, T> g) {
        return obj -> g.apply((AutomationRulesFindingFilters) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AutomationRulesFindingFilters> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) for a third-party product that generated a finding in Security Hub.
         * </p>
         * <p>
         * Array Members: Minimum number of 1 item. Maximum number of 20 items.
         * </p>
         * 
         * @param productArn
         *        The Amazon Resource Name (ARN) for a third-party product that generated a finding in Security Hub.
         *        </p>
         *        <p>
         *        Array Members: Minimum number of 1 item. Maximum number of 20 items.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productArn(Collection<StringFilter> productArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) for a third-party product that generated a finding in Security Hub.
         * </p>
         * <p>
         * Array Members: Minimum number of 1 item. Maximum number of 20 items.
         * </p>
         * 
         * @param productArn
         *        The Amazon Resource Name (ARN) for a third-party product that generated a finding in Security Hub.
         *        </p>
         *        <p>
         *        Array Members: Minimum number of 1 item. Maximum number of 20 items.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productArn(StringFilter... productArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) for a third-party product that generated a finding in Security Hub.
         * </p>
         * <p>
         * Array Members: Minimum number of 1 item. Maximum number of 20 items.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityhub.model.StringFilter.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.securityhub.model.StringFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityhub.model.StringFilter.Builder#build()} is called immediately
         * and its result is passed to {@link #productArn(List<StringFilter>)}.
         * 
         * @param productArn
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityhub.model.StringFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #productArn(java.util.Collection<StringFilter>)
         */
        Builder productArn(Consumer<StringFilter.Builder>... productArn);

        /**
         * <p>
         * The Amazon Web Services account ID in which a finding was generated.
         * </p>
         * <p>
         * Array Members: Minimum number of 1 item. Maximum number of 100 items.
         * </p>
         * 
         * @param awsAccountId
         *        The Amazon Web Services account ID in which a finding was generated.</p>
         *        <p>
         *        Array Members: Minimum number of 1 item. Maximum number of 100 items.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsAccountId(Collection<StringFilter> awsAccountId);

        /**
         * <p>
         * The Amazon Web Services account ID in which a finding was generated.
         * </p>
         * <p>
         * Array Members: Minimum number of 1 item. Maximum number of 100 items.
         * </p>
         * 
         * @param awsAccountId
         *        The Amazon Web Services account ID in which a finding was generated.</p>
         *        <p>
         *        Array Members: Minimum number of 1 item. Maximum number of 100 items.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsAccountId(StringFilter... awsAccountId);

        /**
         * <p>
         * The Amazon Web Services account ID in which a finding was generated.
         * </p>
         * <p>
         * Array Members: Minimum number of 1 item. Maximum number of 100 items.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityhub.model.StringFilter.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.securityhub.model.StringFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityhub.model.StringFilter.Builder#build()} is called immediately
         * and its result is passed to {@link #awsAccountId(List<StringFilter>)}.
         * 
         * @param awsAccountId
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityhub.model.StringFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #awsAccountId(java.util.Collection<StringFilter>)
         */
        Builder awsAccountId(Consumer<StringFilter.Builder>... awsAccountId);

        /**
         * <p>
         * The product-specific identifier for a finding.
         * </p>
         * <p>
         * Array Members: Minimum number of 1 item. Maximum number of 20 items.
         * </p>
         * 
         * @param id
         *        The product-specific identifier for a finding. </p>
         *        <p>
         *        Array Members: Minimum number of 1 item. Maximum number of 20 items.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(Collection<StringFilter> id);

        /**
         * <p>
         * The product-specific identifier for a finding.
         * </p>
         * <p>
         * Array Members: Minimum number of 1 item. Maximum number of 20 items.
         * </p>
         * 
         * @param id
         *        The product-specific identifier for a finding. </p>
         *        <p>
         *        Array Members: Minimum number of 1 item. Maximum number of 20 items.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(StringFilter... id);

        /**
         * <p>
         * The product-specific identifier for a finding.
         * </p>
         * <p>
         * Array Members: Minimum number of 1 item. Maximum number of 20 items.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityhub.model.StringFilter.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.securityhub.model.StringFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityhub.model.StringFilter.Builder#build()} is called immediately
         * and its result is passed to {@link #id(List<StringFilter>)}.
         * 
         * @param id
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityhub.model.StringFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #id(java.util.Collection<StringFilter>)
         */
        Builder id(Consumer<StringFilter.Builder>... id);

        /**
         * <p>
         * The identifier for the solution-specific component that generated a finding.
         * </p>
         * <p>
         * Array Members: Minimum number of 1 item. Maximum number of 100 items.
         * </p>
         * 
         * @param generatorId
         *        The identifier for the solution-specific component that generated a finding. </p>
         *        <p>
         *        Array Members: Minimum number of 1 item. Maximum number of 100 items.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder generatorId(Collection<StringFilter> generatorId);

        /**
         * <p>
         * The identifier for the solution-specific component that generated a finding.
         * </p>
         * <p>
         * Array Members: Minimum number of 1 item. Maximum number of 100 items.
         * </p>
         * 
         * @param generatorId
         *        The identifier for the solution-specific component that generated a finding. </p>
         *        <p>
         *        Array Members: Minimum number of 1 item. Maximum number of 100 items.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder generatorId(StringFilter... generatorId);

        /**
         * <p>
         * The identifier for the solution-specific component that generated a finding.
         * </p>
         * <p>
         * Array Members: Minimum number of 1 item. Maximum number of 100 items.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityhub.model.StringFilter.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.securityhub.model.StringFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityhub.model.StringFilter.Builder#build()} is called immediately
         * and its result is passed to {@link #generatorId(List<StringFilter>)}.
         * 
         * @param generatorId
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityhub.model.StringFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #generatorId(java.util.Collection<StringFilter>)
         */
        Builder generatorId(Consumer<StringFilter.Builder>... generatorId);

        /**
         * <p>
         * One or more finding types in the format of namespace/category/classifier that classify a finding. For a list
         * of namespaces, classifiers, and categories, see <a href=
         * "https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-findings-format-type-taxonomy.html"
         * >Types taxonomy for ASFF</a> in the <i>Security Hub User Guide</i>.
         * </p>
         * <p>
         * Array Members: Minimum number of 1 item. Maximum number of 20 items.
         * </p>
         * 
         * @param type
         *        One or more finding types in the format of namespace/category/classifier that classify a finding. For
         *        a list of namespaces, classifiers, and categories, see <a href=
         *        "https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-findings-format-type-taxonomy.html"
         *        >Types taxonomy for ASFF</a> in the <i>Security Hub User Guide</i>.</p>
         *        <p>
         *        Array Members: Minimum number of 1 item. Maximum number of 20 items.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder type(Collection<StringFilter> type);

        /**
         * <p>
         * One or more finding types in the format of namespace/category/classifier that classify a finding. For a list
         * of namespaces, classifiers, and categories, see <a href=
         * "https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-findings-format-type-taxonomy.html"
         * >Types taxonomy for ASFF</a> in the <i>Security Hub User Guide</i>.
         * </p>
         * <p>
         * Array Members: Minimum number of 1 item. Maximum number of 20 items.
         * </p>
         * 
         * @param type
         *        One or more finding types in the format of namespace/category/classifier that classify a finding. For
         *        a list of namespaces, classifiers, and categories, see <a href=
         *        "https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-findings-format-type-taxonomy.html"
         *        >Types taxonomy for ASFF</a> in the <i>Security Hub User Guide</i>.</p>
         *        <p>
         *        Array Members: Minimum number of 1 item. Maximum number of 20 items.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder type(StringFilter... type);

        /**
         * <p>
         * One or more finding types in the format of namespace/category/classifier that classify a finding. For a list
         * of namespaces, classifiers, and categories, see <a href=
         * "https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-findings-format-type-taxonomy.html"
         * >Types taxonomy for ASFF</a> in the <i>Security Hub User Guide</i>.
         * </p>
         * <p>
         * Array Members: Minimum number of 1 item. Maximum number of 20 items.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityhub.model.StringFilter.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.securityhub.model.StringFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityhub.model.StringFilter.Builder#build()} is called immediately
         * and its result is passed to {@link #type(List<StringFilter>)}.
         * 
         * @param type
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityhub.model.StringFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #type(java.util.Collection<StringFilter>)
         */
        Builder type(Consumer<StringFilter.Builder>... type);

        /**
         * <p>
         * A timestamp that indicates when the potential security issue captured by a finding was first observed by the
         * security findings product.
         * </p>
         * <p>
         * Uses the <code>date-time</code> format specified in <a
         * href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet Date/Time Format</a>.
         * The value cannot contain spaces. For example, <code>2020-03-22T13:22:13.933Z</code>.
         * </p>
         * <p>
         * Array Members: Minimum number of 1 item. Maximum number of 20 items.
         * </p>
         * 
         * @param firstObservedAt
         *        A timestamp that indicates when the potential security issue captured by a finding was first observed
         *        by the security findings product. </p>
         *        <p>
         *        Uses the <code>date-time</code> format specified in <a
         *        href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet Date/Time
         *        Format</a>. The value cannot contain spaces. For example, <code>2020-03-22T13:22:13.933Z</code>.
         *        </p>
         *        <p>
         *        Array Members: Minimum number of 1 item. Maximum number of 20 items.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder firstObservedAt(Collection<DateFilter> firstObservedAt);

        /**
         * <p>
         * A timestamp that indicates when the potential security issue captured by a finding was first observed by the
         * security findings product.
         * </p>
         * <p>
         * Uses the <code>date-time</code> format specified in <a
         * href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet Date/Time Format</a>.
         * The value cannot contain spaces. For example, <code>2020-03-22T13:22:13.933Z</code>.
         * </p>
         * <p>
         * Array Members: Minimum number of 1 item. Maximum number of 20 items.
         * </p>
         * 
         * @param firstObservedAt
         *        A timestamp that indicates when the potential security issue captured by a finding was first observed
         *        by the security findings product. </p>
         *        <p>
         *        Uses the <code>date-time</code> format specified in <a
         *        href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet Date/Time
         *        Format</a>. The value cannot contain spaces. For example, <code>2020-03-22T13:22:13.933Z</code>.
         *        </p>
         *        <p>
         *        Array Members: Minimum number of 1 item. Maximum number of 20 items.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder firstObservedAt(DateFilter... firstObservedAt);

        /**
         * <p>
         * A timestamp that indicates when the potential security issue captured by a finding was first observed by the
         * security findings product.
         * </p>
         * <p>
         * Uses the <code>date-time</code> format specified in <a
         * href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet Date/Time Format</a>.
         * The value cannot contain spaces. For example, <code>2020-03-22T13:22:13.933Z</code>.
         * </p>
         * <p>
         * Array Members: Minimum number of 1 item. Maximum number of 20 items.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityhub.model.DateFilter.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.securityhub.model.DateFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityhub.model.DateFilter.Builder#build()} is called immediately
         * and its result is passed to {@link #firstObservedAt(List<DateFilter>)}.
         * 
         * @param firstObservedAt
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityhub.model.DateFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #firstObservedAt(java.util.Collection<DateFilter>)
         */
        Builder firstObservedAt(Consumer<DateFilter.Builder>... firstObservedAt);

        /**
         * <p>
         * A timestamp that indicates when the potential security issue captured by a finding was most recently observed
         * by the security findings product.
         * </p>
         * <p>
         * Uses the <code>date-time</code> format specified in <a
         * href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet Date/Time Format</a>.
         * The value cannot contain spaces. For example, <code>2020-03-22T13:22:13.933Z</code>.
         * </p>
         * <p>
         * Array Members: Minimum number of 1 item. Maximum number of 20 items.
         * </p>
         * 
         * @param lastObservedAt
         *        A timestamp that indicates when the potential security issue captured by a finding was most recently
         *        observed by the security findings product. </p>
         *        <p>
         *        Uses the <code>date-time</code> format specified in <a
         *        href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet Date/Time
         *        Format</a>. The value cannot contain spaces. For example, <code>2020-03-22T13:22:13.933Z</code>.
         *        </p>
         *        <p>
         *        Array Members: Minimum number of 1 item. Maximum number of 20 items.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastObservedAt(Collection<DateFilter> lastObservedAt);

        /**
         * <p>
         * A timestamp that indicates when the potential security issue captured by a finding was most recently observed
         * by the security findings product.
         * </p>
         * <p>
         * Uses the <code>date-time</code> format specified in <a
         * href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet Date/Time Format</a>.
         * The value cannot contain spaces. For example, <code>2020-03-22T13:22:13.933Z</code>.
         * </p>
         * <p>
         * Array Members: Minimum number of 1 item. Maximum number of 20 items.
         * </p>
         * 
         * @param lastObservedAt
         *        A timestamp that indicates when the potential security issue captured by a finding was most recently
         *        observed by the security findings product. </p>
         *        <p>
         *        Uses the <code>date-time</code> format specified in <a
         *        href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet Date/Time
         *        Format</a>. The value cannot contain spaces. For example, <code>2020-03-22T13:22:13.933Z</code>.
         *        </p>
         *        <p>
         *        Array Members: Minimum number of 1 item. Maximum number of 20 items.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastObservedAt(DateFilter... lastObservedAt);

        /**
         * <p>
         * A timestamp that indicates when the potential security issue captured by a finding was most recently observed
         * by the security findings product.
         * </p>
         * <p>
         * Uses the <code>date-time</code> format specified in <a
         * href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet Date/Time Format</a>.
         * The value cannot contain spaces. For example, <code>2020-03-22T13:22:13.933Z</code>.
         * </p>
         * <p>
         * Array Members: Minimum number of 1 item. Maximum number of 20 items.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityhub.model.DateFilter.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.securityhub.model.DateFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityhub.model.DateFilter.Builder#build()} is called immediately
         * and its result is passed to {@link #lastObservedAt(List<DateFilter>)}.
         * 
         * @param lastObservedAt
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityhub.model.DateFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lastObservedAt(java.util.Collection<DateFilter>)
         */
        Builder lastObservedAt(Consumer<DateFilter.Builder>... lastObservedAt);

        /**
         * <p>
         * A timestamp that indicates when this finding record was created.
         * </p>
         * <p>
         * Uses the <code>date-time</code> format specified in <a
         * href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet Date/Time Format</a>.
         * The value cannot contain spaces. For example, <code>2020-03-22T13:22:13.933Z</code>.
         * </p>
         * <p>
         * Array Members: Minimum number of 1 item. Maximum number of 20 items.
         * </p>
         * 
         * @param createdAt
         *        A timestamp that indicates when this finding record was created. </p>
         *        <p>
         *        Uses the <code>date-time</code> format specified in <a
         *        href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet Date/Time
         *        Format</a>. The value cannot contain spaces. For example, <code>2020-03-22T13:22:13.933Z</code>.
         *        </p>
         *        <p>
         *        Array Members: Minimum number of 1 item. Maximum number of 20 items.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Collection<DateFilter> createdAt);

        /**
         * <p>
         * A timestamp that indicates when this finding record was created.
         * </p>
         * <p>
         * Uses the <code>date-time</code> format specified in <a
         * href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet Date/Time Format</a>.
         * The value cannot contain spaces. For example, <code>2020-03-22T13:22:13.933Z</code>.
         * </p>
         * <p>
         * Array Members: Minimum number of 1 item. Maximum number of 20 items.
         * </p>
         * 
         * @param createdAt
         *        A timestamp that indicates when this finding record was created. </p>
         *        <p>
         *        Uses the <code>date-time</code> format specified in <a
         *        href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet Date/Time
         *        Format</a>. The value cannot contain spaces. For example, <code>2020-03-22T13:22:13.933Z</code>.
         *        </p>
         *        <p>
         *        Array Members: Minimum number of 1 item. Maximum number of 20 items.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(DateFilter... createdAt);

        /**
         * <p>
         * A timestamp that indicates when this finding record was created.
         * </p>
         * <p>
         * Uses the <code>date-time</code> format specified in <a
         * href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet Date/Time Format</a>.
         * The value cannot contain spaces. For example, <code>2020-03-22T13:22:13.933Z</code>.
         * </p>
         * <p>
         * Array Members: Minimum number of 1 item. Maximum number of 20 items.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityhub.model.DateFilter.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.securityhub.model.DateFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityhub.model.DateFilter.Builder#build()} is called immediately
         * and its result is passed to {@link #createdAt(List<DateFilter>)}.
         * 
         * @param createdAt
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityhub.model.DateFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #createdAt(java.util.Collection<DateFilter>)
         */
        Builder createdAt(Consumer<DateFilter.Builder>... createdAt);

        /**
         * <p>
         * A timestamp that indicates when the finding record was most recently updated.
         * </p>
         * <p>
         * Uses the <code>date-time</code> format specified in <a
         * href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet Date/Time Format</a>.
         * The value cannot contain spaces. For example, <code>2020-03-22T13:22:13.933Z</code>.
         * </p>
         * <p>
         * Array Members: Minimum number of 1 item. Maximum number of 20 items.
         * </p>
         * 
         * @param updatedAt
         *        A timestamp that indicates when the finding record was most recently updated. </p>
         *        <p>
         *        Uses the <code>date-time</code> format specified in <a
         *        href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet Date/Time
         *        Format</a>. The value cannot contain spaces. For example, <code>2020-03-22T13:22:13.933Z</code>.
         *        </p>
         *        <p>
         *        Array Members: Minimum number of 1 item. Maximum number of 20 items.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Collection<DateFilter> updatedAt);

        /**
         * <p>
         * A timestamp that indicates when the finding record was most recently updated.
         * </p>
         * <p>
         * Uses the <code>date-time</code> format specified in <a
         * href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet Date/Time Format</a>.
         * The value cannot contain spaces. For example, <code>2020-03-22T13:22:13.933Z</code>.
         * </p>
         * <p>
         * Array Members: Minimum number of 1 item. Maximum number of 20 items.
         * </p>
         * 
         * @param updatedAt
         *        A timestamp that indicates when the finding record was most recently updated. </p>
         *        <p>
         *        Uses the <code>date-time</code> format specified in <a
         *        href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet Date/Time
         *        Format</a>. The value cannot contain spaces. For example, <code>2020-03-22T13:22:13.933Z</code>.
         *        </p>
         *        <p>
         *        Array Members: Minimum number of 1 item. Maximum number of 20 items.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(DateFilter... updatedAt);

        /**
         * <p>
         * A timestamp that indicates when the finding record was most recently updated.
         * </p>
         * <p>
         * Uses the <code>date-time</code> format specified in <a
         * href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet Date/Time Format</a>.
         * The value cannot contain spaces. For example, <code>2020-03-22T13:22:13.933Z</code>.
         * </p>
         * <p>
         * Array Members: Minimum number of 1 item. Maximum number of 20 items.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityhub.model.DateFilter.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.securityhub.model.DateFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityhub.model.DateFilter.Builder#build()} is called immediately
         * and its result is passed to {@link #updatedAt(List<DateFilter>)}.
         * 
         * @param updatedAt
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityhub.model.DateFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #updatedAt(java.util.Collection<DateFilter>)
         */
        Builder updatedAt(Consumer<DateFilter.Builder>... updatedAt);

        /**
         * <p>
         * The likelihood that a finding accurately identifies the behavior or issue that it was intended to identify.
         * <code>Confidence</code> is scored on a 0–100 basis using a ratio scale. A value of <code>0</code> means 0
         * percent confidence, and a value of <code>100</code> means 100 percent confidence. For example, a data
         * exfiltration detection based on a statistical deviation of network traffic has low confidence because an
         * actual exfiltration hasn't been verified. For more information, see <a href=
         * "https://docs.aws.amazon.com/securityhub/latest/userguide/asff-top-level-attributes.html#asff-confidence"
         * >Confidence</a> in the <i>Security Hub User Guide</i>.
         * </p>
         * <p>
         * Array Members: Minimum number of 1 item. Maximum number of 20 items.
         * </p>
         * 
         * @param confidence
         *        The likelihood that a finding accurately identifies the behavior or issue that it was intended to
         *        identify. <code>Confidence</code> is scored on a 0–100 basis using a ratio scale. A value of
         *        <code>0</code> means 0 percent confidence, and a value of <code>100</code> means 100 percent
         *        confidence. For example, a data exfiltration detection based on a statistical deviation of network
         *        traffic has low confidence because an actual exfiltration hasn't been verified. For more information,
         *        see <a href=
         *        "https://docs.aws.amazon.com/securityhub/latest/userguide/asff-top-level-attributes.html#asff-confidence"
         *        >Confidence</a> in the <i>Security Hub User Guide</i>.</p>
         *        <p>
         *        Array Members: Minimum number of 1 item. Maximum number of 20 items.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder confidence(Collection<NumberFilter> confidence);

        /**
         * <p>
         * The likelihood that a finding accurately identifies the behavior or issue that it was intended to identify.
         * <code>Confidence</code> is scored on a 0–100 basis using a ratio scale. A value of <code>0</code> means 0
         * percent confidence, and a value of <code>100</code> means 100 percent confidence. For example, a data
         * exfiltration detection based on a statistical deviation of network traffic has low confidence because an
         * actual exfiltration hasn't been verified. For more information, see <a href=
         * "https://docs.aws.amazon.com/securityhub/latest/userguide/asff-top-level-attributes.html#asff-confidence"
         * >Confidence</a> in the <i>Security Hub User Guide</i>.
         * </p>
         * <p>
         * Array Members: Minimum number of 1 item. Maximum number of 20 items.
         * </p>
         * 
         * @param confidence
         *        The likelihood that a finding accurately identifies the behavior or issue that it was intended to
         *        identify. <code>Confidence</code> is scored on a 0–100 basis using a ratio scale. A value of
         *        <code>0</code> means 0 percent confidence, and a value of <code>100</code> means 100 percent
         *        confidence. For example, a data exfiltration detection based on a statistical deviation of network
         *        traffic has low confidence because an actual exfiltration hasn't been verified. For more information,
         *        see <a href=
         *        "https://docs.aws.amazon.com/securityhub/latest/userguide/asff-top-level-attributes.html#asff-confidence"
         *        >Confidence</a> in the <i>Security Hub User Guide</i>.</p>
         *        <p>
         *        Array Members: Minimum number of 1 item. Maximum number of 20 items.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder confidence(NumberFilter... confidence);

        /**
         * <p>
         * The likelihood that a finding accurately identifies the behavior or issue that it was intended to identify.
         * <code>Confidence</code> is scored on a 0–100 basis using a ratio scale. A value of <code>0</code> means 0
         * percent confidence, and a value of <code>100</code> means 100 percent confidence. For example, a data
         * exfiltration detection based on a statistical deviation of network traffic has low confidence because an
         * actual exfiltration hasn't been verified. For more information, see <a href=
         * "https://docs.aws.amazon.com/securityhub/latest/userguide/asff-top-level-attributes.html#asff-confidence"
         * >Confidence</a> in the <i>Security Hub User Guide</i>.
         * </p>
         * <p>
         * Array Members: Minimum number of 1 item. Maximum number of 20 items.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityhub.model.NumberFilter.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.securityhub.model.NumberFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityhub.model.NumberFilter.Builder#build()} is called immediately
         * and its result is passed to {@link #confidence(List<NumberFilter>)}.
         * 
         * @param confidence
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityhub.model.NumberFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #confidence(java.util.Collection<NumberFilter>)
         */
        Builder confidence(Consumer<NumberFilter.Builder>... confidence);

        /**
         * <p>
         * The level of importance that is assigned to the resources that are associated with a finding.
         * <code>Criticality</code> is scored on a 0–100 basis, using a ratio scale that supports only full integers. A
         * score of <code>0</code> means that the underlying resources have no criticality, and a score of
         * <code>100</code> is reserved for the most critical resources. For more information, see <a href=
         * "https://docs.aws.amazon.com/securityhub/latest/userguide/asff-top-level-attributes.html#asff-criticality"
         * >Criticality</a> in the <i>Security Hub User Guide</i>.
         * </p>
         * <p>
         * Array Members: Minimum number of 1 item. Maximum number of 20 items.
         * </p>
         * 
         * @param criticality
         *        The level of importance that is assigned to the resources that are associated with a finding.
         *        <code>Criticality</code> is scored on a 0–100 basis, using a ratio scale that supports only full
         *        integers. A score of <code>0</code> means that the underlying resources have no criticality, and a
         *        score of <code>100</code> is reserved for the most critical resources. For more information, see <a
         *        href=
         *        "https://docs.aws.amazon.com/securityhub/latest/userguide/asff-top-level-attributes.html#asff-criticality"
         *        >Criticality</a> in the <i>Security Hub User Guide</i>.</p>
         *        <p>
         *        Array Members: Minimum number of 1 item. Maximum number of 20 items.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder criticality(Collection<NumberFilter> criticality);

        /**
         * <p>
         * The level of importance that is assigned to the resources that are associated with a finding.
         * <code>Criticality</code> is scored on a 0–100 basis, using a ratio scale that supports only full integers. A
         * score of <code>0</code> means that the underlying resources have no criticality, and a score of
         * <code>100</code> is reserved for the most critical resources. For more information, see <a href=
         * "https://docs.aws.amazon.com/securityhub/latest/userguide/asff-top-level-attributes.html#asff-criticality"
         * >Criticality</a> in the <i>Security Hub User Guide</i>.
         * </p>
         * <p>
         * Array Members: Minimum number of 1 item. Maximum number of 20 items.
         * </p>
         * 
         * @param criticality
         *        The level of importance that is assigned to the resources that are associated with a finding.
         *        <code>Criticality</code> is scored on a 0–100 basis, using a ratio scale that supports only full
         *        integers. A score of <code>0</code> means that the underlying resources have no criticality, and a
         *        score of <code>100</code> is reserved for the most critical resources. For more information, see <a
         *        href=
         *        "https://docs.aws.amazon.com/securityhub/latest/userguide/asff-top-level-attributes.html#asff-criticality"
         *        >Criticality</a> in the <i>Security Hub User Guide</i>.</p>
         *        <p>
         *        Array Members: Minimum number of 1 item. Maximum number of 20 items.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder criticality(NumberFilter... criticality);

        /**
         * <p>
         * The level of importance that is assigned to the resources that are associated with a finding.
         * <code>Criticality</code> is scored on a 0–100 basis, using a ratio scale that supports only full integers. A
         * score of <code>0</code> means that the underlying resources have no criticality, and a score of
         * <code>100</code> is reserved for the most critical resources. For more information, see <a href=
         * "https://docs.aws.amazon.com/securityhub/latest/userguide/asff-top-level-attributes.html#asff-criticality"
         * >Criticality</a> in the <i>Security Hub User Guide</i>.
         * </p>
         * <p>
         * Array Members: Minimum number of 1 item. Maximum number of 20 items.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityhub.model.NumberFilter.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.securityhub.model.NumberFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityhub.model.NumberFilter.Builder#build()} is called immediately
         * and its result is passed to {@link #criticality(List<NumberFilter>)}.
         * 
         * @param criticality
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityhub.model.NumberFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #criticality(java.util.Collection<NumberFilter>)
         */
        Builder criticality(Consumer<NumberFilter.Builder>... criticality);

        /**
         * <p>
         * A finding's title.
         * </p>
         * <p>
         * Array Members: Minimum number of 1 item. Maximum number of 100 items.
         * </p>
         * 
         * @param title
         *        A finding's title. </p>
         *        <p>
         *        Array Members: Minimum number of 1 item. Maximum number of 100 items.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder title(Collection<StringFilter> title);

        /**
         * <p>
         * A finding's title.
         * </p>
         * <p>
         * Array Members: Minimum number of 1 item. Maximum number of 100 items.
         * </p>
         * 
         * @param title
         *        A finding's title. </p>
         *        <p>
         *        Array Members: Minimum number of 1 item. Maximum number of 100 items.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder title(StringFilter... title);

        /**
         * <p>
         * A finding's title.
         * </p>
         * <p>
         * Array Members: Minimum number of 1 item. Maximum number of 100 items.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityhub.model.StringFilter.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.securityhub.model.StringFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityhub.model.StringFilter.Builder#build()} is called immediately
         * and its result is passed to {@link #title(List<StringFilter>)}.
         * 
         * @param title
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityhub.model.StringFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #title(java.util.Collection<StringFilter>)
         */
        Builder title(Consumer<StringFilter.Builder>... title);

        /**
         * <p>
         * A finding's description.
         * </p>
         * <p>
         * Array Members: Minimum number of 1 item. Maximum number of 20 items.
         * </p>
         * 
         * @param description
         *        A finding's description. </p>
         *        <p>
         *        Array Members: Minimum number of 1 item. Maximum number of 20 items.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(Collection<StringFilter> description);

        /**
         * <p>
         * A finding's description.
         * </p>
         * <p>
         * Array Members: Minimum number of 1 item. Maximum number of 20 items.
         * </p>
         * 
         * @param description
         *        A finding's description. </p>
         *        <p>
         *        Array Members: Minimum number of 1 item. Maximum number of 20 items.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(StringFilter... description);

        /**
         * <p>
         * A finding's description.
         * </p>
         * <p>
         * Array Members: Minimum number of 1 item. Maximum number of 20 items.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityhub.model.StringFilter.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.securityhub.model.StringFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityhub.model.StringFilter.Builder#build()} is called immediately
         * and its result is passed to {@link #description(List<StringFilter>)}.
         * 
         * @param description
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityhub.model.StringFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #description(java.util.Collection<StringFilter>)
         */
        Builder description(Consumer<StringFilter.Builder>... description);

        /**
         * <p>
         * Provides a URL that links to a page about the current finding in the finding product.
         * </p>
         * <p>
         * Array Members: Minimum number of 1 item. Maximum number of 20 items.
         * </p>
         * 
         * @param sourceUrl
         *        Provides a URL that links to a page about the current finding in the finding product. </p>
         *        <p>
         *        Array Members: Minimum number of 1 item. Maximum number of 20 items.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceUrl(Collection<StringFilter> sourceUrl);

        /**
         * <p>
         * Provides a URL that links to a page about the current finding in the finding product.
         * </p>
         * <p>
         * Array Members: Minimum number of 1 item. Maximum number of 20 items.
         * </p>
         * 
         * @param sourceUrl
         *        Provides a URL that links to a page about the current finding in the finding product. </p>
         *        <p>
         *        Array Members: Minimum number of 1 item. Maximum number of 20 items.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceUrl(StringFilter... sourceUrl);

        /**
         * <p>
         * Provides a URL that links to a page about the current finding in the finding product.
         * </p>
         * <p>
         * Array Members: Minimum number of 1 item. Maximum number of 20 items.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityhub.model.StringFilter.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.securityhub.model.StringFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityhub.model.StringFilter.Builder#build()} is called immediately
         * and its result is passed to {@link #sourceUrl(List<StringFilter>)}.
         * 
         * @param sourceUrl
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityhub.model.StringFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sourceUrl(java.util.Collection<StringFilter>)
         */
        Builder sourceUrl(Consumer<StringFilter.Builder>... sourceUrl);

        /**
         * <p>
         * Provides the name of the product that generated the finding. For control-based findings, the product name is
         * Security Hub.
         * </p>
         * <p>
         * Array Members: Minimum number of 1 item. Maximum number of 20 items.
         * </p>
         * 
         * @param productName
         *        Provides the name of the product that generated the finding. For control-based findings, the product
         *        name is Security Hub. </p>
         *        <p>
         *        Array Members: Minimum number of 1 item. Maximum number of 20 items.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productName(Collection<StringFilter> productName);

        /**
         * <p>
         * Provides the name of the product that generated the finding. For control-based findings, the product name is
         * Security Hub.
         * </p>
         * <p>
         * Array Members: Minimum number of 1 item. Maximum number of 20 items.
         * </p>
         * 
         * @param productName
         *        Provides the name of the product that generated the finding. For control-based findings, the product
         *        name is Security Hub. </p>
         *        <p>
         *        Array Members: Minimum number of 1 item. Maximum number of 20 items.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productName(StringFilter... productName);

        /**
         * <p>
         * Provides the name of the product that generated the finding. For control-based findings, the product name is
         * Security Hub.
         * </p>
         * <p>
         * Array Members: Minimum number of 1 item. Maximum number of 20 items.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityhub.model.StringFilter.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.securityhub.model.StringFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityhub.model.StringFilter.Builder#build()} is called immediately
         * and its result is passed to {@link #productName(List<StringFilter>)}.
         * 
         * @param productName
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityhub.model.StringFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #productName(java.util.Collection<StringFilter>)
         */
        Builder productName(Consumer<StringFilter.Builder>... productName);

        /**
         * <p>
         * The name of the company for the product that generated the finding. For control-based findings, the company
         * is Amazon Web Services.
         * </p>
         * <p>
         * Array Members: Minimum number of 1 item. Maximum number of 20 items.
         * </p>
         * 
         * @param companyName
         *        The name of the company for the product that generated the finding. For control-based findings, the
         *        company is Amazon Web Services. </p>
         *        <p>
         *        Array Members: Minimum number of 1 item. Maximum number of 20 items.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder companyName(Collection<StringFilter> companyName);

        /**
         * <p>
         * The name of the company for the product that generated the finding. For control-based findings, the company
         * is Amazon Web Services.
         * </p>
         * <p>
         * Array Members: Minimum number of 1 item. Maximum number of 20 items.
         * </p>
         * 
         * @param companyName
         *        The name of the company for the product that generated the finding. For control-based findings, the
         *        company is Amazon Web Services. </p>
         *        <p>
         *        Array Members: Minimum number of 1 item. Maximum number of 20 items.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder companyName(StringFilter... companyName);

        /**
         * <p>
         * The name of the company for the product that generated the finding. For control-based findings, the company
         * is Amazon Web Services.
         * </p>
         * <p>
         * Array Members: Minimum number of 1 item. Maximum number of 20 items.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityhub.model.StringFilter.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.securityhub.model.StringFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityhub.model.StringFilter.Builder#build()} is called immediately
         * and its result is passed to {@link #companyName(List<StringFilter>)}.
         * 
         * @param companyName
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityhub.model.StringFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #companyName(java.util.Collection<StringFilter>)
         */
        Builder companyName(Consumer<StringFilter.Builder>... companyName);

        /**
         * <p>
         * The severity value of the finding.
         * </p>
         * <p>
         * Array Members: Minimum number of 1 item. Maximum number of 20 items.
         * </p>
         * 
         * @param severityLabel
         *        The severity value of the finding. </p>
         *        <p>
         *        Array Members: Minimum number of 1 item. Maximum number of 20 items.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder severityLabel(Collection<StringFilter> severityLabel);

        /**
         * <p>
         * The severity value of the finding.
         * </p>
         * <p>
         * Array Members: Minimum number of 1 item. Maximum number of 20 items.
         * </p>
         * 
         * @param severityLabel
         *        The severity value of the finding. </p>
         *        <p>
         *        Array Members: Minimum number of 1 item. Maximum number of 20 items.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder severityLabel(StringFilter... severityLabel);

        /**
         * <p>
         * The severity value of the finding.
         * </p>
         * <p>
         * Array Members: Minimum number of 1 item. Maximum number of 20 items.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityhub.model.StringFilter.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.securityhub.model.StringFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityhub.model.StringFilter.Builder#build()} is called immediately
         * and its result is passed to {@link #severityLabel(List<StringFilter>)}.
         * 
         * @param severityLabel
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityhub.model.StringFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #severityLabel(java.util.Collection<StringFilter>)
         */
        Builder severityLabel(Consumer<StringFilter.Builder>... severityLabel);

        /**
         * <p>
         * The type of resource that the finding pertains to.
         * </p>
         * <p>
         * Array Members: Minimum number of 1 item. Maximum number of 20 items.
         * </p>
         * 
         * @param resourceType
         *        The type of resource that the finding pertains to. </p>
         *        <p>
         *        Array Members: Minimum number of 1 item. Maximum number of 20 items.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceType(Collection<StringFilter> resourceType);

        /**
         * <p>
         * The type of resource that the finding pertains to.
         * </p>
         * <p>
         * Array Members: Minimum number of 1 item. Maximum number of 20 items.
         * </p>
         * 
         * @param resourceType
         *        The type of resource that the finding pertains to. </p>
         *        <p>
         *        Array Members: Minimum number of 1 item. Maximum number of 20 items.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceType(StringFilter... resourceType);

        /**
         * <p>
         * The type of resource that the finding pertains to.
         * </p>
         * <p>
         * Array Members: Minimum number of 1 item. Maximum number of 20 items.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityhub.model.StringFilter.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.securityhub.model.StringFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityhub.model.StringFilter.Builder#build()} is called immediately
         * and its result is passed to {@link #resourceType(List<StringFilter>)}.
         * 
         * @param resourceType
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityhub.model.StringFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceType(java.util.Collection<StringFilter>)
         */
        Builder resourceType(Consumer<StringFilter.Builder>... resourceType);

        /**
         * <p>
         * The identifier for the given resource type. For Amazon Web Services resources that are identified by Amazon
         * Resource Names (ARNs), this is the ARN. For Amazon Web Services resources that lack ARNs, this is the
         * identifier as defined by the Amazon Web Service that created the resource. For non-Amazon Web Services
         * resources, this is a unique identifier that is associated with the resource.
         * </p>
         * <p>
         * Array Members: Minimum number of 1 item. Maximum number of 100 items.
         * </p>
         * 
         * @param resourceId
         *        The identifier for the given resource type. For Amazon Web Services resources that are identified by
         *        Amazon Resource Names (ARNs), this is the ARN. For Amazon Web Services resources that lack ARNs, this
         *        is the identifier as defined by the Amazon Web Service that created the resource. For non-Amazon Web
         *        Services resources, this is a unique identifier that is associated with the resource. </p>
         *        <p>
         *        Array Members: Minimum number of 1 item. Maximum number of 100 items.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceId(Collection<StringFilter> resourceId);

        /**
         * <p>
         * The identifier for the given resource type. For Amazon Web Services resources that are identified by Amazon
         * Resource Names (ARNs), this is the ARN. For Amazon Web Services resources that lack ARNs, this is the
         * identifier as defined by the Amazon Web Service that created the resource. For non-Amazon Web Services
         * resources, this is a unique identifier that is associated with the resource.
         * </p>
         * <p>
         * Array Members: Minimum number of 1 item. Maximum number of 100 items.
         * </p>
         * 
         * @param resourceId
         *        The identifier for the given resource type. For Amazon Web Services resources that are identified by
         *        Amazon Resource Names (ARNs), this is the ARN. For Amazon Web Services resources that lack ARNs, this
         *        is the identifier as defined by the Amazon Web Service that created the resource. For non-Amazon Web
         *        Services resources, this is a unique identifier that is associated with the resource. </p>
         *        <p>
         *        Array Members: Minimum number of 1 item. Maximum number of 100 items.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceId(StringFilter... resourceId);

        /**
         * <p>
         * The identifier for the given resource type. For Amazon Web Services resources that are identified by Amazon
         * Resource Names (ARNs), this is the ARN. For Amazon Web Services resources that lack ARNs, this is the
         * identifier as defined by the Amazon Web Service that created the resource. For non-Amazon Web Services
         * resources, this is a unique identifier that is associated with the resource.
         * </p>
         * <p>
         * Array Members: Minimum number of 1 item. Maximum number of 100 items.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityhub.model.StringFilter.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.securityhub.model.StringFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityhub.model.StringFilter.Builder#build()} is called immediately
         * and its result is passed to {@link #resourceId(List<StringFilter>)}.
         * 
         * @param resourceId
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityhub.model.StringFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceId(java.util.Collection<StringFilter>)
         */
        Builder resourceId(Consumer<StringFilter.Builder>... resourceId);

        /**
         * <p>
         * The partition in which the resource that the finding pertains to is located. A partition is a group of Amazon
         * Web Services Regions. Each Amazon Web Services account is scoped to one partition.
         * </p>
         * <p>
         * Array Members: Minimum number of 1 item. Maximum number of 20 items.
         * </p>
         * 
         * @param resourcePartition
         *        The partition in which the resource that the finding pertains to is located. A partition is a group of
         *        Amazon Web Services Regions. Each Amazon Web Services account is scoped to one partition. </p>
         *        <p>
         *        Array Members: Minimum number of 1 item. Maximum number of 20 items.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourcePartition(Collection<StringFilter> resourcePartition);

        /**
         * <p>
         * The partition in which the resource that the finding pertains to is located. A partition is a group of Amazon
         * Web Services Regions. Each Amazon Web Services account is scoped to one partition.
         * </p>
         * <p>
         * Array Members: Minimum number of 1 item. Maximum number of 20 items.
         * </p>
         * 
         * @param resourcePartition
         *        The partition in which the resource that the finding pertains to is located. A partition is a group of
         *        Amazon Web Services Regions. Each Amazon Web Services account is scoped to one partition. </p>
         *        <p>
         *        Array Members: Minimum number of 1 item. Maximum number of 20 items.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourcePartition(StringFilter... resourcePartition);

        /**
         * <p>
         * The partition in which the resource that the finding pertains to is located. A partition is a group of Amazon
         * Web Services Regions. Each Amazon Web Services account is scoped to one partition.
         * </p>
         * <p>
         * Array Members: Minimum number of 1 item. Maximum number of 20 items.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityhub.model.StringFilter.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.securityhub.model.StringFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityhub.model.StringFilter.Builder#build()} is called immediately
         * and its result is passed to {@link #resourcePartition(List<StringFilter>)}.
         * 
         * @param resourcePartition
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityhub.model.StringFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourcePartition(java.util.Collection<StringFilter>)
         */
        Builder resourcePartition(Consumer<StringFilter.Builder>... resourcePartition);

        /**
         * <p>
         * The Amazon Web Services Region where the resource that a finding pertains to is located.
         * </p>
         * <p>
         * Array Members: Minimum number of 1 item. Maximum number of 20 items.
         * </p>
         * 
         * @param resourceRegion
         *        The Amazon Web Services Region where the resource that a finding pertains to is located. </p>
         *        <p>
         *        Array Members: Minimum number of 1 item. Maximum number of 20 items.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceRegion(Collection<StringFilter> resourceRegion);

        /**
         * <p>
         * The Amazon Web Services Region where the resource that a finding pertains to is located.
         * </p>
         * <p>
         * Array Members: Minimum number of 1 item. Maximum number of 20 items.
         * </p>
         * 
         * @param resourceRegion
         *        The Amazon Web Services Region where the resource that a finding pertains to is located. </p>
         *        <p>
         *        Array Members: Minimum number of 1 item. Maximum number of 20 items.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceRegion(StringFilter... resourceRegion);

        /**
         * <p>
         * The Amazon Web Services Region where the resource that a finding pertains to is located.
         * </p>
         * <p>
         * Array Members: Minimum number of 1 item. Maximum number of 20 items.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityhub.model.StringFilter.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.securityhub.model.StringFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityhub.model.StringFilter.Builder#build()} is called immediately
         * and its result is passed to {@link #resourceRegion(List<StringFilter>)}.
         * 
         * @param resourceRegion
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityhub.model.StringFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceRegion(java.util.Collection<StringFilter>)
         */
        Builder resourceRegion(Consumer<StringFilter.Builder>... resourceRegion);

        /**
         * <p>
         * A list of Amazon Web Services tags associated with a resource at the time the finding was processed.
         * </p>
         * <p>
         * Array Members: Minimum number of 1 item. Maximum number of 20 items.
         * </p>
         * 
         * @param resourceTags
         *        A list of Amazon Web Services tags associated with a resource at the time the finding was processed.
         *        </p>
         *        <p>
         *        Array Members: Minimum number of 1 item. Maximum number of 20 items.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceTags(Collection<MapFilter> resourceTags);

        /**
         * <p>
         * A list of Amazon Web Services tags associated with a resource at the time the finding was processed.
         * </p>
         * <p>
         * Array Members: Minimum number of 1 item. Maximum number of 20 items.
         * </p>
         * 
         * @param resourceTags
         *        A list of Amazon Web Services tags associated with a resource at the time the finding was processed.
         *        </p>
         *        <p>
         *        Array Members: Minimum number of 1 item. Maximum number of 20 items.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceTags(MapFilter... resourceTags);

        /**
         * <p>
         * A list of Amazon Web Services tags associated with a resource at the time the finding was processed.
         * </p>
         * <p>
         * Array Members: Minimum number of 1 item. Maximum number of 20 items.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityhub.model.MapFilter.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.securityhub.model.MapFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityhub.model.MapFilter.Builder#build()} is called immediately and
         * its result is passed to {@link #resourceTags(List<MapFilter>)}.
         * 
         * @param resourceTags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityhub.model.MapFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceTags(java.util.Collection<MapFilter>)
         */
        Builder resourceTags(Consumer<MapFilter.Builder>... resourceTags);

        /**
         * <p>
         * Custom fields and values about the resource that a finding pertains to.
         * </p>
         * <p>
         * Array Members: Minimum number of 1 item. Maximum number of 20 items.
         * </p>
         * 
         * @param resourceDetailsOther
         *        Custom fields and values about the resource that a finding pertains to. </p>
         *        <p>
         *        Array Members: Minimum number of 1 item. Maximum number of 20 items.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceDetailsOther(Collection<MapFilter> resourceDetailsOther);

        /**
         * <p>
         * Custom fields and values about the resource that a finding pertains to.
         * </p>
         * <p>
         * Array Members: Minimum number of 1 item. Maximum number of 20 items.
         * </p>
         * 
         * @param resourceDetailsOther
         *        Custom fields and values about the resource that a finding pertains to. </p>
         *        <p>
         *        Array Members: Minimum number of 1 item. Maximum number of 20 items.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceDetailsOther(MapFilter... resourceDetailsOther);

        /**
         * <p>
         * Custom fields and values about the resource that a finding pertains to.
         * </p>
         * <p>
         * Array Members: Minimum number of 1 item. Maximum number of 20 items.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityhub.model.MapFilter.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.securityhub.model.MapFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityhub.model.MapFilter.Builder#build()} is called immediately and
         * its result is passed to {@link #resourceDetailsOther(List<MapFilter>)}.
         * 
         * @param resourceDetailsOther
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityhub.model.MapFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceDetailsOther(java.util.Collection<MapFilter>)
         */
        Builder resourceDetailsOther(Consumer<MapFilter.Builder>... resourceDetailsOther);

        /**
         * <p>
         * The result of a security check. This field is only used for findings generated from controls.
         * </p>
         * <p>
         * Array Members: Minimum number of 1 item. Maximum number of 20 items.
         * </p>
         * 
         * @param complianceStatus
         *        The result of a security check. This field is only used for findings generated from controls. </p>
         *        <p>
         *        Array Members: Minimum number of 1 item. Maximum number of 20 items.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder complianceStatus(Collection<StringFilter> complianceStatus);

        /**
         * <p>
         * The result of a security check. This field is only used for findings generated from controls.
         * </p>
         * <p>
         * Array Members: Minimum number of 1 item. Maximum number of 20 items.
         * </p>
         * 
         * @param complianceStatus
         *        The result of a security check. This field is only used for findings generated from controls. </p>
         *        <p>
         *        Array Members: Minimum number of 1 item. Maximum number of 20 items.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder complianceStatus(StringFilter... complianceStatus);

        /**
         * <p>
         * The result of a security check. This field is only used for findings generated from controls.
         * </p>
         * <p>
         * Array Members: Minimum number of 1 item. Maximum number of 20 items.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityhub.model.StringFilter.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.securityhub.model.StringFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityhub.model.StringFilter.Builder#build()} is called immediately
         * and its result is passed to {@link #complianceStatus(List<StringFilter>)}.
         * 
         * @param complianceStatus
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityhub.model.StringFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #complianceStatus(java.util.Collection<StringFilter>)
         */
        Builder complianceStatus(Consumer<StringFilter.Builder>... complianceStatus);

        /**
         * <p>
         * The security control ID for which a finding was generated. Security control IDs are the same across
         * standards.
         * </p>
         * <p>
         * Array Members: Minimum number of 1 item. Maximum number of 20 items.
         * </p>
         * 
         * @param complianceSecurityControlId
         *        The security control ID for which a finding was generated. Security control IDs are the same across
         *        standards.</p>
         *        <p>
         *        Array Members: Minimum number of 1 item. Maximum number of 20 items.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder complianceSecurityControlId(Collection<StringFilter> complianceSecurityControlId);

        /**
         * <p>
         * The security control ID for which a finding was generated. Security control IDs are the same across
         * standards.
         * </p>
         * <p>
         * Array Members: Minimum number of 1 item. Maximum number of 20 items.
         * </p>
         * 
         * @param complianceSecurityControlId
         *        The security control ID for which a finding was generated. Security control IDs are the same across
         *        standards.</p>
         *        <p>
         *        Array Members: Minimum number of 1 item. Maximum number of 20 items.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder complianceSecurityControlId(StringFilter... complianceSecurityControlId);

        /**
         * <p>
         * The security control ID for which a finding was generated. Security control IDs are the same across
         * standards.
         * </p>
         * <p>
         * Array Members: Minimum number of 1 item. Maximum number of 20 items.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityhub.model.StringFilter.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.securityhub.model.StringFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityhub.model.StringFilter.Builder#build()} is called immediately
         * and its result is passed to {@link #complianceSecurityControlId(List<StringFilter>)}.
         * 
         * @param complianceSecurityControlId
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityhub.model.StringFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #complianceSecurityControlId(java.util.Collection<StringFilter>)
         */
        Builder complianceSecurityControlId(Consumer<StringFilter.Builder>... complianceSecurityControlId);

        /**
         * <p>
         * The unique identifier of a standard in which a control is enabled. This field consists of the resource
         * portion of the Amazon Resource Name (ARN) returned for a standard in the <a
         * href="https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_DescribeStandards.html"
         * >DescribeStandards</a> API response.
         * </p>
         * <p>
         * Array Members: Minimum number of 1 item. Maximum number of 20 items.
         * </p>
         * 
         * @param complianceAssociatedStandardsId
         *        The unique identifier of a standard in which a control is enabled. This field consists of the resource
         *        portion of the Amazon Resource Name (ARN) returned for a standard in the <a
         *        href="https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_DescribeStandards.html"
         *        >DescribeStandards</a> API response.</p>
         *        <p>
         *        Array Members: Minimum number of 1 item. Maximum number of 20 items.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder complianceAssociatedStandardsId(Collection<StringFilter> complianceAssociatedStandardsId);

        /**
         * <p>
         * The unique identifier of a standard in which a control is enabled. This field consists of the resource
         * portion of the Amazon Resource Name (ARN) returned for a standard in the <a
         * href="https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_DescribeStandards.html"
         * >DescribeStandards</a> API response.
         * </p>
         * <p>
         * Array Members: Minimum number of 1 item. Maximum number of 20 items.
         * </p>
         * 
         * @param complianceAssociatedStandardsId
         *        The unique identifier of a standard in which a control is enabled. This field consists of the resource
         *        portion of the Amazon Resource Name (ARN) returned for a standard in the <a
         *        href="https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_DescribeStandards.html"
         *        >DescribeStandards</a> API response.</p>
         *        <p>
         *        Array Members: Minimum number of 1 item. Maximum number of 20 items.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder complianceAssociatedStandardsId(StringFilter... complianceAssociatedStandardsId);

        /**
         * <p>
         * The unique identifier of a standard in which a control is enabled. This field consists of the resource
         * portion of the Amazon Resource Name (ARN) returned for a standard in the <a
         * href="https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_DescribeStandards.html"
         * >DescribeStandards</a> API response.
         * </p>
         * <p>
         * Array Members: Minimum number of 1 item. Maximum number of 20 items.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityhub.model.StringFilter.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.securityhub.model.StringFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityhub.model.StringFilter.Builder#build()} is called immediately
         * and its result is passed to {@link #complianceAssociatedStandardsId(List<StringFilter>)}.
         * 
         * @param complianceAssociatedStandardsId
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityhub.model.StringFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #complianceAssociatedStandardsId(java.util.Collection<StringFilter>)
         */
        Builder complianceAssociatedStandardsId(Consumer<StringFilter.Builder>... complianceAssociatedStandardsId);

        /**
         * <p>
         * Provides the veracity of a finding.
         * </p>
         * <p>
         * Array Members: Minimum number of 1 item. Maximum number of 20 items.
         * </p>
         * 
         * @param verificationState
         *        Provides the veracity of a finding. </p>
         *        <p>
         *        Array Members: Minimum number of 1 item. Maximum number of 20 items.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder verificationState(Collection<StringFilter> verificationState);

        /**
         * <p>
         * Provides the veracity of a finding.
         * </p>
         * <p>
         * Array Members: Minimum number of 1 item. Maximum number of 20 items.
         * </p>
         * 
         * @param verificationState
         *        Provides the veracity of a finding. </p>
         *        <p>
         *        Array Members: Minimum number of 1 item. Maximum number of 20 items.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder verificationState(StringFilter... verificationState);

        /**
         * <p>
         * Provides the veracity of a finding.
         * </p>
         * <p>
         * Array Members: Minimum number of 1 item. Maximum number of 20 items.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityhub.model.StringFilter.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.securityhub.model.StringFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityhub.model.StringFilter.Builder#build()} is called immediately
         * and its result is passed to {@link #verificationState(List<StringFilter>)}.
         * 
         * @param verificationState
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityhub.model.StringFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #verificationState(java.util.Collection<StringFilter>)
         */
        Builder verificationState(Consumer<StringFilter.Builder>... verificationState);

        /**
         * <p>
         * Provides information about the status of the investigation into a finding.
         * </p>
         * <p>
         * Array Members: Minimum number of 1 item. Maximum number of 20 items.
         * </p>
         * 
         * @param workflowStatus
         *        Provides information about the status of the investigation into a finding. </p>
         *        <p>
         *        Array Members: Minimum number of 1 item. Maximum number of 20 items.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workflowStatus(Collection<StringFilter> workflowStatus);

        /**
         * <p>
         * Provides information about the status of the investigation into a finding.
         * </p>
         * <p>
         * Array Members: Minimum number of 1 item. Maximum number of 20 items.
         * </p>
         * 
         * @param workflowStatus
         *        Provides information about the status of the investigation into a finding. </p>
         *        <p>
         *        Array Members: Minimum number of 1 item. Maximum number of 20 items.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workflowStatus(StringFilter... workflowStatus);

        /**
         * <p>
         * Provides information about the status of the investigation into a finding.
         * </p>
         * <p>
         * Array Members: Minimum number of 1 item. Maximum number of 20 items.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityhub.model.StringFilter.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.securityhub.model.StringFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityhub.model.StringFilter.Builder#build()} is called immediately
         * and its result is passed to {@link #workflowStatus(List<StringFilter>)}.
         * 
         * @param workflowStatus
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityhub.model.StringFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #workflowStatus(java.util.Collection<StringFilter>)
         */
        Builder workflowStatus(Consumer<StringFilter.Builder>... workflowStatus);

        /**
         * <p>
         * Provides the current state of a finding.
         * </p>
         * <p>
         * Array Members: Minimum number of 1 item. Maximum number of 20 items.
         * </p>
         * 
         * @param recordState
         *        Provides the current state of a finding. </p>
         *        <p>
         *        Array Members: Minimum number of 1 item. Maximum number of 20 items.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recordState(Collection<StringFilter> recordState);

        /**
         * <p>
         * Provides the current state of a finding.
         * </p>
         * <p>
         * Array Members: Minimum number of 1 item. Maximum number of 20 items.
         * </p>
         * 
         * @param recordState
         *        Provides the current state of a finding. </p>
         *        <p>
         *        Array Members: Minimum number of 1 item. Maximum number of 20 items.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recordState(StringFilter... recordState);

        /**
         * <p>
         * Provides the current state of a finding.
         * </p>
         * <p>
         * Array Members: Minimum number of 1 item. Maximum number of 20 items.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityhub.model.StringFilter.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.securityhub.model.StringFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityhub.model.StringFilter.Builder#build()} is called immediately
         * and its result is passed to {@link #recordState(List<StringFilter>)}.
         * 
         * @param recordState
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityhub.model.StringFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #recordState(java.util.Collection<StringFilter>)
         */
        Builder recordState(Consumer<StringFilter.Builder>... recordState);

        /**
         * <p>
         * The ARN for the product that generated a related finding.
         * </p>
         * <p>
         * Array Members: Minimum number of 1 item. Maximum number of 20 items.
         * </p>
         * 
         * @param relatedFindingsProductArn
         *        The ARN for the product that generated a related finding. </p>
         *        <p>
         *        Array Members: Minimum number of 1 item. Maximum number of 20 items.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder relatedFindingsProductArn(Collection<StringFilter> relatedFindingsProductArn);

        /**
         * <p>
         * The ARN for the product that generated a related finding.
         * </p>
         * <p>
         * Array Members: Minimum number of 1 item. Maximum number of 20 items.
         * </p>
         * 
         * @param relatedFindingsProductArn
         *        The ARN for the product that generated a related finding. </p>
         *        <p>
         *        Array Members: Minimum number of 1 item. Maximum number of 20 items.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder relatedFindingsProductArn(StringFilter... relatedFindingsProductArn);

        /**
         * <p>
         * The ARN for the product that generated a related finding.
         * </p>
         * <p>
         * Array Members: Minimum number of 1 item. Maximum number of 20 items.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityhub.model.StringFilter.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.securityhub.model.StringFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityhub.model.StringFilter.Builder#build()} is called immediately
         * and its result is passed to {@link #relatedFindingsProductArn(List<StringFilter>)}.
         * 
         * @param relatedFindingsProductArn
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityhub.model.StringFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #relatedFindingsProductArn(java.util.Collection<StringFilter>)
         */
        Builder relatedFindingsProductArn(Consumer<StringFilter.Builder>... relatedFindingsProductArn);

        /**
         * <p>
         * The product-generated identifier for a related finding.
         * </p>
         * <p>
         * Array Members: Minimum number of 1 item. Maximum number of 20 items.
         * </p>
         * 
         * @param relatedFindingsId
         *        The product-generated identifier for a related finding. </p>
         *        <p>
         *        Array Members: Minimum number of 1 item. Maximum number of 20 items.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder relatedFindingsId(Collection<StringFilter> relatedFindingsId);

        /**
         * <p>
         * The product-generated identifier for a related finding.
         * </p>
         * <p>
         * Array Members: Minimum number of 1 item. Maximum number of 20 items.
         * </p>
         * 
         * @param relatedFindingsId
         *        The product-generated identifier for a related finding. </p>
         *        <p>
         *        Array Members: Minimum number of 1 item. Maximum number of 20 items.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder relatedFindingsId(StringFilter... relatedFindingsId);

        /**
         * <p>
         * The product-generated identifier for a related finding.
         * </p>
         * <p>
         * Array Members: Minimum number of 1 item. Maximum number of 20 items.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityhub.model.StringFilter.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.securityhub.model.StringFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityhub.model.StringFilter.Builder#build()} is called immediately
         * and its result is passed to {@link #relatedFindingsId(List<StringFilter>)}.
         * 
         * @param relatedFindingsId
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityhub.model.StringFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #relatedFindingsId(java.util.Collection<StringFilter>)
         */
        Builder relatedFindingsId(Consumer<StringFilter.Builder>... relatedFindingsId);

        /**
         * <p>
         * The text of a user-defined note that's added to a finding.
         * </p>
         * <p>
         * Array Members: Minimum number of 1 item. Maximum number of 20 items.
         * </p>
         * 
         * @param noteText
         *        The text of a user-defined note that's added to a finding. </p>
         *        <p>
         *        Array Members: Minimum number of 1 item. Maximum number of 20 items.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder noteText(Collection<StringFilter> noteText);

        /**
         * <p>
         * The text of a user-defined note that's added to a finding.
         * </p>
         * <p>
         * Array Members: Minimum number of 1 item. Maximum number of 20 items.
         * </p>
         * 
         * @param noteText
         *        The text of a user-defined note that's added to a finding. </p>
         *        <p>
         *        Array Members: Minimum number of 1 item. Maximum number of 20 items.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder noteText(StringFilter... noteText);

        /**
         * <p>
         * The text of a user-defined note that's added to a finding.
         * </p>
         * <p>
         * Array Members: Minimum number of 1 item. Maximum number of 20 items.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityhub.model.StringFilter.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.securityhub.model.StringFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityhub.model.StringFilter.Builder#build()} is called immediately
         * and its result is passed to {@link #noteText(List<StringFilter>)}.
         * 
         * @param noteText
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityhub.model.StringFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #noteText(java.util.Collection<StringFilter>)
         */
        Builder noteText(Consumer<StringFilter.Builder>... noteText);

        /**
         * <p>
         * The timestamp of when the note was updated. Uses the date-time format specified in <a
         * href="https://www.rfc-editor.org/rfc/rfc3339#section-5.6">RFC 3339 section 5.6, Internet Date/Time
         * Format</a>. The value cannot contain spaces. For example, <code>2020-03-22T13:22:13.933Z</code>.
         * </p>
         * <p>
         * Array Members: Minimum number of 1 item. Maximum number of 20 items.
         * </p>
         * 
         * @param noteUpdatedAt
         *        The timestamp of when the note was updated. Uses the date-time format specified in <a
         *        href="https://www.rfc-editor.org/rfc/rfc3339#section-5.6">RFC 3339 section 5.6, Internet Date/Time
         *        Format</a>. The value cannot contain spaces. For example, <code>2020-03-22T13:22:13.933Z</code>. </p>
         *        <p>
         *        Array Members: Minimum number of 1 item. Maximum number of 20 items.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder noteUpdatedAt(Collection<DateFilter> noteUpdatedAt);

        /**
         * <p>
         * The timestamp of when the note was updated. Uses the date-time format specified in <a
         * href="https://www.rfc-editor.org/rfc/rfc3339#section-5.6">RFC 3339 section 5.6, Internet Date/Time
         * Format</a>. The value cannot contain spaces. For example, <code>2020-03-22T13:22:13.933Z</code>.
         * </p>
         * <p>
         * Array Members: Minimum number of 1 item. Maximum number of 20 items.
         * </p>
         * 
         * @param noteUpdatedAt
         *        The timestamp of when the note was updated. Uses the date-time format specified in <a
         *        href="https://www.rfc-editor.org/rfc/rfc3339#section-5.6">RFC 3339 section 5.6, Internet Date/Time
         *        Format</a>. The value cannot contain spaces. For example, <code>2020-03-22T13:22:13.933Z</code>. </p>
         *        <p>
         *        Array Members: Minimum number of 1 item. Maximum number of 20 items.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder noteUpdatedAt(DateFilter... noteUpdatedAt);

        /**
         * <p>
         * The timestamp of when the note was updated. Uses the date-time format specified in <a
         * href="https://www.rfc-editor.org/rfc/rfc3339#section-5.6">RFC 3339 section 5.6, Internet Date/Time
         * Format</a>. The value cannot contain spaces. For example, <code>2020-03-22T13:22:13.933Z</code>.
         * </p>
         * <p>
         * Array Members: Minimum number of 1 item. Maximum number of 20 items.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityhub.model.DateFilter.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.securityhub.model.DateFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityhub.model.DateFilter.Builder#build()} is called immediately
         * and its result is passed to {@link #noteUpdatedAt(List<DateFilter>)}.
         * 
         * @param noteUpdatedAt
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityhub.model.DateFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #noteUpdatedAt(java.util.Collection<DateFilter>)
         */
        Builder noteUpdatedAt(Consumer<DateFilter.Builder>... noteUpdatedAt);

        /**
         * <p>
         * The principal that created a note.
         * </p>
         * <p>
         * Array Members: Minimum number of 1 item. Maximum number of 20 items.
         * </p>
         * 
         * @param noteUpdatedBy
         *        The principal that created a note. </p>
         *        <p>
         *        Array Members: Minimum number of 1 item. Maximum number of 20 items.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder noteUpdatedBy(Collection<StringFilter> noteUpdatedBy);

        /**
         * <p>
         * The principal that created a note.
         * </p>
         * <p>
         * Array Members: Minimum number of 1 item. Maximum number of 20 items.
         * </p>
         * 
         * @param noteUpdatedBy
         *        The principal that created a note. </p>
         *        <p>
         *        Array Members: Minimum number of 1 item. Maximum number of 20 items.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder noteUpdatedBy(StringFilter... noteUpdatedBy);

        /**
         * <p>
         * The principal that created a note.
         * </p>
         * <p>
         * Array Members: Minimum number of 1 item. Maximum number of 20 items.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityhub.model.StringFilter.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.securityhub.model.StringFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityhub.model.StringFilter.Builder#build()} is called immediately
         * and its result is passed to {@link #noteUpdatedBy(List<StringFilter>)}.
         * 
         * @param noteUpdatedBy
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityhub.model.StringFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #noteUpdatedBy(java.util.Collection<StringFilter>)
         */
        Builder noteUpdatedBy(Consumer<StringFilter.Builder>... noteUpdatedBy);

        /**
         * <p>
         * A list of user-defined name and value string pairs added to a finding.
         * </p>
         * <p>
         * Array Members: Minimum number of 1 item. Maximum number of 20 items.
         * </p>
         * 
         * @param userDefinedFields
         *        A list of user-defined name and value string pairs added to a finding. </p>
         *        <p>
         *        Array Members: Minimum number of 1 item. Maximum number of 20 items.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userDefinedFields(Collection<MapFilter> userDefinedFields);

        /**
         * <p>
         * A list of user-defined name and value string pairs added to a finding.
         * </p>
         * <p>
         * Array Members: Minimum number of 1 item. Maximum number of 20 items.
         * </p>
         * 
         * @param userDefinedFields
         *        A list of user-defined name and value string pairs added to a finding. </p>
         *        <p>
         *        Array Members: Minimum number of 1 item. Maximum number of 20 items.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userDefinedFields(MapFilter... userDefinedFields);

        /**
         * <p>
         * A list of user-defined name and value string pairs added to a finding.
         * </p>
         * <p>
         * Array Members: Minimum number of 1 item. Maximum number of 20 items.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityhub.model.MapFilter.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.securityhub.model.MapFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityhub.model.MapFilter.Builder#build()} is called immediately and
         * its result is passed to {@link #userDefinedFields(List<MapFilter>)}.
         * 
         * @param userDefinedFields
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityhub.model.MapFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #userDefinedFields(java.util.Collection<MapFilter>)
         */
        Builder userDefinedFields(Consumer<MapFilter.Builder>... userDefinedFields);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the application that is related to a finding.
         * </p>
         * <p>
         * Array Members: Minimum number of 1 item. Maximum number of 20 items.
         * </p>
         * 
         * @param resourceApplicationArn
         *        The Amazon Resource Name (ARN) of the application that is related to a finding. </p>
         *        <p>
         *        Array Members: Minimum number of 1 item. Maximum number of 20 items.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceApplicationArn(Collection<StringFilter> resourceApplicationArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the application that is related to a finding.
         * </p>
         * <p>
         * Array Members: Minimum number of 1 item. Maximum number of 20 items.
         * </p>
         * 
         * @param resourceApplicationArn
         *        The Amazon Resource Name (ARN) of the application that is related to a finding. </p>
         *        <p>
         *        Array Members: Minimum number of 1 item. Maximum number of 20 items.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceApplicationArn(StringFilter... resourceApplicationArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the application that is related to a finding.
         * </p>
         * <p>
         * Array Members: Minimum number of 1 item. Maximum number of 20 items.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityhub.model.StringFilter.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.securityhub.model.StringFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityhub.model.StringFilter.Builder#build()} is called immediately
         * and its result is passed to {@link #resourceApplicationArn(List<StringFilter>)}.
         * 
         * @param resourceApplicationArn
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityhub.model.StringFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceApplicationArn(java.util.Collection<StringFilter>)
         */
        Builder resourceApplicationArn(Consumer<StringFilter.Builder>... resourceApplicationArn);

        /**
         * <p>
         * The name of the application that is related to a finding.
         * </p>
         * <p>
         * Array Members: Minimum number of 1 item. Maximum number of 20 items.
         * </p>
         * 
         * @param resourceApplicationName
         *        The name of the application that is related to a finding. </p>
         *        <p>
         *        Array Members: Minimum number of 1 item. Maximum number of 20 items.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceApplicationName(Collection<StringFilter> resourceApplicationName);

        /**
         * <p>
         * The name of the application that is related to a finding.
         * </p>
         * <p>
         * Array Members: Minimum number of 1 item. Maximum number of 20 items.
         * </p>
         * 
         * @param resourceApplicationName
         *        The name of the application that is related to a finding. </p>
         *        <p>
         *        Array Members: Minimum number of 1 item. Maximum number of 20 items.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceApplicationName(StringFilter... resourceApplicationName);

        /**
         * <p>
         * The name of the application that is related to a finding.
         * </p>
         * <p>
         * Array Members: Minimum number of 1 item. Maximum number of 20 items.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityhub.model.StringFilter.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.securityhub.model.StringFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityhub.model.StringFilter.Builder#build()} is called immediately
         * and its result is passed to {@link #resourceApplicationName(List<StringFilter>)}.
         * 
         * @param resourceApplicationName
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityhub.model.StringFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceApplicationName(java.util.Collection<StringFilter>)
         */
        Builder resourceApplicationName(Consumer<StringFilter.Builder>... resourceApplicationName);

        /**
         * <p>
         * The name of the Amazon Web Services account in which a finding was generated.
         * </p>
         * <p>
         * Array Members: Minimum number of 1 item. Maximum number of 20 items.
         * </p>
         * 
         * @param awsAccountName
         *        The name of the Amazon Web Services account in which a finding was generated. </p>
         *        <p>
         *        Array Members: Minimum number of 1 item. Maximum number of 20 items.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsAccountName(Collection<StringFilter> awsAccountName);

        /**
         * <p>
         * The name of the Amazon Web Services account in which a finding was generated.
         * </p>
         * <p>
         * Array Members: Minimum number of 1 item. Maximum number of 20 items.
         * </p>
         * 
         * @param awsAccountName
         *        The name of the Amazon Web Services account in which a finding was generated. </p>
         *        <p>
         *        Array Members: Minimum number of 1 item. Maximum number of 20 items.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsAccountName(StringFilter... awsAccountName);

        /**
         * <p>
         * The name of the Amazon Web Services account in which a finding was generated.
         * </p>
         * <p>
         * Array Members: Minimum number of 1 item. Maximum number of 20 items.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityhub.model.StringFilter.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.securityhub.model.StringFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityhub.model.StringFilter.Builder#build()} is called immediately
         * and its result is passed to {@link #awsAccountName(List<StringFilter>)}.
         * 
         * @param awsAccountName
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityhub.model.StringFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #awsAccountName(java.util.Collection<StringFilter>)
         */
        Builder awsAccountName(Consumer<StringFilter.Builder>... awsAccountName);
    }

    static final class BuilderImpl implements Builder {
        private List<StringFilter> productArn = DefaultSdkAutoConstructList.getInstance();

        private List<StringFilter> awsAccountId = DefaultSdkAutoConstructList.getInstance();

        private List<StringFilter> id = DefaultSdkAutoConstructList.getInstance();

        private List<StringFilter> generatorId = DefaultSdkAutoConstructList.getInstance();

        private List<StringFilter> type = DefaultSdkAutoConstructList.getInstance();

        private List<DateFilter> firstObservedAt = DefaultSdkAutoConstructList.getInstance();

        private List<DateFilter> lastObservedAt = DefaultSdkAutoConstructList.getInstance();

        private List<DateFilter> createdAt = DefaultSdkAutoConstructList.getInstance();

        private List<DateFilter> updatedAt = DefaultSdkAutoConstructList.getInstance();

        private List<NumberFilter> confidence = DefaultSdkAutoConstructList.getInstance();

        private List<NumberFilter> criticality = DefaultSdkAutoConstructList.getInstance();

        private List<StringFilter> title = DefaultSdkAutoConstructList.getInstance();

        private List<StringFilter> description = DefaultSdkAutoConstructList.getInstance();

        private List<StringFilter> sourceUrl = DefaultSdkAutoConstructList.getInstance();

        private List<StringFilter> productName = DefaultSdkAutoConstructList.getInstance();

        private List<StringFilter> companyName = DefaultSdkAutoConstructList.getInstance();

        private List<StringFilter> severityLabel = DefaultSdkAutoConstructList.getInstance();

        private List<StringFilter> resourceType = DefaultSdkAutoConstructList.getInstance();

        private List<StringFilter> resourceId = DefaultSdkAutoConstructList.getInstance();

        private List<StringFilter> resourcePartition = DefaultSdkAutoConstructList.getInstance();

        private List<StringFilter> resourceRegion = DefaultSdkAutoConstructList.getInstance();

        private List<MapFilter> resourceTags = DefaultSdkAutoConstructList.getInstance();

        private List<MapFilter> resourceDetailsOther = DefaultSdkAutoConstructList.getInstance();

        private List<StringFilter> complianceStatus = DefaultSdkAutoConstructList.getInstance();

        private List<StringFilter> complianceSecurityControlId = DefaultSdkAutoConstructList.getInstance();

        private List<StringFilter> complianceAssociatedStandardsId = DefaultSdkAutoConstructList.getInstance();

        private List<StringFilter> verificationState = DefaultSdkAutoConstructList.getInstance();

        private List<StringFilter> workflowStatus = DefaultSdkAutoConstructList.getInstance();

        private List<StringFilter> recordState = DefaultSdkAutoConstructList.getInstance();

        private List<StringFilter> relatedFindingsProductArn = DefaultSdkAutoConstructList.getInstance();

        private List<StringFilter> relatedFindingsId = DefaultSdkAutoConstructList.getInstance();

        private List<StringFilter> noteText = DefaultSdkAutoConstructList.getInstance();

        private List<DateFilter> noteUpdatedAt = DefaultSdkAutoConstructList.getInstance();

        private List<StringFilter> noteUpdatedBy = DefaultSdkAutoConstructList.getInstance();

        private List<MapFilter> userDefinedFields = DefaultSdkAutoConstructList.getInstance();

        private List<StringFilter> resourceApplicationArn = DefaultSdkAutoConstructList.getInstance();

        private List<StringFilter> resourceApplicationName = DefaultSdkAutoConstructList.getInstance();

        private List<StringFilter> awsAccountName = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AutomationRulesFindingFilters model) {
            productArn(model.productArn);
            awsAccountId(model.awsAccountId);
            id(model.id);
            generatorId(model.generatorId);
            type(model.type);
            firstObservedAt(model.firstObservedAt);
            lastObservedAt(model.lastObservedAt);
            createdAt(model.createdAt);
            updatedAt(model.updatedAt);
            confidence(model.confidence);
            criticality(model.criticality);
            title(model.title);
            description(model.description);
            sourceUrl(model.sourceUrl);
            productName(model.productName);
            companyName(model.companyName);
            severityLabel(model.severityLabel);
            resourceType(model.resourceType);
            resourceId(model.resourceId);
            resourcePartition(model.resourcePartition);
            resourceRegion(model.resourceRegion);
            resourceTags(model.resourceTags);
            resourceDetailsOther(model.resourceDetailsOther);
            complianceStatus(model.complianceStatus);
            complianceSecurityControlId(model.complianceSecurityControlId);
            complianceAssociatedStandardsId(model.complianceAssociatedStandardsId);
            verificationState(model.verificationState);
            workflowStatus(model.workflowStatus);
            recordState(model.recordState);
            relatedFindingsProductArn(model.relatedFindingsProductArn);
            relatedFindingsId(model.relatedFindingsId);
            noteText(model.noteText);
            noteUpdatedAt(model.noteUpdatedAt);
            noteUpdatedBy(model.noteUpdatedBy);
            userDefinedFields(model.userDefinedFields);
            resourceApplicationArn(model.resourceApplicationArn);
            resourceApplicationName(model.resourceApplicationName);
            awsAccountName(model.awsAccountName);
        }

        public final List<StringFilter.Builder> getProductArn() {
            List<StringFilter.Builder> result = StringFilterListCopier.copyToBuilder(this.productArn);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setProductArn(Collection<StringFilter.BuilderImpl> productArn) {
            this.productArn = StringFilterListCopier.copyFromBuilder(productArn);
        }

        @Override
        public final Builder productArn(Collection<StringFilter> productArn) {
            this.productArn = StringFilterListCopier.copy(productArn);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder productArn(StringFilter... productArn) {
            productArn(Arrays.asList(productArn));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder productArn(Consumer<StringFilter.Builder>... productArn) {
            productArn(Stream.of(productArn).map(c -> StringFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<StringFilter.Builder> getAwsAccountId() {
            List<StringFilter.Builder> result = StringFilterListCopier.copyToBuilder(this.awsAccountId);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAwsAccountId(Collection<StringFilter.BuilderImpl> awsAccountId) {
            this.awsAccountId = StringFilterListCopier.copyFromBuilder(awsAccountId);
        }

        @Override
        public final Builder awsAccountId(Collection<StringFilter> awsAccountId) {
            this.awsAccountId = StringFilterListCopier.copy(awsAccountId);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder awsAccountId(StringFilter... awsAccountId) {
            awsAccountId(Arrays.asList(awsAccountId));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder awsAccountId(Consumer<StringFilter.Builder>... awsAccountId) {
            awsAccountId(Stream.of(awsAccountId).map(c -> StringFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<StringFilter.Builder> getId() {
            List<StringFilter.Builder> result = StringFilterListCopier.copyToBuilder(this.id);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setId(Collection<StringFilter.BuilderImpl> id) {
            this.id = StringFilterListCopier.copyFromBuilder(id);
        }

        @Override
        public final Builder id(Collection<StringFilter> id) {
            this.id = StringFilterListCopier.copy(id);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder id(StringFilter... id) {
            id(Arrays.asList(id));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder id(Consumer<StringFilter.Builder>... id) {
            id(Stream.of(id).map(c -> StringFilter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<StringFilter.Builder> getGeneratorId() {
            List<StringFilter.Builder> result = StringFilterListCopier.copyToBuilder(this.generatorId);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGeneratorId(Collection<StringFilter.BuilderImpl> generatorId) {
            this.generatorId = StringFilterListCopier.copyFromBuilder(generatorId);
        }

        @Override
        public final Builder generatorId(Collection<StringFilter> generatorId) {
            this.generatorId = StringFilterListCopier.copy(generatorId);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder generatorId(StringFilter... generatorId) {
            generatorId(Arrays.asList(generatorId));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder generatorId(Consumer<StringFilter.Builder>... generatorId) {
            generatorId(Stream.of(generatorId).map(c -> StringFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<StringFilter.Builder> getType() {
            List<StringFilter.Builder> result = StringFilterListCopier.copyToBuilder(this.type);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setType(Collection<StringFilter.BuilderImpl> type) {
            this.type = StringFilterListCopier.copyFromBuilder(type);
        }

        @Override
        public final Builder type(Collection<StringFilter> type) {
            this.type = StringFilterListCopier.copy(type);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder type(StringFilter... type) {
            type(Arrays.asList(type));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder type(Consumer<StringFilter.Builder>... type) {
            type(Stream.of(type).map(c -> StringFilter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<DateFilter.Builder> getFirstObservedAt() {
            List<DateFilter.Builder> result = DateFilterListCopier.copyToBuilder(this.firstObservedAt);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFirstObservedAt(Collection<DateFilter.BuilderImpl> firstObservedAt) {
            this.firstObservedAt = DateFilterListCopier.copyFromBuilder(firstObservedAt);
        }

        @Override
        public final Builder firstObservedAt(Collection<DateFilter> firstObservedAt) {
            this.firstObservedAt = DateFilterListCopier.copy(firstObservedAt);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder firstObservedAt(DateFilter... firstObservedAt) {
            firstObservedAt(Arrays.asList(firstObservedAt));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder firstObservedAt(Consumer<DateFilter.Builder>... firstObservedAt) {
            firstObservedAt(Stream.of(firstObservedAt).map(c -> DateFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<DateFilter.Builder> getLastObservedAt() {
            List<DateFilter.Builder> result = DateFilterListCopier.copyToBuilder(this.lastObservedAt);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLastObservedAt(Collection<DateFilter.BuilderImpl> lastObservedAt) {
            this.lastObservedAt = DateFilterListCopier.copyFromBuilder(lastObservedAt);
        }

        @Override
        public final Builder lastObservedAt(Collection<DateFilter> lastObservedAt) {
            this.lastObservedAt = DateFilterListCopier.copy(lastObservedAt);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lastObservedAt(DateFilter... lastObservedAt) {
            lastObservedAt(Arrays.asList(lastObservedAt));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lastObservedAt(Consumer<DateFilter.Builder>... lastObservedAt) {
            lastObservedAt(Stream.of(lastObservedAt).map(c -> DateFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<DateFilter.Builder> getCreatedAt() {
            List<DateFilter.Builder> result = DateFilterListCopier.copyToBuilder(this.createdAt);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCreatedAt(Collection<DateFilter.BuilderImpl> createdAt) {
            this.createdAt = DateFilterListCopier.copyFromBuilder(createdAt);
        }

        @Override
        public final Builder createdAt(Collection<DateFilter> createdAt) {
            this.createdAt = DateFilterListCopier.copy(createdAt);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder createdAt(DateFilter... createdAt) {
            createdAt(Arrays.asList(createdAt));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder createdAt(Consumer<DateFilter.Builder>... createdAt) {
            createdAt(Stream.of(createdAt).map(c -> DateFilter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<DateFilter.Builder> getUpdatedAt() {
            List<DateFilter.Builder> result = DateFilterListCopier.copyToBuilder(this.updatedAt);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUpdatedAt(Collection<DateFilter.BuilderImpl> updatedAt) {
            this.updatedAt = DateFilterListCopier.copyFromBuilder(updatedAt);
        }

        @Override
        public final Builder updatedAt(Collection<DateFilter> updatedAt) {
            this.updatedAt = DateFilterListCopier.copy(updatedAt);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder updatedAt(DateFilter... updatedAt) {
            updatedAt(Arrays.asList(updatedAt));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder updatedAt(Consumer<DateFilter.Builder>... updatedAt) {
            updatedAt(Stream.of(updatedAt).map(c -> DateFilter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<NumberFilter.Builder> getConfidence() {
            List<NumberFilter.Builder> result = NumberFilterListCopier.copyToBuilder(this.confidence);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setConfidence(Collection<NumberFilter.BuilderImpl> confidence) {
            this.confidence = NumberFilterListCopier.copyFromBuilder(confidence);
        }

        @Override
        public final Builder confidence(Collection<NumberFilter> confidence) {
            this.confidence = NumberFilterListCopier.copy(confidence);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder confidence(NumberFilter... confidence) {
            confidence(Arrays.asList(confidence));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder confidence(Consumer<NumberFilter.Builder>... confidence) {
            confidence(Stream.of(confidence).map(c -> NumberFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<NumberFilter.Builder> getCriticality() {
            List<NumberFilter.Builder> result = NumberFilterListCopier.copyToBuilder(this.criticality);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCriticality(Collection<NumberFilter.BuilderImpl> criticality) {
            this.criticality = NumberFilterListCopier.copyFromBuilder(criticality);
        }

        @Override
        public final Builder criticality(Collection<NumberFilter> criticality) {
            this.criticality = NumberFilterListCopier.copy(criticality);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder criticality(NumberFilter... criticality) {
            criticality(Arrays.asList(criticality));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder criticality(Consumer<NumberFilter.Builder>... criticality) {
            criticality(Stream.of(criticality).map(c -> NumberFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<StringFilter.Builder> getTitle() {
            List<StringFilter.Builder> result = StringFilterListCopier.copyToBuilder(this.title);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTitle(Collection<StringFilter.BuilderImpl> title) {
            this.title = StringFilterListCopier.copyFromBuilder(title);
        }

        @Override
        public final Builder title(Collection<StringFilter> title) {
            this.title = StringFilterListCopier.copy(title);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder title(StringFilter... title) {
            title(Arrays.asList(title));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder title(Consumer<StringFilter.Builder>... title) {
            title(Stream.of(title).map(c -> StringFilter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<StringFilter.Builder> getDescription() {
            List<StringFilter.Builder> result = StringFilterListCopier.copyToBuilder(this.description);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDescription(Collection<StringFilter.BuilderImpl> description) {
            this.description = StringFilterListCopier.copyFromBuilder(description);
        }

        @Override
        public final Builder description(Collection<StringFilter> description) {
            this.description = StringFilterListCopier.copy(description);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder description(StringFilter... description) {
            description(Arrays.asList(description));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder description(Consumer<StringFilter.Builder>... description) {
            description(Stream.of(description).map(c -> StringFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<StringFilter.Builder> getSourceUrl() {
            List<StringFilter.Builder> result = StringFilterListCopier.copyToBuilder(this.sourceUrl);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSourceUrl(Collection<StringFilter.BuilderImpl> sourceUrl) {
            this.sourceUrl = StringFilterListCopier.copyFromBuilder(sourceUrl);
        }

        @Override
        public final Builder sourceUrl(Collection<StringFilter> sourceUrl) {
            this.sourceUrl = StringFilterListCopier.copy(sourceUrl);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sourceUrl(StringFilter... sourceUrl) {
            sourceUrl(Arrays.asList(sourceUrl));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sourceUrl(Consumer<StringFilter.Builder>... sourceUrl) {
            sourceUrl(Stream.of(sourceUrl).map(c -> StringFilter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<StringFilter.Builder> getProductName() {
            List<StringFilter.Builder> result = StringFilterListCopier.copyToBuilder(this.productName);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setProductName(Collection<StringFilter.BuilderImpl> productName) {
            this.productName = StringFilterListCopier.copyFromBuilder(productName);
        }

        @Override
        public final Builder productName(Collection<StringFilter> productName) {
            this.productName = StringFilterListCopier.copy(productName);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder productName(StringFilter... productName) {
            productName(Arrays.asList(productName));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder productName(Consumer<StringFilter.Builder>... productName) {
            productName(Stream.of(productName).map(c -> StringFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<StringFilter.Builder> getCompanyName() {
            List<StringFilter.Builder> result = StringFilterListCopier.copyToBuilder(this.companyName);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCompanyName(Collection<StringFilter.BuilderImpl> companyName) {
            this.companyName = StringFilterListCopier.copyFromBuilder(companyName);
        }

        @Override
        public final Builder companyName(Collection<StringFilter> companyName) {
            this.companyName = StringFilterListCopier.copy(companyName);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder companyName(StringFilter... companyName) {
            companyName(Arrays.asList(companyName));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder companyName(Consumer<StringFilter.Builder>... companyName) {
            companyName(Stream.of(companyName).map(c -> StringFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<StringFilter.Builder> getSeverityLabel() {
            List<StringFilter.Builder> result = StringFilterListCopier.copyToBuilder(this.severityLabel);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSeverityLabel(Collection<StringFilter.BuilderImpl> severityLabel) {
            this.severityLabel = StringFilterListCopier.copyFromBuilder(severityLabel);
        }

        @Override
        public final Builder severityLabel(Collection<StringFilter> severityLabel) {
            this.severityLabel = StringFilterListCopier.copy(severityLabel);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder severityLabel(StringFilter... severityLabel) {
            severityLabel(Arrays.asList(severityLabel));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder severityLabel(Consumer<StringFilter.Builder>... severityLabel) {
            severityLabel(Stream.of(severityLabel).map(c -> StringFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<StringFilter.Builder> getResourceType() {
            List<StringFilter.Builder> result = StringFilterListCopier.copyToBuilder(this.resourceType);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResourceType(Collection<StringFilter.BuilderImpl> resourceType) {
            this.resourceType = StringFilterListCopier.copyFromBuilder(resourceType);
        }

        @Override
        public final Builder resourceType(Collection<StringFilter> resourceType) {
            this.resourceType = StringFilterListCopier.copy(resourceType);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceType(StringFilter... resourceType) {
            resourceType(Arrays.asList(resourceType));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceType(Consumer<StringFilter.Builder>... resourceType) {
            resourceType(Stream.of(resourceType).map(c -> StringFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<StringFilter.Builder> getResourceId() {
            List<StringFilter.Builder> result = StringFilterListCopier.copyToBuilder(this.resourceId);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResourceId(Collection<StringFilter.BuilderImpl> resourceId) {
            this.resourceId = StringFilterListCopier.copyFromBuilder(resourceId);
        }

        @Override
        public final Builder resourceId(Collection<StringFilter> resourceId) {
            this.resourceId = StringFilterListCopier.copy(resourceId);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceId(StringFilter... resourceId) {
            resourceId(Arrays.asList(resourceId));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceId(Consumer<StringFilter.Builder>... resourceId) {
            resourceId(Stream.of(resourceId).map(c -> StringFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<StringFilter.Builder> getResourcePartition() {
            List<StringFilter.Builder> result = StringFilterListCopier.copyToBuilder(this.resourcePartition);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResourcePartition(Collection<StringFilter.BuilderImpl> resourcePartition) {
            this.resourcePartition = StringFilterListCopier.copyFromBuilder(resourcePartition);
        }

        @Override
        public final Builder resourcePartition(Collection<StringFilter> resourcePartition) {
            this.resourcePartition = StringFilterListCopier.copy(resourcePartition);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourcePartition(StringFilter... resourcePartition) {
            resourcePartition(Arrays.asList(resourcePartition));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourcePartition(Consumer<StringFilter.Builder>... resourcePartition) {
            resourcePartition(Stream.of(resourcePartition).map(c -> StringFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<StringFilter.Builder> getResourceRegion() {
            List<StringFilter.Builder> result = StringFilterListCopier.copyToBuilder(this.resourceRegion);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResourceRegion(Collection<StringFilter.BuilderImpl> resourceRegion) {
            this.resourceRegion = StringFilterListCopier.copyFromBuilder(resourceRegion);
        }

        @Override
        public final Builder resourceRegion(Collection<StringFilter> resourceRegion) {
            this.resourceRegion = StringFilterListCopier.copy(resourceRegion);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceRegion(StringFilter... resourceRegion) {
            resourceRegion(Arrays.asList(resourceRegion));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceRegion(Consumer<StringFilter.Builder>... resourceRegion) {
            resourceRegion(Stream.of(resourceRegion).map(c -> StringFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<MapFilter.Builder> getResourceTags() {
            List<MapFilter.Builder> result = MapFilterListCopier.copyToBuilder(this.resourceTags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResourceTags(Collection<MapFilter.BuilderImpl> resourceTags) {
            this.resourceTags = MapFilterListCopier.copyFromBuilder(resourceTags);
        }

        @Override
        public final Builder resourceTags(Collection<MapFilter> resourceTags) {
            this.resourceTags = MapFilterListCopier.copy(resourceTags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceTags(MapFilter... resourceTags) {
            resourceTags(Arrays.asList(resourceTags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceTags(Consumer<MapFilter.Builder>... resourceTags) {
            resourceTags(Stream.of(resourceTags).map(c -> MapFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<MapFilter.Builder> getResourceDetailsOther() {
            List<MapFilter.Builder> result = MapFilterListCopier.copyToBuilder(this.resourceDetailsOther);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResourceDetailsOther(Collection<MapFilter.BuilderImpl> resourceDetailsOther) {
            this.resourceDetailsOther = MapFilterListCopier.copyFromBuilder(resourceDetailsOther);
        }

        @Override
        public final Builder resourceDetailsOther(Collection<MapFilter> resourceDetailsOther) {
            this.resourceDetailsOther = MapFilterListCopier.copy(resourceDetailsOther);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceDetailsOther(MapFilter... resourceDetailsOther) {
            resourceDetailsOther(Arrays.asList(resourceDetailsOther));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceDetailsOther(Consumer<MapFilter.Builder>... resourceDetailsOther) {
            resourceDetailsOther(Stream.of(resourceDetailsOther).map(c -> MapFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<StringFilter.Builder> getComplianceStatus() {
            List<StringFilter.Builder> result = StringFilterListCopier.copyToBuilder(this.complianceStatus);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setComplianceStatus(Collection<StringFilter.BuilderImpl> complianceStatus) {
            this.complianceStatus = StringFilterListCopier.copyFromBuilder(complianceStatus);
        }

        @Override
        public final Builder complianceStatus(Collection<StringFilter> complianceStatus) {
            this.complianceStatus = StringFilterListCopier.copy(complianceStatus);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder complianceStatus(StringFilter... complianceStatus) {
            complianceStatus(Arrays.asList(complianceStatus));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder complianceStatus(Consumer<StringFilter.Builder>... complianceStatus) {
            complianceStatus(Stream.of(complianceStatus).map(c -> StringFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<StringFilter.Builder> getComplianceSecurityControlId() {
            List<StringFilter.Builder> result = StringFilterListCopier.copyToBuilder(this.complianceSecurityControlId);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setComplianceSecurityControlId(Collection<StringFilter.BuilderImpl> complianceSecurityControlId) {
            this.complianceSecurityControlId = StringFilterListCopier.copyFromBuilder(complianceSecurityControlId);
        }

        @Override
        public final Builder complianceSecurityControlId(Collection<StringFilter> complianceSecurityControlId) {
            this.complianceSecurityControlId = StringFilterListCopier.copy(complianceSecurityControlId);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder complianceSecurityControlId(StringFilter... complianceSecurityControlId) {
            complianceSecurityControlId(Arrays.asList(complianceSecurityControlId));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder complianceSecurityControlId(Consumer<StringFilter.Builder>... complianceSecurityControlId) {
            complianceSecurityControlId(Stream.of(complianceSecurityControlId)
                    .map(c -> StringFilter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<StringFilter.Builder> getComplianceAssociatedStandardsId() {
            List<StringFilter.Builder> result = StringFilterListCopier.copyToBuilder(this.complianceAssociatedStandardsId);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setComplianceAssociatedStandardsId(Collection<StringFilter.BuilderImpl> complianceAssociatedStandardsId) {
            this.complianceAssociatedStandardsId = StringFilterListCopier.copyFromBuilder(complianceAssociatedStandardsId);
        }

        @Override
        public final Builder complianceAssociatedStandardsId(Collection<StringFilter> complianceAssociatedStandardsId) {
            this.complianceAssociatedStandardsId = StringFilterListCopier.copy(complianceAssociatedStandardsId);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder complianceAssociatedStandardsId(StringFilter... complianceAssociatedStandardsId) {
            complianceAssociatedStandardsId(Arrays.asList(complianceAssociatedStandardsId));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder complianceAssociatedStandardsId(Consumer<StringFilter.Builder>... complianceAssociatedStandardsId) {
            complianceAssociatedStandardsId(Stream.of(complianceAssociatedStandardsId)
                    .map(c -> StringFilter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<StringFilter.Builder> getVerificationState() {
            List<StringFilter.Builder> result = StringFilterListCopier.copyToBuilder(this.verificationState);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVerificationState(Collection<StringFilter.BuilderImpl> verificationState) {
            this.verificationState = StringFilterListCopier.copyFromBuilder(verificationState);
        }

        @Override
        public final Builder verificationState(Collection<StringFilter> verificationState) {
            this.verificationState = StringFilterListCopier.copy(verificationState);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder verificationState(StringFilter... verificationState) {
            verificationState(Arrays.asList(verificationState));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder verificationState(Consumer<StringFilter.Builder>... verificationState) {
            verificationState(Stream.of(verificationState).map(c -> StringFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<StringFilter.Builder> getWorkflowStatus() {
            List<StringFilter.Builder> result = StringFilterListCopier.copyToBuilder(this.workflowStatus);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setWorkflowStatus(Collection<StringFilter.BuilderImpl> workflowStatus) {
            this.workflowStatus = StringFilterListCopier.copyFromBuilder(workflowStatus);
        }

        @Override
        public final Builder workflowStatus(Collection<StringFilter> workflowStatus) {
            this.workflowStatus = StringFilterListCopier.copy(workflowStatus);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder workflowStatus(StringFilter... workflowStatus) {
            workflowStatus(Arrays.asList(workflowStatus));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder workflowStatus(Consumer<StringFilter.Builder>... workflowStatus) {
            workflowStatus(Stream.of(workflowStatus).map(c -> StringFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<StringFilter.Builder> getRecordState() {
            List<StringFilter.Builder> result = StringFilterListCopier.copyToBuilder(this.recordState);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRecordState(Collection<StringFilter.BuilderImpl> recordState) {
            this.recordState = StringFilterListCopier.copyFromBuilder(recordState);
        }

        @Override
        public final Builder recordState(Collection<StringFilter> recordState) {
            this.recordState = StringFilterListCopier.copy(recordState);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recordState(StringFilter... recordState) {
            recordState(Arrays.asList(recordState));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recordState(Consumer<StringFilter.Builder>... recordState) {
            recordState(Stream.of(recordState).map(c -> StringFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<StringFilter.Builder> getRelatedFindingsProductArn() {
            List<StringFilter.Builder> result = StringFilterListCopier.copyToBuilder(this.relatedFindingsProductArn);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRelatedFindingsProductArn(Collection<StringFilter.BuilderImpl> relatedFindingsProductArn) {
            this.relatedFindingsProductArn = StringFilterListCopier.copyFromBuilder(relatedFindingsProductArn);
        }

        @Override
        public final Builder relatedFindingsProductArn(Collection<StringFilter> relatedFindingsProductArn) {
            this.relatedFindingsProductArn = StringFilterListCopier.copy(relatedFindingsProductArn);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder relatedFindingsProductArn(StringFilter... relatedFindingsProductArn) {
            relatedFindingsProductArn(Arrays.asList(relatedFindingsProductArn));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder relatedFindingsProductArn(Consumer<StringFilter.Builder>... relatedFindingsProductArn) {
            relatedFindingsProductArn(Stream.of(relatedFindingsProductArn)
                    .map(c -> StringFilter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<StringFilter.Builder> getRelatedFindingsId() {
            List<StringFilter.Builder> result = StringFilterListCopier.copyToBuilder(this.relatedFindingsId);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRelatedFindingsId(Collection<StringFilter.BuilderImpl> relatedFindingsId) {
            this.relatedFindingsId = StringFilterListCopier.copyFromBuilder(relatedFindingsId);
        }

        @Override
        public final Builder relatedFindingsId(Collection<StringFilter> relatedFindingsId) {
            this.relatedFindingsId = StringFilterListCopier.copy(relatedFindingsId);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder relatedFindingsId(StringFilter... relatedFindingsId) {
            relatedFindingsId(Arrays.asList(relatedFindingsId));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder relatedFindingsId(Consumer<StringFilter.Builder>... relatedFindingsId) {
            relatedFindingsId(Stream.of(relatedFindingsId).map(c -> StringFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<StringFilter.Builder> getNoteText() {
            List<StringFilter.Builder> result = StringFilterListCopier.copyToBuilder(this.noteText);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setNoteText(Collection<StringFilter.BuilderImpl> noteText) {
            this.noteText = StringFilterListCopier.copyFromBuilder(noteText);
        }

        @Override
        public final Builder noteText(Collection<StringFilter> noteText) {
            this.noteText = StringFilterListCopier.copy(noteText);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder noteText(StringFilter... noteText) {
            noteText(Arrays.asList(noteText));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder noteText(Consumer<StringFilter.Builder>... noteText) {
            noteText(Stream.of(noteText).map(c -> StringFilter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<DateFilter.Builder> getNoteUpdatedAt() {
            List<DateFilter.Builder> result = DateFilterListCopier.copyToBuilder(this.noteUpdatedAt);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setNoteUpdatedAt(Collection<DateFilter.BuilderImpl> noteUpdatedAt) {
            this.noteUpdatedAt = DateFilterListCopier.copyFromBuilder(noteUpdatedAt);
        }

        @Override
        public final Builder noteUpdatedAt(Collection<DateFilter> noteUpdatedAt) {
            this.noteUpdatedAt = DateFilterListCopier.copy(noteUpdatedAt);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder noteUpdatedAt(DateFilter... noteUpdatedAt) {
            noteUpdatedAt(Arrays.asList(noteUpdatedAt));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder noteUpdatedAt(Consumer<DateFilter.Builder>... noteUpdatedAt) {
            noteUpdatedAt(Stream.of(noteUpdatedAt).map(c -> DateFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<StringFilter.Builder> getNoteUpdatedBy() {
            List<StringFilter.Builder> result = StringFilterListCopier.copyToBuilder(this.noteUpdatedBy);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setNoteUpdatedBy(Collection<StringFilter.BuilderImpl> noteUpdatedBy) {
            this.noteUpdatedBy = StringFilterListCopier.copyFromBuilder(noteUpdatedBy);
        }

        @Override
        public final Builder noteUpdatedBy(Collection<StringFilter> noteUpdatedBy) {
            this.noteUpdatedBy = StringFilterListCopier.copy(noteUpdatedBy);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder noteUpdatedBy(StringFilter... noteUpdatedBy) {
            noteUpdatedBy(Arrays.asList(noteUpdatedBy));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder noteUpdatedBy(Consumer<StringFilter.Builder>... noteUpdatedBy) {
            noteUpdatedBy(Stream.of(noteUpdatedBy).map(c -> StringFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<MapFilter.Builder> getUserDefinedFields() {
            List<MapFilter.Builder> result = MapFilterListCopier.copyToBuilder(this.userDefinedFields);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUserDefinedFields(Collection<MapFilter.BuilderImpl> userDefinedFields) {
            this.userDefinedFields = MapFilterListCopier.copyFromBuilder(userDefinedFields);
        }

        @Override
        public final Builder userDefinedFields(Collection<MapFilter> userDefinedFields) {
            this.userDefinedFields = MapFilterListCopier.copy(userDefinedFields);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userDefinedFields(MapFilter... userDefinedFields) {
            userDefinedFields(Arrays.asList(userDefinedFields));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userDefinedFields(Consumer<MapFilter.Builder>... userDefinedFields) {
            userDefinedFields(Stream.of(userDefinedFields).map(c -> MapFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<StringFilter.Builder> getResourceApplicationArn() {
            List<StringFilter.Builder> result = StringFilterListCopier.copyToBuilder(this.resourceApplicationArn);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResourceApplicationArn(Collection<StringFilter.BuilderImpl> resourceApplicationArn) {
            this.resourceApplicationArn = StringFilterListCopier.copyFromBuilder(resourceApplicationArn);
        }

        @Override
        public final Builder resourceApplicationArn(Collection<StringFilter> resourceApplicationArn) {
            this.resourceApplicationArn = StringFilterListCopier.copy(resourceApplicationArn);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceApplicationArn(StringFilter... resourceApplicationArn) {
            resourceApplicationArn(Arrays.asList(resourceApplicationArn));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceApplicationArn(Consumer<StringFilter.Builder>... resourceApplicationArn) {
            resourceApplicationArn(Stream.of(resourceApplicationArn).map(c -> StringFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<StringFilter.Builder> getResourceApplicationName() {
            List<StringFilter.Builder> result = StringFilterListCopier.copyToBuilder(this.resourceApplicationName);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResourceApplicationName(Collection<StringFilter.BuilderImpl> resourceApplicationName) {
            this.resourceApplicationName = StringFilterListCopier.copyFromBuilder(resourceApplicationName);
        }

        @Override
        public final Builder resourceApplicationName(Collection<StringFilter> resourceApplicationName) {
            this.resourceApplicationName = StringFilterListCopier.copy(resourceApplicationName);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceApplicationName(StringFilter... resourceApplicationName) {
            resourceApplicationName(Arrays.asList(resourceApplicationName));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceApplicationName(Consumer<StringFilter.Builder>... resourceApplicationName) {
            resourceApplicationName(Stream.of(resourceApplicationName).map(c -> StringFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<StringFilter.Builder> getAwsAccountName() {
            List<StringFilter.Builder> result = StringFilterListCopier.copyToBuilder(this.awsAccountName);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAwsAccountName(Collection<StringFilter.BuilderImpl> awsAccountName) {
            this.awsAccountName = StringFilterListCopier.copyFromBuilder(awsAccountName);
        }

        @Override
        public final Builder awsAccountName(Collection<StringFilter> awsAccountName) {
            this.awsAccountName = StringFilterListCopier.copy(awsAccountName);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder awsAccountName(StringFilter... awsAccountName) {
            awsAccountName(Arrays.asList(awsAccountName));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder awsAccountName(Consumer<StringFilter.Builder>... awsAccountName) {
            awsAccountName(Stream.of(awsAccountName).map(c -> StringFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public AutomationRulesFindingFilters build() {
            return new AutomationRulesFindingFilters(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
