/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Metadata for automation rules in the calling account. The response includes rules with a <code>RuleStatus</code> of
 * <code>ENABLED</code> and <code>DISABLED</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AutomationRulesMetadata implements SdkPojo, Serializable,
        ToCopyableBuilder<AutomationRulesMetadata.Builder, AutomationRulesMetadata> {
    private static final SdkField<String> RULE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RuleArn").getter(getter(AutomationRulesMetadata::ruleArn)).setter(setter(Builder::ruleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleArn").build()).build();

    private static final SdkField<String> RULE_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RuleStatus").getter(getter(AutomationRulesMetadata::ruleStatusAsString))
            .setter(setter(Builder::ruleStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleStatus").build()).build();

    private static final SdkField<Integer> RULE_ORDER_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("RuleOrder").getter(getter(AutomationRulesMetadata::ruleOrder)).setter(setter(Builder::ruleOrder))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleOrder").build()).build();

    private static final SdkField<String> RULE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RuleName").getter(getter(AutomationRulesMetadata::ruleName)).setter(setter(Builder::ruleName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleName").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(AutomationRulesMetadata::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<Boolean> IS_TERMINAL_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IsTerminal").getter(getter(AutomationRulesMetadata::isTerminal)).setter(setter(Builder::isTerminal))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsTerminal").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedAt")
            .getter(getter(AutomationRulesMetadata::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("UpdatedAt")
            .getter(getter(AutomationRulesMetadata::updatedAt))
            .setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdatedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> CREATED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CreatedBy").getter(getter(AutomationRulesMetadata::createdBy)).setter(setter(Builder::createdBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedBy").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RULE_ARN_FIELD,
            RULE_STATUS_FIELD, RULE_ORDER_FIELD, RULE_NAME_FIELD, DESCRIPTION_FIELD, IS_TERMINAL_FIELD, CREATED_AT_FIELD,
            UPDATED_AT_FIELD, CREATED_BY_FIELD));

    private static final long serialVersionUID = 1L;

    private final String ruleArn;

    private final String ruleStatus;

    private final Integer ruleOrder;

    private final String ruleName;

    private final String description;

    private final Boolean isTerminal;

    private final Instant createdAt;

    private final Instant updatedAt;

    private final String createdBy;

    private AutomationRulesMetadata(BuilderImpl builder) {
        this.ruleArn = builder.ruleArn;
        this.ruleStatus = builder.ruleStatus;
        this.ruleOrder = builder.ruleOrder;
        this.ruleName = builder.ruleName;
        this.description = builder.description;
        this.isTerminal = builder.isTerminal;
        this.createdAt = builder.createdAt;
        this.updatedAt = builder.updatedAt;
        this.createdBy = builder.createdBy;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for the rule.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for the rule.
     */
    public final String ruleArn() {
        return ruleArn;
    }

    /**
     * <p>
     * Whether the rule is active after it is created. If this parameter is equal to <code>ENABLED</code>, Security Hub
     * starts applying the rule to findings and finding updates after the rule is created. To change the value of this
     * parameter after creating a rule, use <a
     * href="https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_BatchUpdateAutomationRules.html">
     * <code>BatchUpdateAutomationRules</code> </a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ruleStatus} will
     * return {@link RuleStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #ruleStatusAsString}.
     * </p>
     * 
     * @return Whether the rule is active after it is created. If this parameter is equal to <code>ENABLED</code>,
     *         Security Hub starts applying the rule to findings and finding updates after the rule is created. To
     *         change the value of this parameter after creating a rule, use <a
     *         href="https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_BatchUpdateAutomationRules.html">
     *         <code>BatchUpdateAutomationRules</code> </a>.
     * @see RuleStatus
     */
    public final RuleStatus ruleStatus() {
        return RuleStatus.fromValue(ruleStatus);
    }

    /**
     * <p>
     * Whether the rule is active after it is created. If this parameter is equal to <code>ENABLED</code>, Security Hub
     * starts applying the rule to findings and finding updates after the rule is created. To change the value of this
     * parameter after creating a rule, use <a
     * href="https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_BatchUpdateAutomationRules.html">
     * <code>BatchUpdateAutomationRules</code> </a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ruleStatus} will
     * return {@link RuleStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #ruleStatusAsString}.
     * </p>
     * 
     * @return Whether the rule is active after it is created. If this parameter is equal to <code>ENABLED</code>,
     *         Security Hub starts applying the rule to findings and finding updates after the rule is created. To
     *         change the value of this parameter after creating a rule, use <a
     *         href="https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_BatchUpdateAutomationRules.html">
     *         <code>BatchUpdateAutomationRules</code> </a>.
     * @see RuleStatus
     */
    public final String ruleStatusAsString() {
        return ruleStatus;
    }

    /**
     * <p>
     * An integer ranging from 1 to 1000 that represents the order in which the rule action is applied to findings.
     * Security Hub applies rules with lower values for this parameter first.
     * </p>
     * 
     * @return An integer ranging from 1 to 1000 that represents the order in which the rule action is applied to
     *         findings. Security Hub applies rules with lower values for this parameter first.
     */
    public final Integer ruleOrder() {
        return ruleOrder;
    }

    /**
     * <p>
     * The name of the rule.
     * </p>
     * 
     * @return The name of the rule.
     */
    public final String ruleName() {
        return ruleName;
    }

    /**
     * <p>
     * A description of the rule.
     * </p>
     * 
     * @return A description of the rule.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * Specifies whether a rule is the last to be applied with respect to a finding that matches the rule criteria. This
     * is useful when a finding matches the criteria for multiple rules, and each rule has different actions. If a rule
     * is terminal, Security Hub applies the rule action to a finding that matches the rule criteria and doesn't
     * evaluate other rules for the finding. By default, a rule isn't terminal.
     * </p>
     * 
     * @return Specifies whether a rule is the last to be applied with respect to a finding that matches the rule
     *         criteria. This is useful when a finding matches the criteria for multiple rules, and each rule has
     *         different actions. If a rule is terminal, Security Hub applies the rule action to a finding that matches
     *         the rule criteria and doesn't evaluate other rules for the finding. By default, a rule isn't terminal.
     */
    public final Boolean isTerminal() {
        return isTerminal;
    }

    /**
     * <p>
     * A timestamp that indicates when the rule was created.
     * </p>
     * <p>
     * Uses the <code>date-time</code> format specified in <a href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC
     * 3339 section 5.6, Internet Date/Time Format</a>. The value cannot contain spaces. For example,
     * <code>2020-03-22T13:22:13.933Z</code>.
     * </p>
     * 
     * @return A timestamp that indicates when the rule was created. </p>
     *         <p>
     *         Uses the <code>date-time</code> format specified in <a
     *         href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet Date/Time
     *         Format</a>. The value cannot contain spaces. For example, <code>2020-03-22T13:22:13.933Z</code>.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * A timestamp that indicates when the rule was most recently updated.
     * </p>
     * <p>
     * Uses the <code>date-time</code> format specified in <a href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC
     * 3339 section 5.6, Internet Date/Time Format</a>. The value cannot contain spaces. For example,
     * <code>2020-03-22T13:22:13.933Z</code>.
     * </p>
     * 
     * @return A timestamp that indicates when the rule was most recently updated. </p>
     *         <p>
     *         Uses the <code>date-time</code> format specified in <a
     *         href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet Date/Time
     *         Format</a>. The value cannot contain spaces. For example, <code>2020-03-22T13:22:13.933Z</code>.
     */
    public final Instant updatedAt() {
        return updatedAt;
    }

    /**
     * <p>
     * The principal that created a rule.
     * </p>
     * 
     * @return The principal that created a rule.
     */
    public final String createdBy() {
        return createdBy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(ruleArn());
        hashCode = 31 * hashCode + Objects.hashCode(ruleStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(ruleOrder());
        hashCode = 31 * hashCode + Objects.hashCode(ruleName());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(isTerminal());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(createdBy());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutomationRulesMetadata)) {
            return false;
        }
        AutomationRulesMetadata other = (AutomationRulesMetadata) obj;
        return Objects.equals(ruleArn(), other.ruleArn()) && Objects.equals(ruleStatusAsString(), other.ruleStatusAsString())
                && Objects.equals(ruleOrder(), other.ruleOrder()) && Objects.equals(ruleName(), other.ruleName())
                && Objects.equals(description(), other.description()) && Objects.equals(isTerminal(), other.isTerminal())
                && Objects.equals(createdAt(), other.createdAt()) && Objects.equals(updatedAt(), other.updatedAt())
                && Objects.equals(createdBy(), other.createdBy());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AutomationRulesMetadata").add("RuleArn", ruleArn()).add("RuleStatus", ruleStatusAsString())
                .add("RuleOrder", ruleOrder()).add("RuleName", ruleName()).add("Description", description())
                .add("IsTerminal", isTerminal()).add("CreatedAt", createdAt()).add("UpdatedAt", updatedAt())
                .add("CreatedBy", createdBy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RuleArn":
            return Optional.ofNullable(clazz.cast(ruleArn()));
        case "RuleStatus":
            return Optional.ofNullable(clazz.cast(ruleStatusAsString()));
        case "RuleOrder":
            return Optional.ofNullable(clazz.cast(ruleOrder()));
        case "RuleName":
            return Optional.ofNullable(clazz.cast(ruleName()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "IsTerminal":
            return Optional.ofNullable(clazz.cast(isTerminal()));
        case "CreatedAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "UpdatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        case "CreatedBy":
            return Optional.ofNullable(clazz.cast(createdBy()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AutomationRulesMetadata, T> g) {
        return obj -> g.apply((AutomationRulesMetadata) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AutomationRulesMetadata> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) for the rule.
         * </p>
         * 
         * @param ruleArn
         *        The Amazon Resource Name (ARN) for the rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleArn(String ruleArn);

        /**
         * <p>
         * Whether the rule is active after it is created. If this parameter is equal to <code>ENABLED</code>, Security
         * Hub starts applying the rule to findings and finding updates after the rule is created. To change the value
         * of this parameter after creating a rule, use <a
         * href="https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_BatchUpdateAutomationRules.html">
         * <code>BatchUpdateAutomationRules</code> </a>.
         * </p>
         * 
         * @param ruleStatus
         *        Whether the rule is active after it is created. If this parameter is equal to <code>ENABLED</code>,
         *        Security Hub starts applying the rule to findings and finding updates after the rule is created. To
         *        change the value of this parameter after creating a rule, use <a
         *        href="https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_BatchUpdateAutomationRules.html">
         *        <code>BatchUpdateAutomationRules</code> </a>.
         * @see RuleStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RuleStatus
         */
        Builder ruleStatus(String ruleStatus);

        /**
         * <p>
         * Whether the rule is active after it is created. If this parameter is equal to <code>ENABLED</code>, Security
         * Hub starts applying the rule to findings and finding updates after the rule is created. To change the value
         * of this parameter after creating a rule, use <a
         * href="https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_BatchUpdateAutomationRules.html">
         * <code>BatchUpdateAutomationRules</code> </a>.
         * </p>
         * 
         * @param ruleStatus
         *        Whether the rule is active after it is created. If this parameter is equal to <code>ENABLED</code>,
         *        Security Hub starts applying the rule to findings and finding updates after the rule is created. To
         *        change the value of this parameter after creating a rule, use <a
         *        href="https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_BatchUpdateAutomationRules.html">
         *        <code>BatchUpdateAutomationRules</code> </a>.
         * @see RuleStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RuleStatus
         */
        Builder ruleStatus(RuleStatus ruleStatus);

        /**
         * <p>
         * An integer ranging from 1 to 1000 that represents the order in which the rule action is applied to findings.
         * Security Hub applies rules with lower values for this parameter first.
         * </p>
         * 
         * @param ruleOrder
         *        An integer ranging from 1 to 1000 that represents the order in which the rule action is applied to
         *        findings. Security Hub applies rules with lower values for this parameter first.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleOrder(Integer ruleOrder);

        /**
         * <p>
         * The name of the rule.
         * </p>
         * 
         * @param ruleName
         *        The name of the rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleName(String ruleName);

        /**
         * <p>
         * A description of the rule.
         * </p>
         * 
         * @param description
         *        A description of the rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Specifies whether a rule is the last to be applied with respect to a finding that matches the rule criteria.
         * This is useful when a finding matches the criteria for multiple rules, and each rule has different actions.
         * If a rule is terminal, Security Hub applies the rule action to a finding that matches the rule criteria and
         * doesn't evaluate other rules for the finding. By default, a rule isn't terminal.
         * </p>
         * 
         * @param isTerminal
         *        Specifies whether a rule is the last to be applied with respect to a finding that matches the rule
         *        criteria. This is useful when a finding matches the criteria for multiple rules, and each rule has
         *        different actions. If a rule is terminal, Security Hub applies the rule action to a finding that
         *        matches the rule criteria and doesn't evaluate other rules for the finding. By default, a rule isn't
         *        terminal.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isTerminal(Boolean isTerminal);

        /**
         * <p>
         * A timestamp that indicates when the rule was created.
         * </p>
         * <p>
         * Uses the <code>date-time</code> format specified in <a
         * href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet Date/Time Format</a>.
         * The value cannot contain spaces. For example, <code>2020-03-22T13:22:13.933Z</code>.
         * </p>
         * 
         * @param createdAt
         *        A timestamp that indicates when the rule was created. </p>
         *        <p>
         *        Uses the <code>date-time</code> format specified in <a
         *        href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet Date/Time
         *        Format</a>. The value cannot contain spaces. For example, <code>2020-03-22T13:22:13.933Z</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * A timestamp that indicates when the rule was most recently updated.
         * </p>
         * <p>
         * Uses the <code>date-time</code> format specified in <a
         * href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet Date/Time Format</a>.
         * The value cannot contain spaces. For example, <code>2020-03-22T13:22:13.933Z</code>.
         * </p>
         * 
         * @param updatedAt
         *        A timestamp that indicates when the rule was most recently updated. </p>
         *        <p>
         *        Uses the <code>date-time</code> format specified in <a
         *        href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet Date/Time
         *        Format</a>. The value cannot contain spaces. For example, <code>2020-03-22T13:22:13.933Z</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);

        /**
         * <p>
         * The principal that created a rule.
         * </p>
         * 
         * @param createdBy
         *        The principal that created a rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdBy(String createdBy);
    }

    static final class BuilderImpl implements Builder {
        private String ruleArn;

        private String ruleStatus;

        private Integer ruleOrder;

        private String ruleName;

        private String description;

        private Boolean isTerminal;

        private Instant createdAt;

        private Instant updatedAt;

        private String createdBy;

        private BuilderImpl() {
        }

        private BuilderImpl(AutomationRulesMetadata model) {
            ruleArn(model.ruleArn);
            ruleStatus(model.ruleStatus);
            ruleOrder(model.ruleOrder);
            ruleName(model.ruleName);
            description(model.description);
            isTerminal(model.isTerminal);
            createdAt(model.createdAt);
            updatedAt(model.updatedAt);
            createdBy(model.createdBy);
        }

        public final String getRuleArn() {
            return ruleArn;
        }

        public final void setRuleArn(String ruleArn) {
            this.ruleArn = ruleArn;
        }

        @Override
        public final Builder ruleArn(String ruleArn) {
            this.ruleArn = ruleArn;
            return this;
        }

        public final String getRuleStatus() {
            return ruleStatus;
        }

        public final void setRuleStatus(String ruleStatus) {
            this.ruleStatus = ruleStatus;
        }

        @Override
        public final Builder ruleStatus(String ruleStatus) {
            this.ruleStatus = ruleStatus;
            return this;
        }

        @Override
        public final Builder ruleStatus(RuleStatus ruleStatus) {
            this.ruleStatus(ruleStatus == null ? null : ruleStatus.toString());
            return this;
        }

        public final Integer getRuleOrder() {
            return ruleOrder;
        }

        public final void setRuleOrder(Integer ruleOrder) {
            this.ruleOrder = ruleOrder;
        }

        @Override
        public final Builder ruleOrder(Integer ruleOrder) {
            this.ruleOrder = ruleOrder;
            return this;
        }

        public final String getRuleName() {
            return ruleName;
        }

        public final void setRuleName(String ruleName) {
            this.ruleName = ruleName;
        }

        @Override
        public final Builder ruleName(String ruleName) {
            this.ruleName = ruleName;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Boolean getIsTerminal() {
            return isTerminal;
        }

        public final void setIsTerminal(Boolean isTerminal) {
            this.isTerminal = isTerminal;
        }

        @Override
        public final Builder isTerminal(Boolean isTerminal) {
            this.isTerminal = isTerminal;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final String getCreatedBy() {
            return createdBy;
        }

        public final void setCreatedBy(String createdBy) {
            this.createdBy = createdBy;
        }

        @Override
        public final Builder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        @Override
        public AutomationRulesMetadata build() {
            return new AutomationRulesMetadata(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
