/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information about the way an organization is configured in Security Hub.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OrganizationConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<OrganizationConfiguration.Builder, OrganizationConfiguration> {
    private static final SdkField<String> CONFIGURATION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConfigurationType").getter(getter(OrganizationConfiguration::configurationTypeAsString))
            .setter(setter(Builder::configurationType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationType").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(OrganizationConfiguration::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StatusMessage").getter(getter(OrganizationConfiguration::statusMessage))
            .setter(setter(Builder::statusMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusMessage").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIGURATION_TYPE_FIELD,
            STATUS_FIELD, STATUS_MESSAGE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String configurationType;

    private final String status;

    private final String statusMessage;

    private OrganizationConfiguration(BuilderImpl builder) {
        this.configurationType = builder.configurationType;
        this.status = builder.status;
        this.statusMessage = builder.statusMessage;
    }

    /**
     * <p>
     * Indicates whether the organization uses local or central configuration.
     * </p>
     * <p>
     * If you use local configuration, the Security Hub delegated administrator can set <code>AutoEnable</code> to
     * <code>true</code> and <code>AutoEnableStandards</code> to <code>DEFAULT</code>. This automatically enables
     * Security Hub and default security standards in new organization accounts. These new account settings must be set
     * separately in each Amazon Web Services Region, and settings may be different in each Region.
     * </p>
     * <p>
     * If you use central configuration, the delegated administrator can create configuration policies. Configuration
     * policies can be used to configure Security Hub, security standards, and security controls in multiple accounts
     * and Regions. If you want new organization accounts to use a specific configuration, you can create a
     * configuration policy and associate it with the root or specific organizational units (OUs). New accounts will
     * inherit the policy from the root or their assigned OU.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #configurationType}
     * will return {@link OrganizationConfigurationConfigurationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by
     * the service is available from {@link #configurationTypeAsString}.
     * </p>
     * 
     * @return Indicates whether the organization uses local or central configuration. </p>
     *         <p>
     *         If you use local configuration, the Security Hub delegated administrator can set <code>AutoEnable</code>
     *         to <code>true</code> and <code>AutoEnableStandards</code> to <code>DEFAULT</code>. This automatically
     *         enables Security Hub and default security standards in new organization accounts. These new account
     *         settings must be set separately in each Amazon Web Services Region, and settings may be different in each
     *         Region.
     *         </p>
     *         <p>
     *         If you use central configuration, the delegated administrator can create configuration policies.
     *         Configuration policies can be used to configure Security Hub, security standards, and security controls
     *         in multiple accounts and Regions. If you want new organization accounts to use a specific configuration,
     *         you can create a configuration policy and associate it with the root or specific organizational units
     *         (OUs). New accounts will inherit the policy from the root or their assigned OU.
     * @see OrganizationConfigurationConfigurationType
     */
    public final OrganizationConfigurationConfigurationType configurationType() {
        return OrganizationConfigurationConfigurationType.fromValue(configurationType);
    }

    /**
     * <p>
     * Indicates whether the organization uses local or central configuration.
     * </p>
     * <p>
     * If you use local configuration, the Security Hub delegated administrator can set <code>AutoEnable</code> to
     * <code>true</code> and <code>AutoEnableStandards</code> to <code>DEFAULT</code>. This automatically enables
     * Security Hub and default security standards in new organization accounts. These new account settings must be set
     * separately in each Amazon Web Services Region, and settings may be different in each Region.
     * </p>
     * <p>
     * If you use central configuration, the delegated administrator can create configuration policies. Configuration
     * policies can be used to configure Security Hub, security standards, and security controls in multiple accounts
     * and Regions. If you want new organization accounts to use a specific configuration, you can create a
     * configuration policy and associate it with the root or specific organizational units (OUs). New accounts will
     * inherit the policy from the root or their assigned OU.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #configurationType}
     * will return {@link OrganizationConfigurationConfigurationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by
     * the service is available from {@link #configurationTypeAsString}.
     * </p>
     * 
     * @return Indicates whether the organization uses local or central configuration. </p>
     *         <p>
     *         If you use local configuration, the Security Hub delegated administrator can set <code>AutoEnable</code>
     *         to <code>true</code> and <code>AutoEnableStandards</code> to <code>DEFAULT</code>. This automatically
     *         enables Security Hub and default security standards in new organization accounts. These new account
     *         settings must be set separately in each Amazon Web Services Region, and settings may be different in each
     *         Region.
     *         </p>
     *         <p>
     *         If you use central configuration, the delegated administrator can create configuration policies.
     *         Configuration policies can be used to configure Security Hub, security standards, and security controls
     *         in multiple accounts and Regions. If you want new organization accounts to use a specific configuration,
     *         you can create a configuration policy and associate it with the root or specific organizational units
     *         (OUs). New accounts will inherit the policy from the root or their assigned OU.
     * @see OrganizationConfigurationConfigurationType
     */
    public final String configurationTypeAsString() {
        return configurationType;
    }

    /**
     * <p>
     * Describes whether central configuration could be enabled as the <code>ConfigurationType</code> for the
     * organization. If your <code>ConfigurationType</code> is local configuration, then the value of
     * <code>Status</code> is always <code>ENABLED</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link OrganizationConfigurationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return Describes whether central configuration could be enabled as the <code>ConfigurationType</code> for the
     *         organization. If your <code>ConfigurationType</code> is local configuration, then the value of
     *         <code>Status</code> is always <code>ENABLED</code>.
     * @see OrganizationConfigurationStatus
     */
    public final OrganizationConfigurationStatus status() {
        return OrganizationConfigurationStatus.fromValue(status);
    }

    /**
     * <p>
     * Describes whether central configuration could be enabled as the <code>ConfigurationType</code> for the
     * organization. If your <code>ConfigurationType</code> is local configuration, then the value of
     * <code>Status</code> is always <code>ENABLED</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link OrganizationConfigurationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return Describes whether central configuration could be enabled as the <code>ConfigurationType</code> for the
     *         organization. If your <code>ConfigurationType</code> is local configuration, then the value of
     *         <code>Status</code> is always <code>ENABLED</code>.
     * @see OrganizationConfigurationStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * Provides an explanation if the value of <code>Status</code> is equal to <code>FAILED</code> when
     * <code>ConfigurationType</code> is equal to <code>CENTRAL</code>.
     * </p>
     * 
     * @return Provides an explanation if the value of <code>Status</code> is equal to <code>FAILED</code> when
     *         <code>ConfigurationType</code> is equal to <code>CENTRAL</code>.
     */
    public final String statusMessage() {
        return statusMessage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(configurationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusMessage());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OrganizationConfiguration)) {
            return false;
        }
        OrganizationConfiguration other = (OrganizationConfiguration) obj;
        return Objects.equals(configurationTypeAsString(), other.configurationTypeAsString())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(statusMessage(), other.statusMessage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OrganizationConfiguration").add("ConfigurationType", configurationTypeAsString())
                .add("Status", statusAsString()).add("StatusMessage", statusMessage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConfigurationType":
            return Optional.ofNullable(clazz.cast(configurationTypeAsString()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "StatusMessage":
            return Optional.ofNullable(clazz.cast(statusMessage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OrganizationConfiguration, T> g) {
        return obj -> g.apply((OrganizationConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OrganizationConfiguration> {
        /**
         * <p>
         * Indicates whether the organization uses local or central configuration.
         * </p>
         * <p>
         * If you use local configuration, the Security Hub delegated administrator can set <code>AutoEnable</code> to
         * <code>true</code> and <code>AutoEnableStandards</code> to <code>DEFAULT</code>. This automatically enables
         * Security Hub and default security standards in new organization accounts. These new account settings must be
         * set separately in each Amazon Web Services Region, and settings may be different in each Region.
         * </p>
         * <p>
         * If you use central configuration, the delegated administrator can create configuration policies.
         * Configuration policies can be used to configure Security Hub, security standards, and security controls in
         * multiple accounts and Regions. If you want new organization accounts to use a specific configuration, you can
         * create a configuration policy and associate it with the root or specific organizational units (OUs). New
         * accounts will inherit the policy from the root or their assigned OU.
         * </p>
         * 
         * @param configurationType
         *        Indicates whether the organization uses local or central configuration. </p>
         *        <p>
         *        If you use local configuration, the Security Hub delegated administrator can set
         *        <code>AutoEnable</code> to <code>true</code> and <code>AutoEnableStandards</code> to
         *        <code>DEFAULT</code>. This automatically enables Security Hub and default security standards in new
         *        organization accounts. These new account settings must be set separately in each Amazon Web Services
         *        Region, and settings may be different in each Region.
         *        </p>
         *        <p>
         *        If you use central configuration, the delegated administrator can create configuration policies.
         *        Configuration policies can be used to configure Security Hub, security standards, and security
         *        controls in multiple accounts and Regions. If you want new organization accounts to use a specific
         *        configuration, you can create a configuration policy and associate it with the root or specific
         *        organizational units (OUs). New accounts will inherit the policy from the root or their assigned OU.
         * @see OrganizationConfigurationConfigurationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OrganizationConfigurationConfigurationType
         */
        Builder configurationType(String configurationType);

        /**
         * <p>
         * Indicates whether the organization uses local or central configuration.
         * </p>
         * <p>
         * If you use local configuration, the Security Hub delegated administrator can set <code>AutoEnable</code> to
         * <code>true</code> and <code>AutoEnableStandards</code> to <code>DEFAULT</code>. This automatically enables
         * Security Hub and default security standards in new organization accounts. These new account settings must be
         * set separately in each Amazon Web Services Region, and settings may be different in each Region.
         * </p>
         * <p>
         * If you use central configuration, the delegated administrator can create configuration policies.
         * Configuration policies can be used to configure Security Hub, security standards, and security controls in
         * multiple accounts and Regions. If you want new organization accounts to use a specific configuration, you can
         * create a configuration policy and associate it with the root or specific organizational units (OUs). New
         * accounts will inherit the policy from the root or their assigned OU.
         * </p>
         * 
         * @param configurationType
         *        Indicates whether the organization uses local or central configuration. </p>
         *        <p>
         *        If you use local configuration, the Security Hub delegated administrator can set
         *        <code>AutoEnable</code> to <code>true</code> and <code>AutoEnableStandards</code> to
         *        <code>DEFAULT</code>. This automatically enables Security Hub and default security standards in new
         *        organization accounts. These new account settings must be set separately in each Amazon Web Services
         *        Region, and settings may be different in each Region.
         *        </p>
         *        <p>
         *        If you use central configuration, the delegated administrator can create configuration policies.
         *        Configuration policies can be used to configure Security Hub, security standards, and security
         *        controls in multiple accounts and Regions. If you want new organization accounts to use a specific
         *        configuration, you can create a configuration policy and associate it with the root or specific
         *        organizational units (OUs). New accounts will inherit the policy from the root or their assigned OU.
         * @see OrganizationConfigurationConfigurationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OrganizationConfigurationConfigurationType
         */
        Builder configurationType(OrganizationConfigurationConfigurationType configurationType);

        /**
         * <p>
         * Describes whether central configuration could be enabled as the <code>ConfigurationType</code> for the
         * organization. If your <code>ConfigurationType</code> is local configuration, then the value of
         * <code>Status</code> is always <code>ENABLED</code>.
         * </p>
         * 
         * @param status
         *        Describes whether central configuration could be enabled as the <code>ConfigurationType</code> for the
         *        organization. If your <code>ConfigurationType</code> is local configuration, then the value of
         *        <code>Status</code> is always <code>ENABLED</code>.
         * @see OrganizationConfigurationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OrganizationConfigurationStatus
         */
        Builder status(String status);

        /**
         * <p>
         * Describes whether central configuration could be enabled as the <code>ConfigurationType</code> for the
         * organization. If your <code>ConfigurationType</code> is local configuration, then the value of
         * <code>Status</code> is always <code>ENABLED</code>.
         * </p>
         * 
         * @param status
         *        Describes whether central configuration could be enabled as the <code>ConfigurationType</code> for the
         *        organization. If your <code>ConfigurationType</code> is local configuration, then the value of
         *        <code>Status</code> is always <code>ENABLED</code>.
         * @see OrganizationConfigurationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OrganizationConfigurationStatus
         */
        Builder status(OrganizationConfigurationStatus status);

        /**
         * <p>
         * Provides an explanation if the value of <code>Status</code> is equal to <code>FAILED</code> when
         * <code>ConfigurationType</code> is equal to <code>CENTRAL</code>.
         * </p>
         * 
         * @param statusMessage
         *        Provides an explanation if the value of <code>Status</code> is equal to <code>FAILED</code> when
         *        <code>ConfigurationType</code> is equal to <code>CENTRAL</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusMessage(String statusMessage);
    }

    static final class BuilderImpl implements Builder {
        private String configurationType;

        private String status;

        private String statusMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(OrganizationConfiguration model) {
            configurationType(model.configurationType);
            status(model.status);
            statusMessage(model.statusMessage);
        }

        public final String getConfigurationType() {
            return configurationType;
        }

        public final void setConfigurationType(String configurationType) {
            this.configurationType = configurationType;
        }

        @Override
        public final Builder configurationType(String configurationType) {
            this.configurationType = configurationType;
            return this;
        }

        @Override
        public final Builder configurationType(OrganizationConfigurationConfigurationType configurationType) {
            this.configurationType(configurationType == null ? null : configurationType.toString());
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(OrganizationConfigurationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusMessage() {
            return statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        @Override
        public OrganizationConfiguration build() {
            return new OrganizationConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
