/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The options for customizing a security control parameter that is a list of strings.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StringListConfigurationOptions implements SdkPojo, Serializable,
        ToCopyableBuilder<StringListConfigurationOptions.Builder, StringListConfigurationOptions> {
    private static final SdkField<List<String>> DEFAULT_VALUE_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("DefaultValue")
            .getter(getter(StringListConfigurationOptions::defaultValue))
            .setter(setter(Builder::defaultValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultValue").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> RE2_EXPRESSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Re2Expression").getter(getter(StringListConfigurationOptions::re2Expression))
            .setter(setter(Builder::re2Expression))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Re2Expression").build()).build();

    private static final SdkField<Integer> MAX_ITEMS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxItems").getter(getter(StringListConfigurationOptions::maxItems)).setter(setter(Builder::maxItems))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxItems").build()).build();

    private static final SdkField<String> EXPRESSION_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ExpressionDescription").getter(getter(StringListConfigurationOptions::expressionDescription))
            .setter(setter(Builder::expressionDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpressionDescription").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEFAULT_VALUE_FIELD,
            RE2_EXPRESSION_FIELD, MAX_ITEMS_FIELD, EXPRESSION_DESCRIPTION_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> defaultValue;

    private final String re2Expression;

    private final Integer maxItems;

    private final String expressionDescription;

    private StringListConfigurationOptions(BuilderImpl builder) {
        this.defaultValue = builder.defaultValue;
        this.re2Expression = builder.re2Expression;
        this.maxItems = builder.maxItems;
        this.expressionDescription = builder.expressionDescription;
    }

    /**
     * For responses, this returns true if the service returned a value for the DefaultValue property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDefaultValue() {
        return defaultValue != null && !(defaultValue instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Security Hub default value for a control parameter that is a list of strings.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDefaultValue} method.
     * </p>
     * 
     * @return The Security Hub default value for a control parameter that is a list of strings.
     */
    public final List<String> defaultValue() {
        return defaultValue;
    }

    /**
     * <p>
     * An RE2 regular expression that Security Hub uses to validate a user-provided list of strings for a control
     * parameter.
     * </p>
     * 
     * @return An RE2 regular expression that Security Hub uses to validate a user-provided list of strings for a
     *         control parameter.
     */
    public final String re2Expression() {
        return re2Expression;
    }

    /**
     * <p>
     * The maximum number of list items that a string list control parameter can accept.
     * </p>
     * 
     * @return The maximum number of list items that a string list control parameter can accept.
     */
    public final Integer maxItems() {
        return maxItems;
    }

    /**
     * <p>
     * The description of the RE2 regular expression.
     * </p>
     * 
     * @return The description of the RE2 regular expression.
     */
    public final String expressionDescription() {
        return expressionDescription;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasDefaultValue() ? defaultValue() : null);
        hashCode = 31 * hashCode + Objects.hashCode(re2Expression());
        hashCode = 31 * hashCode + Objects.hashCode(maxItems());
        hashCode = 31 * hashCode + Objects.hashCode(expressionDescription());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StringListConfigurationOptions)) {
            return false;
        }
        StringListConfigurationOptions other = (StringListConfigurationOptions) obj;
        return hasDefaultValue() == other.hasDefaultValue() && Objects.equals(defaultValue(), other.defaultValue())
                && Objects.equals(re2Expression(), other.re2Expression()) && Objects.equals(maxItems(), other.maxItems())
                && Objects.equals(expressionDescription(), other.expressionDescription());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StringListConfigurationOptions").add("DefaultValue", hasDefaultValue() ? defaultValue() : null)
                .add("Re2Expression", re2Expression()).add("MaxItems", maxItems())
                .add("ExpressionDescription", expressionDescription()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DefaultValue":
            return Optional.ofNullable(clazz.cast(defaultValue()));
        case "Re2Expression":
            return Optional.ofNullable(clazz.cast(re2Expression()));
        case "MaxItems":
            return Optional.ofNullable(clazz.cast(maxItems()));
        case "ExpressionDescription":
            return Optional.ofNullable(clazz.cast(expressionDescription()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StringListConfigurationOptions, T> g) {
        return obj -> g.apply((StringListConfigurationOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, StringListConfigurationOptions> {
        /**
         * <p>
         * The Security Hub default value for a control parameter that is a list of strings.
         * </p>
         * 
         * @param defaultValue
         *        The Security Hub default value for a control parameter that is a list of strings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultValue(Collection<String> defaultValue);

        /**
         * <p>
         * The Security Hub default value for a control parameter that is a list of strings.
         * </p>
         * 
         * @param defaultValue
         *        The Security Hub default value for a control parameter that is a list of strings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultValue(String... defaultValue);

        /**
         * <p>
         * An RE2 regular expression that Security Hub uses to validate a user-provided list of strings for a control
         * parameter.
         * </p>
         * 
         * @param re2Expression
         *        An RE2 regular expression that Security Hub uses to validate a user-provided list of strings for a
         *        control parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder re2Expression(String re2Expression);

        /**
         * <p>
         * The maximum number of list items that a string list control parameter can accept.
         * </p>
         * 
         * @param maxItems
         *        The maximum number of list items that a string list control parameter can accept.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxItems(Integer maxItems);

        /**
         * <p>
         * The description of the RE2 regular expression.
         * </p>
         * 
         * @param expressionDescription
         *        The description of the RE2 regular expression.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expressionDescription(String expressionDescription);
    }

    static final class BuilderImpl implements Builder {
        private List<String> defaultValue = DefaultSdkAutoConstructList.getInstance();

        private String re2Expression;

        private Integer maxItems;

        private String expressionDescription;

        private BuilderImpl() {
        }

        private BuilderImpl(StringListConfigurationOptions model) {
            defaultValue(model.defaultValue);
            re2Expression(model.re2Expression);
            maxItems(model.maxItems);
            expressionDescription(model.expressionDescription);
        }

        public final Collection<String> getDefaultValue() {
            if (defaultValue instanceof SdkAutoConstructList) {
                return null;
            }
            return defaultValue;
        }

        public final void setDefaultValue(Collection<String> defaultValue) {
            this.defaultValue = StringListCopier.copy(defaultValue);
        }

        @Override
        public final Builder defaultValue(Collection<String> defaultValue) {
            this.defaultValue = StringListCopier.copy(defaultValue);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder defaultValue(String... defaultValue) {
            defaultValue(Arrays.asList(defaultValue));
            return this;
        }

        public final String getRe2Expression() {
            return re2Expression;
        }

        public final void setRe2Expression(String re2Expression) {
            this.re2Expression = re2Expression;
        }

        @Override
        public final Builder re2Expression(String re2Expression) {
            this.re2Expression = re2Expression;
            return this;
        }

        public final Integer getMaxItems() {
            return maxItems;
        }

        public final void setMaxItems(Integer maxItems) {
            this.maxItems = maxItems;
        }

        @Override
        public final Builder maxItems(Integer maxItems) {
            this.maxItems = maxItems;
            return this;
        }

        public final String getExpressionDescription() {
            return expressionDescription;
        }

        public final void setExpressionDescription(String expressionDescription) {
            this.expressionDescription = expressionDescription;
        }

        @Override
        public final Builder expressionDescription(String expressionDescription) {
            this.expressionDescription = expressionDescription;
            return this;
        }

        @Override
        public StringListConfigurationOptions build() {
            return new StringListConfigurationOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
