/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Parameters that are used to automatically set up EBS volumes when an instance is launched.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsAutoScalingLaunchConfigurationBlockDeviceMappingsEbsDetails
        implements
        SdkPojo,
        Serializable,
        ToCopyableBuilder<AwsAutoScalingLaunchConfigurationBlockDeviceMappingsEbsDetails.Builder, AwsAutoScalingLaunchConfigurationBlockDeviceMappingsEbsDetails> {
    private static final SdkField<Boolean> DELETE_ON_TERMINATION_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DeleteOnTermination")
            .getter(getter(AwsAutoScalingLaunchConfigurationBlockDeviceMappingsEbsDetails::deleteOnTermination))
            .setter(setter(Builder::deleteOnTermination))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeleteOnTermination").build())
            .build();

    private static final SdkField<Boolean> ENCRYPTED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Encrypted").getter(getter(AwsAutoScalingLaunchConfigurationBlockDeviceMappingsEbsDetails::encrypted))
            .setter(setter(Builder::encrypted))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Encrypted").build()).build();

    private static final SdkField<Integer> IOPS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Iops")
            .getter(getter(AwsAutoScalingLaunchConfigurationBlockDeviceMappingsEbsDetails::iops)).setter(setter(Builder::iops))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Iops").build()).build();

    private static final SdkField<String> SNAPSHOT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SnapshotId").getter(getter(AwsAutoScalingLaunchConfigurationBlockDeviceMappingsEbsDetails::snapshotId))
            .setter(setter(Builder::snapshotId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotId").build()).build();

    private static final SdkField<Integer> VOLUME_SIZE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("VolumeSize").getter(getter(AwsAutoScalingLaunchConfigurationBlockDeviceMappingsEbsDetails::volumeSize))
            .setter(setter(Builder::volumeSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeSize").build()).build();

    private static final SdkField<String> VOLUME_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VolumeType").getter(getter(AwsAutoScalingLaunchConfigurationBlockDeviceMappingsEbsDetails::volumeType))
            .setter(setter(Builder::volumeType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DELETE_ON_TERMINATION_FIELD,
            ENCRYPTED_FIELD, IOPS_FIELD, SNAPSHOT_ID_FIELD, VOLUME_SIZE_FIELD, VOLUME_TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final Boolean deleteOnTermination;

    private final Boolean encrypted;

    private final Integer iops;

    private final String snapshotId;

    private final Integer volumeSize;

    private final String volumeType;

    private AwsAutoScalingLaunchConfigurationBlockDeviceMappingsEbsDetails(BuilderImpl builder) {
        this.deleteOnTermination = builder.deleteOnTermination;
        this.encrypted = builder.encrypted;
        this.iops = builder.iops;
        this.snapshotId = builder.snapshotId;
        this.volumeSize = builder.volumeSize;
        this.volumeType = builder.volumeType;
    }

    /**
     * <p>
     * Whether to delete the volume when the instance is terminated.
     * </p>
     * 
     * @return Whether to delete the volume when the instance is terminated.
     */
    public final Boolean deleteOnTermination() {
        return deleteOnTermination;
    }

    /**
     * <p>
     * Whether to encrypt the volume.
     * </p>
     * 
     * @return Whether to encrypt the volume.
     */
    public final Boolean encrypted() {
        return encrypted;
    }

    /**
     * <p>
     * The number of input/output (I/O) operations per second (IOPS) to provision for the volume.
     * </p>
     * <p>
     * Only supported for <code>gp3</code> or <code>io1</code> volumes. Required for <code>io1</code> volumes. Not used
     * with <code>standard</code>, <code>gp2</code>, <code>st1</code>, or <code>sc1</code> volumes.
     * </p>
     * 
     * @return The number of input/output (I/O) operations per second (IOPS) to provision for the volume.</p>
     *         <p>
     *         Only supported for <code>gp3</code> or <code>io1</code> volumes. Required for <code>io1</code> volumes.
     *         Not used with <code>standard</code>, <code>gp2</code>, <code>st1</code>, or <code>sc1</code> volumes.
     */
    public final Integer iops() {
        return iops;
    }

    /**
     * <p>
     * The snapshot ID of the volume to use.
     * </p>
     * <p>
     * You must specify either <code>VolumeSize</code> or <code>SnapshotId</code>.
     * </p>
     * 
     * @return The snapshot ID of the volume to use.</p>
     *         <p>
     *         You must specify either <code>VolumeSize</code> or <code>SnapshotId</code>.
     */
    public final String snapshotId() {
        return snapshotId;
    }

    /**
     * <p>
     * The volume size, in GiBs. The following are the supported volumes sizes for each volume type:
     * </p>
     * <ul>
     * <li>
     * <p>
     * gp2 and gp3: 1-16,384
     * </p>
     * </li>
     * <li>
     * <p>
     * io1: 4-16,384
     * </p>
     * </li>
     * <li>
     * <p>
     * st1 and sc1: 125-16,384
     * </p>
     * </li>
     * <li>
     * <p>
     * standard: 1-1,024
     * </p>
     * </li>
     * </ul>
     * <p>
     * You must specify either <code>SnapshotId</code> or <code>VolumeSize</code>. If you specify both
     * <code>SnapshotId</code> and <code>VolumeSize</code>, the volume size must be equal or greater than the size of
     * the snapshot.
     * </p>
     * 
     * @return The volume size, in GiBs. The following are the supported volumes sizes for each volume type:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         gp2 and gp3: 1-16,384
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         io1: 4-16,384
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         st1 and sc1: 125-16,384
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         standard: 1-1,024
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         You must specify either <code>SnapshotId</code> or <code>VolumeSize</code>. If you specify both
     *         <code>SnapshotId</code> and <code>VolumeSize</code>, the volume size must be equal or greater than the
     *         size of the snapshot.
     */
    public final Integer volumeSize() {
        return volumeSize;
    }

    /**
     * <p>
     * The volume type. Valid values are as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>gp2</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>gp3</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>io1</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>sc1</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>st1</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>standard</code>
     * </p>
     * </li>
     * </ul>
     * 
     * @return The volume type. Valid values are as follows:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>gp2</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>gp3</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>io1</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>sc1</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>st1</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>standard</code>
     *         </p>
     *         </li>
     */
    public final String volumeType() {
        return volumeType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(deleteOnTermination());
        hashCode = 31 * hashCode + Objects.hashCode(encrypted());
        hashCode = 31 * hashCode + Objects.hashCode(iops());
        hashCode = 31 * hashCode + Objects.hashCode(snapshotId());
        hashCode = 31 * hashCode + Objects.hashCode(volumeSize());
        hashCode = 31 * hashCode + Objects.hashCode(volumeType());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsAutoScalingLaunchConfigurationBlockDeviceMappingsEbsDetails)) {
            return false;
        }
        AwsAutoScalingLaunchConfigurationBlockDeviceMappingsEbsDetails other = (AwsAutoScalingLaunchConfigurationBlockDeviceMappingsEbsDetails) obj;
        return Objects.equals(deleteOnTermination(), other.deleteOnTermination())
                && Objects.equals(encrypted(), other.encrypted()) && Objects.equals(iops(), other.iops())
                && Objects.equals(snapshotId(), other.snapshotId()) && Objects.equals(volumeSize(), other.volumeSize())
                && Objects.equals(volumeType(), other.volumeType());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsAutoScalingLaunchConfigurationBlockDeviceMappingsEbsDetails")
                .add("DeleteOnTermination", deleteOnTermination()).add("Encrypted", encrypted()).add("Iops", iops())
                .add("SnapshotId", snapshotId()).add("VolumeSize", volumeSize()).add("VolumeType", volumeType()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DeleteOnTermination":
            return Optional.ofNullable(clazz.cast(deleteOnTermination()));
        case "Encrypted":
            return Optional.ofNullable(clazz.cast(encrypted()));
        case "Iops":
            return Optional.ofNullable(clazz.cast(iops()));
        case "SnapshotId":
            return Optional.ofNullable(clazz.cast(snapshotId()));
        case "VolumeSize":
            return Optional.ofNullable(clazz.cast(volumeSize()));
        case "VolumeType":
            return Optional.ofNullable(clazz.cast(volumeType()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsAutoScalingLaunchConfigurationBlockDeviceMappingsEbsDetails, T> g) {
        return obj -> g.apply((AwsAutoScalingLaunchConfigurationBlockDeviceMappingsEbsDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo,
            CopyableBuilder<Builder, AwsAutoScalingLaunchConfigurationBlockDeviceMappingsEbsDetails> {
        /**
         * <p>
         * Whether to delete the volume when the instance is terminated.
         * </p>
         * 
         * @param deleteOnTermination
         *        Whether to delete the volume when the instance is terminated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deleteOnTermination(Boolean deleteOnTermination);

        /**
         * <p>
         * Whether to encrypt the volume.
         * </p>
         * 
         * @param encrypted
         *        Whether to encrypt the volume.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encrypted(Boolean encrypted);

        /**
         * <p>
         * The number of input/output (I/O) operations per second (IOPS) to provision for the volume.
         * </p>
         * <p>
         * Only supported for <code>gp3</code> or <code>io1</code> volumes. Required for <code>io1</code> volumes. Not
         * used with <code>standard</code>, <code>gp2</code>, <code>st1</code>, or <code>sc1</code> volumes.
         * </p>
         * 
         * @param iops
         *        The number of input/output (I/O) operations per second (IOPS) to provision for the volume.</p>
         *        <p>
         *        Only supported for <code>gp3</code> or <code>io1</code> volumes. Required for <code>io1</code>
         *        volumes. Not used with <code>standard</code>, <code>gp2</code>, <code>st1</code>, or <code>sc1</code>
         *        volumes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iops(Integer iops);

        /**
         * <p>
         * The snapshot ID of the volume to use.
         * </p>
         * <p>
         * You must specify either <code>VolumeSize</code> or <code>SnapshotId</code>.
         * </p>
         * 
         * @param snapshotId
         *        The snapshot ID of the volume to use.</p>
         *        <p>
         *        You must specify either <code>VolumeSize</code> or <code>SnapshotId</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotId(String snapshotId);

        /**
         * <p>
         * The volume size, in GiBs. The following are the supported volumes sizes for each volume type:
         * </p>
         * <ul>
         * <li>
         * <p>
         * gp2 and gp3: 1-16,384
         * </p>
         * </li>
         * <li>
         * <p>
         * io1: 4-16,384
         * </p>
         * </li>
         * <li>
         * <p>
         * st1 and sc1: 125-16,384
         * </p>
         * </li>
         * <li>
         * <p>
         * standard: 1-1,024
         * </p>
         * </li>
         * </ul>
         * <p>
         * You must specify either <code>SnapshotId</code> or <code>VolumeSize</code>. If you specify both
         * <code>SnapshotId</code> and <code>VolumeSize</code>, the volume size must be equal or greater than the size
         * of the snapshot.
         * </p>
         * 
         * @param volumeSize
         *        The volume size, in GiBs. The following are the supported volumes sizes for each volume type:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        gp2 and gp3: 1-16,384
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        io1: 4-16,384
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        st1 and sc1: 125-16,384
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        standard: 1-1,024
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        You must specify either <code>SnapshotId</code> or <code>VolumeSize</code>. If you specify both
         *        <code>SnapshotId</code> and <code>VolumeSize</code>, the volume size must be equal or greater than the
         *        size of the snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeSize(Integer volumeSize);

        /**
         * <p>
         * The volume type. Valid values are as follows:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>gp2</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>gp3</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>io1</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>sc1</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>st1</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>standard</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param volumeType
         *        The volume type. Valid values are as follows:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>gp2</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>gp3</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>io1</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>sc1</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>st1</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>standard</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeType(String volumeType);
    }

    static final class BuilderImpl implements Builder {
        private Boolean deleteOnTermination;

        private Boolean encrypted;

        private Integer iops;

        private String snapshotId;

        private Integer volumeSize;

        private String volumeType;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsAutoScalingLaunchConfigurationBlockDeviceMappingsEbsDetails model) {
            deleteOnTermination(model.deleteOnTermination);
            encrypted(model.encrypted);
            iops(model.iops);
            snapshotId(model.snapshotId);
            volumeSize(model.volumeSize);
            volumeType(model.volumeType);
        }

        public final Boolean getDeleteOnTermination() {
            return deleteOnTermination;
        }

        public final void setDeleteOnTermination(Boolean deleteOnTermination) {
            this.deleteOnTermination = deleteOnTermination;
        }

        @Override
        public final Builder deleteOnTermination(Boolean deleteOnTermination) {
            this.deleteOnTermination = deleteOnTermination;
            return this;
        }

        public final Boolean getEncrypted() {
            return encrypted;
        }

        public final void setEncrypted(Boolean encrypted) {
            this.encrypted = encrypted;
        }

        @Override
        public final Builder encrypted(Boolean encrypted) {
            this.encrypted = encrypted;
            return this;
        }

        public final Integer getIops() {
            return iops;
        }

        public final void setIops(Integer iops) {
            this.iops = iops;
        }

        @Override
        public final Builder iops(Integer iops) {
            this.iops = iops;
            return this;
        }

        public final String getSnapshotId() {
            return snapshotId;
        }

        public final void setSnapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
        }

        @Override
        public final Builder snapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
            return this;
        }

        public final Integer getVolumeSize() {
            return volumeSize;
        }

        public final void setVolumeSize(Integer volumeSize) {
            this.volumeSize = volumeSize;
        }

        @Override
        public final Builder volumeSize(Integer volumeSize) {
            this.volumeSize = volumeSize;
            return this;
        }

        public final String getVolumeType() {
            return volumeType;
        }

        public final void setVolumeType(String volumeType) {
            this.volumeType = volumeType;
        }

        @Override
        public final Builder volumeType(String volumeType) {
            this.volumeType = volumeType;
            return this;
        }

        @Override
        public AwsAutoScalingLaunchConfigurationBlockDeviceMappingsEbsDetails build() {
            return new AwsAutoScalingLaunchConfigurationBlockDeviceMappingsEbsDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
