/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about logs for the build project.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsCodeBuildProjectLogsConfigDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsCodeBuildProjectLogsConfigDetails.Builder, AwsCodeBuildProjectLogsConfigDetails> {
    private static final SdkField<AwsCodeBuildProjectLogsConfigCloudWatchLogsDetails> CLOUD_WATCH_LOGS_FIELD = SdkField
            .<AwsCodeBuildProjectLogsConfigCloudWatchLogsDetails> builder(MarshallingType.SDK_POJO).memberName("CloudWatchLogs")
            .getter(getter(AwsCodeBuildProjectLogsConfigDetails::cloudWatchLogs)).setter(setter(Builder::cloudWatchLogs))
            .constructor(AwsCodeBuildProjectLogsConfigCloudWatchLogsDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudWatchLogs").build()).build();

    private static final SdkField<AwsCodeBuildProjectLogsConfigS3LogsDetails> S3_LOGS_FIELD = SdkField
            .<AwsCodeBuildProjectLogsConfigS3LogsDetails> builder(MarshallingType.SDK_POJO).memberName("S3Logs")
            .getter(getter(AwsCodeBuildProjectLogsConfigDetails::s3Logs)).setter(setter(Builder::s3Logs))
            .constructor(AwsCodeBuildProjectLogsConfigS3LogsDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Logs").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLOUD_WATCH_LOGS_FIELD,
            S3_LOGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final AwsCodeBuildProjectLogsConfigCloudWatchLogsDetails cloudWatchLogs;

    private final AwsCodeBuildProjectLogsConfigS3LogsDetails s3Logs;

    private AwsCodeBuildProjectLogsConfigDetails(BuilderImpl builder) {
        this.cloudWatchLogs = builder.cloudWatchLogs;
        this.s3Logs = builder.s3Logs;
    }

    /**
     * <p>
     * Information about CloudWatch Logs for the build project.
     * </p>
     * 
     * @return Information about CloudWatch Logs for the build project.
     */
    public final AwsCodeBuildProjectLogsConfigCloudWatchLogsDetails cloudWatchLogs() {
        return cloudWatchLogs;
    }

    /**
     * <p>
     * Information about logs built to an S3 bucket for a build project.
     * </p>
     * 
     * @return Information about logs built to an S3 bucket for a build project.
     */
    public final AwsCodeBuildProjectLogsConfigS3LogsDetails s3Logs() {
        return s3Logs;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(cloudWatchLogs());
        hashCode = 31 * hashCode + Objects.hashCode(s3Logs());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsCodeBuildProjectLogsConfigDetails)) {
            return false;
        }
        AwsCodeBuildProjectLogsConfigDetails other = (AwsCodeBuildProjectLogsConfigDetails) obj;
        return Objects.equals(cloudWatchLogs(), other.cloudWatchLogs()) && Objects.equals(s3Logs(), other.s3Logs());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsCodeBuildProjectLogsConfigDetails").add("CloudWatchLogs", cloudWatchLogs())
                .add("S3Logs", s3Logs()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CloudWatchLogs":
            return Optional.ofNullable(clazz.cast(cloudWatchLogs()));
        case "S3Logs":
            return Optional.ofNullable(clazz.cast(s3Logs()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsCodeBuildProjectLogsConfigDetails, T> g) {
        return obj -> g.apply((AwsCodeBuildProjectLogsConfigDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsCodeBuildProjectLogsConfigDetails> {
        /**
         * <p>
         * Information about CloudWatch Logs for the build project.
         * </p>
         * 
         * @param cloudWatchLogs
         *        Information about CloudWatch Logs for the build project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudWatchLogs(AwsCodeBuildProjectLogsConfigCloudWatchLogsDetails cloudWatchLogs);

        /**
         * <p>
         * Information about CloudWatch Logs for the build project.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AwsCodeBuildProjectLogsConfigCloudWatchLogsDetails.Builder} avoiding the need to create one manually
         * via {@link AwsCodeBuildProjectLogsConfigCloudWatchLogsDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link AwsCodeBuildProjectLogsConfigCloudWatchLogsDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #cloudWatchLogs(AwsCodeBuildProjectLogsConfigCloudWatchLogsDetails)}.
         * 
         * @param cloudWatchLogs
         *        a consumer that will call methods on
         *        {@link AwsCodeBuildProjectLogsConfigCloudWatchLogsDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cloudWatchLogs(AwsCodeBuildProjectLogsConfigCloudWatchLogsDetails)
         */
        default Builder cloudWatchLogs(Consumer<AwsCodeBuildProjectLogsConfigCloudWatchLogsDetails.Builder> cloudWatchLogs) {
            return cloudWatchLogs(AwsCodeBuildProjectLogsConfigCloudWatchLogsDetails.builder().applyMutation(cloudWatchLogs)
                    .build());
        }

        /**
         * <p>
         * Information about logs built to an S3 bucket for a build project.
         * </p>
         * 
         * @param s3Logs
         *        Information about logs built to an S3 bucket for a build project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Logs(AwsCodeBuildProjectLogsConfigS3LogsDetails s3Logs);

        /**
         * <p>
         * Information about logs built to an S3 bucket for a build project.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AwsCodeBuildProjectLogsConfigS3LogsDetails.Builder} avoiding the need to create one manually via
         * {@link AwsCodeBuildProjectLogsConfigS3LogsDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsCodeBuildProjectLogsConfigS3LogsDetails.Builder#build()} is
         * called immediately and its result is passed to {@link #s3Logs(AwsCodeBuildProjectLogsConfigS3LogsDetails)}.
         * 
         * @param s3Logs
         *        a consumer that will call methods on {@link AwsCodeBuildProjectLogsConfigS3LogsDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3Logs(AwsCodeBuildProjectLogsConfigS3LogsDetails)
         */
        default Builder s3Logs(Consumer<AwsCodeBuildProjectLogsConfigS3LogsDetails.Builder> s3Logs) {
            return s3Logs(AwsCodeBuildProjectLogsConfigS3LogsDetails.builder().applyMutation(s3Logs).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private AwsCodeBuildProjectLogsConfigCloudWatchLogsDetails cloudWatchLogs;

        private AwsCodeBuildProjectLogsConfigS3LogsDetails s3Logs;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsCodeBuildProjectLogsConfigDetails model) {
            cloudWatchLogs(model.cloudWatchLogs);
            s3Logs(model.s3Logs);
        }

        public final AwsCodeBuildProjectLogsConfigCloudWatchLogsDetails.Builder getCloudWatchLogs() {
            return cloudWatchLogs != null ? cloudWatchLogs.toBuilder() : null;
        }

        public final void setCloudWatchLogs(AwsCodeBuildProjectLogsConfigCloudWatchLogsDetails.BuilderImpl cloudWatchLogs) {
            this.cloudWatchLogs = cloudWatchLogs != null ? cloudWatchLogs.build() : null;
        }

        @Override
        public final Builder cloudWatchLogs(AwsCodeBuildProjectLogsConfigCloudWatchLogsDetails cloudWatchLogs) {
            this.cloudWatchLogs = cloudWatchLogs;
            return this;
        }

        public final AwsCodeBuildProjectLogsConfigS3LogsDetails.Builder getS3Logs() {
            return s3Logs != null ? s3Logs.toBuilder() : null;
        }

        public final void setS3Logs(AwsCodeBuildProjectLogsConfigS3LogsDetails.BuilderImpl s3Logs) {
            this.s3Logs = s3Logs != null ? s3Logs.build() : null;
        }

        @Override
        public final Builder s3Logs(AwsCodeBuildProjectLogsConfigS3LogsDetails s3Logs) {
            this.s3Logs = s3Logs;
            return this;
        }

        @Override
        public AwsCodeBuildProjectLogsConfigDetails build() {
            return new AwsCodeBuildProjectLogsConfigDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
