/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Options for enabling a customizable text banner that will be displayed on Amazon Web Services provided clients when a
 * VPN session is established.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsEc2ClientVpnEndpointClientLoginBannerOptionsDetails
        implements
        SdkPojo,
        Serializable,
        ToCopyableBuilder<AwsEc2ClientVpnEndpointClientLoginBannerOptionsDetails.Builder, AwsEc2ClientVpnEndpointClientLoginBannerOptionsDetails> {
    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Enabled").getter(getter(AwsEc2ClientVpnEndpointClientLoginBannerOptionsDetails::enabled))
            .setter(setter(Builder::enabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Enabled").build()).build();

    private static final SdkField<String> BANNER_TEXT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BannerText").getter(getter(AwsEc2ClientVpnEndpointClientLoginBannerOptionsDetails::bannerText))
            .setter(setter(Builder::bannerText))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BannerText").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENABLED_FIELD,
            BANNER_TEXT_FIELD));

    private static final long serialVersionUID = 1L;

    private final Boolean enabled;

    private final String bannerText;

    private AwsEc2ClientVpnEndpointClientLoginBannerOptionsDetails(BuilderImpl builder) {
        this.enabled = builder.enabled;
        this.bannerText = builder.bannerText;
    }

    /**
     * <p>
     * Current state of text banner feature.
     * </p>
     * 
     * @return Current state of text banner feature.
     */
    public final Boolean enabled() {
        return enabled;
    }

    /**
     * <p>
     * Customizable text that will be displayed in a banner on Amazon Web Services provided clients when a VPN session
     * is established.
     * </p>
     * 
     * @return Customizable text that will be displayed in a banner on Amazon Web Services provided clients when a VPN
     *         session is established.
     */
    public final String bannerText() {
        return bannerText;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(enabled());
        hashCode = 31 * hashCode + Objects.hashCode(bannerText());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsEc2ClientVpnEndpointClientLoginBannerOptionsDetails)) {
            return false;
        }
        AwsEc2ClientVpnEndpointClientLoginBannerOptionsDetails other = (AwsEc2ClientVpnEndpointClientLoginBannerOptionsDetails) obj;
        return Objects.equals(enabled(), other.enabled()) && Objects.equals(bannerText(), other.bannerText());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsEc2ClientVpnEndpointClientLoginBannerOptionsDetails").add("Enabled", enabled())
                .add("BannerText", bannerText()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Enabled":
            return Optional.ofNullable(clazz.cast(enabled()));
        case "BannerText":
            return Optional.ofNullable(clazz.cast(bannerText()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsEc2ClientVpnEndpointClientLoginBannerOptionsDetails, T> g) {
        return obj -> g.apply((AwsEc2ClientVpnEndpointClientLoginBannerOptionsDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsEc2ClientVpnEndpointClientLoginBannerOptionsDetails> {
        /**
         * <p>
         * Current state of text banner feature.
         * </p>
         * 
         * @param enabled
         *        Current state of text banner feature.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabled(Boolean enabled);

        /**
         * <p>
         * Customizable text that will be displayed in a banner on Amazon Web Services provided clients when a VPN
         * session is established.
         * </p>
         * 
         * @param bannerText
         *        Customizable text that will be displayed in a banner on Amazon Web Services provided clients when a
         *        VPN session is established.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bannerText(String bannerText);
    }

    static final class BuilderImpl implements Builder {
        private Boolean enabled;

        private String bannerText;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsEc2ClientVpnEndpointClientLoginBannerOptionsDetails model) {
            enabled(model.enabled);
            bannerText(model.bannerText);
        }

        public final Boolean getEnabled() {
            return enabled;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final String getBannerText() {
            return bannerText;
        }

        public final void setBannerText(String bannerText) {
            this.bannerText = bannerText;
        }

        @Override
        public final Builder bannerText(String bannerText) {
            this.bannerText = bannerText;
            return this;
        }

        @Override
        public AwsEc2ClientVpnEndpointClientLoginBannerOptionsDetails build() {
            return new AwsEc2ClientVpnEndpointClientLoginBannerOptionsDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
