/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides details about the placement of an Amazon EC2 instance.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsEc2LaunchTemplateDataPlacementDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsEc2LaunchTemplateDataPlacementDetails.Builder, AwsEc2LaunchTemplateDataPlacementDetails> {
    private static final SdkField<String> AFFINITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Affinity").getter(getter(AwsEc2LaunchTemplateDataPlacementDetails::affinity))
            .setter(setter(Builder::affinity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Affinity").build()).build();

    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AvailabilityZone").getter(getter(AwsEc2LaunchTemplateDataPlacementDetails::availabilityZone))
            .setter(setter(Builder::availabilityZone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZone").build()).build();

    private static final SdkField<String> GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GroupName").getter(getter(AwsEc2LaunchTemplateDataPlacementDetails::groupName))
            .setter(setter(Builder::groupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupName").build()).build();

    private static final SdkField<String> HOST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("HostId")
            .getter(getter(AwsEc2LaunchTemplateDataPlacementDetails::hostId)).setter(setter(Builder::hostId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HostId").build()).build();

    private static final SdkField<String> HOST_RESOURCE_GROUP_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HostResourceGroupArn").getter(getter(AwsEc2LaunchTemplateDataPlacementDetails::hostResourceGroupArn))
            .setter(setter(Builder::hostResourceGroupArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HostResourceGroupArn").build())
            .build();

    private static final SdkField<Integer> PARTITION_NUMBER_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("PartitionNumber").getter(getter(AwsEc2LaunchTemplateDataPlacementDetails::partitionNumber))
            .setter(setter(Builder::partitionNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PartitionNumber").build()).build();

    private static final SdkField<String> SPREAD_DOMAIN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SpreadDomain").getter(getter(AwsEc2LaunchTemplateDataPlacementDetails::spreadDomain))
            .setter(setter(Builder::spreadDomain))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SpreadDomain").build()).build();

    private static final SdkField<String> TENANCY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Tenancy")
            .getter(getter(AwsEc2LaunchTemplateDataPlacementDetails::tenancy)).setter(setter(Builder::tenancy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tenancy").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AFFINITY_FIELD,
            AVAILABILITY_ZONE_FIELD, GROUP_NAME_FIELD, HOST_ID_FIELD, HOST_RESOURCE_GROUP_ARN_FIELD, PARTITION_NUMBER_FIELD,
            SPREAD_DOMAIN_FIELD, TENANCY_FIELD));

    private static final long serialVersionUID = 1L;

    private final String affinity;

    private final String availabilityZone;

    private final String groupName;

    private final String hostId;

    private final String hostResourceGroupArn;

    private final Integer partitionNumber;

    private final String spreadDomain;

    private final String tenancy;

    private AwsEc2LaunchTemplateDataPlacementDetails(BuilderImpl builder) {
        this.affinity = builder.affinity;
        this.availabilityZone = builder.availabilityZone;
        this.groupName = builder.groupName;
        this.hostId = builder.hostId;
        this.hostResourceGroupArn = builder.hostResourceGroupArn;
        this.partitionNumber = builder.partitionNumber;
        this.spreadDomain = builder.spreadDomain;
        this.tenancy = builder.tenancy;
    }

    /**
     * <p>
     * The affinity setting for an instance on an EC2 Dedicated Host.
     * </p>
     * 
     * @return The affinity setting for an instance on an EC2 Dedicated Host.
     */
    public final String affinity() {
        return affinity;
    }

    /**
     * <p>
     * The Availability Zone for the instance.
     * </p>
     * 
     * @return The Availability Zone for the instance.
     */
    public final String availabilityZone() {
        return availabilityZone;
    }

    /**
     * <p>
     * The name of the placement group for the instance.
     * </p>
     * 
     * @return The name of the placement group for the instance.
     */
    public final String groupName() {
        return groupName;
    }

    /**
     * <p>
     * The ID of the Dedicated Host for the instance.
     * </p>
     * 
     * @return The ID of the Dedicated Host for the instance.
     */
    public final String hostId() {
        return hostId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the host resource group in which to launch the instances.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the host resource group in which to launch the instances.
     */
    public final String hostResourceGroupArn() {
        return hostResourceGroupArn;
    }

    /**
     * <p>
     * The number of the partition the instance should launch in.
     * </p>
     * 
     * @return The number of the partition the instance should launch in.
     */
    public final Integer partitionNumber() {
        return partitionNumber;
    }

    /**
     * <p>
     * Reserved for future use.
     * </p>
     * 
     * @return Reserved for future use.
     */
    public final String spreadDomain() {
        return spreadDomain;
    }

    /**
     * <p>
     * The tenancy of the instance (if the instance is running in a VPC). An instance with a tenancy of dedicated runs
     * on single-tenant hardware.
     * </p>
     * 
     * @return The tenancy of the instance (if the instance is running in a VPC). An instance with a tenancy of
     *         dedicated runs on single-tenant hardware.
     */
    public final String tenancy() {
        return tenancy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(affinity());
        hashCode = 31 * hashCode + Objects.hashCode(availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(groupName());
        hashCode = 31 * hashCode + Objects.hashCode(hostId());
        hashCode = 31 * hashCode + Objects.hashCode(hostResourceGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(partitionNumber());
        hashCode = 31 * hashCode + Objects.hashCode(spreadDomain());
        hashCode = 31 * hashCode + Objects.hashCode(tenancy());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsEc2LaunchTemplateDataPlacementDetails)) {
            return false;
        }
        AwsEc2LaunchTemplateDataPlacementDetails other = (AwsEc2LaunchTemplateDataPlacementDetails) obj;
        return Objects.equals(affinity(), other.affinity()) && Objects.equals(availabilityZone(), other.availabilityZone())
                && Objects.equals(groupName(), other.groupName()) && Objects.equals(hostId(), other.hostId())
                && Objects.equals(hostResourceGroupArn(), other.hostResourceGroupArn())
                && Objects.equals(partitionNumber(), other.partitionNumber())
                && Objects.equals(spreadDomain(), other.spreadDomain()) && Objects.equals(tenancy(), other.tenancy());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsEc2LaunchTemplateDataPlacementDetails").add("Affinity", affinity())
                .add("AvailabilityZone", availabilityZone()).add("GroupName", groupName()).add("HostId", hostId())
                .add("HostResourceGroupArn", hostResourceGroupArn()).add("PartitionNumber", partitionNumber())
                .add("SpreadDomain", spreadDomain()).add("Tenancy", tenancy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Affinity":
            return Optional.ofNullable(clazz.cast(affinity()));
        case "AvailabilityZone":
            return Optional.ofNullable(clazz.cast(availabilityZone()));
        case "GroupName":
            return Optional.ofNullable(clazz.cast(groupName()));
        case "HostId":
            return Optional.ofNullable(clazz.cast(hostId()));
        case "HostResourceGroupArn":
            return Optional.ofNullable(clazz.cast(hostResourceGroupArn()));
        case "PartitionNumber":
            return Optional.ofNullable(clazz.cast(partitionNumber()));
        case "SpreadDomain":
            return Optional.ofNullable(clazz.cast(spreadDomain()));
        case "Tenancy":
            return Optional.ofNullable(clazz.cast(tenancy()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsEc2LaunchTemplateDataPlacementDetails, T> g) {
        return obj -> g.apply((AwsEc2LaunchTemplateDataPlacementDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsEc2LaunchTemplateDataPlacementDetails> {
        /**
         * <p>
         * The affinity setting for an instance on an EC2 Dedicated Host.
         * </p>
         * 
         * @param affinity
         *        The affinity setting for an instance on an EC2 Dedicated Host.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder affinity(String affinity);

        /**
         * <p>
         * The Availability Zone for the instance.
         * </p>
         * 
         * @param availabilityZone
         *        The Availability Zone for the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZone(String availabilityZone);

        /**
         * <p>
         * The name of the placement group for the instance.
         * </p>
         * 
         * @param groupName
         *        The name of the placement group for the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupName(String groupName);

        /**
         * <p>
         * The ID of the Dedicated Host for the instance.
         * </p>
         * 
         * @param hostId
         *        The ID of the Dedicated Host for the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostId(String hostId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the host resource group in which to launch the instances.
         * </p>
         * 
         * @param hostResourceGroupArn
         *        The Amazon Resource Name (ARN) of the host resource group in which to launch the instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostResourceGroupArn(String hostResourceGroupArn);

        /**
         * <p>
         * The number of the partition the instance should launch in.
         * </p>
         * 
         * @param partitionNumber
         *        The number of the partition the instance should launch in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder partitionNumber(Integer partitionNumber);

        /**
         * <p>
         * Reserved for future use.
         * </p>
         * 
         * @param spreadDomain
         *        Reserved for future use.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder spreadDomain(String spreadDomain);

        /**
         * <p>
         * The tenancy of the instance (if the instance is running in a VPC). An instance with a tenancy of dedicated
         * runs on single-tenant hardware.
         * </p>
         * 
         * @param tenancy
         *        The tenancy of the instance (if the instance is running in a VPC). An instance with a tenancy of
         *        dedicated runs on single-tenant hardware.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tenancy(String tenancy);
    }

    static final class BuilderImpl implements Builder {
        private String affinity;

        private String availabilityZone;

        private String groupName;

        private String hostId;

        private String hostResourceGroupArn;

        private Integer partitionNumber;

        private String spreadDomain;

        private String tenancy;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsEc2LaunchTemplateDataPlacementDetails model) {
            affinity(model.affinity);
            availabilityZone(model.availabilityZone);
            groupName(model.groupName);
            hostId(model.hostId);
            hostResourceGroupArn(model.hostResourceGroupArn);
            partitionNumber(model.partitionNumber);
            spreadDomain(model.spreadDomain);
            tenancy(model.tenancy);
        }

        public final String getAffinity() {
            return affinity;
        }

        public final void setAffinity(String affinity) {
            this.affinity = affinity;
        }

        @Override
        public final Builder affinity(String affinity) {
            this.affinity = affinity;
            return this;
        }

        public final String getAvailabilityZone() {
            return availabilityZone;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final String getGroupName() {
            return groupName;
        }

        public final void setGroupName(String groupName) {
            this.groupName = groupName;
        }

        @Override
        public final Builder groupName(String groupName) {
            this.groupName = groupName;
            return this;
        }

        public final String getHostId() {
            return hostId;
        }

        public final void setHostId(String hostId) {
            this.hostId = hostId;
        }

        @Override
        public final Builder hostId(String hostId) {
            this.hostId = hostId;
            return this;
        }

        public final String getHostResourceGroupArn() {
            return hostResourceGroupArn;
        }

        public final void setHostResourceGroupArn(String hostResourceGroupArn) {
            this.hostResourceGroupArn = hostResourceGroupArn;
        }

        @Override
        public final Builder hostResourceGroupArn(String hostResourceGroupArn) {
            this.hostResourceGroupArn = hostResourceGroupArn;
            return this;
        }

        public final Integer getPartitionNumber() {
            return partitionNumber;
        }

        public final void setPartitionNumber(Integer partitionNumber) {
            this.partitionNumber = partitionNumber;
        }

        @Override
        public final Builder partitionNumber(Integer partitionNumber) {
            this.partitionNumber = partitionNumber;
            return this;
        }

        public final String getSpreadDomain() {
            return spreadDomain;
        }

        public final void setSpreadDomain(String spreadDomain) {
            this.spreadDomain = spreadDomain;
        }

        @Override
        public final Builder spreadDomain(String spreadDomain) {
            this.spreadDomain = spreadDomain;
            return this;
        }

        public final String getTenancy() {
            return tenancy;
        }

        public final void setTenancy(String tenancy) {
            this.tenancy = tenancy;
        }

        @Override
        public final Builder tenancy(String tenancy) {
            this.tenancy = tenancy;
            return this;
        }

        @Override
        public AwsEc2LaunchTemplateDataPlacementDetails build() {
            return new AwsEc2LaunchTemplateDataPlacementDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
