/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the properties for creating an Amazon Elastic Compute Cloud (Amazon EC2) launch template.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsEc2LaunchTemplateDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsEc2LaunchTemplateDetails.Builder, AwsEc2LaunchTemplateDetails> {
    private static final SdkField<String> LAUNCH_TEMPLATE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LaunchTemplateName").getter(getter(AwsEc2LaunchTemplateDetails::launchTemplateName))
            .setter(setter(Builder::launchTemplateName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LaunchTemplateName").build())
            .build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(AwsEc2LaunchTemplateDetails::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<AwsEc2LaunchTemplateDataDetails> LAUNCH_TEMPLATE_DATA_FIELD = SdkField
            .<AwsEc2LaunchTemplateDataDetails> builder(MarshallingType.SDK_POJO).memberName("LaunchTemplateData")
            .getter(getter(AwsEc2LaunchTemplateDetails::launchTemplateData)).setter(setter(Builder::launchTemplateData))
            .constructor(AwsEc2LaunchTemplateDataDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LaunchTemplateData").build())
            .build();

    private static final SdkField<Long> DEFAULT_VERSION_NUMBER_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("DefaultVersionNumber").getter(getter(AwsEc2LaunchTemplateDetails::defaultVersionNumber))
            .setter(setter(Builder::defaultVersionNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultVersionNumber").build())
            .build();

    private static final SdkField<Long> LATEST_VERSION_NUMBER_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("LatestVersionNumber").getter(getter(AwsEc2LaunchTemplateDetails::latestVersionNumber))
            .setter(setter(Builder::latestVersionNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LatestVersionNumber").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LAUNCH_TEMPLATE_NAME_FIELD,
            ID_FIELD, LAUNCH_TEMPLATE_DATA_FIELD, DEFAULT_VERSION_NUMBER_FIELD, LATEST_VERSION_NUMBER_FIELD));

    private static final long serialVersionUID = 1L;

    private final String launchTemplateName;

    private final String id;

    private final AwsEc2LaunchTemplateDataDetails launchTemplateData;

    private final Long defaultVersionNumber;

    private final Long latestVersionNumber;

    private AwsEc2LaunchTemplateDetails(BuilderImpl builder) {
        this.launchTemplateName = builder.launchTemplateName;
        this.id = builder.id;
        this.launchTemplateData = builder.launchTemplateData;
        this.defaultVersionNumber = builder.defaultVersionNumber;
        this.latestVersionNumber = builder.latestVersionNumber;
    }

    /**
     * <p>
     * A name for the launch template.
     * </p>
     * 
     * @return A name for the launch template.
     */
    public final String launchTemplateName() {
        return launchTemplateName;
    }

    /**
     * <p>
     * An ID for the launch template.
     * </p>
     * 
     * @return An ID for the launch template.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The information to include in the launch template.
     * </p>
     * 
     * @return The information to include in the launch template.
     */
    public final AwsEc2LaunchTemplateDataDetails launchTemplateData() {
        return launchTemplateData;
    }

    /**
     * <p>
     * The default version of the launch template.
     * </p>
     * 
     * @return The default version of the launch template.
     */
    public final Long defaultVersionNumber() {
        return defaultVersionNumber;
    }

    /**
     * <p>
     * The latest version of the launch template.
     * </p>
     * 
     * @return The latest version of the launch template.
     */
    public final Long latestVersionNumber() {
        return latestVersionNumber;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(launchTemplateName());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(launchTemplateData());
        hashCode = 31 * hashCode + Objects.hashCode(defaultVersionNumber());
        hashCode = 31 * hashCode + Objects.hashCode(latestVersionNumber());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsEc2LaunchTemplateDetails)) {
            return false;
        }
        AwsEc2LaunchTemplateDetails other = (AwsEc2LaunchTemplateDetails) obj;
        return Objects.equals(launchTemplateName(), other.launchTemplateName()) && Objects.equals(id(), other.id())
                && Objects.equals(launchTemplateData(), other.launchTemplateData())
                && Objects.equals(defaultVersionNumber(), other.defaultVersionNumber())
                && Objects.equals(latestVersionNumber(), other.latestVersionNumber());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsEc2LaunchTemplateDetails").add("LaunchTemplateName", launchTemplateName()).add("Id", id())
                .add("LaunchTemplateData", launchTemplateData()).add("DefaultVersionNumber", defaultVersionNumber())
                .add("LatestVersionNumber", latestVersionNumber()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LaunchTemplateName":
            return Optional.ofNullable(clazz.cast(launchTemplateName()));
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "LaunchTemplateData":
            return Optional.ofNullable(clazz.cast(launchTemplateData()));
        case "DefaultVersionNumber":
            return Optional.ofNullable(clazz.cast(defaultVersionNumber()));
        case "LatestVersionNumber":
            return Optional.ofNullable(clazz.cast(latestVersionNumber()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsEc2LaunchTemplateDetails, T> g) {
        return obj -> g.apply((AwsEc2LaunchTemplateDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsEc2LaunchTemplateDetails> {
        /**
         * <p>
         * A name for the launch template.
         * </p>
         * 
         * @param launchTemplateName
         *        A name for the launch template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder launchTemplateName(String launchTemplateName);

        /**
         * <p>
         * An ID for the launch template.
         * </p>
         * 
         * @param id
         *        An ID for the launch template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The information to include in the launch template.
         * </p>
         * 
         * @param launchTemplateData
         *        The information to include in the launch template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder launchTemplateData(AwsEc2LaunchTemplateDataDetails launchTemplateData);

        /**
         * <p>
         * The information to include in the launch template.
         * </p>
         * This is a convenience method that creates an instance of the {@link AwsEc2LaunchTemplateDataDetails.Builder}
         * avoiding the need to create one manually via {@link AwsEc2LaunchTemplateDataDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsEc2LaunchTemplateDataDetails.Builder#build()} is called
         * immediately and its result is passed to {@link #launchTemplateData(AwsEc2LaunchTemplateDataDetails)}.
         * 
         * @param launchTemplateData
         *        a consumer that will call methods on {@link AwsEc2LaunchTemplateDataDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #launchTemplateData(AwsEc2LaunchTemplateDataDetails)
         */
        default Builder launchTemplateData(Consumer<AwsEc2LaunchTemplateDataDetails.Builder> launchTemplateData) {
            return launchTemplateData(AwsEc2LaunchTemplateDataDetails.builder().applyMutation(launchTemplateData).build());
        }

        /**
         * <p>
         * The default version of the launch template.
         * </p>
         * 
         * @param defaultVersionNumber
         *        The default version of the launch template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultVersionNumber(Long defaultVersionNumber);

        /**
         * <p>
         * The latest version of the launch template.
         * </p>
         * 
         * @param latestVersionNumber
         *        The latest version of the launch template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder latestVersionNumber(Long latestVersionNumber);
    }

    static final class BuilderImpl implements Builder {
        private String launchTemplateName;

        private String id;

        private AwsEc2LaunchTemplateDataDetails launchTemplateData;

        private Long defaultVersionNumber;

        private Long latestVersionNumber;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsEc2LaunchTemplateDetails model) {
            launchTemplateName(model.launchTemplateName);
            id(model.id);
            launchTemplateData(model.launchTemplateData);
            defaultVersionNumber(model.defaultVersionNumber);
            latestVersionNumber(model.latestVersionNumber);
        }

        public final String getLaunchTemplateName() {
            return launchTemplateName;
        }

        public final void setLaunchTemplateName(String launchTemplateName) {
            this.launchTemplateName = launchTemplateName;
        }

        @Override
        public final Builder launchTemplateName(String launchTemplateName) {
            this.launchTemplateName = launchTemplateName;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final AwsEc2LaunchTemplateDataDetails.Builder getLaunchTemplateData() {
            return launchTemplateData != null ? launchTemplateData.toBuilder() : null;
        }

        public final void setLaunchTemplateData(AwsEc2LaunchTemplateDataDetails.BuilderImpl launchTemplateData) {
            this.launchTemplateData = launchTemplateData != null ? launchTemplateData.build() : null;
        }

        @Override
        public final Builder launchTemplateData(AwsEc2LaunchTemplateDataDetails launchTemplateData) {
            this.launchTemplateData = launchTemplateData;
            return this;
        }

        public final Long getDefaultVersionNumber() {
            return defaultVersionNumber;
        }

        public final void setDefaultVersionNumber(Long defaultVersionNumber) {
            this.defaultVersionNumber = defaultVersionNumber;
        }

        @Override
        public final Builder defaultVersionNumber(Long defaultVersionNumber) {
            this.defaultVersionNumber = defaultVersionNumber;
            return this;
        }

        public final Long getLatestVersionNumber() {
            return latestVersionNumber;
        }

        public final void setLatestVersionNumber(Long latestVersionNumber) {
            this.latestVersionNumber = latestVersionNumber;
        }

        @Override
        public final Builder latestVersionNumber(Long latestVersionNumber) {
            this.latestVersionNumber = latestVersionNumber;
            return this;
        }

        @Override
        public AwsEc2LaunchTemplateDetails build() {
            return new AwsEc2LaunchTemplateDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
