/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details about an Amazon EC2 VPN connection.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsEc2VpnConnectionDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsEc2VpnConnectionDetails.Builder, AwsEc2VpnConnectionDetails> {
    private static final SdkField<String> VPN_CONNECTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VpnConnectionId").getter(getter(AwsEc2VpnConnectionDetails::vpnConnectionId))
            .setter(setter(Builder::vpnConnectionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpnConnectionId").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("State")
            .getter(getter(AwsEc2VpnConnectionDetails::state)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()).build();

    private static final SdkField<String> CUSTOMER_GATEWAY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CustomerGatewayId").getter(getter(AwsEc2VpnConnectionDetails::customerGatewayId))
            .setter(setter(Builder::customerGatewayId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomerGatewayId").build()).build();

    private static final SdkField<String> CUSTOMER_GATEWAY_CONFIGURATION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("CustomerGatewayConfiguration")
            .getter(getter(AwsEc2VpnConnectionDetails::customerGatewayConfiguration))
            .setter(setter(Builder::customerGatewayConfiguration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomerGatewayConfiguration")
                    .build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(AwsEc2VpnConnectionDetails::type)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<String> VPN_GATEWAY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VpnGatewayId").getter(getter(AwsEc2VpnConnectionDetails::vpnGatewayId))
            .setter(setter(Builder::vpnGatewayId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpnGatewayId").build()).build();

    private static final SdkField<String> CATEGORY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Category").getter(getter(AwsEc2VpnConnectionDetails::category)).setter(setter(Builder::category))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Category").build()).build();

    private static final SdkField<List<AwsEc2VpnConnectionVgwTelemetryDetails>> VGW_TELEMETRY_FIELD = SdkField
            .<List<AwsEc2VpnConnectionVgwTelemetryDetails>> builder(MarshallingType.LIST)
            .memberName("VgwTelemetry")
            .getter(getter(AwsEc2VpnConnectionDetails::vgwTelemetry))
            .setter(setter(Builder::vgwTelemetry))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VgwTelemetry").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AwsEc2VpnConnectionVgwTelemetryDetails> builder(MarshallingType.SDK_POJO)
                                            .constructor(AwsEc2VpnConnectionVgwTelemetryDetails::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<AwsEc2VpnConnectionOptionsDetails> OPTIONS_FIELD = SdkField
            .<AwsEc2VpnConnectionOptionsDetails> builder(MarshallingType.SDK_POJO).memberName("Options")
            .getter(getter(AwsEc2VpnConnectionDetails::options)).setter(setter(Builder::options))
            .constructor(AwsEc2VpnConnectionOptionsDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Options").build()).build();

    private static final SdkField<List<AwsEc2VpnConnectionRoutesDetails>> ROUTES_FIELD = SdkField
            .<List<AwsEc2VpnConnectionRoutesDetails>> builder(MarshallingType.LIST)
            .memberName("Routes")
            .getter(getter(AwsEc2VpnConnectionDetails::routes))
            .setter(setter(Builder::routes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Routes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AwsEc2VpnConnectionRoutesDetails> builder(MarshallingType.SDK_POJO)
                                            .constructor(AwsEc2VpnConnectionRoutesDetails::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> TRANSIT_GATEWAY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TransitGatewayId").getter(getter(AwsEc2VpnConnectionDetails::transitGatewayId))
            .setter(setter(Builder::transitGatewayId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransitGatewayId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VPN_CONNECTION_ID_FIELD,
            STATE_FIELD, CUSTOMER_GATEWAY_ID_FIELD, CUSTOMER_GATEWAY_CONFIGURATION_FIELD, TYPE_FIELD, VPN_GATEWAY_ID_FIELD,
            CATEGORY_FIELD, VGW_TELEMETRY_FIELD, OPTIONS_FIELD, ROUTES_FIELD, TRANSIT_GATEWAY_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String vpnConnectionId;

    private final String state;

    private final String customerGatewayId;

    private final String customerGatewayConfiguration;

    private final String type;

    private final String vpnGatewayId;

    private final String category;

    private final List<AwsEc2VpnConnectionVgwTelemetryDetails> vgwTelemetry;

    private final AwsEc2VpnConnectionOptionsDetails options;

    private final List<AwsEc2VpnConnectionRoutesDetails> routes;

    private final String transitGatewayId;

    private AwsEc2VpnConnectionDetails(BuilderImpl builder) {
        this.vpnConnectionId = builder.vpnConnectionId;
        this.state = builder.state;
        this.customerGatewayId = builder.customerGatewayId;
        this.customerGatewayConfiguration = builder.customerGatewayConfiguration;
        this.type = builder.type;
        this.vpnGatewayId = builder.vpnGatewayId;
        this.category = builder.category;
        this.vgwTelemetry = builder.vgwTelemetry;
        this.options = builder.options;
        this.routes = builder.routes;
        this.transitGatewayId = builder.transitGatewayId;
    }

    /**
     * <p>
     * The identifier of the VPN connection.
     * </p>
     * 
     * @return The identifier of the VPN connection.
     */
    public final String vpnConnectionId() {
        return vpnConnectionId;
    }

    /**
     * <p>
     * The current state of the VPN connection. Valid values are as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>available</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>deleted</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>deleting</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>pending</code>
     * </p>
     * </li>
     * </ul>
     * 
     * @return The current state of the VPN connection. Valid values are as follows:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>available</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>deleted</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>deleting</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>pending</code>
     *         </p>
     *         </li>
     */
    public final String state() {
        return state;
    }

    /**
     * <p>
     * The identifier of the customer gateway that is at your end of the VPN connection.
     * </p>
     * 
     * @return The identifier of the customer gateway that is at your end of the VPN connection.
     */
    public final String customerGatewayId() {
        return customerGatewayId;
    }

    /**
     * <p>
     * The configuration information for the VPN connection's customer gateway, in the native XML format.
     * </p>
     * 
     * @return The configuration information for the VPN connection's customer gateway, in the native XML format.
     */
    public final String customerGatewayConfiguration() {
        return customerGatewayConfiguration;
    }

    /**
     * <p>
     * The type of VPN connection.
     * </p>
     * 
     * @return The type of VPN connection.
     */
    public final String type() {
        return type;
    }

    /**
     * <p>
     * The identifier of the virtual private gateway that is at the Amazon Web Services side of the VPN connection.
     * </p>
     * 
     * @return The identifier of the virtual private gateway that is at the Amazon Web Services side of the VPN
     *         connection.
     */
    public final String vpnGatewayId() {
        return vpnGatewayId;
    }

    /**
     * <p>
     * The category of the VPN connection. <code>VPN</code> indicates an Amazon Web Services VPN connection.
     * <code>VPN-Classic</code> indicates an Amazon Web Services Classic VPN connection.
     * </p>
     * 
     * @return The category of the VPN connection. <code>VPN</code> indicates an Amazon Web Services VPN connection.
     *         <code>VPN-Classic</code> indicates an Amazon Web Services Classic VPN connection.
     */
    public final String category() {
        return category;
    }

    /**
     * For responses, this returns true if the service returned a value for the VgwTelemetry property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasVgwTelemetry() {
        return vgwTelemetry != null && !(vgwTelemetry instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the VPN tunnel.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasVgwTelemetry} method.
     * </p>
     * 
     * @return Information about the VPN tunnel.
     */
    public final List<AwsEc2VpnConnectionVgwTelemetryDetails> vgwTelemetry() {
        return vgwTelemetry;
    }

    /**
     * <p>
     * The VPN connection options.
     * </p>
     * 
     * @return The VPN connection options.
     */
    public final AwsEc2VpnConnectionOptionsDetails options() {
        return options;
    }

    /**
     * For responses, this returns true if the service returned a value for the Routes property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasRoutes() {
        return routes != null && !(routes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The static routes that are associated with the VPN connection.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRoutes} method.
     * </p>
     * 
     * @return The static routes that are associated with the VPN connection.
     */
    public final List<AwsEc2VpnConnectionRoutesDetails> routes() {
        return routes;
    }

    /**
     * <p>
     * The identifier of the transit gateway that is associated with the VPN connection.
     * </p>
     * 
     * @return The identifier of the transit gateway that is associated with the VPN connection.
     */
    public final String transitGatewayId() {
        return transitGatewayId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(vpnConnectionId());
        hashCode = 31 * hashCode + Objects.hashCode(state());
        hashCode = 31 * hashCode + Objects.hashCode(customerGatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(customerGatewayConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(type());
        hashCode = 31 * hashCode + Objects.hashCode(vpnGatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(category());
        hashCode = 31 * hashCode + Objects.hashCode(hasVgwTelemetry() ? vgwTelemetry() : null);
        hashCode = 31 * hashCode + Objects.hashCode(options());
        hashCode = 31 * hashCode + Objects.hashCode(hasRoutes() ? routes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(transitGatewayId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsEc2VpnConnectionDetails)) {
            return false;
        }
        AwsEc2VpnConnectionDetails other = (AwsEc2VpnConnectionDetails) obj;
        return Objects.equals(vpnConnectionId(), other.vpnConnectionId()) && Objects.equals(state(), other.state())
                && Objects.equals(customerGatewayId(), other.customerGatewayId())
                && Objects.equals(customerGatewayConfiguration(), other.customerGatewayConfiguration())
                && Objects.equals(type(), other.type()) && Objects.equals(vpnGatewayId(), other.vpnGatewayId())
                && Objects.equals(category(), other.category()) && hasVgwTelemetry() == other.hasVgwTelemetry()
                && Objects.equals(vgwTelemetry(), other.vgwTelemetry()) && Objects.equals(options(), other.options())
                && hasRoutes() == other.hasRoutes() && Objects.equals(routes(), other.routes())
                && Objects.equals(transitGatewayId(), other.transitGatewayId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsEc2VpnConnectionDetails").add("VpnConnectionId", vpnConnectionId()).add("State", state())
                .add("CustomerGatewayId", customerGatewayId())
                .add("CustomerGatewayConfiguration", customerGatewayConfiguration()).add("Type", type())
                .add("VpnGatewayId", vpnGatewayId()).add("Category", category())
                .add("VgwTelemetry", hasVgwTelemetry() ? vgwTelemetry() : null).add("Options", options())
                .add("Routes", hasRoutes() ? routes() : null).add("TransitGatewayId", transitGatewayId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VpnConnectionId":
            return Optional.ofNullable(clazz.cast(vpnConnectionId()));
        case "State":
            return Optional.ofNullable(clazz.cast(state()));
        case "CustomerGatewayId":
            return Optional.ofNullable(clazz.cast(customerGatewayId()));
        case "CustomerGatewayConfiguration":
            return Optional.ofNullable(clazz.cast(customerGatewayConfiguration()));
        case "Type":
            return Optional.ofNullable(clazz.cast(type()));
        case "VpnGatewayId":
            return Optional.ofNullable(clazz.cast(vpnGatewayId()));
        case "Category":
            return Optional.ofNullable(clazz.cast(category()));
        case "VgwTelemetry":
            return Optional.ofNullable(clazz.cast(vgwTelemetry()));
        case "Options":
            return Optional.ofNullable(clazz.cast(options()));
        case "Routes":
            return Optional.ofNullable(clazz.cast(routes()));
        case "TransitGatewayId":
            return Optional.ofNullable(clazz.cast(transitGatewayId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsEc2VpnConnectionDetails, T> g) {
        return obj -> g.apply((AwsEc2VpnConnectionDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsEc2VpnConnectionDetails> {
        /**
         * <p>
         * The identifier of the VPN connection.
         * </p>
         * 
         * @param vpnConnectionId
         *        The identifier of the VPN connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpnConnectionId(String vpnConnectionId);

        /**
         * <p>
         * The current state of the VPN connection. Valid values are as follows:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>available</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>deleted</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>deleting</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>pending</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param state
         *        The current state of the VPN connection. Valid values are as follows:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>available</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>deleted</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>deleting</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>pending</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder state(String state);

        /**
         * <p>
         * The identifier of the customer gateway that is at your end of the VPN connection.
         * </p>
         * 
         * @param customerGatewayId
         *        The identifier of the customer gateway that is at your end of the VPN connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customerGatewayId(String customerGatewayId);

        /**
         * <p>
         * The configuration information for the VPN connection's customer gateway, in the native XML format.
         * </p>
         * 
         * @param customerGatewayConfiguration
         *        The configuration information for the VPN connection's customer gateway, in the native XML format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customerGatewayConfiguration(String customerGatewayConfiguration);

        /**
         * <p>
         * The type of VPN connection.
         * </p>
         * 
         * @param type
         *        The type of VPN connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder type(String type);

        /**
         * <p>
         * The identifier of the virtual private gateway that is at the Amazon Web Services side of the VPN connection.
         * </p>
         * 
         * @param vpnGatewayId
         *        The identifier of the virtual private gateway that is at the Amazon Web Services side of the VPN
         *        connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpnGatewayId(String vpnGatewayId);

        /**
         * <p>
         * The category of the VPN connection. <code>VPN</code> indicates an Amazon Web Services VPN connection.
         * <code>VPN-Classic</code> indicates an Amazon Web Services Classic VPN connection.
         * </p>
         * 
         * @param category
         *        The category of the VPN connection. <code>VPN</code> indicates an Amazon Web Services VPN connection.
         *        <code>VPN-Classic</code> indicates an Amazon Web Services Classic VPN connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder category(String category);

        /**
         * <p>
         * Information about the VPN tunnel.
         * </p>
         * 
         * @param vgwTelemetry
         *        Information about the VPN tunnel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vgwTelemetry(Collection<AwsEc2VpnConnectionVgwTelemetryDetails> vgwTelemetry);

        /**
         * <p>
         * Information about the VPN tunnel.
         * </p>
         * 
         * @param vgwTelemetry
         *        Information about the VPN tunnel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vgwTelemetry(AwsEc2VpnConnectionVgwTelemetryDetails... vgwTelemetry);

        /**
         * <p>
         * Information about the VPN tunnel.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityhub.model.AwsEc2VpnConnectionVgwTelemetryDetails.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.securityhub.model.AwsEc2VpnConnectionVgwTelemetryDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityhub.model.AwsEc2VpnConnectionVgwTelemetryDetails.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #vgwTelemetry(List<AwsEc2VpnConnectionVgwTelemetryDetails>)}.
         * 
         * @param vgwTelemetry
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityhub.model.AwsEc2VpnConnectionVgwTelemetryDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vgwTelemetry(java.util.Collection<AwsEc2VpnConnectionVgwTelemetryDetails>)
         */
        Builder vgwTelemetry(Consumer<AwsEc2VpnConnectionVgwTelemetryDetails.Builder>... vgwTelemetry);

        /**
         * <p>
         * The VPN connection options.
         * </p>
         * 
         * @param options
         *        The VPN connection options.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder options(AwsEc2VpnConnectionOptionsDetails options);

        /**
         * <p>
         * The VPN connection options.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AwsEc2VpnConnectionOptionsDetails.Builder} avoiding the need to create one manually via
         * {@link AwsEc2VpnConnectionOptionsDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsEc2VpnConnectionOptionsDetails.Builder#build()} is called
         * immediately and its result is passed to {@link #options(AwsEc2VpnConnectionOptionsDetails)}.
         * 
         * @param options
         *        a consumer that will call methods on {@link AwsEc2VpnConnectionOptionsDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #options(AwsEc2VpnConnectionOptionsDetails)
         */
        default Builder options(Consumer<AwsEc2VpnConnectionOptionsDetails.Builder> options) {
            return options(AwsEc2VpnConnectionOptionsDetails.builder().applyMutation(options).build());
        }

        /**
         * <p>
         * The static routes that are associated with the VPN connection.
         * </p>
         * 
         * @param routes
         *        The static routes that are associated with the VPN connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routes(Collection<AwsEc2VpnConnectionRoutesDetails> routes);

        /**
         * <p>
         * The static routes that are associated with the VPN connection.
         * </p>
         * 
         * @param routes
         *        The static routes that are associated with the VPN connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routes(AwsEc2VpnConnectionRoutesDetails... routes);

        /**
         * <p>
         * The static routes that are associated with the VPN connection.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityhub.model.AwsEc2VpnConnectionRoutesDetails.Builder} avoiding
         * the need to create one manually via
         * {@link software.amazon.awssdk.services.securityhub.model.AwsEc2VpnConnectionRoutesDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityhub.model.AwsEc2VpnConnectionRoutesDetails.Builder#build()} is
         * called immediately and its result is passed to {@link #routes(List<AwsEc2VpnConnectionRoutesDetails>)}.
         * 
         * @param routes
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityhub.model.AwsEc2VpnConnectionRoutesDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #routes(java.util.Collection<AwsEc2VpnConnectionRoutesDetails>)
         */
        Builder routes(Consumer<AwsEc2VpnConnectionRoutesDetails.Builder>... routes);

        /**
         * <p>
         * The identifier of the transit gateway that is associated with the VPN connection.
         * </p>
         * 
         * @param transitGatewayId
         *        The identifier of the transit gateway that is associated with the VPN connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transitGatewayId(String transitGatewayId);
    }

    static final class BuilderImpl implements Builder {
        private String vpnConnectionId;

        private String state;

        private String customerGatewayId;

        private String customerGatewayConfiguration;

        private String type;

        private String vpnGatewayId;

        private String category;

        private List<AwsEc2VpnConnectionVgwTelemetryDetails> vgwTelemetry = DefaultSdkAutoConstructList.getInstance();

        private AwsEc2VpnConnectionOptionsDetails options;

        private List<AwsEc2VpnConnectionRoutesDetails> routes = DefaultSdkAutoConstructList.getInstance();

        private String transitGatewayId;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsEc2VpnConnectionDetails model) {
            vpnConnectionId(model.vpnConnectionId);
            state(model.state);
            customerGatewayId(model.customerGatewayId);
            customerGatewayConfiguration(model.customerGatewayConfiguration);
            type(model.type);
            vpnGatewayId(model.vpnGatewayId);
            category(model.category);
            vgwTelemetry(model.vgwTelemetry);
            options(model.options);
            routes(model.routes);
            transitGatewayId(model.transitGatewayId);
        }

        public final String getVpnConnectionId() {
            return vpnConnectionId;
        }

        public final void setVpnConnectionId(String vpnConnectionId) {
            this.vpnConnectionId = vpnConnectionId;
        }

        @Override
        public final Builder vpnConnectionId(String vpnConnectionId) {
            this.vpnConnectionId = vpnConnectionId;
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        public final String getCustomerGatewayId() {
            return customerGatewayId;
        }

        public final void setCustomerGatewayId(String customerGatewayId) {
            this.customerGatewayId = customerGatewayId;
        }

        @Override
        public final Builder customerGatewayId(String customerGatewayId) {
            this.customerGatewayId = customerGatewayId;
            return this;
        }

        public final String getCustomerGatewayConfiguration() {
            return customerGatewayConfiguration;
        }

        public final void setCustomerGatewayConfiguration(String customerGatewayConfiguration) {
            this.customerGatewayConfiguration = customerGatewayConfiguration;
        }

        @Override
        public final Builder customerGatewayConfiguration(String customerGatewayConfiguration) {
            this.customerGatewayConfiguration = customerGatewayConfiguration;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final String getVpnGatewayId() {
            return vpnGatewayId;
        }

        public final void setVpnGatewayId(String vpnGatewayId) {
            this.vpnGatewayId = vpnGatewayId;
        }

        @Override
        public final Builder vpnGatewayId(String vpnGatewayId) {
            this.vpnGatewayId = vpnGatewayId;
            return this;
        }

        public final String getCategory() {
            return category;
        }

        public final void setCategory(String category) {
            this.category = category;
        }

        @Override
        public final Builder category(String category) {
            this.category = category;
            return this;
        }

        public final List<AwsEc2VpnConnectionVgwTelemetryDetails.Builder> getVgwTelemetry() {
            List<AwsEc2VpnConnectionVgwTelemetryDetails.Builder> result = AwsEc2VpnConnectionVgwTelemetryListCopier
                    .copyToBuilder(this.vgwTelemetry);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVgwTelemetry(Collection<AwsEc2VpnConnectionVgwTelemetryDetails.BuilderImpl> vgwTelemetry) {
            this.vgwTelemetry = AwsEc2VpnConnectionVgwTelemetryListCopier.copyFromBuilder(vgwTelemetry);
        }

        @Override
        public final Builder vgwTelemetry(Collection<AwsEc2VpnConnectionVgwTelemetryDetails> vgwTelemetry) {
            this.vgwTelemetry = AwsEc2VpnConnectionVgwTelemetryListCopier.copy(vgwTelemetry);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vgwTelemetry(AwsEc2VpnConnectionVgwTelemetryDetails... vgwTelemetry) {
            vgwTelemetry(Arrays.asList(vgwTelemetry));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vgwTelemetry(Consumer<AwsEc2VpnConnectionVgwTelemetryDetails.Builder>... vgwTelemetry) {
            vgwTelemetry(Stream.of(vgwTelemetry)
                    .map(c -> AwsEc2VpnConnectionVgwTelemetryDetails.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final AwsEc2VpnConnectionOptionsDetails.Builder getOptions() {
            return options != null ? options.toBuilder() : null;
        }

        public final void setOptions(AwsEc2VpnConnectionOptionsDetails.BuilderImpl options) {
            this.options = options != null ? options.build() : null;
        }

        @Override
        public final Builder options(AwsEc2VpnConnectionOptionsDetails options) {
            this.options = options;
            return this;
        }

        public final List<AwsEc2VpnConnectionRoutesDetails.Builder> getRoutes() {
            List<AwsEc2VpnConnectionRoutesDetails.Builder> result = AwsEc2VpnConnectionRoutesListCopier
                    .copyToBuilder(this.routes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRoutes(Collection<AwsEc2VpnConnectionRoutesDetails.BuilderImpl> routes) {
            this.routes = AwsEc2VpnConnectionRoutesListCopier.copyFromBuilder(routes);
        }

        @Override
        public final Builder routes(Collection<AwsEc2VpnConnectionRoutesDetails> routes) {
            this.routes = AwsEc2VpnConnectionRoutesListCopier.copy(routes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routes(AwsEc2VpnConnectionRoutesDetails... routes) {
            routes(Arrays.asList(routes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routes(Consumer<AwsEc2VpnConnectionRoutesDetails.Builder>... routes) {
            routes(Stream.of(routes).map(c -> AwsEc2VpnConnectionRoutesDetails.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getTransitGatewayId() {
            return transitGatewayId;
        }

        public final void setTransitGatewayId(String transitGatewayId) {
            this.transitGatewayId = transitGatewayId;
        }

        @Override
        public final Builder transitGatewayId(String transitGatewayId) {
            this.transitGatewayId = transitGatewayId;
            return this;
        }

        @Override
        public AwsEc2VpnConnectionDetails build() {
            return new AwsEc2VpnConnectionDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
