/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationAuthorizationConfigDetails
        implements
        SdkPojo,
        Serializable,
        ToCopyableBuilder<AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationAuthorizationConfigDetails.Builder, AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationAuthorizationConfigDetails> {
    private static final SdkField<String> ACCESS_POINT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AccessPointId")
            .getter(getter(AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationAuthorizationConfigDetails::accessPointId))
            .setter(setter(Builder::accessPointId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessPointId").build()).build();

    private static final SdkField<String> IAM_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Iam")
            .getter(getter(AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationAuthorizationConfigDetails::iam))
            .setter(setter(Builder::iam))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Iam").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCESS_POINT_ID_FIELD,
            IAM_FIELD));

    private static final long serialVersionUID = 1L;

    private final String accessPointId;

    private final String iam;

    private AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationAuthorizationConfigDetails(BuilderImpl builder) {
        this.accessPointId = builder.accessPointId;
        this.iam = builder.iam;
    }

    /**
     * <p>
     * The Amazon EFS access point identifier to use.
     * </p>
     * 
     * @return The Amazon EFS access point identifier to use.
     */
    public final String accessPointId() {
        return accessPointId;
    }

    /**
     * <p>
     * Whether to use the Amazon ECS task IAM role defined in a task definition when mounting the Amazon EFS file
     * system.
     * </p>
     * 
     * @return Whether to use the Amazon ECS task IAM role defined in a task definition when mounting the Amazon EFS
     *         file system.
     */
    public final String iam() {
        return iam;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(accessPointId());
        hashCode = 31 * hashCode + Objects.hashCode(iam());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationAuthorizationConfigDetails)) {
            return false;
        }
        AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationAuthorizationConfigDetails other = (AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationAuthorizationConfigDetails) obj;
        return Objects.equals(accessPointId(), other.accessPointId()) && Objects.equals(iam(), other.iam());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationAuthorizationConfigDetails")
                .add("AccessPointId", accessPointId()).add("Iam", iam()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AccessPointId":
            return Optional.ofNullable(clazz.cast(accessPointId()));
        case "Iam":
            return Optional.ofNullable(clazz.cast(iam()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(
            Function<AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationAuthorizationConfigDetails, T> g) {
        return obj -> g.apply((AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationAuthorizationConfigDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo,
            CopyableBuilder<Builder, AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationAuthorizationConfigDetails> {
        /**
         * <p>
         * The Amazon EFS access point identifier to use.
         * </p>
         * 
         * @param accessPointId
         *        The Amazon EFS access point identifier to use.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessPointId(String accessPointId);

        /**
         * <p>
         * Whether to use the Amazon ECS task IAM role defined in a task definition when mounting the Amazon EFS file
         * system.
         * </p>
         * 
         * @param iam
         *        Whether to use the Amazon ECS task IAM role defined in a task definition when mounting the Amazon EFS
         *        file system.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iam(String iam);
    }

    static final class BuilderImpl implements Builder {
        private String accessPointId;

        private String iam;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationAuthorizationConfigDetails model) {
            accessPointId(model.accessPointId);
            iam(model.iam);
        }

        public final String getAccessPointId() {
            return accessPointId;
        }

        public final void setAccessPointId(String accessPointId) {
            this.accessPointId = accessPointId;
        }

        @Override
        public final Builder accessPointId(String accessPointId) {
            this.accessPointId = accessPointId;
            return this;
        }

        public final String getIam() {
            return iam;
        }

        public final void setIam(String iam) {
            this.iam = iam;
        }

        @Override
        public final Builder iam(String iam) {
            this.iam = iam;
            return this;
        }

        @Override
        public AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationAuthorizationConfigDetails build() {
            return new AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationAuthorizationConfigDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
