/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains metadata about an KMS key.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsKmsKeyDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsKmsKeyDetails.Builder, AwsKmsKeyDetails> {
    private static final SdkField<String> AWS_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AWSAccountId").getter(getter(AwsKmsKeyDetails::awsAccountId)).setter(setter(Builder::awsAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AWSAccountId").build()).build();

    private static final SdkField<Double> CREATION_DATE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("CreationDate").getter(getter(AwsKmsKeyDetails::creationDate)).setter(setter(Builder::creationDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationDate").build()).build();

    private static final SdkField<String> KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("KeyId")
            .getter(getter(AwsKmsKeyDetails::keyId)).setter(setter(Builder::keyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyId").build()).build();

    private static final SdkField<String> KEY_MANAGER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KeyManager").getter(getter(AwsKmsKeyDetails::keyManager)).setter(setter(Builder::keyManager))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyManager").build()).build();

    private static final SdkField<String> KEY_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KeyState").getter(getter(AwsKmsKeyDetails::keyState)).setter(setter(Builder::keyState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyState").build()).build();

    private static final SdkField<String> ORIGIN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Origin")
            .getter(getter(AwsKmsKeyDetails::origin)).setter(setter(Builder::origin))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Origin").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(AwsKmsKeyDetails::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<Boolean> KEY_ROTATION_STATUS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("KeyRotationStatus").getter(getter(AwsKmsKeyDetails::keyRotationStatus))
            .setter(setter(Builder::keyRotationStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyRotationStatus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AWS_ACCOUNT_ID_FIELD,
            CREATION_DATE_FIELD, KEY_ID_FIELD, KEY_MANAGER_FIELD, KEY_STATE_FIELD, ORIGIN_FIELD, DESCRIPTION_FIELD,
            KEY_ROTATION_STATUS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String awsAccountId;

    private final Double creationDate;

    private final String keyId;

    private final String keyManager;

    private final String keyState;

    private final String origin;

    private final String description;

    private final Boolean keyRotationStatus;

    private AwsKmsKeyDetails(BuilderImpl builder) {
        this.awsAccountId = builder.awsAccountId;
        this.creationDate = builder.creationDate;
        this.keyId = builder.keyId;
        this.keyManager = builder.keyManager;
        this.keyState = builder.keyState;
        this.origin = builder.origin;
        this.description = builder.description;
        this.keyRotationStatus = builder.keyRotationStatus;
    }

    /**
     * <p>
     * The twelve-digit account ID of the Amazon Web Services account that owns the KMS key.
     * </p>
     * 
     * @return The twelve-digit account ID of the Amazon Web Services account that owns the KMS key.
     */
    public final String awsAccountId() {
        return awsAccountId;
    }

    /**
     * <p>
     * Indicates when the KMS key was created.
     * </p>
     * <p>
     * This field accepts only the specified formats. Timestamps can end with <code>Z</code> or
     * <code>("+" / "-") time-hour [":" time-minute]</code>. The time-secfrac after seconds is limited to a maximum of 9
     * digits. The offset is bounded by +/-18:00. Here are valid timestamp formats with examples:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>YYYY-MM-DDTHH:MM:SSZ</code> (for example, <code>2019-01-31T23:00:00Z</code>)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ</code> (for example, <code>2019-01-31T23:00:00.123456789Z</code>)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>YYYY-MM-DDTHH:MM:SS+HH:MM</code> (for example, <code>2024-01-04T15:25:10+17:59</code>)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>YYYY-MM-DDTHH:MM:SS-HHMM</code> (for example, <code>2024-01-04T15:25:10-1759</code>)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM</code> (for example, <code>2024-01-04T15:25:10.123456789+17:59</code>)
     * </p>
     * </li>
     * </ul>
     * 
     * @return Indicates when the KMS key was created.</p>
     *         <p>
     *         This field accepts only the specified formats. Timestamps can end with <code>Z</code> or
     *         <code>("+" / "-") time-hour [":" time-minute]</code>. The time-secfrac after seconds is limited to a
     *         maximum of 9 digits. The offset is bounded by +/-18:00. Here are valid timestamp formats with examples:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>YYYY-MM-DDTHH:MM:SSZ</code> (for example, <code>2019-01-31T23:00:00Z</code>)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ</code> (for example, <code>2019-01-31T23:00:00.123456789Z</code>)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>YYYY-MM-DDTHH:MM:SS+HH:MM</code> (for example, <code>2024-01-04T15:25:10+17:59</code>)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>YYYY-MM-DDTHH:MM:SS-HHMM</code> (for example, <code>2024-01-04T15:25:10-1759</code>)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM</code> (for example,
     *         <code>2024-01-04T15:25:10.123456789+17:59</code>)
     *         </p>
     *         </li>
     */
    public final Double creationDate() {
        return creationDate;
    }

    /**
     * <p>
     * The globally unique identifier for the KMS key.
     * </p>
     * 
     * @return The globally unique identifier for the KMS key.
     */
    public final String keyId() {
        return keyId;
    }

    /**
     * <p>
     * The manager of the KMS key. KMS keys in your Amazon Web Services account are either customer managed or Amazon
     * Web Services managed.
     * </p>
     * 
     * @return The manager of the KMS key. KMS keys in your Amazon Web Services account are either customer managed or
     *         Amazon Web Services managed.
     */
    public final String keyManager() {
        return keyManager;
    }

    /**
     * <p>
     * The state of the KMS key. Valid values are as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Disabled</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Enabled</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PendingDeletion</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PendingImport</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Unavailable</code>
     * </p>
     * </li>
     * </ul>
     * 
     * @return The state of the KMS key. Valid values are as follows:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Disabled</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Enabled</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PendingDeletion</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PendingImport</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Unavailable</code>
     *         </p>
     *         </li>
     */
    public final String keyState() {
        return keyState;
    }

    /**
     * <p>
     * The source of the KMS key material.
     * </p>
     * <p>
     * When this value is <code>AWS_KMS</code>, KMS created the key material.
     * </p>
     * <p>
     * When this value is <code>EXTERNAL</code>, the key material was imported from your existing key management
     * infrastructure or the KMS key lacks key material.
     * </p>
     * <p>
     * When this value is <code>AWS_CLOUDHSM</code>, the key material was created in the CloudHSM cluster associated
     * with a custom key store.
     * </p>
     * 
     * @return The source of the KMS key material.</p>
     *         <p>
     *         When this value is <code>AWS_KMS</code>, KMS created the key material.
     *         </p>
     *         <p>
     *         When this value is <code>EXTERNAL</code>, the key material was imported from your existing key management
     *         infrastructure or the KMS key lacks key material.
     *         </p>
     *         <p>
     *         When this value is <code>AWS_CLOUDHSM</code>, the key material was created in the CloudHSM cluster
     *         associated with a custom key store.
     */
    public final String origin() {
        return origin;
    }

    /**
     * <p>
     * A description of the KMS key.
     * </p>
     * 
     * @return A description of the KMS key.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * Whether the key has key rotation enabled.
     * </p>
     * 
     * @return Whether the key has key rotation enabled.
     */
    public final Boolean keyRotationStatus() {
        return keyRotationStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(awsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(keyId());
        hashCode = 31 * hashCode + Objects.hashCode(keyManager());
        hashCode = 31 * hashCode + Objects.hashCode(keyState());
        hashCode = 31 * hashCode + Objects.hashCode(origin());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(keyRotationStatus());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsKmsKeyDetails)) {
            return false;
        }
        AwsKmsKeyDetails other = (AwsKmsKeyDetails) obj;
        return Objects.equals(awsAccountId(), other.awsAccountId()) && Objects.equals(creationDate(), other.creationDate())
                && Objects.equals(keyId(), other.keyId()) && Objects.equals(keyManager(), other.keyManager())
                && Objects.equals(keyState(), other.keyState()) && Objects.equals(origin(), other.origin())
                && Objects.equals(description(), other.description())
                && Objects.equals(keyRotationStatus(), other.keyRotationStatus());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsKmsKeyDetails").add("AWSAccountId", awsAccountId()).add("CreationDate", creationDate())
                .add("KeyId", keyId()).add("KeyManager", keyManager()).add("KeyState", keyState()).add("Origin", origin())
                .add("Description", description()).add("KeyRotationStatus", keyRotationStatus()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AWSAccountId":
            return Optional.ofNullable(clazz.cast(awsAccountId()));
        case "CreationDate":
            return Optional.ofNullable(clazz.cast(creationDate()));
        case "KeyId":
            return Optional.ofNullable(clazz.cast(keyId()));
        case "KeyManager":
            return Optional.ofNullable(clazz.cast(keyManager()));
        case "KeyState":
            return Optional.ofNullable(clazz.cast(keyState()));
        case "Origin":
            return Optional.ofNullable(clazz.cast(origin()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "KeyRotationStatus":
            return Optional.ofNullable(clazz.cast(keyRotationStatus()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsKmsKeyDetails, T> g) {
        return obj -> g.apply((AwsKmsKeyDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsKmsKeyDetails> {
        /**
         * <p>
         * The twelve-digit account ID of the Amazon Web Services account that owns the KMS key.
         * </p>
         * 
         * @param awsAccountId
         *        The twelve-digit account ID of the Amazon Web Services account that owns the KMS key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsAccountId(String awsAccountId);

        /**
         * <p>
         * Indicates when the KMS key was created.
         * </p>
         * <p>
         * This field accepts only the specified formats. Timestamps can end with <code>Z</code> or
         * <code>("+" / "-") time-hour [":" time-minute]</code>. The time-secfrac after seconds is limited to a maximum
         * of 9 digits. The offset is bounded by +/-18:00. Here are valid timestamp formats with examples:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>YYYY-MM-DDTHH:MM:SSZ</code> (for example, <code>2019-01-31T23:00:00Z</code>)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ</code> (for example, <code>2019-01-31T23:00:00.123456789Z</code>)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>YYYY-MM-DDTHH:MM:SS+HH:MM</code> (for example, <code>2024-01-04T15:25:10+17:59</code>)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>YYYY-MM-DDTHH:MM:SS-HHMM</code> (for example, <code>2024-01-04T15:25:10-1759</code>)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM</code> (for example,
         * <code>2024-01-04T15:25:10.123456789+17:59</code>)
         * </p>
         * </li>
         * </ul>
         * 
         * @param creationDate
         *        Indicates when the KMS key was created.</p>
         *        <p>
         *        This field accepts only the specified formats. Timestamps can end with <code>Z</code> or
         *        <code>("+" / "-") time-hour [":" time-minute]</code>. The time-secfrac after seconds is limited to a
         *        maximum of 9 digits. The offset is bounded by +/-18:00. Here are valid timestamp formats with
         *        examples:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>YYYY-MM-DDTHH:MM:SSZ</code> (for example, <code>2019-01-31T23:00:00Z</code>)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ</code> (for example, <code>2019-01-31T23:00:00.123456789Z</code>)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>YYYY-MM-DDTHH:MM:SS+HH:MM</code> (for example, <code>2024-01-04T15:25:10+17:59</code>)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>YYYY-MM-DDTHH:MM:SS-HHMM</code> (for example, <code>2024-01-04T15:25:10-1759</code>)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM</code> (for example,
         *        <code>2024-01-04T15:25:10.123456789+17:59</code>)
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDate(Double creationDate);

        /**
         * <p>
         * The globally unique identifier for the KMS key.
         * </p>
         * 
         * @param keyId
         *        The globally unique identifier for the KMS key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyId(String keyId);

        /**
         * <p>
         * The manager of the KMS key. KMS keys in your Amazon Web Services account are either customer managed or
         * Amazon Web Services managed.
         * </p>
         * 
         * @param keyManager
         *        The manager of the KMS key. KMS keys in your Amazon Web Services account are either customer managed
         *        or Amazon Web Services managed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyManager(String keyManager);

        /**
         * <p>
         * The state of the KMS key. Valid values are as follows:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Disabled</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Enabled</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PendingDeletion</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PendingImport</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Unavailable</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param keyState
         *        The state of the KMS key. Valid values are as follows:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Disabled</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Enabled</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PendingDeletion</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PendingImport</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Unavailable</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyState(String keyState);

        /**
         * <p>
         * The source of the KMS key material.
         * </p>
         * <p>
         * When this value is <code>AWS_KMS</code>, KMS created the key material.
         * </p>
         * <p>
         * When this value is <code>EXTERNAL</code>, the key material was imported from your existing key management
         * infrastructure or the KMS key lacks key material.
         * </p>
         * <p>
         * When this value is <code>AWS_CLOUDHSM</code>, the key material was created in the CloudHSM cluster associated
         * with a custom key store.
         * </p>
         * 
         * @param origin
         *        The source of the KMS key material.</p>
         *        <p>
         *        When this value is <code>AWS_KMS</code>, KMS created the key material.
         *        </p>
         *        <p>
         *        When this value is <code>EXTERNAL</code>, the key material was imported from your existing key
         *        management infrastructure or the KMS key lacks key material.
         *        </p>
         *        <p>
         *        When this value is <code>AWS_CLOUDHSM</code>, the key material was created in the CloudHSM cluster
         *        associated with a custom key store.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder origin(String origin);

        /**
         * <p>
         * A description of the KMS key.
         * </p>
         * 
         * @param description
         *        A description of the KMS key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Whether the key has key rotation enabled.
         * </p>
         * 
         * @param keyRotationStatus
         *        Whether the key has key rotation enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyRotationStatus(Boolean keyRotationStatus);
    }

    static final class BuilderImpl implements Builder {
        private String awsAccountId;

        private Double creationDate;

        private String keyId;

        private String keyManager;

        private String keyState;

        private String origin;

        private String description;

        private Boolean keyRotationStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsKmsKeyDetails model) {
            awsAccountId(model.awsAccountId);
            creationDate(model.creationDate);
            keyId(model.keyId);
            keyManager(model.keyManager);
            keyState(model.keyState);
            origin(model.origin);
            description(model.description);
            keyRotationStatus(model.keyRotationStatus);
        }

        public final String getAwsAccountId() {
            return awsAccountId;
        }

        public final void setAwsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
        }

        @Override
        public final Builder awsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        public final Double getCreationDate() {
            return creationDate;
        }

        public final void setCreationDate(Double creationDate) {
            this.creationDate = creationDate;
        }

        @Override
        public final Builder creationDate(Double creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final String getKeyId() {
            return keyId;
        }

        public final void setKeyId(String keyId) {
            this.keyId = keyId;
        }

        @Override
        public final Builder keyId(String keyId) {
            this.keyId = keyId;
            return this;
        }

        public final String getKeyManager() {
            return keyManager;
        }

        public final void setKeyManager(String keyManager) {
            this.keyManager = keyManager;
        }

        @Override
        public final Builder keyManager(String keyManager) {
            this.keyManager = keyManager;
            return this;
        }

        public final String getKeyState() {
            return keyState;
        }

        public final void setKeyState(String keyState) {
            this.keyState = keyState;
        }

        @Override
        public final Builder keyState(String keyState) {
            this.keyState = keyState;
            return this;
        }

        public final String getOrigin() {
            return origin;
        }

        public final void setOrigin(String origin) {
            this.origin = origin;
        }

        @Override
        public final Builder origin(String origin) {
            this.origin = origin;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Boolean getKeyRotationStatus() {
            return keyRotationStatus;
        }

        public final void setKeyRotationStatus(Boolean keyRotationStatus) {
            this.keyRotationStatus = keyRotationStatus;
        }

        @Override
        public final Builder keyRotationStatus(Boolean keyRotationStatus) {
            this.keyRotationStatus = keyRotationStatus;
            return this;
        }

        @Override
        public AwsKmsKeyDetails build() {
            return new AwsKmsKeyDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
