/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A time windows during which maintenance was deferred for an Amazon Redshift cluster.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsRedshiftClusterDeferredMaintenanceWindow implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsRedshiftClusterDeferredMaintenanceWindow.Builder, AwsRedshiftClusterDeferredMaintenanceWindow> {
    private static final SdkField<String> DEFER_MAINTENANCE_END_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DeferMaintenanceEndTime")
            .getter(getter(AwsRedshiftClusterDeferredMaintenanceWindow::deferMaintenanceEndTime))
            .setter(setter(Builder::deferMaintenanceEndTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeferMaintenanceEndTime").build())
            .build();

    private static final SdkField<String> DEFER_MAINTENANCE_IDENTIFIER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("DeferMaintenanceIdentifier")
            .getter(getter(AwsRedshiftClusterDeferredMaintenanceWindow::deferMaintenanceIdentifier))
            .setter(setter(Builder::deferMaintenanceIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeferMaintenanceIdentifier").build())
            .build();

    private static final SdkField<String> DEFER_MAINTENANCE_START_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DeferMaintenanceStartTime")
            .getter(getter(AwsRedshiftClusterDeferredMaintenanceWindow::deferMaintenanceStartTime))
            .setter(setter(Builder::deferMaintenanceStartTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeferMaintenanceStartTime").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            DEFER_MAINTENANCE_END_TIME_FIELD, DEFER_MAINTENANCE_IDENTIFIER_FIELD, DEFER_MAINTENANCE_START_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String deferMaintenanceEndTime;

    private final String deferMaintenanceIdentifier;

    private final String deferMaintenanceStartTime;

    private AwsRedshiftClusterDeferredMaintenanceWindow(BuilderImpl builder) {
        this.deferMaintenanceEndTime = builder.deferMaintenanceEndTime;
        this.deferMaintenanceIdentifier = builder.deferMaintenanceIdentifier;
        this.deferMaintenanceStartTime = builder.deferMaintenanceStartTime;
    }

    /**
     * <p>
     * The end of the time window for which maintenance was deferred.
     * </p>
     * <p>
     * This field accepts only the specified formats. Timestamps can end with <code>Z</code> or
     * <code>("+" / "-") time-hour [":" time-minute]</code>. The time-secfrac after seconds is limited to a maximum of 9
     * digits. The offset is bounded by +/-18:00. Here are valid timestamp formats with examples:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>YYYY-MM-DDTHH:MM:SSZ</code> (for example, <code>2019-01-31T23:00:00Z</code>)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ</code> (for example, <code>2019-01-31T23:00:00.123456789Z</code>)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>YYYY-MM-DDTHH:MM:SS+HH:MM</code> (for example, <code>2024-01-04T15:25:10+17:59</code>)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>YYYY-MM-DDTHH:MM:SS-HHMM</code> (for example, <code>2024-01-04T15:25:10-1759</code>)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM</code> (for example, <code>2024-01-04T15:25:10.123456789+17:59</code>)
     * </p>
     * </li>
     * </ul>
     * 
     * @return The end of the time window for which maintenance was deferred.</p>
     *         <p>
     *         This field accepts only the specified formats. Timestamps can end with <code>Z</code> or
     *         <code>("+" / "-") time-hour [":" time-minute]</code>. The time-secfrac after seconds is limited to a
     *         maximum of 9 digits. The offset is bounded by +/-18:00. Here are valid timestamp formats with examples:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>YYYY-MM-DDTHH:MM:SSZ</code> (for example, <code>2019-01-31T23:00:00Z</code>)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ</code> (for example, <code>2019-01-31T23:00:00.123456789Z</code>)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>YYYY-MM-DDTHH:MM:SS+HH:MM</code> (for example, <code>2024-01-04T15:25:10+17:59</code>)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>YYYY-MM-DDTHH:MM:SS-HHMM</code> (for example, <code>2024-01-04T15:25:10-1759</code>)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM</code> (for example,
     *         <code>2024-01-04T15:25:10.123456789+17:59</code>)
     *         </p>
     *         </li>
     */
    public final String deferMaintenanceEndTime() {
        return deferMaintenanceEndTime;
    }

    /**
     * <p>
     * The identifier of the maintenance window.
     * </p>
     * 
     * @return The identifier of the maintenance window.
     */
    public final String deferMaintenanceIdentifier() {
        return deferMaintenanceIdentifier;
    }

    /**
     * <p>
     * The start of the time window for which maintenance was deferred.
     * </p>
     * <p>
     * This field accepts only the specified formats. Timestamps can end with <code>Z</code> or
     * <code>("+" / "-") time-hour [":" time-minute]</code>. The time-secfrac after seconds is limited to a maximum of 9
     * digits. The offset is bounded by +/-18:00. Here are valid timestamp formats with examples:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>YYYY-MM-DDTHH:MM:SSZ</code> (for example, <code>2019-01-31T23:00:00Z</code>)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ</code> (for example, <code>2019-01-31T23:00:00.123456789Z</code>)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>YYYY-MM-DDTHH:MM:SS+HH:MM</code> (for example, <code>2024-01-04T15:25:10+17:59</code>)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>YYYY-MM-DDTHH:MM:SS-HHMM</code> (for example, <code>2024-01-04T15:25:10-1759</code>)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM</code> (for example, <code>2024-01-04T15:25:10.123456789+17:59</code>)
     * </p>
     * </li>
     * </ul>
     * 
     * @return The start of the time window for which maintenance was deferred.</p>
     *         <p>
     *         This field accepts only the specified formats. Timestamps can end with <code>Z</code> or
     *         <code>("+" / "-") time-hour [":" time-minute]</code>. The time-secfrac after seconds is limited to a
     *         maximum of 9 digits. The offset is bounded by +/-18:00. Here are valid timestamp formats with examples:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>YYYY-MM-DDTHH:MM:SSZ</code> (for example, <code>2019-01-31T23:00:00Z</code>)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ</code> (for example, <code>2019-01-31T23:00:00.123456789Z</code>)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>YYYY-MM-DDTHH:MM:SS+HH:MM</code> (for example, <code>2024-01-04T15:25:10+17:59</code>)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>YYYY-MM-DDTHH:MM:SS-HHMM</code> (for example, <code>2024-01-04T15:25:10-1759</code>)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM</code> (for example,
     *         <code>2024-01-04T15:25:10.123456789+17:59</code>)
     *         </p>
     *         </li>
     */
    public final String deferMaintenanceStartTime() {
        return deferMaintenanceStartTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(deferMaintenanceEndTime());
        hashCode = 31 * hashCode + Objects.hashCode(deferMaintenanceIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(deferMaintenanceStartTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsRedshiftClusterDeferredMaintenanceWindow)) {
            return false;
        }
        AwsRedshiftClusterDeferredMaintenanceWindow other = (AwsRedshiftClusterDeferredMaintenanceWindow) obj;
        return Objects.equals(deferMaintenanceEndTime(), other.deferMaintenanceEndTime())
                && Objects.equals(deferMaintenanceIdentifier(), other.deferMaintenanceIdentifier())
                && Objects.equals(deferMaintenanceStartTime(), other.deferMaintenanceStartTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsRedshiftClusterDeferredMaintenanceWindow")
                .add("DeferMaintenanceEndTime", deferMaintenanceEndTime())
                .add("DeferMaintenanceIdentifier", deferMaintenanceIdentifier())
                .add("DeferMaintenanceStartTime", deferMaintenanceStartTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DeferMaintenanceEndTime":
            return Optional.ofNullable(clazz.cast(deferMaintenanceEndTime()));
        case "DeferMaintenanceIdentifier":
            return Optional.ofNullable(clazz.cast(deferMaintenanceIdentifier()));
        case "DeferMaintenanceStartTime":
            return Optional.ofNullable(clazz.cast(deferMaintenanceStartTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsRedshiftClusterDeferredMaintenanceWindow, T> g) {
        return obj -> g.apply((AwsRedshiftClusterDeferredMaintenanceWindow) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsRedshiftClusterDeferredMaintenanceWindow> {
        /**
         * <p>
         * The end of the time window for which maintenance was deferred.
         * </p>
         * <p>
         * This field accepts only the specified formats. Timestamps can end with <code>Z</code> or
         * <code>("+" / "-") time-hour [":" time-minute]</code>. The time-secfrac after seconds is limited to a maximum
         * of 9 digits. The offset is bounded by +/-18:00. Here are valid timestamp formats with examples:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>YYYY-MM-DDTHH:MM:SSZ</code> (for example, <code>2019-01-31T23:00:00Z</code>)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ</code> (for example, <code>2019-01-31T23:00:00.123456789Z</code>)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>YYYY-MM-DDTHH:MM:SS+HH:MM</code> (for example, <code>2024-01-04T15:25:10+17:59</code>)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>YYYY-MM-DDTHH:MM:SS-HHMM</code> (for example, <code>2024-01-04T15:25:10-1759</code>)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM</code> (for example,
         * <code>2024-01-04T15:25:10.123456789+17:59</code>)
         * </p>
         * </li>
         * </ul>
         * 
         * @param deferMaintenanceEndTime
         *        The end of the time window for which maintenance was deferred.</p>
         *        <p>
         *        This field accepts only the specified formats. Timestamps can end with <code>Z</code> or
         *        <code>("+" / "-") time-hour [":" time-minute]</code>. The time-secfrac after seconds is limited to a
         *        maximum of 9 digits. The offset is bounded by +/-18:00. Here are valid timestamp formats with
         *        examples:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>YYYY-MM-DDTHH:MM:SSZ</code> (for example, <code>2019-01-31T23:00:00Z</code>)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ</code> (for example, <code>2019-01-31T23:00:00.123456789Z</code>)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>YYYY-MM-DDTHH:MM:SS+HH:MM</code> (for example, <code>2024-01-04T15:25:10+17:59</code>)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>YYYY-MM-DDTHH:MM:SS-HHMM</code> (for example, <code>2024-01-04T15:25:10-1759</code>)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM</code> (for example,
         *        <code>2024-01-04T15:25:10.123456789+17:59</code>)
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deferMaintenanceEndTime(String deferMaintenanceEndTime);

        /**
         * <p>
         * The identifier of the maintenance window.
         * </p>
         * 
         * @param deferMaintenanceIdentifier
         *        The identifier of the maintenance window.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deferMaintenanceIdentifier(String deferMaintenanceIdentifier);

        /**
         * <p>
         * The start of the time window for which maintenance was deferred.
         * </p>
         * <p>
         * This field accepts only the specified formats. Timestamps can end with <code>Z</code> or
         * <code>("+" / "-") time-hour [":" time-minute]</code>. The time-secfrac after seconds is limited to a maximum
         * of 9 digits. The offset is bounded by +/-18:00. Here are valid timestamp formats with examples:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>YYYY-MM-DDTHH:MM:SSZ</code> (for example, <code>2019-01-31T23:00:00Z</code>)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ</code> (for example, <code>2019-01-31T23:00:00.123456789Z</code>)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>YYYY-MM-DDTHH:MM:SS+HH:MM</code> (for example, <code>2024-01-04T15:25:10+17:59</code>)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>YYYY-MM-DDTHH:MM:SS-HHMM</code> (for example, <code>2024-01-04T15:25:10-1759</code>)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM</code> (for example,
         * <code>2024-01-04T15:25:10.123456789+17:59</code>)
         * </p>
         * </li>
         * </ul>
         * 
         * @param deferMaintenanceStartTime
         *        The start of the time window for which maintenance was deferred.</p>
         *        <p>
         *        This field accepts only the specified formats. Timestamps can end with <code>Z</code> or
         *        <code>("+" / "-") time-hour [":" time-minute]</code>. The time-secfrac after seconds is limited to a
         *        maximum of 9 digits. The offset is bounded by +/-18:00. Here are valid timestamp formats with
         *        examples:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>YYYY-MM-DDTHH:MM:SSZ</code> (for example, <code>2019-01-31T23:00:00Z</code>)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ</code> (for example, <code>2019-01-31T23:00:00.123456789Z</code>)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>YYYY-MM-DDTHH:MM:SS+HH:MM</code> (for example, <code>2024-01-04T15:25:10+17:59</code>)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>YYYY-MM-DDTHH:MM:SS-HHMM</code> (for example, <code>2024-01-04T15:25:10-1759</code>)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM</code> (for example,
         *        <code>2024-01-04T15:25:10.123456789+17:59</code>)
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deferMaintenanceStartTime(String deferMaintenanceStartTime);
    }

    static final class BuilderImpl implements Builder {
        private String deferMaintenanceEndTime;

        private String deferMaintenanceIdentifier;

        private String deferMaintenanceStartTime;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsRedshiftClusterDeferredMaintenanceWindow model) {
            deferMaintenanceEndTime(model.deferMaintenanceEndTime);
            deferMaintenanceIdentifier(model.deferMaintenanceIdentifier);
            deferMaintenanceStartTime(model.deferMaintenanceStartTime);
        }

        public final String getDeferMaintenanceEndTime() {
            return deferMaintenanceEndTime;
        }

        public final void setDeferMaintenanceEndTime(String deferMaintenanceEndTime) {
            this.deferMaintenanceEndTime = deferMaintenanceEndTime;
        }

        @Override
        public final Builder deferMaintenanceEndTime(String deferMaintenanceEndTime) {
            this.deferMaintenanceEndTime = deferMaintenanceEndTime;
            return this;
        }

        public final String getDeferMaintenanceIdentifier() {
            return deferMaintenanceIdentifier;
        }

        public final void setDeferMaintenanceIdentifier(String deferMaintenanceIdentifier) {
            this.deferMaintenanceIdentifier = deferMaintenanceIdentifier;
        }

        @Override
        public final Builder deferMaintenanceIdentifier(String deferMaintenanceIdentifier) {
            this.deferMaintenanceIdentifier = deferMaintenanceIdentifier;
            return this;
        }

        public final String getDeferMaintenanceStartTime() {
            return deferMaintenanceStartTime;
        }

        public final void setDeferMaintenanceStartTime(String deferMaintenanceStartTime) {
            this.deferMaintenanceStartTime = deferMaintenanceStartTime;
        }

        @Override
        public final Builder deferMaintenanceStartTime(String deferMaintenanceStartTime) {
            this.deferMaintenanceStartTime = deferMaintenanceStartTime;
            return this;
        }

        @Override
        public AwsRedshiftClusterDeferredMaintenanceWindow build() {
            return new AwsRedshiftClusterDeferredMaintenanceWindow(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
