/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The details of an Amazon Simple Storage Service (Amazon S3) bucket.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsS3BucketDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsS3BucketDetails.Builder, AwsS3BucketDetails> {
    private static final SdkField<String> OWNER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OwnerId").getter(getter(AwsS3BucketDetails::ownerId)).setter(setter(Builder::ownerId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerId").build()).build();

    private static final SdkField<String> OWNER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OwnerName").getter(getter(AwsS3BucketDetails::ownerName)).setter(setter(Builder::ownerName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerName").build()).build();

    private static final SdkField<String> OWNER_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OwnerAccountId").getter(getter(AwsS3BucketDetails::ownerAccountId))
            .setter(setter(Builder::ownerAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerAccountId").build()).build();

    private static final SdkField<String> CREATED_AT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CreatedAt").getter(getter(AwsS3BucketDetails::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()).build();

    private static final SdkField<AwsS3BucketServerSideEncryptionConfiguration> SERVER_SIDE_ENCRYPTION_CONFIGURATION_FIELD = SdkField
            .<AwsS3BucketServerSideEncryptionConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("ServerSideEncryptionConfiguration")
            .getter(getter(AwsS3BucketDetails::serverSideEncryptionConfiguration))
            .setter(setter(Builder::serverSideEncryptionConfiguration))
            .constructor(AwsS3BucketServerSideEncryptionConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerSideEncryptionConfiguration")
                    .build()).build();

    private static final SdkField<AwsS3BucketBucketLifecycleConfigurationDetails> BUCKET_LIFECYCLE_CONFIGURATION_FIELD = SdkField
            .<AwsS3BucketBucketLifecycleConfigurationDetails> builder(MarshallingType.SDK_POJO)
            .memberName("BucketLifecycleConfiguration")
            .getter(getter(AwsS3BucketDetails::bucketLifecycleConfiguration))
            .setter(setter(Builder::bucketLifecycleConfiguration))
            .constructor(AwsS3BucketBucketLifecycleConfigurationDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BucketLifecycleConfiguration")
                    .build()).build();

    private static final SdkField<AwsS3AccountPublicAccessBlockDetails> PUBLIC_ACCESS_BLOCK_CONFIGURATION_FIELD = SdkField
            .<AwsS3AccountPublicAccessBlockDetails> builder(MarshallingType.SDK_POJO)
            .memberName("PublicAccessBlockConfiguration")
            .getter(getter(AwsS3BucketDetails::publicAccessBlockConfiguration))
            .setter(setter(Builder::publicAccessBlockConfiguration))
            .constructor(AwsS3AccountPublicAccessBlockDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublicAccessBlockConfiguration")
                    .build()).build();

    private static final SdkField<String> ACCESS_CONTROL_LIST_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AccessControlList").getter(getter(AwsS3BucketDetails::accessControlList))
            .setter(setter(Builder::accessControlList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessControlList").build()).build();

    private static final SdkField<AwsS3BucketLoggingConfiguration> BUCKET_LOGGING_CONFIGURATION_FIELD = SdkField
            .<AwsS3BucketLoggingConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("BucketLoggingConfiguration")
            .getter(getter(AwsS3BucketDetails::bucketLoggingConfiguration))
            .setter(setter(Builder::bucketLoggingConfiguration))
            .constructor(AwsS3BucketLoggingConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BucketLoggingConfiguration").build())
            .build();

    private static final SdkField<AwsS3BucketWebsiteConfiguration> BUCKET_WEBSITE_CONFIGURATION_FIELD = SdkField
            .<AwsS3BucketWebsiteConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("BucketWebsiteConfiguration")
            .getter(getter(AwsS3BucketDetails::bucketWebsiteConfiguration))
            .setter(setter(Builder::bucketWebsiteConfiguration))
            .constructor(AwsS3BucketWebsiteConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BucketWebsiteConfiguration").build())
            .build();

    private static final SdkField<AwsS3BucketNotificationConfiguration> BUCKET_NOTIFICATION_CONFIGURATION_FIELD = SdkField
            .<AwsS3BucketNotificationConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("BucketNotificationConfiguration")
            .getter(getter(AwsS3BucketDetails::bucketNotificationConfiguration))
            .setter(setter(Builder::bucketNotificationConfiguration))
            .constructor(AwsS3BucketNotificationConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BucketNotificationConfiguration")
                    .build()).build();

    private static final SdkField<AwsS3BucketBucketVersioningConfiguration> BUCKET_VERSIONING_CONFIGURATION_FIELD = SdkField
            .<AwsS3BucketBucketVersioningConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("BucketVersioningConfiguration")
            .getter(getter(AwsS3BucketDetails::bucketVersioningConfiguration))
            .setter(setter(Builder::bucketVersioningConfiguration))
            .constructor(AwsS3BucketBucketVersioningConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BucketVersioningConfiguration")
                    .build()).build();

    private static final SdkField<AwsS3BucketObjectLockConfiguration> OBJECT_LOCK_CONFIGURATION_FIELD = SdkField
            .<AwsS3BucketObjectLockConfiguration> builder(MarshallingType.SDK_POJO).memberName("ObjectLockConfiguration")
            .getter(getter(AwsS3BucketDetails::objectLockConfiguration)).setter(setter(Builder::objectLockConfiguration))
            .constructor(AwsS3BucketObjectLockConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ObjectLockConfiguration").build())
            .build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(AwsS3BucketDetails::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OWNER_ID_FIELD,
            OWNER_NAME_FIELD, OWNER_ACCOUNT_ID_FIELD, CREATED_AT_FIELD, SERVER_SIDE_ENCRYPTION_CONFIGURATION_FIELD,
            BUCKET_LIFECYCLE_CONFIGURATION_FIELD, PUBLIC_ACCESS_BLOCK_CONFIGURATION_FIELD, ACCESS_CONTROL_LIST_FIELD,
            BUCKET_LOGGING_CONFIGURATION_FIELD, BUCKET_WEBSITE_CONFIGURATION_FIELD, BUCKET_NOTIFICATION_CONFIGURATION_FIELD,
            BUCKET_VERSIONING_CONFIGURATION_FIELD, OBJECT_LOCK_CONFIGURATION_FIELD, NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String ownerId;

    private final String ownerName;

    private final String ownerAccountId;

    private final String createdAt;

    private final AwsS3BucketServerSideEncryptionConfiguration serverSideEncryptionConfiguration;

    private final AwsS3BucketBucketLifecycleConfigurationDetails bucketLifecycleConfiguration;

    private final AwsS3AccountPublicAccessBlockDetails publicAccessBlockConfiguration;

    private final String accessControlList;

    private final AwsS3BucketLoggingConfiguration bucketLoggingConfiguration;

    private final AwsS3BucketWebsiteConfiguration bucketWebsiteConfiguration;

    private final AwsS3BucketNotificationConfiguration bucketNotificationConfiguration;

    private final AwsS3BucketBucketVersioningConfiguration bucketVersioningConfiguration;

    private final AwsS3BucketObjectLockConfiguration objectLockConfiguration;

    private final String name;

    private AwsS3BucketDetails(BuilderImpl builder) {
        this.ownerId = builder.ownerId;
        this.ownerName = builder.ownerName;
        this.ownerAccountId = builder.ownerAccountId;
        this.createdAt = builder.createdAt;
        this.serverSideEncryptionConfiguration = builder.serverSideEncryptionConfiguration;
        this.bucketLifecycleConfiguration = builder.bucketLifecycleConfiguration;
        this.publicAccessBlockConfiguration = builder.publicAccessBlockConfiguration;
        this.accessControlList = builder.accessControlList;
        this.bucketLoggingConfiguration = builder.bucketLoggingConfiguration;
        this.bucketWebsiteConfiguration = builder.bucketWebsiteConfiguration;
        this.bucketNotificationConfiguration = builder.bucketNotificationConfiguration;
        this.bucketVersioningConfiguration = builder.bucketVersioningConfiguration;
        this.objectLockConfiguration = builder.objectLockConfiguration;
        this.name = builder.name;
    }

    /**
     * <p>
     * The canonical user ID of the owner of the S3 bucket.
     * </p>
     * 
     * @return The canonical user ID of the owner of the S3 bucket.
     */
    public final String ownerId() {
        return ownerId;
    }

    /**
     * <p>
     * The display name of the owner of the S3 bucket.
     * </p>
     * 
     * @return The display name of the owner of the S3 bucket.
     */
    public final String ownerName() {
        return ownerName;
    }

    /**
     * <p>
     * The Amazon Web Services account identifier of the account that owns the S3 bucket.
     * </p>
     * 
     * @return The Amazon Web Services account identifier of the account that owns the S3 bucket.
     */
    public final String ownerAccountId() {
        return ownerAccountId;
    }

    /**
     * <p>
     * Indicates when the S3 bucket was created.
     * </p>
     * <p>
     * This field accepts only the specified formats. Timestamps can end with <code>Z</code> or
     * <code>("+" / "-") time-hour [":" time-minute]</code>. The time-secfrac after seconds is limited to a maximum of 9
     * digits. The offset is bounded by +/-18:00. Here are valid timestamp formats with examples:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>YYYY-MM-DDTHH:MM:SSZ</code> (for example, <code>2019-01-31T23:00:00Z</code>)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ</code> (for example, <code>2019-01-31T23:00:00.123456789Z</code>)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>YYYY-MM-DDTHH:MM:SS+HH:MM</code> (for example, <code>2024-01-04T15:25:10+17:59</code>)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>YYYY-MM-DDTHH:MM:SS-HHMM</code> (for example, <code>2024-01-04T15:25:10-1759</code>)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM</code> (for example, <code>2024-01-04T15:25:10.123456789+17:59</code>)
     * </p>
     * </li>
     * </ul>
     * 
     * @return Indicates when the S3 bucket was created.</p>
     *         <p>
     *         This field accepts only the specified formats. Timestamps can end with <code>Z</code> or
     *         <code>("+" / "-") time-hour [":" time-minute]</code>. The time-secfrac after seconds is limited to a
     *         maximum of 9 digits. The offset is bounded by +/-18:00. Here are valid timestamp formats with examples:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>YYYY-MM-DDTHH:MM:SSZ</code> (for example, <code>2019-01-31T23:00:00Z</code>)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ</code> (for example, <code>2019-01-31T23:00:00.123456789Z</code>)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>YYYY-MM-DDTHH:MM:SS+HH:MM</code> (for example, <code>2024-01-04T15:25:10+17:59</code>)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>YYYY-MM-DDTHH:MM:SS-HHMM</code> (for example, <code>2024-01-04T15:25:10-1759</code>)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM</code> (for example,
     *         <code>2024-01-04T15:25:10.123456789+17:59</code>)
     *         </p>
     *         </li>
     */
    public final String createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The encryption rules that are applied to the S3 bucket.
     * </p>
     * 
     * @return The encryption rules that are applied to the S3 bucket.
     */
    public final AwsS3BucketServerSideEncryptionConfiguration serverSideEncryptionConfiguration() {
        return serverSideEncryptionConfiguration;
    }

    /**
     * <p>
     * The lifecycle configuration for objects in the specified bucket.
     * </p>
     * 
     * @return The lifecycle configuration for objects in the specified bucket.
     */
    public final AwsS3BucketBucketLifecycleConfigurationDetails bucketLifecycleConfiguration() {
        return bucketLifecycleConfiguration;
    }

    /**
     * <p>
     * Provides information about the Amazon S3 Public Access Block configuration for the S3 bucket.
     * </p>
     * 
     * @return Provides information about the Amazon S3 Public Access Block configuration for the S3 bucket.
     */
    public final AwsS3AccountPublicAccessBlockDetails publicAccessBlockConfiguration() {
        return publicAccessBlockConfiguration;
    }

    /**
     * <p>
     * The access control list for the S3 bucket.
     * </p>
     * 
     * @return The access control list for the S3 bucket.
     */
    public final String accessControlList() {
        return accessControlList;
    }

    /**
     * <p>
     * The logging configuration for the S3 bucket.
     * </p>
     * 
     * @return The logging configuration for the S3 bucket.
     */
    public final AwsS3BucketLoggingConfiguration bucketLoggingConfiguration() {
        return bucketLoggingConfiguration;
    }

    /**
     * <p>
     * The website configuration parameters for the S3 bucket.
     * </p>
     * 
     * @return The website configuration parameters for the S3 bucket.
     */
    public final AwsS3BucketWebsiteConfiguration bucketWebsiteConfiguration() {
        return bucketWebsiteConfiguration;
    }

    /**
     * <p>
     * The notification configuration for the S3 bucket.
     * </p>
     * 
     * @return The notification configuration for the S3 bucket.
     */
    public final AwsS3BucketNotificationConfiguration bucketNotificationConfiguration() {
        return bucketNotificationConfiguration;
    }

    /**
     * <p>
     * The versioning state of an S3 bucket.
     * </p>
     * 
     * @return The versioning state of an S3 bucket.
     */
    public final AwsS3BucketBucketVersioningConfiguration bucketVersioningConfiguration() {
        return bucketVersioningConfiguration;
    }

    /**
     * <p>
     * Specifies which rule Amazon S3 applies by default to every new object placed in the bucket.
     * </p>
     * 
     * @return Specifies which rule Amazon S3 applies by default to every new object placed in the bucket.
     */
    public final AwsS3BucketObjectLockConfiguration objectLockConfiguration() {
        return objectLockConfiguration;
    }

    /**
     * <p>
     * The name of the bucket.
     * </p>
     * 
     * @return The name of the bucket.
     */
    public final String name() {
        return name;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(ownerId());
        hashCode = 31 * hashCode + Objects.hashCode(ownerName());
        hashCode = 31 * hashCode + Objects.hashCode(ownerAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(serverSideEncryptionConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(bucketLifecycleConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(publicAccessBlockConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(accessControlList());
        hashCode = 31 * hashCode + Objects.hashCode(bucketLoggingConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(bucketWebsiteConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(bucketNotificationConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(bucketVersioningConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(objectLockConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsS3BucketDetails)) {
            return false;
        }
        AwsS3BucketDetails other = (AwsS3BucketDetails) obj;
        return Objects.equals(ownerId(), other.ownerId()) && Objects.equals(ownerName(), other.ownerName())
                && Objects.equals(ownerAccountId(), other.ownerAccountId()) && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(serverSideEncryptionConfiguration(), other.serverSideEncryptionConfiguration())
                && Objects.equals(bucketLifecycleConfiguration(), other.bucketLifecycleConfiguration())
                && Objects.equals(publicAccessBlockConfiguration(), other.publicAccessBlockConfiguration())
                && Objects.equals(accessControlList(), other.accessControlList())
                && Objects.equals(bucketLoggingConfiguration(), other.bucketLoggingConfiguration())
                && Objects.equals(bucketWebsiteConfiguration(), other.bucketWebsiteConfiguration())
                && Objects.equals(bucketNotificationConfiguration(), other.bucketNotificationConfiguration())
                && Objects.equals(bucketVersioningConfiguration(), other.bucketVersioningConfiguration())
                && Objects.equals(objectLockConfiguration(), other.objectLockConfiguration())
                && Objects.equals(name(), other.name());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsS3BucketDetails").add("OwnerId", ownerId()).add("OwnerName", ownerName())
                .add("OwnerAccountId", ownerAccountId()).add("CreatedAt", createdAt())
                .add("ServerSideEncryptionConfiguration", serverSideEncryptionConfiguration())
                .add("BucketLifecycleConfiguration", bucketLifecycleConfiguration())
                .add("PublicAccessBlockConfiguration", publicAccessBlockConfiguration())
                .add("AccessControlList", accessControlList()).add("BucketLoggingConfiguration", bucketLoggingConfiguration())
                .add("BucketWebsiteConfiguration", bucketWebsiteConfiguration())
                .add("BucketNotificationConfiguration", bucketNotificationConfiguration())
                .add("BucketVersioningConfiguration", bucketVersioningConfiguration())
                .add("ObjectLockConfiguration", objectLockConfiguration()).add("Name", name()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OwnerId":
            return Optional.ofNullable(clazz.cast(ownerId()));
        case "OwnerName":
            return Optional.ofNullable(clazz.cast(ownerName()));
        case "OwnerAccountId":
            return Optional.ofNullable(clazz.cast(ownerAccountId()));
        case "CreatedAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "ServerSideEncryptionConfiguration":
            return Optional.ofNullable(clazz.cast(serverSideEncryptionConfiguration()));
        case "BucketLifecycleConfiguration":
            return Optional.ofNullable(clazz.cast(bucketLifecycleConfiguration()));
        case "PublicAccessBlockConfiguration":
            return Optional.ofNullable(clazz.cast(publicAccessBlockConfiguration()));
        case "AccessControlList":
            return Optional.ofNullable(clazz.cast(accessControlList()));
        case "BucketLoggingConfiguration":
            return Optional.ofNullable(clazz.cast(bucketLoggingConfiguration()));
        case "BucketWebsiteConfiguration":
            return Optional.ofNullable(clazz.cast(bucketWebsiteConfiguration()));
        case "BucketNotificationConfiguration":
            return Optional.ofNullable(clazz.cast(bucketNotificationConfiguration()));
        case "BucketVersioningConfiguration":
            return Optional.ofNullable(clazz.cast(bucketVersioningConfiguration()));
        case "ObjectLockConfiguration":
            return Optional.ofNullable(clazz.cast(objectLockConfiguration()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsS3BucketDetails, T> g) {
        return obj -> g.apply((AwsS3BucketDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsS3BucketDetails> {
        /**
         * <p>
         * The canonical user ID of the owner of the S3 bucket.
         * </p>
         * 
         * @param ownerId
         *        The canonical user ID of the owner of the S3 bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ownerId(String ownerId);

        /**
         * <p>
         * The display name of the owner of the S3 bucket.
         * </p>
         * 
         * @param ownerName
         *        The display name of the owner of the S3 bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ownerName(String ownerName);

        /**
         * <p>
         * The Amazon Web Services account identifier of the account that owns the S3 bucket.
         * </p>
         * 
         * @param ownerAccountId
         *        The Amazon Web Services account identifier of the account that owns the S3 bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ownerAccountId(String ownerAccountId);

        /**
         * <p>
         * Indicates when the S3 bucket was created.
         * </p>
         * <p>
         * This field accepts only the specified formats. Timestamps can end with <code>Z</code> or
         * <code>("+" / "-") time-hour [":" time-minute]</code>. The time-secfrac after seconds is limited to a maximum
         * of 9 digits. The offset is bounded by +/-18:00. Here are valid timestamp formats with examples:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>YYYY-MM-DDTHH:MM:SSZ</code> (for example, <code>2019-01-31T23:00:00Z</code>)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ</code> (for example, <code>2019-01-31T23:00:00.123456789Z</code>)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>YYYY-MM-DDTHH:MM:SS+HH:MM</code> (for example, <code>2024-01-04T15:25:10+17:59</code>)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>YYYY-MM-DDTHH:MM:SS-HHMM</code> (for example, <code>2024-01-04T15:25:10-1759</code>)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM</code> (for example,
         * <code>2024-01-04T15:25:10.123456789+17:59</code>)
         * </p>
         * </li>
         * </ul>
         * 
         * @param createdAt
         *        Indicates when the S3 bucket was created.</p>
         *        <p>
         *        This field accepts only the specified formats. Timestamps can end with <code>Z</code> or
         *        <code>("+" / "-") time-hour [":" time-minute]</code>. The time-secfrac after seconds is limited to a
         *        maximum of 9 digits. The offset is bounded by +/-18:00. Here are valid timestamp formats with
         *        examples:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>YYYY-MM-DDTHH:MM:SSZ</code> (for example, <code>2019-01-31T23:00:00Z</code>)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ</code> (for example, <code>2019-01-31T23:00:00.123456789Z</code>)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>YYYY-MM-DDTHH:MM:SS+HH:MM</code> (for example, <code>2024-01-04T15:25:10+17:59</code>)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>YYYY-MM-DDTHH:MM:SS-HHMM</code> (for example, <code>2024-01-04T15:25:10-1759</code>)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM</code> (for example,
         *        <code>2024-01-04T15:25:10.123456789+17:59</code>)
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(String createdAt);

        /**
         * <p>
         * The encryption rules that are applied to the S3 bucket.
         * </p>
         * 
         * @param serverSideEncryptionConfiguration
         *        The encryption rules that are applied to the S3 bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serverSideEncryptionConfiguration(AwsS3BucketServerSideEncryptionConfiguration serverSideEncryptionConfiguration);

        /**
         * <p>
         * The encryption rules that are applied to the S3 bucket.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AwsS3BucketServerSideEncryptionConfiguration.Builder} avoiding the need to create one manually via
         * {@link AwsS3BucketServerSideEncryptionConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsS3BucketServerSideEncryptionConfiguration.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #serverSideEncryptionConfiguration(AwsS3BucketServerSideEncryptionConfiguration)}.
         * 
         * @param serverSideEncryptionConfiguration
         *        a consumer that will call methods on {@link AwsS3BucketServerSideEncryptionConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #serverSideEncryptionConfiguration(AwsS3BucketServerSideEncryptionConfiguration)
         */
        default Builder serverSideEncryptionConfiguration(
                Consumer<AwsS3BucketServerSideEncryptionConfiguration.Builder> serverSideEncryptionConfiguration) {
            return serverSideEncryptionConfiguration(AwsS3BucketServerSideEncryptionConfiguration.builder()
                    .applyMutation(serverSideEncryptionConfiguration).build());
        }

        /**
         * <p>
         * The lifecycle configuration for objects in the specified bucket.
         * </p>
         * 
         * @param bucketLifecycleConfiguration
         *        The lifecycle configuration for objects in the specified bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bucketLifecycleConfiguration(AwsS3BucketBucketLifecycleConfigurationDetails bucketLifecycleConfiguration);

        /**
         * <p>
         * The lifecycle configuration for objects in the specified bucket.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AwsS3BucketBucketLifecycleConfigurationDetails.Builder} avoiding the need to create one manually via
         * {@link AwsS3BucketBucketLifecycleConfigurationDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsS3BucketBucketLifecycleConfigurationDetails.Builder#build()}
         * is called immediately and its result is passed to
         * {@link #bucketLifecycleConfiguration(AwsS3BucketBucketLifecycleConfigurationDetails)}.
         * 
         * @param bucketLifecycleConfiguration
         *        a consumer that will call methods on {@link AwsS3BucketBucketLifecycleConfigurationDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #bucketLifecycleConfiguration(AwsS3BucketBucketLifecycleConfigurationDetails)
         */
        default Builder bucketLifecycleConfiguration(
                Consumer<AwsS3BucketBucketLifecycleConfigurationDetails.Builder> bucketLifecycleConfiguration) {
            return bucketLifecycleConfiguration(AwsS3BucketBucketLifecycleConfigurationDetails.builder()
                    .applyMutation(bucketLifecycleConfiguration).build());
        }

        /**
         * <p>
         * Provides information about the Amazon S3 Public Access Block configuration for the S3 bucket.
         * </p>
         * 
         * @param publicAccessBlockConfiguration
         *        Provides information about the Amazon S3 Public Access Block configuration for the S3 bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publicAccessBlockConfiguration(AwsS3AccountPublicAccessBlockDetails publicAccessBlockConfiguration);

        /**
         * <p>
         * Provides information about the Amazon S3 Public Access Block configuration for the S3 bucket.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AwsS3AccountPublicAccessBlockDetails.Builder} avoiding the need to create one manually via
         * {@link AwsS3AccountPublicAccessBlockDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsS3AccountPublicAccessBlockDetails.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #publicAccessBlockConfiguration(AwsS3AccountPublicAccessBlockDetails)}.
         * 
         * @param publicAccessBlockConfiguration
         *        a consumer that will call methods on {@link AwsS3AccountPublicAccessBlockDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #publicAccessBlockConfiguration(AwsS3AccountPublicAccessBlockDetails)
         */
        default Builder publicAccessBlockConfiguration(
                Consumer<AwsS3AccountPublicAccessBlockDetails.Builder> publicAccessBlockConfiguration) {
            return publicAccessBlockConfiguration(AwsS3AccountPublicAccessBlockDetails.builder()
                    .applyMutation(publicAccessBlockConfiguration).build());
        }

        /**
         * <p>
         * The access control list for the S3 bucket.
         * </p>
         * 
         * @param accessControlList
         *        The access control list for the S3 bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessControlList(String accessControlList);

        /**
         * <p>
         * The logging configuration for the S3 bucket.
         * </p>
         * 
         * @param bucketLoggingConfiguration
         *        The logging configuration for the S3 bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bucketLoggingConfiguration(AwsS3BucketLoggingConfiguration bucketLoggingConfiguration);

        /**
         * <p>
         * The logging configuration for the S3 bucket.
         * </p>
         * This is a convenience method that creates an instance of the {@link AwsS3BucketLoggingConfiguration.Builder}
         * avoiding the need to create one manually via {@link AwsS3BucketLoggingConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsS3BucketLoggingConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #bucketLoggingConfiguration(AwsS3BucketLoggingConfiguration)}.
         * 
         * @param bucketLoggingConfiguration
         *        a consumer that will call methods on {@link AwsS3BucketLoggingConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #bucketLoggingConfiguration(AwsS3BucketLoggingConfiguration)
         */
        default Builder bucketLoggingConfiguration(Consumer<AwsS3BucketLoggingConfiguration.Builder> bucketLoggingConfiguration) {
            return bucketLoggingConfiguration(AwsS3BucketLoggingConfiguration.builder().applyMutation(bucketLoggingConfiguration)
                    .build());
        }

        /**
         * <p>
         * The website configuration parameters for the S3 bucket.
         * </p>
         * 
         * @param bucketWebsiteConfiguration
         *        The website configuration parameters for the S3 bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bucketWebsiteConfiguration(AwsS3BucketWebsiteConfiguration bucketWebsiteConfiguration);

        /**
         * <p>
         * The website configuration parameters for the S3 bucket.
         * </p>
         * This is a convenience method that creates an instance of the {@link AwsS3BucketWebsiteConfiguration.Builder}
         * avoiding the need to create one manually via {@link AwsS3BucketWebsiteConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsS3BucketWebsiteConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #bucketWebsiteConfiguration(AwsS3BucketWebsiteConfiguration)}.
         * 
         * @param bucketWebsiteConfiguration
         *        a consumer that will call methods on {@link AwsS3BucketWebsiteConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #bucketWebsiteConfiguration(AwsS3BucketWebsiteConfiguration)
         */
        default Builder bucketWebsiteConfiguration(Consumer<AwsS3BucketWebsiteConfiguration.Builder> bucketWebsiteConfiguration) {
            return bucketWebsiteConfiguration(AwsS3BucketWebsiteConfiguration.builder().applyMutation(bucketWebsiteConfiguration)
                    .build());
        }

        /**
         * <p>
         * The notification configuration for the S3 bucket.
         * </p>
         * 
         * @param bucketNotificationConfiguration
         *        The notification configuration for the S3 bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bucketNotificationConfiguration(AwsS3BucketNotificationConfiguration bucketNotificationConfiguration);

        /**
         * <p>
         * The notification configuration for the S3 bucket.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AwsS3BucketNotificationConfiguration.Builder} avoiding the need to create one manually via
         * {@link AwsS3BucketNotificationConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsS3BucketNotificationConfiguration.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #bucketNotificationConfiguration(AwsS3BucketNotificationConfiguration)}.
         * 
         * @param bucketNotificationConfiguration
         *        a consumer that will call methods on {@link AwsS3BucketNotificationConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #bucketNotificationConfiguration(AwsS3BucketNotificationConfiguration)
         */
        default Builder bucketNotificationConfiguration(
                Consumer<AwsS3BucketNotificationConfiguration.Builder> bucketNotificationConfiguration) {
            return bucketNotificationConfiguration(AwsS3BucketNotificationConfiguration.builder()
                    .applyMutation(bucketNotificationConfiguration).build());
        }

        /**
         * <p>
         * The versioning state of an S3 bucket.
         * </p>
         * 
         * @param bucketVersioningConfiguration
         *        The versioning state of an S3 bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bucketVersioningConfiguration(AwsS3BucketBucketVersioningConfiguration bucketVersioningConfiguration);

        /**
         * <p>
         * The versioning state of an S3 bucket.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AwsS3BucketBucketVersioningConfiguration.Builder} avoiding the need to create one manually via
         * {@link AwsS3BucketBucketVersioningConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsS3BucketBucketVersioningConfiguration.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #bucketVersioningConfiguration(AwsS3BucketBucketVersioningConfiguration)}.
         * 
         * @param bucketVersioningConfiguration
         *        a consumer that will call methods on {@link AwsS3BucketBucketVersioningConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #bucketVersioningConfiguration(AwsS3BucketBucketVersioningConfiguration)
         */
        default Builder bucketVersioningConfiguration(
                Consumer<AwsS3BucketBucketVersioningConfiguration.Builder> bucketVersioningConfiguration) {
            return bucketVersioningConfiguration(AwsS3BucketBucketVersioningConfiguration.builder()
                    .applyMutation(bucketVersioningConfiguration).build());
        }

        /**
         * <p>
         * Specifies which rule Amazon S3 applies by default to every new object placed in the bucket.
         * </p>
         * 
         * @param objectLockConfiguration
         *        Specifies which rule Amazon S3 applies by default to every new object placed in the bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder objectLockConfiguration(AwsS3BucketObjectLockConfiguration objectLockConfiguration);

        /**
         * <p>
         * Specifies which rule Amazon S3 applies by default to every new object placed in the bucket.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AwsS3BucketObjectLockConfiguration.Builder} avoiding the need to create one manually via
         * {@link AwsS3BucketObjectLockConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsS3BucketObjectLockConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #objectLockConfiguration(AwsS3BucketObjectLockConfiguration)}.
         * 
         * @param objectLockConfiguration
         *        a consumer that will call methods on {@link AwsS3BucketObjectLockConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #objectLockConfiguration(AwsS3BucketObjectLockConfiguration)
         */
        default Builder objectLockConfiguration(Consumer<AwsS3BucketObjectLockConfiguration.Builder> objectLockConfiguration) {
            return objectLockConfiguration(AwsS3BucketObjectLockConfiguration.builder().applyMutation(objectLockConfiguration)
                    .build());
        }

        /**
         * <p>
         * The name of the bucket.
         * </p>
         * 
         * @param name
         *        The name of the bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);
    }

    static final class BuilderImpl implements Builder {
        private String ownerId;

        private String ownerName;

        private String ownerAccountId;

        private String createdAt;

        private AwsS3BucketServerSideEncryptionConfiguration serverSideEncryptionConfiguration;

        private AwsS3BucketBucketLifecycleConfigurationDetails bucketLifecycleConfiguration;

        private AwsS3AccountPublicAccessBlockDetails publicAccessBlockConfiguration;

        private String accessControlList;

        private AwsS3BucketLoggingConfiguration bucketLoggingConfiguration;

        private AwsS3BucketWebsiteConfiguration bucketWebsiteConfiguration;

        private AwsS3BucketNotificationConfiguration bucketNotificationConfiguration;

        private AwsS3BucketBucketVersioningConfiguration bucketVersioningConfiguration;

        private AwsS3BucketObjectLockConfiguration objectLockConfiguration;

        private String name;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsS3BucketDetails model) {
            ownerId(model.ownerId);
            ownerName(model.ownerName);
            ownerAccountId(model.ownerAccountId);
            createdAt(model.createdAt);
            serverSideEncryptionConfiguration(model.serverSideEncryptionConfiguration);
            bucketLifecycleConfiguration(model.bucketLifecycleConfiguration);
            publicAccessBlockConfiguration(model.publicAccessBlockConfiguration);
            accessControlList(model.accessControlList);
            bucketLoggingConfiguration(model.bucketLoggingConfiguration);
            bucketWebsiteConfiguration(model.bucketWebsiteConfiguration);
            bucketNotificationConfiguration(model.bucketNotificationConfiguration);
            bucketVersioningConfiguration(model.bucketVersioningConfiguration);
            objectLockConfiguration(model.objectLockConfiguration);
            name(model.name);
        }

        public final String getOwnerId() {
            return ownerId;
        }

        public final void setOwnerId(String ownerId) {
            this.ownerId = ownerId;
        }

        @Override
        public final Builder ownerId(String ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        public final String getOwnerName() {
            return ownerName;
        }

        public final void setOwnerName(String ownerName) {
            this.ownerName = ownerName;
        }

        @Override
        public final Builder ownerName(String ownerName) {
            this.ownerName = ownerName;
            return this;
        }

        public final String getOwnerAccountId() {
            return ownerAccountId;
        }

        public final void setOwnerAccountId(String ownerAccountId) {
            this.ownerAccountId = ownerAccountId;
        }

        @Override
        public final Builder ownerAccountId(String ownerAccountId) {
            this.ownerAccountId = ownerAccountId;
            return this;
        }

        public final String getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(String createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(String createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final AwsS3BucketServerSideEncryptionConfiguration.Builder getServerSideEncryptionConfiguration() {
            return serverSideEncryptionConfiguration != null ? serverSideEncryptionConfiguration.toBuilder() : null;
        }

        public final void setServerSideEncryptionConfiguration(
                AwsS3BucketServerSideEncryptionConfiguration.BuilderImpl serverSideEncryptionConfiguration) {
            this.serverSideEncryptionConfiguration = serverSideEncryptionConfiguration != null ? serverSideEncryptionConfiguration
                    .build() : null;
        }

        @Override
        public final Builder serverSideEncryptionConfiguration(
                AwsS3BucketServerSideEncryptionConfiguration serverSideEncryptionConfiguration) {
            this.serverSideEncryptionConfiguration = serverSideEncryptionConfiguration;
            return this;
        }

        public final AwsS3BucketBucketLifecycleConfigurationDetails.Builder getBucketLifecycleConfiguration() {
            return bucketLifecycleConfiguration != null ? bucketLifecycleConfiguration.toBuilder() : null;
        }

        public final void setBucketLifecycleConfiguration(
                AwsS3BucketBucketLifecycleConfigurationDetails.BuilderImpl bucketLifecycleConfiguration) {
            this.bucketLifecycleConfiguration = bucketLifecycleConfiguration != null ? bucketLifecycleConfiguration.build()
                    : null;
        }

        @Override
        public final Builder bucketLifecycleConfiguration(
                AwsS3BucketBucketLifecycleConfigurationDetails bucketLifecycleConfiguration) {
            this.bucketLifecycleConfiguration = bucketLifecycleConfiguration;
            return this;
        }

        public final AwsS3AccountPublicAccessBlockDetails.Builder getPublicAccessBlockConfiguration() {
            return publicAccessBlockConfiguration != null ? publicAccessBlockConfiguration.toBuilder() : null;
        }

        public final void setPublicAccessBlockConfiguration(
                AwsS3AccountPublicAccessBlockDetails.BuilderImpl publicAccessBlockConfiguration) {
            this.publicAccessBlockConfiguration = publicAccessBlockConfiguration != null ? publicAccessBlockConfiguration.build()
                    : null;
        }

        @Override
        public final Builder publicAccessBlockConfiguration(AwsS3AccountPublicAccessBlockDetails publicAccessBlockConfiguration) {
            this.publicAccessBlockConfiguration = publicAccessBlockConfiguration;
            return this;
        }

        public final String getAccessControlList() {
            return accessControlList;
        }

        public final void setAccessControlList(String accessControlList) {
            this.accessControlList = accessControlList;
        }

        @Override
        public final Builder accessControlList(String accessControlList) {
            this.accessControlList = accessControlList;
            return this;
        }

        public final AwsS3BucketLoggingConfiguration.Builder getBucketLoggingConfiguration() {
            return bucketLoggingConfiguration != null ? bucketLoggingConfiguration.toBuilder() : null;
        }

        public final void setBucketLoggingConfiguration(AwsS3BucketLoggingConfiguration.BuilderImpl bucketLoggingConfiguration) {
            this.bucketLoggingConfiguration = bucketLoggingConfiguration != null ? bucketLoggingConfiguration.build() : null;
        }

        @Override
        public final Builder bucketLoggingConfiguration(AwsS3BucketLoggingConfiguration bucketLoggingConfiguration) {
            this.bucketLoggingConfiguration = bucketLoggingConfiguration;
            return this;
        }

        public final AwsS3BucketWebsiteConfiguration.Builder getBucketWebsiteConfiguration() {
            return bucketWebsiteConfiguration != null ? bucketWebsiteConfiguration.toBuilder() : null;
        }

        public final void setBucketWebsiteConfiguration(AwsS3BucketWebsiteConfiguration.BuilderImpl bucketWebsiteConfiguration) {
            this.bucketWebsiteConfiguration = bucketWebsiteConfiguration != null ? bucketWebsiteConfiguration.build() : null;
        }

        @Override
        public final Builder bucketWebsiteConfiguration(AwsS3BucketWebsiteConfiguration bucketWebsiteConfiguration) {
            this.bucketWebsiteConfiguration = bucketWebsiteConfiguration;
            return this;
        }

        public final AwsS3BucketNotificationConfiguration.Builder getBucketNotificationConfiguration() {
            return bucketNotificationConfiguration != null ? bucketNotificationConfiguration.toBuilder() : null;
        }

        public final void setBucketNotificationConfiguration(
                AwsS3BucketNotificationConfiguration.BuilderImpl bucketNotificationConfiguration) {
            this.bucketNotificationConfiguration = bucketNotificationConfiguration != null ? bucketNotificationConfiguration
                    .build() : null;
        }

        @Override
        public final Builder bucketNotificationConfiguration(AwsS3BucketNotificationConfiguration bucketNotificationConfiguration) {
            this.bucketNotificationConfiguration = bucketNotificationConfiguration;
            return this;
        }

        public final AwsS3BucketBucketVersioningConfiguration.Builder getBucketVersioningConfiguration() {
            return bucketVersioningConfiguration != null ? bucketVersioningConfiguration.toBuilder() : null;
        }

        public final void setBucketVersioningConfiguration(
                AwsS3BucketBucketVersioningConfiguration.BuilderImpl bucketVersioningConfiguration) {
            this.bucketVersioningConfiguration = bucketVersioningConfiguration != null ? bucketVersioningConfiguration.build()
                    : null;
        }

        @Override
        public final Builder bucketVersioningConfiguration(AwsS3BucketBucketVersioningConfiguration bucketVersioningConfiguration) {
            this.bucketVersioningConfiguration = bucketVersioningConfiguration;
            return this;
        }

        public final AwsS3BucketObjectLockConfiguration.Builder getObjectLockConfiguration() {
            return objectLockConfiguration != null ? objectLockConfiguration.toBuilder() : null;
        }

        public final void setObjectLockConfiguration(AwsS3BucketObjectLockConfiguration.BuilderImpl objectLockConfiguration) {
            this.objectLockConfiguration = objectLockConfiguration != null ? objectLockConfiguration.build() : null;
        }

        @Override
        public final Builder objectLockConfiguration(AwsS3BucketObjectLockConfiguration objectLockConfiguration) {
            this.objectLockConfiguration = objectLockConfiguration;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public AwsS3BucketDetails build() {
            return new AwsS3BucketDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
