/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListConfigurationPoliciesResponse extends SecurityHubResponse implements
        ToCopyableBuilder<ListConfigurationPoliciesResponse.Builder, ListConfigurationPoliciesResponse> {
    private static final SdkField<List<ConfigurationPolicySummary>> CONFIGURATION_POLICY_SUMMARIES_FIELD = SdkField
            .<List<ConfigurationPolicySummary>> builder(MarshallingType.LIST)
            .memberName("ConfigurationPolicySummaries")
            .getter(getter(ListConfigurationPoliciesResponse::configurationPolicySummaries))
            .setter(setter(Builder::configurationPolicySummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationPolicySummaries")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ConfigurationPolicySummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(ConfigurationPolicySummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListConfigurationPoliciesResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CONFIGURATION_POLICY_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));

    private final List<ConfigurationPolicySummary> configurationPolicySummaries;

    private final String nextToken;

    private ListConfigurationPoliciesResponse(BuilderImpl builder) {
        super(builder);
        this.configurationPolicySummaries = builder.configurationPolicySummaries;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the ConfigurationPolicySummaries property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasConfigurationPolicySummaries() {
        return configurationPolicySummaries != null && !(configurationPolicySummaries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Provides metadata for each of your configuration policies.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasConfigurationPolicySummaries} method.
     * </p>
     * 
     * @return Provides metadata for each of your configuration policies.
     */
    public final List<ConfigurationPolicySummary> configurationPolicySummaries() {
        return configurationPolicySummaries;
    }

    /**
     * <p>
     * The <code>NextToken</code> value to include in the next <code>ListConfigurationPolicies</code> request. When the
     * results of a <code>ListConfigurationPolicies</code> request exceed <code>MaxResults</code>, this value can be
     * used to retrieve the next page of results. This value is <code>null</code> when there are no more results to
     * return.
     * </p>
     * 
     * @return The <code>NextToken</code> value to include in the next <code>ListConfigurationPolicies</code> request.
     *         When the results of a <code>ListConfigurationPolicies</code> request exceed <code>MaxResults</code>, this
     *         value can be used to retrieve the next page of results. This value is <code>null</code> when there are no
     *         more results to return.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasConfigurationPolicySummaries() ? configurationPolicySummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListConfigurationPoliciesResponse)) {
            return false;
        }
        ListConfigurationPoliciesResponse other = (ListConfigurationPoliciesResponse) obj;
        return hasConfigurationPolicySummaries() == other.hasConfigurationPolicySummaries()
                && Objects.equals(configurationPolicySummaries(), other.configurationPolicySummaries())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListConfigurationPoliciesResponse")
                .add("ConfigurationPolicySummaries", hasConfigurationPolicySummaries() ? configurationPolicySummaries() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConfigurationPolicySummaries":
            return Optional.ofNullable(clazz.cast(configurationPolicySummaries()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListConfigurationPoliciesResponse, T> g) {
        return obj -> g.apply((ListConfigurationPoliciesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SecurityHubResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListConfigurationPoliciesResponse> {
        /**
         * <p>
         * Provides metadata for each of your configuration policies.
         * </p>
         * 
         * @param configurationPolicySummaries
         *        Provides metadata for each of your configuration policies.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationPolicySummaries(Collection<ConfigurationPolicySummary> configurationPolicySummaries);

        /**
         * <p>
         * Provides metadata for each of your configuration policies.
         * </p>
         * 
         * @param configurationPolicySummaries
         *        Provides metadata for each of your configuration policies.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationPolicySummaries(ConfigurationPolicySummary... configurationPolicySummaries);

        /**
         * <p>
         * Provides metadata for each of your configuration policies.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityhub.model.ConfigurationPolicySummary.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.securityhub.model.ConfigurationPolicySummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityhub.model.ConfigurationPolicySummary.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #configurationPolicySummaries(List<ConfigurationPolicySummary>)}.
         * 
         * @param configurationPolicySummaries
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityhub.model.ConfigurationPolicySummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #configurationPolicySummaries(java.util.Collection<ConfigurationPolicySummary>)
         */
        Builder configurationPolicySummaries(Consumer<ConfigurationPolicySummary.Builder>... configurationPolicySummaries);

        /**
         * <p>
         * The <code>NextToken</code> value to include in the next <code>ListConfigurationPolicies</code> request. When
         * the results of a <code>ListConfigurationPolicies</code> request exceed <code>MaxResults</code>, this value
         * can be used to retrieve the next page of results. This value is <code>null</code> when there are no more
         * results to return.
         * </p>
         * 
         * @param nextToken
         *        The <code>NextToken</code> value to include in the next <code>ListConfigurationPolicies</code>
         *        request. When the results of a <code>ListConfigurationPolicies</code> request exceed
         *        <code>MaxResults</code>, this value can be used to retrieve the next page of results. This value is
         *        <code>null</code> when there are no more results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends SecurityHubResponse.BuilderImpl implements Builder {
        private List<ConfigurationPolicySummary> configurationPolicySummaries = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListConfigurationPoliciesResponse model) {
            super(model);
            configurationPolicySummaries(model.configurationPolicySummaries);
            nextToken(model.nextToken);
        }

        public final List<ConfigurationPolicySummary.Builder> getConfigurationPolicySummaries() {
            List<ConfigurationPolicySummary.Builder> result = ConfigurationPolicySummaryListCopier
                    .copyToBuilder(this.configurationPolicySummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setConfigurationPolicySummaries(
                Collection<ConfigurationPolicySummary.BuilderImpl> configurationPolicySummaries) {
            this.configurationPolicySummaries = ConfigurationPolicySummaryListCopier
                    .copyFromBuilder(configurationPolicySummaries);
        }

        @Override
        public final Builder configurationPolicySummaries(Collection<ConfigurationPolicySummary> configurationPolicySummaries) {
            this.configurationPolicySummaries = ConfigurationPolicySummaryListCopier.copy(configurationPolicySummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configurationPolicySummaries(ConfigurationPolicySummary... configurationPolicySummaries) {
            configurationPolicySummaries(Arrays.asList(configurationPolicySummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configurationPolicySummaries(
                Consumer<ConfigurationPolicySummary.Builder>... configurationPolicySummaries) {
            configurationPolicySummaries(Stream.of(configurationPolicySummaries)
                    .map(c -> ConfigurationPolicySummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListConfigurationPoliciesResponse build() {
            return new ListConfigurationPoliciesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
