/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListConfigurationPolicyAssociationsResponse extends SecurityHubResponse implements
        ToCopyableBuilder<ListConfigurationPolicyAssociationsResponse.Builder, ListConfigurationPolicyAssociationsResponse> {
    private static final SdkField<List<ConfigurationPolicyAssociationSummary>> CONFIGURATION_POLICY_ASSOCIATION_SUMMARIES_FIELD = SdkField
            .<List<ConfigurationPolicyAssociationSummary>> builder(MarshallingType.LIST)
            .memberName("ConfigurationPolicyAssociationSummaries")
            .getter(getter(ListConfigurationPolicyAssociationsResponse::configurationPolicyAssociationSummaries))
            .setter(setter(Builder::configurationPolicyAssociationSummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("ConfigurationPolicyAssociationSummaries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ConfigurationPolicyAssociationSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(ConfigurationPolicyAssociationSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListConfigurationPolicyAssociationsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CONFIGURATION_POLICY_ASSOCIATION_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));

    private final List<ConfigurationPolicyAssociationSummary> configurationPolicyAssociationSummaries;

    private final String nextToken;

    private ListConfigurationPolicyAssociationsResponse(BuilderImpl builder) {
        super(builder);
        this.configurationPolicyAssociationSummaries = builder.configurationPolicyAssociationSummaries;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the ConfigurationPolicyAssociationSummaries
     * property. This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()}
     * method on the property). This is useful because the SDK will never return a null collection or map, but you may
     * need to differentiate between the service returning nothing (or null) and the service returning an empty
     * collection or map. For requests, this returns true if a value for the property was specified in the request
     * builder, and false if a value was not specified.
     */
    public final boolean hasConfigurationPolicyAssociationSummaries() {
        return configurationPolicyAssociationSummaries != null
                && !(configurationPolicyAssociationSummaries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An object that contains the details of each configuration policy association that’s returned in a
     * <code>ListConfigurationPolicyAssociations</code> request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the
     * {@link #hasConfigurationPolicyAssociationSummaries} method.
     * </p>
     * 
     * @return An object that contains the details of each configuration policy association that’s returned in a
     *         <code>ListConfigurationPolicyAssociations</code> request.
     */
    public final List<ConfigurationPolicyAssociationSummary> configurationPolicyAssociationSummaries() {
        return configurationPolicyAssociationSummaries;
    }

    /**
     * <p>
     * The <code>NextToken</code> value to include in the next <code>ListConfigurationPolicyAssociations</code> request.
     * When the results of a <code>ListConfigurationPolicyAssociations</code> request exceed <code>MaxResults</code>,
     * this value can be used to retrieve the next page of results. This value is <code>null</code> when there are no
     * more results to return.
     * </p>
     * 
     * @return The <code>NextToken</code> value to include in the next <code>ListConfigurationPolicyAssociations</code>
     *         request. When the results of a <code>ListConfigurationPolicyAssociations</code> request exceed
     *         <code>MaxResults</code>, this value can be used to retrieve the next page of results. This value is
     *         <code>null</code> when there are no more results to return.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31
                * hashCode
                + Objects.hashCode(hasConfigurationPolicyAssociationSummaries() ? configurationPolicyAssociationSummaries()
                        : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListConfigurationPolicyAssociationsResponse)) {
            return false;
        }
        ListConfigurationPolicyAssociationsResponse other = (ListConfigurationPolicyAssociationsResponse) obj;
        return hasConfigurationPolicyAssociationSummaries() == other.hasConfigurationPolicyAssociationSummaries()
                && Objects.equals(configurationPolicyAssociationSummaries(), other.configurationPolicyAssociationSummaries())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("ListConfigurationPolicyAssociationsResponse")
                .add("ConfigurationPolicyAssociationSummaries",
                        hasConfigurationPolicyAssociationSummaries() ? configurationPolicyAssociationSummaries() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConfigurationPolicyAssociationSummaries":
            return Optional.ofNullable(clazz.cast(configurationPolicyAssociationSummaries()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListConfigurationPolicyAssociationsResponse, T> g) {
        return obj -> g.apply((ListConfigurationPolicyAssociationsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SecurityHubResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListConfigurationPolicyAssociationsResponse> {
        /**
         * <p>
         * An object that contains the details of each configuration policy association that’s returned in a
         * <code>ListConfigurationPolicyAssociations</code> request.
         * </p>
         * 
         * @param configurationPolicyAssociationSummaries
         *        An object that contains the details of each configuration policy association that’s returned in a
         *        <code>ListConfigurationPolicyAssociations</code> request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationPolicyAssociationSummaries(
                Collection<ConfigurationPolicyAssociationSummary> configurationPolicyAssociationSummaries);

        /**
         * <p>
         * An object that contains the details of each configuration policy association that’s returned in a
         * <code>ListConfigurationPolicyAssociations</code> request.
         * </p>
         * 
         * @param configurationPolicyAssociationSummaries
         *        An object that contains the details of each configuration policy association that’s returned in a
         *        <code>ListConfigurationPolicyAssociations</code> request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationPolicyAssociationSummaries(
                ConfigurationPolicyAssociationSummary... configurationPolicyAssociationSummaries);

        /**
         * <p>
         * An object that contains the details of each configuration policy association that’s returned in a
         * <code>ListConfigurationPolicyAssociations</code> request.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityhub.model.ConfigurationPolicyAssociationSummary.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.securityhub.model.ConfigurationPolicyAssociationSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityhub.model.ConfigurationPolicyAssociationSummary.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #configurationPolicyAssociationSummaries(List<ConfigurationPolicyAssociationSummary>)}.
         * 
         * @param configurationPolicyAssociationSummaries
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityhub.model.ConfigurationPolicyAssociationSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #configurationPolicyAssociationSummaries(java.util.Collection<ConfigurationPolicyAssociationSummary>)
         */
        Builder configurationPolicyAssociationSummaries(
                Consumer<ConfigurationPolicyAssociationSummary.Builder>... configurationPolicyAssociationSummaries);

        /**
         * <p>
         * The <code>NextToken</code> value to include in the next <code>ListConfigurationPolicyAssociations</code>
         * request. When the results of a <code>ListConfigurationPolicyAssociations</code> request exceed
         * <code>MaxResults</code>, this value can be used to retrieve the next page of results. This value is
         * <code>null</code> when there are no more results to return.
         * </p>
         * 
         * @param nextToken
         *        The <code>NextToken</code> value to include in the next
         *        <code>ListConfigurationPolicyAssociations</code> request. When the results of a
         *        <code>ListConfigurationPolicyAssociations</code> request exceed <code>MaxResults</code>, this value
         *        can be used to retrieve the next page of results. This value is <code>null</code> when there are no
         *        more results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends SecurityHubResponse.BuilderImpl implements Builder {
        private List<ConfigurationPolicyAssociationSummary> configurationPolicyAssociationSummaries = DefaultSdkAutoConstructList
                .getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListConfigurationPolicyAssociationsResponse model) {
            super(model);
            configurationPolicyAssociationSummaries(model.configurationPolicyAssociationSummaries);
            nextToken(model.nextToken);
        }

        public final List<ConfigurationPolicyAssociationSummary.Builder> getConfigurationPolicyAssociationSummaries() {
            List<ConfigurationPolicyAssociationSummary.Builder> result = ConfigurationPolicyAssociationSummaryListCopier
                    .copyToBuilder(this.configurationPolicyAssociationSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setConfigurationPolicyAssociationSummaries(
                Collection<ConfigurationPolicyAssociationSummary.BuilderImpl> configurationPolicyAssociationSummaries) {
            this.configurationPolicyAssociationSummaries = ConfigurationPolicyAssociationSummaryListCopier
                    .copyFromBuilder(configurationPolicyAssociationSummaries);
        }

        @Override
        public final Builder configurationPolicyAssociationSummaries(
                Collection<ConfigurationPolicyAssociationSummary> configurationPolicyAssociationSummaries) {
            this.configurationPolicyAssociationSummaries = ConfigurationPolicyAssociationSummaryListCopier
                    .copy(configurationPolicyAssociationSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configurationPolicyAssociationSummaries(
                ConfigurationPolicyAssociationSummary... configurationPolicyAssociationSummaries) {
            configurationPolicyAssociationSummaries(Arrays.asList(configurationPolicyAssociationSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configurationPolicyAssociationSummaries(
                Consumer<ConfigurationPolicyAssociationSummary.Builder>... configurationPolicyAssociationSummaries) {
            configurationPolicyAssociationSummaries(Stream.of(configurationPolicyAssociationSummaries)
                    .map(c -> ConfigurationPolicyAssociationSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListConfigurationPolicyAssociationsResponse build() {
            return new ListConfigurationPolicyAssociationsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
