/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provided if <code>ActionType</code> is <code>NETWORK_CONNECTION</code>. It provides details about the attempted
 * network connection that was detected.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class NetworkConnectionAction implements SdkPojo, Serializable,
        ToCopyableBuilder<NetworkConnectionAction.Builder, NetworkConnectionAction> {
    private static final SdkField<String> CONNECTION_DIRECTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConnectionDirection").getter(getter(NetworkConnectionAction::connectionDirection))
            .setter(setter(Builder::connectionDirection))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionDirection").build())
            .build();

    private static final SdkField<ActionRemoteIpDetails> REMOTE_IP_DETAILS_FIELD = SdkField
            .<ActionRemoteIpDetails> builder(MarshallingType.SDK_POJO).memberName("RemoteIpDetails")
            .getter(getter(NetworkConnectionAction::remoteIpDetails)).setter(setter(Builder::remoteIpDetails))
            .constructor(ActionRemoteIpDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RemoteIpDetails").build()).build();

    private static final SdkField<ActionRemotePortDetails> REMOTE_PORT_DETAILS_FIELD = SdkField
            .<ActionRemotePortDetails> builder(MarshallingType.SDK_POJO).memberName("RemotePortDetails")
            .getter(getter(NetworkConnectionAction::remotePortDetails)).setter(setter(Builder::remotePortDetails))
            .constructor(ActionRemotePortDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RemotePortDetails").build()).build();

    private static final SdkField<ActionLocalPortDetails> LOCAL_PORT_DETAILS_FIELD = SdkField
            .<ActionLocalPortDetails> builder(MarshallingType.SDK_POJO).memberName("LocalPortDetails")
            .getter(getter(NetworkConnectionAction::localPortDetails)).setter(setter(Builder::localPortDetails))
            .constructor(ActionLocalPortDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocalPortDetails").build()).build();

    private static final SdkField<String> PROTOCOL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Protocol").getter(getter(NetworkConnectionAction::protocol)).setter(setter(Builder::protocol))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Protocol").build()).build();

    private static final SdkField<Boolean> BLOCKED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Blocked").getter(getter(NetworkConnectionAction::blocked)).setter(setter(Builder::blocked))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Blocked").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECTION_DIRECTION_FIELD,
            REMOTE_IP_DETAILS_FIELD, REMOTE_PORT_DETAILS_FIELD, LOCAL_PORT_DETAILS_FIELD, PROTOCOL_FIELD, BLOCKED_FIELD));

    private static final long serialVersionUID = 1L;

    private final String connectionDirection;

    private final ActionRemoteIpDetails remoteIpDetails;

    private final ActionRemotePortDetails remotePortDetails;

    private final ActionLocalPortDetails localPortDetails;

    private final String protocol;

    private final Boolean blocked;

    private NetworkConnectionAction(BuilderImpl builder) {
        this.connectionDirection = builder.connectionDirection;
        this.remoteIpDetails = builder.remoteIpDetails;
        this.remotePortDetails = builder.remotePortDetails;
        this.localPortDetails = builder.localPortDetails;
        this.protocol = builder.protocol;
        this.blocked = builder.blocked;
    }

    /**
     * <p>
     * The direction of the network connection request (<code>IN</code> or <code>OUT</code>).
     * </p>
     * 
     * @return The direction of the network connection request (<code>IN</code> or <code>OUT</code>).
     */
    public final String connectionDirection() {
        return connectionDirection;
    }

    /**
     * <p>
     * Information about the remote IP address that issued the network connection request.
     * </p>
     * 
     * @return Information about the remote IP address that issued the network connection request.
     */
    public final ActionRemoteIpDetails remoteIpDetails() {
        return remoteIpDetails;
    }

    /**
     * <p>
     * Information about the port on the remote IP address.
     * </p>
     * 
     * @return Information about the port on the remote IP address.
     */
    public final ActionRemotePortDetails remotePortDetails() {
        return remotePortDetails;
    }

    /**
     * <p>
     * Information about the port on the EC2 instance.
     * </p>
     * 
     * @return Information about the port on the EC2 instance.
     */
    public final ActionLocalPortDetails localPortDetails() {
        return localPortDetails;
    }

    /**
     * <p>
     * The protocol used to make the network connection request.
     * </p>
     * 
     * @return The protocol used to make the network connection request.
     */
    public final String protocol() {
        return protocol;
    }

    /**
     * <p>
     * Indicates whether the network connection attempt was blocked.
     * </p>
     * 
     * @return Indicates whether the network connection attempt was blocked.
     */
    public final Boolean blocked() {
        return blocked;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(connectionDirection());
        hashCode = 31 * hashCode + Objects.hashCode(remoteIpDetails());
        hashCode = 31 * hashCode + Objects.hashCode(remotePortDetails());
        hashCode = 31 * hashCode + Objects.hashCode(localPortDetails());
        hashCode = 31 * hashCode + Objects.hashCode(protocol());
        hashCode = 31 * hashCode + Objects.hashCode(blocked());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NetworkConnectionAction)) {
            return false;
        }
        NetworkConnectionAction other = (NetworkConnectionAction) obj;
        return Objects.equals(connectionDirection(), other.connectionDirection())
                && Objects.equals(remoteIpDetails(), other.remoteIpDetails())
                && Objects.equals(remotePortDetails(), other.remotePortDetails())
                && Objects.equals(localPortDetails(), other.localPortDetails()) && Objects.equals(protocol(), other.protocol())
                && Objects.equals(blocked(), other.blocked());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("NetworkConnectionAction").add("ConnectionDirection", connectionDirection())
                .add("RemoteIpDetails", remoteIpDetails()).add("RemotePortDetails", remotePortDetails())
                .add("LocalPortDetails", localPortDetails()).add("Protocol", protocol()).add("Blocked", blocked()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConnectionDirection":
            return Optional.ofNullable(clazz.cast(connectionDirection()));
        case "RemoteIpDetails":
            return Optional.ofNullable(clazz.cast(remoteIpDetails()));
        case "RemotePortDetails":
            return Optional.ofNullable(clazz.cast(remotePortDetails()));
        case "LocalPortDetails":
            return Optional.ofNullable(clazz.cast(localPortDetails()));
        case "Protocol":
            return Optional.ofNullable(clazz.cast(protocol()));
        case "Blocked":
            return Optional.ofNullable(clazz.cast(blocked()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<NetworkConnectionAction, T> g) {
        return obj -> g.apply((NetworkConnectionAction) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NetworkConnectionAction> {
        /**
         * <p>
         * The direction of the network connection request (<code>IN</code> or <code>OUT</code>).
         * </p>
         * 
         * @param connectionDirection
         *        The direction of the network connection request (<code>IN</code> or <code>OUT</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectionDirection(String connectionDirection);

        /**
         * <p>
         * Information about the remote IP address that issued the network connection request.
         * </p>
         * 
         * @param remoteIpDetails
         *        Information about the remote IP address that issued the network connection request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder remoteIpDetails(ActionRemoteIpDetails remoteIpDetails);

        /**
         * <p>
         * Information about the remote IP address that issued the network connection request.
         * </p>
         * This is a convenience method that creates an instance of the {@link ActionRemoteIpDetails.Builder} avoiding
         * the need to create one manually via {@link ActionRemoteIpDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ActionRemoteIpDetails.Builder#build()} is called immediately and
         * its result is passed to {@link #remoteIpDetails(ActionRemoteIpDetails)}.
         * 
         * @param remoteIpDetails
         *        a consumer that will call methods on {@link ActionRemoteIpDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #remoteIpDetails(ActionRemoteIpDetails)
         */
        default Builder remoteIpDetails(Consumer<ActionRemoteIpDetails.Builder> remoteIpDetails) {
            return remoteIpDetails(ActionRemoteIpDetails.builder().applyMutation(remoteIpDetails).build());
        }

        /**
         * <p>
         * Information about the port on the remote IP address.
         * </p>
         * 
         * @param remotePortDetails
         *        Information about the port on the remote IP address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder remotePortDetails(ActionRemotePortDetails remotePortDetails);

        /**
         * <p>
         * Information about the port on the remote IP address.
         * </p>
         * This is a convenience method that creates an instance of the {@link ActionRemotePortDetails.Builder} avoiding
         * the need to create one manually via {@link ActionRemotePortDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ActionRemotePortDetails.Builder#build()} is called immediately
         * and its result is passed to {@link #remotePortDetails(ActionRemotePortDetails)}.
         * 
         * @param remotePortDetails
         *        a consumer that will call methods on {@link ActionRemotePortDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #remotePortDetails(ActionRemotePortDetails)
         */
        default Builder remotePortDetails(Consumer<ActionRemotePortDetails.Builder> remotePortDetails) {
            return remotePortDetails(ActionRemotePortDetails.builder().applyMutation(remotePortDetails).build());
        }

        /**
         * <p>
         * Information about the port on the EC2 instance.
         * </p>
         * 
         * @param localPortDetails
         *        Information about the port on the EC2 instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder localPortDetails(ActionLocalPortDetails localPortDetails);

        /**
         * <p>
         * Information about the port on the EC2 instance.
         * </p>
         * This is a convenience method that creates an instance of the {@link ActionLocalPortDetails.Builder} avoiding
         * the need to create one manually via {@link ActionLocalPortDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ActionLocalPortDetails.Builder#build()} is called immediately and
         * its result is passed to {@link #localPortDetails(ActionLocalPortDetails)}.
         * 
         * @param localPortDetails
         *        a consumer that will call methods on {@link ActionLocalPortDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #localPortDetails(ActionLocalPortDetails)
         */
        default Builder localPortDetails(Consumer<ActionLocalPortDetails.Builder> localPortDetails) {
            return localPortDetails(ActionLocalPortDetails.builder().applyMutation(localPortDetails).build());
        }

        /**
         * <p>
         * The protocol used to make the network connection request.
         * </p>
         * 
         * @param protocol
         *        The protocol used to make the network connection request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder protocol(String protocol);

        /**
         * <p>
         * Indicates whether the network connection attempt was blocked.
         * </p>
         * 
         * @param blocked
         *        Indicates whether the network connection attempt was blocked.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blocked(Boolean blocked);
    }

    static final class BuilderImpl implements Builder {
        private String connectionDirection;

        private ActionRemoteIpDetails remoteIpDetails;

        private ActionRemotePortDetails remotePortDetails;

        private ActionLocalPortDetails localPortDetails;

        private String protocol;

        private Boolean blocked;

        private BuilderImpl() {
        }

        private BuilderImpl(NetworkConnectionAction model) {
            connectionDirection(model.connectionDirection);
            remoteIpDetails(model.remoteIpDetails);
            remotePortDetails(model.remotePortDetails);
            localPortDetails(model.localPortDetails);
            protocol(model.protocol);
            blocked(model.blocked);
        }

        public final String getConnectionDirection() {
            return connectionDirection;
        }

        public final void setConnectionDirection(String connectionDirection) {
            this.connectionDirection = connectionDirection;
        }

        @Override
        public final Builder connectionDirection(String connectionDirection) {
            this.connectionDirection = connectionDirection;
            return this;
        }

        public final ActionRemoteIpDetails.Builder getRemoteIpDetails() {
            return remoteIpDetails != null ? remoteIpDetails.toBuilder() : null;
        }

        public final void setRemoteIpDetails(ActionRemoteIpDetails.BuilderImpl remoteIpDetails) {
            this.remoteIpDetails = remoteIpDetails != null ? remoteIpDetails.build() : null;
        }

        @Override
        public final Builder remoteIpDetails(ActionRemoteIpDetails remoteIpDetails) {
            this.remoteIpDetails = remoteIpDetails;
            return this;
        }

        public final ActionRemotePortDetails.Builder getRemotePortDetails() {
            return remotePortDetails != null ? remotePortDetails.toBuilder() : null;
        }

        public final void setRemotePortDetails(ActionRemotePortDetails.BuilderImpl remotePortDetails) {
            this.remotePortDetails = remotePortDetails != null ? remotePortDetails.build() : null;
        }

        @Override
        public final Builder remotePortDetails(ActionRemotePortDetails remotePortDetails) {
            this.remotePortDetails = remotePortDetails;
            return this;
        }

        public final ActionLocalPortDetails.Builder getLocalPortDetails() {
            return localPortDetails != null ? localPortDetails.toBuilder() : null;
        }

        public final void setLocalPortDetails(ActionLocalPortDetails.BuilderImpl localPortDetails) {
            this.localPortDetails = localPortDetails != null ? localPortDetails.build() : null;
        }

        @Override
        public final Builder localPortDetails(ActionLocalPortDetails localPortDetails) {
            this.localPortDetails = localPortDetails;
            return this;
        }

        public final String getProtocol() {
            return protocol;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        @Override
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        public final Boolean getBlocked() {
            return blocked;
        }

        public final void setBlocked(Boolean blocked) {
            this.blocked = blocked;
        }

        @Override
        public final Builder blocked(Boolean blocked) {
            this.blocked = blocked;
            return this;
        }

        @Override
        public NetworkConnectionAction build() {
            return new NetworkConnectionAction(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
