/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that provides the current value of a security control parameter and identifies whether it has been
 * customized.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ParameterConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<ParameterConfiguration.Builder, ParameterConfiguration> {
    private static final SdkField<String> VALUE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ValueType").getter(getter(ParameterConfiguration::valueTypeAsString)).setter(setter(Builder::valueType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValueType").build()).build();

    private static final SdkField<ParameterValue> VALUE_FIELD = SdkField.<ParameterValue> builder(MarshallingType.SDK_POJO)
            .memberName("Value").getter(getter(ParameterConfiguration::value)).setter(setter(Builder::value))
            .constructor(ParameterValue::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(VALUE_TYPE_FIELD, VALUE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String valueType;

    private final ParameterValue value;

    private ParameterConfiguration(BuilderImpl builder) {
        this.valueType = builder.valueType;
        this.value = builder.value;
    }

    /**
     * <p>
     * Identifies whether a control parameter uses a custom user-defined value or subscribes to the default Security Hub
     * behavior.
     * </p>
     * <p>
     * When <code>ValueType</code> is set equal to <code>DEFAULT</code>, the default behavior can be a specific Security
     * Hub default value, or the default behavior can be to ignore a specific parameter. When <code>ValueType</code> is
     * set equal to <code>DEFAULT</code>, Security Hub ignores user-provided input for the <code>Value</code> field.
     * </p>
     * <p>
     * When <code>ValueType</code> is set equal to <code>CUSTOM</code>, the <code>Value</code> field can't be empty.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #valueType} will
     * return {@link ParameterValueType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #valueTypeAsString}.
     * </p>
     * 
     * @return Identifies whether a control parameter uses a custom user-defined value or subscribes to the default
     *         Security Hub behavior.</p>
     *         <p>
     *         When <code>ValueType</code> is set equal to <code>DEFAULT</code>, the default behavior can be a specific
     *         Security Hub default value, or the default behavior can be to ignore a specific parameter. When
     *         <code>ValueType</code> is set equal to <code>DEFAULT</code>, Security Hub ignores user-provided input for
     *         the <code>Value</code> field.
     *         </p>
     *         <p>
     *         When <code>ValueType</code> is set equal to <code>CUSTOM</code>, the <code>Value</code> field can't be
     *         empty.
     * @see ParameterValueType
     */
    public final ParameterValueType valueType() {
        return ParameterValueType.fromValue(valueType);
    }

    /**
     * <p>
     * Identifies whether a control parameter uses a custom user-defined value or subscribes to the default Security Hub
     * behavior.
     * </p>
     * <p>
     * When <code>ValueType</code> is set equal to <code>DEFAULT</code>, the default behavior can be a specific Security
     * Hub default value, or the default behavior can be to ignore a specific parameter. When <code>ValueType</code> is
     * set equal to <code>DEFAULT</code>, Security Hub ignores user-provided input for the <code>Value</code> field.
     * </p>
     * <p>
     * When <code>ValueType</code> is set equal to <code>CUSTOM</code>, the <code>Value</code> field can't be empty.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #valueType} will
     * return {@link ParameterValueType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #valueTypeAsString}.
     * </p>
     * 
     * @return Identifies whether a control parameter uses a custom user-defined value or subscribes to the default
     *         Security Hub behavior.</p>
     *         <p>
     *         When <code>ValueType</code> is set equal to <code>DEFAULT</code>, the default behavior can be a specific
     *         Security Hub default value, or the default behavior can be to ignore a specific parameter. When
     *         <code>ValueType</code> is set equal to <code>DEFAULT</code>, Security Hub ignores user-provided input for
     *         the <code>Value</code> field.
     *         </p>
     *         <p>
     *         When <code>ValueType</code> is set equal to <code>CUSTOM</code>, the <code>Value</code> field can't be
     *         empty.
     * @see ParameterValueType
     */
    public final String valueTypeAsString() {
        return valueType;
    }

    /**
     * <p>
     * The current value of a control parameter.
     * </p>
     * 
     * @return The current value of a control parameter.
     */
    public final ParameterValue value() {
        return value;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(valueTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(value());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ParameterConfiguration)) {
            return false;
        }
        ParameterConfiguration other = (ParameterConfiguration) obj;
        return Objects.equals(valueTypeAsString(), other.valueTypeAsString()) && Objects.equals(value(), other.value());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ParameterConfiguration").add("ValueType", valueTypeAsString()).add("Value", value()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ValueType":
            return Optional.ofNullable(clazz.cast(valueTypeAsString()));
        case "Value":
            return Optional.ofNullable(clazz.cast(value()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ParameterConfiguration, T> g) {
        return obj -> g.apply((ParameterConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ParameterConfiguration> {
        /**
         * <p>
         * Identifies whether a control parameter uses a custom user-defined value or subscribes to the default Security
         * Hub behavior.
         * </p>
         * <p>
         * When <code>ValueType</code> is set equal to <code>DEFAULT</code>, the default behavior can be a specific
         * Security Hub default value, or the default behavior can be to ignore a specific parameter. When
         * <code>ValueType</code> is set equal to <code>DEFAULT</code>, Security Hub ignores user-provided input for the
         * <code>Value</code> field.
         * </p>
         * <p>
         * When <code>ValueType</code> is set equal to <code>CUSTOM</code>, the <code>Value</code> field can't be empty.
         * </p>
         * 
         * @param valueType
         *        Identifies whether a control parameter uses a custom user-defined value or subscribes to the default
         *        Security Hub behavior.</p>
         *        <p>
         *        When <code>ValueType</code> is set equal to <code>DEFAULT</code>, the default behavior can be a
         *        specific Security Hub default value, or the default behavior can be to ignore a specific parameter.
         *        When <code>ValueType</code> is set equal to <code>DEFAULT</code>, Security Hub ignores user-provided
         *        input for the <code>Value</code> field.
         *        </p>
         *        <p>
         *        When <code>ValueType</code> is set equal to <code>CUSTOM</code>, the <code>Value</code> field can't be
         *        empty.
         * @see ParameterValueType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ParameterValueType
         */
        Builder valueType(String valueType);

        /**
         * <p>
         * Identifies whether a control parameter uses a custom user-defined value or subscribes to the default Security
         * Hub behavior.
         * </p>
         * <p>
         * When <code>ValueType</code> is set equal to <code>DEFAULT</code>, the default behavior can be a specific
         * Security Hub default value, or the default behavior can be to ignore a specific parameter. When
         * <code>ValueType</code> is set equal to <code>DEFAULT</code>, Security Hub ignores user-provided input for the
         * <code>Value</code> field.
         * </p>
         * <p>
         * When <code>ValueType</code> is set equal to <code>CUSTOM</code>, the <code>Value</code> field can't be empty.
         * </p>
         * 
         * @param valueType
         *        Identifies whether a control parameter uses a custom user-defined value or subscribes to the default
         *        Security Hub behavior.</p>
         *        <p>
         *        When <code>ValueType</code> is set equal to <code>DEFAULT</code>, the default behavior can be a
         *        specific Security Hub default value, or the default behavior can be to ignore a specific parameter.
         *        When <code>ValueType</code> is set equal to <code>DEFAULT</code>, Security Hub ignores user-provided
         *        input for the <code>Value</code> field.
         *        </p>
         *        <p>
         *        When <code>ValueType</code> is set equal to <code>CUSTOM</code>, the <code>Value</code> field can't be
         *        empty.
         * @see ParameterValueType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ParameterValueType
         */
        Builder valueType(ParameterValueType valueType);

        /**
         * <p>
         * The current value of a control parameter.
         * </p>
         * 
         * @param value
         *        The current value of a control parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(ParameterValue value);

        /**
         * <p>
         * The current value of a control parameter.
         * </p>
         * This is a convenience method that creates an instance of the {@link ParameterValue.Builder} avoiding the need
         * to create one manually via {@link ParameterValue#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ParameterValue.Builder#build()} is called immediately and its
         * result is passed to {@link #value(ParameterValue)}.
         * 
         * @param value
         *        a consumer that will call methods on {@link ParameterValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #value(ParameterValue)
         */
        default Builder value(Consumer<ParameterValue.Builder> value) {
            return value(ParameterValue.builder().applyMutation(value).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String valueType;

        private ParameterValue value;

        private BuilderImpl() {
        }

        private BuilderImpl(ParameterConfiguration model) {
            valueType(model.valueType);
            value(model.value);
        }

        public final String getValueType() {
            return valueType;
        }

        public final void setValueType(String valueType) {
            this.valueType = valueType;
        }

        @Override
        public final Builder valueType(String valueType) {
            this.valueType = valueType;
            return this;
        }

        @Override
        public final Builder valueType(ParameterValueType valueType) {
            this.valueType(valueType == null ? null : valueType.toString());
            return this;
        }

        public final ParameterValue.Builder getValue() {
            return value != null ? value.toBuilder() : null;
        }

        public final void setValue(ParameterValue.BuilderImpl value) {
            this.value = value != null ? value.build() : null;
        }

        @Override
        public final Builder value(ParameterValue value) {
            this.value = value;
            return this;
        }

        @Override
        public ParameterConfiguration build() {
            return new ParameterConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
