/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides an overview of the patch compliance status for an instance against a selected compliance standard.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PatchSummary implements SdkPojo, Serializable, ToCopyableBuilder<PatchSummary.Builder, PatchSummary> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(PatchSummary::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<Integer> INSTALLED_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("InstalledCount").getter(getter(PatchSummary::installedCount)).setter(setter(Builder::installedCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstalledCount").build()).build();

    private static final SdkField<Integer> MISSING_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MissingCount").getter(getter(PatchSummary::missingCount)).setter(setter(Builder::missingCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MissingCount").build()).build();

    private static final SdkField<Integer> FAILED_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("FailedCount").getter(getter(PatchSummary::failedCount)).setter(setter(Builder::failedCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailedCount").build()).build();

    private static final SdkField<Integer> INSTALLED_OTHER_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("InstalledOtherCount").getter(getter(PatchSummary::installedOtherCount))
            .setter(setter(Builder::installedOtherCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstalledOtherCount").build())
            .build();

    private static final SdkField<Integer> INSTALLED_REJECTED_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("InstalledRejectedCount").getter(getter(PatchSummary::installedRejectedCount))
            .setter(setter(Builder::installedRejectedCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstalledRejectedCount").build())
            .build();

    private static final SdkField<Integer> INSTALLED_PENDING_REBOOT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("InstalledPendingReboot").getter(getter(PatchSummary::installedPendingReboot))
            .setter(setter(Builder::installedPendingReboot))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstalledPendingReboot").build())
            .build();

    private static final SdkField<String> OPERATION_START_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OperationStartTime").getter(getter(PatchSummary::operationStartTime))
            .setter(setter(Builder::operationStartTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OperationStartTime").build())
            .build();

    private static final SdkField<String> OPERATION_END_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OperationEndTime").getter(getter(PatchSummary::operationEndTime))
            .setter(setter(Builder::operationEndTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OperationEndTime").build()).build();

    private static final SdkField<String> REBOOT_OPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RebootOption").getter(getter(PatchSummary::rebootOption)).setter(setter(Builder::rebootOption))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RebootOption").build()).build();

    private static final SdkField<String> OPERATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Operation").getter(getter(PatchSummary::operation)).setter(setter(Builder::operation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Operation").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD,
            INSTALLED_COUNT_FIELD, MISSING_COUNT_FIELD, FAILED_COUNT_FIELD, INSTALLED_OTHER_COUNT_FIELD,
            INSTALLED_REJECTED_COUNT_FIELD, INSTALLED_PENDING_REBOOT_FIELD, OPERATION_START_TIME_FIELD, OPERATION_END_TIME_FIELD,
            REBOOT_OPTION_FIELD, OPERATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String id;

    private final Integer installedCount;

    private final Integer missingCount;

    private final Integer failedCount;

    private final Integer installedOtherCount;

    private final Integer installedRejectedCount;

    private final Integer installedPendingReboot;

    private final String operationStartTime;

    private final String operationEndTime;

    private final String rebootOption;

    private final String operation;

    private PatchSummary(BuilderImpl builder) {
        this.id = builder.id;
        this.installedCount = builder.installedCount;
        this.missingCount = builder.missingCount;
        this.failedCount = builder.failedCount;
        this.installedOtherCount = builder.installedOtherCount;
        this.installedRejectedCount = builder.installedRejectedCount;
        this.installedPendingReboot = builder.installedPendingReboot;
        this.operationStartTime = builder.operationStartTime;
        this.operationEndTime = builder.operationEndTime;
        this.rebootOption = builder.rebootOption;
        this.operation = builder.operation;
    }

    /**
     * <p>
     * The identifier of the compliance standard that was used to determine the patch compliance status.
     * </p>
     * 
     * @return The identifier of the compliance standard that was used to determine the patch compliance status.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The number of patches from the compliance standard that were installed successfully.
     * </p>
     * 
     * @return The number of patches from the compliance standard that were installed successfully.
     */
    public final Integer installedCount() {
        return installedCount;
    }

    /**
     * <p>
     * The number of patches that are part of the compliance standard but are not installed. The count includes patches
     * that failed to install.
     * </p>
     * 
     * @return The number of patches that are part of the compliance standard but are not installed. The count includes
     *         patches that failed to install.
     */
    public final Integer missingCount() {
        return missingCount;
    }

    /**
     * <p>
     * The number of patches from the compliance standard that failed to install.
     * </p>
     * 
     * @return The number of patches from the compliance standard that failed to install.
     */
    public final Integer failedCount() {
        return failedCount;
    }

    /**
     * <p>
     * The number of installed patches that are not part of the compliance standard.
     * </p>
     * 
     * @return The number of installed patches that are not part of the compliance standard.
     */
    public final Integer installedOtherCount() {
        return installedOtherCount;
    }

    /**
     * <p>
     * The number of patches that are installed but are also on a list of patches that the customer rejected.
     * </p>
     * 
     * @return The number of patches that are installed but are also on a list of patches that the customer rejected.
     */
    public final Integer installedRejectedCount() {
        return installedRejectedCount;
    }

    /**
     * <p>
     * The number of patches that were applied, but that require the instance to be rebooted in order to be marked as
     * installed.
     * </p>
     * 
     * @return The number of patches that were applied, but that require the instance to be rebooted in order to be
     *         marked as installed.
     */
    public final Integer installedPendingReboot() {
        return installedPendingReboot;
    }

    /**
     * <p>
     * Indicates when the operation started.
     * </p>
     * <p>
     * This field accepts only the specified formats. Timestamps can end with <code>Z</code> or
     * <code>("+" / "-") time-hour [":" time-minute]</code>. The time-secfrac after seconds is limited to a maximum of 9
     * digits. The offset is bounded by +/-18:00. Here are valid timestamp formats with examples:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>YYYY-MM-DDTHH:MM:SSZ</code> (for example, <code>2019-01-31T23:00:00Z</code>)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ</code> (for example, <code>2019-01-31T23:00:00.123456789Z</code>)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>YYYY-MM-DDTHH:MM:SS+HH:MM</code> (for example, <code>2024-01-04T15:25:10+17:59</code>)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>YYYY-MM-DDTHH:MM:SS-HHMM</code> (for example, <code>2024-01-04T15:25:10-1759</code>)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM</code> (for example, <code>2024-01-04T15:25:10.123456789+17:59</code>)
     * </p>
     * </li>
     * </ul>
     * 
     * @return Indicates when the operation started.</p>
     *         <p>
     *         This field accepts only the specified formats. Timestamps can end with <code>Z</code> or
     *         <code>("+" / "-") time-hour [":" time-minute]</code>. The time-secfrac after seconds is limited to a
     *         maximum of 9 digits. The offset is bounded by +/-18:00. Here are valid timestamp formats with examples:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>YYYY-MM-DDTHH:MM:SSZ</code> (for example, <code>2019-01-31T23:00:00Z</code>)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ</code> (for example, <code>2019-01-31T23:00:00.123456789Z</code>)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>YYYY-MM-DDTHH:MM:SS+HH:MM</code> (for example, <code>2024-01-04T15:25:10+17:59</code>)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>YYYY-MM-DDTHH:MM:SS-HHMM</code> (for example, <code>2024-01-04T15:25:10-1759</code>)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM</code> (for example,
     *         <code>2024-01-04T15:25:10.123456789+17:59</code>)
     *         </p>
     *         </li>
     */
    public final String operationStartTime() {
        return operationStartTime;
    }

    /**
     * <p>
     * Indicates when the operation completed.
     * </p>
     * <p>
     * This field accepts only the specified formats. Timestamps can end with <code>Z</code> or
     * <code>("+" / "-") time-hour [":" time-minute]</code>. The time-secfrac after seconds is limited to a maximum of 9
     * digits. The offset is bounded by +/-18:00. Here are valid timestamp formats with examples:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>YYYY-MM-DDTHH:MM:SSZ</code> (for example, <code>2019-01-31T23:00:00Z</code>)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ</code> (for example, <code>2019-01-31T23:00:00.123456789Z</code>)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>YYYY-MM-DDTHH:MM:SS+HH:MM</code> (for example, <code>2024-01-04T15:25:10+17:59</code>)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>YYYY-MM-DDTHH:MM:SS-HHMM</code> (for example, <code>2024-01-04T15:25:10-1759</code>)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM</code> (for example, <code>2024-01-04T15:25:10.123456789+17:59</code>)
     * </p>
     * </li>
     * </ul>
     * 
     * @return Indicates when the operation completed.</p>
     *         <p>
     *         This field accepts only the specified formats. Timestamps can end with <code>Z</code> or
     *         <code>("+" / "-") time-hour [":" time-minute]</code>. The time-secfrac after seconds is limited to a
     *         maximum of 9 digits. The offset is bounded by +/-18:00. Here are valid timestamp formats with examples:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>YYYY-MM-DDTHH:MM:SSZ</code> (for example, <code>2019-01-31T23:00:00Z</code>)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ</code> (for example, <code>2019-01-31T23:00:00.123456789Z</code>)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>YYYY-MM-DDTHH:MM:SS+HH:MM</code> (for example, <code>2024-01-04T15:25:10+17:59</code>)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>YYYY-MM-DDTHH:MM:SS-HHMM</code> (for example, <code>2024-01-04T15:25:10-1759</code>)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM</code> (for example,
     *         <code>2024-01-04T15:25:10.123456789+17:59</code>)
     *         </p>
     *         </li>
     */
    public final String operationEndTime() {
        return operationEndTime;
    }

    /**
     * <p>
     * The reboot option specified for the instance.
     * </p>
     * 
     * @return The reboot option specified for the instance.
     */
    public final String rebootOption() {
        return rebootOption;
    }

    /**
     * <p>
     * The type of patch operation performed. For Patch Manager, the values are <code>SCAN</code> and
     * <code>INSTALL</code>.
     * </p>
     * 
     * @return The type of patch operation performed. For Patch Manager, the values are <code>SCAN</code> and
     *         <code>INSTALL</code>.
     */
    public final String operation() {
        return operation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(installedCount());
        hashCode = 31 * hashCode + Objects.hashCode(missingCount());
        hashCode = 31 * hashCode + Objects.hashCode(failedCount());
        hashCode = 31 * hashCode + Objects.hashCode(installedOtherCount());
        hashCode = 31 * hashCode + Objects.hashCode(installedRejectedCount());
        hashCode = 31 * hashCode + Objects.hashCode(installedPendingReboot());
        hashCode = 31 * hashCode + Objects.hashCode(operationStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(operationEndTime());
        hashCode = 31 * hashCode + Objects.hashCode(rebootOption());
        hashCode = 31 * hashCode + Objects.hashCode(operation());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PatchSummary)) {
            return false;
        }
        PatchSummary other = (PatchSummary) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(installedCount(), other.installedCount())
                && Objects.equals(missingCount(), other.missingCount()) && Objects.equals(failedCount(), other.failedCount())
                && Objects.equals(installedOtherCount(), other.installedOtherCount())
                && Objects.equals(installedRejectedCount(), other.installedRejectedCount())
                && Objects.equals(installedPendingReboot(), other.installedPendingReboot())
                && Objects.equals(operationStartTime(), other.operationStartTime())
                && Objects.equals(operationEndTime(), other.operationEndTime())
                && Objects.equals(rebootOption(), other.rebootOption()) && Objects.equals(operation(), other.operation());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PatchSummary").add("Id", id()).add("InstalledCount", installedCount())
                .add("MissingCount", missingCount()).add("FailedCount", failedCount())
                .add("InstalledOtherCount", installedOtherCount()).add("InstalledRejectedCount", installedRejectedCount())
                .add("InstalledPendingReboot", installedPendingReboot()).add("OperationStartTime", operationStartTime())
                .add("OperationEndTime", operationEndTime()).add("RebootOption", rebootOption()).add("Operation", operation())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "InstalledCount":
            return Optional.ofNullable(clazz.cast(installedCount()));
        case "MissingCount":
            return Optional.ofNullable(clazz.cast(missingCount()));
        case "FailedCount":
            return Optional.ofNullable(clazz.cast(failedCount()));
        case "InstalledOtherCount":
            return Optional.ofNullable(clazz.cast(installedOtherCount()));
        case "InstalledRejectedCount":
            return Optional.ofNullable(clazz.cast(installedRejectedCount()));
        case "InstalledPendingReboot":
            return Optional.ofNullable(clazz.cast(installedPendingReboot()));
        case "OperationStartTime":
            return Optional.ofNullable(clazz.cast(operationStartTime()));
        case "OperationEndTime":
            return Optional.ofNullable(clazz.cast(operationEndTime()));
        case "RebootOption":
            return Optional.ofNullable(clazz.cast(rebootOption()));
        case "Operation":
            return Optional.ofNullable(clazz.cast(operation()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PatchSummary, T> g) {
        return obj -> g.apply((PatchSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PatchSummary> {
        /**
         * <p>
         * The identifier of the compliance standard that was used to determine the patch compliance status.
         * </p>
         * 
         * @param id
         *        The identifier of the compliance standard that was used to determine the patch compliance status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The number of patches from the compliance standard that were installed successfully.
         * </p>
         * 
         * @param installedCount
         *        The number of patches from the compliance standard that were installed successfully.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder installedCount(Integer installedCount);

        /**
         * <p>
         * The number of patches that are part of the compliance standard but are not installed. The count includes
         * patches that failed to install.
         * </p>
         * 
         * @param missingCount
         *        The number of patches that are part of the compliance standard but are not installed. The count
         *        includes patches that failed to install.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder missingCount(Integer missingCount);

        /**
         * <p>
         * The number of patches from the compliance standard that failed to install.
         * </p>
         * 
         * @param failedCount
         *        The number of patches from the compliance standard that failed to install.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failedCount(Integer failedCount);

        /**
         * <p>
         * The number of installed patches that are not part of the compliance standard.
         * </p>
         * 
         * @param installedOtherCount
         *        The number of installed patches that are not part of the compliance standard.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder installedOtherCount(Integer installedOtherCount);

        /**
         * <p>
         * The number of patches that are installed but are also on a list of patches that the customer rejected.
         * </p>
         * 
         * @param installedRejectedCount
         *        The number of patches that are installed but are also on a list of patches that the customer rejected.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder installedRejectedCount(Integer installedRejectedCount);

        /**
         * <p>
         * The number of patches that were applied, but that require the instance to be rebooted in order to be marked
         * as installed.
         * </p>
         * 
         * @param installedPendingReboot
         *        The number of patches that were applied, but that require the instance to be rebooted in order to be
         *        marked as installed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder installedPendingReboot(Integer installedPendingReboot);

        /**
         * <p>
         * Indicates when the operation started.
         * </p>
         * <p>
         * This field accepts only the specified formats. Timestamps can end with <code>Z</code> or
         * <code>("+" / "-") time-hour [":" time-minute]</code>. The time-secfrac after seconds is limited to a maximum
         * of 9 digits. The offset is bounded by +/-18:00. Here are valid timestamp formats with examples:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>YYYY-MM-DDTHH:MM:SSZ</code> (for example, <code>2019-01-31T23:00:00Z</code>)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ</code> (for example, <code>2019-01-31T23:00:00.123456789Z</code>)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>YYYY-MM-DDTHH:MM:SS+HH:MM</code> (for example, <code>2024-01-04T15:25:10+17:59</code>)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>YYYY-MM-DDTHH:MM:SS-HHMM</code> (for example, <code>2024-01-04T15:25:10-1759</code>)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM</code> (for example,
         * <code>2024-01-04T15:25:10.123456789+17:59</code>)
         * </p>
         * </li>
         * </ul>
         * 
         * @param operationStartTime
         *        Indicates when the operation started.</p>
         *        <p>
         *        This field accepts only the specified formats. Timestamps can end with <code>Z</code> or
         *        <code>("+" / "-") time-hour [":" time-minute]</code>. The time-secfrac after seconds is limited to a
         *        maximum of 9 digits. The offset is bounded by +/-18:00. Here are valid timestamp formats with
         *        examples:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>YYYY-MM-DDTHH:MM:SSZ</code> (for example, <code>2019-01-31T23:00:00Z</code>)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ</code> (for example, <code>2019-01-31T23:00:00.123456789Z</code>)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>YYYY-MM-DDTHH:MM:SS+HH:MM</code> (for example, <code>2024-01-04T15:25:10+17:59</code>)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>YYYY-MM-DDTHH:MM:SS-HHMM</code> (for example, <code>2024-01-04T15:25:10-1759</code>)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM</code> (for example,
         *        <code>2024-01-04T15:25:10.123456789+17:59</code>)
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operationStartTime(String operationStartTime);

        /**
         * <p>
         * Indicates when the operation completed.
         * </p>
         * <p>
         * This field accepts only the specified formats. Timestamps can end with <code>Z</code> or
         * <code>("+" / "-") time-hour [":" time-minute]</code>. The time-secfrac after seconds is limited to a maximum
         * of 9 digits. The offset is bounded by +/-18:00. Here are valid timestamp formats with examples:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>YYYY-MM-DDTHH:MM:SSZ</code> (for example, <code>2019-01-31T23:00:00Z</code>)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ</code> (for example, <code>2019-01-31T23:00:00.123456789Z</code>)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>YYYY-MM-DDTHH:MM:SS+HH:MM</code> (for example, <code>2024-01-04T15:25:10+17:59</code>)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>YYYY-MM-DDTHH:MM:SS-HHMM</code> (for example, <code>2024-01-04T15:25:10-1759</code>)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM</code> (for example,
         * <code>2024-01-04T15:25:10.123456789+17:59</code>)
         * </p>
         * </li>
         * </ul>
         * 
         * @param operationEndTime
         *        Indicates when the operation completed.</p>
         *        <p>
         *        This field accepts only the specified formats. Timestamps can end with <code>Z</code> or
         *        <code>("+" / "-") time-hour [":" time-minute]</code>. The time-secfrac after seconds is limited to a
         *        maximum of 9 digits. The offset is bounded by +/-18:00. Here are valid timestamp formats with
         *        examples:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>YYYY-MM-DDTHH:MM:SSZ</code> (for example, <code>2019-01-31T23:00:00Z</code>)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ</code> (for example, <code>2019-01-31T23:00:00.123456789Z</code>)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>YYYY-MM-DDTHH:MM:SS+HH:MM</code> (for example, <code>2024-01-04T15:25:10+17:59</code>)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>YYYY-MM-DDTHH:MM:SS-HHMM</code> (for example, <code>2024-01-04T15:25:10-1759</code>)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM</code> (for example,
         *        <code>2024-01-04T15:25:10.123456789+17:59</code>)
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operationEndTime(String operationEndTime);

        /**
         * <p>
         * The reboot option specified for the instance.
         * </p>
         * 
         * @param rebootOption
         *        The reboot option specified for the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rebootOption(String rebootOption);

        /**
         * <p>
         * The type of patch operation performed. For Patch Manager, the values are <code>SCAN</code> and
         * <code>INSTALL</code>.
         * </p>
         * 
         * @param operation
         *        The type of patch operation performed. For Patch Manager, the values are <code>SCAN</code> and
         *        <code>INSTALL</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operation(String operation);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private Integer installedCount;

        private Integer missingCount;

        private Integer failedCount;

        private Integer installedOtherCount;

        private Integer installedRejectedCount;

        private Integer installedPendingReboot;

        private String operationStartTime;

        private String operationEndTime;

        private String rebootOption;

        private String operation;

        private BuilderImpl() {
        }

        private BuilderImpl(PatchSummary model) {
            id(model.id);
            installedCount(model.installedCount);
            missingCount(model.missingCount);
            failedCount(model.failedCount);
            installedOtherCount(model.installedOtherCount);
            installedRejectedCount(model.installedRejectedCount);
            installedPendingReboot(model.installedPendingReboot);
            operationStartTime(model.operationStartTime);
            operationEndTime(model.operationEndTime);
            rebootOption(model.rebootOption);
            operation(model.operation);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final Integer getInstalledCount() {
            return installedCount;
        }

        public final void setInstalledCount(Integer installedCount) {
            this.installedCount = installedCount;
        }

        @Override
        public final Builder installedCount(Integer installedCount) {
            this.installedCount = installedCount;
            return this;
        }

        public final Integer getMissingCount() {
            return missingCount;
        }

        public final void setMissingCount(Integer missingCount) {
            this.missingCount = missingCount;
        }

        @Override
        public final Builder missingCount(Integer missingCount) {
            this.missingCount = missingCount;
            return this;
        }

        public final Integer getFailedCount() {
            return failedCount;
        }

        public final void setFailedCount(Integer failedCount) {
            this.failedCount = failedCount;
        }

        @Override
        public final Builder failedCount(Integer failedCount) {
            this.failedCount = failedCount;
            return this;
        }

        public final Integer getInstalledOtherCount() {
            return installedOtherCount;
        }

        public final void setInstalledOtherCount(Integer installedOtherCount) {
            this.installedOtherCount = installedOtherCount;
        }

        @Override
        public final Builder installedOtherCount(Integer installedOtherCount) {
            this.installedOtherCount = installedOtherCount;
            return this;
        }

        public final Integer getInstalledRejectedCount() {
            return installedRejectedCount;
        }

        public final void setInstalledRejectedCount(Integer installedRejectedCount) {
            this.installedRejectedCount = installedRejectedCount;
        }

        @Override
        public final Builder installedRejectedCount(Integer installedRejectedCount) {
            this.installedRejectedCount = installedRejectedCount;
            return this;
        }

        public final Integer getInstalledPendingReboot() {
            return installedPendingReboot;
        }

        public final void setInstalledPendingReboot(Integer installedPendingReboot) {
            this.installedPendingReboot = installedPendingReboot;
        }

        @Override
        public final Builder installedPendingReboot(Integer installedPendingReboot) {
            this.installedPendingReboot = installedPendingReboot;
            return this;
        }

        public final String getOperationStartTime() {
            return operationStartTime;
        }

        public final void setOperationStartTime(String operationStartTime) {
            this.operationStartTime = operationStartTime;
        }

        @Override
        public final Builder operationStartTime(String operationStartTime) {
            this.operationStartTime = operationStartTime;
            return this;
        }

        public final String getOperationEndTime() {
            return operationEndTime;
        }

        public final void setOperationEndTime(String operationEndTime) {
            this.operationEndTime = operationEndTime;
        }

        @Override
        public final Builder operationEndTime(String operationEndTime) {
            this.operationEndTime = operationEndTime;
            return this;
        }

        public final String getRebootOption() {
            return rebootOption;
        }

        public final void setRebootOption(String rebootOption) {
            this.rebootOption = rebootOption;
        }

        @Override
        public final Builder rebootOption(String rebootOption) {
            this.rebootOption = rebootOption;
            return this;
        }

        public final String getOperation() {
            return operation;
        }

        public final void setOperation(String operation) {
            this.operation = operation;
        }

        @Override
        public final Builder operation(String operation) {
            this.operation = operation;
            return this;
        }

        @Override
        public PatchSummary build() {
            return new PatchSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
