/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class SecurityControlCustomParametersListCopier {
    static List<SecurityControlCustomParameter> copy(
            Collection<? extends SecurityControlCustomParameter> securityControlCustomParametersListParam) {
        List<SecurityControlCustomParameter> list;
        if (securityControlCustomParametersListParam == null
                || securityControlCustomParametersListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<SecurityControlCustomParameter> modifiableList = new ArrayList<>();
            securityControlCustomParametersListParam.forEach(entry -> {
                modifiableList.add(entry);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<SecurityControlCustomParameter> copyFromBuilder(
            Collection<? extends SecurityControlCustomParameter.Builder> securityControlCustomParametersListParam) {
        List<SecurityControlCustomParameter> list;
        if (securityControlCustomParametersListParam == null
                || securityControlCustomParametersListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<SecurityControlCustomParameter> modifiableList = new ArrayList<>();
            securityControlCustomParametersListParam.forEach(entry -> {
                SecurityControlCustomParameter member = entry == null ? null : entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<SecurityControlCustomParameter.Builder> copyToBuilder(
            Collection<? extends SecurityControlCustomParameter> securityControlCustomParametersListParam) {
        List<SecurityControlCustomParameter.Builder> list;
        if (securityControlCustomParametersListParam == null
                || securityControlCustomParametersListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<SecurityControlCustomParameter.Builder> modifiableList = new ArrayList<>();
            securityControlCustomParametersListParam.forEach(entry -> {
                SecurityControlCustomParameter.Builder member = entry == null ? null : entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
