/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains detailed information about the recovery points stored in an Backup backup vault. A backup, or recovery
 * point, represents the content of a resource at a specified time.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsBackupRecoveryPointDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsBackupRecoveryPointDetails.Builder, AwsBackupRecoveryPointDetails> {
    private static final SdkField<Long> BACKUP_SIZE_IN_BYTES_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("BackupSizeInBytes").getter(getter(AwsBackupRecoveryPointDetails::backupSizeInBytes))
            .setter(setter(Builder::backupSizeInBytes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupSizeInBytes").build()).build();

    private static final SdkField<String> BACKUP_VAULT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BackupVaultArn").getter(getter(AwsBackupRecoveryPointDetails::backupVaultArn))
            .setter(setter(Builder::backupVaultArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupVaultArn").build()).build();

    private static final SdkField<String> BACKUP_VAULT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BackupVaultName").getter(getter(AwsBackupRecoveryPointDetails::backupVaultName))
            .setter(setter(Builder::backupVaultName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupVaultName").build()).build();

    private static final SdkField<AwsBackupRecoveryPointCalculatedLifecycleDetails> CALCULATED_LIFECYCLE_FIELD = SdkField
            .<AwsBackupRecoveryPointCalculatedLifecycleDetails> builder(MarshallingType.SDK_POJO)
            .memberName("CalculatedLifecycle").getter(getter(AwsBackupRecoveryPointDetails::calculatedLifecycle))
            .setter(setter(Builder::calculatedLifecycle)).constructor(AwsBackupRecoveryPointCalculatedLifecycleDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CalculatedLifecycle").build())
            .build();

    private static final SdkField<String> COMPLETION_DATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CompletionDate").getter(getter(AwsBackupRecoveryPointDetails::completionDate))
            .setter(setter(Builder::completionDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompletionDate").build()).build();

    private static final SdkField<AwsBackupRecoveryPointCreatedByDetails> CREATED_BY_FIELD = SdkField
            .<AwsBackupRecoveryPointCreatedByDetails> builder(MarshallingType.SDK_POJO).memberName("CreatedBy")
            .getter(getter(AwsBackupRecoveryPointDetails::createdBy)).setter(setter(Builder::createdBy))
            .constructor(AwsBackupRecoveryPointCreatedByDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedBy").build()).build();

    private static final SdkField<String> CREATION_DATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CreationDate").getter(getter(AwsBackupRecoveryPointDetails::creationDate))
            .setter(setter(Builder::creationDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationDate").build()).build();

    private static final SdkField<String> ENCRYPTION_KEY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EncryptionKeyArn").getter(getter(AwsBackupRecoveryPointDetails::encryptionKeyArn))
            .setter(setter(Builder::encryptionKeyArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionKeyArn").build()).build();

    private static final SdkField<String> IAM_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IamRoleArn").getter(getter(AwsBackupRecoveryPointDetails::iamRoleArn))
            .setter(setter(Builder::iamRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IamRoleArn").build()).build();

    private static final SdkField<Boolean> IS_ENCRYPTED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IsEncrypted").getter(getter(AwsBackupRecoveryPointDetails::isEncrypted))
            .setter(setter(Builder::isEncrypted))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsEncrypted").build()).build();

    private static final SdkField<String> LAST_RESTORE_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LastRestoreTime").getter(getter(AwsBackupRecoveryPointDetails::lastRestoreTime))
            .setter(setter(Builder::lastRestoreTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastRestoreTime").build()).build();

    private static final SdkField<AwsBackupRecoveryPointLifecycleDetails> LIFECYCLE_FIELD = SdkField
            .<AwsBackupRecoveryPointLifecycleDetails> builder(MarshallingType.SDK_POJO).memberName("Lifecycle")
            .getter(getter(AwsBackupRecoveryPointDetails::lifecycle)).setter(setter(Builder::lifecycle))
            .constructor(AwsBackupRecoveryPointLifecycleDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Lifecycle").build()).build();

    private static final SdkField<String> RECOVERY_POINT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RecoveryPointArn").getter(getter(AwsBackupRecoveryPointDetails::recoveryPointArn))
            .setter(setter(Builder::recoveryPointArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecoveryPointArn").build()).build();

    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceArn").getter(getter(AwsBackupRecoveryPointDetails::resourceArn))
            .setter(setter(Builder::resourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceArn").build()).build();

    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceType").getter(getter(AwsBackupRecoveryPointDetails::resourceType))
            .setter(setter(Builder::resourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").build()).build();

    private static final SdkField<String> SOURCE_BACKUP_VAULT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceBackupVaultArn").getter(getter(AwsBackupRecoveryPointDetails::sourceBackupVaultArn))
            .setter(setter(Builder::sourceBackupVaultArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceBackupVaultArn").build())
            .build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(AwsBackupRecoveryPointDetails::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StatusMessage").getter(getter(AwsBackupRecoveryPointDetails::statusMessage))
            .setter(setter(Builder::statusMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusMessage").build()).build();

    private static final SdkField<String> STORAGE_CLASS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StorageClass").getter(getter(AwsBackupRecoveryPointDetails::storageClass))
            .setter(setter(Builder::storageClass))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageClass").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BACKUP_SIZE_IN_BYTES_FIELD,
            BACKUP_VAULT_ARN_FIELD, BACKUP_VAULT_NAME_FIELD, CALCULATED_LIFECYCLE_FIELD, COMPLETION_DATE_FIELD, CREATED_BY_FIELD,
            CREATION_DATE_FIELD, ENCRYPTION_KEY_ARN_FIELD, IAM_ROLE_ARN_FIELD, IS_ENCRYPTED_FIELD, LAST_RESTORE_TIME_FIELD,
            LIFECYCLE_FIELD, RECOVERY_POINT_ARN_FIELD, RESOURCE_ARN_FIELD, RESOURCE_TYPE_FIELD, SOURCE_BACKUP_VAULT_ARN_FIELD,
            STATUS_FIELD, STATUS_MESSAGE_FIELD, STORAGE_CLASS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Long backupSizeInBytes;

    private final String backupVaultArn;

    private final String backupVaultName;

    private final AwsBackupRecoveryPointCalculatedLifecycleDetails calculatedLifecycle;

    private final String completionDate;

    private final AwsBackupRecoveryPointCreatedByDetails createdBy;

    private final String creationDate;

    private final String encryptionKeyArn;

    private final String iamRoleArn;

    private final Boolean isEncrypted;

    private final String lastRestoreTime;

    private final AwsBackupRecoveryPointLifecycleDetails lifecycle;

    private final String recoveryPointArn;

    private final String resourceArn;

    private final String resourceType;

    private final String sourceBackupVaultArn;

    private final String status;

    private final String statusMessage;

    private final String storageClass;

    private AwsBackupRecoveryPointDetails(BuilderImpl builder) {
        this.backupSizeInBytes = builder.backupSizeInBytes;
        this.backupVaultArn = builder.backupVaultArn;
        this.backupVaultName = builder.backupVaultName;
        this.calculatedLifecycle = builder.calculatedLifecycle;
        this.completionDate = builder.completionDate;
        this.createdBy = builder.createdBy;
        this.creationDate = builder.creationDate;
        this.encryptionKeyArn = builder.encryptionKeyArn;
        this.iamRoleArn = builder.iamRoleArn;
        this.isEncrypted = builder.isEncrypted;
        this.lastRestoreTime = builder.lastRestoreTime;
        this.lifecycle = builder.lifecycle;
        this.recoveryPointArn = builder.recoveryPointArn;
        this.resourceArn = builder.resourceArn;
        this.resourceType = builder.resourceType;
        this.sourceBackupVaultArn = builder.sourceBackupVaultArn;
        this.status = builder.status;
        this.statusMessage = builder.statusMessage;
        this.storageClass = builder.storageClass;
    }

    /**
     * <p>
     * The size, in bytes, of a backup.
     * </p>
     * 
     * @return The size, in bytes, of a backup.
     */
    public final Long backupSizeInBytes() {
        return backupSizeInBytes;
    }

    /**
     * <p>
     * An Amazon Resource Name (ARN) that uniquely identifies a backup vault.
     * </p>
     * 
     * @return An Amazon Resource Name (ARN) that uniquely identifies a backup vault.
     */
    public final String backupVaultArn() {
        return backupVaultArn;
    }

    /**
     * <p>
     * The name of a logical container where backups are stored. Backup vaults are identified by names that are unique
     * to the Amazon Web Services account used to create them and the Amazon Web Services Region where they are created.
     * They consist of lowercase letters, numbers, and hyphens.
     * </p>
     * 
     * @return The name of a logical container where backups are stored. Backup vaults are identified by names that are
     *         unique to the Amazon Web Services account used to create them and the Amazon Web Services Region where
     *         they are created. They consist of lowercase letters, numbers, and hyphens.
     */
    public final String backupVaultName() {
        return backupVaultName;
    }

    /**
     * <p>
     * A <code>CalculatedLifecycle</code> object containing <code>DeleteAt</code> and <code>MoveToColdStorageAt</code>
     * timestamps.
     * </p>
     * 
     * @return A <code>CalculatedLifecycle</code> object containing <code>DeleteAt</code> and
     *         <code>MoveToColdStorageAt</code> timestamps.
     */
    public final AwsBackupRecoveryPointCalculatedLifecycleDetails calculatedLifecycle() {
        return calculatedLifecycle;
    }

    /**
     * <p>
     * The date and time that a job to create a recovery point is completed, in Unix format and UTC. The value of
     * <code>CompletionDate</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday,
     * January 26, 2018 12:11:30.087 AM.
     * </p>
     * 
     * @return The date and time that a job to create a recovery point is completed, in Unix format and UTC. The value
     *         of <code>CompletionDate</code> is accurate to milliseconds. For example, the value 1516925490.087
     *         represents Friday, January 26, 2018 12:11:30.087 AM.
     */
    public final String completionDate() {
        return completionDate;
    }

    /**
     * <p>
     * Contains identifying information about the creation of a recovery point, including the <code>BackupPlanArn</code>, <code>BackupPlanId</code>, <code>BackupPlanVersion</code>, and <code>BackupRuleId</code> of the backup plan
     * that is used to create it.
     * </p>
     * 
     * @return Contains identifying information about the creation of a recovery point, including the
     *         <code>BackupPlanArn</code>, <code>BackupPlanId</code>, <code>BackupPlanVersion</code>, and
     *         <code>BackupRuleId</code> of the backup plan that is used to create it.
     */
    public final AwsBackupRecoveryPointCreatedByDetails createdBy() {
        return createdBy;
    }

    /**
     * <p>
     * The date and time a recovery point is created, in Unix format and UTC. The value of <code>CreationDate</code> is
     * accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087
     * AM.
     * </p>
     * 
     * @return The date and time a recovery point is created, in Unix format and UTC. The value of
     *         <code>CreationDate</code> is accurate to milliseconds. For example, the value 1516925490.087 represents
     *         Friday, January 26, 2018 12:11:30.087 AM.
     */
    public final String creationDate() {
        return creationDate;
    }

    /**
     * <p>
     * The ARN for the server-side encryption key that is used to protect your backups.
     * </p>
     * 
     * @return The ARN for the server-side encryption key that is used to protect your backups.
     */
    public final String encryptionKeyArn() {
        return encryptionKeyArn;
    }

    /**
     * <p>
     * Specifies the IAM role ARN used to create the target recovery point
     * </p>
     * 
     * @return Specifies the IAM role ARN used to create the target recovery point
     */
    public final String iamRoleArn() {
        return iamRoleArn;
    }

    /**
     * <p>
     * A Boolean value that is returned as <code>TRUE</code> if the specified recovery point is encrypted, or
     * <code>FALSE</code> if the recovery point is not encrypted.
     * </p>
     * 
     * @return A Boolean value that is returned as <code>TRUE</code> if the specified recovery point is encrypted, or
     *         <code>FALSE</code> if the recovery point is not encrypted.
     */
    public final Boolean isEncrypted() {
        return isEncrypted;
    }

    /**
     * <p>
     * The date and time that a recovery point was last restored, in Unix format and UTC. The value of
     * <code>LastRestoreTime</code> is accurate to milliseconds. For example, the value 1516925490.087 represents
     * Friday, January 26, 2018 12:11:30.087 AM.
     * </p>
     * 
     * @return The date and time that a recovery point was last restored, in Unix format and UTC. The value of
     *         <code>LastRestoreTime</code> is accurate to milliseconds. For example, the value 1516925490.087
     *         represents Friday, January 26, 2018 12:11:30.087 AM.
     */
    public final String lastRestoreTime() {
        return lastRestoreTime;
    }

    /**
     * <p>
     * The lifecycle defines when a protected resource is transitioned to cold storage and when it expires. Backup
     * transitions and expires backups automatically according to the lifecycle that you define
     * </p>
     * 
     * @return The lifecycle defines when a protected resource is transitioned to cold storage and when it expires.
     *         Backup transitions and expires backups automatically according to the lifecycle that you define
     */
    public final AwsBackupRecoveryPointLifecycleDetails lifecycle() {
        return lifecycle;
    }

    /**
     * <p>
     * An ARN that uniquely identifies a recovery point.
     * </p>
     * 
     * @return An ARN that uniquely identifies a recovery point.
     */
    public final String recoveryPointArn() {
        return recoveryPointArn;
    }

    /**
     * <p>
     * An ARN that uniquely identifies a resource. The format of the ARN depends on the resource type.
     * </p>
     * 
     * @return An ARN that uniquely identifies a resource. The format of the ARN depends on the resource type.
     */
    public final String resourceArn() {
        return resourceArn;
    }

    /**
     * <p>
     * The type of Amazon Web Services resource saved as a recovery point, such as an Amazon EBS volume or an Amazon RDS
     * database.
     * </p>
     * 
     * @return The type of Amazon Web Services resource saved as a recovery point, such as an Amazon EBS volume or an
     *         Amazon RDS database.
     */
    public final String resourceType() {
        return resourceType;
    }

    /**
     * <p>
     * The ARN for the backup vault where the recovery point was originally copied from. If the recovery point is
     * restored to the same account, this value will be null.
     * </p>
     * 
     * @return The ARN for the backup vault where the recovery point was originally copied from. If the recovery point
     *         is restored to the same account, this value will be null.
     */
    public final String sourceBackupVaultArn() {
        return sourceBackupVaultArn;
    }

    /**
     * <p>
     * A status code specifying the state of the recovery point. Valid values are as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>COMPLETED</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DELETING</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>EXPIRED</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PARTIAL</code>
     * </p>
     * </li>
     * </ul>
     * 
     * @return A status code specifying the state of the recovery point. Valid values are as follows:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>COMPLETED</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DELETING</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>EXPIRED</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PARTIAL</code>
     *         </p>
     *         </li>
     */
    public final String status() {
        return status;
    }

    /**
     * <p>
     * A message explaining the reason of the recovery point deletion failure.
     * </p>
     * 
     * @return A message explaining the reason of the recovery point deletion failure.
     */
    public final String statusMessage() {
        return statusMessage;
    }

    /**
     * <p>
     * Specifies the storage class of the recovery point. Valid values are as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>COLD</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DELETED</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>WARM</code>
     * </p>
     * </li>
     * </ul>
     * 
     * @return Specifies the storage class of the recovery point. Valid values are as follows:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>COLD</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DELETED</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>WARM</code>
     *         </p>
     *         </li>
     */
    public final String storageClass() {
        return storageClass;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(backupSizeInBytes());
        hashCode = 31 * hashCode + Objects.hashCode(backupVaultArn());
        hashCode = 31 * hashCode + Objects.hashCode(backupVaultName());
        hashCode = 31 * hashCode + Objects.hashCode(calculatedLifecycle());
        hashCode = 31 * hashCode + Objects.hashCode(completionDate());
        hashCode = 31 * hashCode + Objects.hashCode(createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(encryptionKeyArn());
        hashCode = 31 * hashCode + Objects.hashCode(iamRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(isEncrypted());
        hashCode = 31 * hashCode + Objects.hashCode(lastRestoreTime());
        hashCode = 31 * hashCode + Objects.hashCode(lifecycle());
        hashCode = 31 * hashCode + Objects.hashCode(recoveryPointArn());
        hashCode = 31 * hashCode + Objects.hashCode(resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(resourceType());
        hashCode = 31 * hashCode + Objects.hashCode(sourceBackupVaultArn());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(storageClass());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsBackupRecoveryPointDetails)) {
            return false;
        }
        AwsBackupRecoveryPointDetails other = (AwsBackupRecoveryPointDetails) obj;
        return Objects.equals(backupSizeInBytes(), other.backupSizeInBytes())
                && Objects.equals(backupVaultArn(), other.backupVaultArn())
                && Objects.equals(backupVaultName(), other.backupVaultName())
                && Objects.equals(calculatedLifecycle(), other.calculatedLifecycle())
                && Objects.equals(completionDate(), other.completionDate()) && Objects.equals(createdBy(), other.createdBy())
                && Objects.equals(creationDate(), other.creationDate())
                && Objects.equals(encryptionKeyArn(), other.encryptionKeyArn())
                && Objects.equals(iamRoleArn(), other.iamRoleArn()) && Objects.equals(isEncrypted(), other.isEncrypted())
                && Objects.equals(lastRestoreTime(), other.lastRestoreTime()) && Objects.equals(lifecycle(), other.lifecycle())
                && Objects.equals(recoveryPointArn(), other.recoveryPointArn())
                && Objects.equals(resourceArn(), other.resourceArn()) && Objects.equals(resourceType(), other.resourceType())
                && Objects.equals(sourceBackupVaultArn(), other.sourceBackupVaultArn())
                && Objects.equals(status(), other.status()) && Objects.equals(statusMessage(), other.statusMessage())
                && Objects.equals(storageClass(), other.storageClass());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsBackupRecoveryPointDetails").add("BackupSizeInBytes", backupSizeInBytes())
                .add("BackupVaultArn", backupVaultArn()).add("BackupVaultName", backupVaultName())
                .add("CalculatedLifecycle", calculatedLifecycle()).add("CompletionDate", completionDate())
                .add("CreatedBy", createdBy()).add("CreationDate", creationDate()).add("EncryptionKeyArn", encryptionKeyArn())
                .add("IamRoleArn", iamRoleArn()).add("IsEncrypted", isEncrypted()).add("LastRestoreTime", lastRestoreTime())
                .add("Lifecycle", lifecycle()).add("RecoveryPointArn", recoveryPointArn()).add("ResourceArn", resourceArn())
                .add("ResourceType", resourceType()).add("SourceBackupVaultArn", sourceBackupVaultArn()).add("Status", status())
                .add("StatusMessage", statusMessage()).add("StorageClass", storageClass()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BackupSizeInBytes":
            return Optional.ofNullable(clazz.cast(backupSizeInBytes()));
        case "BackupVaultArn":
            return Optional.ofNullable(clazz.cast(backupVaultArn()));
        case "BackupVaultName":
            return Optional.ofNullable(clazz.cast(backupVaultName()));
        case "CalculatedLifecycle":
            return Optional.ofNullable(clazz.cast(calculatedLifecycle()));
        case "CompletionDate":
            return Optional.ofNullable(clazz.cast(completionDate()));
        case "CreatedBy":
            return Optional.ofNullable(clazz.cast(createdBy()));
        case "CreationDate":
            return Optional.ofNullable(clazz.cast(creationDate()));
        case "EncryptionKeyArn":
            return Optional.ofNullable(clazz.cast(encryptionKeyArn()));
        case "IamRoleArn":
            return Optional.ofNullable(clazz.cast(iamRoleArn()));
        case "IsEncrypted":
            return Optional.ofNullable(clazz.cast(isEncrypted()));
        case "LastRestoreTime":
            return Optional.ofNullable(clazz.cast(lastRestoreTime()));
        case "Lifecycle":
            return Optional.ofNullable(clazz.cast(lifecycle()));
        case "RecoveryPointArn":
            return Optional.ofNullable(clazz.cast(recoveryPointArn()));
        case "ResourceArn":
            return Optional.ofNullable(clazz.cast(resourceArn()));
        case "ResourceType":
            return Optional.ofNullable(clazz.cast(resourceType()));
        case "SourceBackupVaultArn":
            return Optional.ofNullable(clazz.cast(sourceBackupVaultArn()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        case "StatusMessage":
            return Optional.ofNullable(clazz.cast(statusMessage()));
        case "StorageClass":
            return Optional.ofNullable(clazz.cast(storageClass()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsBackupRecoveryPointDetails, T> g) {
        return obj -> g.apply((AwsBackupRecoveryPointDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsBackupRecoveryPointDetails> {
        /**
         * <p>
         * The size, in bytes, of a backup.
         * </p>
         * 
         * @param backupSizeInBytes
         *        The size, in bytes, of a backup.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backupSizeInBytes(Long backupSizeInBytes);

        /**
         * <p>
         * An Amazon Resource Name (ARN) that uniquely identifies a backup vault.
         * </p>
         * 
         * @param backupVaultArn
         *        An Amazon Resource Name (ARN) that uniquely identifies a backup vault.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backupVaultArn(String backupVaultArn);

        /**
         * <p>
         * The name of a logical container where backups are stored. Backup vaults are identified by names that are
         * unique to the Amazon Web Services account used to create them and the Amazon Web Services Region where they
         * are created. They consist of lowercase letters, numbers, and hyphens.
         * </p>
         * 
         * @param backupVaultName
         *        The name of a logical container where backups are stored. Backup vaults are identified by names that
         *        are unique to the Amazon Web Services account used to create them and the Amazon Web Services Region
         *        where they are created. They consist of lowercase letters, numbers, and hyphens.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backupVaultName(String backupVaultName);

        /**
         * <p>
         * A <code>CalculatedLifecycle</code> object containing <code>DeleteAt</code> and
         * <code>MoveToColdStorageAt</code> timestamps.
         * </p>
         * 
         * @param calculatedLifecycle
         *        A <code>CalculatedLifecycle</code> object containing <code>DeleteAt</code> and
         *        <code>MoveToColdStorageAt</code> timestamps.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder calculatedLifecycle(AwsBackupRecoveryPointCalculatedLifecycleDetails calculatedLifecycle);

        /**
         * <p>
         * A <code>CalculatedLifecycle</code> object containing <code>DeleteAt</code> and
         * <code>MoveToColdStorageAt</code> timestamps.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AwsBackupRecoveryPointCalculatedLifecycleDetails.Builder} avoiding the need to create one manually via
         * {@link AwsBackupRecoveryPointCalculatedLifecycleDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsBackupRecoveryPointCalculatedLifecycleDetails.Builder#build()}
         * is called immediately and its result is passed to
         * {@link #calculatedLifecycle(AwsBackupRecoveryPointCalculatedLifecycleDetails)}.
         * 
         * @param calculatedLifecycle
         *        a consumer that will call methods on {@link AwsBackupRecoveryPointCalculatedLifecycleDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #calculatedLifecycle(AwsBackupRecoveryPointCalculatedLifecycleDetails)
         */
        default Builder calculatedLifecycle(Consumer<AwsBackupRecoveryPointCalculatedLifecycleDetails.Builder> calculatedLifecycle) {
            return calculatedLifecycle(AwsBackupRecoveryPointCalculatedLifecycleDetails.builder()
                    .applyMutation(calculatedLifecycle).build());
        }

        /**
         * <p>
         * The date and time that a job to create a recovery point is completed, in Unix format and UTC. The value of
         * <code>CompletionDate</code> is accurate to milliseconds. For example, the value 1516925490.087 represents
         * Friday, January 26, 2018 12:11:30.087 AM.
         * </p>
         * 
         * @param completionDate
         *        The date and time that a job to create a recovery point is completed, in Unix format and UTC. The
         *        value of <code>CompletionDate</code> is accurate to milliseconds. For example, the value
         *        1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder completionDate(String completionDate);

        /**
         * <p>
         * Contains identifying information about the creation of a recovery point, including the
         * <code>BackupPlanArn</code>, <code>BackupPlanId</code>, <code>BackupPlanVersion</code>, and
         * <code>BackupRuleId</code> of the backup plan that is used to create it.
         * </p>
         * 
         * @param createdBy
         *        Contains identifying information about the creation of a recovery point, including the
         *        <code>BackupPlanArn</code>, <code>BackupPlanId</code>, <code>BackupPlanVersion</code>, and
         *        <code>BackupRuleId</code> of the backup plan that is used to create it.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdBy(AwsBackupRecoveryPointCreatedByDetails createdBy);

        /**
         * <p>
         * Contains identifying information about the creation of a recovery point, including the
         * <code>BackupPlanArn</code>, <code>BackupPlanId</code>, <code>BackupPlanVersion</code>, and
         * <code>BackupRuleId</code> of the backup plan that is used to create it.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AwsBackupRecoveryPointCreatedByDetails.Builder} avoiding the need to create one manually via
         * {@link AwsBackupRecoveryPointCreatedByDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsBackupRecoveryPointCreatedByDetails.Builder#build()} is called
         * immediately and its result is passed to {@link #createdBy(AwsBackupRecoveryPointCreatedByDetails)}.
         * 
         * @param createdBy
         *        a consumer that will call methods on {@link AwsBackupRecoveryPointCreatedByDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #createdBy(AwsBackupRecoveryPointCreatedByDetails)
         */
        default Builder createdBy(Consumer<AwsBackupRecoveryPointCreatedByDetails.Builder> createdBy) {
            return createdBy(AwsBackupRecoveryPointCreatedByDetails.builder().applyMutation(createdBy).build());
        }

        /**
         * <p>
         * The date and time a recovery point is created, in Unix format and UTC. The value of <code>CreationDate</code>
         * is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018
         * 12:11:30.087 AM.
         * </p>
         * 
         * @param creationDate
         *        The date and time a recovery point is created, in Unix format and UTC. The value of
         *        <code>CreationDate</code> is accurate to milliseconds. For example, the value 1516925490.087
         *        represents Friday, January 26, 2018 12:11:30.087 AM.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDate(String creationDate);

        /**
         * <p>
         * The ARN for the server-side encryption key that is used to protect your backups.
         * </p>
         * 
         * @param encryptionKeyArn
         *        The ARN for the server-side encryption key that is used to protect your backups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encryptionKeyArn(String encryptionKeyArn);

        /**
         * <p>
         * Specifies the IAM role ARN used to create the target recovery point
         * </p>
         * 
         * @param iamRoleArn
         *        Specifies the IAM role ARN used to create the target recovery point
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iamRoleArn(String iamRoleArn);

        /**
         * <p>
         * A Boolean value that is returned as <code>TRUE</code> if the specified recovery point is encrypted, or
         * <code>FALSE</code> if the recovery point is not encrypted.
         * </p>
         * 
         * @param isEncrypted
         *        A Boolean value that is returned as <code>TRUE</code> if the specified recovery point is encrypted, or
         *        <code>FALSE</code> if the recovery point is not encrypted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isEncrypted(Boolean isEncrypted);

        /**
         * <p>
         * The date and time that a recovery point was last restored, in Unix format and UTC. The value of
         * <code>LastRestoreTime</code> is accurate to milliseconds. For example, the value 1516925490.087 represents
         * Friday, January 26, 2018 12:11:30.087 AM.
         * </p>
         * 
         * @param lastRestoreTime
         *        The date and time that a recovery point was last restored, in Unix format and UTC. The value of
         *        <code>LastRestoreTime</code> is accurate to milliseconds. For example, the value 1516925490.087
         *        represents Friday, January 26, 2018 12:11:30.087 AM.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastRestoreTime(String lastRestoreTime);

        /**
         * <p>
         * The lifecycle defines when a protected resource is transitioned to cold storage and when it expires. Backup
         * transitions and expires backups automatically according to the lifecycle that you define
         * </p>
         * 
         * @param lifecycle
         *        The lifecycle defines when a protected resource is transitioned to cold storage and when it expires.
         *        Backup transitions and expires backups automatically according to the lifecycle that you define
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lifecycle(AwsBackupRecoveryPointLifecycleDetails lifecycle);

        /**
         * <p>
         * The lifecycle defines when a protected resource is transitioned to cold storage and when it expires. Backup
         * transitions and expires backups automatically according to the lifecycle that you define
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AwsBackupRecoveryPointLifecycleDetails.Builder} avoiding the need to create one manually via
         * {@link AwsBackupRecoveryPointLifecycleDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsBackupRecoveryPointLifecycleDetails.Builder#build()} is called
         * immediately and its result is passed to {@link #lifecycle(AwsBackupRecoveryPointLifecycleDetails)}.
         * 
         * @param lifecycle
         *        a consumer that will call methods on {@link AwsBackupRecoveryPointLifecycleDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lifecycle(AwsBackupRecoveryPointLifecycleDetails)
         */
        default Builder lifecycle(Consumer<AwsBackupRecoveryPointLifecycleDetails.Builder> lifecycle) {
            return lifecycle(AwsBackupRecoveryPointLifecycleDetails.builder().applyMutation(lifecycle).build());
        }

        /**
         * <p>
         * An ARN that uniquely identifies a recovery point.
         * </p>
         * 
         * @param recoveryPointArn
         *        An ARN that uniquely identifies a recovery point.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recoveryPointArn(String recoveryPointArn);

        /**
         * <p>
         * An ARN that uniquely identifies a resource. The format of the ARN depends on the resource type.
         * </p>
         * 
         * @param resourceArn
         *        An ARN that uniquely identifies a resource. The format of the ARN depends on the resource type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceArn(String resourceArn);

        /**
         * <p>
         * The type of Amazon Web Services resource saved as a recovery point, such as an Amazon EBS volume or an Amazon
         * RDS database.
         * </p>
         * 
         * @param resourceType
         *        The type of Amazon Web Services resource saved as a recovery point, such as an Amazon EBS volume or an
         *        Amazon RDS database.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceType(String resourceType);

        /**
         * <p>
         * The ARN for the backup vault where the recovery point was originally copied from. If the recovery point is
         * restored to the same account, this value will be null.
         * </p>
         * 
         * @param sourceBackupVaultArn
         *        The ARN for the backup vault where the recovery point was originally copied from. If the recovery
         *        point is restored to the same account, this value will be null.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceBackupVaultArn(String sourceBackupVaultArn);

        /**
         * <p>
         * A status code specifying the state of the recovery point. Valid values are as follows:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>COMPLETED</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DELETING</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>EXPIRED</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PARTIAL</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        A status code specifying the state of the recovery point. Valid values are as follows:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>COMPLETED</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DELETING</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>EXPIRED</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PARTIAL</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * A message explaining the reason of the recovery point deletion failure.
         * </p>
         * 
         * @param statusMessage
         *        A message explaining the reason of the recovery point deletion failure.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusMessage(String statusMessage);

        /**
         * <p>
         * Specifies the storage class of the recovery point. Valid values are as follows:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>COLD</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DELETED</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>WARM</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param storageClass
         *        Specifies the storage class of the recovery point. Valid values are as follows:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>COLD</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DELETED</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>WARM</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageClass(String storageClass);
    }

    static final class BuilderImpl implements Builder {
        private Long backupSizeInBytes;

        private String backupVaultArn;

        private String backupVaultName;

        private AwsBackupRecoveryPointCalculatedLifecycleDetails calculatedLifecycle;

        private String completionDate;

        private AwsBackupRecoveryPointCreatedByDetails createdBy;

        private String creationDate;

        private String encryptionKeyArn;

        private String iamRoleArn;

        private Boolean isEncrypted;

        private String lastRestoreTime;

        private AwsBackupRecoveryPointLifecycleDetails lifecycle;

        private String recoveryPointArn;

        private String resourceArn;

        private String resourceType;

        private String sourceBackupVaultArn;

        private String status;

        private String statusMessage;

        private String storageClass;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsBackupRecoveryPointDetails model) {
            backupSizeInBytes(model.backupSizeInBytes);
            backupVaultArn(model.backupVaultArn);
            backupVaultName(model.backupVaultName);
            calculatedLifecycle(model.calculatedLifecycle);
            completionDate(model.completionDate);
            createdBy(model.createdBy);
            creationDate(model.creationDate);
            encryptionKeyArn(model.encryptionKeyArn);
            iamRoleArn(model.iamRoleArn);
            isEncrypted(model.isEncrypted);
            lastRestoreTime(model.lastRestoreTime);
            lifecycle(model.lifecycle);
            recoveryPointArn(model.recoveryPointArn);
            resourceArn(model.resourceArn);
            resourceType(model.resourceType);
            sourceBackupVaultArn(model.sourceBackupVaultArn);
            status(model.status);
            statusMessage(model.statusMessage);
            storageClass(model.storageClass);
        }

        public final Long getBackupSizeInBytes() {
            return backupSizeInBytes;
        }

        public final void setBackupSizeInBytes(Long backupSizeInBytes) {
            this.backupSizeInBytes = backupSizeInBytes;
        }

        @Override
        public final Builder backupSizeInBytes(Long backupSizeInBytes) {
            this.backupSizeInBytes = backupSizeInBytes;
            return this;
        }

        public final String getBackupVaultArn() {
            return backupVaultArn;
        }

        public final void setBackupVaultArn(String backupVaultArn) {
            this.backupVaultArn = backupVaultArn;
        }

        @Override
        public final Builder backupVaultArn(String backupVaultArn) {
            this.backupVaultArn = backupVaultArn;
            return this;
        }

        public final String getBackupVaultName() {
            return backupVaultName;
        }

        public final void setBackupVaultName(String backupVaultName) {
            this.backupVaultName = backupVaultName;
        }

        @Override
        public final Builder backupVaultName(String backupVaultName) {
            this.backupVaultName = backupVaultName;
            return this;
        }

        public final AwsBackupRecoveryPointCalculatedLifecycleDetails.Builder getCalculatedLifecycle() {
            return calculatedLifecycle != null ? calculatedLifecycle.toBuilder() : null;
        }

        public final void setCalculatedLifecycle(AwsBackupRecoveryPointCalculatedLifecycleDetails.BuilderImpl calculatedLifecycle) {
            this.calculatedLifecycle = calculatedLifecycle != null ? calculatedLifecycle.build() : null;
        }

        @Override
        public final Builder calculatedLifecycle(AwsBackupRecoveryPointCalculatedLifecycleDetails calculatedLifecycle) {
            this.calculatedLifecycle = calculatedLifecycle;
            return this;
        }

        public final String getCompletionDate() {
            return completionDate;
        }

        public final void setCompletionDate(String completionDate) {
            this.completionDate = completionDate;
        }

        @Override
        public final Builder completionDate(String completionDate) {
            this.completionDate = completionDate;
            return this;
        }

        public final AwsBackupRecoveryPointCreatedByDetails.Builder getCreatedBy() {
            return createdBy != null ? createdBy.toBuilder() : null;
        }

        public final void setCreatedBy(AwsBackupRecoveryPointCreatedByDetails.BuilderImpl createdBy) {
            this.createdBy = createdBy != null ? createdBy.build() : null;
        }

        @Override
        public final Builder createdBy(AwsBackupRecoveryPointCreatedByDetails createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final String getCreationDate() {
            return creationDate;
        }

        public final void setCreationDate(String creationDate) {
            this.creationDate = creationDate;
        }

        @Override
        public final Builder creationDate(String creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final String getEncryptionKeyArn() {
            return encryptionKeyArn;
        }

        public final void setEncryptionKeyArn(String encryptionKeyArn) {
            this.encryptionKeyArn = encryptionKeyArn;
        }

        @Override
        public final Builder encryptionKeyArn(String encryptionKeyArn) {
            this.encryptionKeyArn = encryptionKeyArn;
            return this;
        }

        public final String getIamRoleArn() {
            return iamRoleArn;
        }

        public final void setIamRoleArn(String iamRoleArn) {
            this.iamRoleArn = iamRoleArn;
        }

        @Override
        public final Builder iamRoleArn(String iamRoleArn) {
            this.iamRoleArn = iamRoleArn;
            return this;
        }

        public final Boolean getIsEncrypted() {
            return isEncrypted;
        }

        public final void setIsEncrypted(Boolean isEncrypted) {
            this.isEncrypted = isEncrypted;
        }

        @Override
        public final Builder isEncrypted(Boolean isEncrypted) {
            this.isEncrypted = isEncrypted;
            return this;
        }

        public final String getLastRestoreTime() {
            return lastRestoreTime;
        }

        public final void setLastRestoreTime(String lastRestoreTime) {
            this.lastRestoreTime = lastRestoreTime;
        }

        @Override
        public final Builder lastRestoreTime(String lastRestoreTime) {
            this.lastRestoreTime = lastRestoreTime;
            return this;
        }

        public final AwsBackupRecoveryPointLifecycleDetails.Builder getLifecycle() {
            return lifecycle != null ? lifecycle.toBuilder() : null;
        }

        public final void setLifecycle(AwsBackupRecoveryPointLifecycleDetails.BuilderImpl lifecycle) {
            this.lifecycle = lifecycle != null ? lifecycle.build() : null;
        }

        @Override
        public final Builder lifecycle(AwsBackupRecoveryPointLifecycleDetails lifecycle) {
            this.lifecycle = lifecycle;
            return this;
        }

        public final String getRecoveryPointArn() {
            return recoveryPointArn;
        }

        public final void setRecoveryPointArn(String recoveryPointArn) {
            this.recoveryPointArn = recoveryPointArn;
        }

        @Override
        public final Builder recoveryPointArn(String recoveryPointArn) {
            this.recoveryPointArn = recoveryPointArn;
            return this;
        }

        public final String getResourceArn() {
            return resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final String getResourceType() {
            return resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public final String getSourceBackupVaultArn() {
            return sourceBackupVaultArn;
        }

        public final void setSourceBackupVaultArn(String sourceBackupVaultArn) {
            this.sourceBackupVaultArn = sourceBackupVaultArn;
        }

        @Override
        public final Builder sourceBackupVaultArn(String sourceBackupVaultArn) {
            this.sourceBackupVaultArn = sourceBackupVaultArn;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final String getStatusMessage() {
            return statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final String getStorageClass() {
            return storageClass;
        }

        public final void setStorageClass(String storageClass) {
            this.storageClass = storageClass;
        }

        @Override
        public final Builder storageClass(String storageClass) {
            this.storageClass = storageClass;
            return this;
        }

        @Override
        public AwsBackupRecoveryPointDetails build() {
            return new AwsBackupRecoveryPointDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
