/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information about the billing for read/write capacity on the table.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsDynamoDbTableBillingModeSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsDynamoDbTableBillingModeSummary.Builder, AwsDynamoDbTableBillingModeSummary> {
    private static final SdkField<String> BILLING_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BillingMode").getter(getter(AwsDynamoDbTableBillingModeSummary::billingMode))
            .setter(setter(Builder::billingMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BillingMode").build()).build();

    private static final SdkField<String> LAST_UPDATE_TO_PAY_PER_REQUEST_DATE_TIME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("LastUpdateToPayPerRequestDateTime")
            .getter(getter(AwsDynamoDbTableBillingModeSummary::lastUpdateToPayPerRequestDateTime))
            .setter(setter(Builder::lastUpdateToPayPerRequestDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdateToPayPerRequestDateTime")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BILLING_MODE_FIELD,
            LAST_UPDATE_TO_PAY_PER_REQUEST_DATE_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String billingMode;

    private final String lastUpdateToPayPerRequestDateTime;

    private AwsDynamoDbTableBillingModeSummary(BuilderImpl builder) {
        this.billingMode = builder.billingMode;
        this.lastUpdateToPayPerRequestDateTime = builder.lastUpdateToPayPerRequestDateTime;
    }

    /**
     * <p>
     * The method used to charge for read and write throughput and to manage capacity.
     * </p>
     * 
     * @return The method used to charge for read and write throughput and to manage capacity.
     */
    public final String billingMode() {
        return billingMode;
    }

    /**
     * <p>
     * If the billing mode is <code>PAY_PER_REQUEST</code>, indicates when the billing mode was set to that value.
     * </p>
     * <p>
     * This field accepts only the specified formats. Timestamps can end with <code>Z</code> or
     * <code>("+" / "-") time-hour [":" time-minute]</code>. The time-secfrac after seconds is limited to a maximum of 9
     * digits. The offset is bounded by +/-18:00. Here are valid timestamp formats with examples:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>YYYY-MM-DDTHH:MM:SSZ</code> (for example, <code>2019-01-31T23:00:00Z</code>)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ</code> (for example, <code>2019-01-31T23:00:00.123456789Z</code>)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>YYYY-MM-DDTHH:MM:SS+HH:MM</code> (for example, <code>2024-01-04T15:25:10+17:59</code>)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>YYYY-MM-DDTHH:MM:SS-HHMM</code> (for example, <code>2024-01-04T15:25:10-1759</code>)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM</code> (for example, <code>2024-01-04T15:25:10.123456789+17:59</code>)
     * </p>
     * </li>
     * </ul>
     * 
     * @return If the billing mode is <code>PAY_PER_REQUEST</code>, indicates when the billing mode was set to that
     *         value.</p>
     *         <p>
     *         This field accepts only the specified formats. Timestamps can end with <code>Z</code> or
     *         <code>("+" / "-") time-hour [":" time-minute]</code>. The time-secfrac after seconds is limited to a
     *         maximum of 9 digits. The offset is bounded by +/-18:00. Here are valid timestamp formats with examples:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>YYYY-MM-DDTHH:MM:SSZ</code> (for example, <code>2019-01-31T23:00:00Z</code>)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ</code> (for example, <code>2019-01-31T23:00:00.123456789Z</code>)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>YYYY-MM-DDTHH:MM:SS+HH:MM</code> (for example, <code>2024-01-04T15:25:10+17:59</code>)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>YYYY-MM-DDTHH:MM:SS-HHMM</code> (for example, <code>2024-01-04T15:25:10-1759</code>)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM</code> (for example,
     *         <code>2024-01-04T15:25:10.123456789+17:59</code>)
     *         </p>
     *         </li>
     */
    public final String lastUpdateToPayPerRequestDateTime() {
        return lastUpdateToPayPerRequestDateTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(billingMode());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdateToPayPerRequestDateTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsDynamoDbTableBillingModeSummary)) {
            return false;
        }
        AwsDynamoDbTableBillingModeSummary other = (AwsDynamoDbTableBillingModeSummary) obj;
        return Objects.equals(billingMode(), other.billingMode())
                && Objects.equals(lastUpdateToPayPerRequestDateTime(), other.lastUpdateToPayPerRequestDateTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsDynamoDbTableBillingModeSummary").add("BillingMode", billingMode())
                .add("LastUpdateToPayPerRequestDateTime", lastUpdateToPayPerRequestDateTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BillingMode":
            return Optional.ofNullable(clazz.cast(billingMode()));
        case "LastUpdateToPayPerRequestDateTime":
            return Optional.ofNullable(clazz.cast(lastUpdateToPayPerRequestDateTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsDynamoDbTableBillingModeSummary, T> g) {
        return obj -> g.apply((AwsDynamoDbTableBillingModeSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsDynamoDbTableBillingModeSummary> {
        /**
         * <p>
         * The method used to charge for read and write throughput and to manage capacity.
         * </p>
         * 
         * @param billingMode
         *        The method used to charge for read and write throughput and to manage capacity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder billingMode(String billingMode);

        /**
         * <p>
         * If the billing mode is <code>PAY_PER_REQUEST</code>, indicates when the billing mode was set to that value.
         * </p>
         * <p>
         * This field accepts only the specified formats. Timestamps can end with <code>Z</code> or
         * <code>("+" / "-") time-hour [":" time-minute]</code>. The time-secfrac after seconds is limited to a maximum
         * of 9 digits. The offset is bounded by +/-18:00. Here are valid timestamp formats with examples:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>YYYY-MM-DDTHH:MM:SSZ</code> (for example, <code>2019-01-31T23:00:00Z</code>)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ</code> (for example, <code>2019-01-31T23:00:00.123456789Z</code>)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>YYYY-MM-DDTHH:MM:SS+HH:MM</code> (for example, <code>2024-01-04T15:25:10+17:59</code>)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>YYYY-MM-DDTHH:MM:SS-HHMM</code> (for example, <code>2024-01-04T15:25:10-1759</code>)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM</code> (for example,
         * <code>2024-01-04T15:25:10.123456789+17:59</code>)
         * </p>
         * </li>
         * </ul>
         * 
         * @param lastUpdateToPayPerRequestDateTime
         *        If the billing mode is <code>PAY_PER_REQUEST</code>, indicates when the billing mode was set to that
         *        value.</p>
         *        <p>
         *        This field accepts only the specified formats. Timestamps can end with <code>Z</code> or
         *        <code>("+" / "-") time-hour [":" time-minute]</code>. The time-secfrac after seconds is limited to a
         *        maximum of 9 digits. The offset is bounded by +/-18:00. Here are valid timestamp formats with
         *        examples:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>YYYY-MM-DDTHH:MM:SSZ</code> (for example, <code>2019-01-31T23:00:00Z</code>)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ</code> (for example, <code>2019-01-31T23:00:00.123456789Z</code>)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>YYYY-MM-DDTHH:MM:SS+HH:MM</code> (for example, <code>2024-01-04T15:25:10+17:59</code>)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>YYYY-MM-DDTHH:MM:SS-HHMM</code> (for example, <code>2024-01-04T15:25:10-1759</code>)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM</code> (for example,
         *        <code>2024-01-04T15:25:10.123456789+17:59</code>)
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdateToPayPerRequestDateTime(String lastUpdateToPayPerRequestDateTime);
    }

    static final class BuilderImpl implements Builder {
        private String billingMode;

        private String lastUpdateToPayPerRequestDateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsDynamoDbTableBillingModeSummary model) {
            billingMode(model.billingMode);
            lastUpdateToPayPerRequestDateTime(model.lastUpdateToPayPerRequestDateTime);
        }

        public final String getBillingMode() {
            return billingMode;
        }

        public final void setBillingMode(String billingMode) {
            this.billingMode = billingMode;
        }

        @Override
        public final Builder billingMode(String billingMode) {
            this.billingMode = billingMode;
            return this;
        }

        public final String getLastUpdateToPayPerRequestDateTime() {
            return lastUpdateToPayPerRequestDateTime;
        }

        public final void setLastUpdateToPayPerRequestDateTime(String lastUpdateToPayPerRequestDateTime) {
            this.lastUpdateToPayPerRequestDateTime = lastUpdateToPayPerRequestDateTime;
        }

        @Override
        public final Builder lastUpdateToPayPerRequestDateTime(String lastUpdateToPayPerRequestDateTime) {
            this.lastUpdateToPayPerRequestDateTime = lastUpdateToPayPerRequestDateTime;
            return this;
        }

        @Override
        public AwsDynamoDbTableBillingModeSummary build() {
            return new AwsDynamoDbTableBillingModeSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
