/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * IAM access key details related to a finding.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsIamAccessKeyDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsIamAccessKeyDetails.Builder, AwsIamAccessKeyDetails> {
    private static final SdkField<String> USER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UserName").getter(getter(AwsIamAccessKeyDetails::userName)).setter(setter(Builder::userName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserName").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(AwsIamAccessKeyDetails::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> CREATED_AT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CreatedAt").getter(getter(AwsIamAccessKeyDetails::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()).build();

    private static final SdkField<String> PRINCIPAL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PrincipalId").getter(getter(AwsIamAccessKeyDetails::principalId)).setter(setter(Builder::principalId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrincipalId").build()).build();

    private static final SdkField<String> PRINCIPAL_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PrincipalType").getter(getter(AwsIamAccessKeyDetails::principalType))
            .setter(setter(Builder::principalType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrincipalType").build()).build();

    private static final SdkField<String> PRINCIPAL_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PrincipalName").getter(getter(AwsIamAccessKeyDetails::principalName))
            .setter(setter(Builder::principalName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrincipalName").build()).build();

    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AccountId").getter(getter(AwsIamAccessKeyDetails::accountId)).setter(setter(Builder::accountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountId").build()).build();

    private static final SdkField<String> ACCESS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AccessKeyId").getter(getter(AwsIamAccessKeyDetails::accessKeyId)).setter(setter(Builder::accessKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessKeyId").build()).build();

    private static final SdkField<AwsIamAccessKeySessionContext> SESSION_CONTEXT_FIELD = SdkField
            .<AwsIamAccessKeySessionContext> builder(MarshallingType.SDK_POJO).memberName("SessionContext")
            .getter(getter(AwsIamAccessKeyDetails::sessionContext)).setter(setter(Builder::sessionContext))
            .constructor(AwsIamAccessKeySessionContext::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SessionContext").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_NAME_FIELD, STATUS_FIELD,
            CREATED_AT_FIELD, PRINCIPAL_ID_FIELD, PRINCIPAL_TYPE_FIELD, PRINCIPAL_NAME_FIELD, ACCOUNT_ID_FIELD,
            ACCESS_KEY_ID_FIELD, SESSION_CONTEXT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String userName;

    private final String status;

    private final String createdAt;

    private final String principalId;

    private final String principalType;

    private final String principalName;

    private final String accountId;

    private final String accessKeyId;

    private final AwsIamAccessKeySessionContext sessionContext;

    private AwsIamAccessKeyDetails(BuilderImpl builder) {
        this.userName = builder.userName;
        this.status = builder.status;
        this.createdAt = builder.createdAt;
        this.principalId = builder.principalId;
        this.principalType = builder.principalType;
        this.principalName = builder.principalName;
        this.accountId = builder.accountId;
        this.accessKeyId = builder.accessKeyId;
        this.sessionContext = builder.sessionContext;
    }

    /**
     * <p>
     * The user associated with the IAM access key related to a finding.
     * </p>
     * <p>
     * The <code>UserName</code> parameter has been replaced with the <code>PrincipalName</code> parameter because
     * access keys can also be assigned to principals that are not IAM users.
     * </p>
     * 
     * @return The user associated with the IAM access key related to a finding.</p>
     *         <p>
     *         The <code>UserName</code> parameter has been replaced with the <code>PrincipalName</code> parameter
     *         because access keys can also be assigned to principals that are not IAM users.
     * @deprecated This filter is deprecated. Instead, use PrincipalName.
     */
    @Deprecated
    public final String userName() {
        return userName;
    }

    /**
     * <p>
     * The status of the IAM access key related to a finding.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link AwsIamAccessKeyStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the IAM access key related to a finding.
     * @see AwsIamAccessKeyStatus
     */
    public final AwsIamAccessKeyStatus status() {
        return AwsIamAccessKeyStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the IAM access key related to a finding.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link AwsIamAccessKeyStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the IAM access key related to a finding.
     * @see AwsIamAccessKeyStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * Indicates when the IAM access key was created.
     * </p>
     * <p>
     * This field accepts only the specified formats. Timestamps can end with <code>Z</code> or
     * <code>("+" / "-") time-hour [":" time-minute]</code>. The time-secfrac after seconds is limited to a maximum of 9
     * digits. The offset is bounded by +/-18:00. Here are valid timestamp formats with examples:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>YYYY-MM-DDTHH:MM:SSZ</code> (for example, <code>2019-01-31T23:00:00Z</code>)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ</code> (for example, <code>2019-01-31T23:00:00.123456789Z</code>)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>YYYY-MM-DDTHH:MM:SS+HH:MM</code> (for example, <code>2024-01-04T15:25:10+17:59</code>)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>YYYY-MM-DDTHH:MM:SS-HHMM</code> (for example, <code>2024-01-04T15:25:10-1759</code>)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM</code> (for example, <code>2024-01-04T15:25:10.123456789+17:59</code>)
     * </p>
     * </li>
     * </ul>
     * 
     * @return Indicates when the IAM access key was created.</p>
     *         <p>
     *         This field accepts only the specified formats. Timestamps can end with <code>Z</code> or
     *         <code>("+" / "-") time-hour [":" time-minute]</code>. The time-secfrac after seconds is limited to a
     *         maximum of 9 digits. The offset is bounded by +/-18:00. Here are valid timestamp formats with examples:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>YYYY-MM-DDTHH:MM:SSZ</code> (for example, <code>2019-01-31T23:00:00Z</code>)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ</code> (for example, <code>2019-01-31T23:00:00.123456789Z</code>)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>YYYY-MM-DDTHH:MM:SS+HH:MM</code> (for example, <code>2024-01-04T15:25:10+17:59</code>)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>YYYY-MM-DDTHH:MM:SS-HHMM</code> (for example, <code>2024-01-04T15:25:10-1759</code>)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM</code> (for example,
     *         <code>2024-01-04T15:25:10.123456789+17:59</code>)
     *         </p>
     *         </li>
     */
    public final String createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The ID of the principal associated with an access key.
     * </p>
     * 
     * @return The ID of the principal associated with an access key.
     */
    public final String principalId() {
        return principalId;
    }

    /**
     * <p>
     * The type of principal associated with an access key.
     * </p>
     * 
     * @return The type of principal associated with an access key.
     */
    public final String principalType() {
        return principalType;
    }

    /**
     * <p>
     * The name of the principal.
     * </p>
     * 
     * @return The name of the principal.
     */
    public final String principalName() {
        return principalName;
    }

    /**
     * <p>
     * The Amazon Web Services account ID of the account for the key.
     * </p>
     * 
     * @return The Amazon Web Services account ID of the account for the key.
     */
    public final String accountId() {
        return accountId;
    }

    /**
     * <p>
     * The identifier of the access key.
     * </p>
     * 
     * @return The identifier of the access key.
     */
    public final String accessKeyId() {
        return accessKeyId;
    }

    /**
     * <p>
     * Information about the session that the key was used for.
     * </p>
     * 
     * @return Information about the session that the key was used for.
     */
    public final AwsIamAccessKeySessionContext sessionContext() {
        return sessionContext;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(userName());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(principalId());
        hashCode = 31 * hashCode + Objects.hashCode(principalType());
        hashCode = 31 * hashCode + Objects.hashCode(principalName());
        hashCode = 31 * hashCode + Objects.hashCode(accountId());
        hashCode = 31 * hashCode + Objects.hashCode(accessKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(sessionContext());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsIamAccessKeyDetails)) {
            return false;
        }
        AwsIamAccessKeyDetails other = (AwsIamAccessKeyDetails) obj;
        return Objects.equals(userName(), other.userName()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(createdAt(), other.createdAt()) && Objects.equals(principalId(), other.principalId())
                && Objects.equals(principalType(), other.principalType())
                && Objects.equals(principalName(), other.principalName()) && Objects.equals(accountId(), other.accountId())
                && Objects.equals(accessKeyId(), other.accessKeyId()) && Objects.equals(sessionContext(), other.sessionContext());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsIamAccessKeyDetails").add("UserName", userName()).add("Status", statusAsString())
                .add("CreatedAt", createdAt()).add("PrincipalId", principalId()).add("PrincipalType", principalType())
                .add("PrincipalName", principalName()).add("AccountId", accountId()).add("AccessKeyId", accessKeyId())
                .add("SessionContext", sessionContext()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "UserName":
            return Optional.ofNullable(clazz.cast(userName()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "CreatedAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "PrincipalId":
            return Optional.ofNullable(clazz.cast(principalId()));
        case "PrincipalType":
            return Optional.ofNullable(clazz.cast(principalType()));
        case "PrincipalName":
            return Optional.ofNullable(clazz.cast(principalName()));
        case "AccountId":
            return Optional.ofNullable(clazz.cast(accountId()));
        case "AccessKeyId":
            return Optional.ofNullable(clazz.cast(accessKeyId()));
        case "SessionContext":
            return Optional.ofNullable(clazz.cast(sessionContext()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsIamAccessKeyDetails, T> g) {
        return obj -> g.apply((AwsIamAccessKeyDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsIamAccessKeyDetails> {
        /**
         * <p>
         * The user associated with the IAM access key related to a finding.
         * </p>
         * <p>
         * The <code>UserName</code> parameter has been replaced with the <code>PrincipalName</code> parameter because
         * access keys can also be assigned to principals that are not IAM users.
         * </p>
         * 
         * @param userName
         *        The user associated with the IAM access key related to a finding.</p>
         *        <p>
         *        The <code>UserName</code> parameter has been replaced with the <code>PrincipalName</code> parameter
         *        because access keys can also be assigned to principals that are not IAM users.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @deprecated This filter is deprecated. Instead, use PrincipalName.
         */
        @Deprecated
        Builder userName(String userName);

        /**
         * <p>
         * The status of the IAM access key related to a finding.
         * </p>
         * 
         * @param status
         *        The status of the IAM access key related to a finding.
         * @see AwsIamAccessKeyStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AwsIamAccessKeyStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the IAM access key related to a finding.
         * </p>
         * 
         * @param status
         *        The status of the IAM access key related to a finding.
         * @see AwsIamAccessKeyStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AwsIamAccessKeyStatus
         */
        Builder status(AwsIamAccessKeyStatus status);

        /**
         * <p>
         * Indicates when the IAM access key was created.
         * </p>
         * <p>
         * This field accepts only the specified formats. Timestamps can end with <code>Z</code> or
         * <code>("+" / "-") time-hour [":" time-minute]</code>. The time-secfrac after seconds is limited to a maximum
         * of 9 digits. The offset is bounded by +/-18:00. Here are valid timestamp formats with examples:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>YYYY-MM-DDTHH:MM:SSZ</code> (for example, <code>2019-01-31T23:00:00Z</code>)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ</code> (for example, <code>2019-01-31T23:00:00.123456789Z</code>)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>YYYY-MM-DDTHH:MM:SS+HH:MM</code> (for example, <code>2024-01-04T15:25:10+17:59</code>)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>YYYY-MM-DDTHH:MM:SS-HHMM</code> (for example, <code>2024-01-04T15:25:10-1759</code>)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM</code> (for example,
         * <code>2024-01-04T15:25:10.123456789+17:59</code>)
         * </p>
         * </li>
         * </ul>
         * 
         * @param createdAt
         *        Indicates when the IAM access key was created.</p>
         *        <p>
         *        This field accepts only the specified formats. Timestamps can end with <code>Z</code> or
         *        <code>("+" / "-") time-hour [":" time-minute]</code>. The time-secfrac after seconds is limited to a
         *        maximum of 9 digits. The offset is bounded by +/-18:00. Here are valid timestamp formats with
         *        examples:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>YYYY-MM-DDTHH:MM:SSZ</code> (for example, <code>2019-01-31T23:00:00Z</code>)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ</code> (for example, <code>2019-01-31T23:00:00.123456789Z</code>)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>YYYY-MM-DDTHH:MM:SS+HH:MM</code> (for example, <code>2024-01-04T15:25:10+17:59</code>)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>YYYY-MM-DDTHH:MM:SS-HHMM</code> (for example, <code>2024-01-04T15:25:10-1759</code>)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM</code> (for example,
         *        <code>2024-01-04T15:25:10.123456789+17:59</code>)
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(String createdAt);

        /**
         * <p>
         * The ID of the principal associated with an access key.
         * </p>
         * 
         * @param principalId
         *        The ID of the principal associated with an access key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder principalId(String principalId);

        /**
         * <p>
         * The type of principal associated with an access key.
         * </p>
         * 
         * @param principalType
         *        The type of principal associated with an access key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder principalType(String principalType);

        /**
         * <p>
         * The name of the principal.
         * </p>
         * 
         * @param principalName
         *        The name of the principal.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder principalName(String principalName);

        /**
         * <p>
         * The Amazon Web Services account ID of the account for the key.
         * </p>
         * 
         * @param accountId
         *        The Amazon Web Services account ID of the account for the key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(String accountId);

        /**
         * <p>
         * The identifier of the access key.
         * </p>
         * 
         * @param accessKeyId
         *        The identifier of the access key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessKeyId(String accessKeyId);

        /**
         * <p>
         * Information about the session that the key was used for.
         * </p>
         * 
         * @param sessionContext
         *        Information about the session that the key was used for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionContext(AwsIamAccessKeySessionContext sessionContext);

        /**
         * <p>
         * Information about the session that the key was used for.
         * </p>
         * This is a convenience method that creates an instance of the {@link AwsIamAccessKeySessionContext.Builder}
         * avoiding the need to create one manually via {@link AwsIamAccessKeySessionContext#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsIamAccessKeySessionContext.Builder#build()} is called
         * immediately and its result is passed to {@link #sessionContext(AwsIamAccessKeySessionContext)}.
         * 
         * @param sessionContext
         *        a consumer that will call methods on {@link AwsIamAccessKeySessionContext.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sessionContext(AwsIamAccessKeySessionContext)
         */
        default Builder sessionContext(Consumer<AwsIamAccessKeySessionContext.Builder> sessionContext) {
            return sessionContext(AwsIamAccessKeySessionContext.builder().applyMutation(sessionContext).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String userName;

        private String status;

        private String createdAt;

        private String principalId;

        private String principalType;

        private String principalName;

        private String accountId;

        private String accessKeyId;

        private AwsIamAccessKeySessionContext sessionContext;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsIamAccessKeyDetails model) {
            userName(model.userName);
            status(model.status);
            createdAt(model.createdAt);
            principalId(model.principalId);
            principalType(model.principalType);
            principalName(model.principalName);
            accountId(model.accountId);
            accessKeyId(model.accessKeyId);
            sessionContext(model.sessionContext);
        }

        @Deprecated
        public final String getUserName() {
            return userName;
        }

        @Deprecated
        public final void setUserName(String userName) {
            this.userName = userName;
        }

        @Override
        @Deprecated
        public final Builder userName(String userName) {
            this.userName = userName;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(AwsIamAccessKeyStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(String createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(String createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getPrincipalId() {
            return principalId;
        }

        public final void setPrincipalId(String principalId) {
            this.principalId = principalId;
        }

        @Override
        public final Builder principalId(String principalId) {
            this.principalId = principalId;
            return this;
        }

        public final String getPrincipalType() {
            return principalType;
        }

        public final void setPrincipalType(String principalType) {
            this.principalType = principalType;
        }

        @Override
        public final Builder principalType(String principalType) {
            this.principalType = principalType;
            return this;
        }

        public final String getPrincipalName() {
            return principalName;
        }

        public final void setPrincipalName(String principalName) {
            this.principalName = principalName;
        }

        @Override
        public final Builder principalName(String principalName) {
            this.principalName = principalName;
            return this;
        }

        public final String getAccountId() {
            return accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final String getAccessKeyId() {
            return accessKeyId;
        }

        public final void setAccessKeyId(String accessKeyId) {
            this.accessKeyId = accessKeyId;
        }

        @Override
        public final Builder accessKeyId(String accessKeyId) {
            this.accessKeyId = accessKeyId;
            return this;
        }

        public final AwsIamAccessKeySessionContext.Builder getSessionContext() {
            return sessionContext != null ? sessionContext.toBuilder() : null;
        }

        public final void setSessionContext(AwsIamAccessKeySessionContext.BuilderImpl sessionContext) {
            this.sessionContext = sessionContext != null ? sessionContext.build() : null;
        }

        @Override
        public final Builder sessionContext(AwsIamAccessKeySessionContext sessionContext) {
            this.sessionContext = sessionContext;
            return this;
        }

        @Override
        public AwsIamAccessKeyDetails build() {
            return new AwsIamAccessKeyDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
