/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents an IAM permissions policy.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsIamPolicyDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsIamPolicyDetails.Builder, AwsIamPolicyDetails> {
    private static final SdkField<Integer> ATTACHMENT_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("AttachmentCount").getter(getter(AwsIamPolicyDetails::attachmentCount))
            .setter(setter(Builder::attachmentCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttachmentCount").build()).build();

    private static final SdkField<String> CREATE_DATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CreateDate").getter(getter(AwsIamPolicyDetails::createDate)).setter(setter(Builder::createDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateDate").build()).build();

    private static final SdkField<String> DEFAULT_VERSION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DefaultVersionId").getter(getter(AwsIamPolicyDetails::defaultVersionId))
            .setter(setter(Builder::defaultVersionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultVersionId").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(AwsIamPolicyDetails::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<Boolean> IS_ATTACHABLE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IsAttachable").getter(getter(AwsIamPolicyDetails::isAttachable)).setter(setter(Builder::isAttachable))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsAttachable").build()).build();

    private static final SdkField<String> PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Path")
            .getter(getter(AwsIamPolicyDetails::path)).setter(setter(Builder::path))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Path").build()).build();

    private static final SdkField<Integer> PERMISSIONS_BOUNDARY_USAGE_COUNT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("PermissionsBoundaryUsageCount")
            .getter(getter(AwsIamPolicyDetails::permissionsBoundaryUsageCount))
            .setter(setter(Builder::permissionsBoundaryUsageCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PermissionsBoundaryUsageCount")
                    .build()).build();

    private static final SdkField<String> POLICY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PolicyId").getter(getter(AwsIamPolicyDetails::policyId)).setter(setter(Builder::policyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyId").build()).build();

    private static final SdkField<String> POLICY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PolicyName").getter(getter(AwsIamPolicyDetails::policyName)).setter(setter(Builder::policyName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyName").build()).build();

    private static final SdkField<List<AwsIamPolicyVersion>> POLICY_VERSION_LIST_FIELD = SdkField
            .<List<AwsIamPolicyVersion>> builder(MarshallingType.LIST)
            .memberName("PolicyVersionList")
            .getter(getter(AwsIamPolicyDetails::policyVersionList))
            .setter(setter(Builder::policyVersionList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyVersionList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AwsIamPolicyVersion> builder(MarshallingType.SDK_POJO)
                                            .constructor(AwsIamPolicyVersion::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> UPDATE_DATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UpdateDate").getter(getter(AwsIamPolicyDetails::updateDate)).setter(setter(Builder::updateDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdateDate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTACHMENT_COUNT_FIELD,
            CREATE_DATE_FIELD, DEFAULT_VERSION_ID_FIELD, DESCRIPTION_FIELD, IS_ATTACHABLE_FIELD, PATH_FIELD,
            PERMISSIONS_BOUNDARY_USAGE_COUNT_FIELD, POLICY_ID_FIELD, POLICY_NAME_FIELD, POLICY_VERSION_LIST_FIELD,
            UPDATE_DATE_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer attachmentCount;

    private final String createDate;

    private final String defaultVersionId;

    private final String description;

    private final Boolean isAttachable;

    private final String path;

    private final Integer permissionsBoundaryUsageCount;

    private final String policyId;

    private final String policyName;

    private final List<AwsIamPolicyVersion> policyVersionList;

    private final String updateDate;

    private AwsIamPolicyDetails(BuilderImpl builder) {
        this.attachmentCount = builder.attachmentCount;
        this.createDate = builder.createDate;
        this.defaultVersionId = builder.defaultVersionId;
        this.description = builder.description;
        this.isAttachable = builder.isAttachable;
        this.path = builder.path;
        this.permissionsBoundaryUsageCount = builder.permissionsBoundaryUsageCount;
        this.policyId = builder.policyId;
        this.policyName = builder.policyName;
        this.policyVersionList = builder.policyVersionList;
        this.updateDate = builder.updateDate;
    }

    /**
     * <p>
     * The number of users, groups, and roles that the policy is attached to.
     * </p>
     * 
     * @return The number of users, groups, and roles that the policy is attached to.
     */
    public final Integer attachmentCount() {
        return attachmentCount;
    }

    /**
     * <p>
     * When the policy was created.
     * </p>
     * <p>
     * This field accepts only the specified formats. Timestamps can end with <code>Z</code> or
     * <code>("+" / "-") time-hour [":" time-minute]</code>. The time-secfrac after seconds is limited to a maximum of 9
     * digits. The offset is bounded by +/-18:00. Here are valid timestamp formats with examples:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>YYYY-MM-DDTHH:MM:SSZ</code> (for example, <code>2019-01-31T23:00:00Z</code>)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ</code> (for example, <code>2019-01-31T23:00:00.123456789Z</code>)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>YYYY-MM-DDTHH:MM:SS+HH:MM</code> (for example, <code>2024-01-04T15:25:10+17:59</code>)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>YYYY-MM-DDTHH:MM:SS-HHMM</code> (for example, <code>2024-01-04T15:25:10-1759</code>)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM</code> (for example, <code>2024-01-04T15:25:10.123456789+17:59</code>)
     * </p>
     * </li>
     * </ul>
     * 
     * @return When the policy was created.</p>
     *         <p>
     *         This field accepts only the specified formats. Timestamps can end with <code>Z</code> or
     *         <code>("+" / "-") time-hour [":" time-minute]</code>. The time-secfrac after seconds is limited to a
     *         maximum of 9 digits. The offset is bounded by +/-18:00. Here are valid timestamp formats with examples:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>YYYY-MM-DDTHH:MM:SSZ</code> (for example, <code>2019-01-31T23:00:00Z</code>)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ</code> (for example, <code>2019-01-31T23:00:00.123456789Z</code>)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>YYYY-MM-DDTHH:MM:SS+HH:MM</code> (for example, <code>2024-01-04T15:25:10+17:59</code>)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>YYYY-MM-DDTHH:MM:SS-HHMM</code> (for example, <code>2024-01-04T15:25:10-1759</code>)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM</code> (for example,
     *         <code>2024-01-04T15:25:10.123456789+17:59</code>)
     *         </p>
     *         </li>
     */
    public final String createDate() {
        return createDate;
    }

    /**
     * <p>
     * The identifier of the default version of the policy.
     * </p>
     * 
     * @return The identifier of the default version of the policy.
     */
    public final String defaultVersionId() {
        return defaultVersionId;
    }

    /**
     * <p>
     * A description of the policy.
     * </p>
     * 
     * @return A description of the policy.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * Whether the policy can be attached to a user, group, or role.
     * </p>
     * 
     * @return Whether the policy can be attached to a user, group, or role.
     */
    public final Boolean isAttachable() {
        return isAttachable;
    }

    /**
     * <p>
     * The path to the policy.
     * </p>
     * 
     * @return The path to the policy.
     */
    public final String path() {
        return path;
    }

    /**
     * <p>
     * The number of users and roles that use the policy to set the permissions boundary.
     * </p>
     * 
     * @return The number of users and roles that use the policy to set the permissions boundary.
     */
    public final Integer permissionsBoundaryUsageCount() {
        return permissionsBoundaryUsageCount;
    }

    /**
     * <p>
     * The unique identifier of the policy.
     * </p>
     * 
     * @return The unique identifier of the policy.
     */
    public final String policyId() {
        return policyId;
    }

    /**
     * <p>
     * The name of the policy.
     * </p>
     * 
     * @return The name of the policy.
     */
    public final String policyName() {
        return policyName;
    }

    /**
     * For responses, this returns true if the service returned a value for the PolicyVersionList property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPolicyVersionList() {
        return policyVersionList != null && !(policyVersionList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of versions of the policy.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPolicyVersionList} method.
     * </p>
     * 
     * @return List of versions of the policy.
     */
    public final List<AwsIamPolicyVersion> policyVersionList() {
        return policyVersionList;
    }

    /**
     * <p>
     * When the policy was most recently updated.
     * </p>
     * <p>
     * This field accepts only the specified formats. Timestamps can end with <code>Z</code> or
     * <code>("+" / "-") time-hour [":" time-minute]</code>. The time-secfrac after seconds is limited to a maximum of 9
     * digits. The offset is bounded by +/-18:00. Here are valid timestamp formats with examples:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>YYYY-MM-DDTHH:MM:SSZ</code> (for example, <code>2019-01-31T23:00:00Z</code>)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ</code> (for example, <code>2019-01-31T23:00:00.123456789Z</code>)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>YYYY-MM-DDTHH:MM:SS+HH:MM</code> (for example, <code>2024-01-04T15:25:10+17:59</code>)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>YYYY-MM-DDTHH:MM:SS-HHMM</code> (for example, <code>2024-01-04T15:25:10-1759</code>)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM</code> (for example, <code>2024-01-04T15:25:10.123456789+17:59</code>)
     * </p>
     * </li>
     * </ul>
     * 
     * @return When the policy was most recently updated.</p>
     *         <p>
     *         This field accepts only the specified formats. Timestamps can end with <code>Z</code> or
     *         <code>("+" / "-") time-hour [":" time-minute]</code>. The time-secfrac after seconds is limited to a
     *         maximum of 9 digits. The offset is bounded by +/-18:00. Here are valid timestamp formats with examples:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>YYYY-MM-DDTHH:MM:SSZ</code> (for example, <code>2019-01-31T23:00:00Z</code>)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ</code> (for example, <code>2019-01-31T23:00:00.123456789Z</code>)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>YYYY-MM-DDTHH:MM:SS+HH:MM</code> (for example, <code>2024-01-04T15:25:10+17:59</code>)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>YYYY-MM-DDTHH:MM:SS-HHMM</code> (for example, <code>2024-01-04T15:25:10-1759</code>)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM</code> (for example,
     *         <code>2024-01-04T15:25:10.123456789+17:59</code>)
     *         </p>
     *         </li>
     */
    public final String updateDate() {
        return updateDate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(attachmentCount());
        hashCode = 31 * hashCode + Objects.hashCode(createDate());
        hashCode = 31 * hashCode + Objects.hashCode(defaultVersionId());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(isAttachable());
        hashCode = 31 * hashCode + Objects.hashCode(path());
        hashCode = 31 * hashCode + Objects.hashCode(permissionsBoundaryUsageCount());
        hashCode = 31 * hashCode + Objects.hashCode(policyId());
        hashCode = 31 * hashCode + Objects.hashCode(policyName());
        hashCode = 31 * hashCode + Objects.hashCode(hasPolicyVersionList() ? policyVersionList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(updateDate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsIamPolicyDetails)) {
            return false;
        }
        AwsIamPolicyDetails other = (AwsIamPolicyDetails) obj;
        return Objects.equals(attachmentCount(), other.attachmentCount()) && Objects.equals(createDate(), other.createDate())
                && Objects.equals(defaultVersionId(), other.defaultVersionId())
                && Objects.equals(description(), other.description()) && Objects.equals(isAttachable(), other.isAttachable())
                && Objects.equals(path(), other.path())
                && Objects.equals(permissionsBoundaryUsageCount(), other.permissionsBoundaryUsageCount())
                && Objects.equals(policyId(), other.policyId()) && Objects.equals(policyName(), other.policyName())
                && hasPolicyVersionList() == other.hasPolicyVersionList()
                && Objects.equals(policyVersionList(), other.policyVersionList())
                && Objects.equals(updateDate(), other.updateDate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsIamPolicyDetails").add("AttachmentCount", attachmentCount()).add("CreateDate", createDate())
                .add("DefaultVersionId", defaultVersionId()).add("Description", description())
                .add("IsAttachable", isAttachable()).add("Path", path())
                .add("PermissionsBoundaryUsageCount", permissionsBoundaryUsageCount()).add("PolicyId", policyId())
                .add("PolicyName", policyName()).add("PolicyVersionList", hasPolicyVersionList() ? policyVersionList() : null)
                .add("UpdateDate", updateDate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AttachmentCount":
            return Optional.ofNullable(clazz.cast(attachmentCount()));
        case "CreateDate":
            return Optional.ofNullable(clazz.cast(createDate()));
        case "DefaultVersionId":
            return Optional.ofNullable(clazz.cast(defaultVersionId()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "IsAttachable":
            return Optional.ofNullable(clazz.cast(isAttachable()));
        case "Path":
            return Optional.ofNullable(clazz.cast(path()));
        case "PermissionsBoundaryUsageCount":
            return Optional.ofNullable(clazz.cast(permissionsBoundaryUsageCount()));
        case "PolicyId":
            return Optional.ofNullable(clazz.cast(policyId()));
        case "PolicyName":
            return Optional.ofNullable(clazz.cast(policyName()));
        case "PolicyVersionList":
            return Optional.ofNullable(clazz.cast(policyVersionList()));
        case "UpdateDate":
            return Optional.ofNullable(clazz.cast(updateDate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsIamPolicyDetails, T> g) {
        return obj -> g.apply((AwsIamPolicyDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsIamPolicyDetails> {
        /**
         * <p>
         * The number of users, groups, and roles that the policy is attached to.
         * </p>
         * 
         * @param attachmentCount
         *        The number of users, groups, and roles that the policy is attached to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attachmentCount(Integer attachmentCount);

        /**
         * <p>
         * When the policy was created.
         * </p>
         * <p>
         * This field accepts only the specified formats. Timestamps can end with <code>Z</code> or
         * <code>("+" / "-") time-hour [":" time-minute]</code>. The time-secfrac after seconds is limited to a maximum
         * of 9 digits. The offset is bounded by +/-18:00. Here are valid timestamp formats with examples:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>YYYY-MM-DDTHH:MM:SSZ</code> (for example, <code>2019-01-31T23:00:00Z</code>)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ</code> (for example, <code>2019-01-31T23:00:00.123456789Z</code>)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>YYYY-MM-DDTHH:MM:SS+HH:MM</code> (for example, <code>2024-01-04T15:25:10+17:59</code>)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>YYYY-MM-DDTHH:MM:SS-HHMM</code> (for example, <code>2024-01-04T15:25:10-1759</code>)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM</code> (for example,
         * <code>2024-01-04T15:25:10.123456789+17:59</code>)
         * </p>
         * </li>
         * </ul>
         * 
         * @param createDate
         *        When the policy was created.</p>
         *        <p>
         *        This field accepts only the specified formats. Timestamps can end with <code>Z</code> or
         *        <code>("+" / "-") time-hour [":" time-minute]</code>. The time-secfrac after seconds is limited to a
         *        maximum of 9 digits. The offset is bounded by +/-18:00. Here are valid timestamp formats with
         *        examples:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>YYYY-MM-DDTHH:MM:SSZ</code> (for example, <code>2019-01-31T23:00:00Z</code>)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ</code> (for example, <code>2019-01-31T23:00:00.123456789Z</code>)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>YYYY-MM-DDTHH:MM:SS+HH:MM</code> (for example, <code>2024-01-04T15:25:10+17:59</code>)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>YYYY-MM-DDTHH:MM:SS-HHMM</code> (for example, <code>2024-01-04T15:25:10-1759</code>)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM</code> (for example,
         *        <code>2024-01-04T15:25:10.123456789+17:59</code>)
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createDate(String createDate);

        /**
         * <p>
         * The identifier of the default version of the policy.
         * </p>
         * 
         * @param defaultVersionId
         *        The identifier of the default version of the policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultVersionId(String defaultVersionId);

        /**
         * <p>
         * A description of the policy.
         * </p>
         * 
         * @param description
         *        A description of the policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Whether the policy can be attached to a user, group, or role.
         * </p>
         * 
         * @param isAttachable
         *        Whether the policy can be attached to a user, group, or role.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isAttachable(Boolean isAttachable);

        /**
         * <p>
         * The path to the policy.
         * </p>
         * 
         * @param path
         *        The path to the policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder path(String path);

        /**
         * <p>
         * The number of users and roles that use the policy to set the permissions boundary.
         * </p>
         * 
         * @param permissionsBoundaryUsageCount
         *        The number of users and roles that use the policy to set the permissions boundary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder permissionsBoundaryUsageCount(Integer permissionsBoundaryUsageCount);

        /**
         * <p>
         * The unique identifier of the policy.
         * </p>
         * 
         * @param policyId
         *        The unique identifier of the policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyId(String policyId);

        /**
         * <p>
         * The name of the policy.
         * </p>
         * 
         * @param policyName
         *        The name of the policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyName(String policyName);

        /**
         * <p>
         * List of versions of the policy.
         * </p>
         * 
         * @param policyVersionList
         *        List of versions of the policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyVersionList(Collection<AwsIamPolicyVersion> policyVersionList);

        /**
         * <p>
         * List of versions of the policy.
         * </p>
         * 
         * @param policyVersionList
         *        List of versions of the policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyVersionList(AwsIamPolicyVersion... policyVersionList);

        /**
         * <p>
         * List of versions of the policy.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityhub.model.AwsIamPolicyVersion.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.securityhub.model.AwsIamPolicyVersion#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityhub.model.AwsIamPolicyVersion.Builder#build()} is called
         * immediately and its result is passed to {@link #policyVersionList(List<AwsIamPolicyVersion>)}.
         * 
         * @param policyVersionList
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityhub.model.AwsIamPolicyVersion.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #policyVersionList(java.util.Collection<AwsIamPolicyVersion>)
         */
        Builder policyVersionList(Consumer<AwsIamPolicyVersion.Builder>... policyVersionList);

        /**
         * <p>
         * When the policy was most recently updated.
         * </p>
         * <p>
         * This field accepts only the specified formats. Timestamps can end with <code>Z</code> or
         * <code>("+" / "-") time-hour [":" time-minute]</code>. The time-secfrac after seconds is limited to a maximum
         * of 9 digits. The offset is bounded by +/-18:00. Here are valid timestamp formats with examples:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>YYYY-MM-DDTHH:MM:SSZ</code> (for example, <code>2019-01-31T23:00:00Z</code>)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ</code> (for example, <code>2019-01-31T23:00:00.123456789Z</code>)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>YYYY-MM-DDTHH:MM:SS+HH:MM</code> (for example, <code>2024-01-04T15:25:10+17:59</code>)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>YYYY-MM-DDTHH:MM:SS-HHMM</code> (for example, <code>2024-01-04T15:25:10-1759</code>)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM</code> (for example,
         * <code>2024-01-04T15:25:10.123456789+17:59</code>)
         * </p>
         * </li>
         * </ul>
         * 
         * @param updateDate
         *        When the policy was most recently updated.</p>
         *        <p>
         *        This field accepts only the specified formats. Timestamps can end with <code>Z</code> or
         *        <code>("+" / "-") time-hour [":" time-minute]</code>. The time-secfrac after seconds is limited to a
         *        maximum of 9 digits. The offset is bounded by +/-18:00. Here are valid timestamp formats with
         *        examples:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>YYYY-MM-DDTHH:MM:SSZ</code> (for example, <code>2019-01-31T23:00:00Z</code>)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ</code> (for example, <code>2019-01-31T23:00:00.123456789Z</code>)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>YYYY-MM-DDTHH:MM:SS+HH:MM</code> (for example, <code>2024-01-04T15:25:10+17:59</code>)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>YYYY-MM-DDTHH:MM:SS-HHMM</code> (for example, <code>2024-01-04T15:25:10-1759</code>)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM</code> (for example,
         *        <code>2024-01-04T15:25:10.123456789+17:59</code>)
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateDate(String updateDate);
    }

    static final class BuilderImpl implements Builder {
        private Integer attachmentCount;

        private String createDate;

        private String defaultVersionId;

        private String description;

        private Boolean isAttachable;

        private String path;

        private Integer permissionsBoundaryUsageCount;

        private String policyId;

        private String policyName;

        private List<AwsIamPolicyVersion> policyVersionList = DefaultSdkAutoConstructList.getInstance();

        private String updateDate;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsIamPolicyDetails model) {
            attachmentCount(model.attachmentCount);
            createDate(model.createDate);
            defaultVersionId(model.defaultVersionId);
            description(model.description);
            isAttachable(model.isAttachable);
            path(model.path);
            permissionsBoundaryUsageCount(model.permissionsBoundaryUsageCount);
            policyId(model.policyId);
            policyName(model.policyName);
            policyVersionList(model.policyVersionList);
            updateDate(model.updateDate);
        }

        public final Integer getAttachmentCount() {
            return attachmentCount;
        }

        public final void setAttachmentCount(Integer attachmentCount) {
            this.attachmentCount = attachmentCount;
        }

        @Override
        public final Builder attachmentCount(Integer attachmentCount) {
            this.attachmentCount = attachmentCount;
            return this;
        }

        public final String getCreateDate() {
            return createDate;
        }

        public final void setCreateDate(String createDate) {
            this.createDate = createDate;
        }

        @Override
        public final Builder createDate(String createDate) {
            this.createDate = createDate;
            return this;
        }

        public final String getDefaultVersionId() {
            return defaultVersionId;
        }

        public final void setDefaultVersionId(String defaultVersionId) {
            this.defaultVersionId = defaultVersionId;
        }

        @Override
        public final Builder defaultVersionId(String defaultVersionId) {
            this.defaultVersionId = defaultVersionId;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Boolean getIsAttachable() {
            return isAttachable;
        }

        public final void setIsAttachable(Boolean isAttachable) {
            this.isAttachable = isAttachable;
        }

        @Override
        public final Builder isAttachable(Boolean isAttachable) {
            this.isAttachable = isAttachable;
            return this;
        }

        public final String getPath() {
            return path;
        }

        public final void setPath(String path) {
            this.path = path;
        }

        @Override
        public final Builder path(String path) {
            this.path = path;
            return this;
        }

        public final Integer getPermissionsBoundaryUsageCount() {
            return permissionsBoundaryUsageCount;
        }

        public final void setPermissionsBoundaryUsageCount(Integer permissionsBoundaryUsageCount) {
            this.permissionsBoundaryUsageCount = permissionsBoundaryUsageCount;
        }

        @Override
        public final Builder permissionsBoundaryUsageCount(Integer permissionsBoundaryUsageCount) {
            this.permissionsBoundaryUsageCount = permissionsBoundaryUsageCount;
            return this;
        }

        public final String getPolicyId() {
            return policyId;
        }

        public final void setPolicyId(String policyId) {
            this.policyId = policyId;
        }

        @Override
        public final Builder policyId(String policyId) {
            this.policyId = policyId;
            return this;
        }

        public final String getPolicyName() {
            return policyName;
        }

        public final void setPolicyName(String policyName) {
            this.policyName = policyName;
        }

        @Override
        public final Builder policyName(String policyName) {
            this.policyName = policyName;
            return this;
        }

        public final List<AwsIamPolicyVersion.Builder> getPolicyVersionList() {
            List<AwsIamPolicyVersion.Builder> result = AwsIamPolicyVersionListCopier.copyToBuilder(this.policyVersionList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPolicyVersionList(Collection<AwsIamPolicyVersion.BuilderImpl> policyVersionList) {
            this.policyVersionList = AwsIamPolicyVersionListCopier.copyFromBuilder(policyVersionList);
        }

        @Override
        public final Builder policyVersionList(Collection<AwsIamPolicyVersion> policyVersionList) {
            this.policyVersionList = AwsIamPolicyVersionListCopier.copy(policyVersionList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policyVersionList(AwsIamPolicyVersion... policyVersionList) {
            policyVersionList(Arrays.asList(policyVersionList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policyVersionList(Consumer<AwsIamPolicyVersion.Builder>... policyVersionList) {
            policyVersionList(Stream.of(policyVersionList).map(c -> AwsIamPolicyVersion.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getUpdateDate() {
            return updateDate;
        }

        public final void setUpdateDate(String updateDate) {
            this.updateDate = updateDate;
        }

        @Override
        public final Builder updateDate(String updateDate) {
            this.updateDate = updateDate;
            return this;
        }

        @Override
        public AwsIamPolicyDetails build() {
            return new AwsIamPolicyDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
