/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about an Amazon RDS DB cluster snapshot.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsRdsDbClusterSnapshotDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsRdsDbClusterSnapshotDetails.Builder, AwsRdsDbClusterSnapshotDetails> {
    private static final SdkField<List<String>> AVAILABILITY_ZONES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AvailabilityZones")
            .getter(getter(AwsRdsDbClusterSnapshotDetails::availabilityZones))
            .setter(setter(Builder::availabilityZones))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZones").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> SNAPSHOT_CREATE_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SnapshotCreateTime").getter(getter(AwsRdsDbClusterSnapshotDetails::snapshotCreateTime))
            .setter(setter(Builder::snapshotCreateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotCreateTime").build())
            .build();

    private static final SdkField<String> ENGINE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Engine")
            .getter(getter(AwsRdsDbClusterSnapshotDetails::engine)).setter(setter(Builder::engine))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Engine").build()).build();

    private static final SdkField<Integer> ALLOCATED_STORAGE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("AllocatedStorage").getter(getter(AwsRdsDbClusterSnapshotDetails::allocatedStorage))
            .setter(setter(Builder::allocatedStorage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllocatedStorage").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(AwsRdsDbClusterSnapshotDetails::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<Integer> PORT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Port")
            .getter(getter(AwsRdsDbClusterSnapshotDetails::port)).setter(setter(Builder::port))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Port").build()).build();

    private static final SdkField<String> VPC_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("VpcId")
            .getter(getter(AwsRdsDbClusterSnapshotDetails::vpcId)).setter(setter(Builder::vpcId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcId").build()).build();

    private static final SdkField<String> CLUSTER_CREATE_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClusterCreateTime").getter(getter(AwsRdsDbClusterSnapshotDetails::clusterCreateTime))
            .setter(setter(Builder::clusterCreateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterCreateTime").build()).build();

    private static final SdkField<String> MASTER_USERNAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MasterUsername").getter(getter(AwsRdsDbClusterSnapshotDetails::masterUsername))
            .setter(setter(Builder::masterUsername))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MasterUsername").build()).build();

    private static final SdkField<String> ENGINE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EngineVersion").getter(getter(AwsRdsDbClusterSnapshotDetails::engineVersion))
            .setter(setter(Builder::engineVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineVersion").build()).build();

    private static final SdkField<String> LICENSE_MODEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LicenseModel").getter(getter(AwsRdsDbClusterSnapshotDetails::licenseModel))
            .setter(setter(Builder::licenseModel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LicenseModel").build()).build();

    private static final SdkField<String> SNAPSHOT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SnapshotType").getter(getter(AwsRdsDbClusterSnapshotDetails::snapshotType))
            .setter(setter(Builder::snapshotType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotType").build()).build();

    private static final SdkField<Integer> PERCENT_PROGRESS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("PercentProgress").getter(getter(AwsRdsDbClusterSnapshotDetails::percentProgress))
            .setter(setter(Builder::percentProgress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PercentProgress").build()).build();

    private static final SdkField<Boolean> STORAGE_ENCRYPTED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("StorageEncrypted").getter(getter(AwsRdsDbClusterSnapshotDetails::storageEncrypted))
            .setter(setter(Builder::storageEncrypted))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageEncrypted").build()).build();

    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KmsKeyId").getter(getter(AwsRdsDbClusterSnapshotDetails::kmsKeyId)).setter(setter(Builder::kmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()).build();

    private static final SdkField<String> DB_CLUSTER_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DbClusterIdentifier").getter(getter(AwsRdsDbClusterSnapshotDetails::dbClusterIdentifier))
            .setter(setter(Builder::dbClusterIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DbClusterIdentifier").build())
            .build();

    private static final SdkField<String> DB_CLUSTER_SNAPSHOT_IDENTIFIER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("DbClusterSnapshotIdentifier")
            .getter(getter(AwsRdsDbClusterSnapshotDetails::dbClusterSnapshotIdentifier))
            .setter(setter(Builder::dbClusterSnapshotIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DbClusterSnapshotIdentifier")
                    .build()).build();

    private static final SdkField<Boolean> IAM_DATABASE_AUTHENTICATION_ENABLED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IamDatabaseAuthenticationEnabled")
            .getter(getter(AwsRdsDbClusterSnapshotDetails::iamDatabaseAuthenticationEnabled))
            .setter(setter(Builder::iamDatabaseAuthenticationEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IamDatabaseAuthenticationEnabled")
                    .build()).build();

    private static final SdkField<List<AwsRdsDbClusterSnapshotDbClusterSnapshotAttribute>> DB_CLUSTER_SNAPSHOT_ATTRIBUTES_FIELD = SdkField
            .<List<AwsRdsDbClusterSnapshotDbClusterSnapshotAttribute>> builder(MarshallingType.LIST)
            .memberName("DbClusterSnapshotAttributes")
            .getter(getter(AwsRdsDbClusterSnapshotDetails::dbClusterSnapshotAttributes))
            .setter(setter(Builder::dbClusterSnapshotAttributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DbClusterSnapshotAttributes")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AwsRdsDbClusterSnapshotDbClusterSnapshotAttribute> builder(MarshallingType.SDK_POJO)
                                            .constructor(AwsRdsDbClusterSnapshotDbClusterSnapshotAttribute::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(AVAILABILITY_ZONES_FIELD, SNAPSHOT_CREATE_TIME_FIELD, ENGINE_FIELD, ALLOCATED_STORAGE_FIELD, STATUS_FIELD,
                    PORT_FIELD, VPC_ID_FIELD, CLUSTER_CREATE_TIME_FIELD, MASTER_USERNAME_FIELD, ENGINE_VERSION_FIELD,
                    LICENSE_MODEL_FIELD, SNAPSHOT_TYPE_FIELD, PERCENT_PROGRESS_FIELD, STORAGE_ENCRYPTED_FIELD, KMS_KEY_ID_FIELD,
                    DB_CLUSTER_IDENTIFIER_FIELD, DB_CLUSTER_SNAPSHOT_IDENTIFIER_FIELD, IAM_DATABASE_AUTHENTICATION_ENABLED_FIELD,
                    DB_CLUSTER_SNAPSHOT_ATTRIBUTES_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> availabilityZones;

    private final String snapshotCreateTime;

    private final String engine;

    private final Integer allocatedStorage;

    private final String status;

    private final Integer port;

    private final String vpcId;

    private final String clusterCreateTime;

    private final String masterUsername;

    private final String engineVersion;

    private final String licenseModel;

    private final String snapshotType;

    private final Integer percentProgress;

    private final Boolean storageEncrypted;

    private final String kmsKeyId;

    private final String dbClusterIdentifier;

    private final String dbClusterSnapshotIdentifier;

    private final Boolean iamDatabaseAuthenticationEnabled;

    private final List<AwsRdsDbClusterSnapshotDbClusterSnapshotAttribute> dbClusterSnapshotAttributes;

    private AwsRdsDbClusterSnapshotDetails(BuilderImpl builder) {
        this.availabilityZones = builder.availabilityZones;
        this.snapshotCreateTime = builder.snapshotCreateTime;
        this.engine = builder.engine;
        this.allocatedStorage = builder.allocatedStorage;
        this.status = builder.status;
        this.port = builder.port;
        this.vpcId = builder.vpcId;
        this.clusterCreateTime = builder.clusterCreateTime;
        this.masterUsername = builder.masterUsername;
        this.engineVersion = builder.engineVersion;
        this.licenseModel = builder.licenseModel;
        this.snapshotType = builder.snapshotType;
        this.percentProgress = builder.percentProgress;
        this.storageEncrypted = builder.storageEncrypted;
        this.kmsKeyId = builder.kmsKeyId;
        this.dbClusterIdentifier = builder.dbClusterIdentifier;
        this.dbClusterSnapshotIdentifier = builder.dbClusterSnapshotIdentifier;
        this.iamDatabaseAuthenticationEnabled = builder.iamDatabaseAuthenticationEnabled;
        this.dbClusterSnapshotAttributes = builder.dbClusterSnapshotAttributes;
    }

    /**
     * For responses, this returns true if the service returned a value for the AvailabilityZones property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAvailabilityZones() {
        return availabilityZones != null && !(availabilityZones instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of Availability Zones where instances in the DB cluster can be created.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAvailabilityZones} method.
     * </p>
     * 
     * @return A list of Availability Zones where instances in the DB cluster can be created.
     */
    public final List<String> availabilityZones() {
        return availabilityZones;
    }

    /**
     * <p>
     * Indicates when the snapshot was taken.
     * </p>
     * <p>
     * This field accepts only the specified formats. Timestamps can end with <code>Z</code> or
     * <code>("+" / "-") time-hour [":" time-minute]</code>. The time-secfrac after seconds is limited to a maximum of 9
     * digits. The offset is bounded by +/-18:00. Here are valid timestamp formats with examples:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>YYYY-MM-DDTHH:MM:SSZ</code> (for example, <code>2019-01-31T23:00:00Z</code>)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ</code> (for example, <code>2019-01-31T23:00:00.123456789Z</code>)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>YYYY-MM-DDTHH:MM:SS+HH:MM</code> (for example, <code>2024-01-04T15:25:10+17:59</code>)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>YYYY-MM-DDTHH:MM:SS-HHMM</code> (for example, <code>2024-01-04T15:25:10-1759</code>)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM</code> (for example, <code>2024-01-04T15:25:10.123456789+17:59</code>)
     * </p>
     * </li>
     * </ul>
     * 
     * @return Indicates when the snapshot was taken.</p>
     *         <p>
     *         This field accepts only the specified formats. Timestamps can end with <code>Z</code> or
     *         <code>("+" / "-") time-hour [":" time-minute]</code>. The time-secfrac after seconds is limited to a
     *         maximum of 9 digits. The offset is bounded by +/-18:00. Here are valid timestamp formats with examples:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>YYYY-MM-DDTHH:MM:SSZ</code> (for example, <code>2019-01-31T23:00:00Z</code>)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ</code> (for example, <code>2019-01-31T23:00:00.123456789Z</code>)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>YYYY-MM-DDTHH:MM:SS+HH:MM</code> (for example, <code>2024-01-04T15:25:10+17:59</code>)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>YYYY-MM-DDTHH:MM:SS-HHMM</code> (for example, <code>2024-01-04T15:25:10-1759</code>)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM</code> (for example,
     *         <code>2024-01-04T15:25:10.123456789+17:59</code>)
     *         </p>
     *         </li>
     */
    public final String snapshotCreateTime() {
        return snapshotCreateTime;
    }

    /**
     * <p>
     * The name of the database engine that you want to use for this DB instance.
     * </p>
     * 
     * @return The name of the database engine that you want to use for this DB instance.
     */
    public final String engine() {
        return engine;
    }

    /**
     * <p>
     * Specifies the allocated storage size in gibibytes (GiB).
     * </p>
     * 
     * @return Specifies the allocated storage size in gibibytes (GiB).
     */
    public final Integer allocatedStorage() {
        return allocatedStorage;
    }

    /**
     * <p>
     * The status of this DB cluster snapshot.
     * </p>
     * 
     * @return The status of this DB cluster snapshot.
     */
    public final String status() {
        return status;
    }

    /**
     * <p>
     * The port number on which the DB instances in the DB cluster accept connections.
     * </p>
     * 
     * @return The port number on which the DB instances in the DB cluster accept connections.
     */
    public final Integer port() {
        return port;
    }

    /**
     * <p>
     * The VPC ID that is associated with the DB cluster snapshot.
     * </p>
     * 
     * @return The VPC ID that is associated with the DB cluster snapshot.
     */
    public final String vpcId() {
        return vpcId;
    }

    /**
     * <p>
     * Indicates when the DB cluster was created, in Universal Coordinated Time (UTC).
     * </p>
     * <p>
     * This field accepts only the specified formats. Timestamps can end with <code>Z</code> or
     * <code>("+" / "-") time-hour [":" time-minute]</code>. The time-secfrac after seconds is limited to a maximum of 9
     * digits. The offset is bounded by +/-18:00. Here are valid timestamp formats with examples:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>YYYY-MM-DDTHH:MM:SSZ</code> (for example, <code>2019-01-31T23:00:00Z</code>)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ</code> (for example, <code>2019-01-31T23:00:00.123456789Z</code>)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>YYYY-MM-DDTHH:MM:SS+HH:MM</code> (for example, <code>2024-01-04T15:25:10+17:59</code>)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>YYYY-MM-DDTHH:MM:SS-HHMM</code> (for example, <code>2024-01-04T15:25:10-1759</code>)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM</code> (for example, <code>2024-01-04T15:25:10.123456789+17:59</code>)
     * </p>
     * </li>
     * </ul>
     * 
     * @return Indicates when the DB cluster was created, in Universal Coordinated Time (UTC).</p>
     *         <p>
     *         This field accepts only the specified formats. Timestamps can end with <code>Z</code> or
     *         <code>("+" / "-") time-hour [":" time-minute]</code>. The time-secfrac after seconds is limited to a
     *         maximum of 9 digits. The offset is bounded by +/-18:00. Here are valid timestamp formats with examples:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>YYYY-MM-DDTHH:MM:SSZ</code> (for example, <code>2019-01-31T23:00:00Z</code>)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ</code> (for example, <code>2019-01-31T23:00:00.123456789Z</code>)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>YYYY-MM-DDTHH:MM:SS+HH:MM</code> (for example, <code>2024-01-04T15:25:10+17:59</code>)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>YYYY-MM-DDTHH:MM:SS-HHMM</code> (for example, <code>2024-01-04T15:25:10-1759</code>)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM</code> (for example,
     *         <code>2024-01-04T15:25:10.123456789+17:59</code>)
     *         </p>
     *         </li>
     */
    public final String clusterCreateTime() {
        return clusterCreateTime;
    }

    /**
     * <p>
     * The name of the master user for the DB cluster.
     * </p>
     * 
     * @return The name of the master user for the DB cluster.
     */
    public final String masterUsername() {
        return masterUsername;
    }

    /**
     * <p>
     * The version of the database engine to use.
     * </p>
     * 
     * @return The version of the database engine to use.
     */
    public final String engineVersion() {
        return engineVersion;
    }

    /**
     * <p>
     * The license model information for this DB cluster snapshot.
     * </p>
     * 
     * @return The license model information for this DB cluster snapshot.
     */
    public final String licenseModel() {
        return licenseModel;
    }

    /**
     * <p>
     * The type of DB cluster snapshot.
     * </p>
     * 
     * @return The type of DB cluster snapshot.
     */
    public final String snapshotType() {
        return snapshotType;
    }

    /**
     * <p>
     * Specifies the percentage of the estimated data that has been transferred.
     * </p>
     * 
     * @return Specifies the percentage of the estimated data that has been transferred.
     */
    public final Integer percentProgress() {
        return percentProgress;
    }

    /**
     * <p>
     * Whether the DB cluster is encrypted.
     * </p>
     * 
     * @return Whether the DB cluster is encrypted.
     */
    public final Boolean storageEncrypted() {
        return storageEncrypted;
    }

    /**
     * <p>
     * The ARN of the KMS master key that is used to encrypt the database instances in the DB cluster.
     * </p>
     * 
     * @return The ARN of the KMS master key that is used to encrypt the database instances in the DB cluster.
     */
    public final String kmsKeyId() {
        return kmsKeyId;
    }

    /**
     * <p>
     * The DB cluster identifier.
     * </p>
     * 
     * @return The DB cluster identifier.
     */
    public final String dbClusterIdentifier() {
        return dbClusterIdentifier;
    }

    /**
     * <p>
     * The identifier of the DB cluster snapshot.
     * </p>
     * 
     * @return The identifier of the DB cluster snapshot.
     */
    public final String dbClusterSnapshotIdentifier() {
        return dbClusterSnapshotIdentifier;
    }

    /**
     * <p>
     * Whether mapping of IAM accounts to database accounts is enabled.
     * </p>
     * 
     * @return Whether mapping of IAM accounts to database accounts is enabled.
     */
    public final Boolean iamDatabaseAuthenticationEnabled() {
        return iamDatabaseAuthenticationEnabled;
    }

    /**
     * For responses, this returns true if the service returned a value for the DbClusterSnapshotAttributes property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasDbClusterSnapshotAttributes() {
        return dbClusterSnapshotAttributes != null && !(dbClusterSnapshotAttributes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Contains the name and values of a manual DB cluster snapshot attribute.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDbClusterSnapshotAttributes} method.
     * </p>
     * 
     * @return Contains the name and values of a manual DB cluster snapshot attribute.
     */
    public final List<AwsRdsDbClusterSnapshotDbClusterSnapshotAttribute> dbClusterSnapshotAttributes() {
        return dbClusterSnapshotAttributes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasAvailabilityZones() ? availabilityZones() : null);
        hashCode = 31 * hashCode + Objects.hashCode(snapshotCreateTime());
        hashCode = 31 * hashCode + Objects.hashCode(engine());
        hashCode = 31 * hashCode + Objects.hashCode(allocatedStorage());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(port());
        hashCode = 31 * hashCode + Objects.hashCode(vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(clusterCreateTime());
        hashCode = 31 * hashCode + Objects.hashCode(masterUsername());
        hashCode = 31 * hashCode + Objects.hashCode(engineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(licenseModel());
        hashCode = 31 * hashCode + Objects.hashCode(snapshotType());
        hashCode = 31 * hashCode + Objects.hashCode(percentProgress());
        hashCode = 31 * hashCode + Objects.hashCode(storageEncrypted());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(dbClusterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(dbClusterSnapshotIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(iamDatabaseAuthenticationEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(hasDbClusterSnapshotAttributes() ? dbClusterSnapshotAttributes() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsRdsDbClusterSnapshotDetails)) {
            return false;
        }
        AwsRdsDbClusterSnapshotDetails other = (AwsRdsDbClusterSnapshotDetails) obj;
        return hasAvailabilityZones() == other.hasAvailabilityZones()
                && Objects.equals(availabilityZones(), other.availabilityZones())
                && Objects.equals(snapshotCreateTime(), other.snapshotCreateTime()) && Objects.equals(engine(), other.engine())
                && Objects.equals(allocatedStorage(), other.allocatedStorage()) && Objects.equals(status(), other.status())
                && Objects.equals(port(), other.port()) && Objects.equals(vpcId(), other.vpcId())
                && Objects.equals(clusterCreateTime(), other.clusterCreateTime())
                && Objects.equals(masterUsername(), other.masterUsername())
                && Objects.equals(engineVersion(), other.engineVersion()) && Objects.equals(licenseModel(), other.licenseModel())
                && Objects.equals(snapshotType(), other.snapshotType())
                && Objects.equals(percentProgress(), other.percentProgress())
                && Objects.equals(storageEncrypted(), other.storageEncrypted()) && Objects.equals(kmsKeyId(), other.kmsKeyId())
                && Objects.equals(dbClusterIdentifier(), other.dbClusterIdentifier())
                && Objects.equals(dbClusterSnapshotIdentifier(), other.dbClusterSnapshotIdentifier())
                && Objects.equals(iamDatabaseAuthenticationEnabled(), other.iamDatabaseAuthenticationEnabled())
                && hasDbClusterSnapshotAttributes() == other.hasDbClusterSnapshotAttributes()
                && Objects.equals(dbClusterSnapshotAttributes(), other.dbClusterSnapshotAttributes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsRdsDbClusterSnapshotDetails")
                .add("AvailabilityZones", hasAvailabilityZones() ? availabilityZones() : null)
                .add("SnapshotCreateTime", snapshotCreateTime()).add("Engine", engine())
                .add("AllocatedStorage", allocatedStorage()).add("Status", status()).add("Port", port()).add("VpcId", vpcId())
                .add("ClusterCreateTime", clusterCreateTime()).add("MasterUsername", masterUsername())
                .add("EngineVersion", engineVersion()).add("LicenseModel", licenseModel()).add("SnapshotType", snapshotType())
                .add("PercentProgress", percentProgress()).add("StorageEncrypted", storageEncrypted())
                .add("KmsKeyId", kmsKeyId()).add("DbClusterIdentifier", dbClusterIdentifier())
                .add("DbClusterSnapshotIdentifier", dbClusterSnapshotIdentifier())
                .add("IamDatabaseAuthenticationEnabled", iamDatabaseAuthenticationEnabled())
                .add("DbClusterSnapshotAttributes", hasDbClusterSnapshotAttributes() ? dbClusterSnapshotAttributes() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AvailabilityZones":
            return Optional.ofNullable(clazz.cast(availabilityZones()));
        case "SnapshotCreateTime":
            return Optional.ofNullable(clazz.cast(snapshotCreateTime()));
        case "Engine":
            return Optional.ofNullable(clazz.cast(engine()));
        case "AllocatedStorage":
            return Optional.ofNullable(clazz.cast(allocatedStorage()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        case "Port":
            return Optional.ofNullable(clazz.cast(port()));
        case "VpcId":
            return Optional.ofNullable(clazz.cast(vpcId()));
        case "ClusterCreateTime":
            return Optional.ofNullable(clazz.cast(clusterCreateTime()));
        case "MasterUsername":
            return Optional.ofNullable(clazz.cast(masterUsername()));
        case "EngineVersion":
            return Optional.ofNullable(clazz.cast(engineVersion()));
        case "LicenseModel":
            return Optional.ofNullable(clazz.cast(licenseModel()));
        case "SnapshotType":
            return Optional.ofNullable(clazz.cast(snapshotType()));
        case "PercentProgress":
            return Optional.ofNullable(clazz.cast(percentProgress()));
        case "StorageEncrypted":
            return Optional.ofNullable(clazz.cast(storageEncrypted()));
        case "KmsKeyId":
            return Optional.ofNullable(clazz.cast(kmsKeyId()));
        case "DbClusterIdentifier":
            return Optional.ofNullable(clazz.cast(dbClusterIdentifier()));
        case "DbClusterSnapshotIdentifier":
            return Optional.ofNullable(clazz.cast(dbClusterSnapshotIdentifier()));
        case "IamDatabaseAuthenticationEnabled":
            return Optional.ofNullable(clazz.cast(iamDatabaseAuthenticationEnabled()));
        case "DbClusterSnapshotAttributes":
            return Optional.ofNullable(clazz.cast(dbClusterSnapshotAttributes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsRdsDbClusterSnapshotDetails, T> g) {
        return obj -> g.apply((AwsRdsDbClusterSnapshotDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsRdsDbClusterSnapshotDetails> {
        /**
         * <p>
         * A list of Availability Zones where instances in the DB cluster can be created.
         * </p>
         * 
         * @param availabilityZones
         *        A list of Availability Zones where instances in the DB cluster can be created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZones(Collection<String> availabilityZones);

        /**
         * <p>
         * A list of Availability Zones where instances in the DB cluster can be created.
         * </p>
         * 
         * @param availabilityZones
         *        A list of Availability Zones where instances in the DB cluster can be created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZones(String... availabilityZones);

        /**
         * <p>
         * Indicates when the snapshot was taken.
         * </p>
         * <p>
         * This field accepts only the specified formats. Timestamps can end with <code>Z</code> or
         * <code>("+" / "-") time-hour [":" time-minute]</code>. The time-secfrac after seconds is limited to a maximum
         * of 9 digits. The offset is bounded by +/-18:00. Here are valid timestamp formats with examples:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>YYYY-MM-DDTHH:MM:SSZ</code> (for example, <code>2019-01-31T23:00:00Z</code>)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ</code> (for example, <code>2019-01-31T23:00:00.123456789Z</code>)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>YYYY-MM-DDTHH:MM:SS+HH:MM</code> (for example, <code>2024-01-04T15:25:10+17:59</code>)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>YYYY-MM-DDTHH:MM:SS-HHMM</code> (for example, <code>2024-01-04T15:25:10-1759</code>)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM</code> (for example,
         * <code>2024-01-04T15:25:10.123456789+17:59</code>)
         * </p>
         * </li>
         * </ul>
         * 
         * @param snapshotCreateTime
         *        Indicates when the snapshot was taken.</p>
         *        <p>
         *        This field accepts only the specified formats. Timestamps can end with <code>Z</code> or
         *        <code>("+" / "-") time-hour [":" time-minute]</code>. The time-secfrac after seconds is limited to a
         *        maximum of 9 digits. The offset is bounded by +/-18:00. Here are valid timestamp formats with
         *        examples:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>YYYY-MM-DDTHH:MM:SSZ</code> (for example, <code>2019-01-31T23:00:00Z</code>)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ</code> (for example, <code>2019-01-31T23:00:00.123456789Z</code>)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>YYYY-MM-DDTHH:MM:SS+HH:MM</code> (for example, <code>2024-01-04T15:25:10+17:59</code>)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>YYYY-MM-DDTHH:MM:SS-HHMM</code> (for example, <code>2024-01-04T15:25:10-1759</code>)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM</code> (for example,
         *        <code>2024-01-04T15:25:10.123456789+17:59</code>)
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotCreateTime(String snapshotCreateTime);

        /**
         * <p>
         * The name of the database engine that you want to use for this DB instance.
         * </p>
         * 
         * @param engine
         *        The name of the database engine that you want to use for this DB instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engine(String engine);

        /**
         * <p>
         * Specifies the allocated storage size in gibibytes (GiB).
         * </p>
         * 
         * @param allocatedStorage
         *        Specifies the allocated storage size in gibibytes (GiB).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allocatedStorage(Integer allocatedStorage);

        /**
         * <p>
         * The status of this DB cluster snapshot.
         * </p>
         * 
         * @param status
         *        The status of this DB cluster snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * The port number on which the DB instances in the DB cluster accept connections.
         * </p>
         * 
         * @param port
         *        The port number on which the DB instances in the DB cluster accept connections.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder port(Integer port);

        /**
         * <p>
         * The VPC ID that is associated with the DB cluster snapshot.
         * </p>
         * 
         * @param vpcId
         *        The VPC ID that is associated with the DB cluster snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcId(String vpcId);

        /**
         * <p>
         * Indicates when the DB cluster was created, in Universal Coordinated Time (UTC).
         * </p>
         * <p>
         * This field accepts only the specified formats. Timestamps can end with <code>Z</code> or
         * <code>("+" / "-") time-hour [":" time-minute]</code>. The time-secfrac after seconds is limited to a maximum
         * of 9 digits. The offset is bounded by +/-18:00. Here are valid timestamp formats with examples:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>YYYY-MM-DDTHH:MM:SSZ</code> (for example, <code>2019-01-31T23:00:00Z</code>)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ</code> (for example, <code>2019-01-31T23:00:00.123456789Z</code>)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>YYYY-MM-DDTHH:MM:SS+HH:MM</code> (for example, <code>2024-01-04T15:25:10+17:59</code>)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>YYYY-MM-DDTHH:MM:SS-HHMM</code> (for example, <code>2024-01-04T15:25:10-1759</code>)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM</code> (for example,
         * <code>2024-01-04T15:25:10.123456789+17:59</code>)
         * </p>
         * </li>
         * </ul>
         * 
         * @param clusterCreateTime
         *        Indicates when the DB cluster was created, in Universal Coordinated Time (UTC).</p>
         *        <p>
         *        This field accepts only the specified formats. Timestamps can end with <code>Z</code> or
         *        <code>("+" / "-") time-hour [":" time-minute]</code>. The time-secfrac after seconds is limited to a
         *        maximum of 9 digits. The offset is bounded by +/-18:00. Here are valid timestamp formats with
         *        examples:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>YYYY-MM-DDTHH:MM:SSZ</code> (for example, <code>2019-01-31T23:00:00Z</code>)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ</code> (for example, <code>2019-01-31T23:00:00.123456789Z</code>)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>YYYY-MM-DDTHH:MM:SS+HH:MM</code> (for example, <code>2024-01-04T15:25:10+17:59</code>)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>YYYY-MM-DDTHH:MM:SS-HHMM</code> (for example, <code>2024-01-04T15:25:10-1759</code>)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM</code> (for example,
         *        <code>2024-01-04T15:25:10.123456789+17:59</code>)
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterCreateTime(String clusterCreateTime);

        /**
         * <p>
         * The name of the master user for the DB cluster.
         * </p>
         * 
         * @param masterUsername
         *        The name of the master user for the DB cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder masterUsername(String masterUsername);

        /**
         * <p>
         * The version of the database engine to use.
         * </p>
         * 
         * @param engineVersion
         *        The version of the database engine to use.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engineVersion(String engineVersion);

        /**
         * <p>
         * The license model information for this DB cluster snapshot.
         * </p>
         * 
         * @param licenseModel
         *        The license model information for this DB cluster snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder licenseModel(String licenseModel);

        /**
         * <p>
         * The type of DB cluster snapshot.
         * </p>
         * 
         * @param snapshotType
         *        The type of DB cluster snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotType(String snapshotType);

        /**
         * <p>
         * Specifies the percentage of the estimated data that has been transferred.
         * </p>
         * 
         * @param percentProgress
         *        Specifies the percentage of the estimated data that has been transferred.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder percentProgress(Integer percentProgress);

        /**
         * <p>
         * Whether the DB cluster is encrypted.
         * </p>
         * 
         * @param storageEncrypted
         *        Whether the DB cluster is encrypted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageEncrypted(Boolean storageEncrypted);

        /**
         * <p>
         * The ARN of the KMS master key that is used to encrypt the database instances in the DB cluster.
         * </p>
         * 
         * @param kmsKeyId
         *        The ARN of the KMS master key that is used to encrypt the database instances in the DB cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyId(String kmsKeyId);

        /**
         * <p>
         * The DB cluster identifier.
         * </p>
         * 
         * @param dbClusterIdentifier
         *        The DB cluster identifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbClusterIdentifier(String dbClusterIdentifier);

        /**
         * <p>
         * The identifier of the DB cluster snapshot.
         * </p>
         * 
         * @param dbClusterSnapshotIdentifier
         *        The identifier of the DB cluster snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbClusterSnapshotIdentifier(String dbClusterSnapshotIdentifier);

        /**
         * <p>
         * Whether mapping of IAM accounts to database accounts is enabled.
         * </p>
         * 
         * @param iamDatabaseAuthenticationEnabled
         *        Whether mapping of IAM accounts to database accounts is enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iamDatabaseAuthenticationEnabled(Boolean iamDatabaseAuthenticationEnabled);

        /**
         * <p>
         * Contains the name and values of a manual DB cluster snapshot attribute.
         * </p>
         * 
         * @param dbClusterSnapshotAttributes
         *        Contains the name and values of a manual DB cluster snapshot attribute.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbClusterSnapshotAttributes(
                Collection<AwsRdsDbClusterSnapshotDbClusterSnapshotAttribute> dbClusterSnapshotAttributes);

        /**
         * <p>
         * Contains the name and values of a manual DB cluster snapshot attribute.
         * </p>
         * 
         * @param dbClusterSnapshotAttributes
         *        Contains the name and values of a manual DB cluster snapshot attribute.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbClusterSnapshotAttributes(AwsRdsDbClusterSnapshotDbClusterSnapshotAttribute... dbClusterSnapshotAttributes);

        /**
         * <p>
         * Contains the name and values of a manual DB cluster snapshot attribute.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityhub.model.AwsRdsDbClusterSnapshotDbClusterSnapshotAttribute.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.securityhub.model.AwsRdsDbClusterSnapshotDbClusterSnapshotAttribute#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityhub.model.AwsRdsDbClusterSnapshotDbClusterSnapshotAttribute.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #dbClusterSnapshotAttributes(List<AwsRdsDbClusterSnapshotDbClusterSnapshotAttribute>)}.
         * 
         * @param dbClusterSnapshotAttributes
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityhub.model.AwsRdsDbClusterSnapshotDbClusterSnapshotAttribute.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dbClusterSnapshotAttributes(java.util.Collection<AwsRdsDbClusterSnapshotDbClusterSnapshotAttribute>)
         */
        Builder dbClusterSnapshotAttributes(
                Consumer<AwsRdsDbClusterSnapshotDbClusterSnapshotAttribute.Builder>... dbClusterSnapshotAttributes);
    }

    static final class BuilderImpl implements Builder {
        private List<String> availabilityZones = DefaultSdkAutoConstructList.getInstance();

        private String snapshotCreateTime;

        private String engine;

        private Integer allocatedStorage;

        private String status;

        private Integer port;

        private String vpcId;

        private String clusterCreateTime;

        private String masterUsername;

        private String engineVersion;

        private String licenseModel;

        private String snapshotType;

        private Integer percentProgress;

        private Boolean storageEncrypted;

        private String kmsKeyId;

        private String dbClusterIdentifier;

        private String dbClusterSnapshotIdentifier;

        private Boolean iamDatabaseAuthenticationEnabled;

        private List<AwsRdsDbClusterSnapshotDbClusterSnapshotAttribute> dbClusterSnapshotAttributes = DefaultSdkAutoConstructList
                .getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AwsRdsDbClusterSnapshotDetails model) {
            availabilityZones(model.availabilityZones);
            snapshotCreateTime(model.snapshotCreateTime);
            engine(model.engine);
            allocatedStorage(model.allocatedStorage);
            status(model.status);
            port(model.port);
            vpcId(model.vpcId);
            clusterCreateTime(model.clusterCreateTime);
            masterUsername(model.masterUsername);
            engineVersion(model.engineVersion);
            licenseModel(model.licenseModel);
            snapshotType(model.snapshotType);
            percentProgress(model.percentProgress);
            storageEncrypted(model.storageEncrypted);
            kmsKeyId(model.kmsKeyId);
            dbClusterIdentifier(model.dbClusterIdentifier);
            dbClusterSnapshotIdentifier(model.dbClusterSnapshotIdentifier);
            iamDatabaseAuthenticationEnabled(model.iamDatabaseAuthenticationEnabled);
            dbClusterSnapshotAttributes(model.dbClusterSnapshotAttributes);
        }

        public final Collection<String> getAvailabilityZones() {
            if (availabilityZones instanceof SdkAutoConstructList) {
                return null;
            }
            return availabilityZones;
        }

        public final void setAvailabilityZones(Collection<String> availabilityZones) {
            this.availabilityZones = StringListCopier.copy(availabilityZones);
        }

        @Override
        public final Builder availabilityZones(Collection<String> availabilityZones) {
            this.availabilityZones = StringListCopier.copy(availabilityZones);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder availabilityZones(String... availabilityZones) {
            availabilityZones(Arrays.asList(availabilityZones));
            return this;
        }

        public final String getSnapshotCreateTime() {
            return snapshotCreateTime;
        }

        public final void setSnapshotCreateTime(String snapshotCreateTime) {
            this.snapshotCreateTime = snapshotCreateTime;
        }

        @Override
        public final Builder snapshotCreateTime(String snapshotCreateTime) {
            this.snapshotCreateTime = snapshotCreateTime;
            return this;
        }

        public final String getEngine() {
            return engine;
        }

        public final void setEngine(String engine) {
            this.engine = engine;
        }

        @Override
        public final Builder engine(String engine) {
            this.engine = engine;
            return this;
        }

        public final Integer getAllocatedStorage() {
            return allocatedStorage;
        }

        public final void setAllocatedStorage(Integer allocatedStorage) {
            this.allocatedStorage = allocatedStorage;
        }

        @Override
        public final Builder allocatedStorage(Integer allocatedStorage) {
            this.allocatedStorage = allocatedStorage;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final Integer getPort() {
            return port;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final String getVpcId() {
            return vpcId;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final String getClusterCreateTime() {
            return clusterCreateTime;
        }

        public final void setClusterCreateTime(String clusterCreateTime) {
            this.clusterCreateTime = clusterCreateTime;
        }

        @Override
        public final Builder clusterCreateTime(String clusterCreateTime) {
            this.clusterCreateTime = clusterCreateTime;
            return this;
        }

        public final String getMasterUsername() {
            return masterUsername;
        }

        public final void setMasterUsername(String masterUsername) {
            this.masterUsername = masterUsername;
        }

        @Override
        public final Builder masterUsername(String masterUsername) {
            this.masterUsername = masterUsername;
            return this;
        }

        public final String getEngineVersion() {
            return engineVersion;
        }

        public final void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        @Override
        public final Builder engineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final String getLicenseModel() {
            return licenseModel;
        }

        public final void setLicenseModel(String licenseModel) {
            this.licenseModel = licenseModel;
        }

        @Override
        public final Builder licenseModel(String licenseModel) {
            this.licenseModel = licenseModel;
            return this;
        }

        public final String getSnapshotType() {
            return snapshotType;
        }

        public final void setSnapshotType(String snapshotType) {
            this.snapshotType = snapshotType;
        }

        @Override
        public final Builder snapshotType(String snapshotType) {
            this.snapshotType = snapshotType;
            return this;
        }

        public final Integer getPercentProgress() {
            return percentProgress;
        }

        public final void setPercentProgress(Integer percentProgress) {
            this.percentProgress = percentProgress;
        }

        @Override
        public final Builder percentProgress(Integer percentProgress) {
            this.percentProgress = percentProgress;
            return this;
        }

        public final Boolean getStorageEncrypted() {
            return storageEncrypted;
        }

        public final void setStorageEncrypted(Boolean storageEncrypted) {
            this.storageEncrypted = storageEncrypted;
        }

        @Override
        public final Builder storageEncrypted(Boolean storageEncrypted) {
            this.storageEncrypted = storageEncrypted;
            return this;
        }

        public final String getKmsKeyId() {
            return kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final String getDbClusterIdentifier() {
            return dbClusterIdentifier;
        }

        public final void setDbClusterIdentifier(String dbClusterIdentifier) {
            this.dbClusterIdentifier = dbClusterIdentifier;
        }

        @Override
        public final Builder dbClusterIdentifier(String dbClusterIdentifier) {
            this.dbClusterIdentifier = dbClusterIdentifier;
            return this;
        }

        public final String getDbClusterSnapshotIdentifier() {
            return dbClusterSnapshotIdentifier;
        }

        public final void setDbClusterSnapshotIdentifier(String dbClusterSnapshotIdentifier) {
            this.dbClusterSnapshotIdentifier = dbClusterSnapshotIdentifier;
        }

        @Override
        public final Builder dbClusterSnapshotIdentifier(String dbClusterSnapshotIdentifier) {
            this.dbClusterSnapshotIdentifier = dbClusterSnapshotIdentifier;
            return this;
        }

        public final Boolean getIamDatabaseAuthenticationEnabled() {
            return iamDatabaseAuthenticationEnabled;
        }

        public final void setIamDatabaseAuthenticationEnabled(Boolean iamDatabaseAuthenticationEnabled) {
            this.iamDatabaseAuthenticationEnabled = iamDatabaseAuthenticationEnabled;
        }

        @Override
        public final Builder iamDatabaseAuthenticationEnabled(Boolean iamDatabaseAuthenticationEnabled) {
            this.iamDatabaseAuthenticationEnabled = iamDatabaseAuthenticationEnabled;
            return this;
        }

        public final List<AwsRdsDbClusterSnapshotDbClusterSnapshotAttribute.Builder> getDbClusterSnapshotAttributes() {
            List<AwsRdsDbClusterSnapshotDbClusterSnapshotAttribute.Builder> result = AwsRdsDbClusterSnapshotDbClusterSnapshotAttributesCopier
                    .copyToBuilder(this.dbClusterSnapshotAttributes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDbClusterSnapshotAttributes(
                Collection<AwsRdsDbClusterSnapshotDbClusterSnapshotAttribute.BuilderImpl> dbClusterSnapshotAttributes) {
            this.dbClusterSnapshotAttributes = AwsRdsDbClusterSnapshotDbClusterSnapshotAttributesCopier
                    .copyFromBuilder(dbClusterSnapshotAttributes);
        }

        @Override
        public final Builder dbClusterSnapshotAttributes(
                Collection<AwsRdsDbClusterSnapshotDbClusterSnapshotAttribute> dbClusterSnapshotAttributes) {
            this.dbClusterSnapshotAttributes = AwsRdsDbClusterSnapshotDbClusterSnapshotAttributesCopier
                    .copy(dbClusterSnapshotAttributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dbClusterSnapshotAttributes(
                AwsRdsDbClusterSnapshotDbClusterSnapshotAttribute... dbClusterSnapshotAttributes) {
            dbClusterSnapshotAttributes(Arrays.asList(dbClusterSnapshotAttributes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dbClusterSnapshotAttributes(
                Consumer<AwsRdsDbClusterSnapshotDbClusterSnapshotAttribute.Builder>... dbClusterSnapshotAttributes) {
            dbClusterSnapshotAttributes(Stream.of(dbClusterSnapshotAttributes)
                    .map(c -> AwsRdsDbClusterSnapshotDbClusterSnapshotAttribute.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public AwsRdsDbClusterSnapshotDetails build() {
            return new AwsRdsDbClusterSnapshotDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
