/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetConfigurationPolicyResponse extends SecurityHubResponse implements
        ToCopyableBuilder<GetConfigurationPolicyResponse.Builder, GetConfigurationPolicyResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(GetConfigurationPolicyResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(GetConfigurationPolicyResponse::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(GetConfigurationPolicyResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(GetConfigurationPolicyResponse::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("UpdatedAt")
            .getter(getter(GetConfigurationPolicyResponse::updatedAt))
            .setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdatedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedAt")
            .getter(getter(GetConfigurationPolicyResponse::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Policy> CONFIGURATION_POLICY_FIELD = SdkField.<Policy> builder(MarshallingType.SDK_POJO)
            .memberName("ConfigurationPolicy").getter(getter(GetConfigurationPolicyResponse::configurationPolicy))
            .setter(setter(Builder::configurationPolicy)).constructor(Policy::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationPolicy").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, ID_FIELD,
            NAME_FIELD, DESCRIPTION_FIELD, UPDATED_AT_FIELD, CREATED_AT_FIELD, CONFIGURATION_POLICY_FIELD));

    private final String arn;

    private final String id;

    private final String name;

    private final String description;

    private final Instant updatedAt;

    private final Instant createdAt;

    private final Policy configurationPolicy;

    private GetConfigurationPolicyResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.id = builder.id;
        this.name = builder.name;
        this.description = builder.description;
        this.updatedAt = builder.updatedAt;
        this.createdAt = builder.createdAt;
        this.configurationPolicy = builder.configurationPolicy;
    }

    /**
     * <p>
     * The ARN of the configuration policy.
     * </p>
     * 
     * @return The ARN of the configuration policy.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The UUID of the configuration policy.
     * </p>
     * 
     * @return The UUID of the configuration policy.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The name of the configuration policy.
     * </p>
     * 
     * @return The name of the configuration policy.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The description of the configuration policy.
     * </p>
     * 
     * @return The description of the configuration policy.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The date and time, in UTC and ISO 8601 format, that the configuration policy was last updated.
     * </p>
     * 
     * @return The date and time, in UTC and ISO 8601 format, that the configuration policy was last updated.
     */
    public final Instant updatedAt() {
        return updatedAt;
    }

    /**
     * <p>
     * The date and time, in UTC and ISO 8601 format, that the configuration policy was created.
     * </p>
     * 
     * @return The date and time, in UTC and ISO 8601 format, that the configuration policy was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * An object that defines how Security Hub is configured. It includes whether Security Hub is enabled or disabled, a
     * list of enabled security standards, a list of enabled or disabled security controls, and a list of custom
     * parameter values for specified controls. If the policy includes a list of security controls that are enabled,
     * Security Hub disables all other controls (including newly released controls). If the policy includes a list of
     * security controls that are disabled, Security Hub enables all other controls (including newly released controls).
     * </p>
     * 
     * @return An object that defines how Security Hub is configured. It includes whether Security Hub is enabled or
     *         disabled, a list of enabled security standards, a list of enabled or disabled security controls, and a
     *         list of custom parameter values for specified controls. If the policy includes a list of security
     *         controls that are enabled, Security Hub disables all other controls (including newly released controls).
     *         If the policy includes a list of security controls that are disabled, Security Hub enables all other
     *         controls (including newly released controls).
     */
    public final Policy configurationPolicy() {
        return configurationPolicy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(configurationPolicy());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetConfigurationPolicyResponse)) {
            return false;
        }
        GetConfigurationPolicyResponse other = (GetConfigurationPolicyResponse) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(id(), other.id()) && Objects.equals(name(), other.name())
                && Objects.equals(description(), other.description()) && Objects.equals(updatedAt(), other.updatedAt())
                && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(configurationPolicy(), other.configurationPolicy());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetConfigurationPolicyResponse").add("Arn", arn()).add("Id", id()).add("Name", name())
                .add("Description", description()).add("UpdatedAt", updatedAt()).add("CreatedAt", createdAt())
                .add("ConfigurationPolicy", configurationPolicy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "UpdatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        case "CreatedAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "ConfigurationPolicy":
            return Optional.ofNullable(clazz.cast(configurationPolicy()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetConfigurationPolicyResponse, T> g) {
        return obj -> g.apply((GetConfigurationPolicyResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SecurityHubResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetConfigurationPolicyResponse> {
        /**
         * <p>
         * The ARN of the configuration policy.
         * </p>
         * 
         * @param arn
         *        The ARN of the configuration policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The UUID of the configuration policy.
         * </p>
         * 
         * @param id
         *        The UUID of the configuration policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The name of the configuration policy.
         * </p>
         * 
         * @param name
         *        The name of the configuration policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The description of the configuration policy.
         * </p>
         * 
         * @param description
         *        The description of the configuration policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The date and time, in UTC and ISO 8601 format, that the configuration policy was last updated.
         * </p>
         * 
         * @param updatedAt
         *        The date and time, in UTC and ISO 8601 format, that the configuration policy was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);

        /**
         * <p>
         * The date and time, in UTC and ISO 8601 format, that the configuration policy was created.
         * </p>
         * 
         * @param createdAt
         *        The date and time, in UTC and ISO 8601 format, that the configuration policy was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * An object that defines how Security Hub is configured. It includes whether Security Hub is enabled or
         * disabled, a list of enabled security standards, a list of enabled or disabled security controls, and a list
         * of custom parameter values for specified controls. If the policy includes a list of security controls that
         * are enabled, Security Hub disables all other controls (including newly released controls). If the policy
         * includes a list of security controls that are disabled, Security Hub enables all other controls (including
         * newly released controls).
         * </p>
         * 
         * @param configurationPolicy
         *        An object that defines how Security Hub is configured. It includes whether Security Hub is enabled or
         *        disabled, a list of enabled security standards, a list of enabled or disabled security controls, and a
         *        list of custom parameter values for specified controls. If the policy includes a list of security
         *        controls that are enabled, Security Hub disables all other controls (including newly released
         *        controls). If the policy includes a list of security controls that are disabled, Security Hub enables
         *        all other controls (including newly released controls).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationPolicy(Policy configurationPolicy);

        /**
         * <p>
         * An object that defines how Security Hub is configured. It includes whether Security Hub is enabled or
         * disabled, a list of enabled security standards, a list of enabled or disabled security controls, and a list
         * of custom parameter values for specified controls. If the policy includes a list of security controls that
         * are enabled, Security Hub disables all other controls (including newly released controls). If the policy
         * includes a list of security controls that are disabled, Security Hub enables all other controls (including
         * newly released controls).
         * </p>
         * This is a convenience method that creates an instance of the {@link Policy.Builder} avoiding the need to
         * create one manually via {@link Policy#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Policy.Builder#build()} is called immediately and its result is
         * passed to {@link #configurationPolicy(Policy)}.
         * 
         * @param configurationPolicy
         *        a consumer that will call methods on {@link Policy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #configurationPolicy(Policy)
         */
        default Builder configurationPolicy(Consumer<Policy.Builder> configurationPolicy) {
            return configurationPolicy(Policy.builder().applyMutation(configurationPolicy).build());
        }
    }

    static final class BuilderImpl extends SecurityHubResponse.BuilderImpl implements Builder {
        private String arn;

        private String id;

        private String name;

        private String description;

        private Instant updatedAt;

        private Instant createdAt;

        private Policy configurationPolicy;

        private BuilderImpl() {
        }

        private BuilderImpl(GetConfigurationPolicyResponse model) {
            super(model);
            arn(model.arn);
            id(model.id);
            name(model.name);
            description(model.description);
            updatedAt(model.updatedAt);
            createdAt(model.createdAt);
            configurationPolicy(model.configurationPolicy);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Policy.Builder getConfigurationPolicy() {
            return configurationPolicy != null ? configurationPolicy.toBuilder() : null;
        }

        public final void setConfigurationPolicy(Policy.BuilderImpl configurationPolicy) {
            this.configurationPolicy = configurationPolicy != null ? configurationPolicy.build() : null;
        }

        @Override
        public final Builder configurationPolicy(Policy configurationPolicy) {
            this.configurationPolicy = configurationPolicy;
            return this;
        }

        @Override
        public GetConfigurationPolicyResponse build() {
            return new GetConfigurationPolicyResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
