/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides details about the routes in the route table.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RouteSetDetails implements SdkPojo, Serializable, ToCopyableBuilder<RouteSetDetails.Builder, RouteSetDetails> {
    private static final SdkField<String> CARRIER_GATEWAY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CarrierGatewayId").getter(getter(RouteSetDetails::carrierGatewayId))
            .setter(setter(Builder::carrierGatewayId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CarrierGatewayId").build()).build();

    private static final SdkField<String> CORE_NETWORK_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CoreNetworkArn").getter(getter(RouteSetDetails::coreNetworkArn)).setter(setter(Builder::coreNetworkArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CoreNetworkArn").build()).build();

    private static final SdkField<String> DESTINATION_CIDR_BLOCK_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DestinationCidrBlock").getter(getter(RouteSetDetails::destinationCidrBlock))
            .setter(setter(Builder::destinationCidrBlock))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationCidrBlock").build())
            .build();

    private static final SdkField<String> DESTINATION_IPV6_CIDR_BLOCK_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DestinationIpv6CidrBlock").getter(getter(RouteSetDetails::destinationIpv6CidrBlock))
            .setter(setter(Builder::destinationIpv6CidrBlock))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationIpv6CidrBlock").build())
            .build();

    private static final SdkField<String> DESTINATION_PREFIX_LIST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DestinationPrefixListId").getter(getter(RouteSetDetails::destinationPrefixListId))
            .setter(setter(Builder::destinationPrefixListId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationPrefixListId").build())
            .build();

    private static final SdkField<String> EGRESS_ONLY_INTERNET_GATEWAY_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("EgressOnlyInternetGatewayId")
            .getter(getter(RouteSetDetails::egressOnlyInternetGatewayId))
            .setter(setter(Builder::egressOnlyInternetGatewayId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EgressOnlyInternetGatewayId")
                    .build()).build();

    private static final SdkField<String> GATEWAY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GatewayId").getter(getter(RouteSetDetails::gatewayId)).setter(setter(Builder::gatewayId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatewayId").build()).build();

    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceId").getter(getter(RouteSetDetails::instanceId)).setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId").build()).build();

    private static final SdkField<String> INSTANCE_OWNER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceOwnerId").getter(getter(RouteSetDetails::instanceOwnerId))
            .setter(setter(Builder::instanceOwnerId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceOwnerId").build()).build();

    private static final SdkField<String> LOCAL_GATEWAY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LocalGatewayId").getter(getter(RouteSetDetails::localGatewayId)).setter(setter(Builder::localGatewayId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocalGatewayId").build()).build();

    private static final SdkField<String> NAT_GATEWAY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NatGatewayId").getter(getter(RouteSetDetails::natGatewayId)).setter(setter(Builder::natGatewayId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NatGatewayId").build()).build();

    private static final SdkField<String> NETWORK_INTERFACE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NetworkInterfaceId").getter(getter(RouteSetDetails::networkInterfaceId))
            .setter(setter(Builder::networkInterfaceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkInterfaceId").build())
            .build();

    private static final SdkField<String> ORIGIN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Origin")
            .getter(getter(RouteSetDetails::origin)).setter(setter(Builder::origin))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Origin").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("State")
            .getter(getter(RouteSetDetails::state)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()).build();

    private static final SdkField<String> TRANSIT_GATEWAY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TransitGatewayId").getter(getter(RouteSetDetails::transitGatewayId))
            .setter(setter(Builder::transitGatewayId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransitGatewayId").build()).build();

    private static final SdkField<String> VPC_PEERING_CONNECTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VpcPeeringConnectionId").getter(getter(RouteSetDetails::vpcPeeringConnectionId))
            .setter(setter(Builder::vpcPeeringConnectionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcPeeringConnectionId").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CARRIER_GATEWAY_ID_FIELD,
            CORE_NETWORK_ARN_FIELD, DESTINATION_CIDR_BLOCK_FIELD, DESTINATION_IPV6_CIDR_BLOCK_FIELD,
            DESTINATION_PREFIX_LIST_ID_FIELD, EGRESS_ONLY_INTERNET_GATEWAY_ID_FIELD, GATEWAY_ID_FIELD, INSTANCE_ID_FIELD,
            INSTANCE_OWNER_ID_FIELD, LOCAL_GATEWAY_ID_FIELD, NAT_GATEWAY_ID_FIELD, NETWORK_INTERFACE_ID_FIELD, ORIGIN_FIELD,
            STATE_FIELD, TRANSIT_GATEWAY_ID_FIELD, VPC_PEERING_CONNECTION_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String carrierGatewayId;

    private final String coreNetworkArn;

    private final String destinationCidrBlock;

    private final String destinationIpv6CidrBlock;

    private final String destinationPrefixListId;

    private final String egressOnlyInternetGatewayId;

    private final String gatewayId;

    private final String instanceId;

    private final String instanceOwnerId;

    private final String localGatewayId;

    private final String natGatewayId;

    private final String networkInterfaceId;

    private final String origin;

    private final String state;

    private final String transitGatewayId;

    private final String vpcPeeringConnectionId;

    private RouteSetDetails(BuilderImpl builder) {
        this.carrierGatewayId = builder.carrierGatewayId;
        this.coreNetworkArn = builder.coreNetworkArn;
        this.destinationCidrBlock = builder.destinationCidrBlock;
        this.destinationIpv6CidrBlock = builder.destinationIpv6CidrBlock;
        this.destinationPrefixListId = builder.destinationPrefixListId;
        this.egressOnlyInternetGatewayId = builder.egressOnlyInternetGatewayId;
        this.gatewayId = builder.gatewayId;
        this.instanceId = builder.instanceId;
        this.instanceOwnerId = builder.instanceOwnerId;
        this.localGatewayId = builder.localGatewayId;
        this.natGatewayId = builder.natGatewayId;
        this.networkInterfaceId = builder.networkInterfaceId;
        this.origin = builder.origin;
        this.state = builder.state;
        this.transitGatewayId = builder.transitGatewayId;
        this.vpcPeeringConnectionId = builder.vpcPeeringConnectionId;
    }

    /**
     * <p>
     * The ID of the carrier gateway.
     * </p>
     * 
     * @return The ID of the carrier gateway.
     */
    public final String carrierGatewayId() {
        return carrierGatewayId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the core network.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the core network.
     */
    public final String coreNetworkArn() {
        return coreNetworkArn;
    }

    /**
     * <p>
     * The IPv4 CIDR block used for the destination match.
     * </p>
     * 
     * @return The IPv4 CIDR block used for the destination match.
     */
    public final String destinationCidrBlock() {
        return destinationCidrBlock;
    }

    /**
     * <p>
     * The IPv6 CIDR block used for the destination match.
     * </p>
     * 
     * @return The IPv6 CIDR block used for the destination match.
     */
    public final String destinationIpv6CidrBlock() {
        return destinationIpv6CidrBlock;
    }

    /**
     * <p>
     * The prefix of the destination Amazon Web Servicesservice.
     * </p>
     * 
     * @return The prefix of the destination Amazon Web Servicesservice.
     */
    public final String destinationPrefixListId() {
        return destinationPrefixListId;
    }

    /**
     * <p>
     * The ID of the egress-only internet gateway.
     * </p>
     * 
     * @return The ID of the egress-only internet gateway.
     */
    public final String egressOnlyInternetGatewayId() {
        return egressOnlyInternetGatewayId;
    }

    /**
     * <p>
     * The ID of a gateway attached to your VPC.
     * </p>
     * 
     * @return The ID of a gateway attached to your VPC.
     */
    public final String gatewayId() {
        return gatewayId;
    }

    /**
     * <p>
     * The ID of a NAT instance in your VPC.
     * </p>
     * 
     * @return The ID of a NAT instance in your VPC.
     */
    public final String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * The ID of the Amazon Web Services account that owns the instance.
     * </p>
     * 
     * @return The ID of the Amazon Web Services account that owns the instance.
     */
    public final String instanceOwnerId() {
        return instanceOwnerId;
    }

    /**
     * <p>
     * The ID of the local gateway.
     * </p>
     * 
     * @return The ID of the local gateway.
     */
    public final String localGatewayId() {
        return localGatewayId;
    }

    /**
     * <p>
     * The ID of a NAT gateway.
     * </p>
     * 
     * @return The ID of a NAT gateway.
     */
    public final String natGatewayId() {
        return natGatewayId;
    }

    /**
     * <p>
     * The ID of the network interface.
     * </p>
     * 
     * @return The ID of the network interface.
     */
    public final String networkInterfaceId() {
        return networkInterfaceId;
    }

    /**
     * <p>
     * Describes how the route was created.
     * </p>
     * 
     * @return Describes how the route was created.
     */
    public final String origin() {
        return origin;
    }

    /**
     * <p>
     * The state of the route.
     * </p>
     * 
     * @return The state of the route.
     */
    public final String state() {
        return state;
    }

    /**
     * <p>
     * The ID of a transit gateway.
     * </p>
     * 
     * @return The ID of a transit gateway.
     */
    public final String transitGatewayId() {
        return transitGatewayId;
    }

    /**
     * <p>
     * The ID of a VPC peering connection.
     * </p>
     * 
     * @return The ID of a VPC peering connection.
     */
    public final String vpcPeeringConnectionId() {
        return vpcPeeringConnectionId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(carrierGatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(coreNetworkArn());
        hashCode = 31 * hashCode + Objects.hashCode(destinationCidrBlock());
        hashCode = 31 * hashCode + Objects.hashCode(destinationIpv6CidrBlock());
        hashCode = 31 * hashCode + Objects.hashCode(destinationPrefixListId());
        hashCode = 31 * hashCode + Objects.hashCode(egressOnlyInternetGatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(gatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(instanceOwnerId());
        hashCode = 31 * hashCode + Objects.hashCode(localGatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(natGatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(networkInterfaceId());
        hashCode = 31 * hashCode + Objects.hashCode(origin());
        hashCode = 31 * hashCode + Objects.hashCode(state());
        hashCode = 31 * hashCode + Objects.hashCode(transitGatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(vpcPeeringConnectionId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RouteSetDetails)) {
            return false;
        }
        RouteSetDetails other = (RouteSetDetails) obj;
        return Objects.equals(carrierGatewayId(), other.carrierGatewayId())
                && Objects.equals(coreNetworkArn(), other.coreNetworkArn())
                && Objects.equals(destinationCidrBlock(), other.destinationCidrBlock())
                && Objects.equals(destinationIpv6CidrBlock(), other.destinationIpv6CidrBlock())
                && Objects.equals(destinationPrefixListId(), other.destinationPrefixListId())
                && Objects.equals(egressOnlyInternetGatewayId(), other.egressOnlyInternetGatewayId())
                && Objects.equals(gatewayId(), other.gatewayId()) && Objects.equals(instanceId(), other.instanceId())
                && Objects.equals(instanceOwnerId(), other.instanceOwnerId())
                && Objects.equals(localGatewayId(), other.localGatewayId())
                && Objects.equals(natGatewayId(), other.natGatewayId())
                && Objects.equals(networkInterfaceId(), other.networkInterfaceId()) && Objects.equals(origin(), other.origin())
                && Objects.equals(state(), other.state()) && Objects.equals(transitGatewayId(), other.transitGatewayId())
                && Objects.equals(vpcPeeringConnectionId(), other.vpcPeeringConnectionId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RouteSetDetails").add("CarrierGatewayId", carrierGatewayId())
                .add("CoreNetworkArn", coreNetworkArn()).add("DestinationCidrBlock", destinationCidrBlock())
                .add("DestinationIpv6CidrBlock", destinationIpv6CidrBlock())
                .add("DestinationPrefixListId", destinationPrefixListId())
                .add("EgressOnlyInternetGatewayId", egressOnlyInternetGatewayId()).add("GatewayId", gatewayId())
                .add("InstanceId", instanceId()).add("InstanceOwnerId", instanceOwnerId())
                .add("LocalGatewayId", localGatewayId()).add("NatGatewayId", natGatewayId())
                .add("NetworkInterfaceId", networkInterfaceId()).add("Origin", origin()).add("State", state())
                .add("TransitGatewayId", transitGatewayId()).add("VpcPeeringConnectionId", vpcPeeringConnectionId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CarrierGatewayId":
            return Optional.ofNullable(clazz.cast(carrierGatewayId()));
        case "CoreNetworkArn":
            return Optional.ofNullable(clazz.cast(coreNetworkArn()));
        case "DestinationCidrBlock":
            return Optional.ofNullable(clazz.cast(destinationCidrBlock()));
        case "DestinationIpv6CidrBlock":
            return Optional.ofNullable(clazz.cast(destinationIpv6CidrBlock()));
        case "DestinationPrefixListId":
            return Optional.ofNullable(clazz.cast(destinationPrefixListId()));
        case "EgressOnlyInternetGatewayId":
            return Optional.ofNullable(clazz.cast(egressOnlyInternetGatewayId()));
        case "GatewayId":
            return Optional.ofNullable(clazz.cast(gatewayId()));
        case "InstanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "InstanceOwnerId":
            return Optional.ofNullable(clazz.cast(instanceOwnerId()));
        case "LocalGatewayId":
            return Optional.ofNullable(clazz.cast(localGatewayId()));
        case "NatGatewayId":
            return Optional.ofNullable(clazz.cast(natGatewayId()));
        case "NetworkInterfaceId":
            return Optional.ofNullable(clazz.cast(networkInterfaceId()));
        case "Origin":
            return Optional.ofNullable(clazz.cast(origin()));
        case "State":
            return Optional.ofNullable(clazz.cast(state()));
        case "TransitGatewayId":
            return Optional.ofNullable(clazz.cast(transitGatewayId()));
        case "VpcPeeringConnectionId":
            return Optional.ofNullable(clazz.cast(vpcPeeringConnectionId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RouteSetDetails, T> g) {
        return obj -> g.apply((RouteSetDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RouteSetDetails> {
        /**
         * <p>
         * The ID of the carrier gateway.
         * </p>
         * 
         * @param carrierGatewayId
         *        The ID of the carrier gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder carrierGatewayId(String carrierGatewayId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the core network.
         * </p>
         * 
         * @param coreNetworkArn
         *        The Amazon Resource Name (ARN) of the core network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder coreNetworkArn(String coreNetworkArn);

        /**
         * <p>
         * The IPv4 CIDR block used for the destination match.
         * </p>
         * 
         * @param destinationCidrBlock
         *        The IPv4 CIDR block used for the destination match.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationCidrBlock(String destinationCidrBlock);

        /**
         * <p>
         * The IPv6 CIDR block used for the destination match.
         * </p>
         * 
         * @param destinationIpv6CidrBlock
         *        The IPv6 CIDR block used for the destination match.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationIpv6CidrBlock(String destinationIpv6CidrBlock);

        /**
         * <p>
         * The prefix of the destination Amazon Web Servicesservice.
         * </p>
         * 
         * @param destinationPrefixListId
         *        The prefix of the destination Amazon Web Servicesservice.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationPrefixListId(String destinationPrefixListId);

        /**
         * <p>
         * The ID of the egress-only internet gateway.
         * </p>
         * 
         * @param egressOnlyInternetGatewayId
         *        The ID of the egress-only internet gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder egressOnlyInternetGatewayId(String egressOnlyInternetGatewayId);

        /**
         * <p>
         * The ID of a gateway attached to your VPC.
         * </p>
         * 
         * @param gatewayId
         *        The ID of a gateway attached to your VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gatewayId(String gatewayId);

        /**
         * <p>
         * The ID of a NAT instance in your VPC.
         * </p>
         * 
         * @param instanceId
         *        The ID of a NAT instance in your VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * The ID of the Amazon Web Services account that owns the instance.
         * </p>
         * 
         * @param instanceOwnerId
         *        The ID of the Amazon Web Services account that owns the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceOwnerId(String instanceOwnerId);

        /**
         * <p>
         * The ID of the local gateway.
         * </p>
         * 
         * @param localGatewayId
         *        The ID of the local gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder localGatewayId(String localGatewayId);

        /**
         * <p>
         * The ID of a NAT gateway.
         * </p>
         * 
         * @param natGatewayId
         *        The ID of a NAT gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder natGatewayId(String natGatewayId);

        /**
         * <p>
         * The ID of the network interface.
         * </p>
         * 
         * @param networkInterfaceId
         *        The ID of the network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkInterfaceId(String networkInterfaceId);

        /**
         * <p>
         * Describes how the route was created.
         * </p>
         * 
         * @param origin
         *        Describes how the route was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder origin(String origin);

        /**
         * <p>
         * The state of the route.
         * </p>
         * 
         * @param state
         *        The state of the route.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder state(String state);

        /**
         * <p>
         * The ID of a transit gateway.
         * </p>
         * 
         * @param transitGatewayId
         *        The ID of a transit gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transitGatewayId(String transitGatewayId);

        /**
         * <p>
         * The ID of a VPC peering connection.
         * </p>
         * 
         * @param vpcPeeringConnectionId
         *        The ID of a VPC peering connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcPeeringConnectionId(String vpcPeeringConnectionId);
    }

    static final class BuilderImpl implements Builder {
        private String carrierGatewayId;

        private String coreNetworkArn;

        private String destinationCidrBlock;

        private String destinationIpv6CidrBlock;

        private String destinationPrefixListId;

        private String egressOnlyInternetGatewayId;

        private String gatewayId;

        private String instanceId;

        private String instanceOwnerId;

        private String localGatewayId;

        private String natGatewayId;

        private String networkInterfaceId;

        private String origin;

        private String state;

        private String transitGatewayId;

        private String vpcPeeringConnectionId;

        private BuilderImpl() {
        }

        private BuilderImpl(RouteSetDetails model) {
            carrierGatewayId(model.carrierGatewayId);
            coreNetworkArn(model.coreNetworkArn);
            destinationCidrBlock(model.destinationCidrBlock);
            destinationIpv6CidrBlock(model.destinationIpv6CidrBlock);
            destinationPrefixListId(model.destinationPrefixListId);
            egressOnlyInternetGatewayId(model.egressOnlyInternetGatewayId);
            gatewayId(model.gatewayId);
            instanceId(model.instanceId);
            instanceOwnerId(model.instanceOwnerId);
            localGatewayId(model.localGatewayId);
            natGatewayId(model.natGatewayId);
            networkInterfaceId(model.networkInterfaceId);
            origin(model.origin);
            state(model.state);
            transitGatewayId(model.transitGatewayId);
            vpcPeeringConnectionId(model.vpcPeeringConnectionId);
        }

        public final String getCarrierGatewayId() {
            return carrierGatewayId;
        }

        public final void setCarrierGatewayId(String carrierGatewayId) {
            this.carrierGatewayId = carrierGatewayId;
        }

        @Override
        public final Builder carrierGatewayId(String carrierGatewayId) {
            this.carrierGatewayId = carrierGatewayId;
            return this;
        }

        public final String getCoreNetworkArn() {
            return coreNetworkArn;
        }

        public final void setCoreNetworkArn(String coreNetworkArn) {
            this.coreNetworkArn = coreNetworkArn;
        }

        @Override
        public final Builder coreNetworkArn(String coreNetworkArn) {
            this.coreNetworkArn = coreNetworkArn;
            return this;
        }

        public final String getDestinationCidrBlock() {
            return destinationCidrBlock;
        }

        public final void setDestinationCidrBlock(String destinationCidrBlock) {
            this.destinationCidrBlock = destinationCidrBlock;
        }

        @Override
        public final Builder destinationCidrBlock(String destinationCidrBlock) {
            this.destinationCidrBlock = destinationCidrBlock;
            return this;
        }

        public final String getDestinationIpv6CidrBlock() {
            return destinationIpv6CidrBlock;
        }

        public final void setDestinationIpv6CidrBlock(String destinationIpv6CidrBlock) {
            this.destinationIpv6CidrBlock = destinationIpv6CidrBlock;
        }

        @Override
        public final Builder destinationIpv6CidrBlock(String destinationIpv6CidrBlock) {
            this.destinationIpv6CidrBlock = destinationIpv6CidrBlock;
            return this;
        }

        public final String getDestinationPrefixListId() {
            return destinationPrefixListId;
        }

        public final void setDestinationPrefixListId(String destinationPrefixListId) {
            this.destinationPrefixListId = destinationPrefixListId;
        }

        @Override
        public final Builder destinationPrefixListId(String destinationPrefixListId) {
            this.destinationPrefixListId = destinationPrefixListId;
            return this;
        }

        public final String getEgressOnlyInternetGatewayId() {
            return egressOnlyInternetGatewayId;
        }

        public final void setEgressOnlyInternetGatewayId(String egressOnlyInternetGatewayId) {
            this.egressOnlyInternetGatewayId = egressOnlyInternetGatewayId;
        }

        @Override
        public final Builder egressOnlyInternetGatewayId(String egressOnlyInternetGatewayId) {
            this.egressOnlyInternetGatewayId = egressOnlyInternetGatewayId;
            return this;
        }

        public final String getGatewayId() {
            return gatewayId;
        }

        public final void setGatewayId(String gatewayId) {
            this.gatewayId = gatewayId;
        }

        @Override
        public final Builder gatewayId(String gatewayId) {
            this.gatewayId = gatewayId;
            return this;
        }

        public final String getInstanceId() {
            return instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getInstanceOwnerId() {
            return instanceOwnerId;
        }

        public final void setInstanceOwnerId(String instanceOwnerId) {
            this.instanceOwnerId = instanceOwnerId;
        }

        @Override
        public final Builder instanceOwnerId(String instanceOwnerId) {
            this.instanceOwnerId = instanceOwnerId;
            return this;
        }

        public final String getLocalGatewayId() {
            return localGatewayId;
        }

        public final void setLocalGatewayId(String localGatewayId) {
            this.localGatewayId = localGatewayId;
        }

        @Override
        public final Builder localGatewayId(String localGatewayId) {
            this.localGatewayId = localGatewayId;
            return this;
        }

        public final String getNatGatewayId() {
            return natGatewayId;
        }

        public final void setNatGatewayId(String natGatewayId) {
            this.natGatewayId = natGatewayId;
        }

        @Override
        public final Builder natGatewayId(String natGatewayId) {
            this.natGatewayId = natGatewayId;
            return this;
        }

        public final String getNetworkInterfaceId() {
            return networkInterfaceId;
        }

        public final void setNetworkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
        }

        @Override
        public final Builder networkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
            return this;
        }

        public final String getOrigin() {
            return origin;
        }

        public final void setOrigin(String origin) {
            this.origin = origin;
        }

        @Override
        public final Builder origin(String origin) {
            this.origin = origin;
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        public final String getTransitGatewayId() {
            return transitGatewayId;
        }

        public final void setTransitGatewayId(String transitGatewayId) {
            this.transitGatewayId = transitGatewayId;
        }

        @Override
        public final Builder transitGatewayId(String transitGatewayId) {
            this.transitGatewayId = transitGatewayId;
            return this;
        }

        public final String getVpcPeeringConnectionId() {
            return vpcPeeringConnectionId;
        }

        public final void setVpcPeeringConnectionId(String vpcPeeringConnectionId) {
            this.vpcPeeringConnectionId = vpcPeeringConnectionId;
        }

        @Override
        public final Builder vpcPeeringConnectionId(String vpcPeeringConnectionId) {
            this.vpcPeeringConnectionId = vpcPeeringConnectionId;
            return this;
        }

        @Override
        public RouteSetDetails build() {
            return new RouteSetDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
