/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateFindingAggregatorRequest extends SecurityHubRequest implements
        ToCopyableBuilder<UpdateFindingAggregatorRequest.Builder, UpdateFindingAggregatorRequest> {
    private static final SdkField<String> FINDING_AGGREGATOR_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FindingAggregatorArn").getter(getter(UpdateFindingAggregatorRequest::findingAggregatorArn))
            .setter(setter(Builder::findingAggregatorArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FindingAggregatorArn").build())
            .build();

    private static final SdkField<String> REGION_LINKING_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RegionLinkingMode").getter(getter(UpdateFindingAggregatorRequest::regionLinkingMode))
            .setter(setter(Builder::regionLinkingMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegionLinkingMode").build()).build();

    private static final SdkField<List<String>> REGIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Regions")
            .getter(getter(UpdateFindingAggregatorRequest::regions))
            .setter(setter(Builder::regions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Regions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FINDING_AGGREGATOR_ARN_FIELD,
            REGION_LINKING_MODE_FIELD, REGIONS_FIELD));

    private final String findingAggregatorArn;

    private final String regionLinkingMode;

    private final List<String> regions;

    private UpdateFindingAggregatorRequest(BuilderImpl builder) {
        super(builder);
        this.findingAggregatorArn = builder.findingAggregatorArn;
        this.regionLinkingMode = builder.regionLinkingMode;
        this.regions = builder.regions;
    }

    /**
     * <p>
     * The ARN of the finding aggregator. To obtain the ARN, use <code>ListFindingAggregators</code>.
     * </p>
     * 
     * @return The ARN of the finding aggregator. To obtain the ARN, use <code>ListFindingAggregators</code>.
     */
    public final String findingAggregatorArn() {
        return findingAggregatorArn;
    }

    /**
     * <p>
     * Indicates whether to aggregate findings from all of the available Regions in the current partition. Also
     * determines whether to automatically aggregate findings from new Regions as Security Hub supports them and you opt
     * into them.
     * </p>
     * <p>
     * The selected option also determines how to use the Regions provided in the Regions list.
     * </p>
     * <p>
     * The options are as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ALL_REGIONS</code> - Aggregates findings from all of the Regions where Security Hub is enabled. When you
     * choose this option, Security Hub also automatically aggregates findings from new Regions as Security Hub supports
     * them and you opt into them.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ALL_REGIONS_EXCEPT_SPECIFIED</code> - Aggregates findings from all of the Regions where Security Hub is
     * enabled, except for the Regions listed in the <code>Regions</code> parameter. When you choose this option,
     * Security Hub also automatically aggregates findings from new Regions as Security Hub supports them and you opt
     * into them.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SPECIFIED_REGIONS</code> - Aggregates findings only from the Regions listed in the <code>Regions</code>
     * parameter. Security Hub does not automatically aggregate findings from new Regions.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NO_REGIONS</code> - Aggregates no data because no Regions are selected as linked Regions.
     * </p>
     * </li>
     * </ul>
     * 
     * @return Indicates whether to aggregate findings from all of the available Regions in the current partition. Also
     *         determines whether to automatically aggregate findings from new Regions as Security Hub supports them and
     *         you opt into them.</p>
     *         <p>
     *         The selected option also determines how to use the Regions provided in the Regions list.
     *         </p>
     *         <p>
     *         The options are as follows:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ALL_REGIONS</code> - Aggregates findings from all of the Regions where Security Hub is enabled.
     *         When you choose this option, Security Hub also automatically aggregates findings from new Regions as
     *         Security Hub supports them and you opt into them.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ALL_REGIONS_EXCEPT_SPECIFIED</code> - Aggregates findings from all of the Regions where Security
     *         Hub is enabled, except for the Regions listed in the <code>Regions</code> parameter. When you choose this
     *         option, Security Hub also automatically aggregates findings from new Regions as Security Hub supports
     *         them and you opt into them.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SPECIFIED_REGIONS</code> - Aggregates findings only from the Regions listed in the
     *         <code>Regions</code> parameter. Security Hub does not automatically aggregate findings from new Regions.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NO_REGIONS</code> - Aggregates no data because no Regions are selected as linked Regions.
     *         </p>
     *         </li>
     */
    public final String regionLinkingMode() {
        return regionLinkingMode;
    }

    /**
     * For responses, this returns true if the service returned a value for the Regions property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasRegions() {
        return regions != null && !(regions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * If <code>RegionLinkingMode</code> is <code>ALL_REGIONS_EXCEPT_SPECIFIED</code>, then this is a space-separated
     * list of Regions that do not aggregate findings to the aggregation Region.
     * </p>
     * <p>
     * If <code>RegionLinkingMode</code> is <code>SPECIFIED_REGIONS</code>, then this is a space-separated list of
     * Regions that do aggregate findings to the aggregation Region.
     * </p>
     * <p>
     * An <code>InvalidInputException</code> error results if you populate this field while
     * <code>RegionLinkingMode</code> is <code>NO_REGIONS</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRegions} method.
     * </p>
     * 
     * @return If <code>RegionLinkingMode</code> is <code>ALL_REGIONS_EXCEPT_SPECIFIED</code>, then this is a
     *         space-separated list of Regions that do not aggregate findings to the aggregation Region.</p>
     *         <p>
     *         If <code>RegionLinkingMode</code> is <code>SPECIFIED_REGIONS</code>, then this is a space-separated list
     *         of Regions that do aggregate findings to the aggregation Region.
     *         </p>
     *         <p>
     *         An <code>InvalidInputException</code> error results if you populate this field while
     *         <code>RegionLinkingMode</code> is <code>NO_REGIONS</code>.
     */
    public final List<String> regions() {
        return regions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(findingAggregatorArn());
        hashCode = 31 * hashCode + Objects.hashCode(regionLinkingMode());
        hashCode = 31 * hashCode + Objects.hashCode(hasRegions() ? regions() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateFindingAggregatorRequest)) {
            return false;
        }
        UpdateFindingAggregatorRequest other = (UpdateFindingAggregatorRequest) obj;
        return Objects.equals(findingAggregatorArn(), other.findingAggregatorArn())
                && Objects.equals(regionLinkingMode(), other.regionLinkingMode()) && hasRegions() == other.hasRegions()
                && Objects.equals(regions(), other.regions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateFindingAggregatorRequest").add("FindingAggregatorArn", findingAggregatorArn())
                .add("RegionLinkingMode", regionLinkingMode()).add("Regions", hasRegions() ? regions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FindingAggregatorArn":
            return Optional.ofNullable(clazz.cast(findingAggregatorArn()));
        case "RegionLinkingMode":
            return Optional.ofNullable(clazz.cast(regionLinkingMode()));
        case "Regions":
            return Optional.ofNullable(clazz.cast(regions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateFindingAggregatorRequest, T> g) {
        return obj -> g.apply((UpdateFindingAggregatorRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SecurityHubRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateFindingAggregatorRequest> {
        /**
         * <p>
         * The ARN of the finding aggregator. To obtain the ARN, use <code>ListFindingAggregators</code>.
         * </p>
         * 
         * @param findingAggregatorArn
         *        The ARN of the finding aggregator. To obtain the ARN, use <code>ListFindingAggregators</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder findingAggregatorArn(String findingAggregatorArn);

        /**
         * <p>
         * Indicates whether to aggregate findings from all of the available Regions in the current partition. Also
         * determines whether to automatically aggregate findings from new Regions as Security Hub supports them and you
         * opt into them.
         * </p>
         * <p>
         * The selected option also determines how to use the Regions provided in the Regions list.
         * </p>
         * <p>
         * The options are as follows:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ALL_REGIONS</code> - Aggregates findings from all of the Regions where Security Hub is enabled. When
         * you choose this option, Security Hub also automatically aggregates findings from new Regions as Security Hub
         * supports them and you opt into them.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ALL_REGIONS_EXCEPT_SPECIFIED</code> - Aggregates findings from all of the Regions where Security Hub is
         * enabled, except for the Regions listed in the <code>Regions</code> parameter. When you choose this option,
         * Security Hub also automatically aggregates findings from new Regions as Security Hub supports them and you
         * opt into them.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SPECIFIED_REGIONS</code> - Aggregates findings only from the Regions listed in the <code>Regions</code>
         * parameter. Security Hub does not automatically aggregate findings from new Regions.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NO_REGIONS</code> - Aggregates no data because no Regions are selected as linked Regions.
         * </p>
         * </li>
         * </ul>
         * 
         * @param regionLinkingMode
         *        Indicates whether to aggregate findings from all of the available Regions in the current partition.
         *        Also determines whether to automatically aggregate findings from new Regions as Security Hub supports
         *        them and you opt into them.</p>
         *        <p>
         *        The selected option also determines how to use the Regions provided in the Regions list.
         *        </p>
         *        <p>
         *        The options are as follows:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ALL_REGIONS</code> - Aggregates findings from all of the Regions where Security Hub is enabled.
         *        When you choose this option, Security Hub also automatically aggregates findings from new Regions as
         *        Security Hub supports them and you opt into them.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ALL_REGIONS_EXCEPT_SPECIFIED</code> - Aggregates findings from all of the Regions where Security
         *        Hub is enabled, except for the Regions listed in the <code>Regions</code> parameter. When you choose
         *        this option, Security Hub also automatically aggregates findings from new Regions as Security Hub
         *        supports them and you opt into them.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SPECIFIED_REGIONS</code> - Aggregates findings only from the Regions listed in the
         *        <code>Regions</code> parameter. Security Hub does not automatically aggregate findings from new
         *        Regions.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NO_REGIONS</code> - Aggregates no data because no Regions are selected as linked Regions.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder regionLinkingMode(String regionLinkingMode);

        /**
         * <p>
         * If <code>RegionLinkingMode</code> is <code>ALL_REGIONS_EXCEPT_SPECIFIED</code>, then this is a
         * space-separated list of Regions that do not aggregate findings to the aggregation Region.
         * </p>
         * <p>
         * If <code>RegionLinkingMode</code> is <code>SPECIFIED_REGIONS</code>, then this is a space-separated list of
         * Regions that do aggregate findings to the aggregation Region.
         * </p>
         * <p>
         * An <code>InvalidInputException</code> error results if you populate this field while
         * <code>RegionLinkingMode</code> is <code>NO_REGIONS</code>.
         * </p>
         * 
         * @param regions
         *        If <code>RegionLinkingMode</code> is <code>ALL_REGIONS_EXCEPT_SPECIFIED</code>, then this is a
         *        space-separated list of Regions that do not aggregate findings to the aggregation Region.</p>
         *        <p>
         *        If <code>RegionLinkingMode</code> is <code>SPECIFIED_REGIONS</code>, then this is a space-separated
         *        list of Regions that do aggregate findings to the aggregation Region.
         *        </p>
         *        <p>
         *        An <code>InvalidInputException</code> error results if you populate this field while
         *        <code>RegionLinkingMode</code> is <code>NO_REGIONS</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder regions(Collection<String> regions);

        /**
         * <p>
         * If <code>RegionLinkingMode</code> is <code>ALL_REGIONS_EXCEPT_SPECIFIED</code>, then this is a
         * space-separated list of Regions that do not aggregate findings to the aggregation Region.
         * </p>
         * <p>
         * If <code>RegionLinkingMode</code> is <code>SPECIFIED_REGIONS</code>, then this is a space-separated list of
         * Regions that do aggregate findings to the aggregation Region.
         * </p>
         * <p>
         * An <code>InvalidInputException</code> error results if you populate this field while
         * <code>RegionLinkingMode</code> is <code>NO_REGIONS</code>.
         * </p>
         * 
         * @param regions
         *        If <code>RegionLinkingMode</code> is <code>ALL_REGIONS_EXCEPT_SPECIFIED</code>, then this is a
         *        space-separated list of Regions that do not aggregate findings to the aggregation Region.</p>
         *        <p>
         *        If <code>RegionLinkingMode</code> is <code>SPECIFIED_REGIONS</code>, then this is a space-separated
         *        list of Regions that do aggregate findings to the aggregation Region.
         *        </p>
         *        <p>
         *        An <code>InvalidInputException</code> error results if you populate this field while
         *        <code>RegionLinkingMode</code> is <code>NO_REGIONS</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder regions(String... regions);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SecurityHubRequest.BuilderImpl implements Builder {
        private String findingAggregatorArn;

        private String regionLinkingMode;

        private List<String> regions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateFindingAggregatorRequest model) {
            super(model);
            findingAggregatorArn(model.findingAggregatorArn);
            regionLinkingMode(model.regionLinkingMode);
            regions(model.regions);
        }

        public final String getFindingAggregatorArn() {
            return findingAggregatorArn;
        }

        public final void setFindingAggregatorArn(String findingAggregatorArn) {
            this.findingAggregatorArn = findingAggregatorArn;
        }

        @Override
        public final Builder findingAggregatorArn(String findingAggregatorArn) {
            this.findingAggregatorArn = findingAggregatorArn;
            return this;
        }

        public final String getRegionLinkingMode() {
            return regionLinkingMode;
        }

        public final void setRegionLinkingMode(String regionLinkingMode) {
            this.regionLinkingMode = regionLinkingMode;
        }

        @Override
        public final Builder regionLinkingMode(String regionLinkingMode) {
            this.regionLinkingMode = regionLinkingMode;
            return this;
        }

        public final Collection<String> getRegions() {
            if (regions instanceof SdkAutoConstructList) {
                return null;
            }
            return regions;
        }

        public final void setRegions(Collection<String> regions) {
            this.regions = StringListCopier.copy(regions);
        }

        @Override
        public final Builder regions(Collection<String> regions) {
            this.regions = StringListCopier.copy(regions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder regions(String... regions) {
            regions(Arrays.asList(regions));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateFindingAggregatorRequest build() {
            return new UpdateFindingAggregatorRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
