/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides details about an array of <code>BackupRule</code> objects, each of which specifies a scheduled task that is
 * used to back up a selection of resources.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsBackupBackupPlanRuleDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsBackupBackupPlanRuleDetails.Builder, AwsBackupBackupPlanRuleDetails> {
    private static final SdkField<String> TARGET_BACKUP_VAULT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TargetBackupVault").getter(getter(AwsBackupBackupPlanRuleDetails::targetBackupVault))
            .setter(setter(Builder::targetBackupVault))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetBackupVault").build()).build();

    private static final SdkField<Long> START_WINDOW_MINUTES_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("StartWindowMinutes").getter(getter(AwsBackupBackupPlanRuleDetails::startWindowMinutes))
            .setter(setter(Builder::startWindowMinutes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartWindowMinutes").build())
            .build();

    private static final SdkField<String> SCHEDULE_EXPRESSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ScheduleExpression").getter(getter(AwsBackupBackupPlanRuleDetails::scheduleExpression))
            .setter(setter(Builder::scheduleExpression))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduleExpression").build())
            .build();

    private static final SdkField<String> RULE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RuleName").getter(getter(AwsBackupBackupPlanRuleDetails::ruleName)).setter(setter(Builder::ruleName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleName").build()).build();

    private static final SdkField<String> RULE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("RuleId")
            .getter(getter(AwsBackupBackupPlanRuleDetails::ruleId)).setter(setter(Builder::ruleId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleId").build()).build();

    private static final SdkField<Boolean> ENABLE_CONTINUOUS_BACKUP_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("EnableContinuousBackup").getter(getter(AwsBackupBackupPlanRuleDetails::enableContinuousBackup))
            .setter(setter(Builder::enableContinuousBackup))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableContinuousBackup").build())
            .build();

    private static final SdkField<Long> COMPLETION_WINDOW_MINUTES_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("CompletionWindowMinutes").getter(getter(AwsBackupBackupPlanRuleDetails::completionWindowMinutes))
            .setter(setter(Builder::completionWindowMinutes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompletionWindowMinutes").build())
            .build();

    private static final SdkField<List<AwsBackupBackupPlanRuleCopyActionsDetails>> COPY_ACTIONS_FIELD = SdkField
            .<List<AwsBackupBackupPlanRuleCopyActionsDetails>> builder(MarshallingType.LIST)
            .memberName("CopyActions")
            .getter(getter(AwsBackupBackupPlanRuleDetails::copyActions))
            .setter(setter(Builder::copyActions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CopyActions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AwsBackupBackupPlanRuleCopyActionsDetails> builder(MarshallingType.SDK_POJO)
                                            .constructor(AwsBackupBackupPlanRuleCopyActionsDetails::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<AwsBackupBackupPlanLifecycleDetails> LIFECYCLE_FIELD = SdkField
            .<AwsBackupBackupPlanLifecycleDetails> builder(MarshallingType.SDK_POJO).memberName("Lifecycle")
            .getter(getter(AwsBackupBackupPlanRuleDetails::lifecycle)).setter(setter(Builder::lifecycle))
            .constructor(AwsBackupBackupPlanLifecycleDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Lifecycle").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TARGET_BACKUP_VAULT_FIELD,
            START_WINDOW_MINUTES_FIELD, SCHEDULE_EXPRESSION_FIELD, RULE_NAME_FIELD, RULE_ID_FIELD,
            ENABLE_CONTINUOUS_BACKUP_FIELD, COMPLETION_WINDOW_MINUTES_FIELD, COPY_ACTIONS_FIELD, LIFECYCLE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String targetBackupVault;

    private final Long startWindowMinutes;

    private final String scheduleExpression;

    private final String ruleName;

    private final String ruleId;

    private final Boolean enableContinuousBackup;

    private final Long completionWindowMinutes;

    private final List<AwsBackupBackupPlanRuleCopyActionsDetails> copyActions;

    private final AwsBackupBackupPlanLifecycleDetails lifecycle;

    private AwsBackupBackupPlanRuleDetails(BuilderImpl builder) {
        this.targetBackupVault = builder.targetBackupVault;
        this.startWindowMinutes = builder.startWindowMinutes;
        this.scheduleExpression = builder.scheduleExpression;
        this.ruleName = builder.ruleName;
        this.ruleId = builder.ruleId;
        this.enableContinuousBackup = builder.enableContinuousBackup;
        this.completionWindowMinutes = builder.completionWindowMinutes;
        this.copyActions = builder.copyActions;
        this.lifecycle = builder.lifecycle;
    }

    /**
     * <p>
     * The name of a logical container where backups are stored. Backup vaults are identified by names that are unique
     * to the Amazon Web Services account used to create them and the Amazon Web Services Region where they are created.
     * They consist of letters, numbers, and hyphens.
     * </p>
     * 
     * @return The name of a logical container where backups are stored. Backup vaults are identified by names that are
     *         unique to the Amazon Web Services account used to create them and the Amazon Web Services Region where
     *         they are created. They consist of letters, numbers, and hyphens.
     */
    public final String targetBackupVault() {
        return targetBackupVault;
    }

    /**
     * <p>
     * A value in minutes after a backup is scheduled before a job will be canceled if it doesn't start successfully.
     * </p>
     * 
     * @return A value in minutes after a backup is scheduled before a job will be canceled if it doesn't start
     *         successfully.
     */
    public final Long startWindowMinutes() {
        return startWindowMinutes;
    }

    /**
     * <p>
     * A cron expression in UTC specifying when Backup initiates a backup job.
     * </p>
     * 
     * @return A cron expression in UTC specifying when Backup initiates a backup job.
     */
    public final String scheduleExpression() {
        return scheduleExpression;
    }

    /**
     * <p>
     * A display name for a backup rule. Must contain 1 to 50 alphanumeric or '-_.' characters.
     * </p>
     * 
     * @return A display name for a backup rule. Must contain 1 to 50 alphanumeric or '-_.' characters.
     */
    public final String ruleName() {
        return ruleName;
    }

    /**
     * <p>
     * Uniquely identifies a rule that is used to schedule the backup of a selection of resources.
     * </p>
     * 
     * @return Uniquely identifies a rule that is used to schedule the backup of a selection of resources.
     */
    public final String ruleId() {
        return ruleId;
    }

    /**
     * <p>
     * Specifies whether Backup creates continuous backups capable of point-in-time restore (PITR).
     * </p>
     * 
     * @return Specifies whether Backup creates continuous backups capable of point-in-time restore (PITR).
     */
    public final Boolean enableContinuousBackup() {
        return enableContinuousBackup;
    }

    /**
     * <p>
     * A value in minutes after a backup job is successfully started before it must be completed, or it is canceled by
     * Backup.
     * </p>
     * 
     * @return A value in minutes after a backup job is successfully started before it must be completed, or it is
     *         canceled by Backup.
     */
    public final Long completionWindowMinutes() {
        return completionWindowMinutes;
    }

    /**
     * For responses, this returns true if the service returned a value for the CopyActions property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasCopyActions() {
        return copyActions != null && !(copyActions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of <code>CopyAction</code> objects, each of which contains details of the copy operation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCopyActions} method.
     * </p>
     * 
     * @return An array of <code>CopyAction</code> objects, each of which contains details of the copy operation.
     */
    public final List<AwsBackupBackupPlanRuleCopyActionsDetails> copyActions() {
        return copyActions;
    }

    /**
     * <p>
     * Defines when a protected resource is transitioned to cold storage and when it expires. Backup transitions and
     * expires backups automatically according to the lifecycle that you define. If you don't specify a lifecycle,
     * Backup applies the lifecycle policy of the source backup to the destination backup.
     * </p>
     * <p>
     * Backups transitioned to cold storage must be stored in cold storage for a minimum of 90 days.
     * </p>
     * 
     * @return Defines when a protected resource is transitioned to cold storage and when it expires. Backup transitions
     *         and expires backups automatically according to the lifecycle that you define. If you don't specify a
     *         lifecycle, Backup applies the lifecycle policy of the source backup to the destination backup.</p>
     *         <p>
     *         Backups transitioned to cold storage must be stored in cold storage for a minimum of 90 days.
     */
    public final AwsBackupBackupPlanLifecycleDetails lifecycle() {
        return lifecycle;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(targetBackupVault());
        hashCode = 31 * hashCode + Objects.hashCode(startWindowMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(scheduleExpression());
        hashCode = 31 * hashCode + Objects.hashCode(ruleName());
        hashCode = 31 * hashCode + Objects.hashCode(ruleId());
        hashCode = 31 * hashCode + Objects.hashCode(enableContinuousBackup());
        hashCode = 31 * hashCode + Objects.hashCode(completionWindowMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(hasCopyActions() ? copyActions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(lifecycle());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsBackupBackupPlanRuleDetails)) {
            return false;
        }
        AwsBackupBackupPlanRuleDetails other = (AwsBackupBackupPlanRuleDetails) obj;
        return Objects.equals(targetBackupVault(), other.targetBackupVault())
                && Objects.equals(startWindowMinutes(), other.startWindowMinutes())
                && Objects.equals(scheduleExpression(), other.scheduleExpression())
                && Objects.equals(ruleName(), other.ruleName()) && Objects.equals(ruleId(), other.ruleId())
                && Objects.equals(enableContinuousBackup(), other.enableContinuousBackup())
                && Objects.equals(completionWindowMinutes(), other.completionWindowMinutes())
                && hasCopyActions() == other.hasCopyActions() && Objects.equals(copyActions(), other.copyActions())
                && Objects.equals(lifecycle(), other.lifecycle());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsBackupBackupPlanRuleDetails").add("TargetBackupVault", targetBackupVault())
                .add("StartWindowMinutes", startWindowMinutes()).add("ScheduleExpression", scheduleExpression())
                .add("RuleName", ruleName()).add("RuleId", ruleId()).add("EnableContinuousBackup", enableContinuousBackup())
                .add("CompletionWindowMinutes", completionWindowMinutes())
                .add("CopyActions", hasCopyActions() ? copyActions() : null).add("Lifecycle", lifecycle()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TargetBackupVault":
            return Optional.ofNullable(clazz.cast(targetBackupVault()));
        case "StartWindowMinutes":
            return Optional.ofNullable(clazz.cast(startWindowMinutes()));
        case "ScheduleExpression":
            return Optional.ofNullable(clazz.cast(scheduleExpression()));
        case "RuleName":
            return Optional.ofNullable(clazz.cast(ruleName()));
        case "RuleId":
            return Optional.ofNullable(clazz.cast(ruleId()));
        case "EnableContinuousBackup":
            return Optional.ofNullable(clazz.cast(enableContinuousBackup()));
        case "CompletionWindowMinutes":
            return Optional.ofNullable(clazz.cast(completionWindowMinutes()));
        case "CopyActions":
            return Optional.ofNullable(clazz.cast(copyActions()));
        case "Lifecycle":
            return Optional.ofNullable(clazz.cast(lifecycle()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsBackupBackupPlanRuleDetails, T> g) {
        return obj -> g.apply((AwsBackupBackupPlanRuleDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsBackupBackupPlanRuleDetails> {
        /**
         * <p>
         * The name of a logical container where backups are stored. Backup vaults are identified by names that are
         * unique to the Amazon Web Services account used to create them and the Amazon Web Services Region where they
         * are created. They consist of letters, numbers, and hyphens.
         * </p>
         * 
         * @param targetBackupVault
         *        The name of a logical container where backups are stored. Backup vaults are identified by names that
         *        are unique to the Amazon Web Services account used to create them and the Amazon Web Services Region
         *        where they are created. They consist of letters, numbers, and hyphens.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetBackupVault(String targetBackupVault);

        /**
         * <p>
         * A value in minutes after a backup is scheduled before a job will be canceled if it doesn't start
         * successfully.
         * </p>
         * 
         * @param startWindowMinutes
         *        A value in minutes after a backup is scheduled before a job will be canceled if it doesn't start
         *        successfully.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startWindowMinutes(Long startWindowMinutes);

        /**
         * <p>
         * A cron expression in UTC specifying when Backup initiates a backup job.
         * </p>
         * 
         * @param scheduleExpression
         *        A cron expression in UTC specifying when Backup initiates a backup job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheduleExpression(String scheduleExpression);

        /**
         * <p>
         * A display name for a backup rule. Must contain 1 to 50 alphanumeric or '-_.' characters.
         * </p>
         * 
         * @param ruleName
         *        A display name for a backup rule. Must contain 1 to 50 alphanumeric or '-_.' characters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleName(String ruleName);

        /**
         * <p>
         * Uniquely identifies a rule that is used to schedule the backup of a selection of resources.
         * </p>
         * 
         * @param ruleId
         *        Uniquely identifies a rule that is used to schedule the backup of a selection of resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleId(String ruleId);

        /**
         * <p>
         * Specifies whether Backup creates continuous backups capable of point-in-time restore (PITR).
         * </p>
         * 
         * @param enableContinuousBackup
         *        Specifies whether Backup creates continuous backups capable of point-in-time restore (PITR).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableContinuousBackup(Boolean enableContinuousBackup);

        /**
         * <p>
         * A value in minutes after a backup job is successfully started before it must be completed, or it is canceled
         * by Backup.
         * </p>
         * 
         * @param completionWindowMinutes
         *        A value in minutes after a backup job is successfully started before it must be completed, or it is
         *        canceled by Backup.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder completionWindowMinutes(Long completionWindowMinutes);

        /**
         * <p>
         * An array of <code>CopyAction</code> objects, each of which contains details of the copy operation.
         * </p>
         * 
         * @param copyActions
         *        An array of <code>CopyAction</code> objects, each of which contains details of the copy operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder copyActions(Collection<AwsBackupBackupPlanRuleCopyActionsDetails> copyActions);

        /**
         * <p>
         * An array of <code>CopyAction</code> objects, each of which contains details of the copy operation.
         * </p>
         * 
         * @param copyActions
         *        An array of <code>CopyAction</code> objects, each of which contains details of the copy operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder copyActions(AwsBackupBackupPlanRuleCopyActionsDetails... copyActions);

        /**
         * <p>
         * An array of <code>CopyAction</code> objects, each of which contains details of the copy operation.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityhub.model.AwsBackupBackupPlanRuleCopyActionsDetails.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.securityhub.model.AwsBackupBackupPlanRuleCopyActionsDetails#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityhub.model.AwsBackupBackupPlanRuleCopyActionsDetails.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #copyActions(List<AwsBackupBackupPlanRuleCopyActionsDetails>)}.
         * 
         * @param copyActions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityhub.model.AwsBackupBackupPlanRuleCopyActionsDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #copyActions(java.util.Collection<AwsBackupBackupPlanRuleCopyActionsDetails>)
         */
        Builder copyActions(Consumer<AwsBackupBackupPlanRuleCopyActionsDetails.Builder>... copyActions);

        /**
         * <p>
         * Defines when a protected resource is transitioned to cold storage and when it expires. Backup transitions and
         * expires backups automatically according to the lifecycle that you define. If you don't specify a lifecycle,
         * Backup applies the lifecycle policy of the source backup to the destination backup.
         * </p>
         * <p>
         * Backups transitioned to cold storage must be stored in cold storage for a minimum of 90 days.
         * </p>
         * 
         * @param lifecycle
         *        Defines when a protected resource is transitioned to cold storage and when it expires. Backup
         *        transitions and expires backups automatically according to the lifecycle that you define. If you don't
         *        specify a lifecycle, Backup applies the lifecycle policy of the source backup to the destination
         *        backup.</p>
         *        <p>
         *        Backups transitioned to cold storage must be stored in cold storage for a minimum of 90 days.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lifecycle(AwsBackupBackupPlanLifecycleDetails lifecycle);

        /**
         * <p>
         * Defines when a protected resource is transitioned to cold storage and when it expires. Backup transitions and
         * expires backups automatically according to the lifecycle that you define. If you don't specify a lifecycle,
         * Backup applies the lifecycle policy of the source backup to the destination backup.
         * </p>
         * <p>
         * Backups transitioned to cold storage must be stored in cold storage for a minimum of 90 days.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AwsBackupBackupPlanLifecycleDetails.Builder} avoiding the need to create one manually via
         * {@link AwsBackupBackupPlanLifecycleDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsBackupBackupPlanLifecycleDetails.Builder#build()} is called
         * immediately and its result is passed to {@link #lifecycle(AwsBackupBackupPlanLifecycleDetails)}.
         * 
         * @param lifecycle
         *        a consumer that will call methods on {@link AwsBackupBackupPlanLifecycleDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lifecycle(AwsBackupBackupPlanLifecycleDetails)
         */
        default Builder lifecycle(Consumer<AwsBackupBackupPlanLifecycleDetails.Builder> lifecycle) {
            return lifecycle(AwsBackupBackupPlanLifecycleDetails.builder().applyMutation(lifecycle).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String targetBackupVault;

        private Long startWindowMinutes;

        private String scheduleExpression;

        private String ruleName;

        private String ruleId;

        private Boolean enableContinuousBackup;

        private Long completionWindowMinutes;

        private List<AwsBackupBackupPlanRuleCopyActionsDetails> copyActions = DefaultSdkAutoConstructList.getInstance();

        private AwsBackupBackupPlanLifecycleDetails lifecycle;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsBackupBackupPlanRuleDetails model) {
            targetBackupVault(model.targetBackupVault);
            startWindowMinutes(model.startWindowMinutes);
            scheduleExpression(model.scheduleExpression);
            ruleName(model.ruleName);
            ruleId(model.ruleId);
            enableContinuousBackup(model.enableContinuousBackup);
            completionWindowMinutes(model.completionWindowMinutes);
            copyActions(model.copyActions);
            lifecycle(model.lifecycle);
        }

        public final String getTargetBackupVault() {
            return targetBackupVault;
        }

        public final void setTargetBackupVault(String targetBackupVault) {
            this.targetBackupVault = targetBackupVault;
        }

        @Override
        public final Builder targetBackupVault(String targetBackupVault) {
            this.targetBackupVault = targetBackupVault;
            return this;
        }

        public final Long getStartWindowMinutes() {
            return startWindowMinutes;
        }

        public final void setStartWindowMinutes(Long startWindowMinutes) {
            this.startWindowMinutes = startWindowMinutes;
        }

        @Override
        public final Builder startWindowMinutes(Long startWindowMinutes) {
            this.startWindowMinutes = startWindowMinutes;
            return this;
        }

        public final String getScheduleExpression() {
            return scheduleExpression;
        }

        public final void setScheduleExpression(String scheduleExpression) {
            this.scheduleExpression = scheduleExpression;
        }

        @Override
        public final Builder scheduleExpression(String scheduleExpression) {
            this.scheduleExpression = scheduleExpression;
            return this;
        }

        public final String getRuleName() {
            return ruleName;
        }

        public final void setRuleName(String ruleName) {
            this.ruleName = ruleName;
        }

        @Override
        public final Builder ruleName(String ruleName) {
            this.ruleName = ruleName;
            return this;
        }

        public final String getRuleId() {
            return ruleId;
        }

        public final void setRuleId(String ruleId) {
            this.ruleId = ruleId;
        }

        @Override
        public final Builder ruleId(String ruleId) {
            this.ruleId = ruleId;
            return this;
        }

        public final Boolean getEnableContinuousBackup() {
            return enableContinuousBackup;
        }

        public final void setEnableContinuousBackup(Boolean enableContinuousBackup) {
            this.enableContinuousBackup = enableContinuousBackup;
        }

        @Override
        public final Builder enableContinuousBackup(Boolean enableContinuousBackup) {
            this.enableContinuousBackup = enableContinuousBackup;
            return this;
        }

        public final Long getCompletionWindowMinutes() {
            return completionWindowMinutes;
        }

        public final void setCompletionWindowMinutes(Long completionWindowMinutes) {
            this.completionWindowMinutes = completionWindowMinutes;
        }

        @Override
        public final Builder completionWindowMinutes(Long completionWindowMinutes) {
            this.completionWindowMinutes = completionWindowMinutes;
            return this;
        }

        public final List<AwsBackupBackupPlanRuleCopyActionsDetails.Builder> getCopyActions() {
            List<AwsBackupBackupPlanRuleCopyActionsDetails.Builder> result = AwsBackupBackupPlanRuleCopyActionsListCopier
                    .copyToBuilder(this.copyActions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCopyActions(Collection<AwsBackupBackupPlanRuleCopyActionsDetails.BuilderImpl> copyActions) {
            this.copyActions = AwsBackupBackupPlanRuleCopyActionsListCopier.copyFromBuilder(copyActions);
        }

        @Override
        public final Builder copyActions(Collection<AwsBackupBackupPlanRuleCopyActionsDetails> copyActions) {
            this.copyActions = AwsBackupBackupPlanRuleCopyActionsListCopier.copy(copyActions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder copyActions(AwsBackupBackupPlanRuleCopyActionsDetails... copyActions) {
            copyActions(Arrays.asList(copyActions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder copyActions(Consumer<AwsBackupBackupPlanRuleCopyActionsDetails.Builder>... copyActions) {
            copyActions(Stream.of(copyActions)
                    .map(c -> AwsBackupBackupPlanRuleCopyActionsDetails.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final AwsBackupBackupPlanLifecycleDetails.Builder getLifecycle() {
            return lifecycle != null ? lifecycle.toBuilder() : null;
        }

        public final void setLifecycle(AwsBackupBackupPlanLifecycleDetails.BuilderImpl lifecycle) {
            this.lifecycle = lifecycle != null ? lifecycle.build() : null;
        }

        @Override
        public final Builder lifecycle(AwsBackupBackupPlanLifecycleDetails lifecycle) {
            this.lifecycle = lifecycle;
            return this;
        }

        @Override
        public AwsBackupBackupPlanRuleDetails build() {
            return new AwsBackupBackupPlanRuleDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
