/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides details about an Database Migration Service (DMS) replication task. A replication task moves a set of data
 * from the source endpoint to the target endpoint.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsDmsReplicationTaskDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsDmsReplicationTaskDetails.Builder, AwsDmsReplicationTaskDetails> {
    private static final SdkField<String> CDC_START_POSITION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CdcStartPosition").getter(getter(AwsDmsReplicationTaskDetails::cdcStartPosition))
            .setter(setter(Builder::cdcStartPosition))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CdcStartPosition").build()).build();

    private static final SdkField<String> CDC_START_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CdcStartTime").getter(getter(AwsDmsReplicationTaskDetails::cdcStartTime))
            .setter(setter(Builder::cdcStartTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CdcStartTime").build()).build();

    private static final SdkField<String> CDC_STOP_POSITION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CdcStopPosition").getter(getter(AwsDmsReplicationTaskDetails::cdcStopPosition))
            .setter(setter(Builder::cdcStopPosition))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CdcStopPosition").build()).build();

    private static final SdkField<String> MIGRATION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MigrationType").getter(getter(AwsDmsReplicationTaskDetails::migrationType))
            .setter(setter(Builder::migrationType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MigrationType").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(AwsDmsReplicationTaskDetails::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> RESOURCE_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceIdentifier").getter(getter(AwsDmsReplicationTaskDetails::resourceIdentifier))
            .setter(setter(Builder::resourceIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceIdentifier").build())
            .build();

    private static final SdkField<String> REPLICATION_INSTANCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ReplicationInstanceArn").getter(getter(AwsDmsReplicationTaskDetails::replicationInstanceArn))
            .setter(setter(Builder::replicationInstanceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationInstanceArn").build())
            .build();

    private static final SdkField<String> REPLICATION_TASK_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ReplicationTaskIdentifier").getter(getter(AwsDmsReplicationTaskDetails::replicationTaskIdentifier))
            .setter(setter(Builder::replicationTaskIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationTaskIdentifier").build())
            .build();

    private static final SdkField<String> REPLICATION_TASK_SETTINGS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ReplicationTaskSettings").getter(getter(AwsDmsReplicationTaskDetails::replicationTaskSettings))
            .setter(setter(Builder::replicationTaskSettings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationTaskSettings").build())
            .build();

    private static final SdkField<String> SOURCE_ENDPOINT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceEndpointArn").getter(getter(AwsDmsReplicationTaskDetails::sourceEndpointArn))
            .setter(setter(Builder::sourceEndpointArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceEndpointArn").build()).build();

    private static final SdkField<String> TABLE_MAPPINGS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TableMappings").getter(getter(AwsDmsReplicationTaskDetails::tableMappings))
            .setter(setter(Builder::tableMappings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableMappings").build()).build();

    private static final SdkField<String> TARGET_ENDPOINT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TargetEndpointArn").getter(getter(AwsDmsReplicationTaskDetails::targetEndpointArn))
            .setter(setter(Builder::targetEndpointArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetEndpointArn").build()).build();

    private static final SdkField<String> TASK_DATA_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TaskData").getter(getter(AwsDmsReplicationTaskDetails::taskData)).setter(setter(Builder::taskData))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TaskData").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CDC_START_POSITION_FIELD,
            CDC_START_TIME_FIELD, CDC_STOP_POSITION_FIELD, MIGRATION_TYPE_FIELD, ID_FIELD, RESOURCE_IDENTIFIER_FIELD,
            REPLICATION_INSTANCE_ARN_FIELD, REPLICATION_TASK_IDENTIFIER_FIELD, REPLICATION_TASK_SETTINGS_FIELD,
            SOURCE_ENDPOINT_ARN_FIELD, TABLE_MAPPINGS_FIELD, TARGET_ENDPOINT_ARN_FIELD, TASK_DATA_FIELD));

    private static final long serialVersionUID = 1L;

    private final String cdcStartPosition;

    private final String cdcStartTime;

    private final String cdcStopPosition;

    private final String migrationType;

    private final String id;

    private final String resourceIdentifier;

    private final String replicationInstanceArn;

    private final String replicationTaskIdentifier;

    private final String replicationTaskSettings;

    private final String sourceEndpointArn;

    private final String tableMappings;

    private final String targetEndpointArn;

    private final String taskData;

    private AwsDmsReplicationTaskDetails(BuilderImpl builder) {
        this.cdcStartPosition = builder.cdcStartPosition;
        this.cdcStartTime = builder.cdcStartTime;
        this.cdcStopPosition = builder.cdcStopPosition;
        this.migrationType = builder.migrationType;
        this.id = builder.id;
        this.resourceIdentifier = builder.resourceIdentifier;
        this.replicationInstanceArn = builder.replicationInstanceArn;
        this.replicationTaskIdentifier = builder.replicationTaskIdentifier;
        this.replicationTaskSettings = builder.replicationTaskSettings;
        this.sourceEndpointArn = builder.sourceEndpointArn;
        this.tableMappings = builder.tableMappings;
        this.targetEndpointArn = builder.targetEndpointArn;
        this.taskData = builder.taskData;
    }

    /**
     * <p>
     * Indicates when you want a change data capture (CDC) operation to start. <code>CCdcStartPosition</code> or
     * <code>CCdcStartTime</code> specifies when you want a CDC operation to start. Only a value for one of these fields
     * is included.
     * </p>
     * 
     * @return Indicates when you want a change data capture (CDC) operation to start. <code>CCdcStartPosition</code> or
     *         <code>CCdcStartTime</code> specifies when you want a CDC operation to start. Only a value for one of
     *         these fields is included.
     */
    public final String cdcStartPosition() {
        return cdcStartPosition;
    }

    /**
     * <p>
     * Indicates the start time for a CDC operation. <code>CdcStartPosition</code> or <code>CCdcStartTime</code>
     * specifies when you want a CDC operation to start. Only a value for one of these fields is included.
     * </p>
     * 
     * @return Indicates the start time for a CDC operation. <code>CdcStartPosition</code> or <code>CCdcStartTime</code>
     *         specifies when you want a CDC operation to start. Only a value for one of these fields is included.
     */
    public final String cdcStartTime() {
        return cdcStartTime;
    }

    /**
     * <p>
     * Indicates when you want a CDC operation to stop. The value can be either server time or commit time.
     * </p>
     * 
     * @return Indicates when you want a CDC operation to stop. The value can be either server time or commit time.
     */
    public final String cdcStopPosition() {
        return cdcStopPosition;
    }

    /**
     * <p>
     * The migration type.
     * </p>
     * 
     * @return The migration type.
     */
    public final String migrationType() {
        return migrationType;
    }

    /**
     * <p>
     * The identifier of the replication task.
     * </p>
     * 
     * @return The identifier of the replication task.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * A display name for the resource identifier at the end of the <code>EndpointArn</code> response parameter. If you
     * don't specify a <code>ResourceIdentifier</code> value, DMS generates a default identifier value for the end of
     * <code>EndpointArn</code>.
     * </p>
     * 
     * @return A display name for the resource identifier at the end of the <code>EndpointArn</code> response parameter.
     *         If you don't specify a <code>ResourceIdentifier</code> value, DMS generates a default identifier value
     *         for the end of <code>EndpointArn</code>.
     */
    public final String resourceIdentifier() {
        return resourceIdentifier;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of a replication instance.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of a replication instance.
     */
    public final String replicationInstanceArn() {
        return replicationInstanceArn;
    }

    /**
     * <p>
     * The user-defined replication task identifier or name.
     * </p>
     * 
     * @return The user-defined replication task identifier or name.
     */
    public final String replicationTaskIdentifier() {
        return replicationTaskIdentifier;
    }

    /**
     * <p>
     * The settings for the replication task.
     * </p>
     * 
     * @return The settings for the replication task.
     */
    public final String replicationTaskSettings() {
        return replicationTaskSettings;
    }

    /**
     * <p>
     * The ARN of the source endpoint.
     * </p>
     * 
     * @return The ARN of the source endpoint.
     */
    public final String sourceEndpointArn() {
        return sourceEndpointArn;
    }

    /**
     * <p>
     * The table mappings for the replication task, in JSON format.
     * </p>
     * 
     * @return The table mappings for the replication task, in JSON format.
     */
    public final String tableMappings() {
        return tableMappings;
    }

    /**
     * <p>
     * The ARN of the target endpoint.
     * </p>
     * 
     * @return The ARN of the target endpoint.
     */
    public final String targetEndpointArn() {
        return targetEndpointArn;
    }

    /**
     * <p>
     * Supplemental information that the task requires to migrate the data for certain source and target endpoints.
     * </p>
     * 
     * @return Supplemental information that the task requires to migrate the data for certain source and target
     *         endpoints.
     */
    public final String taskData() {
        return taskData;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(cdcStartPosition());
        hashCode = 31 * hashCode + Objects.hashCode(cdcStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(cdcStopPosition());
        hashCode = 31 * hashCode + Objects.hashCode(migrationType());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(resourceIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(replicationInstanceArn());
        hashCode = 31 * hashCode + Objects.hashCode(replicationTaskIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(replicationTaskSettings());
        hashCode = 31 * hashCode + Objects.hashCode(sourceEndpointArn());
        hashCode = 31 * hashCode + Objects.hashCode(tableMappings());
        hashCode = 31 * hashCode + Objects.hashCode(targetEndpointArn());
        hashCode = 31 * hashCode + Objects.hashCode(taskData());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsDmsReplicationTaskDetails)) {
            return false;
        }
        AwsDmsReplicationTaskDetails other = (AwsDmsReplicationTaskDetails) obj;
        return Objects.equals(cdcStartPosition(), other.cdcStartPosition())
                && Objects.equals(cdcStartTime(), other.cdcStartTime())
                && Objects.equals(cdcStopPosition(), other.cdcStopPosition())
                && Objects.equals(migrationType(), other.migrationType()) && Objects.equals(id(), other.id())
                && Objects.equals(resourceIdentifier(), other.resourceIdentifier())
                && Objects.equals(replicationInstanceArn(), other.replicationInstanceArn())
                && Objects.equals(replicationTaskIdentifier(), other.replicationTaskIdentifier())
                && Objects.equals(replicationTaskSettings(), other.replicationTaskSettings())
                && Objects.equals(sourceEndpointArn(), other.sourceEndpointArn())
                && Objects.equals(tableMappings(), other.tableMappings())
                && Objects.equals(targetEndpointArn(), other.targetEndpointArn()) && Objects.equals(taskData(), other.taskData());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsDmsReplicationTaskDetails").add("CdcStartPosition", cdcStartPosition())
                .add("CdcStartTime", cdcStartTime()).add("CdcStopPosition", cdcStopPosition())
                .add("MigrationType", migrationType()).add("Id", id()).add("ResourceIdentifier", resourceIdentifier())
                .add("ReplicationInstanceArn", replicationInstanceArn())
                .add("ReplicationTaskIdentifier", replicationTaskIdentifier())
                .add("ReplicationTaskSettings", replicationTaskSettings()).add("SourceEndpointArn", sourceEndpointArn())
                .add("TableMappings", tableMappings()).add("TargetEndpointArn", targetEndpointArn()).add("TaskData", taskData())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CdcStartPosition":
            return Optional.ofNullable(clazz.cast(cdcStartPosition()));
        case "CdcStartTime":
            return Optional.ofNullable(clazz.cast(cdcStartTime()));
        case "CdcStopPosition":
            return Optional.ofNullable(clazz.cast(cdcStopPosition()));
        case "MigrationType":
            return Optional.ofNullable(clazz.cast(migrationType()));
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "ResourceIdentifier":
            return Optional.ofNullable(clazz.cast(resourceIdentifier()));
        case "ReplicationInstanceArn":
            return Optional.ofNullable(clazz.cast(replicationInstanceArn()));
        case "ReplicationTaskIdentifier":
            return Optional.ofNullable(clazz.cast(replicationTaskIdentifier()));
        case "ReplicationTaskSettings":
            return Optional.ofNullable(clazz.cast(replicationTaskSettings()));
        case "SourceEndpointArn":
            return Optional.ofNullable(clazz.cast(sourceEndpointArn()));
        case "TableMappings":
            return Optional.ofNullable(clazz.cast(tableMappings()));
        case "TargetEndpointArn":
            return Optional.ofNullable(clazz.cast(targetEndpointArn()));
        case "TaskData":
            return Optional.ofNullable(clazz.cast(taskData()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsDmsReplicationTaskDetails, T> g) {
        return obj -> g.apply((AwsDmsReplicationTaskDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsDmsReplicationTaskDetails> {
        /**
         * <p>
         * Indicates when you want a change data capture (CDC) operation to start. <code>CCdcStartPosition</code> or
         * <code>CCdcStartTime</code> specifies when you want a CDC operation to start. Only a value for one of these
         * fields is included.
         * </p>
         * 
         * @param cdcStartPosition
         *        Indicates when you want a change data capture (CDC) operation to start. <code>CCdcStartPosition</code>
         *        or <code>CCdcStartTime</code> specifies when you want a CDC operation to start. Only a value for one
         *        of these fields is included.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cdcStartPosition(String cdcStartPosition);

        /**
         * <p>
         * Indicates the start time for a CDC operation. <code>CdcStartPosition</code> or <code>CCdcStartTime</code>
         * specifies when you want a CDC operation to start. Only a value for one of these fields is included.
         * </p>
         * 
         * @param cdcStartTime
         *        Indicates the start time for a CDC operation. <code>CdcStartPosition</code> or
         *        <code>CCdcStartTime</code> specifies when you want a CDC operation to start. Only a value for one of
         *        these fields is included.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cdcStartTime(String cdcStartTime);

        /**
         * <p>
         * Indicates when you want a CDC operation to stop. The value can be either server time or commit time.
         * </p>
         * 
         * @param cdcStopPosition
         *        Indicates when you want a CDC operation to stop. The value can be either server time or commit time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cdcStopPosition(String cdcStopPosition);

        /**
         * <p>
         * The migration type.
         * </p>
         * 
         * @param migrationType
         *        The migration type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder migrationType(String migrationType);

        /**
         * <p>
         * The identifier of the replication task.
         * </p>
         * 
         * @param id
         *        The identifier of the replication task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * A display name for the resource identifier at the end of the <code>EndpointArn</code> response parameter. If
         * you don't specify a <code>ResourceIdentifier</code> value, DMS generates a default identifier value for the
         * end of <code>EndpointArn</code>.
         * </p>
         * 
         * @param resourceIdentifier
         *        A display name for the resource identifier at the end of the <code>EndpointArn</code> response
         *        parameter. If you don't specify a <code>ResourceIdentifier</code> value, DMS generates a default
         *        identifier value for the end of <code>EndpointArn</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceIdentifier(String resourceIdentifier);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of a replication instance.
         * </p>
         * 
         * @param replicationInstanceArn
         *        The Amazon Resource Name (ARN) of a replication instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationInstanceArn(String replicationInstanceArn);

        /**
         * <p>
         * The user-defined replication task identifier or name.
         * </p>
         * 
         * @param replicationTaskIdentifier
         *        The user-defined replication task identifier or name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationTaskIdentifier(String replicationTaskIdentifier);

        /**
         * <p>
         * The settings for the replication task.
         * </p>
         * 
         * @param replicationTaskSettings
         *        The settings for the replication task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationTaskSettings(String replicationTaskSettings);

        /**
         * <p>
         * The ARN of the source endpoint.
         * </p>
         * 
         * @param sourceEndpointArn
         *        The ARN of the source endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceEndpointArn(String sourceEndpointArn);

        /**
         * <p>
         * The table mappings for the replication task, in JSON format.
         * </p>
         * 
         * @param tableMappings
         *        The table mappings for the replication task, in JSON format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableMappings(String tableMappings);

        /**
         * <p>
         * The ARN of the target endpoint.
         * </p>
         * 
         * @param targetEndpointArn
         *        The ARN of the target endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetEndpointArn(String targetEndpointArn);

        /**
         * <p>
         * Supplemental information that the task requires to migrate the data for certain source and target endpoints.
         * </p>
         * 
         * @param taskData
         *        Supplemental information that the task requires to migrate the data for certain source and target
         *        endpoints.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskData(String taskData);
    }

    static final class BuilderImpl implements Builder {
        private String cdcStartPosition;

        private String cdcStartTime;

        private String cdcStopPosition;

        private String migrationType;

        private String id;

        private String resourceIdentifier;

        private String replicationInstanceArn;

        private String replicationTaskIdentifier;

        private String replicationTaskSettings;

        private String sourceEndpointArn;

        private String tableMappings;

        private String targetEndpointArn;

        private String taskData;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsDmsReplicationTaskDetails model) {
            cdcStartPosition(model.cdcStartPosition);
            cdcStartTime(model.cdcStartTime);
            cdcStopPosition(model.cdcStopPosition);
            migrationType(model.migrationType);
            id(model.id);
            resourceIdentifier(model.resourceIdentifier);
            replicationInstanceArn(model.replicationInstanceArn);
            replicationTaskIdentifier(model.replicationTaskIdentifier);
            replicationTaskSettings(model.replicationTaskSettings);
            sourceEndpointArn(model.sourceEndpointArn);
            tableMappings(model.tableMappings);
            targetEndpointArn(model.targetEndpointArn);
            taskData(model.taskData);
        }

        public final String getCdcStartPosition() {
            return cdcStartPosition;
        }

        public final void setCdcStartPosition(String cdcStartPosition) {
            this.cdcStartPosition = cdcStartPosition;
        }

        @Override
        public final Builder cdcStartPosition(String cdcStartPosition) {
            this.cdcStartPosition = cdcStartPosition;
            return this;
        }

        public final String getCdcStartTime() {
            return cdcStartTime;
        }

        public final void setCdcStartTime(String cdcStartTime) {
            this.cdcStartTime = cdcStartTime;
        }

        @Override
        public final Builder cdcStartTime(String cdcStartTime) {
            this.cdcStartTime = cdcStartTime;
            return this;
        }

        public final String getCdcStopPosition() {
            return cdcStopPosition;
        }

        public final void setCdcStopPosition(String cdcStopPosition) {
            this.cdcStopPosition = cdcStopPosition;
        }

        @Override
        public final Builder cdcStopPosition(String cdcStopPosition) {
            this.cdcStopPosition = cdcStopPosition;
            return this;
        }

        public final String getMigrationType() {
            return migrationType;
        }

        public final void setMigrationType(String migrationType) {
            this.migrationType = migrationType;
        }

        @Override
        public final Builder migrationType(String migrationType) {
            this.migrationType = migrationType;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getResourceIdentifier() {
            return resourceIdentifier;
        }

        public final void setResourceIdentifier(String resourceIdentifier) {
            this.resourceIdentifier = resourceIdentifier;
        }

        @Override
        public final Builder resourceIdentifier(String resourceIdentifier) {
            this.resourceIdentifier = resourceIdentifier;
            return this;
        }

        public final String getReplicationInstanceArn() {
            return replicationInstanceArn;
        }

        public final void setReplicationInstanceArn(String replicationInstanceArn) {
            this.replicationInstanceArn = replicationInstanceArn;
        }

        @Override
        public final Builder replicationInstanceArn(String replicationInstanceArn) {
            this.replicationInstanceArn = replicationInstanceArn;
            return this;
        }

        public final String getReplicationTaskIdentifier() {
            return replicationTaskIdentifier;
        }

        public final void setReplicationTaskIdentifier(String replicationTaskIdentifier) {
            this.replicationTaskIdentifier = replicationTaskIdentifier;
        }

        @Override
        public final Builder replicationTaskIdentifier(String replicationTaskIdentifier) {
            this.replicationTaskIdentifier = replicationTaskIdentifier;
            return this;
        }

        public final String getReplicationTaskSettings() {
            return replicationTaskSettings;
        }

        public final void setReplicationTaskSettings(String replicationTaskSettings) {
            this.replicationTaskSettings = replicationTaskSettings;
        }

        @Override
        public final Builder replicationTaskSettings(String replicationTaskSettings) {
            this.replicationTaskSettings = replicationTaskSettings;
            return this;
        }

        public final String getSourceEndpointArn() {
            return sourceEndpointArn;
        }

        public final void setSourceEndpointArn(String sourceEndpointArn) {
            this.sourceEndpointArn = sourceEndpointArn;
        }

        @Override
        public final Builder sourceEndpointArn(String sourceEndpointArn) {
            this.sourceEndpointArn = sourceEndpointArn;
            return this;
        }

        public final String getTableMappings() {
            return tableMappings;
        }

        public final void setTableMappings(String tableMappings) {
            this.tableMappings = tableMappings;
        }

        @Override
        public final Builder tableMappings(String tableMappings) {
            this.tableMappings = tableMappings;
            return this;
        }

        public final String getTargetEndpointArn() {
            return targetEndpointArn;
        }

        public final void setTargetEndpointArn(String targetEndpointArn) {
            this.targetEndpointArn = targetEndpointArn;
        }

        @Override
        public final Builder targetEndpointArn(String targetEndpointArn) {
            this.targetEndpointArn = targetEndpointArn;
            return this;
        }

        public final String getTaskData() {
            return taskData;
        }

        public final void setTaskData(String taskData) {
            this.taskData = taskData;
        }

        @Override
        public final Builder taskData(String taskData) {
            this.taskData = taskData;
            return this;
        }

        @Override
        public AwsDmsReplicationTaskDetails build() {
            return new AwsDmsReplicationTaskDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
