/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the server-side encryption for the table.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsDynamoDbTableSseDescription implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsDynamoDbTableSseDescription.Builder, AwsDynamoDbTableSseDescription> {
    private static final SdkField<String> INACCESSIBLE_ENCRYPTION_DATE_TIME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("InaccessibleEncryptionDateTime")
            .getter(getter(AwsDynamoDbTableSseDescription::inaccessibleEncryptionDateTime))
            .setter(setter(Builder::inaccessibleEncryptionDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InaccessibleEncryptionDateTime")
                    .build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(AwsDynamoDbTableSseDescription::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> SSE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SseType").getter(getter(AwsDynamoDbTableSseDescription::sseType)).setter(setter(Builder::sseType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SseType").build()).build();

    private static final SdkField<String> KMS_MASTER_KEY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KmsMasterKeyArn").getter(getter(AwsDynamoDbTableSseDescription::kmsMasterKeyArn))
            .setter(setter(Builder::kmsMasterKeyArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsMasterKeyArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            INACCESSIBLE_ENCRYPTION_DATE_TIME_FIELD, STATUS_FIELD, SSE_TYPE_FIELD, KMS_MASTER_KEY_ARN_FIELD));

    private static final long serialVersionUID = 1L;

    private final String inaccessibleEncryptionDateTime;

    private final String status;

    private final String sseType;

    private final String kmsMasterKeyArn;

    private AwsDynamoDbTableSseDescription(BuilderImpl builder) {
        this.inaccessibleEncryptionDateTime = builder.inaccessibleEncryptionDateTime;
        this.status = builder.status;
        this.sseType = builder.sseType;
        this.kmsMasterKeyArn = builder.kmsMasterKeyArn;
    }

    /**
     * <p>
     * If the key is inaccessible, the date and time when DynamoDB detected that the key was inaccessible.
     * </p>
     * <p>
     * This field accepts only the specified formats. Timestamps can end with <code>Z</code> or
     * <code>("+" / "-") time-hour [":" time-minute]</code>. The time-secfrac after seconds is limited to a maximum of 9
     * digits. The offset is bounded by +/-18:00. Here are valid timestamp formats with examples:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>YYYY-MM-DDTHH:MM:SSZ</code> (for example, <code>2019-01-31T23:00:00Z</code>)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ</code> (for example, <code>2019-01-31T23:00:00.123456789Z</code>)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>YYYY-MM-DDTHH:MM:SS+HH:MM</code> (for example, <code>2024-01-04T15:25:10+17:59</code>)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>YYYY-MM-DDTHH:MM:SS-HHMM</code> (for example, <code>2024-01-04T15:25:10-1759</code>)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM</code> (for example, <code>2024-01-04T15:25:10.123456789+17:59</code>)
     * </p>
     * </li>
     * </ul>
     * 
     * @return If the key is inaccessible, the date and time when DynamoDB detected that the key was inaccessible.</p>
     *         <p>
     *         This field accepts only the specified formats. Timestamps can end with <code>Z</code> or
     *         <code>("+" / "-") time-hour [":" time-minute]</code>. The time-secfrac after seconds is limited to a
     *         maximum of 9 digits. The offset is bounded by +/-18:00. Here are valid timestamp formats with examples:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>YYYY-MM-DDTHH:MM:SSZ</code> (for example, <code>2019-01-31T23:00:00Z</code>)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ</code> (for example, <code>2019-01-31T23:00:00.123456789Z</code>)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>YYYY-MM-DDTHH:MM:SS+HH:MM</code> (for example, <code>2024-01-04T15:25:10+17:59</code>)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>YYYY-MM-DDTHH:MM:SS-HHMM</code> (for example, <code>2024-01-04T15:25:10-1759</code>)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM</code> (for example,
     *         <code>2024-01-04T15:25:10.123456789+17:59</code>)
     *         </p>
     *         </li>
     */
    public final String inaccessibleEncryptionDateTime() {
        return inaccessibleEncryptionDateTime;
    }

    /**
     * <p>
     * The status of the server-side encryption.
     * </p>
     * 
     * @return The status of the server-side encryption.
     */
    public final String status() {
        return status;
    }

    /**
     * <p>
     * The type of server-side encryption.
     * </p>
     * 
     * @return The type of server-side encryption.
     */
    public final String sseType() {
        return sseType;
    }

    /**
     * <p>
     * The ARN of the KMS key that is used for the KMS encryption.
     * </p>
     * 
     * @return The ARN of the KMS key that is used for the KMS encryption.
     */
    public final String kmsMasterKeyArn() {
        return kmsMasterKeyArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(inaccessibleEncryptionDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(sseType());
        hashCode = 31 * hashCode + Objects.hashCode(kmsMasterKeyArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsDynamoDbTableSseDescription)) {
            return false;
        }
        AwsDynamoDbTableSseDescription other = (AwsDynamoDbTableSseDescription) obj;
        return Objects.equals(inaccessibleEncryptionDateTime(), other.inaccessibleEncryptionDateTime())
                && Objects.equals(status(), other.status()) && Objects.equals(sseType(), other.sseType())
                && Objects.equals(kmsMasterKeyArn(), other.kmsMasterKeyArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsDynamoDbTableSseDescription")
                .add("InaccessibleEncryptionDateTime", inaccessibleEncryptionDateTime()).add("Status", status())
                .add("SseType", sseType()).add("KmsMasterKeyArn", kmsMasterKeyArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InaccessibleEncryptionDateTime":
            return Optional.ofNullable(clazz.cast(inaccessibleEncryptionDateTime()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        case "SseType":
            return Optional.ofNullable(clazz.cast(sseType()));
        case "KmsMasterKeyArn":
            return Optional.ofNullable(clazz.cast(kmsMasterKeyArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsDynamoDbTableSseDescription, T> g) {
        return obj -> g.apply((AwsDynamoDbTableSseDescription) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsDynamoDbTableSseDescription> {
        /**
         * <p>
         * If the key is inaccessible, the date and time when DynamoDB detected that the key was inaccessible.
         * </p>
         * <p>
         * This field accepts only the specified formats. Timestamps can end with <code>Z</code> or
         * <code>("+" / "-") time-hour [":" time-minute]</code>. The time-secfrac after seconds is limited to a maximum
         * of 9 digits. The offset is bounded by +/-18:00. Here are valid timestamp formats with examples:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>YYYY-MM-DDTHH:MM:SSZ</code> (for example, <code>2019-01-31T23:00:00Z</code>)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ</code> (for example, <code>2019-01-31T23:00:00.123456789Z</code>)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>YYYY-MM-DDTHH:MM:SS+HH:MM</code> (for example, <code>2024-01-04T15:25:10+17:59</code>)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>YYYY-MM-DDTHH:MM:SS-HHMM</code> (for example, <code>2024-01-04T15:25:10-1759</code>)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM</code> (for example,
         * <code>2024-01-04T15:25:10.123456789+17:59</code>)
         * </p>
         * </li>
         * </ul>
         * 
         * @param inaccessibleEncryptionDateTime
         *        If the key is inaccessible, the date and time when DynamoDB detected that the key was
         *        inaccessible.</p>
         *        <p>
         *        This field accepts only the specified formats. Timestamps can end with <code>Z</code> or
         *        <code>("+" / "-") time-hour [":" time-minute]</code>. The time-secfrac after seconds is limited to a
         *        maximum of 9 digits. The offset is bounded by +/-18:00. Here are valid timestamp formats with
         *        examples:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>YYYY-MM-DDTHH:MM:SSZ</code> (for example, <code>2019-01-31T23:00:00Z</code>)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ</code> (for example, <code>2019-01-31T23:00:00.123456789Z</code>)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>YYYY-MM-DDTHH:MM:SS+HH:MM</code> (for example, <code>2024-01-04T15:25:10+17:59</code>)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>YYYY-MM-DDTHH:MM:SS-HHMM</code> (for example, <code>2024-01-04T15:25:10-1759</code>)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM</code> (for example,
         *        <code>2024-01-04T15:25:10.123456789+17:59</code>)
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inaccessibleEncryptionDateTime(String inaccessibleEncryptionDateTime);

        /**
         * <p>
         * The status of the server-side encryption.
         * </p>
         * 
         * @param status
         *        The status of the server-side encryption.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * The type of server-side encryption.
         * </p>
         * 
         * @param sseType
         *        The type of server-side encryption.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sseType(String sseType);

        /**
         * <p>
         * The ARN of the KMS key that is used for the KMS encryption.
         * </p>
         * 
         * @param kmsMasterKeyArn
         *        The ARN of the KMS key that is used for the KMS encryption.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsMasterKeyArn(String kmsMasterKeyArn);
    }

    static final class BuilderImpl implements Builder {
        private String inaccessibleEncryptionDateTime;

        private String status;

        private String sseType;

        private String kmsMasterKeyArn;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsDynamoDbTableSseDescription model) {
            inaccessibleEncryptionDateTime(model.inaccessibleEncryptionDateTime);
            status(model.status);
            sseType(model.sseType);
            kmsMasterKeyArn(model.kmsMasterKeyArn);
        }

        public final String getInaccessibleEncryptionDateTime() {
            return inaccessibleEncryptionDateTime;
        }

        public final void setInaccessibleEncryptionDateTime(String inaccessibleEncryptionDateTime) {
            this.inaccessibleEncryptionDateTime = inaccessibleEncryptionDateTime;
        }

        @Override
        public final Builder inaccessibleEncryptionDateTime(String inaccessibleEncryptionDateTime) {
            this.inaccessibleEncryptionDateTime = inaccessibleEncryptionDateTime;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final String getSseType() {
            return sseType;
        }

        public final void setSseType(String sseType) {
            this.sseType = sseType;
        }

        @Override
        public final Builder sseType(String sseType) {
            this.sseType = sseType;
            return this;
        }

        public final String getKmsMasterKeyArn() {
            return kmsMasterKeyArn;
        }

        public final void setKmsMasterKeyArn(String kmsMasterKeyArn) {
            this.kmsMasterKeyArn = kmsMasterKeyArn;
        }

        @Override
        public final Builder kmsMasterKeyArn(String kmsMasterKeyArn) {
            this.kmsMasterKeyArn = kmsMasterKeyArn;
            return this;
        }

        @Override
        public AwsDynamoDbTableSseDescription build() {
            return new AwsDynamoDbTableSseDescription(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
