/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class AwsEc2ClientVpnEndpointAuthenticationOptionsListCopier {
    static List<AwsEc2ClientVpnEndpointAuthenticationOptionsDetails> copy(
            Collection<? extends AwsEc2ClientVpnEndpointAuthenticationOptionsDetails> awsEc2ClientVpnEndpointAuthenticationOptionsListParam) {
        List<AwsEc2ClientVpnEndpointAuthenticationOptionsDetails> list;
        if (awsEc2ClientVpnEndpointAuthenticationOptionsListParam == null
                || awsEc2ClientVpnEndpointAuthenticationOptionsListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<AwsEc2ClientVpnEndpointAuthenticationOptionsDetails> modifiableList = new ArrayList<>(
                    awsEc2ClientVpnEndpointAuthenticationOptionsListParam.size());
            awsEc2ClientVpnEndpointAuthenticationOptionsListParam.forEach(entry -> {
                modifiableList.add(entry);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<AwsEc2ClientVpnEndpointAuthenticationOptionsDetails> copyFromBuilder(
            Collection<? extends AwsEc2ClientVpnEndpointAuthenticationOptionsDetails.Builder> awsEc2ClientVpnEndpointAuthenticationOptionsListParam) {
        List<AwsEc2ClientVpnEndpointAuthenticationOptionsDetails> list;
        if (awsEc2ClientVpnEndpointAuthenticationOptionsListParam == null
                || awsEc2ClientVpnEndpointAuthenticationOptionsListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<AwsEc2ClientVpnEndpointAuthenticationOptionsDetails> modifiableList = new ArrayList<>(
                    awsEc2ClientVpnEndpointAuthenticationOptionsListParam.size());
            awsEc2ClientVpnEndpointAuthenticationOptionsListParam.forEach(entry -> {
                AwsEc2ClientVpnEndpointAuthenticationOptionsDetails member = entry == null ? null : entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<AwsEc2ClientVpnEndpointAuthenticationOptionsDetails.Builder> copyToBuilder(
            Collection<? extends AwsEc2ClientVpnEndpointAuthenticationOptionsDetails> awsEc2ClientVpnEndpointAuthenticationOptionsListParam) {
        List<AwsEc2ClientVpnEndpointAuthenticationOptionsDetails.Builder> list;
        if (awsEc2ClientVpnEndpointAuthenticationOptionsListParam == null
                || awsEc2ClientVpnEndpointAuthenticationOptionsListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<AwsEc2ClientVpnEndpointAuthenticationOptionsDetails.Builder> modifiableList = new ArrayList<>(
                    awsEc2ClientVpnEndpointAuthenticationOptionsListParam.size());
            awsEc2ClientVpnEndpointAuthenticationOptionsListParam.forEach(entry -> {
                AwsEc2ClientVpnEndpointAuthenticationOptionsDetails.Builder member = entry == null ? null : entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
